package cn.ibizlab.eam.webapi.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;
import javax.servlet.ServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import cn.ibizlab.eam.webapi.dto.*;
import cn.ibizlab.eam.webapi.mapping.*;
import cn.ibizlab.eam.core.eam_core.domain.EMEQSTopMoni;
import cn.ibizlab.eam.core.eam_core.service.IEMEQSTopMoniService;
import cn.ibizlab.eam.core.eam_core.filter.EMEQSTopMoniSearchContext;

@Slf4j
@Api(tags = {"EMEQSTopMoni" })
@RestController("WebApi-emeqstopmoni")
@RequestMapping("")
public class EMEQSTopMoniResource {

    @Autowired
    private IEMEQSTopMoniService emeqstopmoniService;

    @Autowired
    @Lazy
    public EMEQSTopMoniMapping emeqstopmoniMapping;

    public EMEQSTopMoniDTO permissionDTO=new EMEQSTopMoniDTO();

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMEQSTopMoni-CheckKey-all')")
    @ApiOperation(value = "CheckKey", tags = {"EMEQSTopMoni" },  notes = "CheckKey")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqstopmonis/checkkey")
    public ResponseEntity<Boolean> checkKey(@RequestBody EMEQSTopMoniDTO emeqstopmonidto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emeqstopmoniService.checkKey(emeqstopmoniMapping.toDomain(emeqstopmonidto)));
    }

    @PreAuthorize("hasPermission('','Create',{'Sql',this.emeqstopmoniMapping,#emeqstopmonidto})")
    @ApiOperation(value = "Create", tags = {"EMEQSTopMoni" },  notes = "Create")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqstopmonis")
    @Transactional
    public ResponseEntity<EMEQSTopMoniDTO> create(@RequestBody EMEQSTopMoniDTO emeqstopmonidto) {
        EMEQSTopMoni domain = emeqstopmoniMapping.toDomain(emeqstopmonidto);
		emeqstopmoniService.create(domain);
        EMEQSTopMoniDTO dto = emeqstopmoniMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Create',{'Sql',this.emeqstopmoniMapping,#emeqstopmonidtos})")
    @ApiOperation(value = "createBatch", tags = {"EMEQSTopMoni" },  notes = "createBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqstopmonis/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<EMEQSTopMoniDTO> emeqstopmonidtos) {
        emeqstopmoniService.createBatch(emeqstopmoniMapping.toDomain(emeqstopmonidtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMEQSTopMoni-GetDraft-all')")
    @ApiOperation(value = "GetDraft", tags = {"EMEQSTopMoni" },  notes = "GetDraft")
	@RequestMapping(method = RequestMethod.GET, value = "/emeqstopmonis/getdraft")
    public ResponseEntity<EMEQSTopMoniDTO> getDraft() {
        return ResponseEntity.status(HttpStatus.OK).body(emeqstopmoniMapping.toDto(emeqstopmoniService.getDraft(new EMEQSTopMoni())));
    }

    @PreAuthorize("hasPermission('','Save',{'Sql',this.emeqstopmoniMapping,#emeqstopmonidto})")
    @ApiOperation(value = "Save", tags = {"EMEQSTopMoni" },  notes = "Save")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqstopmonis/save")
    public ResponseEntity<Boolean> save(@RequestBody EMEQSTopMoniDTO emeqstopmonidto) {
        return ResponseEntity.status(HttpStatus.OK).body(emeqstopmoniService.save(emeqstopmoniMapping.toDomain(emeqstopmonidto)));
    }

    @PreAuthorize("hasPermission('Save',{'Sql',this.emeqstopmoniMapping,#emeqstopmonidtos})")
    @ApiOperation(value = "SaveBatch", tags = {"EMEQSTopMoni" },  notes = "SaveBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqstopmonis/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<EMEQSTopMoniDTO> emeqstopmonidtos) {
        emeqstopmoniService.saveBatch(emeqstopmoniMapping.toDomain(emeqstopmonidtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(#emeqstopmoni_id,'Remove',{'Sql',this.emeqstopmoniMapping,this.permissionDTO})")
    @ApiOperation(value = "Remove", tags = {"EMEQSTopMoni" },  notes = "Remove")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emeqstopmonis/{emeqstopmoni_id}")
    @Transactional
    public ResponseEntity<Boolean> remove(@PathVariable("emeqstopmoni_id") String emeqstopmoni_id) {
         return ResponseEntity.status(HttpStatus.OK).body(emeqstopmoniService.remove(emeqstopmoni_id));
    }

    @PreAuthorize("hasPermission('Remove',{'Sql',this.emeqstopmoniMapping,this.permissionDTO,#ids})")
    @ApiOperation(value = "RemoveBatch", tags = {"EMEQSTopMoni" },  notes = "RemoveBatch")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emeqstopmonis/batch")
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        emeqstopmoniService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(#emeqstopmoni_id,'Update',{'Sql',this.emeqstopmoniMapping,#emeqstopmonidto})")
    @ApiOperation(value = "Update", tags = {"EMEQSTopMoni" },  notes = "Update")
	@RequestMapping(method = RequestMethod.PUT, value = "/emeqstopmonis/{emeqstopmoni_id}")
    @Transactional
    public ResponseEntity<EMEQSTopMoniDTO> update(@PathVariable("emeqstopmoni_id") String emeqstopmoni_id, @RequestBody EMEQSTopMoniDTO emeqstopmonidto) {
		EMEQSTopMoni domain  = emeqstopmoniMapping.toDomain(emeqstopmonidto);
        domain .setEmeqstopmoniid(emeqstopmoni_id);
		emeqstopmoniService.update(domain );
		EMEQSTopMoniDTO dto = emeqstopmoniMapping.toDto(domain );
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Update',{'Sql',this.emeqstopmoniMapping,#emeqstopmonidtos})")
    @ApiOperation(value = "UpdateBatch", tags = {"EMEQSTopMoni" },  notes = "UpdateBatch")
	@RequestMapping(method = RequestMethod.PUT, value = "/emeqstopmonis/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<EMEQSTopMoniDTO> emeqstopmonidtos) {
        emeqstopmoniService.updateBatch(emeqstopmoniMapping.toDomain(emeqstopmonidtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(#emeqstopmoni_id,'Get',{'Sql',this.emeqstopmoniMapping,this.permissionDTO})")
    @ApiOperation(value = "Get", tags = {"EMEQSTopMoni" },  notes = "Get")
	@RequestMapping(method = RequestMethod.GET, value = "/emeqstopmonis/{emeqstopmoni_id}")
    public ResponseEntity<EMEQSTopMoniDTO> get(@PathVariable("emeqstopmoni_id") String emeqstopmoni_id) {
        EMEQSTopMoni domain = emeqstopmoniService.get(emeqstopmoni_id);
        EMEQSTopMoniDTO dto = emeqstopmoniMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMEQSTopMoni-Default-all')")
	@ApiOperation(value = "fetchDEFAULT", tags = {"EMEQSTopMoni" } ,notes = "fetchDEFAULT")
    @RequestMapping(method= RequestMethod.GET , value="/emeqstopmonis/fetchdefault")
	public ResponseEntity<List<EMEQSTopMoniDTO>> fetchDefault(EMEQSTopMoniSearchContext context) {
        Page<EMEQSTopMoni> domains = emeqstopmoniService.searchDefault(context) ;
        List<EMEQSTopMoniDTO> list = emeqstopmoniMapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMEQSTopMoni-Default-all')")
	@ApiOperation(value = "searchDEFAULT", tags = {"EMEQSTopMoni" } ,notes = "searchDEFAULT")
    @RequestMapping(method= RequestMethod.POST , value="/emeqstopmonis/searchdefault")
	public ResponseEntity<Page<EMEQSTopMoniDTO>> searchDefault(@RequestBody EMEQSTopMoniSearchContext context) {
        Page<EMEQSTopMoni> domains = emeqstopmoniService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emeqstopmoniMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
}
