package cn.ibizlab.eam.webapi.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;
import javax.servlet.ServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import cn.ibizlab.eam.webapi.dto.*;
import cn.ibizlab.eam.webapi.mapping.*;
import cn.ibizlab.eam.core.eam_core.domain.EMEQLCTMap;
import cn.ibizlab.eam.core.eam_core.service.IEMEQLCTMapService;
import cn.ibizlab.eam.core.eam_core.filter.EMEQLCTMapSearchContext;

@Slf4j
@Api(tags = {"EMEQLCTMap" })
@RestController("WebApi-emeqlctmap")
@RequestMapping("")
public class EMEQLCTMapResource {

    @Autowired
    private IEMEQLCTMapService emeqlctmapService;

    @Autowired
    @Lazy
    public EMEQLCTMapMapping emeqlctmapMapping;

    public EMEQLCTMapDTO permissionDTO=new EMEQLCTMapDTO();

    @PreAuthorize("hasPermission('','Save',{'Sql',this.emeqlctmapMapping,#emeqlctmapdto})")
    @ApiOperation(value = "Save", tags = {"EMEQLCTMap" },  notes = "Save")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqlctmaps/save")
    public ResponseEntity<Boolean> save(@RequestBody EMEQLCTMapDTO emeqlctmapdto) {
        return ResponseEntity.status(HttpStatus.OK).body(emeqlctmapService.save(emeqlctmapMapping.toDomain(emeqlctmapdto)));
    }

    @PreAuthorize("hasPermission('Save',{'Sql',this.emeqlctmapMapping,#emeqlctmapdtos})")
    @ApiOperation(value = "SaveBatch", tags = {"EMEQLCTMap" },  notes = "SaveBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqlctmaps/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<EMEQLCTMapDTO> emeqlctmapdtos) {
        emeqlctmapService.saveBatch(emeqlctmapMapping.toDomain(emeqlctmapdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(#emeqlctmap_id,'Update',{'Sql',this.emeqlctmapMapping,#emeqlctmapdto})")
    @ApiOperation(value = "Update", tags = {"EMEQLCTMap" },  notes = "Update")
	@RequestMapping(method = RequestMethod.PUT, value = "/emeqlctmaps/{emeqlctmap_id}")
    @Transactional
    public ResponseEntity<EMEQLCTMapDTO> update(@PathVariable("emeqlctmap_id") String emeqlctmap_id, @RequestBody EMEQLCTMapDTO emeqlctmapdto) {
		EMEQLCTMap domain  = emeqlctmapMapping.toDomain(emeqlctmapdto);
        domain .setEmeqlctmapid(emeqlctmap_id);
		emeqlctmapService.update(domain );
		EMEQLCTMapDTO dto = emeqlctmapMapping.toDto(domain );
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Update',{'Sql',this.emeqlctmapMapping,#emeqlctmapdtos})")
    @ApiOperation(value = "UpdateBatch", tags = {"EMEQLCTMap" },  notes = "UpdateBatch")
	@RequestMapping(method = RequestMethod.PUT, value = "/emeqlctmaps/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<EMEQLCTMapDTO> emeqlctmapdtos) {
        emeqlctmapService.updateBatch(emeqlctmapMapping.toDomain(emeqlctmapdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(#emeqlctmap_id,'Remove',{'Sql',this.emeqlctmapMapping,this.permissionDTO})")
    @ApiOperation(value = "Remove", tags = {"EMEQLCTMap" },  notes = "Remove")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emeqlctmaps/{emeqlctmap_id}")
    @Transactional
    public ResponseEntity<Boolean> remove(@PathVariable("emeqlctmap_id") String emeqlctmap_id) {
         return ResponseEntity.status(HttpStatus.OK).body(emeqlctmapService.remove(emeqlctmap_id));
    }

    @PreAuthorize("hasPermission('Remove',{'Sql',this.emeqlctmapMapping,this.permissionDTO,#ids})")
    @ApiOperation(value = "RemoveBatch", tags = {"EMEQLCTMap" },  notes = "RemoveBatch")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emeqlctmaps/batch")
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        emeqlctmapService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMEQLCTMap-CheckKey-all')")
    @ApiOperation(value = "CheckKey", tags = {"EMEQLCTMap" },  notes = "CheckKey")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqlctmaps/checkkey")
    public ResponseEntity<Boolean> checkKey(@RequestBody EMEQLCTMapDTO emeqlctmapdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emeqlctmapService.checkKey(emeqlctmapMapping.toDomain(emeqlctmapdto)));
    }

    @PreAuthorize("hasPermission(#emeqlctmap_id,'Get',{'Sql',this.emeqlctmapMapping,this.permissionDTO})")
    @ApiOperation(value = "Get", tags = {"EMEQLCTMap" },  notes = "Get")
	@RequestMapping(method = RequestMethod.GET, value = "/emeqlctmaps/{emeqlctmap_id}")
    public ResponseEntity<EMEQLCTMapDTO> get(@PathVariable("emeqlctmap_id") String emeqlctmap_id) {
        EMEQLCTMap domain = emeqlctmapService.get(emeqlctmap_id);
        EMEQLCTMapDTO dto = emeqlctmapMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMEQLCTMap-GetDraft-all')")
    @ApiOperation(value = "GetDraft", tags = {"EMEQLCTMap" },  notes = "GetDraft")
	@RequestMapping(method = RequestMethod.GET, value = "/emeqlctmaps/getdraft")
    public ResponseEntity<EMEQLCTMapDTO> getDraft() {
        return ResponseEntity.status(HttpStatus.OK).body(emeqlctmapMapping.toDto(emeqlctmapService.getDraft(new EMEQLCTMap())));
    }

    @PreAuthorize("hasPermission('','Create',{'Sql',this.emeqlctmapMapping,#emeqlctmapdto})")
    @ApiOperation(value = "Create", tags = {"EMEQLCTMap" },  notes = "Create")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqlctmaps")
    @Transactional
    public ResponseEntity<EMEQLCTMapDTO> create(@RequestBody EMEQLCTMapDTO emeqlctmapdto) {
        EMEQLCTMap domain = emeqlctmapMapping.toDomain(emeqlctmapdto);
		emeqlctmapService.create(domain);
        EMEQLCTMapDTO dto = emeqlctmapMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Create',{'Sql',this.emeqlctmapMapping,#emeqlctmapdtos})")
    @ApiOperation(value = "createBatch", tags = {"EMEQLCTMap" },  notes = "createBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqlctmaps/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<EMEQLCTMapDTO> emeqlctmapdtos) {
        emeqlctmapService.createBatch(emeqlctmapMapping.toDomain(emeqlctmapdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMEQLCTMap-Default-all')")
	@ApiOperation(value = "fetchDEFAULT", tags = {"EMEQLCTMap" } ,notes = "fetchDEFAULT")
    @RequestMapping(method= RequestMethod.GET , value="/emeqlctmaps/fetchdefault")
	public ResponseEntity<List<EMEQLCTMapDTO>> fetchDefault(EMEQLCTMapSearchContext context) {
        Page<EMEQLCTMap> domains = emeqlctmapService.searchDefault(context) ;
        List<EMEQLCTMapDTO> list = emeqlctmapMapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMEQLCTMap-Default-all')")
	@ApiOperation(value = "searchDEFAULT", tags = {"EMEQLCTMap" } ,notes = "searchDEFAULT")
    @RequestMapping(method= RequestMethod.POST , value="/emeqlctmaps/searchdefault")
	public ResponseEntity<Page<EMEQLCTMapDTO>> searchDefault(@RequestBody EMEQLCTMapSearchContext context) {
        Page<EMEQLCTMap> domains = emeqlctmapService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emeqlctmapMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
}
