package cn.ibizlab.eam.webapi.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;
import javax.servlet.ServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import cn.ibizlab.eam.webapi.dto.*;
import cn.ibizlab.eam.webapi.mapping.*;
import cn.ibizlab.eam.core.eam_core.domain.EMEITool;
import cn.ibizlab.eam.core.eam_core.service.IEMEIToolService;
import cn.ibizlab.eam.core.eam_core.filter.EMEIToolSearchContext;

@Slf4j
@Api(tags = {"EMEITool" })
@RestController("WebApi-emeitool")
@RequestMapping("")
public class EMEIToolResource {

    @Autowired
    private IEMEIToolService emeitoolService;

    @Autowired
    @Lazy
    public EMEIToolMapping emeitoolMapping;

    public EMEIToolDTO permissionDTO=new EMEIToolDTO();

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMEITool-CheckKey-all')")
    @ApiOperation(value = "CheckKey", tags = {"EMEITool" },  notes = "CheckKey")
	@RequestMapping(method = RequestMethod.POST, value = "/emeitools/checkkey")
    public ResponseEntity<Boolean> checkKey(@RequestBody EMEIToolDTO emeitooldto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emeitoolService.checkKey(emeitoolMapping.toDomain(emeitooldto)));
    }

    @PreAuthorize("hasPermission(#emeitool_id,'Get',{'Sql',this.emeitoolMapping,this.permissionDTO})")
    @ApiOperation(value = "Get", tags = {"EMEITool" },  notes = "Get")
	@RequestMapping(method = RequestMethod.GET, value = "/emeitools/{emeitool_id}")
    public ResponseEntity<EMEIToolDTO> get(@PathVariable("emeitool_id") String emeitool_id) {
        EMEITool domain = emeitoolService.get(emeitool_id);
        EMEIToolDTO dto = emeitoolMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('','Create',{'Sql',this.emeitoolMapping,#emeitooldto})")
    @ApiOperation(value = "Create", tags = {"EMEITool" },  notes = "Create")
	@RequestMapping(method = RequestMethod.POST, value = "/emeitools")
    @Transactional
    public ResponseEntity<EMEIToolDTO> create(@RequestBody EMEIToolDTO emeitooldto) {
        EMEITool domain = emeitoolMapping.toDomain(emeitooldto);
		emeitoolService.create(domain);
        EMEIToolDTO dto = emeitoolMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Create',{'Sql',this.emeitoolMapping,#emeitooldtos})")
    @ApiOperation(value = "createBatch", tags = {"EMEITool" },  notes = "createBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emeitools/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<EMEIToolDTO> emeitooldtos) {
        emeitoolService.createBatch(emeitoolMapping.toDomain(emeitooldtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(#emeitool_id,'Remove',{'Sql',this.emeitoolMapping,this.permissionDTO})")
    @ApiOperation(value = "Remove", tags = {"EMEITool" },  notes = "Remove")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emeitools/{emeitool_id}")
    @Transactional
    public ResponseEntity<Boolean> remove(@PathVariable("emeitool_id") String emeitool_id) {
         return ResponseEntity.status(HttpStatus.OK).body(emeitoolService.remove(emeitool_id));
    }

    @PreAuthorize("hasPermission('Remove',{'Sql',this.emeitoolMapping,this.permissionDTO,#ids})")
    @ApiOperation(value = "RemoveBatch", tags = {"EMEITool" },  notes = "RemoveBatch")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emeitools/batch")
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        emeitoolService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(#emeitool_id,'Update',{'Sql',this.emeitoolMapping,#emeitooldto})")
    @ApiOperation(value = "Update", tags = {"EMEITool" },  notes = "Update")
	@RequestMapping(method = RequestMethod.PUT, value = "/emeitools/{emeitool_id}")
    @Transactional
    public ResponseEntity<EMEIToolDTO> update(@PathVariable("emeitool_id") String emeitool_id, @RequestBody EMEIToolDTO emeitooldto) {
		EMEITool domain  = emeitoolMapping.toDomain(emeitooldto);
        domain .setEmeitoolid(emeitool_id);
		emeitoolService.update(domain );
		EMEIToolDTO dto = emeitoolMapping.toDto(domain );
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Update',{'Sql',this.emeitoolMapping,#emeitooldtos})")
    @ApiOperation(value = "UpdateBatch", tags = {"EMEITool" },  notes = "UpdateBatch")
	@RequestMapping(method = RequestMethod.PUT, value = "/emeitools/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<EMEIToolDTO> emeitooldtos) {
        emeitoolService.updateBatch(emeitoolMapping.toDomain(emeitooldtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission('','Save',{'Sql',this.emeitoolMapping,#emeitooldto})")
    @ApiOperation(value = "Save", tags = {"EMEITool" },  notes = "Save")
	@RequestMapping(method = RequestMethod.POST, value = "/emeitools/save")
    public ResponseEntity<Boolean> save(@RequestBody EMEIToolDTO emeitooldto) {
        return ResponseEntity.status(HttpStatus.OK).body(emeitoolService.save(emeitoolMapping.toDomain(emeitooldto)));
    }

    @PreAuthorize("hasPermission('Save',{'Sql',this.emeitoolMapping,#emeitooldtos})")
    @ApiOperation(value = "SaveBatch", tags = {"EMEITool" },  notes = "SaveBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emeitools/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<EMEIToolDTO> emeitooldtos) {
        emeitoolService.saveBatch(emeitoolMapping.toDomain(emeitooldtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMEITool-GetDraft-all')")
    @ApiOperation(value = "GetDraft", tags = {"EMEITool" },  notes = "GetDraft")
	@RequestMapping(method = RequestMethod.GET, value = "/emeitools/getdraft")
    public ResponseEntity<EMEIToolDTO> getDraft() {
        return ResponseEntity.status(HttpStatus.OK).body(emeitoolMapping.toDto(emeitoolService.getDraft(new EMEITool())));
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMEITool-Default-all')")
	@ApiOperation(value = "fetchDEFAULT", tags = {"EMEITool" } ,notes = "fetchDEFAULT")
    @RequestMapping(method= RequestMethod.GET , value="/emeitools/fetchdefault")
	public ResponseEntity<List<EMEIToolDTO>> fetchDefault(EMEIToolSearchContext context) {
        Page<EMEITool> domains = emeitoolService.searchDefault(context) ;
        List<EMEIToolDTO> list = emeitoolMapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMEITool-Default-all')")
	@ApiOperation(value = "searchDEFAULT", tags = {"EMEITool" } ,notes = "searchDEFAULT")
    @RequestMapping(method= RequestMethod.POST , value="/emeitools/searchdefault")
	public ResponseEntity<Page<EMEIToolDTO>> searchDefault(@RequestBody EMEIToolSearchContext context) {
        Page<EMEITool> domains = emeitoolService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emeitoolMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
}
