package cn.ibizlab.eam.webapi.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;
import javax.servlet.ServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import cn.ibizlab.eam.webapi.dto.*;
import cn.ibizlab.eam.webapi.mapping.*;
import cn.ibizlab.eam.core.eam_core.domain.EMEIBatteryFill;
import cn.ibizlab.eam.core.eam_core.service.IEMEIBatteryFillService;
import cn.ibizlab.eam.core.eam_core.filter.EMEIBatteryFillSearchContext;

@Slf4j
@Api(tags = {"EMEIBatteryFill" })
@RestController("WebApi-emeibatteryfill")
@RequestMapping("")
public class EMEIBatteryFillResource {

    @Autowired
    private IEMEIBatteryFillService emeibatteryfillService;

    @Autowired
    @Lazy
    public EMEIBatteryFillMapping emeibatteryfillMapping;

    public EMEIBatteryFillDTO permissionDTO=new EMEIBatteryFillDTO();

    @PreAuthorize("hasPermission('','Save',{'Sql',this.emeibatteryfillMapping,#emeibatteryfilldto})")
    @ApiOperation(value = "Save", tags = {"EMEIBatteryFill" },  notes = "Save")
	@RequestMapping(method = RequestMethod.POST, value = "/emeibatteryfills/save")
    public ResponseEntity<Boolean> save(@RequestBody EMEIBatteryFillDTO emeibatteryfilldto) {
        return ResponseEntity.status(HttpStatus.OK).body(emeibatteryfillService.save(emeibatteryfillMapping.toDomain(emeibatteryfilldto)));
    }

    @PreAuthorize("hasPermission('Save',{'Sql',this.emeibatteryfillMapping,#emeibatteryfilldtos})")
    @ApiOperation(value = "SaveBatch", tags = {"EMEIBatteryFill" },  notes = "SaveBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emeibatteryfills/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<EMEIBatteryFillDTO> emeibatteryfilldtos) {
        emeibatteryfillService.saveBatch(emeibatteryfillMapping.toDomain(emeibatteryfilldtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMEIBatteryFill-GetDraft-all')")
    @ApiOperation(value = "GetDraft", tags = {"EMEIBatteryFill" },  notes = "GetDraft")
	@RequestMapping(method = RequestMethod.GET, value = "/emeibatteryfills/getdraft")
    public ResponseEntity<EMEIBatteryFillDTO> getDraft() {
        return ResponseEntity.status(HttpStatus.OK).body(emeibatteryfillMapping.toDto(emeibatteryfillService.getDraft(new EMEIBatteryFill())));
    }

    @PreAuthorize("hasPermission('','Create',{'Sql',this.emeibatteryfillMapping,#emeibatteryfilldto})")
    @ApiOperation(value = "Create", tags = {"EMEIBatteryFill" },  notes = "Create")
	@RequestMapping(method = RequestMethod.POST, value = "/emeibatteryfills")
    @Transactional
    public ResponseEntity<EMEIBatteryFillDTO> create(@RequestBody EMEIBatteryFillDTO emeibatteryfilldto) {
        EMEIBatteryFill domain = emeibatteryfillMapping.toDomain(emeibatteryfilldto);
		emeibatteryfillService.create(domain);
        EMEIBatteryFillDTO dto = emeibatteryfillMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Create',{'Sql',this.emeibatteryfillMapping,#emeibatteryfilldtos})")
    @ApiOperation(value = "createBatch", tags = {"EMEIBatteryFill" },  notes = "createBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emeibatteryfills/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<EMEIBatteryFillDTO> emeibatteryfilldtos) {
        emeibatteryfillService.createBatch(emeibatteryfillMapping.toDomain(emeibatteryfilldtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(#emeibatteryfill_id,'Get',{'Sql',this.emeibatteryfillMapping,this.permissionDTO})")
    @ApiOperation(value = "Get", tags = {"EMEIBatteryFill" },  notes = "Get")
	@RequestMapping(method = RequestMethod.GET, value = "/emeibatteryfills/{emeibatteryfill_id}")
    public ResponseEntity<EMEIBatteryFillDTO> get(@PathVariable("emeibatteryfill_id") String emeibatteryfill_id) {
        EMEIBatteryFill domain = emeibatteryfillService.get(emeibatteryfill_id);
        EMEIBatteryFillDTO dto = emeibatteryfillMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(#emeibatteryfill_id,'Remove',{'Sql',this.emeibatteryfillMapping,this.permissionDTO})")
    @ApiOperation(value = "Remove", tags = {"EMEIBatteryFill" },  notes = "Remove")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emeibatteryfills/{emeibatteryfill_id}")
    @Transactional
    public ResponseEntity<Boolean> remove(@PathVariable("emeibatteryfill_id") String emeibatteryfill_id) {
         return ResponseEntity.status(HttpStatus.OK).body(emeibatteryfillService.remove(emeibatteryfill_id));
    }

    @PreAuthorize("hasPermission('Remove',{'Sql',this.emeibatteryfillMapping,this.permissionDTO,#ids})")
    @ApiOperation(value = "RemoveBatch", tags = {"EMEIBatteryFill" },  notes = "RemoveBatch")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emeibatteryfills/batch")
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        emeibatteryfillService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMEIBatteryFill-CheckKey-all')")
    @ApiOperation(value = "CheckKey", tags = {"EMEIBatteryFill" },  notes = "CheckKey")
	@RequestMapping(method = RequestMethod.POST, value = "/emeibatteryfills/checkkey")
    public ResponseEntity<Boolean> checkKey(@RequestBody EMEIBatteryFillDTO emeibatteryfilldto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emeibatteryfillService.checkKey(emeibatteryfillMapping.toDomain(emeibatteryfilldto)));
    }

    @PreAuthorize("hasPermission(#emeibatteryfill_id,'Update',{'Sql',this.emeibatteryfillMapping,#emeibatteryfilldto})")
    @ApiOperation(value = "Update", tags = {"EMEIBatteryFill" },  notes = "Update")
	@RequestMapping(method = RequestMethod.PUT, value = "/emeibatteryfills/{emeibatteryfill_id}")
    @Transactional
    public ResponseEntity<EMEIBatteryFillDTO> update(@PathVariable("emeibatteryfill_id") String emeibatteryfill_id, @RequestBody EMEIBatteryFillDTO emeibatteryfilldto) {
		EMEIBatteryFill domain  = emeibatteryfillMapping.toDomain(emeibatteryfilldto);
        domain .setEmeibatteryfillid(emeibatteryfill_id);
		emeibatteryfillService.update(domain );
		EMEIBatteryFillDTO dto = emeibatteryfillMapping.toDto(domain );
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Update',{'Sql',this.emeibatteryfillMapping,#emeibatteryfilldtos})")
    @ApiOperation(value = "UpdateBatch", tags = {"EMEIBatteryFill" },  notes = "UpdateBatch")
	@RequestMapping(method = RequestMethod.PUT, value = "/emeibatteryfills/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<EMEIBatteryFillDTO> emeibatteryfilldtos) {
        emeibatteryfillService.updateBatch(emeibatteryfillMapping.toDomain(emeibatteryfilldtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMEIBatteryFill-Default-all')")
	@ApiOperation(value = "fetchDEFAULT", tags = {"EMEIBatteryFill" } ,notes = "fetchDEFAULT")
    @RequestMapping(method= RequestMethod.GET , value="/emeibatteryfills/fetchdefault")
	public ResponseEntity<List<EMEIBatteryFillDTO>> fetchDefault(EMEIBatteryFillSearchContext context) {
        Page<EMEIBatteryFill> domains = emeibatteryfillService.searchDefault(context) ;
        List<EMEIBatteryFillDTO> list = emeibatteryfillMapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMEIBatteryFill-Default-all')")
	@ApiOperation(value = "searchDEFAULT", tags = {"EMEIBatteryFill" } ,notes = "searchDEFAULT")
    @RequestMapping(method= RequestMethod.POST , value="/emeibatteryfills/searchdefault")
	public ResponseEntity<Page<EMEIBatteryFillDTO>> searchDefault(@RequestBody EMEIBatteryFillSearchContext context) {
        Page<EMEIBatteryFill> domains = emeibatteryfillService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emeibatteryfillMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
}
