package cn.ibizlab.eam.webapi.dto;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.math.BigInteger;
import java.util.Map;
import java.util.HashMap;
import java.io.Serializable;
import java.math.BigDecimal;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.alibaba.fastjson.annotation.JSONField;
import cn.ibizlab.eam.util.domain.DTOBase;
import lombok.Data;

/**
 * 服务DTO对象[EMPlanCDTDTO]
 */
@Data
public class EMPlanCDTDTO extends DTOBase implements Serializable {

	private static final long serialVersionUID = 1L;

    /**
     * 属性 [EMPLANCDTID]
     *
     */
    @JSONField(name = "emplancdtid")
    @JsonProperty("emplancdtid")
    private String emplancdtid;

    /**
     * 属性 [CREATEMAN]
     *
     */
    @JSONField(name = "createman")
    @JsonProperty("createman")
    private String createman;

    /**
     * 属性 [CREATEDATE]
     *
     */
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
    @JSONField(name = "createdate" , format="yyyy-MM-dd HH:mm:ss")
    @JsonProperty("createdate")
    private Timestamp createdate;

    /**
     * 属性 [ENABLE]
     *
     */
    @JSONField(name = "enable")
    @JsonProperty("enable")
    private Integer enable;

    /**
     * 属性 [TRIGGERVAL]
     *
     */
    @JSONField(name = "triggerval")
    @JsonProperty("triggerval")
    private String triggerval;

    /**
     * 属性 [DPVALTYPE]
     *
     */
    @JSONField(name = "dpvaltype")
    @JsonProperty("dpvaltype")
    private String dpvaltype;

    /**
     * 属性 [LASTVAL]
     *
     */
    @JSONField(name = "lastval")
    @JsonProperty("lastval")
    private String lastval;

    /**
     * 属性 [NOWVAL]
     *
     */
    @JSONField(name = "nowval")
    @JsonProperty("nowval")
    private String nowval;

    /**
     * 属性 [DESCRIPTION]
     *
     */
    @JSONField(name = "description")
    @JsonProperty("description")
    private String description;

    /**
     * 属性 [ORGID]
     *
     */
    @JSONField(name = "orgid")
    @JsonProperty("orgid")
    private String orgid;

    /**
     * 属性 [UPDATEDATE]
     *
     */
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
    @JSONField(name = "updatedate" , format="yyyy-MM-dd HH:mm:ss")
    @JsonProperty("updatedate")
    private Timestamp updatedate;

    /**
     * 属性 [UPDATEMAN]
     *
     */
    @JSONField(name = "updateman")
    @JsonProperty("updateman")
    private String updateman;

    /**
     * 属性 [TRIGGERDP]
     *
     */
    @JSONField(name = "triggerdp")
    @JsonProperty("triggerdp")
    private String triggerdp;

    /**
     * 属性 [EMPLANCDTNAME]
     *
     */
    @JSONField(name = "emplancdtname")
    @JsonProperty("emplancdtname")
    private String emplancdtname;

    /**
     * 属性 [DPTYPE]
     *
     */
    @JSONField(name = "dptype")
    @JsonProperty("dptype")
    private String dptype;

    /**
     * 属性 [OBJNAME]
     *
     */
    @JSONField(name = "objname")
    @JsonProperty("objname")
    private String objname;

    /**
     * 属性 [DPNAME]
     *
     */
    @JSONField(name = "dpname")
    @JsonProperty("dpname")
    private String dpname;

    /**
     * 属性 [PLANNAME]
     *
     */
    @JSONField(name = "planname")
    @JsonProperty("planname")
    private String planname;

    /**
     * 属性 [EQUIPNAME]
     *
     */
    @JSONField(name = "equipname")
    @JsonProperty("equipname")
    private String equipname;

    /**
     * 属性 [DPID]
     *
     */
    @JSONField(name = "dpid")
    @JsonProperty("dpid")
    private String dpid;

    /**
     * 属性 [PLANID]
     *
     */
    @JSONField(name = "planid")
    @JsonProperty("planid")
    private String planid;

    /**
     * 属性 [EQUIPID]
     *
     */
    @JSONField(name = "equipid")
    @JsonProperty("equipid")
    private String equipid;

    /**
     * 属性 [OBJID]
     *
     */
    @JSONField(name = "objid")
    @JsonProperty("objid")
    private String objid;


    /**
     * 设置 [TRIGGERVAL]
     */
    public void setTriggerval(String  triggerval){
        this.triggerval = triggerval ;
        this.modify("triggerval",triggerval);
    }

    /**
     * 设置 [DPVALTYPE]
     */
    public void setDpvaltype(String  dpvaltype){
        this.dpvaltype = dpvaltype ;
        this.modify("dpvaltype",dpvaltype);
    }

    /**
     * 设置 [LASTVAL]
     */
    public void setLastval(String  lastval){
        this.lastval = lastval ;
        this.modify("lastval",lastval);
    }

    /**
     * 设置 [NOWVAL]
     */
    public void setNowval(String  nowval){
        this.nowval = nowval ;
        this.modify("nowval",nowval);
    }

    /**
     * 设置 [DESCRIPTION]
     */
    public void setDescription(String  description){
        this.description = description ;
        this.modify("description",description);
    }

    /**
     * 设置 [TRIGGERDP]
     */
    public void setTriggerdp(String  triggerdp){
        this.triggerdp = triggerdp ;
        this.modify("triggerdp",triggerdp);
    }

    /**
     * 设置 [EMPLANCDTNAME]
     */
    public void setEmplancdtname(String  emplancdtname){
        this.emplancdtname = emplancdtname ;
        this.modify("emplancdtname",emplancdtname);
    }

    /**
     * 设置 [DPID]
     */
    public void setDpid(String  dpid){
        this.dpid = dpid ;
        this.modify("dpid",dpid);
    }

    /**
     * 设置 [PLANID]
     */
    public void setPlanid(String  planid){
        this.planid = planid ;
        this.modify("planid",planid);
    }

    /**
     * 设置 [EQUIPID]
     */
    public void setEquipid(String  equipid){
        this.equipid = equipid ;
        this.modify("equipid",equipid);
    }

    /**
     * 设置 [OBJID]
     */
    public void setObjid(String  objid){
        this.objid = objid ;
        this.modify("objid",objid);
    }


}

