package cn.ibizlab.eam.webapi.dto;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.math.BigInteger;
import java.util.Map;
import java.util.HashMap;
import java.io.Serializable;
import java.math.BigDecimal;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.alibaba.fastjson.annotation.JSONField;
import cn.ibizlab.eam.util.domain.DTOBase;
import lombok.Data;

/**
 * 服务DTO对象[EMEQTypeDTO]
 */
@Data
public class EMEQTypeDTO extends DTOBase implements Serializable {

	private static final long serialVersionUID = 1L;

    /**
     * 属性 [EQTYPEGROUP]
     *
     */
    @JSONField(name = "eqtypegroup")
    @JsonProperty("eqtypegroup")
    private String eqtypegroup;

    /**
     * 属性 [CREATEMAN]
     *
     */
    @JSONField(name = "createman")
    @JsonProperty("createman")
    private String createman;

    /**
     * 属性 [EQSTATEINFO]
     *
     */
    @JSONField(name = "eqstateinfo")
    @JsonProperty("eqstateinfo")
    private String eqstateinfo;

    /**
     * 属性 [UPDATEDATE]
     *
     */
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
    @JSONField(name = "updatedate" , format="yyyy-MM-dd HH:mm:ss")
    @JsonProperty("updatedate")
    private Timestamp updatedate;

    /**
     * 属性 [EQTYPECODE]
     *
     */
    @JSONField(name = "eqtypecode")
    @JsonProperty("eqtypecode")
    private String eqtypecode;

    /**
     * 属性 [STYPE]
     *
     */
    @JSONField(name = "stype")
    @JsonProperty("stype")
    private String stype;

    /**
     * 属性 [EQTYPEINFO]
     *
     */
    @JSONField(name = "eqtypeinfo")
    @JsonProperty("eqtypeinfo")
    private String eqtypeinfo;

    /**
     * 属性 [ARG]
     *
     */
    @JSONField(name = "arg")
    @JsonProperty("arg")
    private String arg;

    /**
     * 属性 [ORGID]
     *
     */
    @JSONField(name = "orgid")
    @JsonProperty("orgid")
    private String orgid;

    /**
     * 属性 [EMEQTYPEID]
     *
     */
    @JSONField(name = "emeqtypeid")
    @JsonProperty("emeqtypeid")
    private String emeqtypeid;

    /**
     * 属性 [CREATEDATE]
     *
     */
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
    @JSONField(name = "createdate" , format="yyyy-MM-dd HH:mm:ss")
    @JsonProperty("createdate")
    private Timestamp createdate;

    /**
     * 属性 [UPDATEMAN]
     *
     */
    @JSONField(name = "updateman")
    @JsonProperty("updateman")
    private String updateman;

    /**
     * 属性 [SNAME]
     *
     */
    @JSONField(name = "sname")
    @JsonProperty("sname")
    private String sname;

    /**
     * 属性 [ENABLE]
     *
     */
    @JSONField(name = "enable")
    @JsonProperty("enable")
    private Integer enable;

    /**
     * 属性 [EMEQTYPENAME]
     *
     */
    @JSONField(name = "emeqtypename")
    @JsonProperty("emeqtypename")
    private String emeqtypename;

    /**
     * 属性 [DESCRIPTION]
     *
     */
    @JSONField(name = "description")
    @JsonProperty("description")
    private String description;

    /**
     * 属性 [EQTYPEPCODE]
     *
     */
    @JSONField(name = "eqtypepcode")
    @JsonProperty("eqtypepcode")
    private String eqtypepcode;

    /**
     * 属性 [EQTYPEPNAME]
     *
     */
    @JSONField(name = "eqtypepname")
    @JsonProperty("eqtypepname")
    private String eqtypepname;

    /**
     * 属性 [EQTYPEPID]
     *
     */
    @JSONField(name = "eqtypepid")
    @JsonProperty("eqtypepid")
    private String eqtypepid;


    /**
     * 设置 [EQTYPEGROUP]
     */
    public void setEqtypegroup(String  eqtypegroup){
        this.eqtypegroup = eqtypegroup ;
        this.modify("eqtypegroup",eqtypegroup);
    }

    /**
     * 设置 [EQTYPECODE]
     */
    public void setEqtypecode(String  eqtypecode){
        this.eqtypecode = eqtypecode ;
        this.modify("eqtypecode",eqtypecode);
    }

    /**
     * 设置 [STYPE]
     */
    public void setStype(String  stype){
        this.stype = stype ;
        this.modify("stype",stype);
    }

    /**
     * 设置 [ARG]
     */
    public void setArg(String  arg){
        this.arg = arg ;
        this.modify("arg",arg);
    }

    /**
     * 设置 [SNAME]
     */
    public void setSname(String  sname){
        this.sname = sname ;
        this.modify("sname",sname);
    }

    /**
     * 设置 [EMEQTYPENAME]
     */
    public void setEmeqtypename(String  emeqtypename){
        this.emeqtypename = emeqtypename ;
        this.modify("emeqtypename",emeqtypename);
    }

    /**
     * 设置 [DESCRIPTION]
     */
    public void setDescription(String  description){
        this.description = description ;
        this.modify("description",description);
    }

    /**
     * 设置 [EQTYPEPID]
     */
    public void setEqtypepid(String  eqtypepid){
        this.eqtypepid = eqtypepid ;
        this.modify("eqtypepid",eqtypepid);
    }


}

