package cn.ibizlab.eam.webapi.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;
import javax.servlet.ServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import cn.ibizlab.eam.webapi.dto.*;
import cn.ibizlab.eam.webapi.mapping.*;
import cn.ibizlab.eam.core.eam_core.domain.EMService;
import cn.ibizlab.eam.core.eam_core.service.IEMServiceService;
import cn.ibizlab.eam.core.eam_core.filter.EMServiceSearchContext;

@Slf4j
@Api(tags = {"EMService" })
@RestController("WebApi-emservice")
@RequestMapping("")
public class EMServiceResource {

    @Autowired
    private IEMServiceService emserviceService;

    @Autowired
    @Lazy
    public EMServiceMapping emserviceMapping;

    public EMServiceDTO permissionDTO=new EMServiceDTO();

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMService-GetDraft-all')")
    @ApiOperation(value = "GetDraft", tags = {"EMService" },  notes = "GetDraft")
	@RequestMapping(method = RequestMethod.GET, value = "/emservices/getdraft")
    public ResponseEntity<EMServiceDTO> getDraft() {
        return ResponseEntity.status(HttpStatus.OK).body(emserviceMapping.toDto(emserviceService.getDraft(new EMService())));
    }

    @PreAuthorize("hasPermission('','Save',{'Sql',this.emserviceMapping,#emservicedto})")
    @ApiOperation(value = "Save", tags = {"EMService" },  notes = "Save")
	@RequestMapping(method = RequestMethod.POST, value = "/emservices/save")
    public ResponseEntity<Boolean> save(@RequestBody EMServiceDTO emservicedto) {
        return ResponseEntity.status(HttpStatus.OK).body(emserviceService.save(emserviceMapping.toDomain(emservicedto)));
    }

    @PreAuthorize("hasPermission('Save',{'Sql',this.emserviceMapping,#emservicedtos})")
    @ApiOperation(value = "SaveBatch", tags = {"EMService" },  notes = "SaveBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emservices/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<EMServiceDTO> emservicedtos) {
        emserviceService.saveBatch(emserviceMapping.toDomain(emservicedtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission('','Create',{'Sql',this.emserviceMapping,#emservicedto})")
    @ApiOperation(value = "Create", tags = {"EMService" },  notes = "Create")
	@RequestMapping(method = RequestMethod.POST, value = "/emservices")
    @Transactional
    public ResponseEntity<EMServiceDTO> create(@RequestBody EMServiceDTO emservicedto) {
        EMService domain = emserviceMapping.toDomain(emservicedto);
		emserviceService.create(domain);
        EMServiceDTO dto = emserviceMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Create',{'Sql',this.emserviceMapping,#emservicedtos})")
    @ApiOperation(value = "createBatch", tags = {"EMService" },  notes = "createBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emservices/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<EMServiceDTO> emservicedtos) {
        emserviceService.createBatch(emserviceMapping.toDomain(emservicedtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(#emservice_id,'Update',{'Sql',this.emserviceMapping,#emservicedto})")
    @ApiOperation(value = "Update", tags = {"EMService" },  notes = "Update")
	@RequestMapping(method = RequestMethod.PUT, value = "/emservices/{emservice_id}")
    @Transactional
    public ResponseEntity<EMServiceDTO> update(@PathVariable("emservice_id") String emservice_id, @RequestBody EMServiceDTO emservicedto) {
		EMService domain  = emserviceMapping.toDomain(emservicedto);
        domain .setEmserviceid(emservice_id);
		emserviceService.update(domain );
		EMServiceDTO dto = emserviceMapping.toDto(domain );
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Update',{'Sql',this.emserviceMapping,#emservicedtos})")
    @ApiOperation(value = "UpdateBatch", tags = {"EMService" },  notes = "UpdateBatch")
	@RequestMapping(method = RequestMethod.PUT, value = "/emservices/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<EMServiceDTO> emservicedtos) {
        emserviceService.updateBatch(emserviceMapping.toDomain(emservicedtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(#emservice_id,'Get',{'Sql',this.emserviceMapping,this.permissionDTO})")
    @ApiOperation(value = "Get", tags = {"EMService" },  notes = "Get")
	@RequestMapping(method = RequestMethod.GET, value = "/emservices/{emservice_id}")
    public ResponseEntity<EMServiceDTO> get(@PathVariable("emservice_id") String emservice_id) {
        EMService domain = emserviceService.get(emservice_id);
        EMServiceDTO dto = emserviceMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(#emservice_id,'Remove',{'Sql',this.emserviceMapping,this.permissionDTO})")
    @ApiOperation(value = "Remove", tags = {"EMService" },  notes = "Remove")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emservices/{emservice_id}")
    @Transactional
    public ResponseEntity<Boolean> remove(@PathVariable("emservice_id") String emservice_id) {
         return ResponseEntity.status(HttpStatus.OK).body(emserviceService.remove(emservice_id));
    }

    @PreAuthorize("hasPermission('Remove',{'Sql',this.emserviceMapping,this.permissionDTO,#ids})")
    @ApiOperation(value = "RemoveBatch", tags = {"EMService" },  notes = "RemoveBatch")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emservices/batch")
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        emserviceService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMService-CheckKey-all')")
    @ApiOperation(value = "CheckKey", tags = {"EMService" },  notes = "CheckKey")
	@RequestMapping(method = RequestMethod.POST, value = "/emservices/checkkey")
    public ResponseEntity<Boolean> checkKey(@RequestBody EMServiceDTO emservicedto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emserviceService.checkKey(emserviceMapping.toDomain(emservicedto)));
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMService-Default-all')")
	@ApiOperation(value = "fetchDEFAULT", tags = {"EMService" } ,notes = "fetchDEFAULT")
    @RequestMapping(method= RequestMethod.GET , value="/emservices/fetchdefault")
	public ResponseEntity<List<EMServiceDTO>> fetchDefault(EMServiceSearchContext context) {
        Page<EMService> domains = emserviceService.searchDefault(context) ;
        List<EMServiceDTO> list = emserviceMapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMService-Default-all')")
	@ApiOperation(value = "searchDEFAULT", tags = {"EMService" } ,notes = "searchDEFAULT")
    @RequestMapping(method= RequestMethod.POST , value="/emservices/searchdefault")
	public ResponseEntity<Page<EMServiceDTO>> searchDefault(@RequestBody EMServiceSearchContext context) {
        Page<EMService> domains = emserviceService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emserviceMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
}
