package cn.ibizlab.eam.webapi.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;
import javax.servlet.ServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import cn.ibizlab.eam.webapi.dto.*;
import cn.ibizlab.eam.webapi.mapping.*;
import cn.ibizlab.eam.core.eam_core.domain.EMJYJL;
import cn.ibizlab.eam.core.eam_core.service.IEMJYJLService;
import cn.ibizlab.eam.core.eam_core.filter.EMJYJLSearchContext;

@Slf4j
@Api(tags = {"EMJYJL" })
@RestController("WebApi-emjyjl")
@RequestMapping("")
public class EMJYJLResource {

    @Autowired
    private IEMJYJLService emjyjlService;

    @Autowired
    @Lazy
    public EMJYJLMapping emjyjlMapping;

    public EMJYJLDTO permissionDTO=new EMJYJLDTO();

    @PreAuthorize("hasPermission('','Save',{'Sql',this.emjyjlMapping,#emjyjldto})")
    @ApiOperation(value = "Save", tags = {"EMJYJL" },  notes = "Save")
	@RequestMapping(method = RequestMethod.POST, value = "/emjyjls/save")
    public ResponseEntity<Boolean> save(@RequestBody EMJYJLDTO emjyjldto) {
        return ResponseEntity.status(HttpStatus.OK).body(emjyjlService.save(emjyjlMapping.toDomain(emjyjldto)));
    }

    @PreAuthorize("hasPermission('Save',{'Sql',this.emjyjlMapping,#emjyjldtos})")
    @ApiOperation(value = "SaveBatch", tags = {"EMJYJL" },  notes = "SaveBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emjyjls/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<EMJYJLDTO> emjyjldtos) {
        emjyjlService.saveBatch(emjyjlMapping.toDomain(emjyjldtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMJYJL-GetDraft-all')")
    @ApiOperation(value = "GetDraft", tags = {"EMJYJL" },  notes = "GetDraft")
	@RequestMapping(method = RequestMethod.GET, value = "/emjyjls/getdraft")
    public ResponseEntity<EMJYJLDTO> getDraft() {
        return ResponseEntity.status(HttpStatus.OK).body(emjyjlMapping.toDto(emjyjlService.getDraft(new EMJYJL())));
    }

    @PreAuthorize("hasPermission(#emjyjl_id,'Update',{'Sql',this.emjyjlMapping,#emjyjldto})")
    @ApiOperation(value = "Update", tags = {"EMJYJL" },  notes = "Update")
	@RequestMapping(method = RequestMethod.PUT, value = "/emjyjls/{emjyjl_id}")
    @Transactional
    public ResponseEntity<EMJYJLDTO> update(@PathVariable("emjyjl_id") String emjyjl_id, @RequestBody EMJYJLDTO emjyjldto) {
		EMJYJL domain  = emjyjlMapping.toDomain(emjyjldto);
        domain .setEmjyjlid(emjyjl_id);
		emjyjlService.update(domain );
		EMJYJLDTO dto = emjyjlMapping.toDto(domain );
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Update',{'Sql',this.emjyjlMapping,#emjyjldtos})")
    @ApiOperation(value = "UpdateBatch", tags = {"EMJYJL" },  notes = "UpdateBatch")
	@RequestMapping(method = RequestMethod.PUT, value = "/emjyjls/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<EMJYJLDTO> emjyjldtos) {
        emjyjlService.updateBatch(emjyjlMapping.toDomain(emjyjldtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(#emjyjl_id,'Get',{'Sql',this.emjyjlMapping,this.permissionDTO})")
    @ApiOperation(value = "Get", tags = {"EMJYJL" },  notes = "Get")
	@RequestMapping(method = RequestMethod.GET, value = "/emjyjls/{emjyjl_id}")
    public ResponseEntity<EMJYJLDTO> get(@PathVariable("emjyjl_id") String emjyjl_id) {
        EMJYJL domain = emjyjlService.get(emjyjl_id);
        EMJYJLDTO dto = emjyjlMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(#emjyjl_id,'Remove',{'Sql',this.emjyjlMapping,this.permissionDTO})")
    @ApiOperation(value = "Remove", tags = {"EMJYJL" },  notes = "Remove")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emjyjls/{emjyjl_id}")
    @Transactional
    public ResponseEntity<Boolean> remove(@PathVariable("emjyjl_id") String emjyjl_id) {
         return ResponseEntity.status(HttpStatus.OK).body(emjyjlService.remove(emjyjl_id));
    }

    @PreAuthorize("hasPermission('Remove',{'Sql',this.emjyjlMapping,this.permissionDTO,#ids})")
    @ApiOperation(value = "RemoveBatch", tags = {"EMJYJL" },  notes = "RemoveBatch")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emjyjls/batch")
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        emjyjlService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMJYJL-CheckKey-all')")
    @ApiOperation(value = "CheckKey", tags = {"EMJYJL" },  notes = "CheckKey")
	@RequestMapping(method = RequestMethod.POST, value = "/emjyjls/checkkey")
    public ResponseEntity<Boolean> checkKey(@RequestBody EMJYJLDTO emjyjldto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emjyjlService.checkKey(emjyjlMapping.toDomain(emjyjldto)));
    }

    @PreAuthorize("hasPermission('','Create',{'Sql',this.emjyjlMapping,#emjyjldto})")
    @ApiOperation(value = "Create", tags = {"EMJYJL" },  notes = "Create")
	@RequestMapping(method = RequestMethod.POST, value = "/emjyjls")
    @Transactional
    public ResponseEntity<EMJYJLDTO> create(@RequestBody EMJYJLDTO emjyjldto) {
        EMJYJL domain = emjyjlMapping.toDomain(emjyjldto);
		emjyjlService.create(domain);
        EMJYJLDTO dto = emjyjlMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Create',{'Sql',this.emjyjlMapping,#emjyjldtos})")
    @ApiOperation(value = "createBatch", tags = {"EMJYJL" },  notes = "createBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emjyjls/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<EMJYJLDTO> emjyjldtos) {
        emjyjlService.createBatch(emjyjlMapping.toDomain(emjyjldtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMJYJL-Default-all')")
	@ApiOperation(value = "fetchDEFAULT", tags = {"EMJYJL" } ,notes = "fetchDEFAULT")
    @RequestMapping(method= RequestMethod.GET , value="/emjyjls/fetchdefault")
	public ResponseEntity<List<EMJYJLDTO>> fetchDefault(EMJYJLSearchContext context) {
        Page<EMJYJL> domains = emjyjlService.searchDefault(context) ;
        List<EMJYJLDTO> list = emjyjlMapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMJYJL-Default-all')")
	@ApiOperation(value = "searchDEFAULT", tags = {"EMJYJL" } ,notes = "searchDEFAULT")
    @RequestMapping(method= RequestMethod.POST , value="/emjyjls/searchdefault")
	public ResponseEntity<Page<EMJYJLDTO>> searchDefault(@RequestBody EMJYJLSearchContext context) {
        Page<EMJYJL> domains = emjyjlService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emjyjlMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
}
