package cn.ibizlab.eam.webapi.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;
import javax.servlet.ServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import cn.ibizlab.eam.webapi.dto.*;
import cn.ibizlab.eam.webapi.mapping.*;
import cn.ibizlab.eam.core.eam_core.domain.EMEQType;
import cn.ibizlab.eam.core.eam_core.service.IEMEQTypeService;
import cn.ibizlab.eam.core.eam_core.filter.EMEQTypeSearchContext;

@Slf4j
@Api(tags = {"EMEQType" })
@RestController("WebApi-emeqtype")
@RequestMapping("")
public class EMEQTypeResource {

    @Autowired
    private IEMEQTypeService emeqtypeService;

    @Autowired
    @Lazy
    public EMEQTypeMapping emeqtypeMapping;

    public EMEQTypeDTO permissionDTO=new EMEQTypeDTO();

    @PreAuthorize("hasPermission(#emeqtype_id,'Remove',{'Sql',this.emeqtypeMapping,this.permissionDTO})")
    @ApiOperation(value = "Remove", tags = {"EMEQType" },  notes = "Remove")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emeqtypes/{emeqtype_id}")
    @Transactional
    public ResponseEntity<Boolean> remove(@PathVariable("emeqtype_id") String emeqtype_id) {
         return ResponseEntity.status(HttpStatus.OK).body(emeqtypeService.remove(emeqtype_id));
    }

    @PreAuthorize("hasPermission('Remove',{'Sql',this.emeqtypeMapping,this.permissionDTO,#ids})")
    @ApiOperation(value = "RemoveBatch", tags = {"EMEQType" },  notes = "RemoveBatch")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emeqtypes/batch")
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        emeqtypeService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(#emeqtype_id,'Update',{'Sql',this.emeqtypeMapping,#emeqtypedto})")
    @ApiOperation(value = "Update", tags = {"EMEQType" },  notes = "Update")
	@RequestMapping(method = RequestMethod.PUT, value = "/emeqtypes/{emeqtype_id}")
    @Transactional
    public ResponseEntity<EMEQTypeDTO> update(@PathVariable("emeqtype_id") String emeqtype_id, @RequestBody EMEQTypeDTO emeqtypedto) {
		EMEQType domain  = emeqtypeMapping.toDomain(emeqtypedto);
        domain .setEmeqtypeid(emeqtype_id);
		emeqtypeService.update(domain );
		EMEQTypeDTO dto = emeqtypeMapping.toDto(domain );
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Update',{'Sql',this.emeqtypeMapping,#emeqtypedtos})")
    @ApiOperation(value = "UpdateBatch", tags = {"EMEQType" },  notes = "UpdateBatch")
	@RequestMapping(method = RequestMethod.PUT, value = "/emeqtypes/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<EMEQTypeDTO> emeqtypedtos) {
        emeqtypeService.updateBatch(emeqtypeMapping.toDomain(emeqtypedtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMEQType-GetDraft-all')")
    @ApiOperation(value = "GetDraft", tags = {"EMEQType" },  notes = "GetDraft")
	@RequestMapping(method = RequestMethod.GET, value = "/emeqtypes/getdraft")
    public ResponseEntity<EMEQTypeDTO> getDraft() {
        return ResponseEntity.status(HttpStatus.OK).body(emeqtypeMapping.toDto(emeqtypeService.getDraft(new EMEQType())));
    }

    @PreAuthorize("hasPermission(#emeqtype_id,'Get',{'Sql',this.emeqtypeMapping,this.permissionDTO})")
    @ApiOperation(value = "Get", tags = {"EMEQType" },  notes = "Get")
	@RequestMapping(method = RequestMethod.GET, value = "/emeqtypes/{emeqtype_id}")
    public ResponseEntity<EMEQTypeDTO> get(@PathVariable("emeqtype_id") String emeqtype_id) {
        EMEQType domain = emeqtypeService.get(emeqtype_id);
        EMEQTypeDTO dto = emeqtypeMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('','Create',{'Sql',this.emeqtypeMapping,#emeqtypedto})")
    @ApiOperation(value = "Create", tags = {"EMEQType" },  notes = "Create")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqtypes")
    @Transactional
    public ResponseEntity<EMEQTypeDTO> create(@RequestBody EMEQTypeDTO emeqtypedto) {
        EMEQType domain = emeqtypeMapping.toDomain(emeqtypedto);
		emeqtypeService.create(domain);
        EMEQTypeDTO dto = emeqtypeMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Create',{'Sql',this.emeqtypeMapping,#emeqtypedtos})")
    @ApiOperation(value = "createBatch", tags = {"EMEQType" },  notes = "createBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqtypes/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<EMEQTypeDTO> emeqtypedtos) {
        emeqtypeService.createBatch(emeqtypeMapping.toDomain(emeqtypedtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMEQType-CheckKey-all')")
    @ApiOperation(value = "CheckKey", tags = {"EMEQType" },  notes = "CheckKey")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqtypes/checkkey")
    public ResponseEntity<Boolean> checkKey(@RequestBody EMEQTypeDTO emeqtypedto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emeqtypeService.checkKey(emeqtypeMapping.toDomain(emeqtypedto)));
    }

    @PreAuthorize("hasPermission('','Save',{'Sql',this.emeqtypeMapping,#emeqtypedto})")
    @ApiOperation(value = "Save", tags = {"EMEQType" },  notes = "Save")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqtypes/save")
    public ResponseEntity<Boolean> save(@RequestBody EMEQTypeDTO emeqtypedto) {
        return ResponseEntity.status(HttpStatus.OK).body(emeqtypeService.save(emeqtypeMapping.toDomain(emeqtypedto)));
    }

    @PreAuthorize("hasPermission('Save',{'Sql',this.emeqtypeMapping,#emeqtypedtos})")
    @ApiOperation(value = "SaveBatch", tags = {"EMEQType" },  notes = "SaveBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqtypes/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<EMEQTypeDTO> emeqtypedtos) {
        emeqtypeService.saveBatch(emeqtypeMapping.toDomain(emeqtypedtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMEQType-PeqType-all')")
	@ApiOperation(value = "fetch上级设备类型", tags = {"EMEQType" } ,notes = "fetch上级设备类型")
    @RequestMapping(method= RequestMethod.GET , value="/emeqtypes/fetchpeqtype")
	public ResponseEntity<List<EMEQTypeDTO>> fetchPeqType(EMEQTypeSearchContext context) {
        Page<EMEQType> domains = emeqtypeService.searchPeqType(context) ;
        List<EMEQTypeDTO> list = emeqtypeMapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMEQType-PeqType-all')")
	@ApiOperation(value = "search上级设备类型", tags = {"EMEQType" } ,notes = "search上级设备类型")
    @RequestMapping(method= RequestMethod.POST , value="/emeqtypes/searchpeqtype")
	public ResponseEntity<Page<EMEQTypeDTO>> searchPeqType(@RequestBody EMEQTypeSearchContext context) {
        Page<EMEQType> domains = emeqtypeService.searchPeqType(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emeqtypeMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMEQType-Default-all')")
	@ApiOperation(value = "fetchDEFAULT", tags = {"EMEQType" } ,notes = "fetchDEFAULT")
    @RequestMapping(method= RequestMethod.GET , value="/emeqtypes/fetchdefault")
	public ResponseEntity<List<EMEQTypeDTO>> fetchDefault(EMEQTypeSearchContext context) {
        Page<EMEQType> domains = emeqtypeService.searchDefault(context) ;
        List<EMEQTypeDTO> list = emeqtypeMapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMEQType-Default-all')")
	@ApiOperation(value = "searchDEFAULT", tags = {"EMEQType" } ,notes = "searchDEFAULT")
    @RequestMapping(method= RequestMethod.POST , value="/emeqtypes/searchdefault")
	public ResponseEntity<Page<EMEQTypeDTO>> searchDefault(@RequestBody EMEQTypeSearchContext context) {
        Page<EMEQType> domains = emeqtypeService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emeqtypeMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
}
