package cn.ibizlab.eam.webapi.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;
import javax.servlet.ServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import cn.ibizlab.eam.webapi.dto.*;
import cn.ibizlab.eam.webapi.mapping.*;
import cn.ibizlab.eam.core.eam_core.domain.EMEICellSetup;
import cn.ibizlab.eam.core.eam_core.service.IEMEICellSetupService;
import cn.ibizlab.eam.core.eam_core.filter.EMEICellSetupSearchContext;

@Slf4j
@Api(tags = {"EMEICellSetup" })
@RestController("WebApi-emeicellsetup")
@RequestMapping("")
public class EMEICellSetupResource {

    @Autowired
    private IEMEICellSetupService emeicellsetupService;

    @Autowired
    @Lazy
    public EMEICellSetupMapping emeicellsetupMapping;

    public EMEICellSetupDTO permissionDTO=new EMEICellSetupDTO();

    @PreAuthorize("hasPermission('','Create',{'Sql',this.emeicellsetupMapping,#emeicellsetupdto})")
    @ApiOperation(value = "Create", tags = {"EMEICellSetup" },  notes = "Create")
	@RequestMapping(method = RequestMethod.POST, value = "/emeicellsetups")
    @Transactional
    public ResponseEntity<EMEICellSetupDTO> create(@RequestBody EMEICellSetupDTO emeicellsetupdto) {
        EMEICellSetup domain = emeicellsetupMapping.toDomain(emeicellsetupdto);
		emeicellsetupService.create(domain);
        EMEICellSetupDTO dto = emeicellsetupMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Create',{'Sql',this.emeicellsetupMapping,#emeicellsetupdtos})")
    @ApiOperation(value = "createBatch", tags = {"EMEICellSetup" },  notes = "createBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emeicellsetups/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<EMEICellSetupDTO> emeicellsetupdtos) {
        emeicellsetupService.createBatch(emeicellsetupMapping.toDomain(emeicellsetupdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMEICellSetup-GetDraft-all')")
    @ApiOperation(value = "GetDraft", tags = {"EMEICellSetup" },  notes = "GetDraft")
	@RequestMapping(method = RequestMethod.GET, value = "/emeicellsetups/getdraft")
    public ResponseEntity<EMEICellSetupDTO> getDraft() {
        return ResponseEntity.status(HttpStatus.OK).body(emeicellsetupMapping.toDto(emeicellsetupService.getDraft(new EMEICellSetup())));
    }

    @PreAuthorize("hasPermission('','Save',{'Sql',this.emeicellsetupMapping,#emeicellsetupdto})")
    @ApiOperation(value = "Save", tags = {"EMEICellSetup" },  notes = "Save")
	@RequestMapping(method = RequestMethod.POST, value = "/emeicellsetups/save")
    public ResponseEntity<Boolean> save(@RequestBody EMEICellSetupDTO emeicellsetupdto) {
        return ResponseEntity.status(HttpStatus.OK).body(emeicellsetupService.save(emeicellsetupMapping.toDomain(emeicellsetupdto)));
    }

    @PreAuthorize("hasPermission('Save',{'Sql',this.emeicellsetupMapping,#emeicellsetupdtos})")
    @ApiOperation(value = "SaveBatch", tags = {"EMEICellSetup" },  notes = "SaveBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emeicellsetups/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<EMEICellSetupDTO> emeicellsetupdtos) {
        emeicellsetupService.saveBatch(emeicellsetupMapping.toDomain(emeicellsetupdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(#emeicellsetup_id,'Get',{'Sql',this.emeicellsetupMapping,this.permissionDTO})")
    @ApiOperation(value = "Get", tags = {"EMEICellSetup" },  notes = "Get")
	@RequestMapping(method = RequestMethod.GET, value = "/emeicellsetups/{emeicellsetup_id}")
    public ResponseEntity<EMEICellSetupDTO> get(@PathVariable("emeicellsetup_id") String emeicellsetup_id) {
        EMEICellSetup domain = emeicellsetupService.get(emeicellsetup_id);
        EMEICellSetupDTO dto = emeicellsetupMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMEICellSetup-CheckKey-all')")
    @ApiOperation(value = "CheckKey", tags = {"EMEICellSetup" },  notes = "CheckKey")
	@RequestMapping(method = RequestMethod.POST, value = "/emeicellsetups/checkkey")
    public ResponseEntity<Boolean> checkKey(@RequestBody EMEICellSetupDTO emeicellsetupdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emeicellsetupService.checkKey(emeicellsetupMapping.toDomain(emeicellsetupdto)));
    }

    @PreAuthorize("hasPermission(#emeicellsetup_id,'Update',{'Sql',this.emeicellsetupMapping,#emeicellsetupdto})")
    @ApiOperation(value = "Update", tags = {"EMEICellSetup" },  notes = "Update")
	@RequestMapping(method = RequestMethod.PUT, value = "/emeicellsetups/{emeicellsetup_id}")
    @Transactional
    public ResponseEntity<EMEICellSetupDTO> update(@PathVariable("emeicellsetup_id") String emeicellsetup_id, @RequestBody EMEICellSetupDTO emeicellsetupdto) {
		EMEICellSetup domain  = emeicellsetupMapping.toDomain(emeicellsetupdto);
        domain .setEmeicellsetupid(emeicellsetup_id);
		emeicellsetupService.update(domain );
		EMEICellSetupDTO dto = emeicellsetupMapping.toDto(domain );
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Update',{'Sql',this.emeicellsetupMapping,#emeicellsetupdtos})")
    @ApiOperation(value = "UpdateBatch", tags = {"EMEICellSetup" },  notes = "UpdateBatch")
	@RequestMapping(method = RequestMethod.PUT, value = "/emeicellsetups/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<EMEICellSetupDTO> emeicellsetupdtos) {
        emeicellsetupService.updateBatch(emeicellsetupMapping.toDomain(emeicellsetupdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(#emeicellsetup_id,'Remove',{'Sql',this.emeicellsetupMapping,this.permissionDTO})")
    @ApiOperation(value = "Remove", tags = {"EMEICellSetup" },  notes = "Remove")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emeicellsetups/{emeicellsetup_id}")
    @Transactional
    public ResponseEntity<Boolean> remove(@PathVariable("emeicellsetup_id") String emeicellsetup_id) {
         return ResponseEntity.status(HttpStatus.OK).body(emeicellsetupService.remove(emeicellsetup_id));
    }

    @PreAuthorize("hasPermission('Remove',{'Sql',this.emeicellsetupMapping,this.permissionDTO,#ids})")
    @ApiOperation(value = "RemoveBatch", tags = {"EMEICellSetup" },  notes = "RemoveBatch")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emeicellsetups/batch")
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        emeicellsetupService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMEICellSetup-Default-all')")
	@ApiOperation(value = "fetchDEFAULT", tags = {"EMEICellSetup" } ,notes = "fetchDEFAULT")
    @RequestMapping(method= RequestMethod.GET , value="/emeicellsetups/fetchdefault")
	public ResponseEntity<List<EMEICellSetupDTO>> fetchDefault(EMEICellSetupSearchContext context) {
        Page<EMEICellSetup> domains = emeicellsetupService.searchDefault(context) ;
        List<EMEICellSetupDTO> list = emeicellsetupMapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMEICellSetup-Default-all')")
	@ApiOperation(value = "searchDEFAULT", tags = {"EMEICellSetup" } ,notes = "searchDEFAULT")
    @RequestMapping(method= RequestMethod.POST , value="/emeicellsetups/searchdefault")
	public ResponseEntity<Page<EMEICellSetupDTO>> searchDefault(@RequestBody EMEICellSetupSearchContext context) {
        Page<EMEICellSetup> domains = emeicellsetupService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emeicellsetupMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
}
