package cn.ibizlab.eam.webapi.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;
import javax.servlet.ServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import cn.ibizlab.eam.webapi.dto.*;
import cn.ibizlab.eam.webapi.mapping.*;
import cn.ibizlab.eam.core.eam_core.domain.EMDRWGMap;
import cn.ibizlab.eam.core.eam_core.service.IEMDRWGMapService;
import cn.ibizlab.eam.core.eam_core.filter.EMDRWGMapSearchContext;

@Slf4j
@Api(tags = {"EMDRWGMap" })
@RestController("WebApi-emdrwgmap")
@RequestMapping("")
public class EMDRWGMapResource {

    @Autowired
    private IEMDRWGMapService emdrwgmapService;

    @Autowired
    @Lazy
    public EMDRWGMapMapping emdrwgmapMapping;

    public EMDRWGMapDTO permissionDTO=new EMDRWGMapDTO();

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMDRWGMap-GetDraft-all')")
    @ApiOperation(value = "GetDraft", tags = {"EMDRWGMap" },  notes = "GetDraft")
	@RequestMapping(method = RequestMethod.GET, value = "/emdrwgmaps/getdraft")
    public ResponseEntity<EMDRWGMapDTO> getDraft() {
        return ResponseEntity.status(HttpStatus.OK).body(emdrwgmapMapping.toDto(emdrwgmapService.getDraft(new EMDRWGMap())));
    }

    @PreAuthorize("hasPermission(#emdrwgmap_id,'Get',{'Sql',this.emdrwgmapMapping,this.permissionDTO})")
    @ApiOperation(value = "Get", tags = {"EMDRWGMap" },  notes = "Get")
	@RequestMapping(method = RequestMethod.GET, value = "/emdrwgmaps/{emdrwgmap_id}")
    public ResponseEntity<EMDRWGMapDTO> get(@PathVariable("emdrwgmap_id") String emdrwgmap_id) {
        EMDRWGMap domain = emdrwgmapService.get(emdrwgmap_id);
        EMDRWGMapDTO dto = emdrwgmapMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMDRWGMap-CheckKey-all')")
    @ApiOperation(value = "CheckKey", tags = {"EMDRWGMap" },  notes = "CheckKey")
	@RequestMapping(method = RequestMethod.POST, value = "/emdrwgmaps/checkkey")
    public ResponseEntity<Boolean> checkKey(@RequestBody EMDRWGMapDTO emdrwgmapdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emdrwgmapService.checkKey(emdrwgmapMapping.toDomain(emdrwgmapdto)));
    }

    @PreAuthorize("hasPermission(#emdrwgmap_id,'Remove',{'Sql',this.emdrwgmapMapping,this.permissionDTO})")
    @ApiOperation(value = "Remove", tags = {"EMDRWGMap" },  notes = "Remove")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emdrwgmaps/{emdrwgmap_id}")
    @Transactional
    public ResponseEntity<Boolean> remove(@PathVariable("emdrwgmap_id") String emdrwgmap_id) {
         return ResponseEntity.status(HttpStatus.OK).body(emdrwgmapService.remove(emdrwgmap_id));
    }

    @PreAuthorize("hasPermission('Remove',{'Sql',this.emdrwgmapMapping,this.permissionDTO,#ids})")
    @ApiOperation(value = "RemoveBatch", tags = {"EMDRWGMap" },  notes = "RemoveBatch")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emdrwgmaps/batch")
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        emdrwgmapService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission('','Create',{'Sql',this.emdrwgmapMapping,#emdrwgmapdto})")
    @ApiOperation(value = "Create", tags = {"EMDRWGMap" },  notes = "Create")
	@RequestMapping(method = RequestMethod.POST, value = "/emdrwgmaps")
    @Transactional
    public ResponseEntity<EMDRWGMapDTO> create(@RequestBody EMDRWGMapDTO emdrwgmapdto) {
        EMDRWGMap domain = emdrwgmapMapping.toDomain(emdrwgmapdto);
		emdrwgmapService.create(domain);
        EMDRWGMapDTO dto = emdrwgmapMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Create',{'Sql',this.emdrwgmapMapping,#emdrwgmapdtos})")
    @ApiOperation(value = "createBatch", tags = {"EMDRWGMap" },  notes = "createBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emdrwgmaps/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<EMDRWGMapDTO> emdrwgmapdtos) {
        emdrwgmapService.createBatch(emdrwgmapMapping.toDomain(emdrwgmapdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(#emdrwgmap_id,'Update',{'Sql',this.emdrwgmapMapping,#emdrwgmapdto})")
    @ApiOperation(value = "Update", tags = {"EMDRWGMap" },  notes = "Update")
	@RequestMapping(method = RequestMethod.PUT, value = "/emdrwgmaps/{emdrwgmap_id}")
    @Transactional
    public ResponseEntity<EMDRWGMapDTO> update(@PathVariable("emdrwgmap_id") String emdrwgmap_id, @RequestBody EMDRWGMapDTO emdrwgmapdto) {
		EMDRWGMap domain  = emdrwgmapMapping.toDomain(emdrwgmapdto);
        domain .setEmdrwgmapid(emdrwgmap_id);
		emdrwgmapService.update(domain );
		EMDRWGMapDTO dto = emdrwgmapMapping.toDto(domain );
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Update',{'Sql',this.emdrwgmapMapping,#emdrwgmapdtos})")
    @ApiOperation(value = "UpdateBatch", tags = {"EMDRWGMap" },  notes = "UpdateBatch")
	@RequestMapping(method = RequestMethod.PUT, value = "/emdrwgmaps/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<EMDRWGMapDTO> emdrwgmapdtos) {
        emdrwgmapService.updateBatch(emdrwgmapMapping.toDomain(emdrwgmapdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission('','Save',{'Sql',this.emdrwgmapMapping,#emdrwgmapdto})")
    @ApiOperation(value = "Save", tags = {"EMDRWGMap" },  notes = "Save")
	@RequestMapping(method = RequestMethod.POST, value = "/emdrwgmaps/save")
    public ResponseEntity<Boolean> save(@RequestBody EMDRWGMapDTO emdrwgmapdto) {
        return ResponseEntity.status(HttpStatus.OK).body(emdrwgmapService.save(emdrwgmapMapping.toDomain(emdrwgmapdto)));
    }

    @PreAuthorize("hasPermission('Save',{'Sql',this.emdrwgmapMapping,#emdrwgmapdtos})")
    @ApiOperation(value = "SaveBatch", tags = {"EMDRWGMap" },  notes = "SaveBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emdrwgmaps/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<EMDRWGMapDTO> emdrwgmapdtos) {
        emdrwgmapService.saveBatch(emdrwgmapMapping.toDomain(emdrwgmapdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMDRWGMap-Default-all')")
	@ApiOperation(value = "fetchDEFAULT", tags = {"EMDRWGMap" } ,notes = "fetchDEFAULT")
    @RequestMapping(method= RequestMethod.GET , value="/emdrwgmaps/fetchdefault")
	public ResponseEntity<List<EMDRWGMapDTO>> fetchDefault(EMDRWGMapSearchContext context) {
        Page<EMDRWGMap> domains = emdrwgmapService.searchDefault(context) ;
        List<EMDRWGMapDTO> list = emdrwgmapMapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMDRWGMap-Default-all')")
	@ApiOperation(value = "searchDEFAULT", tags = {"EMDRWGMap" } ,notes = "searchDEFAULT")
    @RequestMapping(method= RequestMethod.POST , value="/emdrwgmaps/searchdefault")
	public ResponseEntity<Page<EMDRWGMapDTO>> searchDefault(@RequestBody EMDRWGMapSearchContext context) {
        Page<EMDRWGMap> domains = emdrwgmapService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emdrwgmapMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
}
