package cn.ibizlab.eam.webapi.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;
import javax.servlet.ServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import cn.ibizlab.eam.webapi.dto.*;
import cn.ibizlab.eam.webapi.mapping.*;
import cn.ibizlab.eam.core.eam_core.domain.EMCustomRel;
import cn.ibizlab.eam.core.eam_core.service.IEMCustomRelService;
import cn.ibizlab.eam.core.eam_core.filter.EMCustomRelSearchContext;

@Slf4j
@Api(tags = {"EMCustomRel" })
@RestController("WebApi-emcustomrel")
@RequestMapping("")
public class EMCustomRelResource {

    @Autowired
    private IEMCustomRelService emcustomrelService;

    @Autowired
    @Lazy
    public EMCustomRelMapping emcustomrelMapping;

    public EMCustomRelDTO permissionDTO=new EMCustomRelDTO();

    @PreAuthorize("hasPermission('','Create',{'Sql',this.emcustomrelMapping,#emcustomreldto})")
    @ApiOperation(value = "Create", tags = {"EMCustomRel" },  notes = "Create")
	@RequestMapping(method = RequestMethod.POST, value = "/emcustomrels")
    @Transactional
    public ResponseEntity<EMCustomRelDTO> create(@RequestBody EMCustomRelDTO emcustomreldto) {
        EMCustomRel domain = emcustomrelMapping.toDomain(emcustomreldto);
		emcustomrelService.create(domain);
        EMCustomRelDTO dto = emcustomrelMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Create',{'Sql',this.emcustomrelMapping,#emcustomreldtos})")
    @ApiOperation(value = "createBatch", tags = {"EMCustomRel" },  notes = "createBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emcustomrels/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<EMCustomRelDTO> emcustomreldtos) {
        emcustomrelService.createBatch(emcustomrelMapping.toDomain(emcustomreldtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(#emcustomrel_id,'Remove',{'Sql',this.emcustomrelMapping,this.permissionDTO})")
    @ApiOperation(value = "Remove", tags = {"EMCustomRel" },  notes = "Remove")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emcustomrels/{emcustomrel_id}")
    @Transactional
    public ResponseEntity<Boolean> remove(@PathVariable("emcustomrel_id") String emcustomrel_id) {
         return ResponseEntity.status(HttpStatus.OK).body(emcustomrelService.remove(emcustomrel_id));
    }

    @PreAuthorize("hasPermission('Remove',{'Sql',this.emcustomrelMapping,this.permissionDTO,#ids})")
    @ApiOperation(value = "RemoveBatch", tags = {"EMCustomRel" },  notes = "RemoveBatch")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emcustomrels/batch")
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        emcustomrelService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMCustomRel-GetDraft-all')")
    @ApiOperation(value = "GetDraft", tags = {"EMCustomRel" },  notes = "GetDraft")
	@RequestMapping(method = RequestMethod.GET, value = "/emcustomrels/getdraft")
    public ResponseEntity<EMCustomRelDTO> getDraft() {
        return ResponseEntity.status(HttpStatus.OK).body(emcustomrelMapping.toDto(emcustomrelService.getDraft(new EMCustomRel())));
    }

    @PreAuthorize("hasPermission('','Save',{'Sql',this.emcustomrelMapping,#emcustomreldto})")
    @ApiOperation(value = "Save", tags = {"EMCustomRel" },  notes = "Save")
	@RequestMapping(method = RequestMethod.POST, value = "/emcustomrels/save")
    public ResponseEntity<Boolean> save(@RequestBody EMCustomRelDTO emcustomreldto) {
        return ResponseEntity.status(HttpStatus.OK).body(emcustomrelService.save(emcustomrelMapping.toDomain(emcustomreldto)));
    }

    @PreAuthorize("hasPermission('Save',{'Sql',this.emcustomrelMapping,#emcustomreldtos})")
    @ApiOperation(value = "SaveBatch", tags = {"EMCustomRel" },  notes = "SaveBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emcustomrels/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<EMCustomRelDTO> emcustomreldtos) {
        emcustomrelService.saveBatch(emcustomrelMapping.toDomain(emcustomreldtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(#emcustomrel_id,'Get',{'Sql',this.emcustomrelMapping,this.permissionDTO})")
    @ApiOperation(value = "Get", tags = {"EMCustomRel" },  notes = "Get")
	@RequestMapping(method = RequestMethod.GET, value = "/emcustomrels/{emcustomrel_id}")
    public ResponseEntity<EMCustomRelDTO> get(@PathVariable("emcustomrel_id") String emcustomrel_id) {
        EMCustomRel domain = emcustomrelService.get(emcustomrel_id);
        EMCustomRelDTO dto = emcustomrelMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMCustomRel-CheckKey-all')")
    @ApiOperation(value = "CheckKey", tags = {"EMCustomRel" },  notes = "CheckKey")
	@RequestMapping(method = RequestMethod.POST, value = "/emcustomrels/checkkey")
    public ResponseEntity<Boolean> checkKey(@RequestBody EMCustomRelDTO emcustomreldto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emcustomrelService.checkKey(emcustomrelMapping.toDomain(emcustomreldto)));
    }

    @PreAuthorize("hasPermission(#emcustomrel_id,'Update',{'Sql',this.emcustomrelMapping,#emcustomreldto})")
    @ApiOperation(value = "Update", tags = {"EMCustomRel" },  notes = "Update")
	@RequestMapping(method = RequestMethod.PUT, value = "/emcustomrels/{emcustomrel_id}")
    @Transactional
    public ResponseEntity<EMCustomRelDTO> update(@PathVariable("emcustomrel_id") String emcustomrel_id, @RequestBody EMCustomRelDTO emcustomreldto) {
		EMCustomRel domain  = emcustomrelMapping.toDomain(emcustomreldto);
        domain .setEmcustomrelid(emcustomrel_id);
		emcustomrelService.update(domain );
		EMCustomRelDTO dto = emcustomrelMapping.toDto(domain );
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Update',{'Sql',this.emcustomrelMapping,#emcustomreldtos})")
    @ApiOperation(value = "UpdateBatch", tags = {"EMCustomRel" },  notes = "UpdateBatch")
	@RequestMapping(method = RequestMethod.PUT, value = "/emcustomrels/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<EMCustomRelDTO> emcustomreldtos) {
        emcustomrelService.updateBatch(emcustomrelMapping.toDomain(emcustomreldtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMCustomRel-Default-all')")
	@ApiOperation(value = "fetchDEFAULT", tags = {"EMCustomRel" } ,notes = "fetchDEFAULT")
    @RequestMapping(method= RequestMethod.GET , value="/emcustomrels/fetchdefault")
	public ResponseEntity<List<EMCustomRelDTO>> fetchDefault(EMCustomRelSearchContext context) {
        Page<EMCustomRel> domains = emcustomrelService.searchDefault(context) ;
        List<EMCustomRelDTO> list = emcustomrelMapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMCustomRel-Default-all')")
	@ApiOperation(value = "searchDEFAULT", tags = {"EMCustomRel" } ,notes = "searchDEFAULT")
    @RequestMapping(method= RequestMethod.POST , value="/emcustomrels/searchdefault")
	public ResponseEntity<Page<EMCustomRelDTO>> searchDefault(@RequestBody EMCustomRelSearchContext context) {
        Page<EMCustomRel> domains = emcustomrelService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emcustomrelMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
}
