package cn.ibizlab.eam.webapi.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;
import javax.servlet.ServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import cn.ibizlab.eam.webapi.dto.*;
import cn.ibizlab.eam.webapi.mapping.*;
import cn.ibizlab.eam.core.eam_core.domain.EMAssessMent;
import cn.ibizlab.eam.core.eam_core.service.IEMAssessMentService;
import cn.ibizlab.eam.core.eam_core.filter.EMAssessMentSearchContext;

@Slf4j
@Api(tags = {"EMAssessMent" })
@RestController("WebApi-emassessment")
@RequestMapping("")
public class EMAssessMentResource {

    @Autowired
    private IEMAssessMentService emassessmentService;

    @Autowired
    @Lazy
    public EMAssessMentMapping emassessmentMapping;

    public EMAssessMentDTO permissionDTO=new EMAssessMentDTO();

    @PreAuthorize("hasPermission('','Save',{'Sql',this.emassessmentMapping,#emassessmentdto})")
    @ApiOperation(value = "Save", tags = {"EMAssessMent" },  notes = "Save")
	@RequestMapping(method = RequestMethod.POST, value = "/emassessments/save")
    public ResponseEntity<Boolean> save(@RequestBody EMAssessMentDTO emassessmentdto) {
        return ResponseEntity.status(HttpStatus.OK).body(emassessmentService.save(emassessmentMapping.toDomain(emassessmentdto)));
    }

    @PreAuthorize("hasPermission('Save',{'Sql',this.emassessmentMapping,#emassessmentdtos})")
    @ApiOperation(value = "SaveBatch", tags = {"EMAssessMent" },  notes = "SaveBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emassessments/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<EMAssessMentDTO> emassessmentdtos) {
        emassessmentService.saveBatch(emassessmentMapping.toDomain(emassessmentdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(#emassessment_id,'Get',{'Sql',this.emassessmentMapping,this.permissionDTO})")
    @ApiOperation(value = "Get", tags = {"EMAssessMent" },  notes = "Get")
	@RequestMapping(method = RequestMethod.GET, value = "/emassessments/{emassessment_id}")
    public ResponseEntity<EMAssessMentDTO> get(@PathVariable("emassessment_id") String emassessment_id) {
        EMAssessMent domain = emassessmentService.get(emassessment_id);
        EMAssessMentDTO dto = emassessmentMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(#emassessment_id,'Remove',{'Sql',this.emassessmentMapping,this.permissionDTO})")
    @ApiOperation(value = "Remove", tags = {"EMAssessMent" },  notes = "Remove")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emassessments/{emassessment_id}")
    @Transactional
    public ResponseEntity<Boolean> remove(@PathVariable("emassessment_id") String emassessment_id) {
         return ResponseEntity.status(HttpStatus.OK).body(emassessmentService.remove(emassessment_id));
    }

    @PreAuthorize("hasPermission('Remove',{'Sql',this.emassessmentMapping,this.permissionDTO,#ids})")
    @ApiOperation(value = "RemoveBatch", tags = {"EMAssessMent" },  notes = "RemoveBatch")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emassessments/batch")
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        emassessmentService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission('','Create',{'Sql',this.emassessmentMapping,#emassessmentdto})")
    @ApiOperation(value = "Create", tags = {"EMAssessMent" },  notes = "Create")
	@RequestMapping(method = RequestMethod.POST, value = "/emassessments")
    @Transactional
    public ResponseEntity<EMAssessMentDTO> create(@RequestBody EMAssessMentDTO emassessmentdto) {
        EMAssessMent domain = emassessmentMapping.toDomain(emassessmentdto);
		emassessmentService.create(domain);
        EMAssessMentDTO dto = emassessmentMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Create',{'Sql',this.emassessmentMapping,#emassessmentdtos})")
    @ApiOperation(value = "createBatch", tags = {"EMAssessMent" },  notes = "createBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emassessments/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<EMAssessMentDTO> emassessmentdtos) {
        emassessmentService.createBatch(emassessmentMapping.toDomain(emassessmentdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(#emassessment_id,'Update',{'Sql',this.emassessmentMapping,#emassessmentdto})")
    @ApiOperation(value = "Update", tags = {"EMAssessMent" },  notes = "Update")
	@RequestMapping(method = RequestMethod.PUT, value = "/emassessments/{emassessment_id}")
    @Transactional
    public ResponseEntity<EMAssessMentDTO> update(@PathVariable("emassessment_id") String emassessment_id, @RequestBody EMAssessMentDTO emassessmentdto) {
		EMAssessMent domain  = emassessmentMapping.toDomain(emassessmentdto);
        domain .setEmassessmentid(emassessment_id);
		emassessmentService.update(domain );
		EMAssessMentDTO dto = emassessmentMapping.toDto(domain );
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Update',{'Sql',this.emassessmentMapping,#emassessmentdtos})")
    @ApiOperation(value = "UpdateBatch", tags = {"EMAssessMent" },  notes = "UpdateBatch")
	@RequestMapping(method = RequestMethod.PUT, value = "/emassessments/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<EMAssessMentDTO> emassessmentdtos) {
        emassessmentService.updateBatch(emassessmentMapping.toDomain(emassessmentdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMAssessMent-GetDraft-all')")
    @ApiOperation(value = "GetDraft", tags = {"EMAssessMent" },  notes = "GetDraft")
	@RequestMapping(method = RequestMethod.GET, value = "/emassessments/getdraft")
    public ResponseEntity<EMAssessMentDTO> getDraft() {
        return ResponseEntity.status(HttpStatus.OK).body(emassessmentMapping.toDto(emassessmentService.getDraft(new EMAssessMent())));
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMAssessMent-CheckKey-all')")
    @ApiOperation(value = "CheckKey", tags = {"EMAssessMent" },  notes = "CheckKey")
	@RequestMapping(method = RequestMethod.POST, value = "/emassessments/checkkey")
    public ResponseEntity<Boolean> checkKey(@RequestBody EMAssessMentDTO emassessmentdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emassessmentService.checkKey(emassessmentMapping.toDomain(emassessmentdto)));
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMAssessMent-Default-all')")
	@ApiOperation(value = "fetchDEFAULT", tags = {"EMAssessMent" } ,notes = "fetchDEFAULT")
    @RequestMapping(method= RequestMethod.GET , value="/emassessments/fetchdefault")
	public ResponseEntity<List<EMAssessMentDTO>> fetchDefault(EMAssessMentSearchContext context) {
        Page<EMAssessMent> domains = emassessmentService.searchDefault(context) ;
        List<EMAssessMentDTO> list = emassessmentMapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMAssessMent-Default-all')")
	@ApiOperation(value = "searchDEFAULT", tags = {"EMAssessMent" } ,notes = "searchDEFAULT")
    @RequestMapping(method= RequestMethod.POST , value="/emassessments/searchdefault")
	public ResponseEntity<Page<EMAssessMentDTO>> searchDefault(@RequestBody EMAssessMentSearchContext context) {
        Page<EMAssessMent> domains = emassessmentService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emassessmentMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
}
