package cn.ibizlab.eam.webapi.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;
import javax.servlet.ServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import cn.ibizlab.eam.webapi.dto.*;
import cn.ibizlab.eam.webapi.mapping.*;
import cn.ibizlab.eam.core.eam_core.domain.EMAssessMentMX;
import cn.ibizlab.eam.core.eam_core.service.IEMAssessMentMXService;
import cn.ibizlab.eam.core.eam_core.filter.EMAssessMentMXSearchContext;

@Slf4j
@Api(tags = {"EMAssessMentMX" })
@RestController("WebApi-emassessmentmx")
@RequestMapping("")
public class EMAssessMentMXResource {

    @Autowired
    private IEMAssessMentMXService emassessmentmxService;

    @Autowired
    @Lazy
    public EMAssessMentMXMapping emassessmentmxMapping;

    public EMAssessMentMXDTO permissionDTO=new EMAssessMentMXDTO();

    @PreAuthorize("hasPermission('','Save',{'Sql',this.emassessmentmxMapping,#emassessmentmxdto})")
    @ApiOperation(value = "Save", tags = {"EMAssessMentMX" },  notes = "Save")
	@RequestMapping(method = RequestMethod.POST, value = "/emassessmentmxes/save")
    public ResponseEntity<Boolean> save(@RequestBody EMAssessMentMXDTO emassessmentmxdto) {
        return ResponseEntity.status(HttpStatus.OK).body(emassessmentmxService.save(emassessmentmxMapping.toDomain(emassessmentmxdto)));
    }

    @PreAuthorize("hasPermission('Save',{'Sql',this.emassessmentmxMapping,#emassessmentmxdtos})")
    @ApiOperation(value = "SaveBatch", tags = {"EMAssessMentMX" },  notes = "SaveBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emassessmentmxes/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<EMAssessMentMXDTO> emassessmentmxdtos) {
        emassessmentmxService.saveBatch(emassessmentmxMapping.toDomain(emassessmentmxdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(#emassessmentmx_id,'Update',{'Sql',this.emassessmentmxMapping,#emassessmentmxdto})")
    @ApiOperation(value = "Update", tags = {"EMAssessMentMX" },  notes = "Update")
	@RequestMapping(method = RequestMethod.PUT, value = "/emassessmentmxes/{emassessmentmx_id}")
    @Transactional
    public ResponseEntity<EMAssessMentMXDTO> update(@PathVariable("emassessmentmx_id") String emassessmentmx_id, @RequestBody EMAssessMentMXDTO emassessmentmxdto) {
		EMAssessMentMX domain  = emassessmentmxMapping.toDomain(emassessmentmxdto);
        domain .setEmassessmentmxid(emassessmentmx_id);
		emassessmentmxService.update(domain );
		EMAssessMentMXDTO dto = emassessmentmxMapping.toDto(domain );
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Update',{'Sql',this.emassessmentmxMapping,#emassessmentmxdtos})")
    @ApiOperation(value = "UpdateBatch", tags = {"EMAssessMentMX" },  notes = "UpdateBatch")
	@RequestMapping(method = RequestMethod.PUT, value = "/emassessmentmxes/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<EMAssessMentMXDTO> emassessmentmxdtos) {
        emassessmentmxService.updateBatch(emassessmentmxMapping.toDomain(emassessmentmxdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(#emassessmentmx_id,'Remove',{'Sql',this.emassessmentmxMapping,this.permissionDTO})")
    @ApiOperation(value = "Remove", tags = {"EMAssessMentMX" },  notes = "Remove")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emassessmentmxes/{emassessmentmx_id}")
    @Transactional
    public ResponseEntity<Boolean> remove(@PathVariable("emassessmentmx_id") String emassessmentmx_id) {
         return ResponseEntity.status(HttpStatus.OK).body(emassessmentmxService.remove(emassessmentmx_id));
    }

    @PreAuthorize("hasPermission('Remove',{'Sql',this.emassessmentmxMapping,this.permissionDTO,#ids})")
    @ApiOperation(value = "RemoveBatch", tags = {"EMAssessMentMX" },  notes = "RemoveBatch")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emassessmentmxes/batch")
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        emassessmentmxService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMAssessMentMX-CheckKey-all')")
    @ApiOperation(value = "CheckKey", tags = {"EMAssessMentMX" },  notes = "CheckKey")
	@RequestMapping(method = RequestMethod.POST, value = "/emassessmentmxes/checkkey")
    public ResponseEntity<Boolean> checkKey(@RequestBody EMAssessMentMXDTO emassessmentmxdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emassessmentmxService.checkKey(emassessmentmxMapping.toDomain(emassessmentmxdto)));
    }

    @PreAuthorize("hasPermission('','Create',{'Sql',this.emassessmentmxMapping,#emassessmentmxdto})")
    @ApiOperation(value = "Create", tags = {"EMAssessMentMX" },  notes = "Create")
	@RequestMapping(method = RequestMethod.POST, value = "/emassessmentmxes")
    @Transactional
    public ResponseEntity<EMAssessMentMXDTO> create(@RequestBody EMAssessMentMXDTO emassessmentmxdto) {
        EMAssessMentMX domain = emassessmentmxMapping.toDomain(emassessmentmxdto);
		emassessmentmxService.create(domain);
        EMAssessMentMXDTO dto = emassessmentmxMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Create',{'Sql',this.emassessmentmxMapping,#emassessmentmxdtos})")
    @ApiOperation(value = "createBatch", tags = {"EMAssessMentMX" },  notes = "createBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emassessmentmxes/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<EMAssessMentMXDTO> emassessmentmxdtos) {
        emassessmentmxService.createBatch(emassessmentmxMapping.toDomain(emassessmentmxdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMAssessMentMX-GetDraft-all')")
    @ApiOperation(value = "GetDraft", tags = {"EMAssessMentMX" },  notes = "GetDraft")
	@RequestMapping(method = RequestMethod.GET, value = "/emassessmentmxes/getdraft")
    public ResponseEntity<EMAssessMentMXDTO> getDraft() {
        return ResponseEntity.status(HttpStatus.OK).body(emassessmentmxMapping.toDto(emassessmentmxService.getDraft(new EMAssessMentMX())));
    }

    @PreAuthorize("hasPermission(#emassessmentmx_id,'Get',{'Sql',this.emassessmentmxMapping,this.permissionDTO})")
    @ApiOperation(value = "Get", tags = {"EMAssessMentMX" },  notes = "Get")
	@RequestMapping(method = RequestMethod.GET, value = "/emassessmentmxes/{emassessmentmx_id}")
    public ResponseEntity<EMAssessMentMXDTO> get(@PathVariable("emassessmentmx_id") String emassessmentmx_id) {
        EMAssessMentMX domain = emassessmentmxService.get(emassessmentmx_id);
        EMAssessMentMXDTO dto = emassessmentmxMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMAssessMentMX-Default-all')")
	@ApiOperation(value = "fetchDEFAULT", tags = {"EMAssessMentMX" } ,notes = "fetchDEFAULT")
    @RequestMapping(method= RequestMethod.GET , value="/emassessmentmxes/fetchdefault")
	public ResponseEntity<List<EMAssessMentMXDTO>> fetchDefault(EMAssessMentMXSearchContext context) {
        Page<EMAssessMentMX> domains = emassessmentmxService.searchDefault(context) ;
        List<EMAssessMentMXDTO> list = emassessmentmxMapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMAssessMentMX-Default-all')")
	@ApiOperation(value = "searchDEFAULT", tags = {"EMAssessMentMX" } ,notes = "searchDEFAULT")
    @RequestMapping(method= RequestMethod.POST , value="/emassessmentmxes/searchdefault")
	public ResponseEntity<Page<EMAssessMentMXDTO>> searchDefault(@RequestBody EMAssessMentMXSearchContext context) {
        Page<EMAssessMentMX> domains = emassessmentmxService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emassessmentmxMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
}
