package cn.ibizlab.eam.webapi.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;
import javax.servlet.ServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import cn.ibizlab.eam.webapi.dto.*;
import cn.ibizlab.eam.webapi.mapping.*;
import cn.ibizlab.eam.core.eam_core.domain.EMACClass;
import cn.ibizlab.eam.core.eam_core.service.IEMACClassService;
import cn.ibizlab.eam.core.eam_core.filter.EMACClassSearchContext;

@Slf4j
@Api(tags = {"EMACClass" })
@RestController("WebApi-emacclass")
@RequestMapping("")
public class EMACClassResource {

    @Autowired
    private IEMACClassService emacclassService;

    @Autowired
    @Lazy
    public EMACClassMapping emacclassMapping;

    public EMACClassDTO permissionDTO=new EMACClassDTO();

    @PreAuthorize("hasPermission('','Save',{'Sql',this.emacclassMapping,#emacclassdto})")
    @ApiOperation(value = "Save", tags = {"EMACClass" },  notes = "Save")
	@RequestMapping(method = RequestMethod.POST, value = "/emacclasses/save")
    public ResponseEntity<Boolean> save(@RequestBody EMACClassDTO emacclassdto) {
        return ResponseEntity.status(HttpStatus.OK).body(emacclassService.save(emacclassMapping.toDomain(emacclassdto)));
    }

    @PreAuthorize("hasPermission('Save',{'Sql',this.emacclassMapping,#emacclassdtos})")
    @ApiOperation(value = "SaveBatch", tags = {"EMACClass" },  notes = "SaveBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emacclasses/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<EMACClassDTO> emacclassdtos) {
        emacclassService.saveBatch(emacclassMapping.toDomain(emacclassdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMACClass-GetDraft-all')")
    @ApiOperation(value = "GetDraft", tags = {"EMACClass" },  notes = "GetDraft")
	@RequestMapping(method = RequestMethod.GET, value = "/emacclasses/getdraft")
    public ResponseEntity<EMACClassDTO> getDraft() {
        return ResponseEntity.status(HttpStatus.OK).body(emacclassMapping.toDto(emacclassService.getDraft(new EMACClass())));
    }

    @PreAuthorize("hasPermission('','Create',{'Sql',this.emacclassMapping,#emacclassdto})")
    @ApiOperation(value = "Create", tags = {"EMACClass" },  notes = "Create")
	@RequestMapping(method = RequestMethod.POST, value = "/emacclasses")
    @Transactional
    public ResponseEntity<EMACClassDTO> create(@RequestBody EMACClassDTO emacclassdto) {
        EMACClass domain = emacclassMapping.toDomain(emacclassdto);
		emacclassService.create(domain);
        EMACClassDTO dto = emacclassMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Create',{'Sql',this.emacclassMapping,#emacclassdtos})")
    @ApiOperation(value = "createBatch", tags = {"EMACClass" },  notes = "createBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emacclasses/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<EMACClassDTO> emacclassdtos) {
        emacclassService.createBatch(emacclassMapping.toDomain(emacclassdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(#emacclass_id,'Get',{'Sql',this.emacclassMapping,this.permissionDTO})")
    @ApiOperation(value = "Get", tags = {"EMACClass" },  notes = "Get")
	@RequestMapping(method = RequestMethod.GET, value = "/emacclasses/{emacclass_id}")
    public ResponseEntity<EMACClassDTO> get(@PathVariable("emacclass_id") String emacclass_id) {
        EMACClass domain = emacclassService.get(emacclass_id);
        EMACClassDTO dto = emacclassMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(#emacclass_id,'Remove',{'Sql',this.emacclassMapping,this.permissionDTO})")
    @ApiOperation(value = "Remove", tags = {"EMACClass" },  notes = "Remove")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emacclasses/{emacclass_id}")
    @Transactional
    public ResponseEntity<Boolean> remove(@PathVariable("emacclass_id") String emacclass_id) {
         return ResponseEntity.status(HttpStatus.OK).body(emacclassService.remove(emacclass_id));
    }

    @PreAuthorize("hasPermission('Remove',{'Sql',this.emacclassMapping,this.permissionDTO,#ids})")
    @ApiOperation(value = "RemoveBatch", tags = {"EMACClass" },  notes = "RemoveBatch")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emacclasses/batch")
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        emacclassService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMACClass-CheckKey-all')")
    @ApiOperation(value = "CheckKey", tags = {"EMACClass" },  notes = "CheckKey")
	@RequestMapping(method = RequestMethod.POST, value = "/emacclasses/checkkey")
    public ResponseEntity<Boolean> checkKey(@RequestBody EMACClassDTO emacclassdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emacclassService.checkKey(emacclassMapping.toDomain(emacclassdto)));
    }

    @PreAuthorize("hasPermission(#emacclass_id,'Update',{'Sql',this.emacclassMapping,#emacclassdto})")
    @ApiOperation(value = "Update", tags = {"EMACClass" },  notes = "Update")
	@RequestMapping(method = RequestMethod.PUT, value = "/emacclasses/{emacclass_id}")
    @Transactional
    public ResponseEntity<EMACClassDTO> update(@PathVariable("emacclass_id") String emacclass_id, @RequestBody EMACClassDTO emacclassdto) {
		EMACClass domain  = emacclassMapping.toDomain(emacclassdto);
        domain .setEmacclassid(emacclass_id);
		emacclassService.update(domain );
		EMACClassDTO dto = emacclassMapping.toDto(domain );
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Update',{'Sql',this.emacclassMapping,#emacclassdtos})")
    @ApiOperation(value = "UpdateBatch", tags = {"EMACClass" },  notes = "UpdateBatch")
	@RequestMapping(method = RequestMethod.PUT, value = "/emacclasses/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<EMACClassDTO> emacclassdtos) {
        emacclassService.updateBatch(emacclassMapping.toDomain(emacclassdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMACClass-Default-all')")
	@ApiOperation(value = "fetchDEFAULT", tags = {"EMACClass" } ,notes = "fetchDEFAULT")
    @RequestMapping(method= RequestMethod.GET , value="/emacclasses/fetchdefault")
	public ResponseEntity<List<EMACClassDTO>> fetchDefault(EMACClassSearchContext context) {
        Page<EMACClass> domains = emacclassService.searchDefault(context) ;
        List<EMACClassDTO> list = emacclassMapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMACClass-Default-all')")
	@ApiOperation(value = "searchDEFAULT", tags = {"EMACClass" } ,notes = "searchDEFAULT")
    @RequestMapping(method= RequestMethod.POST , value="/emacclasses/searchdefault")
	public ResponseEntity<Page<EMACClassDTO>> searchDefault(@RequestBody EMACClassSearchContext context) {
        Page<EMACClass> domains = emacclassService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emacclassMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
}
