package cn.ibizlab.eam.webapi.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;
import javax.servlet.ServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import cn.ibizlab.eam.webapi.dto.*;
import cn.ibizlab.eam.webapi.mapping.*;
import cn.ibizlab.eam.core.eam_pf.domain.PFPost;
import cn.ibizlab.eam.core.eam_pf.service.IPFPostService;
import cn.ibizlab.eam.core.eam_pf.filter.PFPostSearchContext;

@Slf4j
@Api(tags = {"PFPost" })
@RestController("WebApi-pfpost")
@RequestMapping("")
public class PFPostResource {

    @Autowired
    private IPFPostService pfpostService;

    @Autowired
    @Lazy
    public PFPostMapping pfpostMapping;

    public PFPostDTO permissionDTO=new PFPostDTO();

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-PFPost-GetDraft-all')")
    @ApiOperation(value = "GetDraft", tags = {"PFPost" },  notes = "GetDraft")
	@RequestMapping(method = RequestMethod.GET, value = "/pfposts/getdraft")
    public ResponseEntity<PFPostDTO> getDraft() {
        return ResponseEntity.status(HttpStatus.OK).body(pfpostMapping.toDto(pfpostService.getDraft(new PFPost())));
    }

    @PreAuthorize("hasPermission(#pfpost_id,'Update',{'Sql',this.pfpostMapping,#pfpostdto})")
    @ApiOperation(value = "Update", tags = {"PFPost" },  notes = "Update")
	@RequestMapping(method = RequestMethod.PUT, value = "/pfposts/{pfpost_id}")
    @Transactional
    public ResponseEntity<PFPostDTO> update(@PathVariable("pfpost_id") String pfpost_id, @RequestBody PFPostDTO pfpostdto) {
		PFPost domain  = pfpostMapping.toDomain(pfpostdto);
        domain .setPfpostid(pfpost_id);
		pfpostService.update(domain );
		PFPostDTO dto = pfpostMapping.toDto(domain );
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Update',{'Sql',this.pfpostMapping,#pfpostdtos})")
    @ApiOperation(value = "UpdateBatch", tags = {"PFPost" },  notes = "UpdateBatch")
	@RequestMapping(method = RequestMethod.PUT, value = "/pfposts/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<PFPostDTO> pfpostdtos) {
        pfpostService.updateBatch(pfpostMapping.toDomain(pfpostdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(#pfpost_id,'Get',{'Sql',this.pfpostMapping,this.permissionDTO})")
    @ApiOperation(value = "Get", tags = {"PFPost" },  notes = "Get")
	@RequestMapping(method = RequestMethod.GET, value = "/pfposts/{pfpost_id}")
    public ResponseEntity<PFPostDTO> get(@PathVariable("pfpost_id") String pfpost_id) {
        PFPost domain = pfpostService.get(pfpost_id);
        PFPostDTO dto = pfpostMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(#pfpost_id,'Remove',{'Sql',this.pfpostMapping,this.permissionDTO})")
    @ApiOperation(value = "Remove", tags = {"PFPost" },  notes = "Remove")
	@RequestMapping(method = RequestMethod.DELETE, value = "/pfposts/{pfpost_id}")
    @Transactional
    public ResponseEntity<Boolean> remove(@PathVariable("pfpost_id") String pfpost_id) {
         return ResponseEntity.status(HttpStatus.OK).body(pfpostService.remove(pfpost_id));
    }

    @PreAuthorize("hasPermission('Remove',{'Sql',this.pfpostMapping,this.permissionDTO,#ids})")
    @ApiOperation(value = "RemoveBatch", tags = {"PFPost" },  notes = "RemoveBatch")
	@RequestMapping(method = RequestMethod.DELETE, value = "/pfposts/batch")
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        pfpostService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission('','Create',{'Sql',this.pfpostMapping,#pfpostdto})")
    @ApiOperation(value = "Create", tags = {"PFPost" },  notes = "Create")
	@RequestMapping(method = RequestMethod.POST, value = "/pfposts")
    @Transactional
    public ResponseEntity<PFPostDTO> create(@RequestBody PFPostDTO pfpostdto) {
        PFPost domain = pfpostMapping.toDomain(pfpostdto);
		pfpostService.create(domain);
        PFPostDTO dto = pfpostMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Create',{'Sql',this.pfpostMapping,#pfpostdtos})")
    @ApiOperation(value = "createBatch", tags = {"PFPost" },  notes = "createBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/pfposts/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<PFPostDTO> pfpostdtos) {
        pfpostService.createBatch(pfpostMapping.toDomain(pfpostdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission('','Save',{'Sql',this.pfpostMapping,#pfpostdto})")
    @ApiOperation(value = "Save", tags = {"PFPost" },  notes = "Save")
	@RequestMapping(method = RequestMethod.POST, value = "/pfposts/save")
    public ResponseEntity<Boolean> save(@RequestBody PFPostDTO pfpostdto) {
        return ResponseEntity.status(HttpStatus.OK).body(pfpostService.save(pfpostMapping.toDomain(pfpostdto)));
    }

    @PreAuthorize("hasPermission('Save',{'Sql',this.pfpostMapping,#pfpostdtos})")
    @ApiOperation(value = "SaveBatch", tags = {"PFPost" },  notes = "SaveBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/pfposts/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<PFPostDTO> pfpostdtos) {
        pfpostService.saveBatch(pfpostMapping.toDomain(pfpostdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-PFPost-CheckKey-all')")
    @ApiOperation(value = "CheckKey", tags = {"PFPost" },  notes = "CheckKey")
	@RequestMapping(method = RequestMethod.POST, value = "/pfposts/checkkey")
    public ResponseEntity<Boolean> checkKey(@RequestBody PFPostDTO pfpostdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(pfpostService.checkKey(pfpostMapping.toDomain(pfpostdto)));
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-PFPost-Default-all')")
	@ApiOperation(value = "fetchDEFAULT", tags = {"PFPost" } ,notes = "fetchDEFAULT")
    @RequestMapping(method= RequestMethod.GET , value="/pfposts/fetchdefault")
	public ResponseEntity<List<PFPostDTO>> fetchDefault(PFPostSearchContext context) {
        Page<PFPost> domains = pfpostService.searchDefault(context) ;
        List<PFPostDTO> list = pfpostMapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-PFPost-Default-all')")
	@ApiOperation(value = "searchDEFAULT", tags = {"PFPost" } ,notes = "searchDEFAULT")
    @RequestMapping(method= RequestMethod.POST , value="/pfposts/searchdefault")
	public ResponseEntity<Page<PFPostDTO>> searchDefault(@RequestBody PFPostSearchContext context) {
        Page<PFPost> domains = pfpostService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(pfpostMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
}
