package cn.ibizlab.eam.webapi.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;
import javax.servlet.ServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import cn.ibizlab.eam.webapi.dto.*;
import cn.ibizlab.eam.webapi.mapping.*;
import cn.ibizlab.eam.core.eam_core.domain.EMWO;
import cn.ibizlab.eam.core.eam_core.service.IEMWOService;
import cn.ibizlab.eam.core.eam_core.filter.EMWOSearchContext;

@Slf4j
@Api(tags = {"EMWO" })
@RestController("WebApi-emwo")
@RequestMapping("")
public class EMWOResource {

    @Autowired
    private IEMWOService emwoService;

    @Autowired
    @Lazy
    public EMWOMapping emwoMapping;

    public EMWODTO permissionDTO=new EMWODTO();

    @PreAuthorize("hasPermission('','Create',{'Sql',this.emwoMapping,#emwodto})")
    @ApiOperation(value = "Create", tags = {"EMWO" },  notes = "Create")
	@RequestMapping(method = RequestMethod.POST, value = "/emwos")
    @Transactional
    public ResponseEntity<EMWODTO> create(@RequestBody EMWODTO emwodto) {
        EMWO domain = emwoMapping.toDomain(emwodto);
		emwoService.create(domain);
        EMWODTO dto = emwoMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Create',{'Sql',this.emwoMapping,#emwodtos})")
    @ApiOperation(value = "createBatch", tags = {"EMWO" },  notes = "createBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emwos/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<EMWODTO> emwodtos) {
        emwoService.createBatch(emwoMapping.toDomain(emwodtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(#emwo_id,'Update',{'Sql',this.emwoMapping,#emwodto})")
    @ApiOperation(value = "Update", tags = {"EMWO" },  notes = "Update")
	@RequestMapping(method = RequestMethod.PUT, value = "/emwos/{emwo_id}")
    @Transactional
    public ResponseEntity<EMWODTO> update(@PathVariable("emwo_id") String emwo_id, @RequestBody EMWODTO emwodto) {
		EMWO domain  = emwoMapping.toDomain(emwodto);
        domain .setEmwoid(emwo_id);
		emwoService.update(domain );
		EMWODTO dto = emwoMapping.toDto(domain );
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Update',{'Sql',this.emwoMapping,#emwodtos})")
    @ApiOperation(value = "UpdateBatch", tags = {"EMWO" },  notes = "UpdateBatch")
	@RequestMapping(method = RequestMethod.PUT, value = "/emwos/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<EMWODTO> emwodtos) {
        emwoService.updateBatch(emwoMapping.toDomain(emwodtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMWO-CheckKey-all')")
    @ApiOperation(value = "CheckKey", tags = {"EMWO" },  notes = "CheckKey")
	@RequestMapping(method = RequestMethod.POST, value = "/emwos/checkkey")
    public ResponseEntity<Boolean> checkKey(@RequestBody EMWODTO emwodto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emwoService.checkKey(emwoMapping.toDomain(emwodto)));
    }

    @PreAuthorize("hasPermission(#emwo_id,'Get',{'Sql',this.emwoMapping,this.permissionDTO})")
    @ApiOperation(value = "Get", tags = {"EMWO" },  notes = "Get")
	@RequestMapping(method = RequestMethod.GET, value = "/emwos/{emwo_id}")
    public ResponseEntity<EMWODTO> get(@PathVariable("emwo_id") String emwo_id) {
        EMWO domain = emwoService.get(emwo_id);
        EMWODTO dto = emwoMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMWO-GetDraft-all')")
    @ApiOperation(value = "GetDraft", tags = {"EMWO" },  notes = "GetDraft")
	@RequestMapping(method = RequestMethod.GET, value = "/emwos/getdraft")
    public ResponseEntity<EMWODTO> getDraft() {
        return ResponseEntity.status(HttpStatus.OK).body(emwoMapping.toDto(emwoService.getDraft(new EMWO())));
    }

    @PreAuthorize("hasPermission(#emwo_id,'Remove',{'Sql',this.emwoMapping,this.permissionDTO})")
    @ApiOperation(value = "Remove", tags = {"EMWO" },  notes = "Remove")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emwos/{emwo_id}")
    @Transactional
    public ResponseEntity<Boolean> remove(@PathVariable("emwo_id") String emwo_id) {
         return ResponseEntity.status(HttpStatus.OK).body(emwoService.remove(emwo_id));
    }

    @PreAuthorize("hasPermission('Remove',{'Sql',this.emwoMapping,this.permissionDTO,#ids})")
    @ApiOperation(value = "RemoveBatch", tags = {"EMWO" },  notes = "RemoveBatch")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emwos/batch")
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        emwoService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission('','Save',{'Sql',this.emwoMapping,#emwodto})")
    @ApiOperation(value = "Save", tags = {"EMWO" },  notes = "Save")
	@RequestMapping(method = RequestMethod.POST, value = "/emwos/save")
    public ResponseEntity<Boolean> save(@RequestBody EMWODTO emwodto) {
        return ResponseEntity.status(HttpStatus.OK).body(emwoService.save(emwoMapping.toDomain(emwodto)));
    }

    @PreAuthorize("hasPermission('Save',{'Sql',this.emwoMapping,#emwodtos})")
    @ApiOperation(value = "SaveBatch", tags = {"EMWO" },  notes = "SaveBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emwos/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<EMWODTO> emwodtos) {
        emwoService.saveBatch(emwoMapping.toDomain(emwodtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMWO-LaterThreeYear-all')")
	@ApiOperation(value = "fetch近三年工单", tags = {"EMWO" } ,notes = "fetch近三年工单")
    @RequestMapping(method= RequestMethod.GET , value="/emwos/fetchlaterthreeyear")
	public ResponseEntity<List<HashMap>> fetchLaterThreeYear(EMWOSearchContext context) {
        Page<HashMap> domains = emwoService.searchLaterThreeYear(context) ;
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(domains.getContent());
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMWO-LaterThreeYear-all')")
	@ApiOperation(value = "search近三年工单", tags = {"EMWO" } ,notes = "search近三年工单")
    @RequestMapping(method= RequestMethod.POST , value="/emwos/searchlaterthreeyear")
	public ResponseEntity<Page<HashMap>> searchLaterThreeYear(@RequestBody EMWOSearchContext context) {
        Page<HashMap> domains = emwoService.searchLaterThreeYear(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(domains.getContent(), context.getPageable(), domains.getTotalElements()));
	}
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMWO-IndexDER-all')")
	@ApiOperation(value = "fetchIndexDER", tags = {"EMWO" } ,notes = "fetchIndexDER")
    @RequestMapping(method= RequestMethod.GET , value="/emwos/fetchindexder")
	public ResponseEntity<List<EMWODTO>> fetchIndexDER(EMWOSearchContext context) {
        Page<EMWO> domains = emwoService.searchIndexDER(context) ;
        List<EMWODTO> list = emwoMapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMWO-IndexDER-all')")
	@ApiOperation(value = "searchIndexDER", tags = {"EMWO" } ,notes = "searchIndexDER")
    @RequestMapping(method= RequestMethod.POST , value="/emwos/searchindexder")
	public ResponseEntity<Page<EMWODTO>> searchIndexDER(@RequestBody EMWOSearchContext context) {
        Page<EMWO> domains = emwoService.searchIndexDER(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emwoMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMWO-Default-all')")
	@ApiOperation(value = "fetchDEFAULT", tags = {"EMWO" } ,notes = "fetchDEFAULT")
    @RequestMapping(method= RequestMethod.GET , value="/emwos/fetchdefault")
	public ResponseEntity<List<EMWODTO>> fetchDefault(EMWOSearchContext context) {
        Page<EMWO> domains = emwoService.searchDefault(context) ;
        List<EMWODTO> list = emwoMapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMWO-Default-all')")
	@ApiOperation(value = "searchDEFAULT", tags = {"EMWO" } ,notes = "searchDEFAULT")
    @RequestMapping(method= RequestMethod.POST , value="/emwos/searchdefault")
	public ResponseEntity<Page<EMWODTO>> searchDefault(@RequestBody EMWOSearchContext context) {
        Page<EMWO> domains = emwoService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emwoMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMWO-WoTypeNum-all')")
	@ApiOperation(value = "fetch工单种类数量", tags = {"EMWO" } ,notes = "fetch工单种类数量")
    @RequestMapping(method= RequestMethod.GET , value="/emwos/fetchwotypenum")
	public ResponseEntity<List<HashMap>> fetchWoTypeNum(EMWOSearchContext context) {
        Page<HashMap> domains = emwoService.searchWoTypeNum(context) ;
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(domains.getContent());
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMWO-WoTypeNum-all')")
	@ApiOperation(value = "search工单种类数量", tags = {"EMWO" } ,notes = "search工单种类数量")
    @RequestMapping(method= RequestMethod.POST , value="/emwos/searchwotypenum")
	public ResponseEntity<Page<HashMap>> searchWoTypeNum(@RequestBody EMWOSearchContext context) {
        Page<HashMap> domains = emwoService.searchWoTypeNum(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(domains.getContent(), context.getPageable(), domains.getTotalElements()));
	}
    @PreAuthorize("hasPermission('','Create',{'Sql',this.emwoMapping,#emwodto})")
    @ApiOperation(value = "CreateByEMEquip", tags = {"EMWO" },  notes = "CreateByEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/emequips/{emequip_id}/emwos")
    @Transactional
    public ResponseEntity<EMWODTO> createByEMEquip(@PathVariable("emequip_id") String emequip_id, @RequestBody EMWODTO emwodto) {
        EMWO domain = emwoMapping.toDomain(emwodto);
        domain.setEquipid(emequip_id);
		emwoService.create(domain);
        EMWODTO dto = emwoMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Create',{'Sql',this.emwoMapping,#emwodtos})")
    @ApiOperation(value = "createBatchByEMEquip", tags = {"EMWO" },  notes = "createBatchByEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/emequips/{emequip_id}/emwos/batch")
    public ResponseEntity<Boolean> createBatchByEMEquip(@PathVariable("emequip_id") String emequip_id, @RequestBody List<EMWODTO> emwodtos) {
        List<EMWO> domainlist=emwoMapping.toDomain(emwodtos);
        for(EMWO domain:domainlist){
            domain.setEquipid(emequip_id);
        }
        emwoService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(#emwo_id,'Update',{'Sql',this.emwoMapping,#emwodto})")
    @ApiOperation(value = "UpdateByEMEquip", tags = {"EMWO" },  notes = "UpdateByEMEquip")
	@RequestMapping(method = RequestMethod.PUT, value = "/emequips/{emequip_id}/emwos/{emwo_id}")
    @Transactional
    public ResponseEntity<EMWODTO> updateByEMEquip(@PathVariable("emequip_id") String emequip_id, @PathVariable("emwo_id") String emwo_id, @RequestBody EMWODTO emwodto) {
        EMWO domain = emwoMapping.toDomain(emwodto);
        domain.setEquipid(emequip_id);
        domain.setEmwoid(emwo_id);
		emwoService.update(domain);
        EMWODTO dto = emwoMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Update',{'Sql',this.emwoMapping,#emwodtos})")
    @ApiOperation(value = "UpdateBatchByEMEquip", tags = {"EMWO" },  notes = "UpdateBatchByEMEquip")
	@RequestMapping(method = RequestMethod.PUT, value = "/emequips/{emequip_id}/emwos/batch")
    public ResponseEntity<Boolean> updateBatchByEMEquip(@PathVariable("emequip_id") String emequip_id, @RequestBody List<EMWODTO> emwodtos) {
        List<EMWO> domainlist=emwoMapping.toDomain(emwodtos);
        for(EMWO domain:domainlist){
            domain.setEquipid(emequip_id);
        }
        emwoService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMWO-CheckKey-all')")
    @ApiOperation(value = "CheckKeyByEMEquip", tags = {"EMWO" },  notes = "CheckKeyByEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/emequips/{emequip_id}/emwos/checkkey")
    public ResponseEntity<Boolean> checkKeyByEMEquip(@PathVariable("emequip_id") String emequip_id, @RequestBody EMWODTO emwodto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emwoService.checkKey(emwoMapping.toDomain(emwodto)));
    }

    @PreAuthorize("hasPermission(#emwo_id,'Get',{'Sql',this.emwoMapping,this.permissionDTO})")
    @ApiOperation(value = "GetByEMEquip", tags = {"EMWO" },  notes = "GetByEMEquip")
	@RequestMapping(method = RequestMethod.GET, value = "/emequips/{emequip_id}/emwos/{emwo_id}")
    public ResponseEntity<EMWODTO> getByEMEquip(@PathVariable("emequip_id") String emequip_id, @PathVariable("emwo_id") String emwo_id) {
        EMWO domain = emwoService.get(emwo_id);
        EMWODTO dto = emwoMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMWO-GetDraft-all')")
    @ApiOperation(value = "GetDraftByEMEquip", tags = {"EMWO" },  notes = "GetDraftByEMEquip")
    @RequestMapping(method = RequestMethod.GET, value = "/emequips/{emequip_id}/emwos/getdraft")
    public ResponseEntity<EMWODTO> getDraftByEMEquip(@PathVariable("emequip_id") String emequip_id) {
        EMWO domain = new EMWO();
        domain.setEquipid(emequip_id);
        return ResponseEntity.status(HttpStatus.OK).body(emwoMapping.toDto(emwoService.getDraft(domain)));
    }

    @PreAuthorize("hasPermission(#emwo_id,'Remove',{'Sql',this.emwoMapping,this.permissionDTO})")
    @ApiOperation(value = "RemoveByEMEquip", tags = {"EMWO" },  notes = "RemoveByEMEquip")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emequips/{emequip_id}/emwos/{emwo_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByEMEquip(@PathVariable("emequip_id") String emequip_id, @PathVariable("emwo_id") String emwo_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emwoService.remove(emwo_id));
    }

    @PreAuthorize("hasPermission('Remove',{'Sql',this.emwoMapping,this.permissionDTO,#ids})")
    @ApiOperation(value = "RemoveBatchByEMEquip", tags = {"EMWO" },  notes = "RemoveBatchByEMEquip")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emequips/{emequip_id}/emwos/batch")
    public ResponseEntity<Boolean> removeBatchByEMEquip(@RequestBody List<String> ids) {
        emwoService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission('','Save',{'Sql',this.emwoMapping,#emwodto})")
    @ApiOperation(value = "SaveByEMEquip", tags = {"EMWO" },  notes = "SaveByEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/emequips/{emequip_id}/emwos/save")
    public ResponseEntity<Boolean> saveByEMEquip(@PathVariable("emequip_id") String emequip_id, @RequestBody EMWODTO emwodto) {
        EMWO domain = emwoMapping.toDomain(emwodto);
        domain.setEquipid(emequip_id);
        return ResponseEntity.status(HttpStatus.OK).body(emwoService.save(domain));
    }

    @PreAuthorize("hasPermission('Save',{'Sql',this.emwoMapping,#emwodtos})")
    @ApiOperation(value = "SaveBatchByEMEquip", tags = {"EMWO" },  notes = "SaveBatchByEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/emequips/{emequip_id}/emwos/savebatch")
    public ResponseEntity<Boolean> saveBatchByEMEquip(@PathVariable("emequip_id") String emequip_id, @RequestBody List<EMWODTO> emwodtos) {
        List<EMWO> domainlist=emwoMapping.toDomain(emwodtos);
        for(EMWO domain:domainlist){
             domain.setEquipid(emequip_id);
        }
        emwoService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMWO-LaterThreeYear-all')")
	@ApiOperation(value = "fetch近三年工单ByEMEquip", tags = {"EMWO" } ,notes = "fetch近三年工单ByEMEquip")
    @RequestMapping(method= RequestMethod.GET , value="/emequips/{emequip_id}/emwos/fetchlaterthreeyear")
	public ResponseEntity<List<HashMap>> fetchEMWOLaterThreeYearByEMEquip(@PathVariable("emequip_id") String emequip_id,EMWOSearchContext context) {
        context.setN_equipid_eq(emequip_id);
        Page<HashMap> domains = emwoService.searchLaterThreeYear(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(domains.getContent());
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMWO-LaterThreeYear-all')")
	@ApiOperation(value = "search近三年工单ByEMEquip", tags = {"EMWO" } ,notes = "search近三年工单ByEMEquip")
    @RequestMapping(method= RequestMethod.POST , value="/emequips/{emequip_id}/emwos/searchlaterthreeyear")
	public ResponseEntity<Page<HashMap>> searchEMWOLaterThreeYearByEMEquip(@PathVariable("emequip_id") String emequip_id, @RequestBody EMWOSearchContext context) {
        context.setN_equipid_eq(emequip_id);
        Page<HashMap> domains = emwoService.searchLaterThreeYear(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(domains.getContent(), context.getPageable(), domains.getTotalElements()));
	}
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMWO-IndexDER-all')")
	@ApiOperation(value = "fetchIndexDERByEMEquip", tags = {"EMWO" } ,notes = "fetchIndexDERByEMEquip")
    @RequestMapping(method= RequestMethod.GET , value="/emequips/{emequip_id}/emwos/fetchindexder")
	public ResponseEntity<List<EMWODTO>> fetchEMWOIndexDERByEMEquip(@PathVariable("emequip_id") String emequip_id,EMWOSearchContext context) {
        context.setN_equipid_eq(emequip_id);
        Page<EMWO> domains = emwoService.searchIndexDER(context) ;
        List<EMWODTO> list = emwoMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMWO-IndexDER-all')")
	@ApiOperation(value = "searchIndexDERByEMEquip", tags = {"EMWO" } ,notes = "searchIndexDERByEMEquip")
    @RequestMapping(method= RequestMethod.POST , value="/emequips/{emequip_id}/emwos/searchindexder")
	public ResponseEntity<Page<EMWODTO>> searchEMWOIndexDERByEMEquip(@PathVariable("emequip_id") String emequip_id, @RequestBody EMWOSearchContext context) {
        context.setN_equipid_eq(emequip_id);
        Page<EMWO> domains = emwoService.searchIndexDER(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emwoMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMWO-Default-all')")
	@ApiOperation(value = "fetchDEFAULTByEMEquip", tags = {"EMWO" } ,notes = "fetchDEFAULTByEMEquip")
    @RequestMapping(method= RequestMethod.GET , value="/emequips/{emequip_id}/emwos/fetchdefault")
	public ResponseEntity<List<EMWODTO>> fetchEMWODefaultByEMEquip(@PathVariable("emequip_id") String emequip_id,EMWOSearchContext context) {
        context.setN_equipid_eq(emequip_id);
        Page<EMWO> domains = emwoService.searchDefault(context) ;
        List<EMWODTO> list = emwoMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMWO-Default-all')")
	@ApiOperation(value = "searchDEFAULTByEMEquip", tags = {"EMWO" } ,notes = "searchDEFAULTByEMEquip")
    @RequestMapping(method= RequestMethod.POST , value="/emequips/{emequip_id}/emwos/searchdefault")
	public ResponseEntity<Page<EMWODTO>> searchEMWODefaultByEMEquip(@PathVariable("emequip_id") String emequip_id, @RequestBody EMWOSearchContext context) {
        context.setN_equipid_eq(emequip_id);
        Page<EMWO> domains = emwoService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emwoMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMWO-WoTypeNum-all')")
	@ApiOperation(value = "fetch工单种类数量ByEMEquip", tags = {"EMWO" } ,notes = "fetch工单种类数量ByEMEquip")
    @RequestMapping(method= RequestMethod.GET , value="/emequips/{emequip_id}/emwos/fetchwotypenum")
	public ResponseEntity<List<HashMap>> fetchEMWOWoTypeNumByEMEquip(@PathVariable("emequip_id") String emequip_id,EMWOSearchContext context) {
        context.setN_equipid_eq(emequip_id);
        Page<HashMap> domains = emwoService.searchWoTypeNum(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(domains.getContent());
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMWO-WoTypeNum-all')")
	@ApiOperation(value = "search工单种类数量ByEMEquip", tags = {"EMWO" } ,notes = "search工单种类数量ByEMEquip")
    @RequestMapping(method= RequestMethod.POST , value="/emequips/{emequip_id}/emwos/searchwotypenum")
	public ResponseEntity<Page<HashMap>> searchEMWOWoTypeNumByEMEquip(@PathVariable("emequip_id") String emequip_id, @RequestBody EMWOSearchContext context) {
        context.setN_equipid_eq(emequip_id);
        Page<HashMap> domains = emwoService.searchWoTypeNum(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(domains.getContent(), context.getPageable(), domains.getTotalElements()));
	}
    @PreAuthorize("hasPermission('','Create',{'Sql',this.emwoMapping,#emwodto})")
    @ApiOperation(value = "CreateByEMEQTypeEMEquip", tags = {"EMWO" },  notes = "CreateByEMEQTypeEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emwos")
    @Transactional
    public ResponseEntity<EMWODTO> createByEMEQTypeEMEquip(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id, @RequestBody EMWODTO emwodto) {
        EMWO domain = emwoMapping.toDomain(emwodto);
        domain.setEquipid(emequip_id);
		emwoService.create(domain);
        EMWODTO dto = emwoMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Create',{'Sql',this.emwoMapping,#emwodtos})")
    @ApiOperation(value = "createBatchByEMEQTypeEMEquip", tags = {"EMWO" },  notes = "createBatchByEMEQTypeEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emwos/batch")
    public ResponseEntity<Boolean> createBatchByEMEQTypeEMEquip(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id, @RequestBody List<EMWODTO> emwodtos) {
        List<EMWO> domainlist=emwoMapping.toDomain(emwodtos);
        for(EMWO domain:domainlist){
            domain.setEquipid(emequip_id);
        }
        emwoService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(#emwo_id,'Update',{'Sql',this.emwoMapping,#emwodto})")
    @ApiOperation(value = "UpdateByEMEQTypeEMEquip", tags = {"EMWO" },  notes = "UpdateByEMEQTypeEMEquip")
	@RequestMapping(method = RequestMethod.PUT, value = "/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emwos/{emwo_id}")
    @Transactional
    public ResponseEntity<EMWODTO> updateByEMEQTypeEMEquip(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id, @PathVariable("emwo_id") String emwo_id, @RequestBody EMWODTO emwodto) {
        EMWO domain = emwoMapping.toDomain(emwodto);
        domain.setEquipid(emequip_id);
        domain.setEmwoid(emwo_id);
		emwoService.update(domain);
        EMWODTO dto = emwoMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Update',{'Sql',this.emwoMapping,#emwodtos})")
    @ApiOperation(value = "UpdateBatchByEMEQTypeEMEquip", tags = {"EMWO" },  notes = "UpdateBatchByEMEQTypeEMEquip")
	@RequestMapping(method = RequestMethod.PUT, value = "/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emwos/batch")
    public ResponseEntity<Boolean> updateBatchByEMEQTypeEMEquip(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id, @RequestBody List<EMWODTO> emwodtos) {
        List<EMWO> domainlist=emwoMapping.toDomain(emwodtos);
        for(EMWO domain:domainlist){
            domain.setEquipid(emequip_id);
        }
        emwoService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMWO-CheckKey-all')")
    @ApiOperation(value = "CheckKeyByEMEQTypeEMEquip", tags = {"EMWO" },  notes = "CheckKeyByEMEQTypeEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emwos/checkkey")
    public ResponseEntity<Boolean> checkKeyByEMEQTypeEMEquip(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id, @RequestBody EMWODTO emwodto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emwoService.checkKey(emwoMapping.toDomain(emwodto)));
    }

    @PreAuthorize("hasPermission(#emwo_id,'Get',{'Sql',this.emwoMapping,this.permissionDTO})")
    @ApiOperation(value = "GetByEMEQTypeEMEquip", tags = {"EMWO" },  notes = "GetByEMEQTypeEMEquip")
	@RequestMapping(method = RequestMethod.GET, value = "/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emwos/{emwo_id}")
    public ResponseEntity<EMWODTO> getByEMEQTypeEMEquip(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id, @PathVariable("emwo_id") String emwo_id) {
        EMWO domain = emwoService.get(emwo_id);
        EMWODTO dto = emwoMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMWO-GetDraft-all')")
    @ApiOperation(value = "GetDraftByEMEQTypeEMEquip", tags = {"EMWO" },  notes = "GetDraftByEMEQTypeEMEquip")
    @RequestMapping(method = RequestMethod.GET, value = "/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emwos/getdraft")
    public ResponseEntity<EMWODTO> getDraftByEMEQTypeEMEquip(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id) {
        EMWO domain = new EMWO();
        domain.setEquipid(emequip_id);
        return ResponseEntity.status(HttpStatus.OK).body(emwoMapping.toDto(emwoService.getDraft(domain)));
    }

    @PreAuthorize("hasPermission(#emwo_id,'Remove',{'Sql',this.emwoMapping,this.permissionDTO})")
    @ApiOperation(value = "RemoveByEMEQTypeEMEquip", tags = {"EMWO" },  notes = "RemoveByEMEQTypeEMEquip")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emwos/{emwo_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByEMEQTypeEMEquip(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id, @PathVariable("emwo_id") String emwo_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emwoService.remove(emwo_id));
    }

    @PreAuthorize("hasPermission('Remove',{'Sql',this.emwoMapping,this.permissionDTO,#ids})")
    @ApiOperation(value = "RemoveBatchByEMEQTypeEMEquip", tags = {"EMWO" },  notes = "RemoveBatchByEMEQTypeEMEquip")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emwos/batch")
    public ResponseEntity<Boolean> removeBatchByEMEQTypeEMEquip(@RequestBody List<String> ids) {
        emwoService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission('','Save',{'Sql',this.emwoMapping,#emwodto})")
    @ApiOperation(value = "SaveByEMEQTypeEMEquip", tags = {"EMWO" },  notes = "SaveByEMEQTypeEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emwos/save")
    public ResponseEntity<Boolean> saveByEMEQTypeEMEquip(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id, @RequestBody EMWODTO emwodto) {
        EMWO domain = emwoMapping.toDomain(emwodto);
        domain.setEquipid(emequip_id);
        return ResponseEntity.status(HttpStatus.OK).body(emwoService.save(domain));
    }

    @PreAuthorize("hasPermission('Save',{'Sql',this.emwoMapping,#emwodtos})")
    @ApiOperation(value = "SaveBatchByEMEQTypeEMEquip", tags = {"EMWO" },  notes = "SaveBatchByEMEQTypeEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emwos/savebatch")
    public ResponseEntity<Boolean> saveBatchByEMEQTypeEMEquip(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id, @RequestBody List<EMWODTO> emwodtos) {
        List<EMWO> domainlist=emwoMapping.toDomain(emwodtos);
        for(EMWO domain:domainlist){
             domain.setEquipid(emequip_id);
        }
        emwoService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMWO-LaterThreeYear-all')")
	@ApiOperation(value = "fetch近三年工单ByEMEQTypeEMEquip", tags = {"EMWO" } ,notes = "fetch近三年工单ByEMEQTypeEMEquip")
    @RequestMapping(method= RequestMethod.GET , value="/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emwos/fetchlaterthreeyear")
	public ResponseEntity<List<HashMap>> fetchEMWOLaterThreeYearByEMEQTypeEMEquip(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id,EMWOSearchContext context) {
        context.setN_equipid_eq(emequip_id);
        Page<HashMap> domains = emwoService.searchLaterThreeYear(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(domains.getContent());
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMWO-LaterThreeYear-all')")
	@ApiOperation(value = "search近三年工单ByEMEQTypeEMEquip", tags = {"EMWO" } ,notes = "search近三年工单ByEMEQTypeEMEquip")
    @RequestMapping(method= RequestMethod.POST , value="/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emwos/searchlaterthreeyear")
	public ResponseEntity<Page<HashMap>> searchEMWOLaterThreeYearByEMEQTypeEMEquip(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id, @RequestBody EMWOSearchContext context) {
        context.setN_equipid_eq(emequip_id);
        Page<HashMap> domains = emwoService.searchLaterThreeYear(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(domains.getContent(), context.getPageable(), domains.getTotalElements()));
	}
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMWO-IndexDER-all')")
	@ApiOperation(value = "fetchIndexDERByEMEQTypeEMEquip", tags = {"EMWO" } ,notes = "fetchIndexDERByEMEQTypeEMEquip")
    @RequestMapping(method= RequestMethod.GET , value="/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emwos/fetchindexder")
	public ResponseEntity<List<EMWODTO>> fetchEMWOIndexDERByEMEQTypeEMEquip(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id,EMWOSearchContext context) {
        context.setN_equipid_eq(emequip_id);
        Page<EMWO> domains = emwoService.searchIndexDER(context) ;
        List<EMWODTO> list = emwoMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMWO-IndexDER-all')")
	@ApiOperation(value = "searchIndexDERByEMEQTypeEMEquip", tags = {"EMWO" } ,notes = "searchIndexDERByEMEQTypeEMEquip")
    @RequestMapping(method= RequestMethod.POST , value="/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emwos/searchindexder")
	public ResponseEntity<Page<EMWODTO>> searchEMWOIndexDERByEMEQTypeEMEquip(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id, @RequestBody EMWOSearchContext context) {
        context.setN_equipid_eq(emequip_id);
        Page<EMWO> domains = emwoService.searchIndexDER(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emwoMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMWO-Default-all')")
	@ApiOperation(value = "fetchDEFAULTByEMEQTypeEMEquip", tags = {"EMWO" } ,notes = "fetchDEFAULTByEMEQTypeEMEquip")
    @RequestMapping(method= RequestMethod.GET , value="/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emwos/fetchdefault")
	public ResponseEntity<List<EMWODTO>> fetchEMWODefaultByEMEQTypeEMEquip(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id,EMWOSearchContext context) {
        context.setN_equipid_eq(emequip_id);
        Page<EMWO> domains = emwoService.searchDefault(context) ;
        List<EMWODTO> list = emwoMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMWO-Default-all')")
	@ApiOperation(value = "searchDEFAULTByEMEQTypeEMEquip", tags = {"EMWO" } ,notes = "searchDEFAULTByEMEQTypeEMEquip")
    @RequestMapping(method= RequestMethod.POST , value="/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emwos/searchdefault")
	public ResponseEntity<Page<EMWODTO>> searchEMWODefaultByEMEQTypeEMEquip(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id, @RequestBody EMWOSearchContext context) {
        context.setN_equipid_eq(emequip_id);
        Page<EMWO> domains = emwoService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emwoMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMWO-WoTypeNum-all')")
	@ApiOperation(value = "fetch工单种类数量ByEMEQTypeEMEquip", tags = {"EMWO" } ,notes = "fetch工单种类数量ByEMEQTypeEMEquip")
    @RequestMapping(method= RequestMethod.GET , value="/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emwos/fetchwotypenum")
	public ResponseEntity<List<HashMap>> fetchEMWOWoTypeNumByEMEQTypeEMEquip(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id,EMWOSearchContext context) {
        context.setN_equipid_eq(emequip_id);
        Page<HashMap> domains = emwoService.searchWoTypeNum(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(domains.getContent());
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMWO-WoTypeNum-all')")
	@ApiOperation(value = "search工单种类数量ByEMEQTypeEMEquip", tags = {"EMWO" } ,notes = "search工单种类数量ByEMEQTypeEMEquip")
    @RequestMapping(method= RequestMethod.POST , value="/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emwos/searchwotypenum")
	public ResponseEntity<Page<HashMap>> searchEMWOWoTypeNumByEMEQTypeEMEquip(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id, @RequestBody EMWOSearchContext context) {
        context.setN_equipid_eq(emequip_id);
        Page<HashMap> domains = emwoService.searchWoTypeNum(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(domains.getContent(), context.getPageable(), domains.getTotalElements()));
	}
    @PreAuthorize("hasPermission('','Create',{'Sql',this.emwoMapping,#emwodto})")
    @ApiOperation(value = "CreateByPFTeamEMEquip", tags = {"EMWO" },  notes = "CreateByPFTeamEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/pfteams/{pfteam_id}/emequips/{emequip_id}/emwos")
    @Transactional
    public ResponseEntity<EMWODTO> createByPFTeamEMEquip(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id, @RequestBody EMWODTO emwodto) {
        EMWO domain = emwoMapping.toDomain(emwodto);
        domain.setEquipid(emequip_id);
		emwoService.create(domain);
        EMWODTO dto = emwoMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Create',{'Sql',this.emwoMapping,#emwodtos})")
    @ApiOperation(value = "createBatchByPFTeamEMEquip", tags = {"EMWO" },  notes = "createBatchByPFTeamEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/pfteams/{pfteam_id}/emequips/{emequip_id}/emwos/batch")
    public ResponseEntity<Boolean> createBatchByPFTeamEMEquip(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id, @RequestBody List<EMWODTO> emwodtos) {
        List<EMWO> domainlist=emwoMapping.toDomain(emwodtos);
        for(EMWO domain:domainlist){
            domain.setEquipid(emequip_id);
        }
        emwoService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(#emwo_id,'Update',{'Sql',this.emwoMapping,#emwodto})")
    @ApiOperation(value = "UpdateByPFTeamEMEquip", tags = {"EMWO" },  notes = "UpdateByPFTeamEMEquip")
	@RequestMapping(method = RequestMethod.PUT, value = "/pfteams/{pfteam_id}/emequips/{emequip_id}/emwos/{emwo_id}")
    @Transactional
    public ResponseEntity<EMWODTO> updateByPFTeamEMEquip(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id, @PathVariable("emwo_id") String emwo_id, @RequestBody EMWODTO emwodto) {
        EMWO domain = emwoMapping.toDomain(emwodto);
        domain.setEquipid(emequip_id);
        domain.setEmwoid(emwo_id);
		emwoService.update(domain);
        EMWODTO dto = emwoMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Update',{'Sql',this.emwoMapping,#emwodtos})")
    @ApiOperation(value = "UpdateBatchByPFTeamEMEquip", tags = {"EMWO" },  notes = "UpdateBatchByPFTeamEMEquip")
	@RequestMapping(method = RequestMethod.PUT, value = "/pfteams/{pfteam_id}/emequips/{emequip_id}/emwos/batch")
    public ResponseEntity<Boolean> updateBatchByPFTeamEMEquip(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id, @RequestBody List<EMWODTO> emwodtos) {
        List<EMWO> domainlist=emwoMapping.toDomain(emwodtos);
        for(EMWO domain:domainlist){
            domain.setEquipid(emequip_id);
        }
        emwoService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMWO-CheckKey-all')")
    @ApiOperation(value = "CheckKeyByPFTeamEMEquip", tags = {"EMWO" },  notes = "CheckKeyByPFTeamEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/pfteams/{pfteam_id}/emequips/{emequip_id}/emwos/checkkey")
    public ResponseEntity<Boolean> checkKeyByPFTeamEMEquip(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id, @RequestBody EMWODTO emwodto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emwoService.checkKey(emwoMapping.toDomain(emwodto)));
    }

    @PreAuthorize("hasPermission(#emwo_id,'Get',{'Sql',this.emwoMapping,this.permissionDTO})")
    @ApiOperation(value = "GetByPFTeamEMEquip", tags = {"EMWO" },  notes = "GetByPFTeamEMEquip")
	@RequestMapping(method = RequestMethod.GET, value = "/pfteams/{pfteam_id}/emequips/{emequip_id}/emwos/{emwo_id}")
    public ResponseEntity<EMWODTO> getByPFTeamEMEquip(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id, @PathVariable("emwo_id") String emwo_id) {
        EMWO domain = emwoService.get(emwo_id);
        EMWODTO dto = emwoMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMWO-GetDraft-all')")
    @ApiOperation(value = "GetDraftByPFTeamEMEquip", tags = {"EMWO" },  notes = "GetDraftByPFTeamEMEquip")
    @RequestMapping(method = RequestMethod.GET, value = "/pfteams/{pfteam_id}/emequips/{emequip_id}/emwos/getdraft")
    public ResponseEntity<EMWODTO> getDraftByPFTeamEMEquip(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id) {
        EMWO domain = new EMWO();
        domain.setEquipid(emequip_id);
        return ResponseEntity.status(HttpStatus.OK).body(emwoMapping.toDto(emwoService.getDraft(domain)));
    }

    @PreAuthorize("hasPermission(#emwo_id,'Remove',{'Sql',this.emwoMapping,this.permissionDTO})")
    @ApiOperation(value = "RemoveByPFTeamEMEquip", tags = {"EMWO" },  notes = "RemoveByPFTeamEMEquip")
	@RequestMapping(method = RequestMethod.DELETE, value = "/pfteams/{pfteam_id}/emequips/{emequip_id}/emwos/{emwo_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByPFTeamEMEquip(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id, @PathVariable("emwo_id") String emwo_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emwoService.remove(emwo_id));
    }

    @PreAuthorize("hasPermission('Remove',{'Sql',this.emwoMapping,this.permissionDTO,#ids})")
    @ApiOperation(value = "RemoveBatchByPFTeamEMEquip", tags = {"EMWO" },  notes = "RemoveBatchByPFTeamEMEquip")
	@RequestMapping(method = RequestMethod.DELETE, value = "/pfteams/{pfteam_id}/emequips/{emequip_id}/emwos/batch")
    public ResponseEntity<Boolean> removeBatchByPFTeamEMEquip(@RequestBody List<String> ids) {
        emwoService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission('','Save',{'Sql',this.emwoMapping,#emwodto})")
    @ApiOperation(value = "SaveByPFTeamEMEquip", tags = {"EMWO" },  notes = "SaveByPFTeamEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/pfteams/{pfteam_id}/emequips/{emequip_id}/emwos/save")
    public ResponseEntity<Boolean> saveByPFTeamEMEquip(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id, @RequestBody EMWODTO emwodto) {
        EMWO domain = emwoMapping.toDomain(emwodto);
        domain.setEquipid(emequip_id);
        return ResponseEntity.status(HttpStatus.OK).body(emwoService.save(domain));
    }

    @PreAuthorize("hasPermission('Save',{'Sql',this.emwoMapping,#emwodtos})")
    @ApiOperation(value = "SaveBatchByPFTeamEMEquip", tags = {"EMWO" },  notes = "SaveBatchByPFTeamEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/pfteams/{pfteam_id}/emequips/{emequip_id}/emwos/savebatch")
    public ResponseEntity<Boolean> saveBatchByPFTeamEMEquip(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id, @RequestBody List<EMWODTO> emwodtos) {
        List<EMWO> domainlist=emwoMapping.toDomain(emwodtos);
        for(EMWO domain:domainlist){
             domain.setEquipid(emequip_id);
        }
        emwoService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMWO-LaterThreeYear-all')")
	@ApiOperation(value = "fetch近三年工单ByPFTeamEMEquip", tags = {"EMWO" } ,notes = "fetch近三年工单ByPFTeamEMEquip")
    @RequestMapping(method= RequestMethod.GET , value="/pfteams/{pfteam_id}/emequips/{emequip_id}/emwos/fetchlaterthreeyear")
	public ResponseEntity<List<HashMap>> fetchEMWOLaterThreeYearByPFTeamEMEquip(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id,EMWOSearchContext context) {
        context.setN_equipid_eq(emequip_id);
        Page<HashMap> domains = emwoService.searchLaterThreeYear(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(domains.getContent());
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMWO-LaterThreeYear-all')")
	@ApiOperation(value = "search近三年工单ByPFTeamEMEquip", tags = {"EMWO" } ,notes = "search近三年工单ByPFTeamEMEquip")
    @RequestMapping(method= RequestMethod.POST , value="/pfteams/{pfteam_id}/emequips/{emequip_id}/emwos/searchlaterthreeyear")
	public ResponseEntity<Page<HashMap>> searchEMWOLaterThreeYearByPFTeamEMEquip(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id, @RequestBody EMWOSearchContext context) {
        context.setN_equipid_eq(emequip_id);
        Page<HashMap> domains = emwoService.searchLaterThreeYear(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(domains.getContent(), context.getPageable(), domains.getTotalElements()));
	}
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMWO-IndexDER-all')")
	@ApiOperation(value = "fetchIndexDERByPFTeamEMEquip", tags = {"EMWO" } ,notes = "fetchIndexDERByPFTeamEMEquip")
    @RequestMapping(method= RequestMethod.GET , value="/pfteams/{pfteam_id}/emequips/{emequip_id}/emwos/fetchindexder")
	public ResponseEntity<List<EMWODTO>> fetchEMWOIndexDERByPFTeamEMEquip(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id,EMWOSearchContext context) {
        context.setN_equipid_eq(emequip_id);
        Page<EMWO> domains = emwoService.searchIndexDER(context) ;
        List<EMWODTO> list = emwoMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMWO-IndexDER-all')")
	@ApiOperation(value = "searchIndexDERByPFTeamEMEquip", tags = {"EMWO" } ,notes = "searchIndexDERByPFTeamEMEquip")
    @RequestMapping(method= RequestMethod.POST , value="/pfteams/{pfteam_id}/emequips/{emequip_id}/emwos/searchindexder")
	public ResponseEntity<Page<EMWODTO>> searchEMWOIndexDERByPFTeamEMEquip(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id, @RequestBody EMWOSearchContext context) {
        context.setN_equipid_eq(emequip_id);
        Page<EMWO> domains = emwoService.searchIndexDER(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emwoMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMWO-Default-all')")
	@ApiOperation(value = "fetchDEFAULTByPFTeamEMEquip", tags = {"EMWO" } ,notes = "fetchDEFAULTByPFTeamEMEquip")
    @RequestMapping(method= RequestMethod.GET , value="/pfteams/{pfteam_id}/emequips/{emequip_id}/emwos/fetchdefault")
	public ResponseEntity<List<EMWODTO>> fetchEMWODefaultByPFTeamEMEquip(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id,EMWOSearchContext context) {
        context.setN_equipid_eq(emequip_id);
        Page<EMWO> domains = emwoService.searchDefault(context) ;
        List<EMWODTO> list = emwoMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMWO-Default-all')")
	@ApiOperation(value = "searchDEFAULTByPFTeamEMEquip", tags = {"EMWO" } ,notes = "searchDEFAULTByPFTeamEMEquip")
    @RequestMapping(method= RequestMethod.POST , value="/pfteams/{pfteam_id}/emequips/{emequip_id}/emwos/searchdefault")
	public ResponseEntity<Page<EMWODTO>> searchEMWODefaultByPFTeamEMEquip(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id, @RequestBody EMWOSearchContext context) {
        context.setN_equipid_eq(emequip_id);
        Page<EMWO> domains = emwoService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emwoMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMWO-WoTypeNum-all')")
	@ApiOperation(value = "fetch工单种类数量ByPFTeamEMEquip", tags = {"EMWO" } ,notes = "fetch工单种类数量ByPFTeamEMEquip")
    @RequestMapping(method= RequestMethod.GET , value="/pfteams/{pfteam_id}/emequips/{emequip_id}/emwos/fetchwotypenum")
	public ResponseEntity<List<HashMap>> fetchEMWOWoTypeNumByPFTeamEMEquip(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id,EMWOSearchContext context) {
        context.setN_equipid_eq(emequip_id);
        Page<HashMap> domains = emwoService.searchWoTypeNum(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(domains.getContent());
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMWO-WoTypeNum-all')")
	@ApiOperation(value = "search工单种类数量ByPFTeamEMEquip", tags = {"EMWO" } ,notes = "search工单种类数量ByPFTeamEMEquip")
    @RequestMapping(method= RequestMethod.POST , value="/pfteams/{pfteam_id}/emequips/{emequip_id}/emwos/searchwotypenum")
	public ResponseEntity<Page<HashMap>> searchEMWOWoTypeNumByPFTeamEMEquip(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id, @RequestBody EMWOSearchContext context) {
        context.setN_equipid_eq(emequip_id);
        Page<HashMap> domains = emwoService.searchWoTypeNum(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(domains.getContent(), context.getPageable(), domains.getTotalElements()));
	}
}
