package cn.ibizlab.eam.webapi.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;
import javax.servlet.ServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import cn.ibizlab.eam.webapi.dto.*;
import cn.ibizlab.eam.webapi.mapping.*;
import cn.ibizlab.eam.core.eam_core.domain.EMSysCtrl;
import cn.ibizlab.eam.core.eam_core.service.IEMSysCtrlService;
import cn.ibizlab.eam.core.eam_core.filter.EMSysCtrlSearchContext;

@Slf4j
@Api(tags = {"EMSysCtrl" })
@RestController("WebApi-emsysctrl")
@RequestMapping("")
public class EMSysCtrlResource {

    @Autowired
    private IEMSysCtrlService emsysctrlService;

    @Autowired
    @Lazy
    public EMSysCtrlMapping emsysctrlMapping;

    public EMSysCtrlDTO permissionDTO=new EMSysCtrlDTO();

    @PreAuthorize("hasPermission('','Create',{'Sql',this.emsysctrlMapping,#emsysctrldto})")
    @ApiOperation(value = "Create", tags = {"EMSysCtrl" },  notes = "Create")
	@RequestMapping(method = RequestMethod.POST, value = "/emsysctrls")
    @Transactional
    public ResponseEntity<EMSysCtrlDTO> create(@RequestBody EMSysCtrlDTO emsysctrldto) {
        EMSysCtrl domain = emsysctrlMapping.toDomain(emsysctrldto);
		emsysctrlService.create(domain);
        EMSysCtrlDTO dto = emsysctrlMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Create',{'Sql',this.emsysctrlMapping,#emsysctrldtos})")
    @ApiOperation(value = "createBatch", tags = {"EMSysCtrl" },  notes = "createBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emsysctrls/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<EMSysCtrlDTO> emsysctrldtos) {
        emsysctrlService.createBatch(emsysctrlMapping.toDomain(emsysctrldtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(#emsysctrl_id,'Update',{'Sql',this.emsysctrlMapping,#emsysctrldto})")
    @ApiOperation(value = "Update", tags = {"EMSysCtrl" },  notes = "Update")
	@RequestMapping(method = RequestMethod.PUT, value = "/emsysctrls/{emsysctrl_id}")
    @Transactional
    public ResponseEntity<EMSysCtrlDTO> update(@PathVariable("emsysctrl_id") String emsysctrl_id, @RequestBody EMSysCtrlDTO emsysctrldto) {
		EMSysCtrl domain  = emsysctrlMapping.toDomain(emsysctrldto);
        domain .setEmsysctrlid(emsysctrl_id);
		emsysctrlService.update(domain );
		EMSysCtrlDTO dto = emsysctrlMapping.toDto(domain );
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Update',{'Sql',this.emsysctrlMapping,#emsysctrldtos})")
    @ApiOperation(value = "UpdateBatch", tags = {"EMSysCtrl" },  notes = "UpdateBatch")
	@RequestMapping(method = RequestMethod.PUT, value = "/emsysctrls/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<EMSysCtrlDTO> emsysctrldtos) {
        emsysctrlService.updateBatch(emsysctrlMapping.toDomain(emsysctrldtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(#emsysctrl_id,'Get',{'Sql',this.emsysctrlMapping,this.permissionDTO})")
    @ApiOperation(value = "Get", tags = {"EMSysCtrl" },  notes = "Get")
	@RequestMapping(method = RequestMethod.GET, value = "/emsysctrls/{emsysctrl_id}")
    public ResponseEntity<EMSysCtrlDTO> get(@PathVariable("emsysctrl_id") String emsysctrl_id) {
        EMSysCtrl domain = emsysctrlService.get(emsysctrl_id);
        EMSysCtrlDTO dto = emsysctrlMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('','Save',{'Sql',this.emsysctrlMapping,#emsysctrldto})")
    @ApiOperation(value = "Save", tags = {"EMSysCtrl" },  notes = "Save")
	@RequestMapping(method = RequestMethod.POST, value = "/emsysctrls/save")
    public ResponseEntity<Boolean> save(@RequestBody EMSysCtrlDTO emsysctrldto) {
        return ResponseEntity.status(HttpStatus.OK).body(emsysctrlService.save(emsysctrlMapping.toDomain(emsysctrldto)));
    }

    @PreAuthorize("hasPermission('Save',{'Sql',this.emsysctrlMapping,#emsysctrldtos})")
    @ApiOperation(value = "SaveBatch", tags = {"EMSysCtrl" },  notes = "SaveBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emsysctrls/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<EMSysCtrlDTO> emsysctrldtos) {
        emsysctrlService.saveBatch(emsysctrlMapping.toDomain(emsysctrldtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(#emsysctrl_id,'Remove',{'Sql',this.emsysctrlMapping,this.permissionDTO})")
    @ApiOperation(value = "Remove", tags = {"EMSysCtrl" },  notes = "Remove")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emsysctrls/{emsysctrl_id}")
    @Transactional
    public ResponseEntity<Boolean> remove(@PathVariable("emsysctrl_id") String emsysctrl_id) {
         return ResponseEntity.status(HttpStatus.OK).body(emsysctrlService.remove(emsysctrl_id));
    }

    @PreAuthorize("hasPermission('Remove',{'Sql',this.emsysctrlMapping,this.permissionDTO,#ids})")
    @ApiOperation(value = "RemoveBatch", tags = {"EMSysCtrl" },  notes = "RemoveBatch")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emsysctrls/batch")
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        emsysctrlService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMSysCtrl-GetDraft-all')")
    @ApiOperation(value = "GetDraft", tags = {"EMSysCtrl" },  notes = "GetDraft")
	@RequestMapping(method = RequestMethod.GET, value = "/emsysctrls/getdraft")
    public ResponseEntity<EMSysCtrlDTO> getDraft() {
        return ResponseEntity.status(HttpStatus.OK).body(emsysctrlMapping.toDto(emsysctrlService.getDraft(new EMSysCtrl())));
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMSysCtrl-CheckKey-all')")
    @ApiOperation(value = "CheckKey", tags = {"EMSysCtrl" },  notes = "CheckKey")
	@RequestMapping(method = RequestMethod.POST, value = "/emsysctrls/checkkey")
    public ResponseEntity<Boolean> checkKey(@RequestBody EMSysCtrlDTO emsysctrldto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emsysctrlService.checkKey(emsysctrlMapping.toDomain(emsysctrldto)));
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMSysCtrl-Default-all')")
	@ApiOperation(value = "fetchDEFAULT", tags = {"EMSysCtrl" } ,notes = "fetchDEFAULT")
    @RequestMapping(method= RequestMethod.GET , value="/emsysctrls/fetchdefault")
	public ResponseEntity<List<EMSysCtrlDTO>> fetchDefault(EMSysCtrlSearchContext context) {
        Page<EMSysCtrl> domains = emsysctrlService.searchDefault(context) ;
        List<EMSysCtrlDTO> list = emsysctrlMapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMSysCtrl-Default-all')")
	@ApiOperation(value = "searchDEFAULT", tags = {"EMSysCtrl" } ,notes = "searchDEFAULT")
    @RequestMapping(method= RequestMethod.POST , value="/emsysctrls/searchdefault")
	public ResponseEntity<Page<EMSysCtrlDTO>> searchDefault(@RequestBody EMSysCtrlSearchContext context) {
        Page<EMSysCtrl> domains = emsysctrlService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emsysctrlMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
}
