package cn.ibizlab.eam.webapi.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;
import javax.servlet.ServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import cn.ibizlab.eam.webapi.dto.*;
import cn.ibizlab.eam.webapi.mapping.*;
import cn.ibizlab.eam.core.eam_core.domain.EMServiceEvl;
import cn.ibizlab.eam.core.eam_core.service.IEMServiceEvlService;
import cn.ibizlab.eam.core.eam_core.filter.EMServiceEvlSearchContext;

@Slf4j
@Api(tags = {"EMServiceEvl" })
@RestController("WebApi-emserviceevl")
@RequestMapping("")
public class EMServiceEvlResource {

    @Autowired
    private IEMServiceEvlService emserviceevlService;

    @Autowired
    @Lazy
    public EMServiceEvlMapping emserviceevlMapping;

    public EMServiceEvlDTO permissionDTO=new EMServiceEvlDTO();

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMServiceEvl-CheckKey-all')")
    @ApiOperation(value = "CheckKey", tags = {"EMServiceEvl" },  notes = "CheckKey")
	@RequestMapping(method = RequestMethod.POST, value = "/emserviceevls/checkkey")
    public ResponseEntity<Boolean> checkKey(@RequestBody EMServiceEvlDTO emserviceevldto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emserviceevlService.checkKey(emserviceevlMapping.toDomain(emserviceevldto)));
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMServiceEvl-GetDraft-all')")
    @ApiOperation(value = "GetDraft", tags = {"EMServiceEvl" },  notes = "GetDraft")
	@RequestMapping(method = RequestMethod.GET, value = "/emserviceevls/getdraft")
    public ResponseEntity<EMServiceEvlDTO> getDraft() {
        return ResponseEntity.status(HttpStatus.OK).body(emserviceevlMapping.toDto(emserviceevlService.getDraft(new EMServiceEvl())));
    }

    @PreAuthorize("hasPermission('','Save',{'Sql',this.emserviceevlMapping,#emserviceevldto})")
    @ApiOperation(value = "Save", tags = {"EMServiceEvl" },  notes = "Save")
	@RequestMapping(method = RequestMethod.POST, value = "/emserviceevls/save")
    public ResponseEntity<Boolean> save(@RequestBody EMServiceEvlDTO emserviceevldto) {
        return ResponseEntity.status(HttpStatus.OK).body(emserviceevlService.save(emserviceevlMapping.toDomain(emserviceevldto)));
    }

    @PreAuthorize("hasPermission('Save',{'Sql',this.emserviceevlMapping,#emserviceevldtos})")
    @ApiOperation(value = "SaveBatch", tags = {"EMServiceEvl" },  notes = "SaveBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emserviceevls/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<EMServiceEvlDTO> emserviceevldtos) {
        emserviceevlService.saveBatch(emserviceevlMapping.toDomain(emserviceevldtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(#emserviceevl_id,'Remove',{'Sql',this.emserviceevlMapping,this.permissionDTO})")
    @ApiOperation(value = "Remove", tags = {"EMServiceEvl" },  notes = "Remove")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emserviceevls/{emserviceevl_id}")
    @Transactional
    public ResponseEntity<Boolean> remove(@PathVariable("emserviceevl_id") String emserviceevl_id) {
         return ResponseEntity.status(HttpStatus.OK).body(emserviceevlService.remove(emserviceevl_id));
    }

    @PreAuthorize("hasPermission('Remove',{'Sql',this.emserviceevlMapping,this.permissionDTO,#ids})")
    @ApiOperation(value = "RemoveBatch", tags = {"EMServiceEvl" },  notes = "RemoveBatch")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emserviceevls/batch")
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        emserviceevlService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(#emserviceevl_id,'Get',{'Sql',this.emserviceevlMapping,this.permissionDTO})")
    @ApiOperation(value = "Get", tags = {"EMServiceEvl" },  notes = "Get")
	@RequestMapping(method = RequestMethod.GET, value = "/emserviceevls/{emserviceevl_id}")
    public ResponseEntity<EMServiceEvlDTO> get(@PathVariable("emserviceevl_id") String emserviceevl_id) {
        EMServiceEvl domain = emserviceevlService.get(emserviceevl_id);
        EMServiceEvlDTO dto = emserviceevlMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('','Create',{'Sql',this.emserviceevlMapping,#emserviceevldto})")
    @ApiOperation(value = "Create", tags = {"EMServiceEvl" },  notes = "Create")
	@RequestMapping(method = RequestMethod.POST, value = "/emserviceevls")
    @Transactional
    public ResponseEntity<EMServiceEvlDTO> create(@RequestBody EMServiceEvlDTO emserviceevldto) {
        EMServiceEvl domain = emserviceevlMapping.toDomain(emserviceevldto);
		emserviceevlService.create(domain);
        EMServiceEvlDTO dto = emserviceevlMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Create',{'Sql',this.emserviceevlMapping,#emserviceevldtos})")
    @ApiOperation(value = "createBatch", tags = {"EMServiceEvl" },  notes = "createBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emserviceevls/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<EMServiceEvlDTO> emserviceevldtos) {
        emserviceevlService.createBatch(emserviceevlMapping.toDomain(emserviceevldtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(#emserviceevl_id,'Update',{'Sql',this.emserviceevlMapping,#emserviceevldto})")
    @ApiOperation(value = "Update", tags = {"EMServiceEvl" },  notes = "Update")
	@RequestMapping(method = RequestMethod.PUT, value = "/emserviceevls/{emserviceevl_id}")
    @Transactional
    public ResponseEntity<EMServiceEvlDTO> update(@PathVariable("emserviceevl_id") String emserviceevl_id, @RequestBody EMServiceEvlDTO emserviceevldto) {
		EMServiceEvl domain  = emserviceevlMapping.toDomain(emserviceevldto);
        domain .setEmserviceevlid(emserviceevl_id);
		emserviceevlService.update(domain );
		EMServiceEvlDTO dto = emserviceevlMapping.toDto(domain );
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Update',{'Sql',this.emserviceevlMapping,#emserviceevldtos})")
    @ApiOperation(value = "UpdateBatch", tags = {"EMServiceEvl" },  notes = "UpdateBatch")
	@RequestMapping(method = RequestMethod.PUT, value = "/emserviceevls/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<EMServiceEvlDTO> emserviceevldtos) {
        emserviceevlService.updateBatch(emserviceevlMapping.toDomain(emserviceevldtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMServiceEvl-Default-all')")
	@ApiOperation(value = "fetchDEFAULT", tags = {"EMServiceEvl" } ,notes = "fetchDEFAULT")
    @RequestMapping(method= RequestMethod.GET , value="/emserviceevls/fetchdefault")
	public ResponseEntity<List<EMServiceEvlDTO>> fetchDefault(EMServiceEvlSearchContext context) {
        Page<EMServiceEvl> domains = emserviceevlService.searchDefault(context) ;
        List<EMServiceEvlDTO> list = emserviceevlMapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMServiceEvl-Default-all')")
	@ApiOperation(value = "searchDEFAULT", tags = {"EMServiceEvl" } ,notes = "searchDEFAULT")
    @RequestMapping(method= RequestMethod.POST , value="/emserviceevls/searchdefault")
	public ResponseEntity<Page<EMServiceEvlDTO>> searchDefault(@RequestBody EMServiceEvlSearchContext context) {
        Page<EMServiceEvl> domains = emserviceevlService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emserviceevlMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
}
