package cn.ibizlab.eam.webapi.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;
import javax.servlet.ServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import cn.ibizlab.eam.webapi.dto.*;
import cn.ibizlab.eam.webapi.mapping.*;
import cn.ibizlab.eam.core.eam_core.domain.EMResItem;
import cn.ibizlab.eam.core.eam_core.service.IEMResItemService;
import cn.ibizlab.eam.core.eam_core.filter.EMResItemSearchContext;

@Slf4j
@Api(tags = {"EMResItem" })
@RestController("WebApi-emresitem")
@RequestMapping("")
public class EMResItemResource {

    @Autowired
    private IEMResItemService emresitemService;

    @Autowired
    @Lazy
    public EMResItemMapping emresitemMapping;

    public EMResItemDTO permissionDTO=new EMResItemDTO();

    @PreAuthorize("hasPermission('','Save',{'Sql',this.emresitemMapping,#emresitemdto})")
    @ApiOperation(value = "Save", tags = {"EMResItem" },  notes = "Save")
	@RequestMapping(method = RequestMethod.POST, value = "/emresitems/save")
    public ResponseEntity<Boolean> save(@RequestBody EMResItemDTO emresitemdto) {
        return ResponseEntity.status(HttpStatus.OK).body(emresitemService.save(emresitemMapping.toDomain(emresitemdto)));
    }

    @PreAuthorize("hasPermission('Save',{'Sql',this.emresitemMapping,#emresitemdtos})")
    @ApiOperation(value = "SaveBatch", tags = {"EMResItem" },  notes = "SaveBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emresitems/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<EMResItemDTO> emresitemdtos) {
        emresitemService.saveBatch(emresitemMapping.toDomain(emresitemdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(#emresitem_id,'Update',{'Sql',this.emresitemMapping,#emresitemdto})")
    @ApiOperation(value = "Update", tags = {"EMResItem" },  notes = "Update")
	@RequestMapping(method = RequestMethod.PUT, value = "/emresitems/{emresitem_id}")
    @Transactional
    public ResponseEntity<EMResItemDTO> update(@PathVariable("emresitem_id") String emresitem_id, @RequestBody EMResItemDTO emresitemdto) {
		EMResItem domain  = emresitemMapping.toDomain(emresitemdto);
        domain .setEmresitemid(emresitem_id);
		emresitemService.update(domain );
		EMResItemDTO dto = emresitemMapping.toDto(domain );
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Update',{'Sql',this.emresitemMapping,#emresitemdtos})")
    @ApiOperation(value = "UpdateBatch", tags = {"EMResItem" },  notes = "UpdateBatch")
	@RequestMapping(method = RequestMethod.PUT, value = "/emresitems/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<EMResItemDTO> emresitemdtos) {
        emresitemService.updateBatch(emresitemMapping.toDomain(emresitemdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMResItem-GetDraft-all')")
    @ApiOperation(value = "GetDraft", tags = {"EMResItem" },  notes = "GetDraft")
	@RequestMapping(method = RequestMethod.GET, value = "/emresitems/getdraft")
    public ResponseEntity<EMResItemDTO> getDraft() {
        return ResponseEntity.status(HttpStatus.OK).body(emresitemMapping.toDto(emresitemService.getDraft(new EMResItem())));
    }

    @PreAuthorize("hasPermission(#emresitem_id,'Get',{'Sql',this.emresitemMapping,this.permissionDTO})")
    @ApiOperation(value = "Get", tags = {"EMResItem" },  notes = "Get")
	@RequestMapping(method = RequestMethod.GET, value = "/emresitems/{emresitem_id}")
    public ResponseEntity<EMResItemDTO> get(@PathVariable("emresitem_id") String emresitem_id) {
        EMResItem domain = emresitemService.get(emresitem_id);
        EMResItemDTO dto = emresitemMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMResItem-CheckKey-all')")
    @ApiOperation(value = "CheckKey", tags = {"EMResItem" },  notes = "CheckKey")
	@RequestMapping(method = RequestMethod.POST, value = "/emresitems/checkkey")
    public ResponseEntity<Boolean> checkKey(@RequestBody EMResItemDTO emresitemdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emresitemService.checkKey(emresitemMapping.toDomain(emresitemdto)));
    }

    @PreAuthorize("hasPermission(#emresitem_id,'Remove',{'Sql',this.emresitemMapping,this.permissionDTO})")
    @ApiOperation(value = "Remove", tags = {"EMResItem" },  notes = "Remove")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emresitems/{emresitem_id}")
    @Transactional
    public ResponseEntity<Boolean> remove(@PathVariable("emresitem_id") String emresitem_id) {
         return ResponseEntity.status(HttpStatus.OK).body(emresitemService.remove(emresitem_id));
    }

    @PreAuthorize("hasPermission('Remove',{'Sql',this.emresitemMapping,this.permissionDTO,#ids})")
    @ApiOperation(value = "RemoveBatch", tags = {"EMResItem" },  notes = "RemoveBatch")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emresitems/batch")
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        emresitemService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission('','Create',{'Sql',this.emresitemMapping,#emresitemdto})")
    @ApiOperation(value = "Create", tags = {"EMResItem" },  notes = "Create")
	@RequestMapping(method = RequestMethod.POST, value = "/emresitems")
    @Transactional
    public ResponseEntity<EMResItemDTO> create(@RequestBody EMResItemDTO emresitemdto) {
        EMResItem domain = emresitemMapping.toDomain(emresitemdto);
		emresitemService.create(domain);
        EMResItemDTO dto = emresitemMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Create',{'Sql',this.emresitemMapping,#emresitemdtos})")
    @ApiOperation(value = "createBatch", tags = {"EMResItem" },  notes = "createBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emresitems/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<EMResItemDTO> emresitemdtos) {
        emresitemService.createBatch(emresitemMapping.toDomain(emresitemdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMResItem-Default-all')")
	@ApiOperation(value = "fetchDEFAULT", tags = {"EMResItem" } ,notes = "fetchDEFAULT")
    @RequestMapping(method= RequestMethod.GET , value="/emresitems/fetchdefault")
	public ResponseEntity<List<EMResItemDTO>> fetchDefault(EMResItemSearchContext context) {
        Page<EMResItem> domains = emresitemService.searchDefault(context) ;
        List<EMResItemDTO> list = emresitemMapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMResItem-Default-all')")
	@ApiOperation(value = "searchDEFAULT", tags = {"EMResItem" } ,notes = "searchDEFAULT")
    @RequestMapping(method= RequestMethod.POST , value="/emresitems/searchdefault")
	public ResponseEntity<Page<EMResItemDTO>> searchDefault(@RequestBody EMResItemSearchContext context) {
        Page<EMResItem> domains = emresitemService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emresitemMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
}
