package cn.ibizlab.eam.webapi.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;
import javax.servlet.ServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import cn.ibizlab.eam.webapi.dto.*;
import cn.ibizlab.eam.webapi.mapping.*;
import cn.ibizlab.eam.core.eam_core.domain.EMRFOMO;
import cn.ibizlab.eam.core.eam_core.service.IEMRFOMOService;
import cn.ibizlab.eam.core.eam_core.filter.EMRFOMOSearchContext;

@Slf4j
@Api(tags = {"EMRFOMO" })
@RestController("WebApi-emrfomo")
@RequestMapping("")
public class EMRFOMOResource {

    @Autowired
    private IEMRFOMOService emrfomoService;

    @Autowired
    @Lazy
    public EMRFOMOMapping emrfomoMapping;

    public EMRFOMODTO permissionDTO=new EMRFOMODTO();

    @PreAuthorize("hasPermission('','Create',{'Sql',this.emrfomoMapping,#emrfomodto})")
    @ApiOperation(value = "Create", tags = {"EMRFOMO" },  notes = "Create")
	@RequestMapping(method = RequestMethod.POST, value = "/emrfomos")
    @Transactional
    public ResponseEntity<EMRFOMODTO> create(@RequestBody EMRFOMODTO emrfomodto) {
        EMRFOMO domain = emrfomoMapping.toDomain(emrfomodto);
		emrfomoService.create(domain);
        EMRFOMODTO dto = emrfomoMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Create',{'Sql',this.emrfomoMapping,#emrfomodtos})")
    @ApiOperation(value = "createBatch", tags = {"EMRFOMO" },  notes = "createBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emrfomos/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<EMRFOMODTO> emrfomodtos) {
        emrfomoService.createBatch(emrfomoMapping.toDomain(emrfomodtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission('','Save',{'Sql',this.emrfomoMapping,#emrfomodto})")
    @ApiOperation(value = "Save", tags = {"EMRFOMO" },  notes = "Save")
	@RequestMapping(method = RequestMethod.POST, value = "/emrfomos/save")
    public ResponseEntity<Boolean> save(@RequestBody EMRFOMODTO emrfomodto) {
        return ResponseEntity.status(HttpStatus.OK).body(emrfomoService.save(emrfomoMapping.toDomain(emrfomodto)));
    }

    @PreAuthorize("hasPermission('Save',{'Sql',this.emrfomoMapping,#emrfomodtos})")
    @ApiOperation(value = "SaveBatch", tags = {"EMRFOMO" },  notes = "SaveBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emrfomos/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<EMRFOMODTO> emrfomodtos) {
        emrfomoService.saveBatch(emrfomoMapping.toDomain(emrfomodtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMRFOMO-CheckKey-all')")
    @ApiOperation(value = "CheckKey", tags = {"EMRFOMO" },  notes = "CheckKey")
	@RequestMapping(method = RequestMethod.POST, value = "/emrfomos/checkkey")
    public ResponseEntity<Boolean> checkKey(@RequestBody EMRFOMODTO emrfomodto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emrfomoService.checkKey(emrfomoMapping.toDomain(emrfomodto)));
    }

    @PreAuthorize("hasPermission(#emrfomo_id,'Get',{'Sql',this.emrfomoMapping,this.permissionDTO})")
    @ApiOperation(value = "Get", tags = {"EMRFOMO" },  notes = "Get")
	@RequestMapping(method = RequestMethod.GET, value = "/emrfomos/{emrfomo_id}")
    public ResponseEntity<EMRFOMODTO> get(@PathVariable("emrfomo_id") String emrfomo_id) {
        EMRFOMO domain = emrfomoService.get(emrfomo_id);
        EMRFOMODTO dto = emrfomoMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(#emrfomo_id,'Remove',{'Sql',this.emrfomoMapping,this.permissionDTO})")
    @ApiOperation(value = "Remove", tags = {"EMRFOMO" },  notes = "Remove")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emrfomos/{emrfomo_id}")
    @Transactional
    public ResponseEntity<Boolean> remove(@PathVariable("emrfomo_id") String emrfomo_id) {
         return ResponseEntity.status(HttpStatus.OK).body(emrfomoService.remove(emrfomo_id));
    }

    @PreAuthorize("hasPermission('Remove',{'Sql',this.emrfomoMapping,this.permissionDTO,#ids})")
    @ApiOperation(value = "RemoveBatch", tags = {"EMRFOMO" },  notes = "RemoveBatch")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emrfomos/batch")
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        emrfomoService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMRFOMO-GetDraft-all')")
    @ApiOperation(value = "GetDraft", tags = {"EMRFOMO" },  notes = "GetDraft")
	@RequestMapping(method = RequestMethod.GET, value = "/emrfomos/getdraft")
    public ResponseEntity<EMRFOMODTO> getDraft() {
        return ResponseEntity.status(HttpStatus.OK).body(emrfomoMapping.toDto(emrfomoService.getDraft(new EMRFOMO())));
    }

    @PreAuthorize("hasPermission(#emrfomo_id,'Update',{'Sql',this.emrfomoMapping,#emrfomodto})")
    @ApiOperation(value = "Update", tags = {"EMRFOMO" },  notes = "Update")
	@RequestMapping(method = RequestMethod.PUT, value = "/emrfomos/{emrfomo_id}")
    @Transactional
    public ResponseEntity<EMRFOMODTO> update(@PathVariable("emrfomo_id") String emrfomo_id, @RequestBody EMRFOMODTO emrfomodto) {
		EMRFOMO domain  = emrfomoMapping.toDomain(emrfomodto);
        domain .setEmrfomoid(emrfomo_id);
		emrfomoService.update(domain );
		EMRFOMODTO dto = emrfomoMapping.toDto(domain );
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Update',{'Sql',this.emrfomoMapping,#emrfomodtos})")
    @ApiOperation(value = "UpdateBatch", tags = {"EMRFOMO" },  notes = "UpdateBatch")
	@RequestMapping(method = RequestMethod.PUT, value = "/emrfomos/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<EMRFOMODTO> emrfomodtos) {
        emrfomoService.updateBatch(emrfomoMapping.toDomain(emrfomodtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMRFOMO-Default-all')")
	@ApiOperation(value = "fetchDEFAULT", tags = {"EMRFOMO" } ,notes = "fetchDEFAULT")
    @RequestMapping(method= RequestMethod.GET , value="/emrfomos/fetchdefault")
	public ResponseEntity<List<EMRFOMODTO>> fetchDefault(EMRFOMOSearchContext context) {
        Page<EMRFOMO> domains = emrfomoService.searchDefault(context) ;
        List<EMRFOMODTO> list = emrfomoMapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMRFOMO-Default-all')")
	@ApiOperation(value = "searchDEFAULT", tags = {"EMRFOMO" } ,notes = "searchDEFAULT")
    @RequestMapping(method= RequestMethod.POST , value="/emrfomos/searchdefault")
	public ResponseEntity<Page<EMRFOMODTO>> searchDefault(@RequestBody EMRFOMOSearchContext context) {
        Page<EMRFOMO> domains = emrfomoService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emrfomoMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
    @PreAuthorize("hasPermission('','Create',{'Sql',this.emrfomoMapping,#emrfomodto})")
    @ApiOperation(value = "CreateByEMRFODE", tags = {"EMRFOMO" },  notes = "CreateByEMRFODE")
	@RequestMapping(method = RequestMethod.POST, value = "/emrfodes/{emrfode_id}/emrfomos")
    @Transactional
    public ResponseEntity<EMRFOMODTO> createByEMRFODE(@PathVariable("emrfode_id") String emrfode_id, @RequestBody EMRFOMODTO emrfomodto) {
        EMRFOMO domain = emrfomoMapping.toDomain(emrfomodto);
        domain.setRfodeid(emrfode_id);
		emrfomoService.create(domain);
        EMRFOMODTO dto = emrfomoMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Create',{'Sql',this.emrfomoMapping,#emrfomodtos})")
    @ApiOperation(value = "createBatchByEMRFODE", tags = {"EMRFOMO" },  notes = "createBatchByEMRFODE")
	@RequestMapping(method = RequestMethod.POST, value = "/emrfodes/{emrfode_id}/emrfomos/batch")
    public ResponseEntity<Boolean> createBatchByEMRFODE(@PathVariable("emrfode_id") String emrfode_id, @RequestBody List<EMRFOMODTO> emrfomodtos) {
        List<EMRFOMO> domainlist=emrfomoMapping.toDomain(emrfomodtos);
        for(EMRFOMO domain:domainlist){
            domain.setRfodeid(emrfode_id);
        }
        emrfomoService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission('','Save',{'Sql',this.emrfomoMapping,#emrfomodto})")
    @ApiOperation(value = "SaveByEMRFODE", tags = {"EMRFOMO" },  notes = "SaveByEMRFODE")
	@RequestMapping(method = RequestMethod.POST, value = "/emrfodes/{emrfode_id}/emrfomos/save")
    public ResponseEntity<Boolean> saveByEMRFODE(@PathVariable("emrfode_id") String emrfode_id, @RequestBody EMRFOMODTO emrfomodto) {
        EMRFOMO domain = emrfomoMapping.toDomain(emrfomodto);
        domain.setRfodeid(emrfode_id);
        return ResponseEntity.status(HttpStatus.OK).body(emrfomoService.save(domain));
    }

    @PreAuthorize("hasPermission('Save',{'Sql',this.emrfomoMapping,#emrfomodtos})")
    @ApiOperation(value = "SaveBatchByEMRFODE", tags = {"EMRFOMO" },  notes = "SaveBatchByEMRFODE")
	@RequestMapping(method = RequestMethod.POST, value = "/emrfodes/{emrfode_id}/emrfomos/savebatch")
    public ResponseEntity<Boolean> saveBatchByEMRFODE(@PathVariable("emrfode_id") String emrfode_id, @RequestBody List<EMRFOMODTO> emrfomodtos) {
        List<EMRFOMO> domainlist=emrfomoMapping.toDomain(emrfomodtos);
        for(EMRFOMO domain:domainlist){
             domain.setRfodeid(emrfode_id);
        }
        emrfomoService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMRFOMO-CheckKey-all')")
    @ApiOperation(value = "CheckKeyByEMRFODE", tags = {"EMRFOMO" },  notes = "CheckKeyByEMRFODE")
	@RequestMapping(method = RequestMethod.POST, value = "/emrfodes/{emrfode_id}/emrfomos/checkkey")
    public ResponseEntity<Boolean> checkKeyByEMRFODE(@PathVariable("emrfode_id") String emrfode_id, @RequestBody EMRFOMODTO emrfomodto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emrfomoService.checkKey(emrfomoMapping.toDomain(emrfomodto)));
    }

    @PreAuthorize("hasPermission(#emrfomo_id,'Get',{'Sql',this.emrfomoMapping,this.permissionDTO})")
    @ApiOperation(value = "GetByEMRFODE", tags = {"EMRFOMO" },  notes = "GetByEMRFODE")
	@RequestMapping(method = RequestMethod.GET, value = "/emrfodes/{emrfode_id}/emrfomos/{emrfomo_id}")
    public ResponseEntity<EMRFOMODTO> getByEMRFODE(@PathVariable("emrfode_id") String emrfode_id, @PathVariable("emrfomo_id") String emrfomo_id) {
        EMRFOMO domain = emrfomoService.get(emrfomo_id);
        EMRFOMODTO dto = emrfomoMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(#emrfomo_id,'Remove',{'Sql',this.emrfomoMapping,this.permissionDTO})")
    @ApiOperation(value = "RemoveByEMRFODE", tags = {"EMRFOMO" },  notes = "RemoveByEMRFODE")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emrfodes/{emrfode_id}/emrfomos/{emrfomo_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByEMRFODE(@PathVariable("emrfode_id") String emrfode_id, @PathVariable("emrfomo_id") String emrfomo_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emrfomoService.remove(emrfomo_id));
    }

    @PreAuthorize("hasPermission('Remove',{'Sql',this.emrfomoMapping,this.permissionDTO,#ids})")
    @ApiOperation(value = "RemoveBatchByEMRFODE", tags = {"EMRFOMO" },  notes = "RemoveBatchByEMRFODE")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emrfodes/{emrfode_id}/emrfomos/batch")
    public ResponseEntity<Boolean> removeBatchByEMRFODE(@RequestBody List<String> ids) {
        emrfomoService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMRFOMO-GetDraft-all')")
    @ApiOperation(value = "GetDraftByEMRFODE", tags = {"EMRFOMO" },  notes = "GetDraftByEMRFODE")
    @RequestMapping(method = RequestMethod.GET, value = "/emrfodes/{emrfode_id}/emrfomos/getdraft")
    public ResponseEntity<EMRFOMODTO> getDraftByEMRFODE(@PathVariable("emrfode_id") String emrfode_id) {
        EMRFOMO domain = new EMRFOMO();
        domain.setRfodeid(emrfode_id);
        return ResponseEntity.status(HttpStatus.OK).body(emrfomoMapping.toDto(emrfomoService.getDraft(domain)));
    }

    @PreAuthorize("hasPermission(#emrfomo_id,'Update',{'Sql',this.emrfomoMapping,#emrfomodto})")
    @ApiOperation(value = "UpdateByEMRFODE", tags = {"EMRFOMO" },  notes = "UpdateByEMRFODE")
	@RequestMapping(method = RequestMethod.PUT, value = "/emrfodes/{emrfode_id}/emrfomos/{emrfomo_id}")
    @Transactional
    public ResponseEntity<EMRFOMODTO> updateByEMRFODE(@PathVariable("emrfode_id") String emrfode_id, @PathVariable("emrfomo_id") String emrfomo_id, @RequestBody EMRFOMODTO emrfomodto) {
        EMRFOMO domain = emrfomoMapping.toDomain(emrfomodto);
        domain.setRfodeid(emrfode_id);
        domain.setEmrfomoid(emrfomo_id);
		emrfomoService.update(domain);
        EMRFOMODTO dto = emrfomoMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Update',{'Sql',this.emrfomoMapping,#emrfomodtos})")
    @ApiOperation(value = "UpdateBatchByEMRFODE", tags = {"EMRFOMO" },  notes = "UpdateBatchByEMRFODE")
	@RequestMapping(method = RequestMethod.PUT, value = "/emrfodes/{emrfode_id}/emrfomos/batch")
    public ResponseEntity<Boolean> updateBatchByEMRFODE(@PathVariable("emrfode_id") String emrfode_id, @RequestBody List<EMRFOMODTO> emrfomodtos) {
        List<EMRFOMO> domainlist=emrfomoMapping.toDomain(emrfomodtos);
        for(EMRFOMO domain:domainlist){
            domain.setRfodeid(emrfode_id);
        }
        emrfomoService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMRFOMO-Default-all')")
	@ApiOperation(value = "fetchDEFAULTByEMRFODE", tags = {"EMRFOMO" } ,notes = "fetchDEFAULTByEMRFODE")
    @RequestMapping(method= RequestMethod.GET , value="/emrfodes/{emrfode_id}/emrfomos/fetchdefault")
	public ResponseEntity<List<EMRFOMODTO>> fetchEMRFOMODefaultByEMRFODE(@PathVariable("emrfode_id") String emrfode_id,EMRFOMOSearchContext context) {
        context.setN_rfodeid_eq(emrfode_id);
        Page<EMRFOMO> domains = emrfomoService.searchDefault(context) ;
        List<EMRFOMODTO> list = emrfomoMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMRFOMO-Default-all')")
	@ApiOperation(value = "searchDEFAULTByEMRFODE", tags = {"EMRFOMO" } ,notes = "searchDEFAULTByEMRFODE")
    @RequestMapping(method= RequestMethod.POST , value="/emrfodes/{emrfode_id}/emrfomos/searchdefault")
	public ResponseEntity<Page<EMRFOMODTO>> searchEMRFOMODefaultByEMRFODE(@PathVariable("emrfode_id") String emrfode_id, @RequestBody EMRFOMOSearchContext context) {
        context.setN_rfodeid_eq(emrfode_id);
        Page<EMRFOMO> domains = emrfomoService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emrfomoMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
}
