package cn.ibizlab.eam.webapi.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;
import javax.servlet.ServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import cn.ibizlab.eam.webapi.dto.*;
import cn.ibizlab.eam.webapi.mapping.*;
import cn.ibizlab.eam.core.eam_core.domain.EMPlan;
import cn.ibizlab.eam.core.eam_core.service.IEMPlanService;
import cn.ibizlab.eam.core.eam_core.filter.EMPlanSearchContext;

@Slf4j
@Api(tags = {"EMPlan" })
@RestController("WebApi-emplan")
@RequestMapping("")
public class EMPlanResource {

    @Autowired
    private IEMPlanService emplanService;

    @Autowired
    @Lazy
    public EMPlanMapping emplanMapping;

    public EMPlanDTO permissionDTO=new EMPlanDTO();

    @PreAuthorize("hasPermission('','Create',{'Sql',this.emplanMapping,#emplandto})")
    @ApiOperation(value = "Create", tags = {"EMPlan" },  notes = "Create")
	@RequestMapping(method = RequestMethod.POST, value = "/emplans")
    @Transactional
    public ResponseEntity<EMPlanDTO> create(@RequestBody EMPlanDTO emplandto) {
        EMPlan domain = emplanMapping.toDomain(emplandto);
		emplanService.create(domain);
        EMPlanDTO dto = emplanMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Create',{'Sql',this.emplanMapping,#emplandtos})")
    @ApiOperation(value = "createBatch", tags = {"EMPlan" },  notes = "createBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emplans/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<EMPlanDTO> emplandtos) {
        emplanService.createBatch(emplanMapping.toDomain(emplandtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(#emplan_id,'Update',{'Sql',this.emplanMapping,#emplandto})")
    @ApiOperation(value = "Update", tags = {"EMPlan" },  notes = "Update")
	@RequestMapping(method = RequestMethod.PUT, value = "/emplans/{emplan_id}")
    @Transactional
    public ResponseEntity<EMPlanDTO> update(@PathVariable("emplan_id") String emplan_id, @RequestBody EMPlanDTO emplandto) {
		EMPlan domain  = emplanMapping.toDomain(emplandto);
        domain .setEmplanid(emplan_id);
		emplanService.update(domain );
		EMPlanDTO dto = emplanMapping.toDto(domain );
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Update',{'Sql',this.emplanMapping,#emplandtos})")
    @ApiOperation(value = "UpdateBatch", tags = {"EMPlan" },  notes = "UpdateBatch")
	@RequestMapping(method = RequestMethod.PUT, value = "/emplans/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<EMPlanDTO> emplandtos) {
        emplanService.updateBatch(emplanMapping.toDomain(emplandtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(#emplan_id,'Get',{'Sql',this.emplanMapping,this.permissionDTO})")
    @ApiOperation(value = "Get", tags = {"EMPlan" },  notes = "Get")
	@RequestMapping(method = RequestMethod.GET, value = "/emplans/{emplan_id}")
    public ResponseEntity<EMPlanDTO> get(@PathVariable("emplan_id") String emplan_id) {
        EMPlan domain = emplanService.get(emplan_id);
        EMPlanDTO dto = emplanMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(#emplan_id,'Remove',{'Sql',this.emplanMapping,this.permissionDTO})")
    @ApiOperation(value = "Remove", tags = {"EMPlan" },  notes = "Remove")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emplans/{emplan_id}")
    @Transactional
    public ResponseEntity<Boolean> remove(@PathVariable("emplan_id") String emplan_id) {
         return ResponseEntity.status(HttpStatus.OK).body(emplanService.remove(emplan_id));
    }

    @PreAuthorize("hasPermission('Remove',{'Sql',this.emplanMapping,this.permissionDTO,#ids})")
    @ApiOperation(value = "RemoveBatch", tags = {"EMPlan" },  notes = "RemoveBatch")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emplans/batch")
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        emplanService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMPlan-GetDraft-all')")
    @ApiOperation(value = "GetDraft", tags = {"EMPlan" },  notes = "GetDraft")
	@RequestMapping(method = RequestMethod.GET, value = "/emplans/getdraft")
    public ResponseEntity<EMPlanDTO> getDraft() {
        return ResponseEntity.status(HttpStatus.OK).body(emplanMapping.toDto(emplanService.getDraft(new EMPlan())));
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMPlan-CheckKey-all')")
    @ApiOperation(value = "CheckKey", tags = {"EMPlan" },  notes = "CheckKey")
	@RequestMapping(method = RequestMethod.POST, value = "/emplans/checkkey")
    public ResponseEntity<Boolean> checkKey(@RequestBody EMPlanDTO emplandto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emplanService.checkKey(emplanMapping.toDomain(emplandto)));
    }

    @PreAuthorize("hasPermission('','Save',{'Sql',this.emplanMapping,#emplandto})")
    @ApiOperation(value = "Save", tags = {"EMPlan" },  notes = "Save")
	@RequestMapping(method = RequestMethod.POST, value = "/emplans/save")
    public ResponseEntity<Boolean> save(@RequestBody EMPlanDTO emplandto) {
        return ResponseEntity.status(HttpStatus.OK).body(emplanService.save(emplanMapping.toDomain(emplandto)));
    }

    @PreAuthorize("hasPermission('Save',{'Sql',this.emplanMapping,#emplandtos})")
    @ApiOperation(value = "SaveBatch", tags = {"EMPlan" },  notes = "SaveBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emplans/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<EMPlanDTO> emplandtos) {
        emplanService.saveBatch(emplanMapping.toDomain(emplandtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMPlan-Default-all')")
	@ApiOperation(value = "fetchDEFAULT", tags = {"EMPlan" } ,notes = "fetchDEFAULT")
    @RequestMapping(method= RequestMethod.GET , value="/emplans/fetchdefault")
	public ResponseEntity<List<EMPlanDTO>> fetchDefault(EMPlanSearchContext context) {
        Page<EMPlan> domains = emplanService.searchDefault(context) ;
        List<EMPlanDTO> list = emplanMapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMPlan-Default-all')")
	@ApiOperation(value = "searchDEFAULT", tags = {"EMPlan" } ,notes = "searchDEFAULT")
    @RequestMapping(method= RequestMethod.POST , value="/emplans/searchdefault")
	public ResponseEntity<Page<EMPlanDTO>> searchDefault(@RequestBody EMPlanSearchContext context) {
        Page<EMPlan> domains = emplanService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emplanMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
    @PreAuthorize("hasPermission('','Create',{'Sql',this.emplanMapping,#emplandto})")
    @ApiOperation(value = "CreateByEMACClass", tags = {"EMPlan" },  notes = "CreateByEMACClass")
	@RequestMapping(method = RequestMethod.POST, value = "/emacclasses/{emacclass_id}/emplans")
    @Transactional
    public ResponseEntity<EMPlanDTO> createByEMACClass(@PathVariable("emacclass_id") String emacclass_id, @RequestBody EMPlanDTO emplandto) {
        EMPlan domain = emplanMapping.toDomain(emplandto);
        domain.setAcclassid(emacclass_id);
		emplanService.create(domain);
        EMPlanDTO dto = emplanMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Create',{'Sql',this.emplanMapping,#emplandtos})")
    @ApiOperation(value = "createBatchByEMACClass", tags = {"EMPlan" },  notes = "createBatchByEMACClass")
	@RequestMapping(method = RequestMethod.POST, value = "/emacclasses/{emacclass_id}/emplans/batch")
    public ResponseEntity<Boolean> createBatchByEMACClass(@PathVariable("emacclass_id") String emacclass_id, @RequestBody List<EMPlanDTO> emplandtos) {
        List<EMPlan> domainlist=emplanMapping.toDomain(emplandtos);
        for(EMPlan domain:domainlist){
            domain.setAcclassid(emacclass_id);
        }
        emplanService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(#emplan_id,'Update',{'Sql',this.emplanMapping,#emplandto})")
    @ApiOperation(value = "UpdateByEMACClass", tags = {"EMPlan" },  notes = "UpdateByEMACClass")
	@RequestMapping(method = RequestMethod.PUT, value = "/emacclasses/{emacclass_id}/emplans/{emplan_id}")
    @Transactional
    public ResponseEntity<EMPlanDTO> updateByEMACClass(@PathVariable("emacclass_id") String emacclass_id, @PathVariable("emplan_id") String emplan_id, @RequestBody EMPlanDTO emplandto) {
        EMPlan domain = emplanMapping.toDomain(emplandto);
        domain.setAcclassid(emacclass_id);
        domain.setEmplanid(emplan_id);
		emplanService.update(domain);
        EMPlanDTO dto = emplanMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Update',{'Sql',this.emplanMapping,#emplandtos})")
    @ApiOperation(value = "UpdateBatchByEMACClass", tags = {"EMPlan" },  notes = "UpdateBatchByEMACClass")
	@RequestMapping(method = RequestMethod.PUT, value = "/emacclasses/{emacclass_id}/emplans/batch")
    public ResponseEntity<Boolean> updateBatchByEMACClass(@PathVariable("emacclass_id") String emacclass_id, @RequestBody List<EMPlanDTO> emplandtos) {
        List<EMPlan> domainlist=emplanMapping.toDomain(emplandtos);
        for(EMPlan domain:domainlist){
            domain.setAcclassid(emacclass_id);
        }
        emplanService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(#emplan_id,'Get',{'Sql',this.emplanMapping,this.permissionDTO})")
    @ApiOperation(value = "GetByEMACClass", tags = {"EMPlan" },  notes = "GetByEMACClass")
	@RequestMapping(method = RequestMethod.GET, value = "/emacclasses/{emacclass_id}/emplans/{emplan_id}")
    public ResponseEntity<EMPlanDTO> getByEMACClass(@PathVariable("emacclass_id") String emacclass_id, @PathVariable("emplan_id") String emplan_id) {
        EMPlan domain = emplanService.get(emplan_id);
        EMPlanDTO dto = emplanMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(#emplan_id,'Remove',{'Sql',this.emplanMapping,this.permissionDTO})")
    @ApiOperation(value = "RemoveByEMACClass", tags = {"EMPlan" },  notes = "RemoveByEMACClass")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emacclasses/{emacclass_id}/emplans/{emplan_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByEMACClass(@PathVariable("emacclass_id") String emacclass_id, @PathVariable("emplan_id") String emplan_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emplanService.remove(emplan_id));
    }

    @PreAuthorize("hasPermission('Remove',{'Sql',this.emplanMapping,this.permissionDTO,#ids})")
    @ApiOperation(value = "RemoveBatchByEMACClass", tags = {"EMPlan" },  notes = "RemoveBatchByEMACClass")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emacclasses/{emacclass_id}/emplans/batch")
    public ResponseEntity<Boolean> removeBatchByEMACClass(@RequestBody List<String> ids) {
        emplanService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMPlan-GetDraft-all')")
    @ApiOperation(value = "GetDraftByEMACClass", tags = {"EMPlan" },  notes = "GetDraftByEMACClass")
    @RequestMapping(method = RequestMethod.GET, value = "/emacclasses/{emacclass_id}/emplans/getdraft")
    public ResponseEntity<EMPlanDTO> getDraftByEMACClass(@PathVariable("emacclass_id") String emacclass_id) {
        EMPlan domain = new EMPlan();
        domain.setAcclassid(emacclass_id);
        return ResponseEntity.status(HttpStatus.OK).body(emplanMapping.toDto(emplanService.getDraft(domain)));
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMPlan-CheckKey-all')")
    @ApiOperation(value = "CheckKeyByEMACClass", tags = {"EMPlan" },  notes = "CheckKeyByEMACClass")
	@RequestMapping(method = RequestMethod.POST, value = "/emacclasses/{emacclass_id}/emplans/checkkey")
    public ResponseEntity<Boolean> checkKeyByEMACClass(@PathVariable("emacclass_id") String emacclass_id, @RequestBody EMPlanDTO emplandto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emplanService.checkKey(emplanMapping.toDomain(emplandto)));
    }

    @PreAuthorize("hasPermission('','Save',{'Sql',this.emplanMapping,#emplandto})")
    @ApiOperation(value = "SaveByEMACClass", tags = {"EMPlan" },  notes = "SaveByEMACClass")
	@RequestMapping(method = RequestMethod.POST, value = "/emacclasses/{emacclass_id}/emplans/save")
    public ResponseEntity<Boolean> saveByEMACClass(@PathVariable("emacclass_id") String emacclass_id, @RequestBody EMPlanDTO emplandto) {
        EMPlan domain = emplanMapping.toDomain(emplandto);
        domain.setAcclassid(emacclass_id);
        return ResponseEntity.status(HttpStatus.OK).body(emplanService.save(domain));
    }

    @PreAuthorize("hasPermission('Save',{'Sql',this.emplanMapping,#emplandtos})")
    @ApiOperation(value = "SaveBatchByEMACClass", tags = {"EMPlan" },  notes = "SaveBatchByEMACClass")
	@RequestMapping(method = RequestMethod.POST, value = "/emacclasses/{emacclass_id}/emplans/savebatch")
    public ResponseEntity<Boolean> saveBatchByEMACClass(@PathVariable("emacclass_id") String emacclass_id, @RequestBody List<EMPlanDTO> emplandtos) {
        List<EMPlan> domainlist=emplanMapping.toDomain(emplandtos);
        for(EMPlan domain:domainlist){
             domain.setAcclassid(emacclass_id);
        }
        emplanService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMPlan-Default-all')")
	@ApiOperation(value = "fetchDEFAULTByEMACClass", tags = {"EMPlan" } ,notes = "fetchDEFAULTByEMACClass")
    @RequestMapping(method= RequestMethod.GET , value="/emacclasses/{emacclass_id}/emplans/fetchdefault")
	public ResponseEntity<List<EMPlanDTO>> fetchEMPlanDefaultByEMACClass(@PathVariable("emacclass_id") String emacclass_id,EMPlanSearchContext context) {
        context.setN_acclassid_eq(emacclass_id);
        Page<EMPlan> domains = emplanService.searchDefault(context) ;
        List<EMPlanDTO> list = emplanMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMPlan-Default-all')")
	@ApiOperation(value = "searchDEFAULTByEMACClass", tags = {"EMPlan" } ,notes = "searchDEFAULTByEMACClass")
    @RequestMapping(method= RequestMethod.POST , value="/emacclasses/{emacclass_id}/emplans/searchdefault")
	public ResponseEntity<Page<EMPlanDTO>> searchEMPlanDefaultByEMACClass(@PathVariable("emacclass_id") String emacclass_id, @RequestBody EMPlanSearchContext context) {
        context.setN_acclassid_eq(emacclass_id);
        Page<EMPlan> domains = emplanService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emplanMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
    @PreAuthorize("hasPermission('','Create',{'Sql',this.emplanMapping,#emplandto})")
    @ApiOperation(value = "CreateByEMEquip", tags = {"EMPlan" },  notes = "CreateByEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/emequips/{emequip_id}/emplans")
    @Transactional
    public ResponseEntity<EMPlanDTO> createByEMEquip(@PathVariable("emequip_id") String emequip_id, @RequestBody EMPlanDTO emplandto) {
        EMPlan domain = emplanMapping.toDomain(emplandto);
        domain.setEquipid(emequip_id);
		emplanService.create(domain);
        EMPlanDTO dto = emplanMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Create',{'Sql',this.emplanMapping,#emplandtos})")
    @ApiOperation(value = "createBatchByEMEquip", tags = {"EMPlan" },  notes = "createBatchByEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/emequips/{emequip_id}/emplans/batch")
    public ResponseEntity<Boolean> createBatchByEMEquip(@PathVariable("emequip_id") String emequip_id, @RequestBody List<EMPlanDTO> emplandtos) {
        List<EMPlan> domainlist=emplanMapping.toDomain(emplandtos);
        for(EMPlan domain:domainlist){
            domain.setEquipid(emequip_id);
        }
        emplanService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(#emplan_id,'Update',{'Sql',this.emplanMapping,#emplandto})")
    @ApiOperation(value = "UpdateByEMEquip", tags = {"EMPlan" },  notes = "UpdateByEMEquip")
	@RequestMapping(method = RequestMethod.PUT, value = "/emequips/{emequip_id}/emplans/{emplan_id}")
    @Transactional
    public ResponseEntity<EMPlanDTO> updateByEMEquip(@PathVariable("emequip_id") String emequip_id, @PathVariable("emplan_id") String emplan_id, @RequestBody EMPlanDTO emplandto) {
        EMPlan domain = emplanMapping.toDomain(emplandto);
        domain.setEquipid(emequip_id);
        domain.setEmplanid(emplan_id);
		emplanService.update(domain);
        EMPlanDTO dto = emplanMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Update',{'Sql',this.emplanMapping,#emplandtos})")
    @ApiOperation(value = "UpdateBatchByEMEquip", tags = {"EMPlan" },  notes = "UpdateBatchByEMEquip")
	@RequestMapping(method = RequestMethod.PUT, value = "/emequips/{emequip_id}/emplans/batch")
    public ResponseEntity<Boolean> updateBatchByEMEquip(@PathVariable("emequip_id") String emequip_id, @RequestBody List<EMPlanDTO> emplandtos) {
        List<EMPlan> domainlist=emplanMapping.toDomain(emplandtos);
        for(EMPlan domain:domainlist){
            domain.setEquipid(emequip_id);
        }
        emplanService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(#emplan_id,'Get',{'Sql',this.emplanMapping,this.permissionDTO})")
    @ApiOperation(value = "GetByEMEquip", tags = {"EMPlan" },  notes = "GetByEMEquip")
	@RequestMapping(method = RequestMethod.GET, value = "/emequips/{emequip_id}/emplans/{emplan_id}")
    public ResponseEntity<EMPlanDTO> getByEMEquip(@PathVariable("emequip_id") String emequip_id, @PathVariable("emplan_id") String emplan_id) {
        EMPlan domain = emplanService.get(emplan_id);
        EMPlanDTO dto = emplanMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(#emplan_id,'Remove',{'Sql',this.emplanMapping,this.permissionDTO})")
    @ApiOperation(value = "RemoveByEMEquip", tags = {"EMPlan" },  notes = "RemoveByEMEquip")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emequips/{emequip_id}/emplans/{emplan_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByEMEquip(@PathVariable("emequip_id") String emequip_id, @PathVariable("emplan_id") String emplan_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emplanService.remove(emplan_id));
    }

    @PreAuthorize("hasPermission('Remove',{'Sql',this.emplanMapping,this.permissionDTO,#ids})")
    @ApiOperation(value = "RemoveBatchByEMEquip", tags = {"EMPlan" },  notes = "RemoveBatchByEMEquip")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emequips/{emequip_id}/emplans/batch")
    public ResponseEntity<Boolean> removeBatchByEMEquip(@RequestBody List<String> ids) {
        emplanService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMPlan-GetDraft-all')")
    @ApiOperation(value = "GetDraftByEMEquip", tags = {"EMPlan" },  notes = "GetDraftByEMEquip")
    @RequestMapping(method = RequestMethod.GET, value = "/emequips/{emequip_id}/emplans/getdraft")
    public ResponseEntity<EMPlanDTO> getDraftByEMEquip(@PathVariable("emequip_id") String emequip_id) {
        EMPlan domain = new EMPlan();
        domain.setEquipid(emequip_id);
        return ResponseEntity.status(HttpStatus.OK).body(emplanMapping.toDto(emplanService.getDraft(domain)));
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMPlan-CheckKey-all')")
    @ApiOperation(value = "CheckKeyByEMEquip", tags = {"EMPlan" },  notes = "CheckKeyByEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/emequips/{emequip_id}/emplans/checkkey")
    public ResponseEntity<Boolean> checkKeyByEMEquip(@PathVariable("emequip_id") String emequip_id, @RequestBody EMPlanDTO emplandto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emplanService.checkKey(emplanMapping.toDomain(emplandto)));
    }

    @PreAuthorize("hasPermission('','Save',{'Sql',this.emplanMapping,#emplandto})")
    @ApiOperation(value = "SaveByEMEquip", tags = {"EMPlan" },  notes = "SaveByEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/emequips/{emequip_id}/emplans/save")
    public ResponseEntity<Boolean> saveByEMEquip(@PathVariable("emequip_id") String emequip_id, @RequestBody EMPlanDTO emplandto) {
        EMPlan domain = emplanMapping.toDomain(emplandto);
        domain.setEquipid(emequip_id);
        return ResponseEntity.status(HttpStatus.OK).body(emplanService.save(domain));
    }

    @PreAuthorize("hasPermission('Save',{'Sql',this.emplanMapping,#emplandtos})")
    @ApiOperation(value = "SaveBatchByEMEquip", tags = {"EMPlan" },  notes = "SaveBatchByEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/emequips/{emequip_id}/emplans/savebatch")
    public ResponseEntity<Boolean> saveBatchByEMEquip(@PathVariable("emequip_id") String emequip_id, @RequestBody List<EMPlanDTO> emplandtos) {
        List<EMPlan> domainlist=emplanMapping.toDomain(emplandtos);
        for(EMPlan domain:domainlist){
             domain.setEquipid(emequip_id);
        }
        emplanService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMPlan-Default-all')")
	@ApiOperation(value = "fetchDEFAULTByEMEquip", tags = {"EMPlan" } ,notes = "fetchDEFAULTByEMEquip")
    @RequestMapping(method= RequestMethod.GET , value="/emequips/{emequip_id}/emplans/fetchdefault")
	public ResponseEntity<List<EMPlanDTO>> fetchEMPlanDefaultByEMEquip(@PathVariable("emequip_id") String emequip_id,EMPlanSearchContext context) {
        context.setN_equipid_eq(emequip_id);
        Page<EMPlan> domains = emplanService.searchDefault(context) ;
        List<EMPlanDTO> list = emplanMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMPlan-Default-all')")
	@ApiOperation(value = "searchDEFAULTByEMEquip", tags = {"EMPlan" } ,notes = "searchDEFAULTByEMEquip")
    @RequestMapping(method= RequestMethod.POST , value="/emequips/{emequip_id}/emplans/searchdefault")
	public ResponseEntity<Page<EMPlanDTO>> searchEMPlanDefaultByEMEquip(@PathVariable("emequip_id") String emequip_id, @RequestBody EMPlanSearchContext context) {
        context.setN_equipid_eq(emequip_id);
        Page<EMPlan> domains = emplanService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emplanMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
    @PreAuthorize("hasPermission('','Create',{'Sql',this.emplanMapping,#emplandto})")
    @ApiOperation(value = "CreateByEMPlanTempl", tags = {"EMPlan" },  notes = "CreateByEMPlanTempl")
	@RequestMapping(method = RequestMethod.POST, value = "/emplantempls/{emplantempl_id}/emplans")
    @Transactional
    public ResponseEntity<EMPlanDTO> createByEMPlanTempl(@PathVariable("emplantempl_id") String emplantempl_id, @RequestBody EMPlanDTO emplandto) {
        EMPlan domain = emplanMapping.toDomain(emplandto);
        domain.setPlantemplid(emplantempl_id);
		emplanService.create(domain);
        EMPlanDTO dto = emplanMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Create',{'Sql',this.emplanMapping,#emplandtos})")
    @ApiOperation(value = "createBatchByEMPlanTempl", tags = {"EMPlan" },  notes = "createBatchByEMPlanTempl")
	@RequestMapping(method = RequestMethod.POST, value = "/emplantempls/{emplantempl_id}/emplans/batch")
    public ResponseEntity<Boolean> createBatchByEMPlanTempl(@PathVariable("emplantempl_id") String emplantempl_id, @RequestBody List<EMPlanDTO> emplandtos) {
        List<EMPlan> domainlist=emplanMapping.toDomain(emplandtos);
        for(EMPlan domain:domainlist){
            domain.setPlantemplid(emplantempl_id);
        }
        emplanService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(#emplan_id,'Update',{'Sql',this.emplanMapping,#emplandto})")
    @ApiOperation(value = "UpdateByEMPlanTempl", tags = {"EMPlan" },  notes = "UpdateByEMPlanTempl")
	@RequestMapping(method = RequestMethod.PUT, value = "/emplantempls/{emplantempl_id}/emplans/{emplan_id}")
    @Transactional
    public ResponseEntity<EMPlanDTO> updateByEMPlanTempl(@PathVariable("emplantempl_id") String emplantempl_id, @PathVariable("emplan_id") String emplan_id, @RequestBody EMPlanDTO emplandto) {
        EMPlan domain = emplanMapping.toDomain(emplandto);
        domain.setPlantemplid(emplantempl_id);
        domain.setEmplanid(emplan_id);
		emplanService.update(domain);
        EMPlanDTO dto = emplanMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Update',{'Sql',this.emplanMapping,#emplandtos})")
    @ApiOperation(value = "UpdateBatchByEMPlanTempl", tags = {"EMPlan" },  notes = "UpdateBatchByEMPlanTempl")
	@RequestMapping(method = RequestMethod.PUT, value = "/emplantempls/{emplantempl_id}/emplans/batch")
    public ResponseEntity<Boolean> updateBatchByEMPlanTempl(@PathVariable("emplantempl_id") String emplantempl_id, @RequestBody List<EMPlanDTO> emplandtos) {
        List<EMPlan> domainlist=emplanMapping.toDomain(emplandtos);
        for(EMPlan domain:domainlist){
            domain.setPlantemplid(emplantempl_id);
        }
        emplanService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(#emplan_id,'Get',{'Sql',this.emplanMapping,this.permissionDTO})")
    @ApiOperation(value = "GetByEMPlanTempl", tags = {"EMPlan" },  notes = "GetByEMPlanTempl")
	@RequestMapping(method = RequestMethod.GET, value = "/emplantempls/{emplantempl_id}/emplans/{emplan_id}")
    public ResponseEntity<EMPlanDTO> getByEMPlanTempl(@PathVariable("emplantempl_id") String emplantempl_id, @PathVariable("emplan_id") String emplan_id) {
        EMPlan domain = emplanService.get(emplan_id);
        EMPlanDTO dto = emplanMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(#emplan_id,'Remove',{'Sql',this.emplanMapping,this.permissionDTO})")
    @ApiOperation(value = "RemoveByEMPlanTempl", tags = {"EMPlan" },  notes = "RemoveByEMPlanTempl")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emplantempls/{emplantempl_id}/emplans/{emplan_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByEMPlanTempl(@PathVariable("emplantempl_id") String emplantempl_id, @PathVariable("emplan_id") String emplan_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emplanService.remove(emplan_id));
    }

    @PreAuthorize("hasPermission('Remove',{'Sql',this.emplanMapping,this.permissionDTO,#ids})")
    @ApiOperation(value = "RemoveBatchByEMPlanTempl", tags = {"EMPlan" },  notes = "RemoveBatchByEMPlanTempl")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emplantempls/{emplantempl_id}/emplans/batch")
    public ResponseEntity<Boolean> removeBatchByEMPlanTempl(@RequestBody List<String> ids) {
        emplanService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMPlan-GetDraft-all')")
    @ApiOperation(value = "GetDraftByEMPlanTempl", tags = {"EMPlan" },  notes = "GetDraftByEMPlanTempl")
    @RequestMapping(method = RequestMethod.GET, value = "/emplantempls/{emplantempl_id}/emplans/getdraft")
    public ResponseEntity<EMPlanDTO> getDraftByEMPlanTempl(@PathVariable("emplantempl_id") String emplantempl_id) {
        EMPlan domain = new EMPlan();
        domain.setPlantemplid(emplantempl_id);
        return ResponseEntity.status(HttpStatus.OK).body(emplanMapping.toDto(emplanService.getDraft(domain)));
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMPlan-CheckKey-all')")
    @ApiOperation(value = "CheckKeyByEMPlanTempl", tags = {"EMPlan" },  notes = "CheckKeyByEMPlanTempl")
	@RequestMapping(method = RequestMethod.POST, value = "/emplantempls/{emplantempl_id}/emplans/checkkey")
    public ResponseEntity<Boolean> checkKeyByEMPlanTempl(@PathVariable("emplantempl_id") String emplantempl_id, @RequestBody EMPlanDTO emplandto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emplanService.checkKey(emplanMapping.toDomain(emplandto)));
    }

    @PreAuthorize("hasPermission('','Save',{'Sql',this.emplanMapping,#emplandto})")
    @ApiOperation(value = "SaveByEMPlanTempl", tags = {"EMPlan" },  notes = "SaveByEMPlanTempl")
	@RequestMapping(method = RequestMethod.POST, value = "/emplantempls/{emplantempl_id}/emplans/save")
    public ResponseEntity<Boolean> saveByEMPlanTempl(@PathVariable("emplantempl_id") String emplantempl_id, @RequestBody EMPlanDTO emplandto) {
        EMPlan domain = emplanMapping.toDomain(emplandto);
        domain.setPlantemplid(emplantempl_id);
        return ResponseEntity.status(HttpStatus.OK).body(emplanService.save(domain));
    }

    @PreAuthorize("hasPermission('Save',{'Sql',this.emplanMapping,#emplandtos})")
    @ApiOperation(value = "SaveBatchByEMPlanTempl", tags = {"EMPlan" },  notes = "SaveBatchByEMPlanTempl")
	@RequestMapping(method = RequestMethod.POST, value = "/emplantempls/{emplantempl_id}/emplans/savebatch")
    public ResponseEntity<Boolean> saveBatchByEMPlanTempl(@PathVariable("emplantempl_id") String emplantempl_id, @RequestBody List<EMPlanDTO> emplandtos) {
        List<EMPlan> domainlist=emplanMapping.toDomain(emplandtos);
        for(EMPlan domain:domainlist){
             domain.setPlantemplid(emplantempl_id);
        }
        emplanService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMPlan-Default-all')")
	@ApiOperation(value = "fetchDEFAULTByEMPlanTempl", tags = {"EMPlan" } ,notes = "fetchDEFAULTByEMPlanTempl")
    @RequestMapping(method= RequestMethod.GET , value="/emplantempls/{emplantempl_id}/emplans/fetchdefault")
	public ResponseEntity<List<EMPlanDTO>> fetchEMPlanDefaultByEMPlanTempl(@PathVariable("emplantempl_id") String emplantempl_id,EMPlanSearchContext context) {
        context.setN_plantemplid_eq(emplantempl_id);
        Page<EMPlan> domains = emplanService.searchDefault(context) ;
        List<EMPlanDTO> list = emplanMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMPlan-Default-all')")
	@ApiOperation(value = "searchDEFAULTByEMPlanTempl", tags = {"EMPlan" } ,notes = "searchDEFAULTByEMPlanTempl")
    @RequestMapping(method= RequestMethod.POST , value="/emplantempls/{emplantempl_id}/emplans/searchdefault")
	public ResponseEntity<Page<EMPlanDTO>> searchEMPlanDefaultByEMPlanTempl(@PathVariable("emplantempl_id") String emplantempl_id, @RequestBody EMPlanSearchContext context) {
        context.setN_plantemplid_eq(emplantempl_id);
        Page<EMPlan> domains = emplanService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emplanMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
    @PreAuthorize("hasPermission('','Create',{'Sql',this.emplanMapping,#emplandto})")
    @ApiOperation(value = "CreateByEMService", tags = {"EMPlan" },  notes = "CreateByEMService")
	@RequestMapping(method = RequestMethod.POST, value = "/emservices/{emservice_id}/emplans")
    @Transactional
    public ResponseEntity<EMPlanDTO> createByEMService(@PathVariable("emservice_id") String emservice_id, @RequestBody EMPlanDTO emplandto) {
        EMPlan domain = emplanMapping.toDomain(emplandto);
        domain.setRserviceid(emservice_id);
		emplanService.create(domain);
        EMPlanDTO dto = emplanMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Create',{'Sql',this.emplanMapping,#emplandtos})")
    @ApiOperation(value = "createBatchByEMService", tags = {"EMPlan" },  notes = "createBatchByEMService")
	@RequestMapping(method = RequestMethod.POST, value = "/emservices/{emservice_id}/emplans/batch")
    public ResponseEntity<Boolean> createBatchByEMService(@PathVariable("emservice_id") String emservice_id, @RequestBody List<EMPlanDTO> emplandtos) {
        List<EMPlan> domainlist=emplanMapping.toDomain(emplandtos);
        for(EMPlan domain:domainlist){
            domain.setRserviceid(emservice_id);
        }
        emplanService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(#emplan_id,'Update',{'Sql',this.emplanMapping,#emplandto})")
    @ApiOperation(value = "UpdateByEMService", tags = {"EMPlan" },  notes = "UpdateByEMService")
	@RequestMapping(method = RequestMethod.PUT, value = "/emservices/{emservice_id}/emplans/{emplan_id}")
    @Transactional
    public ResponseEntity<EMPlanDTO> updateByEMService(@PathVariable("emservice_id") String emservice_id, @PathVariable("emplan_id") String emplan_id, @RequestBody EMPlanDTO emplandto) {
        EMPlan domain = emplanMapping.toDomain(emplandto);
        domain.setRserviceid(emservice_id);
        domain.setEmplanid(emplan_id);
		emplanService.update(domain);
        EMPlanDTO dto = emplanMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Update',{'Sql',this.emplanMapping,#emplandtos})")
    @ApiOperation(value = "UpdateBatchByEMService", tags = {"EMPlan" },  notes = "UpdateBatchByEMService")
	@RequestMapping(method = RequestMethod.PUT, value = "/emservices/{emservice_id}/emplans/batch")
    public ResponseEntity<Boolean> updateBatchByEMService(@PathVariable("emservice_id") String emservice_id, @RequestBody List<EMPlanDTO> emplandtos) {
        List<EMPlan> domainlist=emplanMapping.toDomain(emplandtos);
        for(EMPlan domain:domainlist){
            domain.setRserviceid(emservice_id);
        }
        emplanService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(#emplan_id,'Get',{'Sql',this.emplanMapping,this.permissionDTO})")
    @ApiOperation(value = "GetByEMService", tags = {"EMPlan" },  notes = "GetByEMService")
	@RequestMapping(method = RequestMethod.GET, value = "/emservices/{emservice_id}/emplans/{emplan_id}")
    public ResponseEntity<EMPlanDTO> getByEMService(@PathVariable("emservice_id") String emservice_id, @PathVariable("emplan_id") String emplan_id) {
        EMPlan domain = emplanService.get(emplan_id);
        EMPlanDTO dto = emplanMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(#emplan_id,'Remove',{'Sql',this.emplanMapping,this.permissionDTO})")
    @ApiOperation(value = "RemoveByEMService", tags = {"EMPlan" },  notes = "RemoveByEMService")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emservices/{emservice_id}/emplans/{emplan_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByEMService(@PathVariable("emservice_id") String emservice_id, @PathVariable("emplan_id") String emplan_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emplanService.remove(emplan_id));
    }

    @PreAuthorize("hasPermission('Remove',{'Sql',this.emplanMapping,this.permissionDTO,#ids})")
    @ApiOperation(value = "RemoveBatchByEMService", tags = {"EMPlan" },  notes = "RemoveBatchByEMService")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emservices/{emservice_id}/emplans/batch")
    public ResponseEntity<Boolean> removeBatchByEMService(@RequestBody List<String> ids) {
        emplanService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMPlan-GetDraft-all')")
    @ApiOperation(value = "GetDraftByEMService", tags = {"EMPlan" },  notes = "GetDraftByEMService")
    @RequestMapping(method = RequestMethod.GET, value = "/emservices/{emservice_id}/emplans/getdraft")
    public ResponseEntity<EMPlanDTO> getDraftByEMService(@PathVariable("emservice_id") String emservice_id) {
        EMPlan domain = new EMPlan();
        domain.setRserviceid(emservice_id);
        return ResponseEntity.status(HttpStatus.OK).body(emplanMapping.toDto(emplanService.getDraft(domain)));
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMPlan-CheckKey-all')")
    @ApiOperation(value = "CheckKeyByEMService", tags = {"EMPlan" },  notes = "CheckKeyByEMService")
	@RequestMapping(method = RequestMethod.POST, value = "/emservices/{emservice_id}/emplans/checkkey")
    public ResponseEntity<Boolean> checkKeyByEMService(@PathVariable("emservice_id") String emservice_id, @RequestBody EMPlanDTO emplandto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emplanService.checkKey(emplanMapping.toDomain(emplandto)));
    }

    @PreAuthorize("hasPermission('','Save',{'Sql',this.emplanMapping,#emplandto})")
    @ApiOperation(value = "SaveByEMService", tags = {"EMPlan" },  notes = "SaveByEMService")
	@RequestMapping(method = RequestMethod.POST, value = "/emservices/{emservice_id}/emplans/save")
    public ResponseEntity<Boolean> saveByEMService(@PathVariable("emservice_id") String emservice_id, @RequestBody EMPlanDTO emplandto) {
        EMPlan domain = emplanMapping.toDomain(emplandto);
        domain.setRserviceid(emservice_id);
        return ResponseEntity.status(HttpStatus.OK).body(emplanService.save(domain));
    }

    @PreAuthorize("hasPermission('Save',{'Sql',this.emplanMapping,#emplandtos})")
    @ApiOperation(value = "SaveBatchByEMService", tags = {"EMPlan" },  notes = "SaveBatchByEMService")
	@RequestMapping(method = RequestMethod.POST, value = "/emservices/{emservice_id}/emplans/savebatch")
    public ResponseEntity<Boolean> saveBatchByEMService(@PathVariable("emservice_id") String emservice_id, @RequestBody List<EMPlanDTO> emplandtos) {
        List<EMPlan> domainlist=emplanMapping.toDomain(emplandtos);
        for(EMPlan domain:domainlist){
             domain.setRserviceid(emservice_id);
        }
        emplanService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMPlan-Default-all')")
	@ApiOperation(value = "fetchDEFAULTByEMService", tags = {"EMPlan" } ,notes = "fetchDEFAULTByEMService")
    @RequestMapping(method= RequestMethod.GET , value="/emservices/{emservice_id}/emplans/fetchdefault")
	public ResponseEntity<List<EMPlanDTO>> fetchEMPlanDefaultByEMService(@PathVariable("emservice_id") String emservice_id,EMPlanSearchContext context) {
        context.setN_rserviceid_eq(emservice_id);
        Page<EMPlan> domains = emplanService.searchDefault(context) ;
        List<EMPlanDTO> list = emplanMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMPlan-Default-all')")
	@ApiOperation(value = "searchDEFAULTByEMService", tags = {"EMPlan" } ,notes = "searchDEFAULTByEMService")
    @RequestMapping(method= RequestMethod.POST , value="/emservices/{emservice_id}/emplans/searchdefault")
	public ResponseEntity<Page<EMPlanDTO>> searchEMPlanDefaultByEMService(@PathVariable("emservice_id") String emservice_id, @RequestBody EMPlanSearchContext context) {
        context.setN_rserviceid_eq(emservice_id);
        Page<EMPlan> domains = emplanService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emplanMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
    @PreAuthorize("hasPermission('','Create',{'Sql',this.emplanMapping,#emplandto})")
    @ApiOperation(value = "CreateByPFDept", tags = {"EMPlan" },  notes = "CreateByPFDept")
	@RequestMapping(method = RequestMethod.POST, value = "/pfdepts/{pfdept_id}/emplans")
    @Transactional
    public ResponseEntity<EMPlanDTO> createByPFDept(@PathVariable("pfdept_id") String pfdept_id, @RequestBody EMPlanDTO emplandto) {
        EMPlan domain = emplanMapping.toDomain(emplandto);
        domain.setRdeptid(pfdept_id);
		emplanService.create(domain);
        EMPlanDTO dto = emplanMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Create',{'Sql',this.emplanMapping,#emplandtos})")
    @ApiOperation(value = "createBatchByPFDept", tags = {"EMPlan" },  notes = "createBatchByPFDept")
	@RequestMapping(method = RequestMethod.POST, value = "/pfdepts/{pfdept_id}/emplans/batch")
    public ResponseEntity<Boolean> createBatchByPFDept(@PathVariable("pfdept_id") String pfdept_id, @RequestBody List<EMPlanDTO> emplandtos) {
        List<EMPlan> domainlist=emplanMapping.toDomain(emplandtos);
        for(EMPlan domain:domainlist){
            domain.setRdeptid(pfdept_id);
        }
        emplanService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(#emplan_id,'Update',{'Sql',this.emplanMapping,#emplandto})")
    @ApiOperation(value = "UpdateByPFDept", tags = {"EMPlan" },  notes = "UpdateByPFDept")
	@RequestMapping(method = RequestMethod.PUT, value = "/pfdepts/{pfdept_id}/emplans/{emplan_id}")
    @Transactional
    public ResponseEntity<EMPlanDTO> updateByPFDept(@PathVariable("pfdept_id") String pfdept_id, @PathVariable("emplan_id") String emplan_id, @RequestBody EMPlanDTO emplandto) {
        EMPlan domain = emplanMapping.toDomain(emplandto);
        domain.setRdeptid(pfdept_id);
        domain.setEmplanid(emplan_id);
		emplanService.update(domain);
        EMPlanDTO dto = emplanMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Update',{'Sql',this.emplanMapping,#emplandtos})")
    @ApiOperation(value = "UpdateBatchByPFDept", tags = {"EMPlan" },  notes = "UpdateBatchByPFDept")
	@RequestMapping(method = RequestMethod.PUT, value = "/pfdepts/{pfdept_id}/emplans/batch")
    public ResponseEntity<Boolean> updateBatchByPFDept(@PathVariable("pfdept_id") String pfdept_id, @RequestBody List<EMPlanDTO> emplandtos) {
        List<EMPlan> domainlist=emplanMapping.toDomain(emplandtos);
        for(EMPlan domain:domainlist){
            domain.setRdeptid(pfdept_id);
        }
        emplanService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(#emplan_id,'Get',{'Sql',this.emplanMapping,this.permissionDTO})")
    @ApiOperation(value = "GetByPFDept", tags = {"EMPlan" },  notes = "GetByPFDept")
	@RequestMapping(method = RequestMethod.GET, value = "/pfdepts/{pfdept_id}/emplans/{emplan_id}")
    public ResponseEntity<EMPlanDTO> getByPFDept(@PathVariable("pfdept_id") String pfdept_id, @PathVariable("emplan_id") String emplan_id) {
        EMPlan domain = emplanService.get(emplan_id);
        EMPlanDTO dto = emplanMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(#emplan_id,'Remove',{'Sql',this.emplanMapping,this.permissionDTO})")
    @ApiOperation(value = "RemoveByPFDept", tags = {"EMPlan" },  notes = "RemoveByPFDept")
	@RequestMapping(method = RequestMethod.DELETE, value = "/pfdepts/{pfdept_id}/emplans/{emplan_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByPFDept(@PathVariable("pfdept_id") String pfdept_id, @PathVariable("emplan_id") String emplan_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emplanService.remove(emplan_id));
    }

    @PreAuthorize("hasPermission('Remove',{'Sql',this.emplanMapping,this.permissionDTO,#ids})")
    @ApiOperation(value = "RemoveBatchByPFDept", tags = {"EMPlan" },  notes = "RemoveBatchByPFDept")
	@RequestMapping(method = RequestMethod.DELETE, value = "/pfdepts/{pfdept_id}/emplans/batch")
    public ResponseEntity<Boolean> removeBatchByPFDept(@RequestBody List<String> ids) {
        emplanService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMPlan-GetDraft-all')")
    @ApiOperation(value = "GetDraftByPFDept", tags = {"EMPlan" },  notes = "GetDraftByPFDept")
    @RequestMapping(method = RequestMethod.GET, value = "/pfdepts/{pfdept_id}/emplans/getdraft")
    public ResponseEntity<EMPlanDTO> getDraftByPFDept(@PathVariable("pfdept_id") String pfdept_id) {
        EMPlan domain = new EMPlan();
        domain.setRdeptid(pfdept_id);
        return ResponseEntity.status(HttpStatus.OK).body(emplanMapping.toDto(emplanService.getDraft(domain)));
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMPlan-CheckKey-all')")
    @ApiOperation(value = "CheckKeyByPFDept", tags = {"EMPlan" },  notes = "CheckKeyByPFDept")
	@RequestMapping(method = RequestMethod.POST, value = "/pfdepts/{pfdept_id}/emplans/checkkey")
    public ResponseEntity<Boolean> checkKeyByPFDept(@PathVariable("pfdept_id") String pfdept_id, @RequestBody EMPlanDTO emplandto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emplanService.checkKey(emplanMapping.toDomain(emplandto)));
    }

    @PreAuthorize("hasPermission('','Save',{'Sql',this.emplanMapping,#emplandto})")
    @ApiOperation(value = "SaveByPFDept", tags = {"EMPlan" },  notes = "SaveByPFDept")
	@RequestMapping(method = RequestMethod.POST, value = "/pfdepts/{pfdept_id}/emplans/save")
    public ResponseEntity<Boolean> saveByPFDept(@PathVariable("pfdept_id") String pfdept_id, @RequestBody EMPlanDTO emplandto) {
        EMPlan domain = emplanMapping.toDomain(emplandto);
        domain.setRdeptid(pfdept_id);
        return ResponseEntity.status(HttpStatus.OK).body(emplanService.save(domain));
    }

    @PreAuthorize("hasPermission('Save',{'Sql',this.emplanMapping,#emplandtos})")
    @ApiOperation(value = "SaveBatchByPFDept", tags = {"EMPlan" },  notes = "SaveBatchByPFDept")
	@RequestMapping(method = RequestMethod.POST, value = "/pfdepts/{pfdept_id}/emplans/savebatch")
    public ResponseEntity<Boolean> saveBatchByPFDept(@PathVariable("pfdept_id") String pfdept_id, @RequestBody List<EMPlanDTO> emplandtos) {
        List<EMPlan> domainlist=emplanMapping.toDomain(emplandtos);
        for(EMPlan domain:domainlist){
             domain.setRdeptid(pfdept_id);
        }
        emplanService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMPlan-Default-all')")
	@ApiOperation(value = "fetchDEFAULTByPFDept", tags = {"EMPlan" } ,notes = "fetchDEFAULTByPFDept")
    @RequestMapping(method= RequestMethod.GET , value="/pfdepts/{pfdept_id}/emplans/fetchdefault")
	public ResponseEntity<List<EMPlanDTO>> fetchEMPlanDefaultByPFDept(@PathVariable("pfdept_id") String pfdept_id,EMPlanSearchContext context) {
        context.setN_rdeptid_eq(pfdept_id);
        Page<EMPlan> domains = emplanService.searchDefault(context) ;
        List<EMPlanDTO> list = emplanMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMPlan-Default-all')")
	@ApiOperation(value = "searchDEFAULTByPFDept", tags = {"EMPlan" } ,notes = "searchDEFAULTByPFDept")
    @RequestMapping(method= RequestMethod.POST , value="/pfdepts/{pfdept_id}/emplans/searchdefault")
	public ResponseEntity<Page<EMPlanDTO>> searchEMPlanDefaultByPFDept(@PathVariable("pfdept_id") String pfdept_id, @RequestBody EMPlanSearchContext context) {
        context.setN_rdeptid_eq(pfdept_id);
        Page<EMPlan> domains = emplanService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emplanMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
    @PreAuthorize("hasPermission('','Create',{'Sql',this.emplanMapping,#emplandto})")
    @ApiOperation(value = "CreateByPFEmp", tags = {"EMPlan" },  notes = "CreateByPFEmp")
	@RequestMapping(method = RequestMethod.POST, value = "/pfemps/{pfemp_id}/emplans")
    @Transactional
    public ResponseEntity<EMPlanDTO> createByPFEmp(@PathVariable("pfemp_id") String pfemp_id, @RequestBody EMPlanDTO emplandto) {
        EMPlan domain = emplanMapping.toDomain(emplandto);
        domain.setMpersonid(pfemp_id);
		emplanService.create(domain);
        EMPlanDTO dto = emplanMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Create',{'Sql',this.emplanMapping,#emplandtos})")
    @ApiOperation(value = "createBatchByPFEmp", tags = {"EMPlan" },  notes = "createBatchByPFEmp")
	@RequestMapping(method = RequestMethod.POST, value = "/pfemps/{pfemp_id}/emplans/batch")
    public ResponseEntity<Boolean> createBatchByPFEmp(@PathVariable("pfemp_id") String pfemp_id, @RequestBody List<EMPlanDTO> emplandtos) {
        List<EMPlan> domainlist=emplanMapping.toDomain(emplandtos);
        for(EMPlan domain:domainlist){
            domain.setMpersonid(pfemp_id);
        }
        emplanService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(#emplan_id,'Update',{'Sql',this.emplanMapping,#emplandto})")
    @ApiOperation(value = "UpdateByPFEmp", tags = {"EMPlan" },  notes = "UpdateByPFEmp")
	@RequestMapping(method = RequestMethod.PUT, value = "/pfemps/{pfemp_id}/emplans/{emplan_id}")
    @Transactional
    public ResponseEntity<EMPlanDTO> updateByPFEmp(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emplan_id") String emplan_id, @RequestBody EMPlanDTO emplandto) {
        EMPlan domain = emplanMapping.toDomain(emplandto);
        domain.setMpersonid(pfemp_id);
        domain.setEmplanid(emplan_id);
		emplanService.update(domain);
        EMPlanDTO dto = emplanMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Update',{'Sql',this.emplanMapping,#emplandtos})")
    @ApiOperation(value = "UpdateBatchByPFEmp", tags = {"EMPlan" },  notes = "UpdateBatchByPFEmp")
	@RequestMapping(method = RequestMethod.PUT, value = "/pfemps/{pfemp_id}/emplans/batch")
    public ResponseEntity<Boolean> updateBatchByPFEmp(@PathVariable("pfemp_id") String pfemp_id, @RequestBody List<EMPlanDTO> emplandtos) {
        List<EMPlan> domainlist=emplanMapping.toDomain(emplandtos);
        for(EMPlan domain:domainlist){
            domain.setMpersonid(pfemp_id);
        }
        emplanService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(#emplan_id,'Get',{'Sql',this.emplanMapping,this.permissionDTO})")
    @ApiOperation(value = "GetByPFEmp", tags = {"EMPlan" },  notes = "GetByPFEmp")
	@RequestMapping(method = RequestMethod.GET, value = "/pfemps/{pfemp_id}/emplans/{emplan_id}")
    public ResponseEntity<EMPlanDTO> getByPFEmp(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emplan_id") String emplan_id) {
        EMPlan domain = emplanService.get(emplan_id);
        EMPlanDTO dto = emplanMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(#emplan_id,'Remove',{'Sql',this.emplanMapping,this.permissionDTO})")
    @ApiOperation(value = "RemoveByPFEmp", tags = {"EMPlan" },  notes = "RemoveByPFEmp")
	@RequestMapping(method = RequestMethod.DELETE, value = "/pfemps/{pfemp_id}/emplans/{emplan_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByPFEmp(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emplan_id") String emplan_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emplanService.remove(emplan_id));
    }

    @PreAuthorize("hasPermission('Remove',{'Sql',this.emplanMapping,this.permissionDTO,#ids})")
    @ApiOperation(value = "RemoveBatchByPFEmp", tags = {"EMPlan" },  notes = "RemoveBatchByPFEmp")
	@RequestMapping(method = RequestMethod.DELETE, value = "/pfemps/{pfemp_id}/emplans/batch")
    public ResponseEntity<Boolean> removeBatchByPFEmp(@RequestBody List<String> ids) {
        emplanService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMPlan-GetDraft-all')")
    @ApiOperation(value = "GetDraftByPFEmp", tags = {"EMPlan" },  notes = "GetDraftByPFEmp")
    @RequestMapping(method = RequestMethod.GET, value = "/pfemps/{pfemp_id}/emplans/getdraft")
    public ResponseEntity<EMPlanDTO> getDraftByPFEmp(@PathVariable("pfemp_id") String pfemp_id) {
        EMPlan domain = new EMPlan();
        domain.setMpersonid(pfemp_id);
        return ResponseEntity.status(HttpStatus.OK).body(emplanMapping.toDto(emplanService.getDraft(domain)));
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMPlan-CheckKey-all')")
    @ApiOperation(value = "CheckKeyByPFEmp", tags = {"EMPlan" },  notes = "CheckKeyByPFEmp")
	@RequestMapping(method = RequestMethod.POST, value = "/pfemps/{pfemp_id}/emplans/checkkey")
    public ResponseEntity<Boolean> checkKeyByPFEmp(@PathVariable("pfemp_id") String pfemp_id, @RequestBody EMPlanDTO emplandto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emplanService.checkKey(emplanMapping.toDomain(emplandto)));
    }

    @PreAuthorize("hasPermission('','Save',{'Sql',this.emplanMapping,#emplandto})")
    @ApiOperation(value = "SaveByPFEmp", tags = {"EMPlan" },  notes = "SaveByPFEmp")
	@RequestMapping(method = RequestMethod.POST, value = "/pfemps/{pfemp_id}/emplans/save")
    public ResponseEntity<Boolean> saveByPFEmp(@PathVariable("pfemp_id") String pfemp_id, @RequestBody EMPlanDTO emplandto) {
        EMPlan domain = emplanMapping.toDomain(emplandto);
        domain.setMpersonid(pfemp_id);
        return ResponseEntity.status(HttpStatus.OK).body(emplanService.save(domain));
    }

    @PreAuthorize("hasPermission('Save',{'Sql',this.emplanMapping,#emplandtos})")
    @ApiOperation(value = "SaveBatchByPFEmp", tags = {"EMPlan" },  notes = "SaveBatchByPFEmp")
	@RequestMapping(method = RequestMethod.POST, value = "/pfemps/{pfemp_id}/emplans/savebatch")
    public ResponseEntity<Boolean> saveBatchByPFEmp(@PathVariable("pfemp_id") String pfemp_id, @RequestBody List<EMPlanDTO> emplandtos) {
        List<EMPlan> domainlist=emplanMapping.toDomain(emplandtos);
        for(EMPlan domain:domainlist){
             domain.setMpersonid(pfemp_id);
        }
        emplanService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMPlan-Default-all')")
	@ApiOperation(value = "fetchDEFAULTByPFEmp", tags = {"EMPlan" } ,notes = "fetchDEFAULTByPFEmp")
    @RequestMapping(method= RequestMethod.GET , value="/pfemps/{pfemp_id}/emplans/fetchdefault")
	public ResponseEntity<List<EMPlanDTO>> fetchEMPlanDefaultByPFEmp(@PathVariable("pfemp_id") String pfemp_id,EMPlanSearchContext context) {
        context.setN_mpersonid_eq(pfemp_id);
        Page<EMPlan> domains = emplanService.searchDefault(context) ;
        List<EMPlanDTO> list = emplanMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMPlan-Default-all')")
	@ApiOperation(value = "searchDEFAULTByPFEmp", tags = {"EMPlan" } ,notes = "searchDEFAULTByPFEmp")
    @RequestMapping(method= RequestMethod.POST , value="/pfemps/{pfemp_id}/emplans/searchdefault")
	public ResponseEntity<Page<EMPlanDTO>> searchEMPlanDefaultByPFEmp(@PathVariable("pfemp_id") String pfemp_id, @RequestBody EMPlanSearchContext context) {
        context.setN_mpersonid_eq(pfemp_id);
        Page<EMPlan> domains = emplanService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emplanMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
    @PreAuthorize("hasPermission('','Create',{'Sql',this.emplanMapping,#emplandto})")
    @ApiOperation(value = "CreateByPFTeam", tags = {"EMPlan" },  notes = "CreateByPFTeam")
	@RequestMapping(method = RequestMethod.POST, value = "/pfteams/{pfteam_id}/emplans")
    @Transactional
    public ResponseEntity<EMPlanDTO> createByPFTeam(@PathVariable("pfteam_id") String pfteam_id, @RequestBody EMPlanDTO emplandto) {
        EMPlan domain = emplanMapping.toDomain(emplandto);
        domain.setRteamid(pfteam_id);
		emplanService.create(domain);
        EMPlanDTO dto = emplanMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Create',{'Sql',this.emplanMapping,#emplandtos})")
    @ApiOperation(value = "createBatchByPFTeam", tags = {"EMPlan" },  notes = "createBatchByPFTeam")
	@RequestMapping(method = RequestMethod.POST, value = "/pfteams/{pfteam_id}/emplans/batch")
    public ResponseEntity<Boolean> createBatchByPFTeam(@PathVariable("pfteam_id") String pfteam_id, @RequestBody List<EMPlanDTO> emplandtos) {
        List<EMPlan> domainlist=emplanMapping.toDomain(emplandtos);
        for(EMPlan domain:domainlist){
            domain.setRteamid(pfteam_id);
        }
        emplanService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(#emplan_id,'Update',{'Sql',this.emplanMapping,#emplandto})")
    @ApiOperation(value = "UpdateByPFTeam", tags = {"EMPlan" },  notes = "UpdateByPFTeam")
	@RequestMapping(method = RequestMethod.PUT, value = "/pfteams/{pfteam_id}/emplans/{emplan_id}")
    @Transactional
    public ResponseEntity<EMPlanDTO> updateByPFTeam(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emplan_id") String emplan_id, @RequestBody EMPlanDTO emplandto) {
        EMPlan domain = emplanMapping.toDomain(emplandto);
        domain.setRteamid(pfteam_id);
        domain.setEmplanid(emplan_id);
		emplanService.update(domain);
        EMPlanDTO dto = emplanMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Update',{'Sql',this.emplanMapping,#emplandtos})")
    @ApiOperation(value = "UpdateBatchByPFTeam", tags = {"EMPlan" },  notes = "UpdateBatchByPFTeam")
	@RequestMapping(method = RequestMethod.PUT, value = "/pfteams/{pfteam_id}/emplans/batch")
    public ResponseEntity<Boolean> updateBatchByPFTeam(@PathVariable("pfteam_id") String pfteam_id, @RequestBody List<EMPlanDTO> emplandtos) {
        List<EMPlan> domainlist=emplanMapping.toDomain(emplandtos);
        for(EMPlan domain:domainlist){
            domain.setRteamid(pfteam_id);
        }
        emplanService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(#emplan_id,'Get',{'Sql',this.emplanMapping,this.permissionDTO})")
    @ApiOperation(value = "GetByPFTeam", tags = {"EMPlan" },  notes = "GetByPFTeam")
	@RequestMapping(method = RequestMethod.GET, value = "/pfteams/{pfteam_id}/emplans/{emplan_id}")
    public ResponseEntity<EMPlanDTO> getByPFTeam(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emplan_id") String emplan_id) {
        EMPlan domain = emplanService.get(emplan_id);
        EMPlanDTO dto = emplanMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(#emplan_id,'Remove',{'Sql',this.emplanMapping,this.permissionDTO})")
    @ApiOperation(value = "RemoveByPFTeam", tags = {"EMPlan" },  notes = "RemoveByPFTeam")
	@RequestMapping(method = RequestMethod.DELETE, value = "/pfteams/{pfteam_id}/emplans/{emplan_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByPFTeam(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emplan_id") String emplan_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emplanService.remove(emplan_id));
    }

    @PreAuthorize("hasPermission('Remove',{'Sql',this.emplanMapping,this.permissionDTO,#ids})")
    @ApiOperation(value = "RemoveBatchByPFTeam", tags = {"EMPlan" },  notes = "RemoveBatchByPFTeam")
	@RequestMapping(method = RequestMethod.DELETE, value = "/pfteams/{pfteam_id}/emplans/batch")
    public ResponseEntity<Boolean> removeBatchByPFTeam(@RequestBody List<String> ids) {
        emplanService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMPlan-GetDraft-all')")
    @ApiOperation(value = "GetDraftByPFTeam", tags = {"EMPlan" },  notes = "GetDraftByPFTeam")
    @RequestMapping(method = RequestMethod.GET, value = "/pfteams/{pfteam_id}/emplans/getdraft")
    public ResponseEntity<EMPlanDTO> getDraftByPFTeam(@PathVariable("pfteam_id") String pfteam_id) {
        EMPlan domain = new EMPlan();
        domain.setRteamid(pfteam_id);
        return ResponseEntity.status(HttpStatus.OK).body(emplanMapping.toDto(emplanService.getDraft(domain)));
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMPlan-CheckKey-all')")
    @ApiOperation(value = "CheckKeyByPFTeam", tags = {"EMPlan" },  notes = "CheckKeyByPFTeam")
	@RequestMapping(method = RequestMethod.POST, value = "/pfteams/{pfteam_id}/emplans/checkkey")
    public ResponseEntity<Boolean> checkKeyByPFTeam(@PathVariable("pfteam_id") String pfteam_id, @RequestBody EMPlanDTO emplandto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emplanService.checkKey(emplanMapping.toDomain(emplandto)));
    }

    @PreAuthorize("hasPermission('','Save',{'Sql',this.emplanMapping,#emplandto})")
    @ApiOperation(value = "SaveByPFTeam", tags = {"EMPlan" },  notes = "SaveByPFTeam")
	@RequestMapping(method = RequestMethod.POST, value = "/pfteams/{pfteam_id}/emplans/save")
    public ResponseEntity<Boolean> saveByPFTeam(@PathVariable("pfteam_id") String pfteam_id, @RequestBody EMPlanDTO emplandto) {
        EMPlan domain = emplanMapping.toDomain(emplandto);
        domain.setRteamid(pfteam_id);
        return ResponseEntity.status(HttpStatus.OK).body(emplanService.save(domain));
    }

    @PreAuthorize("hasPermission('Save',{'Sql',this.emplanMapping,#emplandtos})")
    @ApiOperation(value = "SaveBatchByPFTeam", tags = {"EMPlan" },  notes = "SaveBatchByPFTeam")
	@RequestMapping(method = RequestMethod.POST, value = "/pfteams/{pfteam_id}/emplans/savebatch")
    public ResponseEntity<Boolean> saveBatchByPFTeam(@PathVariable("pfteam_id") String pfteam_id, @RequestBody List<EMPlanDTO> emplandtos) {
        List<EMPlan> domainlist=emplanMapping.toDomain(emplandtos);
        for(EMPlan domain:domainlist){
             domain.setRteamid(pfteam_id);
        }
        emplanService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMPlan-Default-all')")
	@ApiOperation(value = "fetchDEFAULTByPFTeam", tags = {"EMPlan" } ,notes = "fetchDEFAULTByPFTeam")
    @RequestMapping(method= RequestMethod.GET , value="/pfteams/{pfteam_id}/emplans/fetchdefault")
	public ResponseEntity<List<EMPlanDTO>> fetchEMPlanDefaultByPFTeam(@PathVariable("pfteam_id") String pfteam_id,EMPlanSearchContext context) {
        context.setN_rteamid_eq(pfteam_id);
        Page<EMPlan> domains = emplanService.searchDefault(context) ;
        List<EMPlanDTO> list = emplanMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMPlan-Default-all')")
	@ApiOperation(value = "searchDEFAULTByPFTeam", tags = {"EMPlan" } ,notes = "searchDEFAULTByPFTeam")
    @RequestMapping(method= RequestMethod.POST , value="/pfteams/{pfteam_id}/emplans/searchdefault")
	public ResponseEntity<Page<EMPlanDTO>> searchEMPlanDefaultByPFTeam(@PathVariable("pfteam_id") String pfteam_id, @RequestBody EMPlanSearchContext context) {
        context.setN_rteamid_eq(pfteam_id);
        Page<EMPlan> domains = emplanService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emplanMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
    @PreAuthorize("hasPermission('','Create',{'Sql',this.emplanMapping,#emplandto})")
    @ApiOperation(value = "CreateByEMEQTypeEMEquip", tags = {"EMPlan" },  notes = "CreateByEMEQTypeEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emplans")
    @Transactional
    public ResponseEntity<EMPlanDTO> createByEMEQTypeEMEquip(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id, @RequestBody EMPlanDTO emplandto) {
        EMPlan domain = emplanMapping.toDomain(emplandto);
        domain.setEquipid(emequip_id);
		emplanService.create(domain);
        EMPlanDTO dto = emplanMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Create',{'Sql',this.emplanMapping,#emplandtos})")
    @ApiOperation(value = "createBatchByEMEQTypeEMEquip", tags = {"EMPlan" },  notes = "createBatchByEMEQTypeEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emplans/batch")
    public ResponseEntity<Boolean> createBatchByEMEQTypeEMEquip(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id, @RequestBody List<EMPlanDTO> emplandtos) {
        List<EMPlan> domainlist=emplanMapping.toDomain(emplandtos);
        for(EMPlan domain:domainlist){
            domain.setEquipid(emequip_id);
        }
        emplanService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(#emplan_id,'Update',{'Sql',this.emplanMapping,#emplandto})")
    @ApiOperation(value = "UpdateByEMEQTypeEMEquip", tags = {"EMPlan" },  notes = "UpdateByEMEQTypeEMEquip")
	@RequestMapping(method = RequestMethod.PUT, value = "/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emplans/{emplan_id}")
    @Transactional
    public ResponseEntity<EMPlanDTO> updateByEMEQTypeEMEquip(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id, @PathVariable("emplan_id") String emplan_id, @RequestBody EMPlanDTO emplandto) {
        EMPlan domain = emplanMapping.toDomain(emplandto);
        domain.setEquipid(emequip_id);
        domain.setEmplanid(emplan_id);
		emplanService.update(domain);
        EMPlanDTO dto = emplanMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Update',{'Sql',this.emplanMapping,#emplandtos})")
    @ApiOperation(value = "UpdateBatchByEMEQTypeEMEquip", tags = {"EMPlan" },  notes = "UpdateBatchByEMEQTypeEMEquip")
	@RequestMapping(method = RequestMethod.PUT, value = "/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emplans/batch")
    public ResponseEntity<Boolean> updateBatchByEMEQTypeEMEquip(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id, @RequestBody List<EMPlanDTO> emplandtos) {
        List<EMPlan> domainlist=emplanMapping.toDomain(emplandtos);
        for(EMPlan domain:domainlist){
            domain.setEquipid(emequip_id);
        }
        emplanService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(#emplan_id,'Get',{'Sql',this.emplanMapping,this.permissionDTO})")
    @ApiOperation(value = "GetByEMEQTypeEMEquip", tags = {"EMPlan" },  notes = "GetByEMEQTypeEMEquip")
	@RequestMapping(method = RequestMethod.GET, value = "/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emplans/{emplan_id}")
    public ResponseEntity<EMPlanDTO> getByEMEQTypeEMEquip(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id, @PathVariable("emplan_id") String emplan_id) {
        EMPlan domain = emplanService.get(emplan_id);
        EMPlanDTO dto = emplanMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(#emplan_id,'Remove',{'Sql',this.emplanMapping,this.permissionDTO})")
    @ApiOperation(value = "RemoveByEMEQTypeEMEquip", tags = {"EMPlan" },  notes = "RemoveByEMEQTypeEMEquip")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emplans/{emplan_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByEMEQTypeEMEquip(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id, @PathVariable("emplan_id") String emplan_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emplanService.remove(emplan_id));
    }

    @PreAuthorize("hasPermission('Remove',{'Sql',this.emplanMapping,this.permissionDTO,#ids})")
    @ApiOperation(value = "RemoveBatchByEMEQTypeEMEquip", tags = {"EMPlan" },  notes = "RemoveBatchByEMEQTypeEMEquip")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emplans/batch")
    public ResponseEntity<Boolean> removeBatchByEMEQTypeEMEquip(@RequestBody List<String> ids) {
        emplanService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMPlan-GetDraft-all')")
    @ApiOperation(value = "GetDraftByEMEQTypeEMEquip", tags = {"EMPlan" },  notes = "GetDraftByEMEQTypeEMEquip")
    @RequestMapping(method = RequestMethod.GET, value = "/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emplans/getdraft")
    public ResponseEntity<EMPlanDTO> getDraftByEMEQTypeEMEquip(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id) {
        EMPlan domain = new EMPlan();
        domain.setEquipid(emequip_id);
        return ResponseEntity.status(HttpStatus.OK).body(emplanMapping.toDto(emplanService.getDraft(domain)));
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMPlan-CheckKey-all')")
    @ApiOperation(value = "CheckKeyByEMEQTypeEMEquip", tags = {"EMPlan" },  notes = "CheckKeyByEMEQTypeEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emplans/checkkey")
    public ResponseEntity<Boolean> checkKeyByEMEQTypeEMEquip(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id, @RequestBody EMPlanDTO emplandto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emplanService.checkKey(emplanMapping.toDomain(emplandto)));
    }

    @PreAuthorize("hasPermission('','Save',{'Sql',this.emplanMapping,#emplandto})")
    @ApiOperation(value = "SaveByEMEQTypeEMEquip", tags = {"EMPlan" },  notes = "SaveByEMEQTypeEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emplans/save")
    public ResponseEntity<Boolean> saveByEMEQTypeEMEquip(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id, @RequestBody EMPlanDTO emplandto) {
        EMPlan domain = emplanMapping.toDomain(emplandto);
        domain.setEquipid(emequip_id);
        return ResponseEntity.status(HttpStatus.OK).body(emplanService.save(domain));
    }

    @PreAuthorize("hasPermission('Save',{'Sql',this.emplanMapping,#emplandtos})")
    @ApiOperation(value = "SaveBatchByEMEQTypeEMEquip", tags = {"EMPlan" },  notes = "SaveBatchByEMEQTypeEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emplans/savebatch")
    public ResponseEntity<Boolean> saveBatchByEMEQTypeEMEquip(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id, @RequestBody List<EMPlanDTO> emplandtos) {
        List<EMPlan> domainlist=emplanMapping.toDomain(emplandtos);
        for(EMPlan domain:domainlist){
             domain.setEquipid(emequip_id);
        }
        emplanService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMPlan-Default-all')")
	@ApiOperation(value = "fetchDEFAULTByEMEQTypeEMEquip", tags = {"EMPlan" } ,notes = "fetchDEFAULTByEMEQTypeEMEquip")
    @RequestMapping(method= RequestMethod.GET , value="/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emplans/fetchdefault")
	public ResponseEntity<List<EMPlanDTO>> fetchEMPlanDefaultByEMEQTypeEMEquip(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id,EMPlanSearchContext context) {
        context.setN_equipid_eq(emequip_id);
        Page<EMPlan> domains = emplanService.searchDefault(context) ;
        List<EMPlanDTO> list = emplanMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMPlan-Default-all')")
	@ApiOperation(value = "searchDEFAULTByEMEQTypeEMEquip", tags = {"EMPlan" } ,notes = "searchDEFAULTByEMEQTypeEMEquip")
    @RequestMapping(method= RequestMethod.POST , value="/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emplans/searchdefault")
	public ResponseEntity<Page<EMPlanDTO>> searchEMPlanDefaultByEMEQTypeEMEquip(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id, @RequestBody EMPlanSearchContext context) {
        context.setN_equipid_eq(emequip_id);
        Page<EMPlan> domains = emplanService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emplanMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
    @PreAuthorize("hasPermission('','Create',{'Sql',this.emplanMapping,#emplandto})")
    @ApiOperation(value = "CreateByPFTeamEMEquip", tags = {"EMPlan" },  notes = "CreateByPFTeamEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/pfteams/{pfteam_id}/emequips/{emequip_id}/emplans")
    @Transactional
    public ResponseEntity<EMPlanDTO> createByPFTeamEMEquip(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id, @RequestBody EMPlanDTO emplandto) {
        EMPlan domain = emplanMapping.toDomain(emplandto);
        domain.setEquipid(emequip_id);
		emplanService.create(domain);
        EMPlanDTO dto = emplanMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Create',{'Sql',this.emplanMapping,#emplandtos})")
    @ApiOperation(value = "createBatchByPFTeamEMEquip", tags = {"EMPlan" },  notes = "createBatchByPFTeamEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/pfteams/{pfteam_id}/emequips/{emequip_id}/emplans/batch")
    public ResponseEntity<Boolean> createBatchByPFTeamEMEquip(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id, @RequestBody List<EMPlanDTO> emplandtos) {
        List<EMPlan> domainlist=emplanMapping.toDomain(emplandtos);
        for(EMPlan domain:domainlist){
            domain.setEquipid(emequip_id);
        }
        emplanService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(#emplan_id,'Update',{'Sql',this.emplanMapping,#emplandto})")
    @ApiOperation(value = "UpdateByPFTeamEMEquip", tags = {"EMPlan" },  notes = "UpdateByPFTeamEMEquip")
	@RequestMapping(method = RequestMethod.PUT, value = "/pfteams/{pfteam_id}/emequips/{emequip_id}/emplans/{emplan_id}")
    @Transactional
    public ResponseEntity<EMPlanDTO> updateByPFTeamEMEquip(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id, @PathVariable("emplan_id") String emplan_id, @RequestBody EMPlanDTO emplandto) {
        EMPlan domain = emplanMapping.toDomain(emplandto);
        domain.setEquipid(emequip_id);
        domain.setEmplanid(emplan_id);
		emplanService.update(domain);
        EMPlanDTO dto = emplanMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Update',{'Sql',this.emplanMapping,#emplandtos})")
    @ApiOperation(value = "UpdateBatchByPFTeamEMEquip", tags = {"EMPlan" },  notes = "UpdateBatchByPFTeamEMEquip")
	@RequestMapping(method = RequestMethod.PUT, value = "/pfteams/{pfteam_id}/emequips/{emequip_id}/emplans/batch")
    public ResponseEntity<Boolean> updateBatchByPFTeamEMEquip(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id, @RequestBody List<EMPlanDTO> emplandtos) {
        List<EMPlan> domainlist=emplanMapping.toDomain(emplandtos);
        for(EMPlan domain:domainlist){
            domain.setEquipid(emequip_id);
        }
        emplanService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(#emplan_id,'Get',{'Sql',this.emplanMapping,this.permissionDTO})")
    @ApiOperation(value = "GetByPFTeamEMEquip", tags = {"EMPlan" },  notes = "GetByPFTeamEMEquip")
	@RequestMapping(method = RequestMethod.GET, value = "/pfteams/{pfteam_id}/emequips/{emequip_id}/emplans/{emplan_id}")
    public ResponseEntity<EMPlanDTO> getByPFTeamEMEquip(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id, @PathVariable("emplan_id") String emplan_id) {
        EMPlan domain = emplanService.get(emplan_id);
        EMPlanDTO dto = emplanMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(#emplan_id,'Remove',{'Sql',this.emplanMapping,this.permissionDTO})")
    @ApiOperation(value = "RemoveByPFTeamEMEquip", tags = {"EMPlan" },  notes = "RemoveByPFTeamEMEquip")
	@RequestMapping(method = RequestMethod.DELETE, value = "/pfteams/{pfteam_id}/emequips/{emequip_id}/emplans/{emplan_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByPFTeamEMEquip(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id, @PathVariable("emplan_id") String emplan_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emplanService.remove(emplan_id));
    }

    @PreAuthorize("hasPermission('Remove',{'Sql',this.emplanMapping,this.permissionDTO,#ids})")
    @ApiOperation(value = "RemoveBatchByPFTeamEMEquip", tags = {"EMPlan" },  notes = "RemoveBatchByPFTeamEMEquip")
	@RequestMapping(method = RequestMethod.DELETE, value = "/pfteams/{pfteam_id}/emequips/{emequip_id}/emplans/batch")
    public ResponseEntity<Boolean> removeBatchByPFTeamEMEquip(@RequestBody List<String> ids) {
        emplanService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMPlan-GetDraft-all')")
    @ApiOperation(value = "GetDraftByPFTeamEMEquip", tags = {"EMPlan" },  notes = "GetDraftByPFTeamEMEquip")
    @RequestMapping(method = RequestMethod.GET, value = "/pfteams/{pfteam_id}/emequips/{emequip_id}/emplans/getdraft")
    public ResponseEntity<EMPlanDTO> getDraftByPFTeamEMEquip(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id) {
        EMPlan domain = new EMPlan();
        domain.setEquipid(emequip_id);
        return ResponseEntity.status(HttpStatus.OK).body(emplanMapping.toDto(emplanService.getDraft(domain)));
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMPlan-CheckKey-all')")
    @ApiOperation(value = "CheckKeyByPFTeamEMEquip", tags = {"EMPlan" },  notes = "CheckKeyByPFTeamEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/pfteams/{pfteam_id}/emequips/{emequip_id}/emplans/checkkey")
    public ResponseEntity<Boolean> checkKeyByPFTeamEMEquip(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id, @RequestBody EMPlanDTO emplandto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emplanService.checkKey(emplanMapping.toDomain(emplandto)));
    }

    @PreAuthorize("hasPermission('','Save',{'Sql',this.emplanMapping,#emplandto})")
    @ApiOperation(value = "SaveByPFTeamEMEquip", tags = {"EMPlan" },  notes = "SaveByPFTeamEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/pfteams/{pfteam_id}/emequips/{emequip_id}/emplans/save")
    public ResponseEntity<Boolean> saveByPFTeamEMEquip(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id, @RequestBody EMPlanDTO emplandto) {
        EMPlan domain = emplanMapping.toDomain(emplandto);
        domain.setEquipid(emequip_id);
        return ResponseEntity.status(HttpStatus.OK).body(emplanService.save(domain));
    }

    @PreAuthorize("hasPermission('Save',{'Sql',this.emplanMapping,#emplandtos})")
    @ApiOperation(value = "SaveBatchByPFTeamEMEquip", tags = {"EMPlan" },  notes = "SaveBatchByPFTeamEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/pfteams/{pfteam_id}/emequips/{emequip_id}/emplans/savebatch")
    public ResponseEntity<Boolean> saveBatchByPFTeamEMEquip(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id, @RequestBody List<EMPlanDTO> emplandtos) {
        List<EMPlan> domainlist=emplanMapping.toDomain(emplandtos);
        for(EMPlan domain:domainlist){
             domain.setEquipid(emequip_id);
        }
        emplanService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMPlan-Default-all')")
	@ApiOperation(value = "fetchDEFAULTByPFTeamEMEquip", tags = {"EMPlan" } ,notes = "fetchDEFAULTByPFTeamEMEquip")
    @RequestMapping(method= RequestMethod.GET , value="/pfteams/{pfteam_id}/emequips/{emequip_id}/emplans/fetchdefault")
	public ResponseEntity<List<EMPlanDTO>> fetchEMPlanDefaultByPFTeamEMEquip(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id,EMPlanSearchContext context) {
        context.setN_equipid_eq(emequip_id);
        Page<EMPlan> domains = emplanService.searchDefault(context) ;
        List<EMPlanDTO> list = emplanMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMPlan-Default-all')")
	@ApiOperation(value = "searchDEFAULTByPFTeamEMEquip", tags = {"EMPlan" } ,notes = "searchDEFAULTByPFTeamEMEquip")
    @RequestMapping(method= RequestMethod.POST , value="/pfteams/{pfteam_id}/emequips/{emequip_id}/emplans/searchdefault")
	public ResponseEntity<Page<EMPlanDTO>> searchEMPlanDefaultByPFTeamEMEquip(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id, @RequestBody EMPlanSearchContext context) {
        context.setN_equipid_eq(emequip_id);
        Page<EMPlan> domains = emplanService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emplanMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
    @PreAuthorize("hasPermission('','Create',{'Sql',this.emplanMapping,#emplandto})")
    @ApiOperation(value = "CreateByEMACClassEMPlanTempl", tags = {"EMPlan" },  notes = "CreateByEMACClassEMPlanTempl")
	@RequestMapping(method = RequestMethod.POST, value = "/emacclasses/{emacclass_id}/emplantempls/{emplantempl_id}/emplans")
    @Transactional
    public ResponseEntity<EMPlanDTO> createByEMACClassEMPlanTempl(@PathVariable("emacclass_id") String emacclass_id, @PathVariable("emplantempl_id") String emplantempl_id, @RequestBody EMPlanDTO emplandto) {
        EMPlan domain = emplanMapping.toDomain(emplandto);
        domain.setPlantemplid(emplantempl_id);
		emplanService.create(domain);
        EMPlanDTO dto = emplanMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Create',{'Sql',this.emplanMapping,#emplandtos})")
    @ApiOperation(value = "createBatchByEMACClassEMPlanTempl", tags = {"EMPlan" },  notes = "createBatchByEMACClassEMPlanTempl")
	@RequestMapping(method = RequestMethod.POST, value = "/emacclasses/{emacclass_id}/emplantempls/{emplantempl_id}/emplans/batch")
    public ResponseEntity<Boolean> createBatchByEMACClassEMPlanTempl(@PathVariable("emacclass_id") String emacclass_id, @PathVariable("emplantempl_id") String emplantempl_id, @RequestBody List<EMPlanDTO> emplandtos) {
        List<EMPlan> domainlist=emplanMapping.toDomain(emplandtos);
        for(EMPlan domain:domainlist){
            domain.setPlantemplid(emplantempl_id);
        }
        emplanService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(#emplan_id,'Update',{'Sql',this.emplanMapping,#emplandto})")
    @ApiOperation(value = "UpdateByEMACClassEMPlanTempl", tags = {"EMPlan" },  notes = "UpdateByEMACClassEMPlanTempl")
	@RequestMapping(method = RequestMethod.PUT, value = "/emacclasses/{emacclass_id}/emplantempls/{emplantempl_id}/emplans/{emplan_id}")
    @Transactional
    public ResponseEntity<EMPlanDTO> updateByEMACClassEMPlanTempl(@PathVariable("emacclass_id") String emacclass_id, @PathVariable("emplantempl_id") String emplantempl_id, @PathVariable("emplan_id") String emplan_id, @RequestBody EMPlanDTO emplandto) {
        EMPlan domain = emplanMapping.toDomain(emplandto);
        domain.setPlantemplid(emplantempl_id);
        domain.setEmplanid(emplan_id);
		emplanService.update(domain);
        EMPlanDTO dto = emplanMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Update',{'Sql',this.emplanMapping,#emplandtos})")
    @ApiOperation(value = "UpdateBatchByEMACClassEMPlanTempl", tags = {"EMPlan" },  notes = "UpdateBatchByEMACClassEMPlanTempl")
	@RequestMapping(method = RequestMethod.PUT, value = "/emacclasses/{emacclass_id}/emplantempls/{emplantempl_id}/emplans/batch")
    public ResponseEntity<Boolean> updateBatchByEMACClassEMPlanTempl(@PathVariable("emacclass_id") String emacclass_id, @PathVariable("emplantempl_id") String emplantempl_id, @RequestBody List<EMPlanDTO> emplandtos) {
        List<EMPlan> domainlist=emplanMapping.toDomain(emplandtos);
        for(EMPlan domain:domainlist){
            domain.setPlantemplid(emplantempl_id);
        }
        emplanService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(#emplan_id,'Get',{'Sql',this.emplanMapping,this.permissionDTO})")
    @ApiOperation(value = "GetByEMACClassEMPlanTempl", tags = {"EMPlan" },  notes = "GetByEMACClassEMPlanTempl")
	@RequestMapping(method = RequestMethod.GET, value = "/emacclasses/{emacclass_id}/emplantempls/{emplantempl_id}/emplans/{emplan_id}")
    public ResponseEntity<EMPlanDTO> getByEMACClassEMPlanTempl(@PathVariable("emacclass_id") String emacclass_id, @PathVariable("emplantempl_id") String emplantempl_id, @PathVariable("emplan_id") String emplan_id) {
        EMPlan domain = emplanService.get(emplan_id);
        EMPlanDTO dto = emplanMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(#emplan_id,'Remove',{'Sql',this.emplanMapping,this.permissionDTO})")
    @ApiOperation(value = "RemoveByEMACClassEMPlanTempl", tags = {"EMPlan" },  notes = "RemoveByEMACClassEMPlanTempl")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emacclasses/{emacclass_id}/emplantempls/{emplantempl_id}/emplans/{emplan_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByEMACClassEMPlanTempl(@PathVariable("emacclass_id") String emacclass_id, @PathVariable("emplantempl_id") String emplantempl_id, @PathVariable("emplan_id") String emplan_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emplanService.remove(emplan_id));
    }

    @PreAuthorize("hasPermission('Remove',{'Sql',this.emplanMapping,this.permissionDTO,#ids})")
    @ApiOperation(value = "RemoveBatchByEMACClassEMPlanTempl", tags = {"EMPlan" },  notes = "RemoveBatchByEMACClassEMPlanTempl")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emacclasses/{emacclass_id}/emplantempls/{emplantempl_id}/emplans/batch")
    public ResponseEntity<Boolean> removeBatchByEMACClassEMPlanTempl(@RequestBody List<String> ids) {
        emplanService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMPlan-GetDraft-all')")
    @ApiOperation(value = "GetDraftByEMACClassEMPlanTempl", tags = {"EMPlan" },  notes = "GetDraftByEMACClassEMPlanTempl")
    @RequestMapping(method = RequestMethod.GET, value = "/emacclasses/{emacclass_id}/emplantempls/{emplantempl_id}/emplans/getdraft")
    public ResponseEntity<EMPlanDTO> getDraftByEMACClassEMPlanTempl(@PathVariable("emacclass_id") String emacclass_id, @PathVariable("emplantempl_id") String emplantempl_id) {
        EMPlan domain = new EMPlan();
        domain.setPlantemplid(emplantempl_id);
        return ResponseEntity.status(HttpStatus.OK).body(emplanMapping.toDto(emplanService.getDraft(domain)));
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMPlan-CheckKey-all')")
    @ApiOperation(value = "CheckKeyByEMACClassEMPlanTempl", tags = {"EMPlan" },  notes = "CheckKeyByEMACClassEMPlanTempl")
	@RequestMapping(method = RequestMethod.POST, value = "/emacclasses/{emacclass_id}/emplantempls/{emplantempl_id}/emplans/checkkey")
    public ResponseEntity<Boolean> checkKeyByEMACClassEMPlanTempl(@PathVariable("emacclass_id") String emacclass_id, @PathVariable("emplantempl_id") String emplantempl_id, @RequestBody EMPlanDTO emplandto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emplanService.checkKey(emplanMapping.toDomain(emplandto)));
    }

    @PreAuthorize("hasPermission('','Save',{'Sql',this.emplanMapping,#emplandto})")
    @ApiOperation(value = "SaveByEMACClassEMPlanTempl", tags = {"EMPlan" },  notes = "SaveByEMACClassEMPlanTempl")
	@RequestMapping(method = RequestMethod.POST, value = "/emacclasses/{emacclass_id}/emplantempls/{emplantempl_id}/emplans/save")
    public ResponseEntity<Boolean> saveByEMACClassEMPlanTempl(@PathVariable("emacclass_id") String emacclass_id, @PathVariable("emplantempl_id") String emplantempl_id, @RequestBody EMPlanDTO emplandto) {
        EMPlan domain = emplanMapping.toDomain(emplandto);
        domain.setPlantemplid(emplantempl_id);
        return ResponseEntity.status(HttpStatus.OK).body(emplanService.save(domain));
    }

    @PreAuthorize("hasPermission('Save',{'Sql',this.emplanMapping,#emplandtos})")
    @ApiOperation(value = "SaveBatchByEMACClassEMPlanTempl", tags = {"EMPlan" },  notes = "SaveBatchByEMACClassEMPlanTempl")
	@RequestMapping(method = RequestMethod.POST, value = "/emacclasses/{emacclass_id}/emplantempls/{emplantempl_id}/emplans/savebatch")
    public ResponseEntity<Boolean> saveBatchByEMACClassEMPlanTempl(@PathVariable("emacclass_id") String emacclass_id, @PathVariable("emplantempl_id") String emplantempl_id, @RequestBody List<EMPlanDTO> emplandtos) {
        List<EMPlan> domainlist=emplanMapping.toDomain(emplandtos);
        for(EMPlan domain:domainlist){
             domain.setPlantemplid(emplantempl_id);
        }
        emplanService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMPlan-Default-all')")
	@ApiOperation(value = "fetchDEFAULTByEMACClassEMPlanTempl", tags = {"EMPlan" } ,notes = "fetchDEFAULTByEMACClassEMPlanTempl")
    @RequestMapping(method= RequestMethod.GET , value="/emacclasses/{emacclass_id}/emplantempls/{emplantempl_id}/emplans/fetchdefault")
	public ResponseEntity<List<EMPlanDTO>> fetchEMPlanDefaultByEMACClassEMPlanTempl(@PathVariable("emacclass_id") String emacclass_id, @PathVariable("emplantempl_id") String emplantempl_id,EMPlanSearchContext context) {
        context.setN_plantemplid_eq(emplantempl_id);
        Page<EMPlan> domains = emplanService.searchDefault(context) ;
        List<EMPlanDTO> list = emplanMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMPlan-Default-all')")
	@ApiOperation(value = "searchDEFAULTByEMACClassEMPlanTempl", tags = {"EMPlan" } ,notes = "searchDEFAULTByEMACClassEMPlanTempl")
    @RequestMapping(method= RequestMethod.POST , value="/emacclasses/{emacclass_id}/emplantempls/{emplantempl_id}/emplans/searchdefault")
	public ResponseEntity<Page<EMPlanDTO>> searchEMPlanDefaultByEMACClassEMPlanTempl(@PathVariable("emacclass_id") String emacclass_id, @PathVariable("emplantempl_id") String emplantempl_id, @RequestBody EMPlanSearchContext context) {
        context.setN_plantemplid_eq(emplantempl_id);
        Page<EMPlan> domains = emplanService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emplanMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
    @PreAuthorize("hasPermission('','Create',{'Sql',this.emplanMapping,#emplandto})")
    @ApiOperation(value = "CreateByEMServiceEMPlanTempl", tags = {"EMPlan" },  notes = "CreateByEMServiceEMPlanTempl")
	@RequestMapping(method = RequestMethod.POST, value = "/emservices/{emservice_id}/emplantempls/{emplantempl_id}/emplans")
    @Transactional
    public ResponseEntity<EMPlanDTO> createByEMServiceEMPlanTempl(@PathVariable("emservice_id") String emservice_id, @PathVariable("emplantempl_id") String emplantempl_id, @RequestBody EMPlanDTO emplandto) {
        EMPlan domain = emplanMapping.toDomain(emplandto);
        domain.setPlantemplid(emplantempl_id);
		emplanService.create(domain);
        EMPlanDTO dto = emplanMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Create',{'Sql',this.emplanMapping,#emplandtos})")
    @ApiOperation(value = "createBatchByEMServiceEMPlanTempl", tags = {"EMPlan" },  notes = "createBatchByEMServiceEMPlanTempl")
	@RequestMapping(method = RequestMethod.POST, value = "/emservices/{emservice_id}/emplantempls/{emplantempl_id}/emplans/batch")
    public ResponseEntity<Boolean> createBatchByEMServiceEMPlanTempl(@PathVariable("emservice_id") String emservice_id, @PathVariable("emplantempl_id") String emplantempl_id, @RequestBody List<EMPlanDTO> emplandtos) {
        List<EMPlan> domainlist=emplanMapping.toDomain(emplandtos);
        for(EMPlan domain:domainlist){
            domain.setPlantemplid(emplantempl_id);
        }
        emplanService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(#emplan_id,'Update',{'Sql',this.emplanMapping,#emplandto})")
    @ApiOperation(value = "UpdateByEMServiceEMPlanTempl", tags = {"EMPlan" },  notes = "UpdateByEMServiceEMPlanTempl")
	@RequestMapping(method = RequestMethod.PUT, value = "/emservices/{emservice_id}/emplantempls/{emplantempl_id}/emplans/{emplan_id}")
    @Transactional
    public ResponseEntity<EMPlanDTO> updateByEMServiceEMPlanTempl(@PathVariable("emservice_id") String emservice_id, @PathVariable("emplantempl_id") String emplantempl_id, @PathVariable("emplan_id") String emplan_id, @RequestBody EMPlanDTO emplandto) {
        EMPlan domain = emplanMapping.toDomain(emplandto);
        domain.setPlantemplid(emplantempl_id);
        domain.setEmplanid(emplan_id);
		emplanService.update(domain);
        EMPlanDTO dto = emplanMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Update',{'Sql',this.emplanMapping,#emplandtos})")
    @ApiOperation(value = "UpdateBatchByEMServiceEMPlanTempl", tags = {"EMPlan" },  notes = "UpdateBatchByEMServiceEMPlanTempl")
	@RequestMapping(method = RequestMethod.PUT, value = "/emservices/{emservice_id}/emplantempls/{emplantempl_id}/emplans/batch")
    public ResponseEntity<Boolean> updateBatchByEMServiceEMPlanTempl(@PathVariable("emservice_id") String emservice_id, @PathVariable("emplantempl_id") String emplantempl_id, @RequestBody List<EMPlanDTO> emplandtos) {
        List<EMPlan> domainlist=emplanMapping.toDomain(emplandtos);
        for(EMPlan domain:domainlist){
            domain.setPlantemplid(emplantempl_id);
        }
        emplanService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(#emplan_id,'Get',{'Sql',this.emplanMapping,this.permissionDTO})")
    @ApiOperation(value = "GetByEMServiceEMPlanTempl", tags = {"EMPlan" },  notes = "GetByEMServiceEMPlanTempl")
	@RequestMapping(method = RequestMethod.GET, value = "/emservices/{emservice_id}/emplantempls/{emplantempl_id}/emplans/{emplan_id}")
    public ResponseEntity<EMPlanDTO> getByEMServiceEMPlanTempl(@PathVariable("emservice_id") String emservice_id, @PathVariable("emplantempl_id") String emplantempl_id, @PathVariable("emplan_id") String emplan_id) {
        EMPlan domain = emplanService.get(emplan_id);
        EMPlanDTO dto = emplanMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(#emplan_id,'Remove',{'Sql',this.emplanMapping,this.permissionDTO})")
    @ApiOperation(value = "RemoveByEMServiceEMPlanTempl", tags = {"EMPlan" },  notes = "RemoveByEMServiceEMPlanTempl")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emservices/{emservice_id}/emplantempls/{emplantempl_id}/emplans/{emplan_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByEMServiceEMPlanTempl(@PathVariable("emservice_id") String emservice_id, @PathVariable("emplantempl_id") String emplantempl_id, @PathVariable("emplan_id") String emplan_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emplanService.remove(emplan_id));
    }

    @PreAuthorize("hasPermission('Remove',{'Sql',this.emplanMapping,this.permissionDTO,#ids})")
    @ApiOperation(value = "RemoveBatchByEMServiceEMPlanTempl", tags = {"EMPlan" },  notes = "RemoveBatchByEMServiceEMPlanTempl")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emservices/{emservice_id}/emplantempls/{emplantempl_id}/emplans/batch")
    public ResponseEntity<Boolean> removeBatchByEMServiceEMPlanTempl(@RequestBody List<String> ids) {
        emplanService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMPlan-GetDraft-all')")
    @ApiOperation(value = "GetDraftByEMServiceEMPlanTempl", tags = {"EMPlan" },  notes = "GetDraftByEMServiceEMPlanTempl")
    @RequestMapping(method = RequestMethod.GET, value = "/emservices/{emservice_id}/emplantempls/{emplantempl_id}/emplans/getdraft")
    public ResponseEntity<EMPlanDTO> getDraftByEMServiceEMPlanTempl(@PathVariable("emservice_id") String emservice_id, @PathVariable("emplantempl_id") String emplantempl_id) {
        EMPlan domain = new EMPlan();
        domain.setPlantemplid(emplantempl_id);
        return ResponseEntity.status(HttpStatus.OK).body(emplanMapping.toDto(emplanService.getDraft(domain)));
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMPlan-CheckKey-all')")
    @ApiOperation(value = "CheckKeyByEMServiceEMPlanTempl", tags = {"EMPlan" },  notes = "CheckKeyByEMServiceEMPlanTempl")
	@RequestMapping(method = RequestMethod.POST, value = "/emservices/{emservice_id}/emplantempls/{emplantempl_id}/emplans/checkkey")
    public ResponseEntity<Boolean> checkKeyByEMServiceEMPlanTempl(@PathVariable("emservice_id") String emservice_id, @PathVariable("emplantempl_id") String emplantempl_id, @RequestBody EMPlanDTO emplandto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emplanService.checkKey(emplanMapping.toDomain(emplandto)));
    }

    @PreAuthorize("hasPermission('','Save',{'Sql',this.emplanMapping,#emplandto})")
    @ApiOperation(value = "SaveByEMServiceEMPlanTempl", tags = {"EMPlan" },  notes = "SaveByEMServiceEMPlanTempl")
	@RequestMapping(method = RequestMethod.POST, value = "/emservices/{emservice_id}/emplantempls/{emplantempl_id}/emplans/save")
    public ResponseEntity<Boolean> saveByEMServiceEMPlanTempl(@PathVariable("emservice_id") String emservice_id, @PathVariable("emplantempl_id") String emplantempl_id, @RequestBody EMPlanDTO emplandto) {
        EMPlan domain = emplanMapping.toDomain(emplandto);
        domain.setPlantemplid(emplantempl_id);
        return ResponseEntity.status(HttpStatus.OK).body(emplanService.save(domain));
    }

    @PreAuthorize("hasPermission('Save',{'Sql',this.emplanMapping,#emplandtos})")
    @ApiOperation(value = "SaveBatchByEMServiceEMPlanTempl", tags = {"EMPlan" },  notes = "SaveBatchByEMServiceEMPlanTempl")
	@RequestMapping(method = RequestMethod.POST, value = "/emservices/{emservice_id}/emplantempls/{emplantempl_id}/emplans/savebatch")
    public ResponseEntity<Boolean> saveBatchByEMServiceEMPlanTempl(@PathVariable("emservice_id") String emservice_id, @PathVariable("emplantempl_id") String emplantempl_id, @RequestBody List<EMPlanDTO> emplandtos) {
        List<EMPlan> domainlist=emplanMapping.toDomain(emplandtos);
        for(EMPlan domain:domainlist){
             domain.setPlantemplid(emplantempl_id);
        }
        emplanService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMPlan-Default-all')")
	@ApiOperation(value = "fetchDEFAULTByEMServiceEMPlanTempl", tags = {"EMPlan" } ,notes = "fetchDEFAULTByEMServiceEMPlanTempl")
    @RequestMapping(method= RequestMethod.GET , value="/emservices/{emservice_id}/emplantempls/{emplantempl_id}/emplans/fetchdefault")
	public ResponseEntity<List<EMPlanDTO>> fetchEMPlanDefaultByEMServiceEMPlanTempl(@PathVariable("emservice_id") String emservice_id, @PathVariable("emplantempl_id") String emplantempl_id,EMPlanSearchContext context) {
        context.setN_plantemplid_eq(emplantempl_id);
        Page<EMPlan> domains = emplanService.searchDefault(context) ;
        List<EMPlanDTO> list = emplanMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMPlan-Default-all')")
	@ApiOperation(value = "searchDEFAULTByEMServiceEMPlanTempl", tags = {"EMPlan" } ,notes = "searchDEFAULTByEMServiceEMPlanTempl")
    @RequestMapping(method= RequestMethod.POST , value="/emservices/{emservice_id}/emplantempls/{emplantempl_id}/emplans/searchdefault")
	public ResponseEntity<Page<EMPlanDTO>> searchEMPlanDefaultByEMServiceEMPlanTempl(@PathVariable("emservice_id") String emservice_id, @PathVariable("emplantempl_id") String emplantempl_id, @RequestBody EMPlanSearchContext context) {
        context.setN_plantemplid_eq(emplantempl_id);
        Page<EMPlan> domains = emplanService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emplanMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
    @PreAuthorize("hasPermission('','Create',{'Sql',this.emplanMapping,#emplandto})")
    @ApiOperation(value = "CreateByPFDeptEMPlanTempl", tags = {"EMPlan" },  notes = "CreateByPFDeptEMPlanTempl")
	@RequestMapping(method = RequestMethod.POST, value = "/pfdepts/{pfdept_id}/emplantempls/{emplantempl_id}/emplans")
    @Transactional
    public ResponseEntity<EMPlanDTO> createByPFDeptEMPlanTempl(@PathVariable("pfdept_id") String pfdept_id, @PathVariable("emplantempl_id") String emplantempl_id, @RequestBody EMPlanDTO emplandto) {
        EMPlan domain = emplanMapping.toDomain(emplandto);
        domain.setPlantemplid(emplantempl_id);
		emplanService.create(domain);
        EMPlanDTO dto = emplanMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Create',{'Sql',this.emplanMapping,#emplandtos})")
    @ApiOperation(value = "createBatchByPFDeptEMPlanTempl", tags = {"EMPlan" },  notes = "createBatchByPFDeptEMPlanTempl")
	@RequestMapping(method = RequestMethod.POST, value = "/pfdepts/{pfdept_id}/emplantempls/{emplantempl_id}/emplans/batch")
    public ResponseEntity<Boolean> createBatchByPFDeptEMPlanTempl(@PathVariable("pfdept_id") String pfdept_id, @PathVariable("emplantempl_id") String emplantempl_id, @RequestBody List<EMPlanDTO> emplandtos) {
        List<EMPlan> domainlist=emplanMapping.toDomain(emplandtos);
        for(EMPlan domain:domainlist){
            domain.setPlantemplid(emplantempl_id);
        }
        emplanService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(#emplan_id,'Update',{'Sql',this.emplanMapping,#emplandto})")
    @ApiOperation(value = "UpdateByPFDeptEMPlanTempl", tags = {"EMPlan" },  notes = "UpdateByPFDeptEMPlanTempl")
	@RequestMapping(method = RequestMethod.PUT, value = "/pfdepts/{pfdept_id}/emplantempls/{emplantempl_id}/emplans/{emplan_id}")
    @Transactional
    public ResponseEntity<EMPlanDTO> updateByPFDeptEMPlanTempl(@PathVariable("pfdept_id") String pfdept_id, @PathVariable("emplantempl_id") String emplantempl_id, @PathVariable("emplan_id") String emplan_id, @RequestBody EMPlanDTO emplandto) {
        EMPlan domain = emplanMapping.toDomain(emplandto);
        domain.setPlantemplid(emplantempl_id);
        domain.setEmplanid(emplan_id);
		emplanService.update(domain);
        EMPlanDTO dto = emplanMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Update',{'Sql',this.emplanMapping,#emplandtos})")
    @ApiOperation(value = "UpdateBatchByPFDeptEMPlanTempl", tags = {"EMPlan" },  notes = "UpdateBatchByPFDeptEMPlanTempl")
	@RequestMapping(method = RequestMethod.PUT, value = "/pfdepts/{pfdept_id}/emplantempls/{emplantempl_id}/emplans/batch")
    public ResponseEntity<Boolean> updateBatchByPFDeptEMPlanTempl(@PathVariable("pfdept_id") String pfdept_id, @PathVariable("emplantempl_id") String emplantempl_id, @RequestBody List<EMPlanDTO> emplandtos) {
        List<EMPlan> domainlist=emplanMapping.toDomain(emplandtos);
        for(EMPlan domain:domainlist){
            domain.setPlantemplid(emplantempl_id);
        }
        emplanService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(#emplan_id,'Get',{'Sql',this.emplanMapping,this.permissionDTO})")
    @ApiOperation(value = "GetByPFDeptEMPlanTempl", tags = {"EMPlan" },  notes = "GetByPFDeptEMPlanTempl")
	@RequestMapping(method = RequestMethod.GET, value = "/pfdepts/{pfdept_id}/emplantempls/{emplantempl_id}/emplans/{emplan_id}")
    public ResponseEntity<EMPlanDTO> getByPFDeptEMPlanTempl(@PathVariable("pfdept_id") String pfdept_id, @PathVariable("emplantempl_id") String emplantempl_id, @PathVariable("emplan_id") String emplan_id) {
        EMPlan domain = emplanService.get(emplan_id);
        EMPlanDTO dto = emplanMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(#emplan_id,'Remove',{'Sql',this.emplanMapping,this.permissionDTO})")
    @ApiOperation(value = "RemoveByPFDeptEMPlanTempl", tags = {"EMPlan" },  notes = "RemoveByPFDeptEMPlanTempl")
	@RequestMapping(method = RequestMethod.DELETE, value = "/pfdepts/{pfdept_id}/emplantempls/{emplantempl_id}/emplans/{emplan_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByPFDeptEMPlanTempl(@PathVariable("pfdept_id") String pfdept_id, @PathVariable("emplantempl_id") String emplantempl_id, @PathVariable("emplan_id") String emplan_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emplanService.remove(emplan_id));
    }

    @PreAuthorize("hasPermission('Remove',{'Sql',this.emplanMapping,this.permissionDTO,#ids})")
    @ApiOperation(value = "RemoveBatchByPFDeptEMPlanTempl", tags = {"EMPlan" },  notes = "RemoveBatchByPFDeptEMPlanTempl")
	@RequestMapping(method = RequestMethod.DELETE, value = "/pfdepts/{pfdept_id}/emplantempls/{emplantempl_id}/emplans/batch")
    public ResponseEntity<Boolean> removeBatchByPFDeptEMPlanTempl(@RequestBody List<String> ids) {
        emplanService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMPlan-GetDraft-all')")
    @ApiOperation(value = "GetDraftByPFDeptEMPlanTempl", tags = {"EMPlan" },  notes = "GetDraftByPFDeptEMPlanTempl")
    @RequestMapping(method = RequestMethod.GET, value = "/pfdepts/{pfdept_id}/emplantempls/{emplantempl_id}/emplans/getdraft")
    public ResponseEntity<EMPlanDTO> getDraftByPFDeptEMPlanTempl(@PathVariable("pfdept_id") String pfdept_id, @PathVariable("emplantempl_id") String emplantempl_id) {
        EMPlan domain = new EMPlan();
        domain.setPlantemplid(emplantempl_id);
        return ResponseEntity.status(HttpStatus.OK).body(emplanMapping.toDto(emplanService.getDraft(domain)));
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMPlan-CheckKey-all')")
    @ApiOperation(value = "CheckKeyByPFDeptEMPlanTempl", tags = {"EMPlan" },  notes = "CheckKeyByPFDeptEMPlanTempl")
	@RequestMapping(method = RequestMethod.POST, value = "/pfdepts/{pfdept_id}/emplantempls/{emplantempl_id}/emplans/checkkey")
    public ResponseEntity<Boolean> checkKeyByPFDeptEMPlanTempl(@PathVariable("pfdept_id") String pfdept_id, @PathVariable("emplantempl_id") String emplantempl_id, @RequestBody EMPlanDTO emplandto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emplanService.checkKey(emplanMapping.toDomain(emplandto)));
    }

    @PreAuthorize("hasPermission('','Save',{'Sql',this.emplanMapping,#emplandto})")
    @ApiOperation(value = "SaveByPFDeptEMPlanTempl", tags = {"EMPlan" },  notes = "SaveByPFDeptEMPlanTempl")
	@RequestMapping(method = RequestMethod.POST, value = "/pfdepts/{pfdept_id}/emplantempls/{emplantempl_id}/emplans/save")
    public ResponseEntity<Boolean> saveByPFDeptEMPlanTempl(@PathVariable("pfdept_id") String pfdept_id, @PathVariable("emplantempl_id") String emplantempl_id, @RequestBody EMPlanDTO emplandto) {
        EMPlan domain = emplanMapping.toDomain(emplandto);
        domain.setPlantemplid(emplantempl_id);
        return ResponseEntity.status(HttpStatus.OK).body(emplanService.save(domain));
    }

    @PreAuthorize("hasPermission('Save',{'Sql',this.emplanMapping,#emplandtos})")
    @ApiOperation(value = "SaveBatchByPFDeptEMPlanTempl", tags = {"EMPlan" },  notes = "SaveBatchByPFDeptEMPlanTempl")
	@RequestMapping(method = RequestMethod.POST, value = "/pfdepts/{pfdept_id}/emplantempls/{emplantempl_id}/emplans/savebatch")
    public ResponseEntity<Boolean> saveBatchByPFDeptEMPlanTempl(@PathVariable("pfdept_id") String pfdept_id, @PathVariable("emplantempl_id") String emplantempl_id, @RequestBody List<EMPlanDTO> emplandtos) {
        List<EMPlan> domainlist=emplanMapping.toDomain(emplandtos);
        for(EMPlan domain:domainlist){
             domain.setPlantemplid(emplantempl_id);
        }
        emplanService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMPlan-Default-all')")
	@ApiOperation(value = "fetchDEFAULTByPFDeptEMPlanTempl", tags = {"EMPlan" } ,notes = "fetchDEFAULTByPFDeptEMPlanTempl")
    @RequestMapping(method= RequestMethod.GET , value="/pfdepts/{pfdept_id}/emplantempls/{emplantempl_id}/emplans/fetchdefault")
	public ResponseEntity<List<EMPlanDTO>> fetchEMPlanDefaultByPFDeptEMPlanTempl(@PathVariable("pfdept_id") String pfdept_id, @PathVariable("emplantempl_id") String emplantempl_id,EMPlanSearchContext context) {
        context.setN_plantemplid_eq(emplantempl_id);
        Page<EMPlan> domains = emplanService.searchDefault(context) ;
        List<EMPlanDTO> list = emplanMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMPlan-Default-all')")
	@ApiOperation(value = "searchDEFAULTByPFDeptEMPlanTempl", tags = {"EMPlan" } ,notes = "searchDEFAULTByPFDeptEMPlanTempl")
    @RequestMapping(method= RequestMethod.POST , value="/pfdepts/{pfdept_id}/emplantempls/{emplantempl_id}/emplans/searchdefault")
	public ResponseEntity<Page<EMPlanDTO>> searchEMPlanDefaultByPFDeptEMPlanTempl(@PathVariable("pfdept_id") String pfdept_id, @PathVariable("emplantempl_id") String emplantempl_id, @RequestBody EMPlanSearchContext context) {
        context.setN_plantemplid_eq(emplantempl_id);
        Page<EMPlan> domains = emplanService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emplanMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
    @PreAuthorize("hasPermission('','Create',{'Sql',this.emplanMapping,#emplandto})")
    @ApiOperation(value = "CreateByPFEmpEMPlanTempl", tags = {"EMPlan" },  notes = "CreateByPFEmpEMPlanTempl")
	@RequestMapping(method = RequestMethod.POST, value = "/pfemps/{pfemp_id}/emplantempls/{emplantempl_id}/emplans")
    @Transactional
    public ResponseEntity<EMPlanDTO> createByPFEmpEMPlanTempl(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emplantempl_id") String emplantempl_id, @RequestBody EMPlanDTO emplandto) {
        EMPlan domain = emplanMapping.toDomain(emplandto);
        domain.setPlantemplid(emplantempl_id);
		emplanService.create(domain);
        EMPlanDTO dto = emplanMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Create',{'Sql',this.emplanMapping,#emplandtos})")
    @ApiOperation(value = "createBatchByPFEmpEMPlanTempl", tags = {"EMPlan" },  notes = "createBatchByPFEmpEMPlanTempl")
	@RequestMapping(method = RequestMethod.POST, value = "/pfemps/{pfemp_id}/emplantempls/{emplantempl_id}/emplans/batch")
    public ResponseEntity<Boolean> createBatchByPFEmpEMPlanTempl(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emplantempl_id") String emplantempl_id, @RequestBody List<EMPlanDTO> emplandtos) {
        List<EMPlan> domainlist=emplanMapping.toDomain(emplandtos);
        for(EMPlan domain:domainlist){
            domain.setPlantemplid(emplantempl_id);
        }
        emplanService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(#emplan_id,'Update',{'Sql',this.emplanMapping,#emplandto})")
    @ApiOperation(value = "UpdateByPFEmpEMPlanTempl", tags = {"EMPlan" },  notes = "UpdateByPFEmpEMPlanTempl")
	@RequestMapping(method = RequestMethod.PUT, value = "/pfemps/{pfemp_id}/emplantempls/{emplantempl_id}/emplans/{emplan_id}")
    @Transactional
    public ResponseEntity<EMPlanDTO> updateByPFEmpEMPlanTempl(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emplantempl_id") String emplantempl_id, @PathVariable("emplan_id") String emplan_id, @RequestBody EMPlanDTO emplandto) {
        EMPlan domain = emplanMapping.toDomain(emplandto);
        domain.setPlantemplid(emplantempl_id);
        domain.setEmplanid(emplan_id);
		emplanService.update(domain);
        EMPlanDTO dto = emplanMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Update',{'Sql',this.emplanMapping,#emplandtos})")
    @ApiOperation(value = "UpdateBatchByPFEmpEMPlanTempl", tags = {"EMPlan" },  notes = "UpdateBatchByPFEmpEMPlanTempl")
	@RequestMapping(method = RequestMethod.PUT, value = "/pfemps/{pfemp_id}/emplantempls/{emplantempl_id}/emplans/batch")
    public ResponseEntity<Boolean> updateBatchByPFEmpEMPlanTempl(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emplantempl_id") String emplantempl_id, @RequestBody List<EMPlanDTO> emplandtos) {
        List<EMPlan> domainlist=emplanMapping.toDomain(emplandtos);
        for(EMPlan domain:domainlist){
            domain.setPlantemplid(emplantempl_id);
        }
        emplanService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(#emplan_id,'Get',{'Sql',this.emplanMapping,this.permissionDTO})")
    @ApiOperation(value = "GetByPFEmpEMPlanTempl", tags = {"EMPlan" },  notes = "GetByPFEmpEMPlanTempl")
	@RequestMapping(method = RequestMethod.GET, value = "/pfemps/{pfemp_id}/emplantempls/{emplantempl_id}/emplans/{emplan_id}")
    public ResponseEntity<EMPlanDTO> getByPFEmpEMPlanTempl(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emplantempl_id") String emplantempl_id, @PathVariable("emplan_id") String emplan_id) {
        EMPlan domain = emplanService.get(emplan_id);
        EMPlanDTO dto = emplanMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(#emplan_id,'Remove',{'Sql',this.emplanMapping,this.permissionDTO})")
    @ApiOperation(value = "RemoveByPFEmpEMPlanTempl", tags = {"EMPlan" },  notes = "RemoveByPFEmpEMPlanTempl")
	@RequestMapping(method = RequestMethod.DELETE, value = "/pfemps/{pfemp_id}/emplantempls/{emplantempl_id}/emplans/{emplan_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByPFEmpEMPlanTempl(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emplantempl_id") String emplantempl_id, @PathVariable("emplan_id") String emplan_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emplanService.remove(emplan_id));
    }

    @PreAuthorize("hasPermission('Remove',{'Sql',this.emplanMapping,this.permissionDTO,#ids})")
    @ApiOperation(value = "RemoveBatchByPFEmpEMPlanTempl", tags = {"EMPlan" },  notes = "RemoveBatchByPFEmpEMPlanTempl")
	@RequestMapping(method = RequestMethod.DELETE, value = "/pfemps/{pfemp_id}/emplantempls/{emplantempl_id}/emplans/batch")
    public ResponseEntity<Boolean> removeBatchByPFEmpEMPlanTempl(@RequestBody List<String> ids) {
        emplanService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMPlan-GetDraft-all')")
    @ApiOperation(value = "GetDraftByPFEmpEMPlanTempl", tags = {"EMPlan" },  notes = "GetDraftByPFEmpEMPlanTempl")
    @RequestMapping(method = RequestMethod.GET, value = "/pfemps/{pfemp_id}/emplantempls/{emplantempl_id}/emplans/getdraft")
    public ResponseEntity<EMPlanDTO> getDraftByPFEmpEMPlanTempl(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emplantempl_id") String emplantempl_id) {
        EMPlan domain = new EMPlan();
        domain.setPlantemplid(emplantempl_id);
        return ResponseEntity.status(HttpStatus.OK).body(emplanMapping.toDto(emplanService.getDraft(domain)));
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMPlan-CheckKey-all')")
    @ApiOperation(value = "CheckKeyByPFEmpEMPlanTempl", tags = {"EMPlan" },  notes = "CheckKeyByPFEmpEMPlanTempl")
	@RequestMapping(method = RequestMethod.POST, value = "/pfemps/{pfemp_id}/emplantempls/{emplantempl_id}/emplans/checkkey")
    public ResponseEntity<Boolean> checkKeyByPFEmpEMPlanTempl(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emplantempl_id") String emplantempl_id, @RequestBody EMPlanDTO emplandto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emplanService.checkKey(emplanMapping.toDomain(emplandto)));
    }

    @PreAuthorize("hasPermission('','Save',{'Sql',this.emplanMapping,#emplandto})")
    @ApiOperation(value = "SaveByPFEmpEMPlanTempl", tags = {"EMPlan" },  notes = "SaveByPFEmpEMPlanTempl")
	@RequestMapping(method = RequestMethod.POST, value = "/pfemps/{pfemp_id}/emplantempls/{emplantempl_id}/emplans/save")
    public ResponseEntity<Boolean> saveByPFEmpEMPlanTempl(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emplantempl_id") String emplantempl_id, @RequestBody EMPlanDTO emplandto) {
        EMPlan domain = emplanMapping.toDomain(emplandto);
        domain.setPlantemplid(emplantempl_id);
        return ResponseEntity.status(HttpStatus.OK).body(emplanService.save(domain));
    }

    @PreAuthorize("hasPermission('Save',{'Sql',this.emplanMapping,#emplandtos})")
    @ApiOperation(value = "SaveBatchByPFEmpEMPlanTempl", tags = {"EMPlan" },  notes = "SaveBatchByPFEmpEMPlanTempl")
	@RequestMapping(method = RequestMethod.POST, value = "/pfemps/{pfemp_id}/emplantempls/{emplantempl_id}/emplans/savebatch")
    public ResponseEntity<Boolean> saveBatchByPFEmpEMPlanTempl(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emplantempl_id") String emplantempl_id, @RequestBody List<EMPlanDTO> emplandtos) {
        List<EMPlan> domainlist=emplanMapping.toDomain(emplandtos);
        for(EMPlan domain:domainlist){
             domain.setPlantemplid(emplantempl_id);
        }
        emplanService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMPlan-Default-all')")
	@ApiOperation(value = "fetchDEFAULTByPFEmpEMPlanTempl", tags = {"EMPlan" } ,notes = "fetchDEFAULTByPFEmpEMPlanTempl")
    @RequestMapping(method= RequestMethod.GET , value="/pfemps/{pfemp_id}/emplantempls/{emplantempl_id}/emplans/fetchdefault")
	public ResponseEntity<List<EMPlanDTO>> fetchEMPlanDefaultByPFEmpEMPlanTempl(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emplantempl_id") String emplantempl_id,EMPlanSearchContext context) {
        context.setN_plantemplid_eq(emplantempl_id);
        Page<EMPlan> domains = emplanService.searchDefault(context) ;
        List<EMPlanDTO> list = emplanMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMPlan-Default-all')")
	@ApiOperation(value = "searchDEFAULTByPFEmpEMPlanTempl", tags = {"EMPlan" } ,notes = "searchDEFAULTByPFEmpEMPlanTempl")
    @RequestMapping(method= RequestMethod.POST , value="/pfemps/{pfemp_id}/emplantempls/{emplantempl_id}/emplans/searchdefault")
	public ResponseEntity<Page<EMPlanDTO>> searchEMPlanDefaultByPFEmpEMPlanTempl(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emplantempl_id") String emplantempl_id, @RequestBody EMPlanSearchContext context) {
        context.setN_plantemplid_eq(emplantempl_id);
        Page<EMPlan> domains = emplanService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emplanMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
    @PreAuthorize("hasPermission('','Create',{'Sql',this.emplanMapping,#emplandto})")
    @ApiOperation(value = "CreateByPFTeamEMPlanTempl", tags = {"EMPlan" },  notes = "CreateByPFTeamEMPlanTempl")
	@RequestMapping(method = RequestMethod.POST, value = "/pfteams/{pfteam_id}/emplantempls/{emplantempl_id}/emplans")
    @Transactional
    public ResponseEntity<EMPlanDTO> createByPFTeamEMPlanTempl(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emplantempl_id") String emplantempl_id, @RequestBody EMPlanDTO emplandto) {
        EMPlan domain = emplanMapping.toDomain(emplandto);
        domain.setPlantemplid(emplantempl_id);
		emplanService.create(domain);
        EMPlanDTO dto = emplanMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Create',{'Sql',this.emplanMapping,#emplandtos})")
    @ApiOperation(value = "createBatchByPFTeamEMPlanTempl", tags = {"EMPlan" },  notes = "createBatchByPFTeamEMPlanTempl")
	@RequestMapping(method = RequestMethod.POST, value = "/pfteams/{pfteam_id}/emplantempls/{emplantempl_id}/emplans/batch")
    public ResponseEntity<Boolean> createBatchByPFTeamEMPlanTempl(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emplantempl_id") String emplantempl_id, @RequestBody List<EMPlanDTO> emplandtos) {
        List<EMPlan> domainlist=emplanMapping.toDomain(emplandtos);
        for(EMPlan domain:domainlist){
            domain.setPlantemplid(emplantempl_id);
        }
        emplanService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(#emplan_id,'Update',{'Sql',this.emplanMapping,#emplandto})")
    @ApiOperation(value = "UpdateByPFTeamEMPlanTempl", tags = {"EMPlan" },  notes = "UpdateByPFTeamEMPlanTempl")
	@RequestMapping(method = RequestMethod.PUT, value = "/pfteams/{pfteam_id}/emplantempls/{emplantempl_id}/emplans/{emplan_id}")
    @Transactional
    public ResponseEntity<EMPlanDTO> updateByPFTeamEMPlanTempl(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emplantempl_id") String emplantempl_id, @PathVariable("emplan_id") String emplan_id, @RequestBody EMPlanDTO emplandto) {
        EMPlan domain = emplanMapping.toDomain(emplandto);
        domain.setPlantemplid(emplantempl_id);
        domain.setEmplanid(emplan_id);
		emplanService.update(domain);
        EMPlanDTO dto = emplanMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Update',{'Sql',this.emplanMapping,#emplandtos})")
    @ApiOperation(value = "UpdateBatchByPFTeamEMPlanTempl", tags = {"EMPlan" },  notes = "UpdateBatchByPFTeamEMPlanTempl")
	@RequestMapping(method = RequestMethod.PUT, value = "/pfteams/{pfteam_id}/emplantempls/{emplantempl_id}/emplans/batch")
    public ResponseEntity<Boolean> updateBatchByPFTeamEMPlanTempl(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emplantempl_id") String emplantempl_id, @RequestBody List<EMPlanDTO> emplandtos) {
        List<EMPlan> domainlist=emplanMapping.toDomain(emplandtos);
        for(EMPlan domain:domainlist){
            domain.setPlantemplid(emplantempl_id);
        }
        emplanService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(#emplan_id,'Get',{'Sql',this.emplanMapping,this.permissionDTO})")
    @ApiOperation(value = "GetByPFTeamEMPlanTempl", tags = {"EMPlan" },  notes = "GetByPFTeamEMPlanTempl")
	@RequestMapping(method = RequestMethod.GET, value = "/pfteams/{pfteam_id}/emplantempls/{emplantempl_id}/emplans/{emplan_id}")
    public ResponseEntity<EMPlanDTO> getByPFTeamEMPlanTempl(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emplantempl_id") String emplantempl_id, @PathVariable("emplan_id") String emplan_id) {
        EMPlan domain = emplanService.get(emplan_id);
        EMPlanDTO dto = emplanMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(#emplan_id,'Remove',{'Sql',this.emplanMapping,this.permissionDTO})")
    @ApiOperation(value = "RemoveByPFTeamEMPlanTempl", tags = {"EMPlan" },  notes = "RemoveByPFTeamEMPlanTempl")
	@RequestMapping(method = RequestMethod.DELETE, value = "/pfteams/{pfteam_id}/emplantempls/{emplantempl_id}/emplans/{emplan_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByPFTeamEMPlanTempl(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emplantempl_id") String emplantempl_id, @PathVariable("emplan_id") String emplan_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emplanService.remove(emplan_id));
    }

    @PreAuthorize("hasPermission('Remove',{'Sql',this.emplanMapping,this.permissionDTO,#ids})")
    @ApiOperation(value = "RemoveBatchByPFTeamEMPlanTempl", tags = {"EMPlan" },  notes = "RemoveBatchByPFTeamEMPlanTempl")
	@RequestMapping(method = RequestMethod.DELETE, value = "/pfteams/{pfteam_id}/emplantempls/{emplantempl_id}/emplans/batch")
    public ResponseEntity<Boolean> removeBatchByPFTeamEMPlanTempl(@RequestBody List<String> ids) {
        emplanService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMPlan-GetDraft-all')")
    @ApiOperation(value = "GetDraftByPFTeamEMPlanTempl", tags = {"EMPlan" },  notes = "GetDraftByPFTeamEMPlanTempl")
    @RequestMapping(method = RequestMethod.GET, value = "/pfteams/{pfteam_id}/emplantempls/{emplantempl_id}/emplans/getdraft")
    public ResponseEntity<EMPlanDTO> getDraftByPFTeamEMPlanTempl(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emplantempl_id") String emplantempl_id) {
        EMPlan domain = new EMPlan();
        domain.setPlantemplid(emplantempl_id);
        return ResponseEntity.status(HttpStatus.OK).body(emplanMapping.toDto(emplanService.getDraft(domain)));
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMPlan-CheckKey-all')")
    @ApiOperation(value = "CheckKeyByPFTeamEMPlanTempl", tags = {"EMPlan" },  notes = "CheckKeyByPFTeamEMPlanTempl")
	@RequestMapping(method = RequestMethod.POST, value = "/pfteams/{pfteam_id}/emplantempls/{emplantempl_id}/emplans/checkkey")
    public ResponseEntity<Boolean> checkKeyByPFTeamEMPlanTempl(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emplantempl_id") String emplantempl_id, @RequestBody EMPlanDTO emplandto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emplanService.checkKey(emplanMapping.toDomain(emplandto)));
    }

    @PreAuthorize("hasPermission('','Save',{'Sql',this.emplanMapping,#emplandto})")
    @ApiOperation(value = "SaveByPFTeamEMPlanTempl", tags = {"EMPlan" },  notes = "SaveByPFTeamEMPlanTempl")
	@RequestMapping(method = RequestMethod.POST, value = "/pfteams/{pfteam_id}/emplantempls/{emplantempl_id}/emplans/save")
    public ResponseEntity<Boolean> saveByPFTeamEMPlanTempl(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emplantempl_id") String emplantempl_id, @RequestBody EMPlanDTO emplandto) {
        EMPlan domain = emplanMapping.toDomain(emplandto);
        domain.setPlantemplid(emplantempl_id);
        return ResponseEntity.status(HttpStatus.OK).body(emplanService.save(domain));
    }

    @PreAuthorize("hasPermission('Save',{'Sql',this.emplanMapping,#emplandtos})")
    @ApiOperation(value = "SaveBatchByPFTeamEMPlanTempl", tags = {"EMPlan" },  notes = "SaveBatchByPFTeamEMPlanTempl")
	@RequestMapping(method = RequestMethod.POST, value = "/pfteams/{pfteam_id}/emplantempls/{emplantempl_id}/emplans/savebatch")
    public ResponseEntity<Boolean> saveBatchByPFTeamEMPlanTempl(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emplantempl_id") String emplantempl_id, @RequestBody List<EMPlanDTO> emplandtos) {
        List<EMPlan> domainlist=emplanMapping.toDomain(emplandtos);
        for(EMPlan domain:domainlist){
             domain.setPlantemplid(emplantempl_id);
        }
        emplanService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMPlan-Default-all')")
	@ApiOperation(value = "fetchDEFAULTByPFTeamEMPlanTempl", tags = {"EMPlan" } ,notes = "fetchDEFAULTByPFTeamEMPlanTempl")
    @RequestMapping(method= RequestMethod.GET , value="/pfteams/{pfteam_id}/emplantempls/{emplantempl_id}/emplans/fetchdefault")
	public ResponseEntity<List<EMPlanDTO>> fetchEMPlanDefaultByPFTeamEMPlanTempl(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emplantempl_id") String emplantempl_id,EMPlanSearchContext context) {
        context.setN_plantemplid_eq(emplantempl_id);
        Page<EMPlan> domains = emplanService.searchDefault(context) ;
        List<EMPlanDTO> list = emplanMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMPlan-Default-all')")
	@ApiOperation(value = "searchDEFAULTByPFTeamEMPlanTempl", tags = {"EMPlan" } ,notes = "searchDEFAULTByPFTeamEMPlanTempl")
    @RequestMapping(method= RequestMethod.POST , value="/pfteams/{pfteam_id}/emplantempls/{emplantempl_id}/emplans/searchdefault")
	public ResponseEntity<Page<EMPlanDTO>> searchEMPlanDefaultByPFTeamEMPlanTempl(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emplantempl_id") String emplantempl_id, @RequestBody EMPlanSearchContext context) {
        context.setN_plantemplid_eq(emplantempl_id);
        Page<EMPlan> domains = emplanService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emplanMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
}
