package cn.ibizlab.eam.webapi.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;
import javax.servlet.ServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import cn.ibizlab.eam.webapi.dto.*;
import cn.ibizlab.eam.webapi.mapping.*;
import cn.ibizlab.eam.core.eam_core.domain.EMPlanDetail;
import cn.ibizlab.eam.core.eam_core.service.IEMPlanDetailService;
import cn.ibizlab.eam.core.eam_core.filter.EMPlanDetailSearchContext;

@Slf4j
@Api(tags = {"EMPlanDetail" })
@RestController("WebApi-emplandetail")
@RequestMapping("")
public class EMPlanDetailResource {

    @Autowired
    private IEMPlanDetailService emplandetailService;

    @Autowired
    @Lazy
    public EMPlanDetailMapping emplandetailMapping;

    public EMPlanDetailDTO permissionDTO=new EMPlanDetailDTO();

    @PreAuthorize("hasPermission(#emplandetail_id,'Get',{'Sql',this.emplandetailMapping,this.permissionDTO})")
    @ApiOperation(value = "Get", tags = {"EMPlanDetail" },  notes = "Get")
	@RequestMapping(method = RequestMethod.GET, value = "/emplandetails/{emplandetail_id}")
    public ResponseEntity<EMPlanDetailDTO> get(@PathVariable("emplandetail_id") String emplandetail_id) {
        EMPlanDetail domain = emplandetailService.get(emplandetail_id);
        EMPlanDetailDTO dto = emplandetailMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMPlanDetail-GetDraft-all')")
    @ApiOperation(value = "GetDraft", tags = {"EMPlanDetail" },  notes = "GetDraft")
	@RequestMapping(method = RequestMethod.GET, value = "/emplandetails/getdraft")
    public ResponseEntity<EMPlanDetailDTO> getDraft() {
        return ResponseEntity.status(HttpStatus.OK).body(emplandetailMapping.toDto(emplandetailService.getDraft(new EMPlanDetail())));
    }

    @PreAuthorize("hasPermission('','Save',{'Sql',this.emplandetailMapping,#emplandetaildto})")
    @ApiOperation(value = "Save", tags = {"EMPlanDetail" },  notes = "Save")
	@RequestMapping(method = RequestMethod.POST, value = "/emplandetails/save")
    public ResponseEntity<Boolean> save(@RequestBody EMPlanDetailDTO emplandetaildto) {
        return ResponseEntity.status(HttpStatus.OK).body(emplandetailService.save(emplandetailMapping.toDomain(emplandetaildto)));
    }

    @PreAuthorize("hasPermission('Save',{'Sql',this.emplandetailMapping,#emplandetaildtos})")
    @ApiOperation(value = "SaveBatch", tags = {"EMPlanDetail" },  notes = "SaveBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emplandetails/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<EMPlanDetailDTO> emplandetaildtos) {
        emplandetailService.saveBatch(emplandetailMapping.toDomain(emplandetaildtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(#emplandetail_id,'Update',{'Sql',this.emplandetailMapping,#emplandetaildto})")
    @ApiOperation(value = "Update", tags = {"EMPlanDetail" },  notes = "Update")
	@RequestMapping(method = RequestMethod.PUT, value = "/emplandetails/{emplandetail_id}")
    @Transactional
    public ResponseEntity<EMPlanDetailDTO> update(@PathVariable("emplandetail_id") String emplandetail_id, @RequestBody EMPlanDetailDTO emplandetaildto) {
		EMPlanDetail domain  = emplandetailMapping.toDomain(emplandetaildto);
        domain .setEmplandetailid(emplandetail_id);
		emplandetailService.update(domain );
		EMPlanDetailDTO dto = emplandetailMapping.toDto(domain );
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Update',{'Sql',this.emplandetailMapping,#emplandetaildtos})")
    @ApiOperation(value = "UpdateBatch", tags = {"EMPlanDetail" },  notes = "UpdateBatch")
	@RequestMapping(method = RequestMethod.PUT, value = "/emplandetails/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<EMPlanDetailDTO> emplandetaildtos) {
        emplandetailService.updateBatch(emplandetailMapping.toDomain(emplandetaildtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission('','Create',{'Sql',this.emplandetailMapping,#emplandetaildto})")
    @ApiOperation(value = "Create", tags = {"EMPlanDetail" },  notes = "Create")
	@RequestMapping(method = RequestMethod.POST, value = "/emplandetails")
    @Transactional
    public ResponseEntity<EMPlanDetailDTO> create(@RequestBody EMPlanDetailDTO emplandetaildto) {
        EMPlanDetail domain = emplandetailMapping.toDomain(emplandetaildto);
		emplandetailService.create(domain);
        EMPlanDetailDTO dto = emplandetailMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Create',{'Sql',this.emplandetailMapping,#emplandetaildtos})")
    @ApiOperation(value = "createBatch", tags = {"EMPlanDetail" },  notes = "createBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emplandetails/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<EMPlanDetailDTO> emplandetaildtos) {
        emplandetailService.createBatch(emplandetailMapping.toDomain(emplandetaildtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMPlanDetail-CheckKey-all')")
    @ApiOperation(value = "CheckKey", tags = {"EMPlanDetail" },  notes = "CheckKey")
	@RequestMapping(method = RequestMethod.POST, value = "/emplandetails/checkkey")
    public ResponseEntity<Boolean> checkKey(@RequestBody EMPlanDetailDTO emplandetaildto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emplandetailService.checkKey(emplandetailMapping.toDomain(emplandetaildto)));
    }

    @PreAuthorize("hasPermission(#emplandetail_id,'Remove',{'Sql',this.emplandetailMapping,this.permissionDTO})")
    @ApiOperation(value = "Remove", tags = {"EMPlanDetail" },  notes = "Remove")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emplandetails/{emplandetail_id}")
    @Transactional
    public ResponseEntity<Boolean> remove(@PathVariable("emplandetail_id") String emplandetail_id) {
         return ResponseEntity.status(HttpStatus.OK).body(emplandetailService.remove(emplandetail_id));
    }

    @PreAuthorize("hasPermission('Remove',{'Sql',this.emplandetailMapping,this.permissionDTO,#ids})")
    @ApiOperation(value = "RemoveBatch", tags = {"EMPlanDetail" },  notes = "RemoveBatch")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emplandetails/batch")
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        emplandetailService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMPlanDetail-Default-all')")
	@ApiOperation(value = "fetchDEFAULT", tags = {"EMPlanDetail" } ,notes = "fetchDEFAULT")
    @RequestMapping(method= RequestMethod.GET , value="/emplandetails/fetchdefault")
	public ResponseEntity<List<EMPlanDetailDTO>> fetchDefault(EMPlanDetailSearchContext context) {
        Page<EMPlanDetail> domains = emplandetailService.searchDefault(context) ;
        List<EMPlanDetailDTO> list = emplandetailMapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMPlanDetail-Default-all')")
	@ApiOperation(value = "searchDEFAULT", tags = {"EMPlanDetail" } ,notes = "searchDEFAULT")
    @RequestMapping(method= RequestMethod.POST , value="/emplandetails/searchdefault")
	public ResponseEntity<Page<EMPlanDetailDTO>> searchDefault(@RequestBody EMPlanDetailSearchContext context) {
        Page<EMPlanDetail> domains = emplandetailService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emplandetailMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
    @PreAuthorize("hasPermission(#emplandetail_id,'Get',{'Sql',this.emplandetailMapping,this.permissionDTO})")
    @ApiOperation(value = "GetByEMPlan", tags = {"EMPlanDetail" },  notes = "GetByEMPlan")
	@RequestMapping(method = RequestMethod.GET, value = "/emplans/{emplan_id}/emplandetails/{emplandetail_id}")
    public ResponseEntity<EMPlanDetailDTO> getByEMPlan(@PathVariable("emplan_id") String emplan_id, @PathVariable("emplandetail_id") String emplandetail_id) {
        EMPlanDetail domain = emplandetailService.get(emplandetail_id);
        EMPlanDetailDTO dto = emplandetailMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMPlanDetail-GetDraft-all')")
    @ApiOperation(value = "GetDraftByEMPlan", tags = {"EMPlanDetail" },  notes = "GetDraftByEMPlan")
    @RequestMapping(method = RequestMethod.GET, value = "/emplans/{emplan_id}/emplandetails/getdraft")
    public ResponseEntity<EMPlanDetailDTO> getDraftByEMPlan(@PathVariable("emplan_id") String emplan_id) {
        EMPlanDetail domain = new EMPlanDetail();
        domain.setPlanid(emplan_id);
        return ResponseEntity.status(HttpStatus.OK).body(emplandetailMapping.toDto(emplandetailService.getDraft(domain)));
    }

    @PreAuthorize("hasPermission('','Save',{'Sql',this.emplandetailMapping,#emplandetaildto})")
    @ApiOperation(value = "SaveByEMPlan", tags = {"EMPlanDetail" },  notes = "SaveByEMPlan")
	@RequestMapping(method = RequestMethod.POST, value = "/emplans/{emplan_id}/emplandetails/save")
    public ResponseEntity<Boolean> saveByEMPlan(@PathVariable("emplan_id") String emplan_id, @RequestBody EMPlanDetailDTO emplandetaildto) {
        EMPlanDetail domain = emplandetailMapping.toDomain(emplandetaildto);
        domain.setPlanid(emplan_id);
        return ResponseEntity.status(HttpStatus.OK).body(emplandetailService.save(domain));
    }

    @PreAuthorize("hasPermission('Save',{'Sql',this.emplandetailMapping,#emplandetaildtos})")
    @ApiOperation(value = "SaveBatchByEMPlan", tags = {"EMPlanDetail" },  notes = "SaveBatchByEMPlan")
	@RequestMapping(method = RequestMethod.POST, value = "/emplans/{emplan_id}/emplandetails/savebatch")
    public ResponseEntity<Boolean> saveBatchByEMPlan(@PathVariable("emplan_id") String emplan_id, @RequestBody List<EMPlanDetailDTO> emplandetaildtos) {
        List<EMPlanDetail> domainlist=emplandetailMapping.toDomain(emplandetaildtos);
        for(EMPlanDetail domain:domainlist){
             domain.setPlanid(emplan_id);
        }
        emplandetailService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(#emplandetail_id,'Update',{'Sql',this.emplandetailMapping,#emplandetaildto})")
    @ApiOperation(value = "UpdateByEMPlan", tags = {"EMPlanDetail" },  notes = "UpdateByEMPlan")
	@RequestMapping(method = RequestMethod.PUT, value = "/emplans/{emplan_id}/emplandetails/{emplandetail_id}")
    @Transactional
    public ResponseEntity<EMPlanDetailDTO> updateByEMPlan(@PathVariable("emplan_id") String emplan_id, @PathVariable("emplandetail_id") String emplandetail_id, @RequestBody EMPlanDetailDTO emplandetaildto) {
        EMPlanDetail domain = emplandetailMapping.toDomain(emplandetaildto);
        domain.setPlanid(emplan_id);
        domain.setEmplandetailid(emplandetail_id);
		emplandetailService.update(domain);
        EMPlanDetailDTO dto = emplandetailMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Update',{'Sql',this.emplandetailMapping,#emplandetaildtos})")
    @ApiOperation(value = "UpdateBatchByEMPlan", tags = {"EMPlanDetail" },  notes = "UpdateBatchByEMPlan")
	@RequestMapping(method = RequestMethod.PUT, value = "/emplans/{emplan_id}/emplandetails/batch")
    public ResponseEntity<Boolean> updateBatchByEMPlan(@PathVariable("emplan_id") String emplan_id, @RequestBody List<EMPlanDetailDTO> emplandetaildtos) {
        List<EMPlanDetail> domainlist=emplandetailMapping.toDomain(emplandetaildtos);
        for(EMPlanDetail domain:domainlist){
            domain.setPlanid(emplan_id);
        }
        emplandetailService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission('','Create',{'Sql',this.emplandetailMapping,#emplandetaildto})")
    @ApiOperation(value = "CreateByEMPlan", tags = {"EMPlanDetail" },  notes = "CreateByEMPlan")
	@RequestMapping(method = RequestMethod.POST, value = "/emplans/{emplan_id}/emplandetails")
    @Transactional
    public ResponseEntity<EMPlanDetailDTO> createByEMPlan(@PathVariable("emplan_id") String emplan_id, @RequestBody EMPlanDetailDTO emplandetaildto) {
        EMPlanDetail domain = emplandetailMapping.toDomain(emplandetaildto);
        domain.setPlanid(emplan_id);
		emplandetailService.create(domain);
        EMPlanDetailDTO dto = emplandetailMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Create',{'Sql',this.emplandetailMapping,#emplandetaildtos})")
    @ApiOperation(value = "createBatchByEMPlan", tags = {"EMPlanDetail" },  notes = "createBatchByEMPlan")
	@RequestMapping(method = RequestMethod.POST, value = "/emplans/{emplan_id}/emplandetails/batch")
    public ResponseEntity<Boolean> createBatchByEMPlan(@PathVariable("emplan_id") String emplan_id, @RequestBody List<EMPlanDetailDTO> emplandetaildtos) {
        List<EMPlanDetail> domainlist=emplandetailMapping.toDomain(emplandetaildtos);
        for(EMPlanDetail domain:domainlist){
            domain.setPlanid(emplan_id);
        }
        emplandetailService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMPlanDetail-CheckKey-all')")
    @ApiOperation(value = "CheckKeyByEMPlan", tags = {"EMPlanDetail" },  notes = "CheckKeyByEMPlan")
	@RequestMapping(method = RequestMethod.POST, value = "/emplans/{emplan_id}/emplandetails/checkkey")
    public ResponseEntity<Boolean> checkKeyByEMPlan(@PathVariable("emplan_id") String emplan_id, @RequestBody EMPlanDetailDTO emplandetaildto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emplandetailService.checkKey(emplandetailMapping.toDomain(emplandetaildto)));
    }

    @PreAuthorize("hasPermission(#emplandetail_id,'Remove',{'Sql',this.emplandetailMapping,this.permissionDTO})")
    @ApiOperation(value = "RemoveByEMPlan", tags = {"EMPlanDetail" },  notes = "RemoveByEMPlan")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emplans/{emplan_id}/emplandetails/{emplandetail_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByEMPlan(@PathVariable("emplan_id") String emplan_id, @PathVariable("emplandetail_id") String emplandetail_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emplandetailService.remove(emplandetail_id));
    }

    @PreAuthorize("hasPermission('Remove',{'Sql',this.emplandetailMapping,this.permissionDTO,#ids})")
    @ApiOperation(value = "RemoveBatchByEMPlan", tags = {"EMPlanDetail" },  notes = "RemoveBatchByEMPlan")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emplans/{emplan_id}/emplandetails/batch")
    public ResponseEntity<Boolean> removeBatchByEMPlan(@RequestBody List<String> ids) {
        emplandetailService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMPlanDetail-Default-all')")
	@ApiOperation(value = "fetchDEFAULTByEMPlan", tags = {"EMPlanDetail" } ,notes = "fetchDEFAULTByEMPlan")
    @RequestMapping(method= RequestMethod.GET , value="/emplans/{emplan_id}/emplandetails/fetchdefault")
	public ResponseEntity<List<EMPlanDetailDTO>> fetchEMPlanDetailDefaultByEMPlan(@PathVariable("emplan_id") String emplan_id,EMPlanDetailSearchContext context) {
        context.setN_planid_eq(emplan_id);
        Page<EMPlanDetail> domains = emplandetailService.searchDefault(context) ;
        List<EMPlanDetailDTO> list = emplandetailMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMPlanDetail-Default-all')")
	@ApiOperation(value = "searchDEFAULTByEMPlan", tags = {"EMPlanDetail" } ,notes = "searchDEFAULTByEMPlan")
    @RequestMapping(method= RequestMethod.POST , value="/emplans/{emplan_id}/emplandetails/searchdefault")
	public ResponseEntity<Page<EMPlanDetailDTO>> searchEMPlanDetailDefaultByEMPlan(@PathVariable("emplan_id") String emplan_id, @RequestBody EMPlanDetailSearchContext context) {
        context.setN_planid_eq(emplan_id);
        Page<EMPlanDetail> domains = emplandetailService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emplandetailMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
    @PreAuthorize("hasPermission(#emplandetail_id,'Get',{'Sql',this.emplandetailMapping,this.permissionDTO})")
    @ApiOperation(value = "GetByEMACClassEMPlan", tags = {"EMPlanDetail" },  notes = "GetByEMACClassEMPlan")
	@RequestMapping(method = RequestMethod.GET, value = "/emacclasses/{emacclass_id}/emplans/{emplan_id}/emplandetails/{emplandetail_id}")
    public ResponseEntity<EMPlanDetailDTO> getByEMACClassEMPlan(@PathVariable("emacclass_id") String emacclass_id, @PathVariable("emplan_id") String emplan_id, @PathVariable("emplandetail_id") String emplandetail_id) {
        EMPlanDetail domain = emplandetailService.get(emplandetail_id);
        EMPlanDetailDTO dto = emplandetailMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMPlanDetail-GetDraft-all')")
    @ApiOperation(value = "GetDraftByEMACClassEMPlan", tags = {"EMPlanDetail" },  notes = "GetDraftByEMACClassEMPlan")
    @RequestMapping(method = RequestMethod.GET, value = "/emacclasses/{emacclass_id}/emplans/{emplan_id}/emplandetails/getdraft")
    public ResponseEntity<EMPlanDetailDTO> getDraftByEMACClassEMPlan(@PathVariable("emacclass_id") String emacclass_id, @PathVariable("emplan_id") String emplan_id) {
        EMPlanDetail domain = new EMPlanDetail();
        domain.setPlanid(emplan_id);
        return ResponseEntity.status(HttpStatus.OK).body(emplandetailMapping.toDto(emplandetailService.getDraft(domain)));
    }

    @PreAuthorize("hasPermission('','Save',{'Sql',this.emplandetailMapping,#emplandetaildto})")
    @ApiOperation(value = "SaveByEMACClassEMPlan", tags = {"EMPlanDetail" },  notes = "SaveByEMACClassEMPlan")
	@RequestMapping(method = RequestMethod.POST, value = "/emacclasses/{emacclass_id}/emplans/{emplan_id}/emplandetails/save")
    public ResponseEntity<Boolean> saveByEMACClassEMPlan(@PathVariable("emacclass_id") String emacclass_id, @PathVariable("emplan_id") String emplan_id, @RequestBody EMPlanDetailDTO emplandetaildto) {
        EMPlanDetail domain = emplandetailMapping.toDomain(emplandetaildto);
        domain.setPlanid(emplan_id);
        return ResponseEntity.status(HttpStatus.OK).body(emplandetailService.save(domain));
    }

    @PreAuthorize("hasPermission('Save',{'Sql',this.emplandetailMapping,#emplandetaildtos})")
    @ApiOperation(value = "SaveBatchByEMACClassEMPlan", tags = {"EMPlanDetail" },  notes = "SaveBatchByEMACClassEMPlan")
	@RequestMapping(method = RequestMethod.POST, value = "/emacclasses/{emacclass_id}/emplans/{emplan_id}/emplandetails/savebatch")
    public ResponseEntity<Boolean> saveBatchByEMACClassEMPlan(@PathVariable("emacclass_id") String emacclass_id, @PathVariable("emplan_id") String emplan_id, @RequestBody List<EMPlanDetailDTO> emplandetaildtos) {
        List<EMPlanDetail> domainlist=emplandetailMapping.toDomain(emplandetaildtos);
        for(EMPlanDetail domain:domainlist){
             domain.setPlanid(emplan_id);
        }
        emplandetailService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(#emplandetail_id,'Update',{'Sql',this.emplandetailMapping,#emplandetaildto})")
    @ApiOperation(value = "UpdateByEMACClassEMPlan", tags = {"EMPlanDetail" },  notes = "UpdateByEMACClassEMPlan")
	@RequestMapping(method = RequestMethod.PUT, value = "/emacclasses/{emacclass_id}/emplans/{emplan_id}/emplandetails/{emplandetail_id}")
    @Transactional
    public ResponseEntity<EMPlanDetailDTO> updateByEMACClassEMPlan(@PathVariable("emacclass_id") String emacclass_id, @PathVariable("emplan_id") String emplan_id, @PathVariable("emplandetail_id") String emplandetail_id, @RequestBody EMPlanDetailDTO emplandetaildto) {
        EMPlanDetail domain = emplandetailMapping.toDomain(emplandetaildto);
        domain.setPlanid(emplan_id);
        domain.setEmplandetailid(emplandetail_id);
		emplandetailService.update(domain);
        EMPlanDetailDTO dto = emplandetailMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Update',{'Sql',this.emplandetailMapping,#emplandetaildtos})")
    @ApiOperation(value = "UpdateBatchByEMACClassEMPlan", tags = {"EMPlanDetail" },  notes = "UpdateBatchByEMACClassEMPlan")
	@RequestMapping(method = RequestMethod.PUT, value = "/emacclasses/{emacclass_id}/emplans/{emplan_id}/emplandetails/batch")
    public ResponseEntity<Boolean> updateBatchByEMACClassEMPlan(@PathVariable("emacclass_id") String emacclass_id, @PathVariable("emplan_id") String emplan_id, @RequestBody List<EMPlanDetailDTO> emplandetaildtos) {
        List<EMPlanDetail> domainlist=emplandetailMapping.toDomain(emplandetaildtos);
        for(EMPlanDetail domain:domainlist){
            domain.setPlanid(emplan_id);
        }
        emplandetailService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission('','Create',{'Sql',this.emplandetailMapping,#emplandetaildto})")
    @ApiOperation(value = "CreateByEMACClassEMPlan", tags = {"EMPlanDetail" },  notes = "CreateByEMACClassEMPlan")
	@RequestMapping(method = RequestMethod.POST, value = "/emacclasses/{emacclass_id}/emplans/{emplan_id}/emplandetails")
    @Transactional
    public ResponseEntity<EMPlanDetailDTO> createByEMACClassEMPlan(@PathVariable("emacclass_id") String emacclass_id, @PathVariable("emplan_id") String emplan_id, @RequestBody EMPlanDetailDTO emplandetaildto) {
        EMPlanDetail domain = emplandetailMapping.toDomain(emplandetaildto);
        domain.setPlanid(emplan_id);
		emplandetailService.create(domain);
        EMPlanDetailDTO dto = emplandetailMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Create',{'Sql',this.emplandetailMapping,#emplandetaildtos})")
    @ApiOperation(value = "createBatchByEMACClassEMPlan", tags = {"EMPlanDetail" },  notes = "createBatchByEMACClassEMPlan")
	@RequestMapping(method = RequestMethod.POST, value = "/emacclasses/{emacclass_id}/emplans/{emplan_id}/emplandetails/batch")
    public ResponseEntity<Boolean> createBatchByEMACClassEMPlan(@PathVariable("emacclass_id") String emacclass_id, @PathVariable("emplan_id") String emplan_id, @RequestBody List<EMPlanDetailDTO> emplandetaildtos) {
        List<EMPlanDetail> domainlist=emplandetailMapping.toDomain(emplandetaildtos);
        for(EMPlanDetail domain:domainlist){
            domain.setPlanid(emplan_id);
        }
        emplandetailService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMPlanDetail-CheckKey-all')")
    @ApiOperation(value = "CheckKeyByEMACClassEMPlan", tags = {"EMPlanDetail" },  notes = "CheckKeyByEMACClassEMPlan")
	@RequestMapping(method = RequestMethod.POST, value = "/emacclasses/{emacclass_id}/emplans/{emplan_id}/emplandetails/checkkey")
    public ResponseEntity<Boolean> checkKeyByEMACClassEMPlan(@PathVariable("emacclass_id") String emacclass_id, @PathVariable("emplan_id") String emplan_id, @RequestBody EMPlanDetailDTO emplandetaildto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emplandetailService.checkKey(emplandetailMapping.toDomain(emplandetaildto)));
    }

    @PreAuthorize("hasPermission(#emplandetail_id,'Remove',{'Sql',this.emplandetailMapping,this.permissionDTO})")
    @ApiOperation(value = "RemoveByEMACClassEMPlan", tags = {"EMPlanDetail" },  notes = "RemoveByEMACClassEMPlan")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emacclasses/{emacclass_id}/emplans/{emplan_id}/emplandetails/{emplandetail_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByEMACClassEMPlan(@PathVariable("emacclass_id") String emacclass_id, @PathVariable("emplan_id") String emplan_id, @PathVariable("emplandetail_id") String emplandetail_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emplandetailService.remove(emplandetail_id));
    }

    @PreAuthorize("hasPermission('Remove',{'Sql',this.emplandetailMapping,this.permissionDTO,#ids})")
    @ApiOperation(value = "RemoveBatchByEMACClassEMPlan", tags = {"EMPlanDetail" },  notes = "RemoveBatchByEMACClassEMPlan")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emacclasses/{emacclass_id}/emplans/{emplan_id}/emplandetails/batch")
    public ResponseEntity<Boolean> removeBatchByEMACClassEMPlan(@RequestBody List<String> ids) {
        emplandetailService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMPlanDetail-Default-all')")
	@ApiOperation(value = "fetchDEFAULTByEMACClassEMPlan", tags = {"EMPlanDetail" } ,notes = "fetchDEFAULTByEMACClassEMPlan")
    @RequestMapping(method= RequestMethod.GET , value="/emacclasses/{emacclass_id}/emplans/{emplan_id}/emplandetails/fetchdefault")
	public ResponseEntity<List<EMPlanDetailDTO>> fetchEMPlanDetailDefaultByEMACClassEMPlan(@PathVariable("emacclass_id") String emacclass_id, @PathVariable("emplan_id") String emplan_id,EMPlanDetailSearchContext context) {
        context.setN_planid_eq(emplan_id);
        Page<EMPlanDetail> domains = emplandetailService.searchDefault(context) ;
        List<EMPlanDetailDTO> list = emplandetailMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMPlanDetail-Default-all')")
	@ApiOperation(value = "searchDEFAULTByEMACClassEMPlan", tags = {"EMPlanDetail" } ,notes = "searchDEFAULTByEMACClassEMPlan")
    @RequestMapping(method= RequestMethod.POST , value="/emacclasses/{emacclass_id}/emplans/{emplan_id}/emplandetails/searchdefault")
	public ResponseEntity<Page<EMPlanDetailDTO>> searchEMPlanDetailDefaultByEMACClassEMPlan(@PathVariable("emacclass_id") String emacclass_id, @PathVariable("emplan_id") String emplan_id, @RequestBody EMPlanDetailSearchContext context) {
        context.setN_planid_eq(emplan_id);
        Page<EMPlanDetail> domains = emplandetailService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emplandetailMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
    @PreAuthorize("hasPermission(#emplandetail_id,'Get',{'Sql',this.emplandetailMapping,this.permissionDTO})")
    @ApiOperation(value = "GetByEMEquipEMPlan", tags = {"EMPlanDetail" },  notes = "GetByEMEquipEMPlan")
	@RequestMapping(method = RequestMethod.GET, value = "/emequips/{emequip_id}/emplans/{emplan_id}/emplandetails/{emplandetail_id}")
    public ResponseEntity<EMPlanDetailDTO> getByEMEquipEMPlan(@PathVariable("emequip_id") String emequip_id, @PathVariable("emplan_id") String emplan_id, @PathVariable("emplandetail_id") String emplandetail_id) {
        EMPlanDetail domain = emplandetailService.get(emplandetail_id);
        EMPlanDetailDTO dto = emplandetailMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMPlanDetail-GetDraft-all')")
    @ApiOperation(value = "GetDraftByEMEquipEMPlan", tags = {"EMPlanDetail" },  notes = "GetDraftByEMEquipEMPlan")
    @RequestMapping(method = RequestMethod.GET, value = "/emequips/{emequip_id}/emplans/{emplan_id}/emplandetails/getdraft")
    public ResponseEntity<EMPlanDetailDTO> getDraftByEMEquipEMPlan(@PathVariable("emequip_id") String emequip_id, @PathVariable("emplan_id") String emplan_id) {
        EMPlanDetail domain = new EMPlanDetail();
        domain.setPlanid(emplan_id);
        return ResponseEntity.status(HttpStatus.OK).body(emplandetailMapping.toDto(emplandetailService.getDraft(domain)));
    }

    @PreAuthorize("hasPermission('','Save',{'Sql',this.emplandetailMapping,#emplandetaildto})")
    @ApiOperation(value = "SaveByEMEquipEMPlan", tags = {"EMPlanDetail" },  notes = "SaveByEMEquipEMPlan")
	@RequestMapping(method = RequestMethod.POST, value = "/emequips/{emequip_id}/emplans/{emplan_id}/emplandetails/save")
    public ResponseEntity<Boolean> saveByEMEquipEMPlan(@PathVariable("emequip_id") String emequip_id, @PathVariable("emplan_id") String emplan_id, @RequestBody EMPlanDetailDTO emplandetaildto) {
        EMPlanDetail domain = emplandetailMapping.toDomain(emplandetaildto);
        domain.setPlanid(emplan_id);
        return ResponseEntity.status(HttpStatus.OK).body(emplandetailService.save(domain));
    }

    @PreAuthorize("hasPermission('Save',{'Sql',this.emplandetailMapping,#emplandetaildtos})")
    @ApiOperation(value = "SaveBatchByEMEquipEMPlan", tags = {"EMPlanDetail" },  notes = "SaveBatchByEMEquipEMPlan")
	@RequestMapping(method = RequestMethod.POST, value = "/emequips/{emequip_id}/emplans/{emplan_id}/emplandetails/savebatch")
    public ResponseEntity<Boolean> saveBatchByEMEquipEMPlan(@PathVariable("emequip_id") String emequip_id, @PathVariable("emplan_id") String emplan_id, @RequestBody List<EMPlanDetailDTO> emplandetaildtos) {
        List<EMPlanDetail> domainlist=emplandetailMapping.toDomain(emplandetaildtos);
        for(EMPlanDetail domain:domainlist){
             domain.setPlanid(emplan_id);
        }
        emplandetailService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(#emplandetail_id,'Update',{'Sql',this.emplandetailMapping,#emplandetaildto})")
    @ApiOperation(value = "UpdateByEMEquipEMPlan", tags = {"EMPlanDetail" },  notes = "UpdateByEMEquipEMPlan")
	@RequestMapping(method = RequestMethod.PUT, value = "/emequips/{emequip_id}/emplans/{emplan_id}/emplandetails/{emplandetail_id}")
    @Transactional
    public ResponseEntity<EMPlanDetailDTO> updateByEMEquipEMPlan(@PathVariable("emequip_id") String emequip_id, @PathVariable("emplan_id") String emplan_id, @PathVariable("emplandetail_id") String emplandetail_id, @RequestBody EMPlanDetailDTO emplandetaildto) {
        EMPlanDetail domain = emplandetailMapping.toDomain(emplandetaildto);
        domain.setPlanid(emplan_id);
        domain.setEmplandetailid(emplandetail_id);
		emplandetailService.update(domain);
        EMPlanDetailDTO dto = emplandetailMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Update',{'Sql',this.emplandetailMapping,#emplandetaildtos})")
    @ApiOperation(value = "UpdateBatchByEMEquipEMPlan", tags = {"EMPlanDetail" },  notes = "UpdateBatchByEMEquipEMPlan")
	@RequestMapping(method = RequestMethod.PUT, value = "/emequips/{emequip_id}/emplans/{emplan_id}/emplandetails/batch")
    public ResponseEntity<Boolean> updateBatchByEMEquipEMPlan(@PathVariable("emequip_id") String emequip_id, @PathVariable("emplan_id") String emplan_id, @RequestBody List<EMPlanDetailDTO> emplandetaildtos) {
        List<EMPlanDetail> domainlist=emplandetailMapping.toDomain(emplandetaildtos);
        for(EMPlanDetail domain:domainlist){
            domain.setPlanid(emplan_id);
        }
        emplandetailService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission('','Create',{'Sql',this.emplandetailMapping,#emplandetaildto})")
    @ApiOperation(value = "CreateByEMEquipEMPlan", tags = {"EMPlanDetail" },  notes = "CreateByEMEquipEMPlan")
	@RequestMapping(method = RequestMethod.POST, value = "/emequips/{emequip_id}/emplans/{emplan_id}/emplandetails")
    @Transactional
    public ResponseEntity<EMPlanDetailDTO> createByEMEquipEMPlan(@PathVariable("emequip_id") String emequip_id, @PathVariable("emplan_id") String emplan_id, @RequestBody EMPlanDetailDTO emplandetaildto) {
        EMPlanDetail domain = emplandetailMapping.toDomain(emplandetaildto);
        domain.setPlanid(emplan_id);
		emplandetailService.create(domain);
        EMPlanDetailDTO dto = emplandetailMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Create',{'Sql',this.emplandetailMapping,#emplandetaildtos})")
    @ApiOperation(value = "createBatchByEMEquipEMPlan", tags = {"EMPlanDetail" },  notes = "createBatchByEMEquipEMPlan")
	@RequestMapping(method = RequestMethod.POST, value = "/emequips/{emequip_id}/emplans/{emplan_id}/emplandetails/batch")
    public ResponseEntity<Boolean> createBatchByEMEquipEMPlan(@PathVariable("emequip_id") String emequip_id, @PathVariable("emplan_id") String emplan_id, @RequestBody List<EMPlanDetailDTO> emplandetaildtos) {
        List<EMPlanDetail> domainlist=emplandetailMapping.toDomain(emplandetaildtos);
        for(EMPlanDetail domain:domainlist){
            domain.setPlanid(emplan_id);
        }
        emplandetailService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMPlanDetail-CheckKey-all')")
    @ApiOperation(value = "CheckKeyByEMEquipEMPlan", tags = {"EMPlanDetail" },  notes = "CheckKeyByEMEquipEMPlan")
	@RequestMapping(method = RequestMethod.POST, value = "/emequips/{emequip_id}/emplans/{emplan_id}/emplandetails/checkkey")
    public ResponseEntity<Boolean> checkKeyByEMEquipEMPlan(@PathVariable("emequip_id") String emequip_id, @PathVariable("emplan_id") String emplan_id, @RequestBody EMPlanDetailDTO emplandetaildto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emplandetailService.checkKey(emplandetailMapping.toDomain(emplandetaildto)));
    }

    @PreAuthorize("hasPermission(#emplandetail_id,'Remove',{'Sql',this.emplandetailMapping,this.permissionDTO})")
    @ApiOperation(value = "RemoveByEMEquipEMPlan", tags = {"EMPlanDetail" },  notes = "RemoveByEMEquipEMPlan")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emequips/{emequip_id}/emplans/{emplan_id}/emplandetails/{emplandetail_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByEMEquipEMPlan(@PathVariable("emequip_id") String emequip_id, @PathVariable("emplan_id") String emplan_id, @PathVariable("emplandetail_id") String emplandetail_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emplandetailService.remove(emplandetail_id));
    }

    @PreAuthorize("hasPermission('Remove',{'Sql',this.emplandetailMapping,this.permissionDTO,#ids})")
    @ApiOperation(value = "RemoveBatchByEMEquipEMPlan", tags = {"EMPlanDetail" },  notes = "RemoveBatchByEMEquipEMPlan")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emequips/{emequip_id}/emplans/{emplan_id}/emplandetails/batch")
    public ResponseEntity<Boolean> removeBatchByEMEquipEMPlan(@RequestBody List<String> ids) {
        emplandetailService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMPlanDetail-Default-all')")
	@ApiOperation(value = "fetchDEFAULTByEMEquipEMPlan", tags = {"EMPlanDetail" } ,notes = "fetchDEFAULTByEMEquipEMPlan")
    @RequestMapping(method= RequestMethod.GET , value="/emequips/{emequip_id}/emplans/{emplan_id}/emplandetails/fetchdefault")
	public ResponseEntity<List<EMPlanDetailDTO>> fetchEMPlanDetailDefaultByEMEquipEMPlan(@PathVariable("emequip_id") String emequip_id, @PathVariable("emplan_id") String emplan_id,EMPlanDetailSearchContext context) {
        context.setN_planid_eq(emplan_id);
        Page<EMPlanDetail> domains = emplandetailService.searchDefault(context) ;
        List<EMPlanDetailDTO> list = emplandetailMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMPlanDetail-Default-all')")
	@ApiOperation(value = "searchDEFAULTByEMEquipEMPlan", tags = {"EMPlanDetail" } ,notes = "searchDEFAULTByEMEquipEMPlan")
    @RequestMapping(method= RequestMethod.POST , value="/emequips/{emequip_id}/emplans/{emplan_id}/emplandetails/searchdefault")
	public ResponseEntity<Page<EMPlanDetailDTO>> searchEMPlanDetailDefaultByEMEquipEMPlan(@PathVariable("emequip_id") String emequip_id, @PathVariable("emplan_id") String emplan_id, @RequestBody EMPlanDetailSearchContext context) {
        context.setN_planid_eq(emplan_id);
        Page<EMPlanDetail> domains = emplandetailService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emplandetailMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
    @PreAuthorize("hasPermission(#emplandetail_id,'Get',{'Sql',this.emplandetailMapping,this.permissionDTO})")
    @ApiOperation(value = "GetByEMPlanTemplEMPlan", tags = {"EMPlanDetail" },  notes = "GetByEMPlanTemplEMPlan")
	@RequestMapping(method = RequestMethod.GET, value = "/emplantempls/{emplantempl_id}/emplans/{emplan_id}/emplandetails/{emplandetail_id}")
    public ResponseEntity<EMPlanDetailDTO> getByEMPlanTemplEMPlan(@PathVariable("emplantempl_id") String emplantempl_id, @PathVariable("emplan_id") String emplan_id, @PathVariable("emplandetail_id") String emplandetail_id) {
        EMPlanDetail domain = emplandetailService.get(emplandetail_id);
        EMPlanDetailDTO dto = emplandetailMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMPlanDetail-GetDraft-all')")
    @ApiOperation(value = "GetDraftByEMPlanTemplEMPlan", tags = {"EMPlanDetail" },  notes = "GetDraftByEMPlanTemplEMPlan")
    @RequestMapping(method = RequestMethod.GET, value = "/emplantempls/{emplantempl_id}/emplans/{emplan_id}/emplandetails/getdraft")
    public ResponseEntity<EMPlanDetailDTO> getDraftByEMPlanTemplEMPlan(@PathVariable("emplantempl_id") String emplantempl_id, @PathVariable("emplan_id") String emplan_id) {
        EMPlanDetail domain = new EMPlanDetail();
        domain.setPlanid(emplan_id);
        return ResponseEntity.status(HttpStatus.OK).body(emplandetailMapping.toDto(emplandetailService.getDraft(domain)));
    }

    @PreAuthorize("hasPermission('','Save',{'Sql',this.emplandetailMapping,#emplandetaildto})")
    @ApiOperation(value = "SaveByEMPlanTemplEMPlan", tags = {"EMPlanDetail" },  notes = "SaveByEMPlanTemplEMPlan")
	@RequestMapping(method = RequestMethod.POST, value = "/emplantempls/{emplantempl_id}/emplans/{emplan_id}/emplandetails/save")
    public ResponseEntity<Boolean> saveByEMPlanTemplEMPlan(@PathVariable("emplantempl_id") String emplantempl_id, @PathVariable("emplan_id") String emplan_id, @RequestBody EMPlanDetailDTO emplandetaildto) {
        EMPlanDetail domain = emplandetailMapping.toDomain(emplandetaildto);
        domain.setPlanid(emplan_id);
        return ResponseEntity.status(HttpStatus.OK).body(emplandetailService.save(domain));
    }

    @PreAuthorize("hasPermission('Save',{'Sql',this.emplandetailMapping,#emplandetaildtos})")
    @ApiOperation(value = "SaveBatchByEMPlanTemplEMPlan", tags = {"EMPlanDetail" },  notes = "SaveBatchByEMPlanTemplEMPlan")
	@RequestMapping(method = RequestMethod.POST, value = "/emplantempls/{emplantempl_id}/emplans/{emplan_id}/emplandetails/savebatch")
    public ResponseEntity<Boolean> saveBatchByEMPlanTemplEMPlan(@PathVariable("emplantempl_id") String emplantempl_id, @PathVariable("emplan_id") String emplan_id, @RequestBody List<EMPlanDetailDTO> emplandetaildtos) {
        List<EMPlanDetail> domainlist=emplandetailMapping.toDomain(emplandetaildtos);
        for(EMPlanDetail domain:domainlist){
             domain.setPlanid(emplan_id);
        }
        emplandetailService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(#emplandetail_id,'Update',{'Sql',this.emplandetailMapping,#emplandetaildto})")
    @ApiOperation(value = "UpdateByEMPlanTemplEMPlan", tags = {"EMPlanDetail" },  notes = "UpdateByEMPlanTemplEMPlan")
	@RequestMapping(method = RequestMethod.PUT, value = "/emplantempls/{emplantempl_id}/emplans/{emplan_id}/emplandetails/{emplandetail_id}")
    @Transactional
    public ResponseEntity<EMPlanDetailDTO> updateByEMPlanTemplEMPlan(@PathVariable("emplantempl_id") String emplantempl_id, @PathVariable("emplan_id") String emplan_id, @PathVariable("emplandetail_id") String emplandetail_id, @RequestBody EMPlanDetailDTO emplandetaildto) {
        EMPlanDetail domain = emplandetailMapping.toDomain(emplandetaildto);
        domain.setPlanid(emplan_id);
        domain.setEmplandetailid(emplandetail_id);
		emplandetailService.update(domain);
        EMPlanDetailDTO dto = emplandetailMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Update',{'Sql',this.emplandetailMapping,#emplandetaildtos})")
    @ApiOperation(value = "UpdateBatchByEMPlanTemplEMPlan", tags = {"EMPlanDetail" },  notes = "UpdateBatchByEMPlanTemplEMPlan")
	@RequestMapping(method = RequestMethod.PUT, value = "/emplantempls/{emplantempl_id}/emplans/{emplan_id}/emplandetails/batch")
    public ResponseEntity<Boolean> updateBatchByEMPlanTemplEMPlan(@PathVariable("emplantempl_id") String emplantempl_id, @PathVariable("emplan_id") String emplan_id, @RequestBody List<EMPlanDetailDTO> emplandetaildtos) {
        List<EMPlanDetail> domainlist=emplandetailMapping.toDomain(emplandetaildtos);
        for(EMPlanDetail domain:domainlist){
            domain.setPlanid(emplan_id);
        }
        emplandetailService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission('','Create',{'Sql',this.emplandetailMapping,#emplandetaildto})")
    @ApiOperation(value = "CreateByEMPlanTemplEMPlan", tags = {"EMPlanDetail" },  notes = "CreateByEMPlanTemplEMPlan")
	@RequestMapping(method = RequestMethod.POST, value = "/emplantempls/{emplantempl_id}/emplans/{emplan_id}/emplandetails")
    @Transactional
    public ResponseEntity<EMPlanDetailDTO> createByEMPlanTemplEMPlan(@PathVariable("emplantempl_id") String emplantempl_id, @PathVariable("emplan_id") String emplan_id, @RequestBody EMPlanDetailDTO emplandetaildto) {
        EMPlanDetail domain = emplandetailMapping.toDomain(emplandetaildto);
        domain.setPlanid(emplan_id);
		emplandetailService.create(domain);
        EMPlanDetailDTO dto = emplandetailMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Create',{'Sql',this.emplandetailMapping,#emplandetaildtos})")
    @ApiOperation(value = "createBatchByEMPlanTemplEMPlan", tags = {"EMPlanDetail" },  notes = "createBatchByEMPlanTemplEMPlan")
	@RequestMapping(method = RequestMethod.POST, value = "/emplantempls/{emplantempl_id}/emplans/{emplan_id}/emplandetails/batch")
    public ResponseEntity<Boolean> createBatchByEMPlanTemplEMPlan(@PathVariable("emplantempl_id") String emplantempl_id, @PathVariable("emplan_id") String emplan_id, @RequestBody List<EMPlanDetailDTO> emplandetaildtos) {
        List<EMPlanDetail> domainlist=emplandetailMapping.toDomain(emplandetaildtos);
        for(EMPlanDetail domain:domainlist){
            domain.setPlanid(emplan_id);
        }
        emplandetailService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMPlanDetail-CheckKey-all')")
    @ApiOperation(value = "CheckKeyByEMPlanTemplEMPlan", tags = {"EMPlanDetail" },  notes = "CheckKeyByEMPlanTemplEMPlan")
	@RequestMapping(method = RequestMethod.POST, value = "/emplantempls/{emplantempl_id}/emplans/{emplan_id}/emplandetails/checkkey")
    public ResponseEntity<Boolean> checkKeyByEMPlanTemplEMPlan(@PathVariable("emplantempl_id") String emplantempl_id, @PathVariable("emplan_id") String emplan_id, @RequestBody EMPlanDetailDTO emplandetaildto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emplandetailService.checkKey(emplandetailMapping.toDomain(emplandetaildto)));
    }

    @PreAuthorize("hasPermission(#emplandetail_id,'Remove',{'Sql',this.emplandetailMapping,this.permissionDTO})")
    @ApiOperation(value = "RemoveByEMPlanTemplEMPlan", tags = {"EMPlanDetail" },  notes = "RemoveByEMPlanTemplEMPlan")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emplantempls/{emplantempl_id}/emplans/{emplan_id}/emplandetails/{emplandetail_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByEMPlanTemplEMPlan(@PathVariable("emplantempl_id") String emplantempl_id, @PathVariable("emplan_id") String emplan_id, @PathVariable("emplandetail_id") String emplandetail_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emplandetailService.remove(emplandetail_id));
    }

    @PreAuthorize("hasPermission('Remove',{'Sql',this.emplandetailMapping,this.permissionDTO,#ids})")
    @ApiOperation(value = "RemoveBatchByEMPlanTemplEMPlan", tags = {"EMPlanDetail" },  notes = "RemoveBatchByEMPlanTemplEMPlan")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emplantempls/{emplantempl_id}/emplans/{emplan_id}/emplandetails/batch")
    public ResponseEntity<Boolean> removeBatchByEMPlanTemplEMPlan(@RequestBody List<String> ids) {
        emplandetailService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMPlanDetail-Default-all')")
	@ApiOperation(value = "fetchDEFAULTByEMPlanTemplEMPlan", tags = {"EMPlanDetail" } ,notes = "fetchDEFAULTByEMPlanTemplEMPlan")
    @RequestMapping(method= RequestMethod.GET , value="/emplantempls/{emplantempl_id}/emplans/{emplan_id}/emplandetails/fetchdefault")
	public ResponseEntity<List<EMPlanDetailDTO>> fetchEMPlanDetailDefaultByEMPlanTemplEMPlan(@PathVariable("emplantempl_id") String emplantempl_id, @PathVariable("emplan_id") String emplan_id,EMPlanDetailSearchContext context) {
        context.setN_planid_eq(emplan_id);
        Page<EMPlanDetail> domains = emplandetailService.searchDefault(context) ;
        List<EMPlanDetailDTO> list = emplandetailMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMPlanDetail-Default-all')")
	@ApiOperation(value = "searchDEFAULTByEMPlanTemplEMPlan", tags = {"EMPlanDetail" } ,notes = "searchDEFAULTByEMPlanTemplEMPlan")
    @RequestMapping(method= RequestMethod.POST , value="/emplantempls/{emplantempl_id}/emplans/{emplan_id}/emplandetails/searchdefault")
	public ResponseEntity<Page<EMPlanDetailDTO>> searchEMPlanDetailDefaultByEMPlanTemplEMPlan(@PathVariable("emplantempl_id") String emplantempl_id, @PathVariable("emplan_id") String emplan_id, @RequestBody EMPlanDetailSearchContext context) {
        context.setN_planid_eq(emplan_id);
        Page<EMPlanDetail> domains = emplandetailService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emplandetailMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
    @PreAuthorize("hasPermission(#emplandetail_id,'Get',{'Sql',this.emplandetailMapping,this.permissionDTO})")
    @ApiOperation(value = "GetByEMServiceEMPlan", tags = {"EMPlanDetail" },  notes = "GetByEMServiceEMPlan")
	@RequestMapping(method = RequestMethod.GET, value = "/emservices/{emservice_id}/emplans/{emplan_id}/emplandetails/{emplandetail_id}")
    public ResponseEntity<EMPlanDetailDTO> getByEMServiceEMPlan(@PathVariable("emservice_id") String emservice_id, @PathVariable("emplan_id") String emplan_id, @PathVariable("emplandetail_id") String emplandetail_id) {
        EMPlanDetail domain = emplandetailService.get(emplandetail_id);
        EMPlanDetailDTO dto = emplandetailMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMPlanDetail-GetDraft-all')")
    @ApiOperation(value = "GetDraftByEMServiceEMPlan", tags = {"EMPlanDetail" },  notes = "GetDraftByEMServiceEMPlan")
    @RequestMapping(method = RequestMethod.GET, value = "/emservices/{emservice_id}/emplans/{emplan_id}/emplandetails/getdraft")
    public ResponseEntity<EMPlanDetailDTO> getDraftByEMServiceEMPlan(@PathVariable("emservice_id") String emservice_id, @PathVariable("emplan_id") String emplan_id) {
        EMPlanDetail domain = new EMPlanDetail();
        domain.setPlanid(emplan_id);
        return ResponseEntity.status(HttpStatus.OK).body(emplandetailMapping.toDto(emplandetailService.getDraft(domain)));
    }

    @PreAuthorize("hasPermission('','Save',{'Sql',this.emplandetailMapping,#emplandetaildto})")
    @ApiOperation(value = "SaveByEMServiceEMPlan", tags = {"EMPlanDetail" },  notes = "SaveByEMServiceEMPlan")
	@RequestMapping(method = RequestMethod.POST, value = "/emservices/{emservice_id}/emplans/{emplan_id}/emplandetails/save")
    public ResponseEntity<Boolean> saveByEMServiceEMPlan(@PathVariable("emservice_id") String emservice_id, @PathVariable("emplan_id") String emplan_id, @RequestBody EMPlanDetailDTO emplandetaildto) {
        EMPlanDetail domain = emplandetailMapping.toDomain(emplandetaildto);
        domain.setPlanid(emplan_id);
        return ResponseEntity.status(HttpStatus.OK).body(emplandetailService.save(domain));
    }

    @PreAuthorize("hasPermission('Save',{'Sql',this.emplandetailMapping,#emplandetaildtos})")
    @ApiOperation(value = "SaveBatchByEMServiceEMPlan", tags = {"EMPlanDetail" },  notes = "SaveBatchByEMServiceEMPlan")
	@RequestMapping(method = RequestMethod.POST, value = "/emservices/{emservice_id}/emplans/{emplan_id}/emplandetails/savebatch")
    public ResponseEntity<Boolean> saveBatchByEMServiceEMPlan(@PathVariable("emservice_id") String emservice_id, @PathVariable("emplan_id") String emplan_id, @RequestBody List<EMPlanDetailDTO> emplandetaildtos) {
        List<EMPlanDetail> domainlist=emplandetailMapping.toDomain(emplandetaildtos);
        for(EMPlanDetail domain:domainlist){
             domain.setPlanid(emplan_id);
        }
        emplandetailService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(#emplandetail_id,'Update',{'Sql',this.emplandetailMapping,#emplandetaildto})")
    @ApiOperation(value = "UpdateByEMServiceEMPlan", tags = {"EMPlanDetail" },  notes = "UpdateByEMServiceEMPlan")
	@RequestMapping(method = RequestMethod.PUT, value = "/emservices/{emservice_id}/emplans/{emplan_id}/emplandetails/{emplandetail_id}")
    @Transactional
    public ResponseEntity<EMPlanDetailDTO> updateByEMServiceEMPlan(@PathVariable("emservice_id") String emservice_id, @PathVariable("emplan_id") String emplan_id, @PathVariable("emplandetail_id") String emplandetail_id, @RequestBody EMPlanDetailDTO emplandetaildto) {
        EMPlanDetail domain = emplandetailMapping.toDomain(emplandetaildto);
        domain.setPlanid(emplan_id);
        domain.setEmplandetailid(emplandetail_id);
		emplandetailService.update(domain);
        EMPlanDetailDTO dto = emplandetailMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Update',{'Sql',this.emplandetailMapping,#emplandetaildtos})")
    @ApiOperation(value = "UpdateBatchByEMServiceEMPlan", tags = {"EMPlanDetail" },  notes = "UpdateBatchByEMServiceEMPlan")
	@RequestMapping(method = RequestMethod.PUT, value = "/emservices/{emservice_id}/emplans/{emplan_id}/emplandetails/batch")
    public ResponseEntity<Boolean> updateBatchByEMServiceEMPlan(@PathVariable("emservice_id") String emservice_id, @PathVariable("emplan_id") String emplan_id, @RequestBody List<EMPlanDetailDTO> emplandetaildtos) {
        List<EMPlanDetail> domainlist=emplandetailMapping.toDomain(emplandetaildtos);
        for(EMPlanDetail domain:domainlist){
            domain.setPlanid(emplan_id);
        }
        emplandetailService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission('','Create',{'Sql',this.emplandetailMapping,#emplandetaildto})")
    @ApiOperation(value = "CreateByEMServiceEMPlan", tags = {"EMPlanDetail" },  notes = "CreateByEMServiceEMPlan")
	@RequestMapping(method = RequestMethod.POST, value = "/emservices/{emservice_id}/emplans/{emplan_id}/emplandetails")
    @Transactional
    public ResponseEntity<EMPlanDetailDTO> createByEMServiceEMPlan(@PathVariable("emservice_id") String emservice_id, @PathVariable("emplan_id") String emplan_id, @RequestBody EMPlanDetailDTO emplandetaildto) {
        EMPlanDetail domain = emplandetailMapping.toDomain(emplandetaildto);
        domain.setPlanid(emplan_id);
		emplandetailService.create(domain);
        EMPlanDetailDTO dto = emplandetailMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Create',{'Sql',this.emplandetailMapping,#emplandetaildtos})")
    @ApiOperation(value = "createBatchByEMServiceEMPlan", tags = {"EMPlanDetail" },  notes = "createBatchByEMServiceEMPlan")
	@RequestMapping(method = RequestMethod.POST, value = "/emservices/{emservice_id}/emplans/{emplan_id}/emplandetails/batch")
    public ResponseEntity<Boolean> createBatchByEMServiceEMPlan(@PathVariable("emservice_id") String emservice_id, @PathVariable("emplan_id") String emplan_id, @RequestBody List<EMPlanDetailDTO> emplandetaildtos) {
        List<EMPlanDetail> domainlist=emplandetailMapping.toDomain(emplandetaildtos);
        for(EMPlanDetail domain:domainlist){
            domain.setPlanid(emplan_id);
        }
        emplandetailService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMPlanDetail-CheckKey-all')")
    @ApiOperation(value = "CheckKeyByEMServiceEMPlan", tags = {"EMPlanDetail" },  notes = "CheckKeyByEMServiceEMPlan")
	@RequestMapping(method = RequestMethod.POST, value = "/emservices/{emservice_id}/emplans/{emplan_id}/emplandetails/checkkey")
    public ResponseEntity<Boolean> checkKeyByEMServiceEMPlan(@PathVariable("emservice_id") String emservice_id, @PathVariable("emplan_id") String emplan_id, @RequestBody EMPlanDetailDTO emplandetaildto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emplandetailService.checkKey(emplandetailMapping.toDomain(emplandetaildto)));
    }

    @PreAuthorize("hasPermission(#emplandetail_id,'Remove',{'Sql',this.emplandetailMapping,this.permissionDTO})")
    @ApiOperation(value = "RemoveByEMServiceEMPlan", tags = {"EMPlanDetail" },  notes = "RemoveByEMServiceEMPlan")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emservices/{emservice_id}/emplans/{emplan_id}/emplandetails/{emplandetail_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByEMServiceEMPlan(@PathVariable("emservice_id") String emservice_id, @PathVariable("emplan_id") String emplan_id, @PathVariable("emplandetail_id") String emplandetail_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emplandetailService.remove(emplandetail_id));
    }

    @PreAuthorize("hasPermission('Remove',{'Sql',this.emplandetailMapping,this.permissionDTO,#ids})")
    @ApiOperation(value = "RemoveBatchByEMServiceEMPlan", tags = {"EMPlanDetail" },  notes = "RemoveBatchByEMServiceEMPlan")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emservices/{emservice_id}/emplans/{emplan_id}/emplandetails/batch")
    public ResponseEntity<Boolean> removeBatchByEMServiceEMPlan(@RequestBody List<String> ids) {
        emplandetailService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMPlanDetail-Default-all')")
	@ApiOperation(value = "fetchDEFAULTByEMServiceEMPlan", tags = {"EMPlanDetail" } ,notes = "fetchDEFAULTByEMServiceEMPlan")
    @RequestMapping(method= RequestMethod.GET , value="/emservices/{emservice_id}/emplans/{emplan_id}/emplandetails/fetchdefault")
	public ResponseEntity<List<EMPlanDetailDTO>> fetchEMPlanDetailDefaultByEMServiceEMPlan(@PathVariable("emservice_id") String emservice_id, @PathVariable("emplan_id") String emplan_id,EMPlanDetailSearchContext context) {
        context.setN_planid_eq(emplan_id);
        Page<EMPlanDetail> domains = emplandetailService.searchDefault(context) ;
        List<EMPlanDetailDTO> list = emplandetailMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMPlanDetail-Default-all')")
	@ApiOperation(value = "searchDEFAULTByEMServiceEMPlan", tags = {"EMPlanDetail" } ,notes = "searchDEFAULTByEMServiceEMPlan")
    @RequestMapping(method= RequestMethod.POST , value="/emservices/{emservice_id}/emplans/{emplan_id}/emplandetails/searchdefault")
	public ResponseEntity<Page<EMPlanDetailDTO>> searchEMPlanDetailDefaultByEMServiceEMPlan(@PathVariable("emservice_id") String emservice_id, @PathVariable("emplan_id") String emplan_id, @RequestBody EMPlanDetailSearchContext context) {
        context.setN_planid_eq(emplan_id);
        Page<EMPlanDetail> domains = emplandetailService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emplandetailMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
    @PreAuthorize("hasPermission(#emplandetail_id,'Get',{'Sql',this.emplandetailMapping,this.permissionDTO})")
    @ApiOperation(value = "GetByPFDeptEMPlan", tags = {"EMPlanDetail" },  notes = "GetByPFDeptEMPlan")
	@RequestMapping(method = RequestMethod.GET, value = "/pfdepts/{pfdept_id}/emplans/{emplan_id}/emplandetails/{emplandetail_id}")
    public ResponseEntity<EMPlanDetailDTO> getByPFDeptEMPlan(@PathVariable("pfdept_id") String pfdept_id, @PathVariable("emplan_id") String emplan_id, @PathVariable("emplandetail_id") String emplandetail_id) {
        EMPlanDetail domain = emplandetailService.get(emplandetail_id);
        EMPlanDetailDTO dto = emplandetailMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMPlanDetail-GetDraft-all')")
    @ApiOperation(value = "GetDraftByPFDeptEMPlan", tags = {"EMPlanDetail" },  notes = "GetDraftByPFDeptEMPlan")
    @RequestMapping(method = RequestMethod.GET, value = "/pfdepts/{pfdept_id}/emplans/{emplan_id}/emplandetails/getdraft")
    public ResponseEntity<EMPlanDetailDTO> getDraftByPFDeptEMPlan(@PathVariable("pfdept_id") String pfdept_id, @PathVariable("emplan_id") String emplan_id) {
        EMPlanDetail domain = new EMPlanDetail();
        domain.setPlanid(emplan_id);
        return ResponseEntity.status(HttpStatus.OK).body(emplandetailMapping.toDto(emplandetailService.getDraft(domain)));
    }

    @PreAuthorize("hasPermission('','Save',{'Sql',this.emplandetailMapping,#emplandetaildto})")
    @ApiOperation(value = "SaveByPFDeptEMPlan", tags = {"EMPlanDetail" },  notes = "SaveByPFDeptEMPlan")
	@RequestMapping(method = RequestMethod.POST, value = "/pfdepts/{pfdept_id}/emplans/{emplan_id}/emplandetails/save")
    public ResponseEntity<Boolean> saveByPFDeptEMPlan(@PathVariable("pfdept_id") String pfdept_id, @PathVariable("emplan_id") String emplan_id, @RequestBody EMPlanDetailDTO emplandetaildto) {
        EMPlanDetail domain = emplandetailMapping.toDomain(emplandetaildto);
        domain.setPlanid(emplan_id);
        return ResponseEntity.status(HttpStatus.OK).body(emplandetailService.save(domain));
    }

    @PreAuthorize("hasPermission('Save',{'Sql',this.emplandetailMapping,#emplandetaildtos})")
    @ApiOperation(value = "SaveBatchByPFDeptEMPlan", tags = {"EMPlanDetail" },  notes = "SaveBatchByPFDeptEMPlan")
	@RequestMapping(method = RequestMethod.POST, value = "/pfdepts/{pfdept_id}/emplans/{emplan_id}/emplandetails/savebatch")
    public ResponseEntity<Boolean> saveBatchByPFDeptEMPlan(@PathVariable("pfdept_id") String pfdept_id, @PathVariable("emplan_id") String emplan_id, @RequestBody List<EMPlanDetailDTO> emplandetaildtos) {
        List<EMPlanDetail> domainlist=emplandetailMapping.toDomain(emplandetaildtos);
        for(EMPlanDetail domain:domainlist){
             domain.setPlanid(emplan_id);
        }
        emplandetailService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(#emplandetail_id,'Update',{'Sql',this.emplandetailMapping,#emplandetaildto})")
    @ApiOperation(value = "UpdateByPFDeptEMPlan", tags = {"EMPlanDetail" },  notes = "UpdateByPFDeptEMPlan")
	@RequestMapping(method = RequestMethod.PUT, value = "/pfdepts/{pfdept_id}/emplans/{emplan_id}/emplandetails/{emplandetail_id}")
    @Transactional
    public ResponseEntity<EMPlanDetailDTO> updateByPFDeptEMPlan(@PathVariable("pfdept_id") String pfdept_id, @PathVariable("emplan_id") String emplan_id, @PathVariable("emplandetail_id") String emplandetail_id, @RequestBody EMPlanDetailDTO emplandetaildto) {
        EMPlanDetail domain = emplandetailMapping.toDomain(emplandetaildto);
        domain.setPlanid(emplan_id);
        domain.setEmplandetailid(emplandetail_id);
		emplandetailService.update(domain);
        EMPlanDetailDTO dto = emplandetailMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Update',{'Sql',this.emplandetailMapping,#emplandetaildtos})")
    @ApiOperation(value = "UpdateBatchByPFDeptEMPlan", tags = {"EMPlanDetail" },  notes = "UpdateBatchByPFDeptEMPlan")
	@RequestMapping(method = RequestMethod.PUT, value = "/pfdepts/{pfdept_id}/emplans/{emplan_id}/emplandetails/batch")
    public ResponseEntity<Boolean> updateBatchByPFDeptEMPlan(@PathVariable("pfdept_id") String pfdept_id, @PathVariable("emplan_id") String emplan_id, @RequestBody List<EMPlanDetailDTO> emplandetaildtos) {
        List<EMPlanDetail> domainlist=emplandetailMapping.toDomain(emplandetaildtos);
        for(EMPlanDetail domain:domainlist){
            domain.setPlanid(emplan_id);
        }
        emplandetailService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission('','Create',{'Sql',this.emplandetailMapping,#emplandetaildto})")
    @ApiOperation(value = "CreateByPFDeptEMPlan", tags = {"EMPlanDetail" },  notes = "CreateByPFDeptEMPlan")
	@RequestMapping(method = RequestMethod.POST, value = "/pfdepts/{pfdept_id}/emplans/{emplan_id}/emplandetails")
    @Transactional
    public ResponseEntity<EMPlanDetailDTO> createByPFDeptEMPlan(@PathVariable("pfdept_id") String pfdept_id, @PathVariable("emplan_id") String emplan_id, @RequestBody EMPlanDetailDTO emplandetaildto) {
        EMPlanDetail domain = emplandetailMapping.toDomain(emplandetaildto);
        domain.setPlanid(emplan_id);
		emplandetailService.create(domain);
        EMPlanDetailDTO dto = emplandetailMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Create',{'Sql',this.emplandetailMapping,#emplandetaildtos})")
    @ApiOperation(value = "createBatchByPFDeptEMPlan", tags = {"EMPlanDetail" },  notes = "createBatchByPFDeptEMPlan")
	@RequestMapping(method = RequestMethod.POST, value = "/pfdepts/{pfdept_id}/emplans/{emplan_id}/emplandetails/batch")
    public ResponseEntity<Boolean> createBatchByPFDeptEMPlan(@PathVariable("pfdept_id") String pfdept_id, @PathVariable("emplan_id") String emplan_id, @RequestBody List<EMPlanDetailDTO> emplandetaildtos) {
        List<EMPlanDetail> domainlist=emplandetailMapping.toDomain(emplandetaildtos);
        for(EMPlanDetail domain:domainlist){
            domain.setPlanid(emplan_id);
        }
        emplandetailService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMPlanDetail-CheckKey-all')")
    @ApiOperation(value = "CheckKeyByPFDeptEMPlan", tags = {"EMPlanDetail" },  notes = "CheckKeyByPFDeptEMPlan")
	@RequestMapping(method = RequestMethod.POST, value = "/pfdepts/{pfdept_id}/emplans/{emplan_id}/emplandetails/checkkey")
    public ResponseEntity<Boolean> checkKeyByPFDeptEMPlan(@PathVariable("pfdept_id") String pfdept_id, @PathVariable("emplan_id") String emplan_id, @RequestBody EMPlanDetailDTO emplandetaildto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emplandetailService.checkKey(emplandetailMapping.toDomain(emplandetaildto)));
    }

    @PreAuthorize("hasPermission(#emplandetail_id,'Remove',{'Sql',this.emplandetailMapping,this.permissionDTO})")
    @ApiOperation(value = "RemoveByPFDeptEMPlan", tags = {"EMPlanDetail" },  notes = "RemoveByPFDeptEMPlan")
	@RequestMapping(method = RequestMethod.DELETE, value = "/pfdepts/{pfdept_id}/emplans/{emplan_id}/emplandetails/{emplandetail_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByPFDeptEMPlan(@PathVariable("pfdept_id") String pfdept_id, @PathVariable("emplan_id") String emplan_id, @PathVariable("emplandetail_id") String emplandetail_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emplandetailService.remove(emplandetail_id));
    }

    @PreAuthorize("hasPermission('Remove',{'Sql',this.emplandetailMapping,this.permissionDTO,#ids})")
    @ApiOperation(value = "RemoveBatchByPFDeptEMPlan", tags = {"EMPlanDetail" },  notes = "RemoveBatchByPFDeptEMPlan")
	@RequestMapping(method = RequestMethod.DELETE, value = "/pfdepts/{pfdept_id}/emplans/{emplan_id}/emplandetails/batch")
    public ResponseEntity<Boolean> removeBatchByPFDeptEMPlan(@RequestBody List<String> ids) {
        emplandetailService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMPlanDetail-Default-all')")
	@ApiOperation(value = "fetchDEFAULTByPFDeptEMPlan", tags = {"EMPlanDetail" } ,notes = "fetchDEFAULTByPFDeptEMPlan")
    @RequestMapping(method= RequestMethod.GET , value="/pfdepts/{pfdept_id}/emplans/{emplan_id}/emplandetails/fetchdefault")
	public ResponseEntity<List<EMPlanDetailDTO>> fetchEMPlanDetailDefaultByPFDeptEMPlan(@PathVariable("pfdept_id") String pfdept_id, @PathVariable("emplan_id") String emplan_id,EMPlanDetailSearchContext context) {
        context.setN_planid_eq(emplan_id);
        Page<EMPlanDetail> domains = emplandetailService.searchDefault(context) ;
        List<EMPlanDetailDTO> list = emplandetailMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMPlanDetail-Default-all')")
	@ApiOperation(value = "searchDEFAULTByPFDeptEMPlan", tags = {"EMPlanDetail" } ,notes = "searchDEFAULTByPFDeptEMPlan")
    @RequestMapping(method= RequestMethod.POST , value="/pfdepts/{pfdept_id}/emplans/{emplan_id}/emplandetails/searchdefault")
	public ResponseEntity<Page<EMPlanDetailDTO>> searchEMPlanDetailDefaultByPFDeptEMPlan(@PathVariable("pfdept_id") String pfdept_id, @PathVariable("emplan_id") String emplan_id, @RequestBody EMPlanDetailSearchContext context) {
        context.setN_planid_eq(emplan_id);
        Page<EMPlanDetail> domains = emplandetailService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emplandetailMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
    @PreAuthorize("hasPermission(#emplandetail_id,'Get',{'Sql',this.emplandetailMapping,this.permissionDTO})")
    @ApiOperation(value = "GetByPFEmpEMPlan", tags = {"EMPlanDetail" },  notes = "GetByPFEmpEMPlan")
	@RequestMapping(method = RequestMethod.GET, value = "/pfemps/{pfemp_id}/emplans/{emplan_id}/emplandetails/{emplandetail_id}")
    public ResponseEntity<EMPlanDetailDTO> getByPFEmpEMPlan(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emplan_id") String emplan_id, @PathVariable("emplandetail_id") String emplandetail_id) {
        EMPlanDetail domain = emplandetailService.get(emplandetail_id);
        EMPlanDetailDTO dto = emplandetailMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMPlanDetail-GetDraft-all')")
    @ApiOperation(value = "GetDraftByPFEmpEMPlan", tags = {"EMPlanDetail" },  notes = "GetDraftByPFEmpEMPlan")
    @RequestMapping(method = RequestMethod.GET, value = "/pfemps/{pfemp_id}/emplans/{emplan_id}/emplandetails/getdraft")
    public ResponseEntity<EMPlanDetailDTO> getDraftByPFEmpEMPlan(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emplan_id") String emplan_id) {
        EMPlanDetail domain = new EMPlanDetail();
        domain.setPlanid(emplan_id);
        return ResponseEntity.status(HttpStatus.OK).body(emplandetailMapping.toDto(emplandetailService.getDraft(domain)));
    }

    @PreAuthorize("hasPermission('','Save',{'Sql',this.emplandetailMapping,#emplandetaildto})")
    @ApiOperation(value = "SaveByPFEmpEMPlan", tags = {"EMPlanDetail" },  notes = "SaveByPFEmpEMPlan")
	@RequestMapping(method = RequestMethod.POST, value = "/pfemps/{pfemp_id}/emplans/{emplan_id}/emplandetails/save")
    public ResponseEntity<Boolean> saveByPFEmpEMPlan(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emplan_id") String emplan_id, @RequestBody EMPlanDetailDTO emplandetaildto) {
        EMPlanDetail domain = emplandetailMapping.toDomain(emplandetaildto);
        domain.setPlanid(emplan_id);
        return ResponseEntity.status(HttpStatus.OK).body(emplandetailService.save(domain));
    }

    @PreAuthorize("hasPermission('Save',{'Sql',this.emplandetailMapping,#emplandetaildtos})")
    @ApiOperation(value = "SaveBatchByPFEmpEMPlan", tags = {"EMPlanDetail" },  notes = "SaveBatchByPFEmpEMPlan")
	@RequestMapping(method = RequestMethod.POST, value = "/pfemps/{pfemp_id}/emplans/{emplan_id}/emplandetails/savebatch")
    public ResponseEntity<Boolean> saveBatchByPFEmpEMPlan(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emplan_id") String emplan_id, @RequestBody List<EMPlanDetailDTO> emplandetaildtos) {
        List<EMPlanDetail> domainlist=emplandetailMapping.toDomain(emplandetaildtos);
        for(EMPlanDetail domain:domainlist){
             domain.setPlanid(emplan_id);
        }
        emplandetailService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(#emplandetail_id,'Update',{'Sql',this.emplandetailMapping,#emplandetaildto})")
    @ApiOperation(value = "UpdateByPFEmpEMPlan", tags = {"EMPlanDetail" },  notes = "UpdateByPFEmpEMPlan")
	@RequestMapping(method = RequestMethod.PUT, value = "/pfemps/{pfemp_id}/emplans/{emplan_id}/emplandetails/{emplandetail_id}")
    @Transactional
    public ResponseEntity<EMPlanDetailDTO> updateByPFEmpEMPlan(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emplan_id") String emplan_id, @PathVariable("emplandetail_id") String emplandetail_id, @RequestBody EMPlanDetailDTO emplandetaildto) {
        EMPlanDetail domain = emplandetailMapping.toDomain(emplandetaildto);
        domain.setPlanid(emplan_id);
        domain.setEmplandetailid(emplandetail_id);
		emplandetailService.update(domain);
        EMPlanDetailDTO dto = emplandetailMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Update',{'Sql',this.emplandetailMapping,#emplandetaildtos})")
    @ApiOperation(value = "UpdateBatchByPFEmpEMPlan", tags = {"EMPlanDetail" },  notes = "UpdateBatchByPFEmpEMPlan")
	@RequestMapping(method = RequestMethod.PUT, value = "/pfemps/{pfemp_id}/emplans/{emplan_id}/emplandetails/batch")
    public ResponseEntity<Boolean> updateBatchByPFEmpEMPlan(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emplan_id") String emplan_id, @RequestBody List<EMPlanDetailDTO> emplandetaildtos) {
        List<EMPlanDetail> domainlist=emplandetailMapping.toDomain(emplandetaildtos);
        for(EMPlanDetail domain:domainlist){
            domain.setPlanid(emplan_id);
        }
        emplandetailService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission('','Create',{'Sql',this.emplandetailMapping,#emplandetaildto})")
    @ApiOperation(value = "CreateByPFEmpEMPlan", tags = {"EMPlanDetail" },  notes = "CreateByPFEmpEMPlan")
	@RequestMapping(method = RequestMethod.POST, value = "/pfemps/{pfemp_id}/emplans/{emplan_id}/emplandetails")
    @Transactional
    public ResponseEntity<EMPlanDetailDTO> createByPFEmpEMPlan(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emplan_id") String emplan_id, @RequestBody EMPlanDetailDTO emplandetaildto) {
        EMPlanDetail domain = emplandetailMapping.toDomain(emplandetaildto);
        domain.setPlanid(emplan_id);
		emplandetailService.create(domain);
        EMPlanDetailDTO dto = emplandetailMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Create',{'Sql',this.emplandetailMapping,#emplandetaildtos})")
    @ApiOperation(value = "createBatchByPFEmpEMPlan", tags = {"EMPlanDetail" },  notes = "createBatchByPFEmpEMPlan")
	@RequestMapping(method = RequestMethod.POST, value = "/pfemps/{pfemp_id}/emplans/{emplan_id}/emplandetails/batch")
    public ResponseEntity<Boolean> createBatchByPFEmpEMPlan(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emplan_id") String emplan_id, @RequestBody List<EMPlanDetailDTO> emplandetaildtos) {
        List<EMPlanDetail> domainlist=emplandetailMapping.toDomain(emplandetaildtos);
        for(EMPlanDetail domain:domainlist){
            domain.setPlanid(emplan_id);
        }
        emplandetailService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMPlanDetail-CheckKey-all')")
    @ApiOperation(value = "CheckKeyByPFEmpEMPlan", tags = {"EMPlanDetail" },  notes = "CheckKeyByPFEmpEMPlan")
	@RequestMapping(method = RequestMethod.POST, value = "/pfemps/{pfemp_id}/emplans/{emplan_id}/emplandetails/checkkey")
    public ResponseEntity<Boolean> checkKeyByPFEmpEMPlan(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emplan_id") String emplan_id, @RequestBody EMPlanDetailDTO emplandetaildto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emplandetailService.checkKey(emplandetailMapping.toDomain(emplandetaildto)));
    }

    @PreAuthorize("hasPermission(#emplandetail_id,'Remove',{'Sql',this.emplandetailMapping,this.permissionDTO})")
    @ApiOperation(value = "RemoveByPFEmpEMPlan", tags = {"EMPlanDetail" },  notes = "RemoveByPFEmpEMPlan")
	@RequestMapping(method = RequestMethod.DELETE, value = "/pfemps/{pfemp_id}/emplans/{emplan_id}/emplandetails/{emplandetail_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByPFEmpEMPlan(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emplan_id") String emplan_id, @PathVariable("emplandetail_id") String emplandetail_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emplandetailService.remove(emplandetail_id));
    }

    @PreAuthorize("hasPermission('Remove',{'Sql',this.emplandetailMapping,this.permissionDTO,#ids})")
    @ApiOperation(value = "RemoveBatchByPFEmpEMPlan", tags = {"EMPlanDetail" },  notes = "RemoveBatchByPFEmpEMPlan")
	@RequestMapping(method = RequestMethod.DELETE, value = "/pfemps/{pfemp_id}/emplans/{emplan_id}/emplandetails/batch")
    public ResponseEntity<Boolean> removeBatchByPFEmpEMPlan(@RequestBody List<String> ids) {
        emplandetailService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMPlanDetail-Default-all')")
	@ApiOperation(value = "fetchDEFAULTByPFEmpEMPlan", tags = {"EMPlanDetail" } ,notes = "fetchDEFAULTByPFEmpEMPlan")
    @RequestMapping(method= RequestMethod.GET , value="/pfemps/{pfemp_id}/emplans/{emplan_id}/emplandetails/fetchdefault")
	public ResponseEntity<List<EMPlanDetailDTO>> fetchEMPlanDetailDefaultByPFEmpEMPlan(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emplan_id") String emplan_id,EMPlanDetailSearchContext context) {
        context.setN_planid_eq(emplan_id);
        Page<EMPlanDetail> domains = emplandetailService.searchDefault(context) ;
        List<EMPlanDetailDTO> list = emplandetailMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMPlanDetail-Default-all')")
	@ApiOperation(value = "searchDEFAULTByPFEmpEMPlan", tags = {"EMPlanDetail" } ,notes = "searchDEFAULTByPFEmpEMPlan")
    @RequestMapping(method= RequestMethod.POST , value="/pfemps/{pfemp_id}/emplans/{emplan_id}/emplandetails/searchdefault")
	public ResponseEntity<Page<EMPlanDetailDTO>> searchEMPlanDetailDefaultByPFEmpEMPlan(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emplan_id") String emplan_id, @RequestBody EMPlanDetailSearchContext context) {
        context.setN_planid_eq(emplan_id);
        Page<EMPlanDetail> domains = emplandetailService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emplandetailMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
    @PreAuthorize("hasPermission(#emplandetail_id,'Get',{'Sql',this.emplandetailMapping,this.permissionDTO})")
    @ApiOperation(value = "GetByPFTeamEMPlan", tags = {"EMPlanDetail" },  notes = "GetByPFTeamEMPlan")
	@RequestMapping(method = RequestMethod.GET, value = "/pfteams/{pfteam_id}/emplans/{emplan_id}/emplandetails/{emplandetail_id}")
    public ResponseEntity<EMPlanDetailDTO> getByPFTeamEMPlan(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emplan_id") String emplan_id, @PathVariable("emplandetail_id") String emplandetail_id) {
        EMPlanDetail domain = emplandetailService.get(emplandetail_id);
        EMPlanDetailDTO dto = emplandetailMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMPlanDetail-GetDraft-all')")
    @ApiOperation(value = "GetDraftByPFTeamEMPlan", tags = {"EMPlanDetail" },  notes = "GetDraftByPFTeamEMPlan")
    @RequestMapping(method = RequestMethod.GET, value = "/pfteams/{pfteam_id}/emplans/{emplan_id}/emplandetails/getdraft")
    public ResponseEntity<EMPlanDetailDTO> getDraftByPFTeamEMPlan(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emplan_id") String emplan_id) {
        EMPlanDetail domain = new EMPlanDetail();
        domain.setPlanid(emplan_id);
        return ResponseEntity.status(HttpStatus.OK).body(emplandetailMapping.toDto(emplandetailService.getDraft(domain)));
    }

    @PreAuthorize("hasPermission('','Save',{'Sql',this.emplandetailMapping,#emplandetaildto})")
    @ApiOperation(value = "SaveByPFTeamEMPlan", tags = {"EMPlanDetail" },  notes = "SaveByPFTeamEMPlan")
	@RequestMapping(method = RequestMethod.POST, value = "/pfteams/{pfteam_id}/emplans/{emplan_id}/emplandetails/save")
    public ResponseEntity<Boolean> saveByPFTeamEMPlan(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emplan_id") String emplan_id, @RequestBody EMPlanDetailDTO emplandetaildto) {
        EMPlanDetail domain = emplandetailMapping.toDomain(emplandetaildto);
        domain.setPlanid(emplan_id);
        return ResponseEntity.status(HttpStatus.OK).body(emplandetailService.save(domain));
    }

    @PreAuthorize("hasPermission('Save',{'Sql',this.emplandetailMapping,#emplandetaildtos})")
    @ApiOperation(value = "SaveBatchByPFTeamEMPlan", tags = {"EMPlanDetail" },  notes = "SaveBatchByPFTeamEMPlan")
	@RequestMapping(method = RequestMethod.POST, value = "/pfteams/{pfteam_id}/emplans/{emplan_id}/emplandetails/savebatch")
    public ResponseEntity<Boolean> saveBatchByPFTeamEMPlan(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emplan_id") String emplan_id, @RequestBody List<EMPlanDetailDTO> emplandetaildtos) {
        List<EMPlanDetail> domainlist=emplandetailMapping.toDomain(emplandetaildtos);
        for(EMPlanDetail domain:domainlist){
             domain.setPlanid(emplan_id);
        }
        emplandetailService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(#emplandetail_id,'Update',{'Sql',this.emplandetailMapping,#emplandetaildto})")
    @ApiOperation(value = "UpdateByPFTeamEMPlan", tags = {"EMPlanDetail" },  notes = "UpdateByPFTeamEMPlan")
	@RequestMapping(method = RequestMethod.PUT, value = "/pfteams/{pfteam_id}/emplans/{emplan_id}/emplandetails/{emplandetail_id}")
    @Transactional
    public ResponseEntity<EMPlanDetailDTO> updateByPFTeamEMPlan(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emplan_id") String emplan_id, @PathVariable("emplandetail_id") String emplandetail_id, @RequestBody EMPlanDetailDTO emplandetaildto) {
        EMPlanDetail domain = emplandetailMapping.toDomain(emplandetaildto);
        domain.setPlanid(emplan_id);
        domain.setEmplandetailid(emplandetail_id);
		emplandetailService.update(domain);
        EMPlanDetailDTO dto = emplandetailMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Update',{'Sql',this.emplandetailMapping,#emplandetaildtos})")
    @ApiOperation(value = "UpdateBatchByPFTeamEMPlan", tags = {"EMPlanDetail" },  notes = "UpdateBatchByPFTeamEMPlan")
	@RequestMapping(method = RequestMethod.PUT, value = "/pfteams/{pfteam_id}/emplans/{emplan_id}/emplandetails/batch")
    public ResponseEntity<Boolean> updateBatchByPFTeamEMPlan(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emplan_id") String emplan_id, @RequestBody List<EMPlanDetailDTO> emplandetaildtos) {
        List<EMPlanDetail> domainlist=emplandetailMapping.toDomain(emplandetaildtos);
        for(EMPlanDetail domain:domainlist){
            domain.setPlanid(emplan_id);
        }
        emplandetailService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission('','Create',{'Sql',this.emplandetailMapping,#emplandetaildto})")
    @ApiOperation(value = "CreateByPFTeamEMPlan", tags = {"EMPlanDetail" },  notes = "CreateByPFTeamEMPlan")
	@RequestMapping(method = RequestMethod.POST, value = "/pfteams/{pfteam_id}/emplans/{emplan_id}/emplandetails")
    @Transactional
    public ResponseEntity<EMPlanDetailDTO> createByPFTeamEMPlan(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emplan_id") String emplan_id, @RequestBody EMPlanDetailDTO emplandetaildto) {
        EMPlanDetail domain = emplandetailMapping.toDomain(emplandetaildto);
        domain.setPlanid(emplan_id);
		emplandetailService.create(domain);
        EMPlanDetailDTO dto = emplandetailMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Create',{'Sql',this.emplandetailMapping,#emplandetaildtos})")
    @ApiOperation(value = "createBatchByPFTeamEMPlan", tags = {"EMPlanDetail" },  notes = "createBatchByPFTeamEMPlan")
	@RequestMapping(method = RequestMethod.POST, value = "/pfteams/{pfteam_id}/emplans/{emplan_id}/emplandetails/batch")
    public ResponseEntity<Boolean> createBatchByPFTeamEMPlan(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emplan_id") String emplan_id, @RequestBody List<EMPlanDetailDTO> emplandetaildtos) {
        List<EMPlanDetail> domainlist=emplandetailMapping.toDomain(emplandetaildtos);
        for(EMPlanDetail domain:domainlist){
            domain.setPlanid(emplan_id);
        }
        emplandetailService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMPlanDetail-CheckKey-all')")
    @ApiOperation(value = "CheckKeyByPFTeamEMPlan", tags = {"EMPlanDetail" },  notes = "CheckKeyByPFTeamEMPlan")
	@RequestMapping(method = RequestMethod.POST, value = "/pfteams/{pfteam_id}/emplans/{emplan_id}/emplandetails/checkkey")
    public ResponseEntity<Boolean> checkKeyByPFTeamEMPlan(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emplan_id") String emplan_id, @RequestBody EMPlanDetailDTO emplandetaildto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emplandetailService.checkKey(emplandetailMapping.toDomain(emplandetaildto)));
    }

    @PreAuthorize("hasPermission(#emplandetail_id,'Remove',{'Sql',this.emplandetailMapping,this.permissionDTO})")
    @ApiOperation(value = "RemoveByPFTeamEMPlan", tags = {"EMPlanDetail" },  notes = "RemoveByPFTeamEMPlan")
	@RequestMapping(method = RequestMethod.DELETE, value = "/pfteams/{pfteam_id}/emplans/{emplan_id}/emplandetails/{emplandetail_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByPFTeamEMPlan(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emplan_id") String emplan_id, @PathVariable("emplandetail_id") String emplandetail_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emplandetailService.remove(emplandetail_id));
    }

    @PreAuthorize("hasPermission('Remove',{'Sql',this.emplandetailMapping,this.permissionDTO,#ids})")
    @ApiOperation(value = "RemoveBatchByPFTeamEMPlan", tags = {"EMPlanDetail" },  notes = "RemoveBatchByPFTeamEMPlan")
	@RequestMapping(method = RequestMethod.DELETE, value = "/pfteams/{pfteam_id}/emplans/{emplan_id}/emplandetails/batch")
    public ResponseEntity<Boolean> removeBatchByPFTeamEMPlan(@RequestBody List<String> ids) {
        emplandetailService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMPlanDetail-Default-all')")
	@ApiOperation(value = "fetchDEFAULTByPFTeamEMPlan", tags = {"EMPlanDetail" } ,notes = "fetchDEFAULTByPFTeamEMPlan")
    @RequestMapping(method= RequestMethod.GET , value="/pfteams/{pfteam_id}/emplans/{emplan_id}/emplandetails/fetchdefault")
	public ResponseEntity<List<EMPlanDetailDTO>> fetchEMPlanDetailDefaultByPFTeamEMPlan(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emplan_id") String emplan_id,EMPlanDetailSearchContext context) {
        context.setN_planid_eq(emplan_id);
        Page<EMPlanDetail> domains = emplandetailService.searchDefault(context) ;
        List<EMPlanDetailDTO> list = emplandetailMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMPlanDetail-Default-all')")
	@ApiOperation(value = "searchDEFAULTByPFTeamEMPlan", tags = {"EMPlanDetail" } ,notes = "searchDEFAULTByPFTeamEMPlan")
    @RequestMapping(method= RequestMethod.POST , value="/pfteams/{pfteam_id}/emplans/{emplan_id}/emplandetails/searchdefault")
	public ResponseEntity<Page<EMPlanDetailDTO>> searchEMPlanDetailDefaultByPFTeamEMPlan(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emplan_id") String emplan_id, @RequestBody EMPlanDetailSearchContext context) {
        context.setN_planid_eq(emplan_id);
        Page<EMPlanDetail> domains = emplandetailService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emplandetailMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
    @PreAuthorize("hasPermission(#emplandetail_id,'Get',{'Sql',this.emplandetailMapping,this.permissionDTO})")
    @ApiOperation(value = "GetByEMEQTypeEMEquipEMPlan", tags = {"EMPlanDetail" },  notes = "GetByEMEQTypeEMEquipEMPlan")
	@RequestMapping(method = RequestMethod.GET, value = "/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emplans/{emplan_id}/emplandetails/{emplandetail_id}")
    public ResponseEntity<EMPlanDetailDTO> getByEMEQTypeEMEquipEMPlan(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id, @PathVariable("emplan_id") String emplan_id, @PathVariable("emplandetail_id") String emplandetail_id) {
        EMPlanDetail domain = emplandetailService.get(emplandetail_id);
        EMPlanDetailDTO dto = emplandetailMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMPlanDetail-GetDraft-all')")
    @ApiOperation(value = "GetDraftByEMEQTypeEMEquipEMPlan", tags = {"EMPlanDetail" },  notes = "GetDraftByEMEQTypeEMEquipEMPlan")
    @RequestMapping(method = RequestMethod.GET, value = "/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emplans/{emplan_id}/emplandetails/getdraft")
    public ResponseEntity<EMPlanDetailDTO> getDraftByEMEQTypeEMEquipEMPlan(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id, @PathVariable("emplan_id") String emplan_id) {
        EMPlanDetail domain = new EMPlanDetail();
        domain.setPlanid(emplan_id);
        return ResponseEntity.status(HttpStatus.OK).body(emplandetailMapping.toDto(emplandetailService.getDraft(domain)));
    }

    @PreAuthorize("hasPermission('','Save',{'Sql',this.emplandetailMapping,#emplandetaildto})")
    @ApiOperation(value = "SaveByEMEQTypeEMEquipEMPlan", tags = {"EMPlanDetail" },  notes = "SaveByEMEQTypeEMEquipEMPlan")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emplans/{emplan_id}/emplandetails/save")
    public ResponseEntity<Boolean> saveByEMEQTypeEMEquipEMPlan(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id, @PathVariable("emplan_id") String emplan_id, @RequestBody EMPlanDetailDTO emplandetaildto) {
        EMPlanDetail domain = emplandetailMapping.toDomain(emplandetaildto);
        domain.setPlanid(emplan_id);
        return ResponseEntity.status(HttpStatus.OK).body(emplandetailService.save(domain));
    }

    @PreAuthorize("hasPermission('Save',{'Sql',this.emplandetailMapping,#emplandetaildtos})")
    @ApiOperation(value = "SaveBatchByEMEQTypeEMEquipEMPlan", tags = {"EMPlanDetail" },  notes = "SaveBatchByEMEQTypeEMEquipEMPlan")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emplans/{emplan_id}/emplandetails/savebatch")
    public ResponseEntity<Boolean> saveBatchByEMEQTypeEMEquipEMPlan(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id, @PathVariable("emplan_id") String emplan_id, @RequestBody List<EMPlanDetailDTO> emplandetaildtos) {
        List<EMPlanDetail> domainlist=emplandetailMapping.toDomain(emplandetaildtos);
        for(EMPlanDetail domain:domainlist){
             domain.setPlanid(emplan_id);
        }
        emplandetailService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(#emplandetail_id,'Update',{'Sql',this.emplandetailMapping,#emplandetaildto})")
    @ApiOperation(value = "UpdateByEMEQTypeEMEquipEMPlan", tags = {"EMPlanDetail" },  notes = "UpdateByEMEQTypeEMEquipEMPlan")
	@RequestMapping(method = RequestMethod.PUT, value = "/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emplans/{emplan_id}/emplandetails/{emplandetail_id}")
    @Transactional
    public ResponseEntity<EMPlanDetailDTO> updateByEMEQTypeEMEquipEMPlan(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id, @PathVariable("emplan_id") String emplan_id, @PathVariable("emplandetail_id") String emplandetail_id, @RequestBody EMPlanDetailDTO emplandetaildto) {
        EMPlanDetail domain = emplandetailMapping.toDomain(emplandetaildto);
        domain.setPlanid(emplan_id);
        domain.setEmplandetailid(emplandetail_id);
		emplandetailService.update(domain);
        EMPlanDetailDTO dto = emplandetailMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Update',{'Sql',this.emplandetailMapping,#emplandetaildtos})")
    @ApiOperation(value = "UpdateBatchByEMEQTypeEMEquipEMPlan", tags = {"EMPlanDetail" },  notes = "UpdateBatchByEMEQTypeEMEquipEMPlan")
	@RequestMapping(method = RequestMethod.PUT, value = "/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emplans/{emplan_id}/emplandetails/batch")
    public ResponseEntity<Boolean> updateBatchByEMEQTypeEMEquipEMPlan(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id, @PathVariable("emplan_id") String emplan_id, @RequestBody List<EMPlanDetailDTO> emplandetaildtos) {
        List<EMPlanDetail> domainlist=emplandetailMapping.toDomain(emplandetaildtos);
        for(EMPlanDetail domain:domainlist){
            domain.setPlanid(emplan_id);
        }
        emplandetailService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission('','Create',{'Sql',this.emplandetailMapping,#emplandetaildto})")
    @ApiOperation(value = "CreateByEMEQTypeEMEquipEMPlan", tags = {"EMPlanDetail" },  notes = "CreateByEMEQTypeEMEquipEMPlan")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emplans/{emplan_id}/emplandetails")
    @Transactional
    public ResponseEntity<EMPlanDetailDTO> createByEMEQTypeEMEquipEMPlan(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id, @PathVariable("emplan_id") String emplan_id, @RequestBody EMPlanDetailDTO emplandetaildto) {
        EMPlanDetail domain = emplandetailMapping.toDomain(emplandetaildto);
        domain.setPlanid(emplan_id);
		emplandetailService.create(domain);
        EMPlanDetailDTO dto = emplandetailMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Create',{'Sql',this.emplandetailMapping,#emplandetaildtos})")
    @ApiOperation(value = "createBatchByEMEQTypeEMEquipEMPlan", tags = {"EMPlanDetail" },  notes = "createBatchByEMEQTypeEMEquipEMPlan")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emplans/{emplan_id}/emplandetails/batch")
    public ResponseEntity<Boolean> createBatchByEMEQTypeEMEquipEMPlan(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id, @PathVariable("emplan_id") String emplan_id, @RequestBody List<EMPlanDetailDTO> emplandetaildtos) {
        List<EMPlanDetail> domainlist=emplandetailMapping.toDomain(emplandetaildtos);
        for(EMPlanDetail domain:domainlist){
            domain.setPlanid(emplan_id);
        }
        emplandetailService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMPlanDetail-CheckKey-all')")
    @ApiOperation(value = "CheckKeyByEMEQTypeEMEquipEMPlan", tags = {"EMPlanDetail" },  notes = "CheckKeyByEMEQTypeEMEquipEMPlan")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emplans/{emplan_id}/emplandetails/checkkey")
    public ResponseEntity<Boolean> checkKeyByEMEQTypeEMEquipEMPlan(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id, @PathVariable("emplan_id") String emplan_id, @RequestBody EMPlanDetailDTO emplandetaildto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emplandetailService.checkKey(emplandetailMapping.toDomain(emplandetaildto)));
    }

    @PreAuthorize("hasPermission(#emplandetail_id,'Remove',{'Sql',this.emplandetailMapping,this.permissionDTO})")
    @ApiOperation(value = "RemoveByEMEQTypeEMEquipEMPlan", tags = {"EMPlanDetail" },  notes = "RemoveByEMEQTypeEMEquipEMPlan")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emplans/{emplan_id}/emplandetails/{emplandetail_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByEMEQTypeEMEquipEMPlan(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id, @PathVariable("emplan_id") String emplan_id, @PathVariable("emplandetail_id") String emplandetail_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emplandetailService.remove(emplandetail_id));
    }

    @PreAuthorize("hasPermission('Remove',{'Sql',this.emplandetailMapping,this.permissionDTO,#ids})")
    @ApiOperation(value = "RemoveBatchByEMEQTypeEMEquipEMPlan", tags = {"EMPlanDetail" },  notes = "RemoveBatchByEMEQTypeEMEquipEMPlan")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emplans/{emplan_id}/emplandetails/batch")
    public ResponseEntity<Boolean> removeBatchByEMEQTypeEMEquipEMPlan(@RequestBody List<String> ids) {
        emplandetailService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMPlanDetail-Default-all')")
	@ApiOperation(value = "fetchDEFAULTByEMEQTypeEMEquipEMPlan", tags = {"EMPlanDetail" } ,notes = "fetchDEFAULTByEMEQTypeEMEquipEMPlan")
    @RequestMapping(method= RequestMethod.GET , value="/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emplans/{emplan_id}/emplandetails/fetchdefault")
	public ResponseEntity<List<EMPlanDetailDTO>> fetchEMPlanDetailDefaultByEMEQTypeEMEquipEMPlan(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id, @PathVariable("emplan_id") String emplan_id,EMPlanDetailSearchContext context) {
        context.setN_planid_eq(emplan_id);
        Page<EMPlanDetail> domains = emplandetailService.searchDefault(context) ;
        List<EMPlanDetailDTO> list = emplandetailMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMPlanDetail-Default-all')")
	@ApiOperation(value = "searchDEFAULTByEMEQTypeEMEquipEMPlan", tags = {"EMPlanDetail" } ,notes = "searchDEFAULTByEMEQTypeEMEquipEMPlan")
    @RequestMapping(method= RequestMethod.POST , value="/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emplans/{emplan_id}/emplandetails/searchdefault")
	public ResponseEntity<Page<EMPlanDetailDTO>> searchEMPlanDetailDefaultByEMEQTypeEMEquipEMPlan(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id, @PathVariable("emplan_id") String emplan_id, @RequestBody EMPlanDetailSearchContext context) {
        context.setN_planid_eq(emplan_id);
        Page<EMPlanDetail> domains = emplandetailService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emplandetailMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
    @PreAuthorize("hasPermission(#emplandetail_id,'Get',{'Sql',this.emplandetailMapping,this.permissionDTO})")
    @ApiOperation(value = "GetByPFTeamEMEquipEMPlan", tags = {"EMPlanDetail" },  notes = "GetByPFTeamEMEquipEMPlan")
	@RequestMapping(method = RequestMethod.GET, value = "/pfteams/{pfteam_id}/emequips/{emequip_id}/emplans/{emplan_id}/emplandetails/{emplandetail_id}")
    public ResponseEntity<EMPlanDetailDTO> getByPFTeamEMEquipEMPlan(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id, @PathVariable("emplan_id") String emplan_id, @PathVariable("emplandetail_id") String emplandetail_id) {
        EMPlanDetail domain = emplandetailService.get(emplandetail_id);
        EMPlanDetailDTO dto = emplandetailMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMPlanDetail-GetDraft-all')")
    @ApiOperation(value = "GetDraftByPFTeamEMEquipEMPlan", tags = {"EMPlanDetail" },  notes = "GetDraftByPFTeamEMEquipEMPlan")
    @RequestMapping(method = RequestMethod.GET, value = "/pfteams/{pfteam_id}/emequips/{emequip_id}/emplans/{emplan_id}/emplandetails/getdraft")
    public ResponseEntity<EMPlanDetailDTO> getDraftByPFTeamEMEquipEMPlan(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id, @PathVariable("emplan_id") String emplan_id) {
        EMPlanDetail domain = new EMPlanDetail();
        domain.setPlanid(emplan_id);
        return ResponseEntity.status(HttpStatus.OK).body(emplandetailMapping.toDto(emplandetailService.getDraft(domain)));
    }

    @PreAuthorize("hasPermission('','Save',{'Sql',this.emplandetailMapping,#emplandetaildto})")
    @ApiOperation(value = "SaveByPFTeamEMEquipEMPlan", tags = {"EMPlanDetail" },  notes = "SaveByPFTeamEMEquipEMPlan")
	@RequestMapping(method = RequestMethod.POST, value = "/pfteams/{pfteam_id}/emequips/{emequip_id}/emplans/{emplan_id}/emplandetails/save")
    public ResponseEntity<Boolean> saveByPFTeamEMEquipEMPlan(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id, @PathVariable("emplan_id") String emplan_id, @RequestBody EMPlanDetailDTO emplandetaildto) {
        EMPlanDetail domain = emplandetailMapping.toDomain(emplandetaildto);
        domain.setPlanid(emplan_id);
        return ResponseEntity.status(HttpStatus.OK).body(emplandetailService.save(domain));
    }

    @PreAuthorize("hasPermission('Save',{'Sql',this.emplandetailMapping,#emplandetaildtos})")
    @ApiOperation(value = "SaveBatchByPFTeamEMEquipEMPlan", tags = {"EMPlanDetail" },  notes = "SaveBatchByPFTeamEMEquipEMPlan")
	@RequestMapping(method = RequestMethod.POST, value = "/pfteams/{pfteam_id}/emequips/{emequip_id}/emplans/{emplan_id}/emplandetails/savebatch")
    public ResponseEntity<Boolean> saveBatchByPFTeamEMEquipEMPlan(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id, @PathVariable("emplan_id") String emplan_id, @RequestBody List<EMPlanDetailDTO> emplandetaildtos) {
        List<EMPlanDetail> domainlist=emplandetailMapping.toDomain(emplandetaildtos);
        for(EMPlanDetail domain:domainlist){
             domain.setPlanid(emplan_id);
        }
        emplandetailService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(#emplandetail_id,'Update',{'Sql',this.emplandetailMapping,#emplandetaildto})")
    @ApiOperation(value = "UpdateByPFTeamEMEquipEMPlan", tags = {"EMPlanDetail" },  notes = "UpdateByPFTeamEMEquipEMPlan")
	@RequestMapping(method = RequestMethod.PUT, value = "/pfteams/{pfteam_id}/emequips/{emequip_id}/emplans/{emplan_id}/emplandetails/{emplandetail_id}")
    @Transactional
    public ResponseEntity<EMPlanDetailDTO> updateByPFTeamEMEquipEMPlan(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id, @PathVariable("emplan_id") String emplan_id, @PathVariable("emplandetail_id") String emplandetail_id, @RequestBody EMPlanDetailDTO emplandetaildto) {
        EMPlanDetail domain = emplandetailMapping.toDomain(emplandetaildto);
        domain.setPlanid(emplan_id);
        domain.setEmplandetailid(emplandetail_id);
		emplandetailService.update(domain);
        EMPlanDetailDTO dto = emplandetailMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Update',{'Sql',this.emplandetailMapping,#emplandetaildtos})")
    @ApiOperation(value = "UpdateBatchByPFTeamEMEquipEMPlan", tags = {"EMPlanDetail" },  notes = "UpdateBatchByPFTeamEMEquipEMPlan")
	@RequestMapping(method = RequestMethod.PUT, value = "/pfteams/{pfteam_id}/emequips/{emequip_id}/emplans/{emplan_id}/emplandetails/batch")
    public ResponseEntity<Boolean> updateBatchByPFTeamEMEquipEMPlan(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id, @PathVariable("emplan_id") String emplan_id, @RequestBody List<EMPlanDetailDTO> emplandetaildtos) {
        List<EMPlanDetail> domainlist=emplandetailMapping.toDomain(emplandetaildtos);
        for(EMPlanDetail domain:domainlist){
            domain.setPlanid(emplan_id);
        }
        emplandetailService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission('','Create',{'Sql',this.emplandetailMapping,#emplandetaildto})")
    @ApiOperation(value = "CreateByPFTeamEMEquipEMPlan", tags = {"EMPlanDetail" },  notes = "CreateByPFTeamEMEquipEMPlan")
	@RequestMapping(method = RequestMethod.POST, value = "/pfteams/{pfteam_id}/emequips/{emequip_id}/emplans/{emplan_id}/emplandetails")
    @Transactional
    public ResponseEntity<EMPlanDetailDTO> createByPFTeamEMEquipEMPlan(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id, @PathVariable("emplan_id") String emplan_id, @RequestBody EMPlanDetailDTO emplandetaildto) {
        EMPlanDetail domain = emplandetailMapping.toDomain(emplandetaildto);
        domain.setPlanid(emplan_id);
		emplandetailService.create(domain);
        EMPlanDetailDTO dto = emplandetailMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Create',{'Sql',this.emplandetailMapping,#emplandetaildtos})")
    @ApiOperation(value = "createBatchByPFTeamEMEquipEMPlan", tags = {"EMPlanDetail" },  notes = "createBatchByPFTeamEMEquipEMPlan")
	@RequestMapping(method = RequestMethod.POST, value = "/pfteams/{pfteam_id}/emequips/{emequip_id}/emplans/{emplan_id}/emplandetails/batch")
    public ResponseEntity<Boolean> createBatchByPFTeamEMEquipEMPlan(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id, @PathVariable("emplan_id") String emplan_id, @RequestBody List<EMPlanDetailDTO> emplandetaildtos) {
        List<EMPlanDetail> domainlist=emplandetailMapping.toDomain(emplandetaildtos);
        for(EMPlanDetail domain:domainlist){
            domain.setPlanid(emplan_id);
        }
        emplandetailService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMPlanDetail-CheckKey-all')")
    @ApiOperation(value = "CheckKeyByPFTeamEMEquipEMPlan", tags = {"EMPlanDetail" },  notes = "CheckKeyByPFTeamEMEquipEMPlan")
	@RequestMapping(method = RequestMethod.POST, value = "/pfteams/{pfteam_id}/emequips/{emequip_id}/emplans/{emplan_id}/emplandetails/checkkey")
    public ResponseEntity<Boolean> checkKeyByPFTeamEMEquipEMPlan(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id, @PathVariable("emplan_id") String emplan_id, @RequestBody EMPlanDetailDTO emplandetaildto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emplandetailService.checkKey(emplandetailMapping.toDomain(emplandetaildto)));
    }

    @PreAuthorize("hasPermission(#emplandetail_id,'Remove',{'Sql',this.emplandetailMapping,this.permissionDTO})")
    @ApiOperation(value = "RemoveByPFTeamEMEquipEMPlan", tags = {"EMPlanDetail" },  notes = "RemoveByPFTeamEMEquipEMPlan")
	@RequestMapping(method = RequestMethod.DELETE, value = "/pfteams/{pfteam_id}/emequips/{emequip_id}/emplans/{emplan_id}/emplandetails/{emplandetail_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByPFTeamEMEquipEMPlan(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id, @PathVariable("emplan_id") String emplan_id, @PathVariable("emplandetail_id") String emplandetail_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emplandetailService.remove(emplandetail_id));
    }

    @PreAuthorize("hasPermission('Remove',{'Sql',this.emplandetailMapping,this.permissionDTO,#ids})")
    @ApiOperation(value = "RemoveBatchByPFTeamEMEquipEMPlan", tags = {"EMPlanDetail" },  notes = "RemoveBatchByPFTeamEMEquipEMPlan")
	@RequestMapping(method = RequestMethod.DELETE, value = "/pfteams/{pfteam_id}/emequips/{emequip_id}/emplans/{emplan_id}/emplandetails/batch")
    public ResponseEntity<Boolean> removeBatchByPFTeamEMEquipEMPlan(@RequestBody List<String> ids) {
        emplandetailService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMPlanDetail-Default-all')")
	@ApiOperation(value = "fetchDEFAULTByPFTeamEMEquipEMPlan", tags = {"EMPlanDetail" } ,notes = "fetchDEFAULTByPFTeamEMEquipEMPlan")
    @RequestMapping(method= RequestMethod.GET , value="/pfteams/{pfteam_id}/emequips/{emequip_id}/emplans/{emplan_id}/emplandetails/fetchdefault")
	public ResponseEntity<List<EMPlanDetailDTO>> fetchEMPlanDetailDefaultByPFTeamEMEquipEMPlan(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id, @PathVariable("emplan_id") String emplan_id,EMPlanDetailSearchContext context) {
        context.setN_planid_eq(emplan_id);
        Page<EMPlanDetail> domains = emplandetailService.searchDefault(context) ;
        List<EMPlanDetailDTO> list = emplandetailMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMPlanDetail-Default-all')")
	@ApiOperation(value = "searchDEFAULTByPFTeamEMEquipEMPlan", tags = {"EMPlanDetail" } ,notes = "searchDEFAULTByPFTeamEMEquipEMPlan")
    @RequestMapping(method= RequestMethod.POST , value="/pfteams/{pfteam_id}/emequips/{emequip_id}/emplans/{emplan_id}/emplandetails/searchdefault")
	public ResponseEntity<Page<EMPlanDetailDTO>> searchEMPlanDetailDefaultByPFTeamEMEquipEMPlan(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id, @PathVariable("emplan_id") String emplan_id, @RequestBody EMPlanDetailSearchContext context) {
        context.setN_planid_eq(emplan_id);
        Page<EMPlanDetail> domains = emplandetailService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emplandetailMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
    @PreAuthorize("hasPermission(#emplandetail_id,'Get',{'Sql',this.emplandetailMapping,this.permissionDTO})")
    @ApiOperation(value = "GetByEMACClassEMPlanTemplEMPlan", tags = {"EMPlanDetail" },  notes = "GetByEMACClassEMPlanTemplEMPlan")
	@RequestMapping(method = RequestMethod.GET, value = "/emacclasses/{emacclass_id}/emplantempls/{emplantempl_id}/emplans/{emplan_id}/emplandetails/{emplandetail_id}")
    public ResponseEntity<EMPlanDetailDTO> getByEMACClassEMPlanTemplEMPlan(@PathVariable("emacclass_id") String emacclass_id, @PathVariable("emplantempl_id") String emplantempl_id, @PathVariable("emplan_id") String emplan_id, @PathVariable("emplandetail_id") String emplandetail_id) {
        EMPlanDetail domain = emplandetailService.get(emplandetail_id);
        EMPlanDetailDTO dto = emplandetailMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMPlanDetail-GetDraft-all')")
    @ApiOperation(value = "GetDraftByEMACClassEMPlanTemplEMPlan", tags = {"EMPlanDetail" },  notes = "GetDraftByEMACClassEMPlanTemplEMPlan")
    @RequestMapping(method = RequestMethod.GET, value = "/emacclasses/{emacclass_id}/emplantempls/{emplantempl_id}/emplans/{emplan_id}/emplandetails/getdraft")
    public ResponseEntity<EMPlanDetailDTO> getDraftByEMACClassEMPlanTemplEMPlan(@PathVariable("emacclass_id") String emacclass_id, @PathVariable("emplantempl_id") String emplantempl_id, @PathVariable("emplan_id") String emplan_id) {
        EMPlanDetail domain = new EMPlanDetail();
        domain.setPlanid(emplan_id);
        return ResponseEntity.status(HttpStatus.OK).body(emplandetailMapping.toDto(emplandetailService.getDraft(domain)));
    }

    @PreAuthorize("hasPermission('','Save',{'Sql',this.emplandetailMapping,#emplandetaildto})")
    @ApiOperation(value = "SaveByEMACClassEMPlanTemplEMPlan", tags = {"EMPlanDetail" },  notes = "SaveByEMACClassEMPlanTemplEMPlan")
	@RequestMapping(method = RequestMethod.POST, value = "/emacclasses/{emacclass_id}/emplantempls/{emplantempl_id}/emplans/{emplan_id}/emplandetails/save")
    public ResponseEntity<Boolean> saveByEMACClassEMPlanTemplEMPlan(@PathVariable("emacclass_id") String emacclass_id, @PathVariable("emplantempl_id") String emplantempl_id, @PathVariable("emplan_id") String emplan_id, @RequestBody EMPlanDetailDTO emplandetaildto) {
        EMPlanDetail domain = emplandetailMapping.toDomain(emplandetaildto);
        domain.setPlanid(emplan_id);
        return ResponseEntity.status(HttpStatus.OK).body(emplandetailService.save(domain));
    }

    @PreAuthorize("hasPermission('Save',{'Sql',this.emplandetailMapping,#emplandetaildtos})")
    @ApiOperation(value = "SaveBatchByEMACClassEMPlanTemplEMPlan", tags = {"EMPlanDetail" },  notes = "SaveBatchByEMACClassEMPlanTemplEMPlan")
	@RequestMapping(method = RequestMethod.POST, value = "/emacclasses/{emacclass_id}/emplantempls/{emplantempl_id}/emplans/{emplan_id}/emplandetails/savebatch")
    public ResponseEntity<Boolean> saveBatchByEMACClassEMPlanTemplEMPlan(@PathVariable("emacclass_id") String emacclass_id, @PathVariable("emplantempl_id") String emplantempl_id, @PathVariable("emplan_id") String emplan_id, @RequestBody List<EMPlanDetailDTO> emplandetaildtos) {
        List<EMPlanDetail> domainlist=emplandetailMapping.toDomain(emplandetaildtos);
        for(EMPlanDetail domain:domainlist){
             domain.setPlanid(emplan_id);
        }
        emplandetailService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(#emplandetail_id,'Update',{'Sql',this.emplandetailMapping,#emplandetaildto})")
    @ApiOperation(value = "UpdateByEMACClassEMPlanTemplEMPlan", tags = {"EMPlanDetail" },  notes = "UpdateByEMACClassEMPlanTemplEMPlan")
	@RequestMapping(method = RequestMethod.PUT, value = "/emacclasses/{emacclass_id}/emplantempls/{emplantempl_id}/emplans/{emplan_id}/emplandetails/{emplandetail_id}")
    @Transactional
    public ResponseEntity<EMPlanDetailDTO> updateByEMACClassEMPlanTemplEMPlan(@PathVariable("emacclass_id") String emacclass_id, @PathVariable("emplantempl_id") String emplantempl_id, @PathVariable("emplan_id") String emplan_id, @PathVariable("emplandetail_id") String emplandetail_id, @RequestBody EMPlanDetailDTO emplandetaildto) {
        EMPlanDetail domain = emplandetailMapping.toDomain(emplandetaildto);
        domain.setPlanid(emplan_id);
        domain.setEmplandetailid(emplandetail_id);
		emplandetailService.update(domain);
        EMPlanDetailDTO dto = emplandetailMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Update',{'Sql',this.emplandetailMapping,#emplandetaildtos})")
    @ApiOperation(value = "UpdateBatchByEMACClassEMPlanTemplEMPlan", tags = {"EMPlanDetail" },  notes = "UpdateBatchByEMACClassEMPlanTemplEMPlan")
	@RequestMapping(method = RequestMethod.PUT, value = "/emacclasses/{emacclass_id}/emplantempls/{emplantempl_id}/emplans/{emplan_id}/emplandetails/batch")
    public ResponseEntity<Boolean> updateBatchByEMACClassEMPlanTemplEMPlan(@PathVariable("emacclass_id") String emacclass_id, @PathVariable("emplantempl_id") String emplantempl_id, @PathVariable("emplan_id") String emplan_id, @RequestBody List<EMPlanDetailDTO> emplandetaildtos) {
        List<EMPlanDetail> domainlist=emplandetailMapping.toDomain(emplandetaildtos);
        for(EMPlanDetail domain:domainlist){
            domain.setPlanid(emplan_id);
        }
        emplandetailService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission('','Create',{'Sql',this.emplandetailMapping,#emplandetaildto})")
    @ApiOperation(value = "CreateByEMACClassEMPlanTemplEMPlan", tags = {"EMPlanDetail" },  notes = "CreateByEMACClassEMPlanTemplEMPlan")
	@RequestMapping(method = RequestMethod.POST, value = "/emacclasses/{emacclass_id}/emplantempls/{emplantempl_id}/emplans/{emplan_id}/emplandetails")
    @Transactional
    public ResponseEntity<EMPlanDetailDTO> createByEMACClassEMPlanTemplEMPlan(@PathVariable("emacclass_id") String emacclass_id, @PathVariable("emplantempl_id") String emplantempl_id, @PathVariable("emplan_id") String emplan_id, @RequestBody EMPlanDetailDTO emplandetaildto) {
        EMPlanDetail domain = emplandetailMapping.toDomain(emplandetaildto);
        domain.setPlanid(emplan_id);
		emplandetailService.create(domain);
        EMPlanDetailDTO dto = emplandetailMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Create',{'Sql',this.emplandetailMapping,#emplandetaildtos})")
    @ApiOperation(value = "createBatchByEMACClassEMPlanTemplEMPlan", tags = {"EMPlanDetail" },  notes = "createBatchByEMACClassEMPlanTemplEMPlan")
	@RequestMapping(method = RequestMethod.POST, value = "/emacclasses/{emacclass_id}/emplantempls/{emplantempl_id}/emplans/{emplan_id}/emplandetails/batch")
    public ResponseEntity<Boolean> createBatchByEMACClassEMPlanTemplEMPlan(@PathVariable("emacclass_id") String emacclass_id, @PathVariable("emplantempl_id") String emplantempl_id, @PathVariable("emplan_id") String emplan_id, @RequestBody List<EMPlanDetailDTO> emplandetaildtos) {
        List<EMPlanDetail> domainlist=emplandetailMapping.toDomain(emplandetaildtos);
        for(EMPlanDetail domain:domainlist){
            domain.setPlanid(emplan_id);
        }
        emplandetailService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMPlanDetail-CheckKey-all')")
    @ApiOperation(value = "CheckKeyByEMACClassEMPlanTemplEMPlan", tags = {"EMPlanDetail" },  notes = "CheckKeyByEMACClassEMPlanTemplEMPlan")
	@RequestMapping(method = RequestMethod.POST, value = "/emacclasses/{emacclass_id}/emplantempls/{emplantempl_id}/emplans/{emplan_id}/emplandetails/checkkey")
    public ResponseEntity<Boolean> checkKeyByEMACClassEMPlanTemplEMPlan(@PathVariable("emacclass_id") String emacclass_id, @PathVariable("emplantempl_id") String emplantempl_id, @PathVariable("emplan_id") String emplan_id, @RequestBody EMPlanDetailDTO emplandetaildto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emplandetailService.checkKey(emplandetailMapping.toDomain(emplandetaildto)));
    }

    @PreAuthorize("hasPermission(#emplandetail_id,'Remove',{'Sql',this.emplandetailMapping,this.permissionDTO})")
    @ApiOperation(value = "RemoveByEMACClassEMPlanTemplEMPlan", tags = {"EMPlanDetail" },  notes = "RemoveByEMACClassEMPlanTemplEMPlan")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emacclasses/{emacclass_id}/emplantempls/{emplantempl_id}/emplans/{emplan_id}/emplandetails/{emplandetail_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByEMACClassEMPlanTemplEMPlan(@PathVariable("emacclass_id") String emacclass_id, @PathVariable("emplantempl_id") String emplantempl_id, @PathVariable("emplan_id") String emplan_id, @PathVariable("emplandetail_id") String emplandetail_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emplandetailService.remove(emplandetail_id));
    }

    @PreAuthorize("hasPermission('Remove',{'Sql',this.emplandetailMapping,this.permissionDTO,#ids})")
    @ApiOperation(value = "RemoveBatchByEMACClassEMPlanTemplEMPlan", tags = {"EMPlanDetail" },  notes = "RemoveBatchByEMACClassEMPlanTemplEMPlan")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emacclasses/{emacclass_id}/emplantempls/{emplantempl_id}/emplans/{emplan_id}/emplandetails/batch")
    public ResponseEntity<Boolean> removeBatchByEMACClassEMPlanTemplEMPlan(@RequestBody List<String> ids) {
        emplandetailService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMPlanDetail-Default-all')")
	@ApiOperation(value = "fetchDEFAULTByEMACClassEMPlanTemplEMPlan", tags = {"EMPlanDetail" } ,notes = "fetchDEFAULTByEMACClassEMPlanTemplEMPlan")
    @RequestMapping(method= RequestMethod.GET , value="/emacclasses/{emacclass_id}/emplantempls/{emplantempl_id}/emplans/{emplan_id}/emplandetails/fetchdefault")
	public ResponseEntity<List<EMPlanDetailDTO>> fetchEMPlanDetailDefaultByEMACClassEMPlanTemplEMPlan(@PathVariable("emacclass_id") String emacclass_id, @PathVariable("emplantempl_id") String emplantempl_id, @PathVariable("emplan_id") String emplan_id,EMPlanDetailSearchContext context) {
        context.setN_planid_eq(emplan_id);
        Page<EMPlanDetail> domains = emplandetailService.searchDefault(context) ;
        List<EMPlanDetailDTO> list = emplandetailMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMPlanDetail-Default-all')")
	@ApiOperation(value = "searchDEFAULTByEMACClassEMPlanTemplEMPlan", tags = {"EMPlanDetail" } ,notes = "searchDEFAULTByEMACClassEMPlanTemplEMPlan")
    @RequestMapping(method= RequestMethod.POST , value="/emacclasses/{emacclass_id}/emplantempls/{emplantempl_id}/emplans/{emplan_id}/emplandetails/searchdefault")
	public ResponseEntity<Page<EMPlanDetailDTO>> searchEMPlanDetailDefaultByEMACClassEMPlanTemplEMPlan(@PathVariable("emacclass_id") String emacclass_id, @PathVariable("emplantempl_id") String emplantempl_id, @PathVariable("emplan_id") String emplan_id, @RequestBody EMPlanDetailSearchContext context) {
        context.setN_planid_eq(emplan_id);
        Page<EMPlanDetail> domains = emplandetailService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emplandetailMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
    @PreAuthorize("hasPermission(#emplandetail_id,'Get',{'Sql',this.emplandetailMapping,this.permissionDTO})")
    @ApiOperation(value = "GetByEMServiceEMPlanTemplEMPlan", tags = {"EMPlanDetail" },  notes = "GetByEMServiceEMPlanTemplEMPlan")
	@RequestMapping(method = RequestMethod.GET, value = "/emservices/{emservice_id}/emplantempls/{emplantempl_id}/emplans/{emplan_id}/emplandetails/{emplandetail_id}")
    public ResponseEntity<EMPlanDetailDTO> getByEMServiceEMPlanTemplEMPlan(@PathVariable("emservice_id") String emservice_id, @PathVariable("emplantempl_id") String emplantempl_id, @PathVariable("emplan_id") String emplan_id, @PathVariable("emplandetail_id") String emplandetail_id) {
        EMPlanDetail domain = emplandetailService.get(emplandetail_id);
        EMPlanDetailDTO dto = emplandetailMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMPlanDetail-GetDraft-all')")
    @ApiOperation(value = "GetDraftByEMServiceEMPlanTemplEMPlan", tags = {"EMPlanDetail" },  notes = "GetDraftByEMServiceEMPlanTemplEMPlan")
    @RequestMapping(method = RequestMethod.GET, value = "/emservices/{emservice_id}/emplantempls/{emplantempl_id}/emplans/{emplan_id}/emplandetails/getdraft")
    public ResponseEntity<EMPlanDetailDTO> getDraftByEMServiceEMPlanTemplEMPlan(@PathVariable("emservice_id") String emservice_id, @PathVariable("emplantempl_id") String emplantempl_id, @PathVariable("emplan_id") String emplan_id) {
        EMPlanDetail domain = new EMPlanDetail();
        domain.setPlanid(emplan_id);
        return ResponseEntity.status(HttpStatus.OK).body(emplandetailMapping.toDto(emplandetailService.getDraft(domain)));
    }

    @PreAuthorize("hasPermission('','Save',{'Sql',this.emplandetailMapping,#emplandetaildto})")
    @ApiOperation(value = "SaveByEMServiceEMPlanTemplEMPlan", tags = {"EMPlanDetail" },  notes = "SaveByEMServiceEMPlanTemplEMPlan")
	@RequestMapping(method = RequestMethod.POST, value = "/emservices/{emservice_id}/emplantempls/{emplantempl_id}/emplans/{emplan_id}/emplandetails/save")
    public ResponseEntity<Boolean> saveByEMServiceEMPlanTemplEMPlan(@PathVariable("emservice_id") String emservice_id, @PathVariable("emplantempl_id") String emplantempl_id, @PathVariable("emplan_id") String emplan_id, @RequestBody EMPlanDetailDTO emplandetaildto) {
        EMPlanDetail domain = emplandetailMapping.toDomain(emplandetaildto);
        domain.setPlanid(emplan_id);
        return ResponseEntity.status(HttpStatus.OK).body(emplandetailService.save(domain));
    }

    @PreAuthorize("hasPermission('Save',{'Sql',this.emplandetailMapping,#emplandetaildtos})")
    @ApiOperation(value = "SaveBatchByEMServiceEMPlanTemplEMPlan", tags = {"EMPlanDetail" },  notes = "SaveBatchByEMServiceEMPlanTemplEMPlan")
	@RequestMapping(method = RequestMethod.POST, value = "/emservices/{emservice_id}/emplantempls/{emplantempl_id}/emplans/{emplan_id}/emplandetails/savebatch")
    public ResponseEntity<Boolean> saveBatchByEMServiceEMPlanTemplEMPlan(@PathVariable("emservice_id") String emservice_id, @PathVariable("emplantempl_id") String emplantempl_id, @PathVariable("emplan_id") String emplan_id, @RequestBody List<EMPlanDetailDTO> emplandetaildtos) {
        List<EMPlanDetail> domainlist=emplandetailMapping.toDomain(emplandetaildtos);
        for(EMPlanDetail domain:domainlist){
             domain.setPlanid(emplan_id);
        }
        emplandetailService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(#emplandetail_id,'Update',{'Sql',this.emplandetailMapping,#emplandetaildto})")
    @ApiOperation(value = "UpdateByEMServiceEMPlanTemplEMPlan", tags = {"EMPlanDetail" },  notes = "UpdateByEMServiceEMPlanTemplEMPlan")
	@RequestMapping(method = RequestMethod.PUT, value = "/emservices/{emservice_id}/emplantempls/{emplantempl_id}/emplans/{emplan_id}/emplandetails/{emplandetail_id}")
    @Transactional
    public ResponseEntity<EMPlanDetailDTO> updateByEMServiceEMPlanTemplEMPlan(@PathVariable("emservice_id") String emservice_id, @PathVariable("emplantempl_id") String emplantempl_id, @PathVariable("emplan_id") String emplan_id, @PathVariable("emplandetail_id") String emplandetail_id, @RequestBody EMPlanDetailDTO emplandetaildto) {
        EMPlanDetail domain = emplandetailMapping.toDomain(emplandetaildto);
        domain.setPlanid(emplan_id);
        domain.setEmplandetailid(emplandetail_id);
		emplandetailService.update(domain);
        EMPlanDetailDTO dto = emplandetailMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Update',{'Sql',this.emplandetailMapping,#emplandetaildtos})")
    @ApiOperation(value = "UpdateBatchByEMServiceEMPlanTemplEMPlan", tags = {"EMPlanDetail" },  notes = "UpdateBatchByEMServiceEMPlanTemplEMPlan")
	@RequestMapping(method = RequestMethod.PUT, value = "/emservices/{emservice_id}/emplantempls/{emplantempl_id}/emplans/{emplan_id}/emplandetails/batch")
    public ResponseEntity<Boolean> updateBatchByEMServiceEMPlanTemplEMPlan(@PathVariable("emservice_id") String emservice_id, @PathVariable("emplantempl_id") String emplantempl_id, @PathVariable("emplan_id") String emplan_id, @RequestBody List<EMPlanDetailDTO> emplandetaildtos) {
        List<EMPlanDetail> domainlist=emplandetailMapping.toDomain(emplandetaildtos);
        for(EMPlanDetail domain:domainlist){
            domain.setPlanid(emplan_id);
        }
        emplandetailService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission('','Create',{'Sql',this.emplandetailMapping,#emplandetaildto})")
    @ApiOperation(value = "CreateByEMServiceEMPlanTemplEMPlan", tags = {"EMPlanDetail" },  notes = "CreateByEMServiceEMPlanTemplEMPlan")
	@RequestMapping(method = RequestMethod.POST, value = "/emservices/{emservice_id}/emplantempls/{emplantempl_id}/emplans/{emplan_id}/emplandetails")
    @Transactional
    public ResponseEntity<EMPlanDetailDTO> createByEMServiceEMPlanTemplEMPlan(@PathVariable("emservice_id") String emservice_id, @PathVariable("emplantempl_id") String emplantempl_id, @PathVariable("emplan_id") String emplan_id, @RequestBody EMPlanDetailDTO emplandetaildto) {
        EMPlanDetail domain = emplandetailMapping.toDomain(emplandetaildto);
        domain.setPlanid(emplan_id);
		emplandetailService.create(domain);
        EMPlanDetailDTO dto = emplandetailMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Create',{'Sql',this.emplandetailMapping,#emplandetaildtos})")
    @ApiOperation(value = "createBatchByEMServiceEMPlanTemplEMPlan", tags = {"EMPlanDetail" },  notes = "createBatchByEMServiceEMPlanTemplEMPlan")
	@RequestMapping(method = RequestMethod.POST, value = "/emservices/{emservice_id}/emplantempls/{emplantempl_id}/emplans/{emplan_id}/emplandetails/batch")
    public ResponseEntity<Boolean> createBatchByEMServiceEMPlanTemplEMPlan(@PathVariable("emservice_id") String emservice_id, @PathVariable("emplantempl_id") String emplantempl_id, @PathVariable("emplan_id") String emplan_id, @RequestBody List<EMPlanDetailDTO> emplandetaildtos) {
        List<EMPlanDetail> domainlist=emplandetailMapping.toDomain(emplandetaildtos);
        for(EMPlanDetail domain:domainlist){
            domain.setPlanid(emplan_id);
        }
        emplandetailService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMPlanDetail-CheckKey-all')")
    @ApiOperation(value = "CheckKeyByEMServiceEMPlanTemplEMPlan", tags = {"EMPlanDetail" },  notes = "CheckKeyByEMServiceEMPlanTemplEMPlan")
	@RequestMapping(method = RequestMethod.POST, value = "/emservices/{emservice_id}/emplantempls/{emplantempl_id}/emplans/{emplan_id}/emplandetails/checkkey")
    public ResponseEntity<Boolean> checkKeyByEMServiceEMPlanTemplEMPlan(@PathVariable("emservice_id") String emservice_id, @PathVariable("emplantempl_id") String emplantempl_id, @PathVariable("emplan_id") String emplan_id, @RequestBody EMPlanDetailDTO emplandetaildto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emplandetailService.checkKey(emplandetailMapping.toDomain(emplandetaildto)));
    }

    @PreAuthorize("hasPermission(#emplandetail_id,'Remove',{'Sql',this.emplandetailMapping,this.permissionDTO})")
    @ApiOperation(value = "RemoveByEMServiceEMPlanTemplEMPlan", tags = {"EMPlanDetail" },  notes = "RemoveByEMServiceEMPlanTemplEMPlan")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emservices/{emservice_id}/emplantempls/{emplantempl_id}/emplans/{emplan_id}/emplandetails/{emplandetail_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByEMServiceEMPlanTemplEMPlan(@PathVariable("emservice_id") String emservice_id, @PathVariable("emplantempl_id") String emplantempl_id, @PathVariable("emplan_id") String emplan_id, @PathVariable("emplandetail_id") String emplandetail_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emplandetailService.remove(emplandetail_id));
    }

    @PreAuthorize("hasPermission('Remove',{'Sql',this.emplandetailMapping,this.permissionDTO,#ids})")
    @ApiOperation(value = "RemoveBatchByEMServiceEMPlanTemplEMPlan", tags = {"EMPlanDetail" },  notes = "RemoveBatchByEMServiceEMPlanTemplEMPlan")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emservices/{emservice_id}/emplantempls/{emplantempl_id}/emplans/{emplan_id}/emplandetails/batch")
    public ResponseEntity<Boolean> removeBatchByEMServiceEMPlanTemplEMPlan(@RequestBody List<String> ids) {
        emplandetailService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMPlanDetail-Default-all')")
	@ApiOperation(value = "fetchDEFAULTByEMServiceEMPlanTemplEMPlan", tags = {"EMPlanDetail" } ,notes = "fetchDEFAULTByEMServiceEMPlanTemplEMPlan")
    @RequestMapping(method= RequestMethod.GET , value="/emservices/{emservice_id}/emplantempls/{emplantempl_id}/emplans/{emplan_id}/emplandetails/fetchdefault")
	public ResponseEntity<List<EMPlanDetailDTO>> fetchEMPlanDetailDefaultByEMServiceEMPlanTemplEMPlan(@PathVariable("emservice_id") String emservice_id, @PathVariable("emplantempl_id") String emplantempl_id, @PathVariable("emplan_id") String emplan_id,EMPlanDetailSearchContext context) {
        context.setN_planid_eq(emplan_id);
        Page<EMPlanDetail> domains = emplandetailService.searchDefault(context) ;
        List<EMPlanDetailDTO> list = emplandetailMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMPlanDetail-Default-all')")
	@ApiOperation(value = "searchDEFAULTByEMServiceEMPlanTemplEMPlan", tags = {"EMPlanDetail" } ,notes = "searchDEFAULTByEMServiceEMPlanTemplEMPlan")
    @RequestMapping(method= RequestMethod.POST , value="/emservices/{emservice_id}/emplantempls/{emplantempl_id}/emplans/{emplan_id}/emplandetails/searchdefault")
	public ResponseEntity<Page<EMPlanDetailDTO>> searchEMPlanDetailDefaultByEMServiceEMPlanTemplEMPlan(@PathVariable("emservice_id") String emservice_id, @PathVariable("emplantempl_id") String emplantempl_id, @PathVariable("emplan_id") String emplan_id, @RequestBody EMPlanDetailSearchContext context) {
        context.setN_planid_eq(emplan_id);
        Page<EMPlanDetail> domains = emplandetailService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emplandetailMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
    @PreAuthorize("hasPermission(#emplandetail_id,'Get',{'Sql',this.emplandetailMapping,this.permissionDTO})")
    @ApiOperation(value = "GetByPFDeptEMPlanTemplEMPlan", tags = {"EMPlanDetail" },  notes = "GetByPFDeptEMPlanTemplEMPlan")
	@RequestMapping(method = RequestMethod.GET, value = "/pfdepts/{pfdept_id}/emplantempls/{emplantempl_id}/emplans/{emplan_id}/emplandetails/{emplandetail_id}")
    public ResponseEntity<EMPlanDetailDTO> getByPFDeptEMPlanTemplEMPlan(@PathVariable("pfdept_id") String pfdept_id, @PathVariable("emplantempl_id") String emplantempl_id, @PathVariable("emplan_id") String emplan_id, @PathVariable("emplandetail_id") String emplandetail_id) {
        EMPlanDetail domain = emplandetailService.get(emplandetail_id);
        EMPlanDetailDTO dto = emplandetailMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMPlanDetail-GetDraft-all')")
    @ApiOperation(value = "GetDraftByPFDeptEMPlanTemplEMPlan", tags = {"EMPlanDetail" },  notes = "GetDraftByPFDeptEMPlanTemplEMPlan")
    @RequestMapping(method = RequestMethod.GET, value = "/pfdepts/{pfdept_id}/emplantempls/{emplantempl_id}/emplans/{emplan_id}/emplandetails/getdraft")
    public ResponseEntity<EMPlanDetailDTO> getDraftByPFDeptEMPlanTemplEMPlan(@PathVariable("pfdept_id") String pfdept_id, @PathVariable("emplantempl_id") String emplantempl_id, @PathVariable("emplan_id") String emplan_id) {
        EMPlanDetail domain = new EMPlanDetail();
        domain.setPlanid(emplan_id);
        return ResponseEntity.status(HttpStatus.OK).body(emplandetailMapping.toDto(emplandetailService.getDraft(domain)));
    }

    @PreAuthorize("hasPermission('','Save',{'Sql',this.emplandetailMapping,#emplandetaildto})")
    @ApiOperation(value = "SaveByPFDeptEMPlanTemplEMPlan", tags = {"EMPlanDetail" },  notes = "SaveByPFDeptEMPlanTemplEMPlan")
	@RequestMapping(method = RequestMethod.POST, value = "/pfdepts/{pfdept_id}/emplantempls/{emplantempl_id}/emplans/{emplan_id}/emplandetails/save")
    public ResponseEntity<Boolean> saveByPFDeptEMPlanTemplEMPlan(@PathVariable("pfdept_id") String pfdept_id, @PathVariable("emplantempl_id") String emplantempl_id, @PathVariable("emplan_id") String emplan_id, @RequestBody EMPlanDetailDTO emplandetaildto) {
        EMPlanDetail domain = emplandetailMapping.toDomain(emplandetaildto);
        domain.setPlanid(emplan_id);
        return ResponseEntity.status(HttpStatus.OK).body(emplandetailService.save(domain));
    }

    @PreAuthorize("hasPermission('Save',{'Sql',this.emplandetailMapping,#emplandetaildtos})")
    @ApiOperation(value = "SaveBatchByPFDeptEMPlanTemplEMPlan", tags = {"EMPlanDetail" },  notes = "SaveBatchByPFDeptEMPlanTemplEMPlan")
	@RequestMapping(method = RequestMethod.POST, value = "/pfdepts/{pfdept_id}/emplantempls/{emplantempl_id}/emplans/{emplan_id}/emplandetails/savebatch")
    public ResponseEntity<Boolean> saveBatchByPFDeptEMPlanTemplEMPlan(@PathVariable("pfdept_id") String pfdept_id, @PathVariable("emplantempl_id") String emplantempl_id, @PathVariable("emplan_id") String emplan_id, @RequestBody List<EMPlanDetailDTO> emplandetaildtos) {
        List<EMPlanDetail> domainlist=emplandetailMapping.toDomain(emplandetaildtos);
        for(EMPlanDetail domain:domainlist){
             domain.setPlanid(emplan_id);
        }
        emplandetailService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(#emplandetail_id,'Update',{'Sql',this.emplandetailMapping,#emplandetaildto})")
    @ApiOperation(value = "UpdateByPFDeptEMPlanTemplEMPlan", tags = {"EMPlanDetail" },  notes = "UpdateByPFDeptEMPlanTemplEMPlan")
	@RequestMapping(method = RequestMethod.PUT, value = "/pfdepts/{pfdept_id}/emplantempls/{emplantempl_id}/emplans/{emplan_id}/emplandetails/{emplandetail_id}")
    @Transactional
    public ResponseEntity<EMPlanDetailDTO> updateByPFDeptEMPlanTemplEMPlan(@PathVariable("pfdept_id") String pfdept_id, @PathVariable("emplantempl_id") String emplantempl_id, @PathVariable("emplan_id") String emplan_id, @PathVariable("emplandetail_id") String emplandetail_id, @RequestBody EMPlanDetailDTO emplandetaildto) {
        EMPlanDetail domain = emplandetailMapping.toDomain(emplandetaildto);
        domain.setPlanid(emplan_id);
        domain.setEmplandetailid(emplandetail_id);
		emplandetailService.update(domain);
        EMPlanDetailDTO dto = emplandetailMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Update',{'Sql',this.emplandetailMapping,#emplandetaildtos})")
    @ApiOperation(value = "UpdateBatchByPFDeptEMPlanTemplEMPlan", tags = {"EMPlanDetail" },  notes = "UpdateBatchByPFDeptEMPlanTemplEMPlan")
	@RequestMapping(method = RequestMethod.PUT, value = "/pfdepts/{pfdept_id}/emplantempls/{emplantempl_id}/emplans/{emplan_id}/emplandetails/batch")
    public ResponseEntity<Boolean> updateBatchByPFDeptEMPlanTemplEMPlan(@PathVariable("pfdept_id") String pfdept_id, @PathVariable("emplantempl_id") String emplantempl_id, @PathVariable("emplan_id") String emplan_id, @RequestBody List<EMPlanDetailDTO> emplandetaildtos) {
        List<EMPlanDetail> domainlist=emplandetailMapping.toDomain(emplandetaildtos);
        for(EMPlanDetail domain:domainlist){
            domain.setPlanid(emplan_id);
        }
        emplandetailService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission('','Create',{'Sql',this.emplandetailMapping,#emplandetaildto})")
    @ApiOperation(value = "CreateByPFDeptEMPlanTemplEMPlan", tags = {"EMPlanDetail" },  notes = "CreateByPFDeptEMPlanTemplEMPlan")
	@RequestMapping(method = RequestMethod.POST, value = "/pfdepts/{pfdept_id}/emplantempls/{emplantempl_id}/emplans/{emplan_id}/emplandetails")
    @Transactional
    public ResponseEntity<EMPlanDetailDTO> createByPFDeptEMPlanTemplEMPlan(@PathVariable("pfdept_id") String pfdept_id, @PathVariable("emplantempl_id") String emplantempl_id, @PathVariable("emplan_id") String emplan_id, @RequestBody EMPlanDetailDTO emplandetaildto) {
        EMPlanDetail domain = emplandetailMapping.toDomain(emplandetaildto);
        domain.setPlanid(emplan_id);
		emplandetailService.create(domain);
        EMPlanDetailDTO dto = emplandetailMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Create',{'Sql',this.emplandetailMapping,#emplandetaildtos})")
    @ApiOperation(value = "createBatchByPFDeptEMPlanTemplEMPlan", tags = {"EMPlanDetail" },  notes = "createBatchByPFDeptEMPlanTemplEMPlan")
	@RequestMapping(method = RequestMethod.POST, value = "/pfdepts/{pfdept_id}/emplantempls/{emplantempl_id}/emplans/{emplan_id}/emplandetails/batch")
    public ResponseEntity<Boolean> createBatchByPFDeptEMPlanTemplEMPlan(@PathVariable("pfdept_id") String pfdept_id, @PathVariable("emplantempl_id") String emplantempl_id, @PathVariable("emplan_id") String emplan_id, @RequestBody List<EMPlanDetailDTO> emplandetaildtos) {
        List<EMPlanDetail> domainlist=emplandetailMapping.toDomain(emplandetaildtos);
        for(EMPlanDetail domain:domainlist){
            domain.setPlanid(emplan_id);
        }
        emplandetailService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMPlanDetail-CheckKey-all')")
    @ApiOperation(value = "CheckKeyByPFDeptEMPlanTemplEMPlan", tags = {"EMPlanDetail" },  notes = "CheckKeyByPFDeptEMPlanTemplEMPlan")
	@RequestMapping(method = RequestMethod.POST, value = "/pfdepts/{pfdept_id}/emplantempls/{emplantempl_id}/emplans/{emplan_id}/emplandetails/checkkey")
    public ResponseEntity<Boolean> checkKeyByPFDeptEMPlanTemplEMPlan(@PathVariable("pfdept_id") String pfdept_id, @PathVariable("emplantempl_id") String emplantempl_id, @PathVariable("emplan_id") String emplan_id, @RequestBody EMPlanDetailDTO emplandetaildto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emplandetailService.checkKey(emplandetailMapping.toDomain(emplandetaildto)));
    }

    @PreAuthorize("hasPermission(#emplandetail_id,'Remove',{'Sql',this.emplandetailMapping,this.permissionDTO})")
    @ApiOperation(value = "RemoveByPFDeptEMPlanTemplEMPlan", tags = {"EMPlanDetail" },  notes = "RemoveByPFDeptEMPlanTemplEMPlan")
	@RequestMapping(method = RequestMethod.DELETE, value = "/pfdepts/{pfdept_id}/emplantempls/{emplantempl_id}/emplans/{emplan_id}/emplandetails/{emplandetail_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByPFDeptEMPlanTemplEMPlan(@PathVariable("pfdept_id") String pfdept_id, @PathVariable("emplantempl_id") String emplantempl_id, @PathVariable("emplan_id") String emplan_id, @PathVariable("emplandetail_id") String emplandetail_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emplandetailService.remove(emplandetail_id));
    }

    @PreAuthorize("hasPermission('Remove',{'Sql',this.emplandetailMapping,this.permissionDTO,#ids})")
    @ApiOperation(value = "RemoveBatchByPFDeptEMPlanTemplEMPlan", tags = {"EMPlanDetail" },  notes = "RemoveBatchByPFDeptEMPlanTemplEMPlan")
	@RequestMapping(method = RequestMethod.DELETE, value = "/pfdepts/{pfdept_id}/emplantempls/{emplantempl_id}/emplans/{emplan_id}/emplandetails/batch")
    public ResponseEntity<Boolean> removeBatchByPFDeptEMPlanTemplEMPlan(@RequestBody List<String> ids) {
        emplandetailService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMPlanDetail-Default-all')")
	@ApiOperation(value = "fetchDEFAULTByPFDeptEMPlanTemplEMPlan", tags = {"EMPlanDetail" } ,notes = "fetchDEFAULTByPFDeptEMPlanTemplEMPlan")
    @RequestMapping(method= RequestMethod.GET , value="/pfdepts/{pfdept_id}/emplantempls/{emplantempl_id}/emplans/{emplan_id}/emplandetails/fetchdefault")
	public ResponseEntity<List<EMPlanDetailDTO>> fetchEMPlanDetailDefaultByPFDeptEMPlanTemplEMPlan(@PathVariable("pfdept_id") String pfdept_id, @PathVariable("emplantempl_id") String emplantempl_id, @PathVariable("emplan_id") String emplan_id,EMPlanDetailSearchContext context) {
        context.setN_planid_eq(emplan_id);
        Page<EMPlanDetail> domains = emplandetailService.searchDefault(context) ;
        List<EMPlanDetailDTO> list = emplandetailMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMPlanDetail-Default-all')")
	@ApiOperation(value = "searchDEFAULTByPFDeptEMPlanTemplEMPlan", tags = {"EMPlanDetail" } ,notes = "searchDEFAULTByPFDeptEMPlanTemplEMPlan")
    @RequestMapping(method= RequestMethod.POST , value="/pfdepts/{pfdept_id}/emplantempls/{emplantempl_id}/emplans/{emplan_id}/emplandetails/searchdefault")
	public ResponseEntity<Page<EMPlanDetailDTO>> searchEMPlanDetailDefaultByPFDeptEMPlanTemplEMPlan(@PathVariable("pfdept_id") String pfdept_id, @PathVariable("emplantempl_id") String emplantempl_id, @PathVariable("emplan_id") String emplan_id, @RequestBody EMPlanDetailSearchContext context) {
        context.setN_planid_eq(emplan_id);
        Page<EMPlanDetail> domains = emplandetailService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emplandetailMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
    @PreAuthorize("hasPermission(#emplandetail_id,'Get',{'Sql',this.emplandetailMapping,this.permissionDTO})")
    @ApiOperation(value = "GetByPFEmpEMPlanTemplEMPlan", tags = {"EMPlanDetail" },  notes = "GetByPFEmpEMPlanTemplEMPlan")
	@RequestMapping(method = RequestMethod.GET, value = "/pfemps/{pfemp_id}/emplantempls/{emplantempl_id}/emplans/{emplan_id}/emplandetails/{emplandetail_id}")
    public ResponseEntity<EMPlanDetailDTO> getByPFEmpEMPlanTemplEMPlan(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emplantempl_id") String emplantempl_id, @PathVariable("emplan_id") String emplan_id, @PathVariable("emplandetail_id") String emplandetail_id) {
        EMPlanDetail domain = emplandetailService.get(emplandetail_id);
        EMPlanDetailDTO dto = emplandetailMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMPlanDetail-GetDraft-all')")
    @ApiOperation(value = "GetDraftByPFEmpEMPlanTemplEMPlan", tags = {"EMPlanDetail" },  notes = "GetDraftByPFEmpEMPlanTemplEMPlan")
    @RequestMapping(method = RequestMethod.GET, value = "/pfemps/{pfemp_id}/emplantempls/{emplantempl_id}/emplans/{emplan_id}/emplandetails/getdraft")
    public ResponseEntity<EMPlanDetailDTO> getDraftByPFEmpEMPlanTemplEMPlan(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emplantempl_id") String emplantempl_id, @PathVariable("emplan_id") String emplan_id) {
        EMPlanDetail domain = new EMPlanDetail();
        domain.setPlanid(emplan_id);
        return ResponseEntity.status(HttpStatus.OK).body(emplandetailMapping.toDto(emplandetailService.getDraft(domain)));
    }

    @PreAuthorize("hasPermission('','Save',{'Sql',this.emplandetailMapping,#emplandetaildto})")
    @ApiOperation(value = "SaveByPFEmpEMPlanTemplEMPlan", tags = {"EMPlanDetail" },  notes = "SaveByPFEmpEMPlanTemplEMPlan")
	@RequestMapping(method = RequestMethod.POST, value = "/pfemps/{pfemp_id}/emplantempls/{emplantempl_id}/emplans/{emplan_id}/emplandetails/save")
    public ResponseEntity<Boolean> saveByPFEmpEMPlanTemplEMPlan(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emplantempl_id") String emplantempl_id, @PathVariable("emplan_id") String emplan_id, @RequestBody EMPlanDetailDTO emplandetaildto) {
        EMPlanDetail domain = emplandetailMapping.toDomain(emplandetaildto);
        domain.setPlanid(emplan_id);
        return ResponseEntity.status(HttpStatus.OK).body(emplandetailService.save(domain));
    }

    @PreAuthorize("hasPermission('Save',{'Sql',this.emplandetailMapping,#emplandetaildtos})")
    @ApiOperation(value = "SaveBatchByPFEmpEMPlanTemplEMPlan", tags = {"EMPlanDetail" },  notes = "SaveBatchByPFEmpEMPlanTemplEMPlan")
	@RequestMapping(method = RequestMethod.POST, value = "/pfemps/{pfemp_id}/emplantempls/{emplantempl_id}/emplans/{emplan_id}/emplandetails/savebatch")
    public ResponseEntity<Boolean> saveBatchByPFEmpEMPlanTemplEMPlan(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emplantempl_id") String emplantempl_id, @PathVariable("emplan_id") String emplan_id, @RequestBody List<EMPlanDetailDTO> emplandetaildtos) {
        List<EMPlanDetail> domainlist=emplandetailMapping.toDomain(emplandetaildtos);
        for(EMPlanDetail domain:domainlist){
             domain.setPlanid(emplan_id);
        }
        emplandetailService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(#emplandetail_id,'Update',{'Sql',this.emplandetailMapping,#emplandetaildto})")
    @ApiOperation(value = "UpdateByPFEmpEMPlanTemplEMPlan", tags = {"EMPlanDetail" },  notes = "UpdateByPFEmpEMPlanTemplEMPlan")
	@RequestMapping(method = RequestMethod.PUT, value = "/pfemps/{pfemp_id}/emplantempls/{emplantempl_id}/emplans/{emplan_id}/emplandetails/{emplandetail_id}")
    @Transactional
    public ResponseEntity<EMPlanDetailDTO> updateByPFEmpEMPlanTemplEMPlan(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emplantempl_id") String emplantempl_id, @PathVariable("emplan_id") String emplan_id, @PathVariable("emplandetail_id") String emplandetail_id, @RequestBody EMPlanDetailDTO emplandetaildto) {
        EMPlanDetail domain = emplandetailMapping.toDomain(emplandetaildto);
        domain.setPlanid(emplan_id);
        domain.setEmplandetailid(emplandetail_id);
		emplandetailService.update(domain);
        EMPlanDetailDTO dto = emplandetailMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Update',{'Sql',this.emplandetailMapping,#emplandetaildtos})")
    @ApiOperation(value = "UpdateBatchByPFEmpEMPlanTemplEMPlan", tags = {"EMPlanDetail" },  notes = "UpdateBatchByPFEmpEMPlanTemplEMPlan")
	@RequestMapping(method = RequestMethod.PUT, value = "/pfemps/{pfemp_id}/emplantempls/{emplantempl_id}/emplans/{emplan_id}/emplandetails/batch")
    public ResponseEntity<Boolean> updateBatchByPFEmpEMPlanTemplEMPlan(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emplantempl_id") String emplantempl_id, @PathVariable("emplan_id") String emplan_id, @RequestBody List<EMPlanDetailDTO> emplandetaildtos) {
        List<EMPlanDetail> domainlist=emplandetailMapping.toDomain(emplandetaildtos);
        for(EMPlanDetail domain:domainlist){
            domain.setPlanid(emplan_id);
        }
        emplandetailService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission('','Create',{'Sql',this.emplandetailMapping,#emplandetaildto})")
    @ApiOperation(value = "CreateByPFEmpEMPlanTemplEMPlan", tags = {"EMPlanDetail" },  notes = "CreateByPFEmpEMPlanTemplEMPlan")
	@RequestMapping(method = RequestMethod.POST, value = "/pfemps/{pfemp_id}/emplantempls/{emplantempl_id}/emplans/{emplan_id}/emplandetails")
    @Transactional
    public ResponseEntity<EMPlanDetailDTO> createByPFEmpEMPlanTemplEMPlan(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emplantempl_id") String emplantempl_id, @PathVariable("emplan_id") String emplan_id, @RequestBody EMPlanDetailDTO emplandetaildto) {
        EMPlanDetail domain = emplandetailMapping.toDomain(emplandetaildto);
        domain.setPlanid(emplan_id);
		emplandetailService.create(domain);
        EMPlanDetailDTO dto = emplandetailMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Create',{'Sql',this.emplandetailMapping,#emplandetaildtos})")
    @ApiOperation(value = "createBatchByPFEmpEMPlanTemplEMPlan", tags = {"EMPlanDetail" },  notes = "createBatchByPFEmpEMPlanTemplEMPlan")
	@RequestMapping(method = RequestMethod.POST, value = "/pfemps/{pfemp_id}/emplantempls/{emplantempl_id}/emplans/{emplan_id}/emplandetails/batch")
    public ResponseEntity<Boolean> createBatchByPFEmpEMPlanTemplEMPlan(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emplantempl_id") String emplantempl_id, @PathVariable("emplan_id") String emplan_id, @RequestBody List<EMPlanDetailDTO> emplandetaildtos) {
        List<EMPlanDetail> domainlist=emplandetailMapping.toDomain(emplandetaildtos);
        for(EMPlanDetail domain:domainlist){
            domain.setPlanid(emplan_id);
        }
        emplandetailService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMPlanDetail-CheckKey-all')")
    @ApiOperation(value = "CheckKeyByPFEmpEMPlanTemplEMPlan", tags = {"EMPlanDetail" },  notes = "CheckKeyByPFEmpEMPlanTemplEMPlan")
	@RequestMapping(method = RequestMethod.POST, value = "/pfemps/{pfemp_id}/emplantempls/{emplantempl_id}/emplans/{emplan_id}/emplandetails/checkkey")
    public ResponseEntity<Boolean> checkKeyByPFEmpEMPlanTemplEMPlan(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emplantempl_id") String emplantempl_id, @PathVariable("emplan_id") String emplan_id, @RequestBody EMPlanDetailDTO emplandetaildto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emplandetailService.checkKey(emplandetailMapping.toDomain(emplandetaildto)));
    }

    @PreAuthorize("hasPermission(#emplandetail_id,'Remove',{'Sql',this.emplandetailMapping,this.permissionDTO})")
    @ApiOperation(value = "RemoveByPFEmpEMPlanTemplEMPlan", tags = {"EMPlanDetail" },  notes = "RemoveByPFEmpEMPlanTemplEMPlan")
	@RequestMapping(method = RequestMethod.DELETE, value = "/pfemps/{pfemp_id}/emplantempls/{emplantempl_id}/emplans/{emplan_id}/emplandetails/{emplandetail_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByPFEmpEMPlanTemplEMPlan(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emplantempl_id") String emplantempl_id, @PathVariable("emplan_id") String emplan_id, @PathVariable("emplandetail_id") String emplandetail_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emplandetailService.remove(emplandetail_id));
    }

    @PreAuthorize("hasPermission('Remove',{'Sql',this.emplandetailMapping,this.permissionDTO,#ids})")
    @ApiOperation(value = "RemoveBatchByPFEmpEMPlanTemplEMPlan", tags = {"EMPlanDetail" },  notes = "RemoveBatchByPFEmpEMPlanTemplEMPlan")
	@RequestMapping(method = RequestMethod.DELETE, value = "/pfemps/{pfemp_id}/emplantempls/{emplantempl_id}/emplans/{emplan_id}/emplandetails/batch")
    public ResponseEntity<Boolean> removeBatchByPFEmpEMPlanTemplEMPlan(@RequestBody List<String> ids) {
        emplandetailService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMPlanDetail-Default-all')")
	@ApiOperation(value = "fetchDEFAULTByPFEmpEMPlanTemplEMPlan", tags = {"EMPlanDetail" } ,notes = "fetchDEFAULTByPFEmpEMPlanTemplEMPlan")
    @RequestMapping(method= RequestMethod.GET , value="/pfemps/{pfemp_id}/emplantempls/{emplantempl_id}/emplans/{emplan_id}/emplandetails/fetchdefault")
	public ResponseEntity<List<EMPlanDetailDTO>> fetchEMPlanDetailDefaultByPFEmpEMPlanTemplEMPlan(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emplantempl_id") String emplantempl_id, @PathVariable("emplan_id") String emplan_id,EMPlanDetailSearchContext context) {
        context.setN_planid_eq(emplan_id);
        Page<EMPlanDetail> domains = emplandetailService.searchDefault(context) ;
        List<EMPlanDetailDTO> list = emplandetailMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMPlanDetail-Default-all')")
	@ApiOperation(value = "searchDEFAULTByPFEmpEMPlanTemplEMPlan", tags = {"EMPlanDetail" } ,notes = "searchDEFAULTByPFEmpEMPlanTemplEMPlan")
    @RequestMapping(method= RequestMethod.POST , value="/pfemps/{pfemp_id}/emplantempls/{emplantempl_id}/emplans/{emplan_id}/emplandetails/searchdefault")
	public ResponseEntity<Page<EMPlanDetailDTO>> searchEMPlanDetailDefaultByPFEmpEMPlanTemplEMPlan(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emplantempl_id") String emplantempl_id, @PathVariable("emplan_id") String emplan_id, @RequestBody EMPlanDetailSearchContext context) {
        context.setN_planid_eq(emplan_id);
        Page<EMPlanDetail> domains = emplandetailService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emplandetailMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
    @PreAuthorize("hasPermission(#emplandetail_id,'Get',{'Sql',this.emplandetailMapping,this.permissionDTO})")
    @ApiOperation(value = "GetByPFTeamEMPlanTemplEMPlan", tags = {"EMPlanDetail" },  notes = "GetByPFTeamEMPlanTemplEMPlan")
	@RequestMapping(method = RequestMethod.GET, value = "/pfteams/{pfteam_id}/emplantempls/{emplantempl_id}/emplans/{emplan_id}/emplandetails/{emplandetail_id}")
    public ResponseEntity<EMPlanDetailDTO> getByPFTeamEMPlanTemplEMPlan(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emplantempl_id") String emplantempl_id, @PathVariable("emplan_id") String emplan_id, @PathVariable("emplandetail_id") String emplandetail_id) {
        EMPlanDetail domain = emplandetailService.get(emplandetail_id);
        EMPlanDetailDTO dto = emplandetailMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMPlanDetail-GetDraft-all')")
    @ApiOperation(value = "GetDraftByPFTeamEMPlanTemplEMPlan", tags = {"EMPlanDetail" },  notes = "GetDraftByPFTeamEMPlanTemplEMPlan")
    @RequestMapping(method = RequestMethod.GET, value = "/pfteams/{pfteam_id}/emplantempls/{emplantempl_id}/emplans/{emplan_id}/emplandetails/getdraft")
    public ResponseEntity<EMPlanDetailDTO> getDraftByPFTeamEMPlanTemplEMPlan(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emplantempl_id") String emplantempl_id, @PathVariable("emplan_id") String emplan_id) {
        EMPlanDetail domain = new EMPlanDetail();
        domain.setPlanid(emplan_id);
        return ResponseEntity.status(HttpStatus.OK).body(emplandetailMapping.toDto(emplandetailService.getDraft(domain)));
    }

    @PreAuthorize("hasPermission('','Save',{'Sql',this.emplandetailMapping,#emplandetaildto})")
    @ApiOperation(value = "SaveByPFTeamEMPlanTemplEMPlan", tags = {"EMPlanDetail" },  notes = "SaveByPFTeamEMPlanTemplEMPlan")
	@RequestMapping(method = RequestMethod.POST, value = "/pfteams/{pfteam_id}/emplantempls/{emplantempl_id}/emplans/{emplan_id}/emplandetails/save")
    public ResponseEntity<Boolean> saveByPFTeamEMPlanTemplEMPlan(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emplantempl_id") String emplantempl_id, @PathVariable("emplan_id") String emplan_id, @RequestBody EMPlanDetailDTO emplandetaildto) {
        EMPlanDetail domain = emplandetailMapping.toDomain(emplandetaildto);
        domain.setPlanid(emplan_id);
        return ResponseEntity.status(HttpStatus.OK).body(emplandetailService.save(domain));
    }

    @PreAuthorize("hasPermission('Save',{'Sql',this.emplandetailMapping,#emplandetaildtos})")
    @ApiOperation(value = "SaveBatchByPFTeamEMPlanTemplEMPlan", tags = {"EMPlanDetail" },  notes = "SaveBatchByPFTeamEMPlanTemplEMPlan")
	@RequestMapping(method = RequestMethod.POST, value = "/pfteams/{pfteam_id}/emplantempls/{emplantempl_id}/emplans/{emplan_id}/emplandetails/savebatch")
    public ResponseEntity<Boolean> saveBatchByPFTeamEMPlanTemplEMPlan(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emplantempl_id") String emplantempl_id, @PathVariable("emplan_id") String emplan_id, @RequestBody List<EMPlanDetailDTO> emplandetaildtos) {
        List<EMPlanDetail> domainlist=emplandetailMapping.toDomain(emplandetaildtos);
        for(EMPlanDetail domain:domainlist){
             domain.setPlanid(emplan_id);
        }
        emplandetailService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(#emplandetail_id,'Update',{'Sql',this.emplandetailMapping,#emplandetaildto})")
    @ApiOperation(value = "UpdateByPFTeamEMPlanTemplEMPlan", tags = {"EMPlanDetail" },  notes = "UpdateByPFTeamEMPlanTemplEMPlan")
	@RequestMapping(method = RequestMethod.PUT, value = "/pfteams/{pfteam_id}/emplantempls/{emplantempl_id}/emplans/{emplan_id}/emplandetails/{emplandetail_id}")
    @Transactional
    public ResponseEntity<EMPlanDetailDTO> updateByPFTeamEMPlanTemplEMPlan(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emplantempl_id") String emplantempl_id, @PathVariable("emplan_id") String emplan_id, @PathVariable("emplandetail_id") String emplandetail_id, @RequestBody EMPlanDetailDTO emplandetaildto) {
        EMPlanDetail domain = emplandetailMapping.toDomain(emplandetaildto);
        domain.setPlanid(emplan_id);
        domain.setEmplandetailid(emplandetail_id);
		emplandetailService.update(domain);
        EMPlanDetailDTO dto = emplandetailMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Update',{'Sql',this.emplandetailMapping,#emplandetaildtos})")
    @ApiOperation(value = "UpdateBatchByPFTeamEMPlanTemplEMPlan", tags = {"EMPlanDetail" },  notes = "UpdateBatchByPFTeamEMPlanTemplEMPlan")
	@RequestMapping(method = RequestMethod.PUT, value = "/pfteams/{pfteam_id}/emplantempls/{emplantempl_id}/emplans/{emplan_id}/emplandetails/batch")
    public ResponseEntity<Boolean> updateBatchByPFTeamEMPlanTemplEMPlan(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emplantempl_id") String emplantempl_id, @PathVariable("emplan_id") String emplan_id, @RequestBody List<EMPlanDetailDTO> emplandetaildtos) {
        List<EMPlanDetail> domainlist=emplandetailMapping.toDomain(emplandetaildtos);
        for(EMPlanDetail domain:domainlist){
            domain.setPlanid(emplan_id);
        }
        emplandetailService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission('','Create',{'Sql',this.emplandetailMapping,#emplandetaildto})")
    @ApiOperation(value = "CreateByPFTeamEMPlanTemplEMPlan", tags = {"EMPlanDetail" },  notes = "CreateByPFTeamEMPlanTemplEMPlan")
	@RequestMapping(method = RequestMethod.POST, value = "/pfteams/{pfteam_id}/emplantempls/{emplantempl_id}/emplans/{emplan_id}/emplandetails")
    @Transactional
    public ResponseEntity<EMPlanDetailDTO> createByPFTeamEMPlanTemplEMPlan(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emplantempl_id") String emplantempl_id, @PathVariable("emplan_id") String emplan_id, @RequestBody EMPlanDetailDTO emplandetaildto) {
        EMPlanDetail domain = emplandetailMapping.toDomain(emplandetaildto);
        domain.setPlanid(emplan_id);
		emplandetailService.create(domain);
        EMPlanDetailDTO dto = emplandetailMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Create',{'Sql',this.emplandetailMapping,#emplandetaildtos})")
    @ApiOperation(value = "createBatchByPFTeamEMPlanTemplEMPlan", tags = {"EMPlanDetail" },  notes = "createBatchByPFTeamEMPlanTemplEMPlan")
	@RequestMapping(method = RequestMethod.POST, value = "/pfteams/{pfteam_id}/emplantempls/{emplantempl_id}/emplans/{emplan_id}/emplandetails/batch")
    public ResponseEntity<Boolean> createBatchByPFTeamEMPlanTemplEMPlan(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emplantempl_id") String emplantempl_id, @PathVariable("emplan_id") String emplan_id, @RequestBody List<EMPlanDetailDTO> emplandetaildtos) {
        List<EMPlanDetail> domainlist=emplandetailMapping.toDomain(emplandetaildtos);
        for(EMPlanDetail domain:domainlist){
            domain.setPlanid(emplan_id);
        }
        emplandetailService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMPlanDetail-CheckKey-all')")
    @ApiOperation(value = "CheckKeyByPFTeamEMPlanTemplEMPlan", tags = {"EMPlanDetail" },  notes = "CheckKeyByPFTeamEMPlanTemplEMPlan")
	@RequestMapping(method = RequestMethod.POST, value = "/pfteams/{pfteam_id}/emplantempls/{emplantempl_id}/emplans/{emplan_id}/emplandetails/checkkey")
    public ResponseEntity<Boolean> checkKeyByPFTeamEMPlanTemplEMPlan(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emplantempl_id") String emplantempl_id, @PathVariable("emplan_id") String emplan_id, @RequestBody EMPlanDetailDTO emplandetaildto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emplandetailService.checkKey(emplandetailMapping.toDomain(emplandetaildto)));
    }

    @PreAuthorize("hasPermission(#emplandetail_id,'Remove',{'Sql',this.emplandetailMapping,this.permissionDTO})")
    @ApiOperation(value = "RemoveByPFTeamEMPlanTemplEMPlan", tags = {"EMPlanDetail" },  notes = "RemoveByPFTeamEMPlanTemplEMPlan")
	@RequestMapping(method = RequestMethod.DELETE, value = "/pfteams/{pfteam_id}/emplantempls/{emplantempl_id}/emplans/{emplan_id}/emplandetails/{emplandetail_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByPFTeamEMPlanTemplEMPlan(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emplantempl_id") String emplantempl_id, @PathVariable("emplan_id") String emplan_id, @PathVariable("emplandetail_id") String emplandetail_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emplandetailService.remove(emplandetail_id));
    }

    @PreAuthorize("hasPermission('Remove',{'Sql',this.emplandetailMapping,this.permissionDTO,#ids})")
    @ApiOperation(value = "RemoveBatchByPFTeamEMPlanTemplEMPlan", tags = {"EMPlanDetail" },  notes = "RemoveBatchByPFTeamEMPlanTemplEMPlan")
	@RequestMapping(method = RequestMethod.DELETE, value = "/pfteams/{pfteam_id}/emplantempls/{emplantempl_id}/emplans/{emplan_id}/emplandetails/batch")
    public ResponseEntity<Boolean> removeBatchByPFTeamEMPlanTemplEMPlan(@RequestBody List<String> ids) {
        emplandetailService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMPlanDetail-Default-all')")
	@ApiOperation(value = "fetchDEFAULTByPFTeamEMPlanTemplEMPlan", tags = {"EMPlanDetail" } ,notes = "fetchDEFAULTByPFTeamEMPlanTemplEMPlan")
    @RequestMapping(method= RequestMethod.GET , value="/pfteams/{pfteam_id}/emplantempls/{emplantempl_id}/emplans/{emplan_id}/emplandetails/fetchdefault")
	public ResponseEntity<List<EMPlanDetailDTO>> fetchEMPlanDetailDefaultByPFTeamEMPlanTemplEMPlan(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emplantempl_id") String emplantempl_id, @PathVariable("emplan_id") String emplan_id,EMPlanDetailSearchContext context) {
        context.setN_planid_eq(emplan_id);
        Page<EMPlanDetail> domains = emplandetailService.searchDefault(context) ;
        List<EMPlanDetailDTO> list = emplandetailMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMPlanDetail-Default-all')")
	@ApiOperation(value = "searchDEFAULTByPFTeamEMPlanTemplEMPlan", tags = {"EMPlanDetail" } ,notes = "searchDEFAULTByPFTeamEMPlanTemplEMPlan")
    @RequestMapping(method= RequestMethod.POST , value="/pfteams/{pfteam_id}/emplantempls/{emplantempl_id}/emplans/{emplan_id}/emplandetails/searchdefault")
	public ResponseEntity<Page<EMPlanDetailDTO>> searchEMPlanDetailDefaultByPFTeamEMPlanTemplEMPlan(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emplantempl_id") String emplantempl_id, @PathVariable("emplan_id") String emplan_id, @RequestBody EMPlanDetailSearchContext context) {
        context.setN_planid_eq(emplan_id);
        Page<EMPlanDetail> domains = emplandetailService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emplandetailMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
}
