package cn.ibizlab.eam.webapi.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;
import javax.servlet.ServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import cn.ibizlab.eam.webapi.dto.*;
import cn.ibizlab.eam.webapi.mapping.*;
import cn.ibizlab.eam.core.eam_core.domain.EMOutput;
import cn.ibizlab.eam.core.eam_core.service.IEMOutputService;
import cn.ibizlab.eam.core.eam_core.filter.EMOutputSearchContext;

@Slf4j
@Api(tags = {"EMOutput" })
@RestController("WebApi-emoutput")
@RequestMapping("")
public class EMOutputResource {

    @Autowired
    private IEMOutputService emoutputService;

    @Autowired
    @Lazy
    public EMOutputMapping emoutputMapping;

    public EMOutputDTO permissionDTO=new EMOutputDTO();

    @PreAuthorize("hasPermission(#emoutput_id,'Remove',{'Sql',this.emoutputMapping,this.permissionDTO})")
    @ApiOperation(value = "Remove", tags = {"EMOutput" },  notes = "Remove")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emoutputs/{emoutput_id}")
    @Transactional
    public ResponseEntity<Boolean> remove(@PathVariable("emoutput_id") String emoutput_id) {
         return ResponseEntity.status(HttpStatus.OK).body(emoutputService.remove(emoutput_id));
    }

    @PreAuthorize("hasPermission('Remove',{'Sql',this.emoutputMapping,this.permissionDTO,#ids})")
    @ApiOperation(value = "RemoveBatch", tags = {"EMOutput" },  notes = "RemoveBatch")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emoutputs/batch")
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        emoutputService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMOutput-GetDraft-all')")
    @ApiOperation(value = "GetDraft", tags = {"EMOutput" },  notes = "GetDraft")
	@RequestMapping(method = RequestMethod.GET, value = "/emoutputs/getdraft")
    public ResponseEntity<EMOutputDTO> getDraft() {
        return ResponseEntity.status(HttpStatus.OK).body(emoutputMapping.toDto(emoutputService.getDraft(new EMOutput())));
    }

    @PreAuthorize("hasPermission(#emoutput_id,'Get',{'Sql',this.emoutputMapping,this.permissionDTO})")
    @ApiOperation(value = "Get", tags = {"EMOutput" },  notes = "Get")
	@RequestMapping(method = RequestMethod.GET, value = "/emoutputs/{emoutput_id}")
    public ResponseEntity<EMOutputDTO> get(@PathVariable("emoutput_id") String emoutput_id) {
        EMOutput domain = emoutputService.get(emoutput_id);
        EMOutputDTO dto = emoutputMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('','Save',{'Sql',this.emoutputMapping,#emoutputdto})")
    @ApiOperation(value = "Save", tags = {"EMOutput" },  notes = "Save")
	@RequestMapping(method = RequestMethod.POST, value = "/emoutputs/save")
    public ResponseEntity<Boolean> save(@RequestBody EMOutputDTO emoutputdto) {
        return ResponseEntity.status(HttpStatus.OK).body(emoutputService.save(emoutputMapping.toDomain(emoutputdto)));
    }

    @PreAuthorize("hasPermission('Save',{'Sql',this.emoutputMapping,#emoutputdtos})")
    @ApiOperation(value = "SaveBatch", tags = {"EMOutput" },  notes = "SaveBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emoutputs/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<EMOutputDTO> emoutputdtos) {
        emoutputService.saveBatch(emoutputMapping.toDomain(emoutputdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission('','Create',{'Sql',this.emoutputMapping,#emoutputdto})")
    @ApiOperation(value = "Create", tags = {"EMOutput" },  notes = "Create")
	@RequestMapping(method = RequestMethod.POST, value = "/emoutputs")
    @Transactional
    public ResponseEntity<EMOutputDTO> create(@RequestBody EMOutputDTO emoutputdto) {
        EMOutput domain = emoutputMapping.toDomain(emoutputdto);
		emoutputService.create(domain);
        EMOutputDTO dto = emoutputMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Create',{'Sql',this.emoutputMapping,#emoutputdtos})")
    @ApiOperation(value = "createBatch", tags = {"EMOutput" },  notes = "createBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emoutputs/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<EMOutputDTO> emoutputdtos) {
        emoutputService.createBatch(emoutputMapping.toDomain(emoutputdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMOutput-CheckKey-all')")
    @ApiOperation(value = "CheckKey", tags = {"EMOutput" },  notes = "CheckKey")
	@RequestMapping(method = RequestMethod.POST, value = "/emoutputs/checkkey")
    public ResponseEntity<Boolean> checkKey(@RequestBody EMOutputDTO emoutputdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emoutputService.checkKey(emoutputMapping.toDomain(emoutputdto)));
    }

    @PreAuthorize("hasPermission(#emoutput_id,'Update',{'Sql',this.emoutputMapping,#emoutputdto})")
    @ApiOperation(value = "Update", tags = {"EMOutput" },  notes = "Update")
	@RequestMapping(method = RequestMethod.PUT, value = "/emoutputs/{emoutput_id}")
    @Transactional
    public ResponseEntity<EMOutputDTO> update(@PathVariable("emoutput_id") String emoutput_id, @RequestBody EMOutputDTO emoutputdto) {
		EMOutput domain  = emoutputMapping.toDomain(emoutputdto);
        domain .setEmoutputid(emoutput_id);
		emoutputService.update(domain );
		EMOutputDTO dto = emoutputMapping.toDto(domain );
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Update',{'Sql',this.emoutputMapping,#emoutputdtos})")
    @ApiOperation(value = "UpdateBatch", tags = {"EMOutput" },  notes = "UpdateBatch")
	@RequestMapping(method = RequestMethod.PUT, value = "/emoutputs/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<EMOutputDTO> emoutputdtos) {
        emoutputService.updateBatch(emoutputMapping.toDomain(emoutputdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMOutput-Default-all')")
	@ApiOperation(value = "fetchDEFAULT", tags = {"EMOutput" } ,notes = "fetchDEFAULT")
    @RequestMapping(method= RequestMethod.GET , value="/emoutputs/fetchdefault")
	public ResponseEntity<List<EMOutputDTO>> fetchDefault(EMOutputSearchContext context) {
        Page<EMOutput> domains = emoutputService.searchDefault(context) ;
        List<EMOutputDTO> list = emoutputMapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMOutput-Default-all')")
	@ApiOperation(value = "searchDEFAULT", tags = {"EMOutput" } ,notes = "searchDEFAULT")
    @RequestMapping(method= RequestMethod.POST , value="/emoutputs/searchdefault")
	public ResponseEntity<Page<EMOutputDTO>> searchDefault(@RequestBody EMOutputSearchContext context) {
        Page<EMOutput> domains = emoutputService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emoutputMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
}
