package cn.ibizlab.eam.webapi.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;
import javax.servlet.ServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import cn.ibizlab.eam.webapi.dto.*;
import cn.ibizlab.eam.webapi.mapping.*;
import cn.ibizlab.eam.core.eam_core.domain.EMMonthly;
import cn.ibizlab.eam.core.eam_core.service.IEMMonthlyService;
import cn.ibizlab.eam.core.eam_core.filter.EMMonthlySearchContext;

@Slf4j
@Api(tags = {"EMMonthly" })
@RestController("WebApi-emmonthly")
@RequestMapping("")
public class EMMonthlyResource {

    @Autowired
    private IEMMonthlyService emmonthlyService;

    @Autowired
    @Lazy
    public EMMonthlyMapping emmonthlyMapping;

    public EMMonthlyDTO permissionDTO=new EMMonthlyDTO();

    @PreAuthorize("hasPermission('','Create',{'Sql',this.emmonthlyMapping,#emmonthlydto})")
    @ApiOperation(value = "Create", tags = {"EMMonthly" },  notes = "Create")
	@RequestMapping(method = RequestMethod.POST, value = "/emmonthlies")
    @Transactional
    public ResponseEntity<EMMonthlyDTO> create(@RequestBody EMMonthlyDTO emmonthlydto) {
        EMMonthly domain = emmonthlyMapping.toDomain(emmonthlydto);
		emmonthlyService.create(domain);
        EMMonthlyDTO dto = emmonthlyMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Create',{'Sql',this.emmonthlyMapping,#emmonthlydtos})")
    @ApiOperation(value = "createBatch", tags = {"EMMonthly" },  notes = "createBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emmonthlies/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<EMMonthlyDTO> emmonthlydtos) {
        emmonthlyService.createBatch(emmonthlyMapping.toDomain(emmonthlydtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission('','Save',{'Sql',this.emmonthlyMapping,#emmonthlydto})")
    @ApiOperation(value = "Save", tags = {"EMMonthly" },  notes = "Save")
	@RequestMapping(method = RequestMethod.POST, value = "/emmonthlies/save")
    public ResponseEntity<Boolean> save(@RequestBody EMMonthlyDTO emmonthlydto) {
        return ResponseEntity.status(HttpStatus.OK).body(emmonthlyService.save(emmonthlyMapping.toDomain(emmonthlydto)));
    }

    @PreAuthorize("hasPermission('Save',{'Sql',this.emmonthlyMapping,#emmonthlydtos})")
    @ApiOperation(value = "SaveBatch", tags = {"EMMonthly" },  notes = "SaveBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emmonthlies/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<EMMonthlyDTO> emmonthlydtos) {
        emmonthlyService.saveBatch(emmonthlyMapping.toDomain(emmonthlydtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMMonthly-CheckKey-all')")
    @ApiOperation(value = "CheckKey", tags = {"EMMonthly" },  notes = "CheckKey")
	@RequestMapping(method = RequestMethod.POST, value = "/emmonthlies/checkkey")
    public ResponseEntity<Boolean> checkKey(@RequestBody EMMonthlyDTO emmonthlydto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emmonthlyService.checkKey(emmonthlyMapping.toDomain(emmonthlydto)));
    }

    @PreAuthorize("hasPermission(#emmonthly_id,'Get',{'Sql',this.emmonthlyMapping,this.permissionDTO})")
    @ApiOperation(value = "Get", tags = {"EMMonthly" },  notes = "Get")
	@RequestMapping(method = RequestMethod.GET, value = "/emmonthlies/{emmonthly_id}")
    public ResponseEntity<EMMonthlyDTO> get(@PathVariable("emmonthly_id") String emmonthly_id) {
        EMMonthly domain = emmonthlyService.get(emmonthly_id);
        EMMonthlyDTO dto = emmonthlyMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(#emmonthly_id,'Remove',{'Sql',this.emmonthlyMapping,this.permissionDTO})")
    @ApiOperation(value = "Remove", tags = {"EMMonthly" },  notes = "Remove")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emmonthlies/{emmonthly_id}")
    @Transactional
    public ResponseEntity<Boolean> remove(@PathVariable("emmonthly_id") String emmonthly_id) {
         return ResponseEntity.status(HttpStatus.OK).body(emmonthlyService.remove(emmonthly_id));
    }

    @PreAuthorize("hasPermission('Remove',{'Sql',this.emmonthlyMapping,this.permissionDTO,#ids})")
    @ApiOperation(value = "RemoveBatch", tags = {"EMMonthly" },  notes = "RemoveBatch")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emmonthlies/batch")
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        emmonthlyService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(#emmonthly_id,'Update',{'Sql',this.emmonthlyMapping,#emmonthlydto})")
    @ApiOperation(value = "Update", tags = {"EMMonthly" },  notes = "Update")
	@RequestMapping(method = RequestMethod.PUT, value = "/emmonthlies/{emmonthly_id}")
    @Transactional
    public ResponseEntity<EMMonthlyDTO> update(@PathVariable("emmonthly_id") String emmonthly_id, @RequestBody EMMonthlyDTO emmonthlydto) {
		EMMonthly domain  = emmonthlyMapping.toDomain(emmonthlydto);
        domain .setEmmonthlyid(emmonthly_id);
		emmonthlyService.update(domain );
		EMMonthlyDTO dto = emmonthlyMapping.toDto(domain );
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Update',{'Sql',this.emmonthlyMapping,#emmonthlydtos})")
    @ApiOperation(value = "UpdateBatch", tags = {"EMMonthly" },  notes = "UpdateBatch")
	@RequestMapping(method = RequestMethod.PUT, value = "/emmonthlies/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<EMMonthlyDTO> emmonthlydtos) {
        emmonthlyService.updateBatch(emmonthlyMapping.toDomain(emmonthlydtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMMonthly-GetDraft-all')")
    @ApiOperation(value = "GetDraft", tags = {"EMMonthly" },  notes = "GetDraft")
	@RequestMapping(method = RequestMethod.GET, value = "/emmonthlies/getdraft")
    public ResponseEntity<EMMonthlyDTO> getDraft() {
        return ResponseEntity.status(HttpStatus.OK).body(emmonthlyMapping.toDto(emmonthlyService.getDraft(new EMMonthly())));
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMMonthly-Default-all')")
	@ApiOperation(value = "fetchDEFAULT", tags = {"EMMonthly" } ,notes = "fetchDEFAULT")
    @RequestMapping(method= RequestMethod.GET , value="/emmonthlies/fetchdefault")
	public ResponseEntity<List<EMMonthlyDTO>> fetchDefault(EMMonthlySearchContext context) {
        Page<EMMonthly> domains = emmonthlyService.searchDefault(context) ;
        List<EMMonthlyDTO> list = emmonthlyMapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMMonthly-Default-all')")
	@ApiOperation(value = "searchDEFAULT", tags = {"EMMonthly" } ,notes = "searchDEFAULT")
    @RequestMapping(method= RequestMethod.POST , value="/emmonthlies/searchdefault")
	public ResponseEntity<Page<EMMonthlyDTO>> searchDefault(@RequestBody EMMonthlySearchContext context) {
        Page<EMMonthly> domains = emmonthlyService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emmonthlyMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
}
