package cn.ibizlab.eam.webapi.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;
import javax.servlet.ServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import cn.ibizlab.eam.webapi.dto.*;
import cn.ibizlab.eam.webapi.mapping.*;
import cn.ibizlab.eam.core.eam_core.domain.EMMachineCategory;
import cn.ibizlab.eam.core.eam_core.service.IEMMachineCategoryService;
import cn.ibizlab.eam.core.eam_core.filter.EMMachineCategorySearchContext;

@Slf4j
@Api(tags = {"EMMachineCategory" })
@RestController("WebApi-emmachinecategory")
@RequestMapping("")
public class EMMachineCategoryResource {

    @Autowired
    private IEMMachineCategoryService emmachinecategoryService;

    @Autowired
    @Lazy
    public EMMachineCategoryMapping emmachinecategoryMapping;

    public EMMachineCategoryDTO permissionDTO=new EMMachineCategoryDTO();

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMMachineCategory-CheckKey-all')")
    @ApiOperation(value = "CheckKey", tags = {"EMMachineCategory" },  notes = "CheckKey")
	@RequestMapping(method = RequestMethod.POST, value = "/emmachinecategories/checkkey")
    public ResponseEntity<Boolean> checkKey(@RequestBody EMMachineCategoryDTO emmachinecategorydto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emmachinecategoryService.checkKey(emmachinecategoryMapping.toDomain(emmachinecategorydto)));
    }

    @PreAuthorize("hasPermission(#emmachinecategory_id,'Remove',{'Sql',this.emmachinecategoryMapping,this.permissionDTO})")
    @ApiOperation(value = "Remove", tags = {"EMMachineCategory" },  notes = "Remove")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emmachinecategories/{emmachinecategory_id}")
    @Transactional
    public ResponseEntity<Boolean> remove(@PathVariable("emmachinecategory_id") String emmachinecategory_id) {
         return ResponseEntity.status(HttpStatus.OK).body(emmachinecategoryService.remove(emmachinecategory_id));
    }

    @PreAuthorize("hasPermission('Remove',{'Sql',this.emmachinecategoryMapping,this.permissionDTO,#ids})")
    @ApiOperation(value = "RemoveBatch", tags = {"EMMachineCategory" },  notes = "RemoveBatch")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emmachinecategories/batch")
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        emmachinecategoryService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(#emmachinecategory_id,'Get',{'Sql',this.emmachinecategoryMapping,this.permissionDTO})")
    @ApiOperation(value = "Get", tags = {"EMMachineCategory" },  notes = "Get")
	@RequestMapping(method = RequestMethod.GET, value = "/emmachinecategories/{emmachinecategory_id}")
    public ResponseEntity<EMMachineCategoryDTO> get(@PathVariable("emmachinecategory_id") String emmachinecategory_id) {
        EMMachineCategory domain = emmachinecategoryService.get(emmachinecategory_id);
        EMMachineCategoryDTO dto = emmachinecategoryMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(#emmachinecategory_id,'Update',{'Sql',this.emmachinecategoryMapping,#emmachinecategorydto})")
    @ApiOperation(value = "Update", tags = {"EMMachineCategory" },  notes = "Update")
	@RequestMapping(method = RequestMethod.PUT, value = "/emmachinecategories/{emmachinecategory_id}")
    @Transactional
    public ResponseEntity<EMMachineCategoryDTO> update(@PathVariable("emmachinecategory_id") String emmachinecategory_id, @RequestBody EMMachineCategoryDTO emmachinecategorydto) {
		EMMachineCategory domain  = emmachinecategoryMapping.toDomain(emmachinecategorydto);
        domain .setEmmachinecategoryid(emmachinecategory_id);
		emmachinecategoryService.update(domain );
		EMMachineCategoryDTO dto = emmachinecategoryMapping.toDto(domain );
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Update',{'Sql',this.emmachinecategoryMapping,#emmachinecategorydtos})")
    @ApiOperation(value = "UpdateBatch", tags = {"EMMachineCategory" },  notes = "UpdateBatch")
	@RequestMapping(method = RequestMethod.PUT, value = "/emmachinecategories/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<EMMachineCategoryDTO> emmachinecategorydtos) {
        emmachinecategoryService.updateBatch(emmachinecategoryMapping.toDomain(emmachinecategorydtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission('','Create',{'Sql',this.emmachinecategoryMapping,#emmachinecategorydto})")
    @ApiOperation(value = "Create", tags = {"EMMachineCategory" },  notes = "Create")
	@RequestMapping(method = RequestMethod.POST, value = "/emmachinecategories")
    @Transactional
    public ResponseEntity<EMMachineCategoryDTO> create(@RequestBody EMMachineCategoryDTO emmachinecategorydto) {
        EMMachineCategory domain = emmachinecategoryMapping.toDomain(emmachinecategorydto);
		emmachinecategoryService.create(domain);
        EMMachineCategoryDTO dto = emmachinecategoryMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Create',{'Sql',this.emmachinecategoryMapping,#emmachinecategorydtos})")
    @ApiOperation(value = "createBatch", tags = {"EMMachineCategory" },  notes = "createBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emmachinecategories/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<EMMachineCategoryDTO> emmachinecategorydtos) {
        emmachinecategoryService.createBatch(emmachinecategoryMapping.toDomain(emmachinecategorydtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMMachineCategory-GetDraft-all')")
    @ApiOperation(value = "GetDraft", tags = {"EMMachineCategory" },  notes = "GetDraft")
	@RequestMapping(method = RequestMethod.GET, value = "/emmachinecategories/getdraft")
    public ResponseEntity<EMMachineCategoryDTO> getDraft() {
        return ResponseEntity.status(HttpStatus.OK).body(emmachinecategoryMapping.toDto(emmachinecategoryService.getDraft(new EMMachineCategory())));
    }

    @PreAuthorize("hasPermission('','Save',{'Sql',this.emmachinecategoryMapping,#emmachinecategorydto})")
    @ApiOperation(value = "Save", tags = {"EMMachineCategory" },  notes = "Save")
	@RequestMapping(method = RequestMethod.POST, value = "/emmachinecategories/save")
    public ResponseEntity<Boolean> save(@RequestBody EMMachineCategoryDTO emmachinecategorydto) {
        return ResponseEntity.status(HttpStatus.OK).body(emmachinecategoryService.save(emmachinecategoryMapping.toDomain(emmachinecategorydto)));
    }

    @PreAuthorize("hasPermission('Save',{'Sql',this.emmachinecategoryMapping,#emmachinecategorydtos})")
    @ApiOperation(value = "SaveBatch", tags = {"EMMachineCategory" },  notes = "SaveBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emmachinecategories/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<EMMachineCategoryDTO> emmachinecategorydtos) {
        emmachinecategoryService.saveBatch(emmachinecategoryMapping.toDomain(emmachinecategorydtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMMachineCategory-Default-all')")
	@ApiOperation(value = "fetchDEFAULT", tags = {"EMMachineCategory" } ,notes = "fetchDEFAULT")
    @RequestMapping(method= RequestMethod.GET , value="/emmachinecategories/fetchdefault")
	public ResponseEntity<List<EMMachineCategoryDTO>> fetchDefault(EMMachineCategorySearchContext context) {
        Page<EMMachineCategory> domains = emmachinecategoryService.searchDefault(context) ;
        List<EMMachineCategoryDTO> list = emmachinecategoryMapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMMachineCategory-Default-all')")
	@ApiOperation(value = "searchDEFAULT", tags = {"EMMachineCategory" } ,notes = "searchDEFAULT")
    @RequestMapping(method= RequestMethod.POST , value="/emmachinecategories/searchdefault")
	public ResponseEntity<Page<EMMachineCategoryDTO>> searchDefault(@RequestBody EMMachineCategorySearchContext context) {
        Page<EMMachineCategory> domains = emmachinecategoryService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emmachinecategoryMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
}
