package cn.ibizlab.eam.webapi.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;
import javax.servlet.ServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import cn.ibizlab.eam.webapi.dto.*;
import cn.ibizlab.eam.webapi.mapping.*;
import cn.ibizlab.eam.core.eam_core.domain.EMEQSpare;
import cn.ibizlab.eam.core.eam_core.service.IEMEQSpareService;
import cn.ibizlab.eam.core.eam_core.filter.EMEQSpareSearchContext;

@Slf4j
@Api(tags = {"EMEQSpare" })
@RestController("WebApi-emeqspare")
@RequestMapping("")
public class EMEQSpareResource {

    @Autowired
    private IEMEQSpareService emeqspareService;

    @Autowired
    @Lazy
    public EMEQSpareMapping emeqspareMapping;

    public EMEQSpareDTO permissionDTO=new EMEQSpareDTO();

    @PreAuthorize("hasPermission(#emeqspare_id,'Update',{'Sql',this.emeqspareMapping,#emeqsparedto})")
    @ApiOperation(value = "Update", tags = {"EMEQSpare" },  notes = "Update")
	@RequestMapping(method = RequestMethod.PUT, value = "/emeqspares/{emeqspare_id}")
    @Transactional
    public ResponseEntity<EMEQSpareDTO> update(@PathVariable("emeqspare_id") String emeqspare_id, @RequestBody EMEQSpareDTO emeqsparedto) {
		EMEQSpare domain  = emeqspareMapping.toDomain(emeqsparedto);
        domain .setEmeqspareid(emeqspare_id);
		emeqspareService.update(domain );
		EMEQSpareDTO dto = emeqspareMapping.toDto(domain );
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Update',{'Sql',this.emeqspareMapping,#emeqsparedtos})")
    @ApiOperation(value = "UpdateBatch", tags = {"EMEQSpare" },  notes = "UpdateBatch")
	@RequestMapping(method = RequestMethod.PUT, value = "/emeqspares/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<EMEQSpareDTO> emeqsparedtos) {
        emeqspareService.updateBatch(emeqspareMapping.toDomain(emeqsparedtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(#emeqspare_id,'Remove',{'Sql',this.emeqspareMapping,this.permissionDTO})")
    @ApiOperation(value = "Remove", tags = {"EMEQSpare" },  notes = "Remove")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emeqspares/{emeqspare_id}")
    @Transactional
    public ResponseEntity<Boolean> remove(@PathVariable("emeqspare_id") String emeqspare_id) {
         return ResponseEntity.status(HttpStatus.OK).body(emeqspareService.remove(emeqspare_id));
    }

    @PreAuthorize("hasPermission('Remove',{'Sql',this.emeqspareMapping,this.permissionDTO,#ids})")
    @ApiOperation(value = "RemoveBatch", tags = {"EMEQSpare" },  notes = "RemoveBatch")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emeqspares/batch")
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        emeqspareService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMEQSpare-CheckKey-all')")
    @ApiOperation(value = "CheckKey", tags = {"EMEQSpare" },  notes = "CheckKey")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqspares/checkkey")
    public ResponseEntity<Boolean> checkKey(@RequestBody EMEQSpareDTO emeqsparedto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emeqspareService.checkKey(emeqspareMapping.toDomain(emeqsparedto)));
    }

    @PreAuthorize("hasPermission('','Create',{'Sql',this.emeqspareMapping,#emeqsparedto})")
    @ApiOperation(value = "Create", tags = {"EMEQSpare" },  notes = "Create")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqspares")
    @Transactional
    public ResponseEntity<EMEQSpareDTO> create(@RequestBody EMEQSpareDTO emeqsparedto) {
        EMEQSpare domain = emeqspareMapping.toDomain(emeqsparedto);
		emeqspareService.create(domain);
        EMEQSpareDTO dto = emeqspareMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Create',{'Sql',this.emeqspareMapping,#emeqsparedtos})")
    @ApiOperation(value = "createBatch", tags = {"EMEQSpare" },  notes = "createBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqspares/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<EMEQSpareDTO> emeqsparedtos) {
        emeqspareService.createBatch(emeqspareMapping.toDomain(emeqsparedtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission('','Save',{'Sql',this.emeqspareMapping,#emeqsparedto})")
    @ApiOperation(value = "Save", tags = {"EMEQSpare" },  notes = "Save")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqspares/save")
    public ResponseEntity<Boolean> save(@RequestBody EMEQSpareDTO emeqsparedto) {
        return ResponseEntity.status(HttpStatus.OK).body(emeqspareService.save(emeqspareMapping.toDomain(emeqsparedto)));
    }

    @PreAuthorize("hasPermission('Save',{'Sql',this.emeqspareMapping,#emeqsparedtos})")
    @ApiOperation(value = "SaveBatch", tags = {"EMEQSpare" },  notes = "SaveBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqspares/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<EMEQSpareDTO> emeqsparedtos) {
        emeqspareService.saveBatch(emeqspareMapping.toDomain(emeqsparedtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMEQSpare-GetDraft-all')")
    @ApiOperation(value = "GetDraft", tags = {"EMEQSpare" },  notes = "GetDraft")
	@RequestMapping(method = RequestMethod.GET, value = "/emeqspares/getdraft")
    public ResponseEntity<EMEQSpareDTO> getDraft() {
        return ResponseEntity.status(HttpStatus.OK).body(emeqspareMapping.toDto(emeqspareService.getDraft(new EMEQSpare())));
    }

    @PreAuthorize("hasPermission(#emeqspare_id,'Get',{'Sql',this.emeqspareMapping,this.permissionDTO})")
    @ApiOperation(value = "Get", tags = {"EMEQSpare" },  notes = "Get")
	@RequestMapping(method = RequestMethod.GET, value = "/emeqspares/{emeqspare_id}")
    public ResponseEntity<EMEQSpareDTO> get(@PathVariable("emeqspare_id") String emeqspare_id) {
        EMEQSpare domain = emeqspareService.get(emeqspare_id);
        EMEQSpareDTO dto = emeqspareMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMEQSpare-Default-all')")
	@ApiOperation(value = "fetchDEFAULT", tags = {"EMEQSpare" } ,notes = "fetchDEFAULT")
    @RequestMapping(method= RequestMethod.GET , value="/emeqspares/fetchdefault")
	public ResponseEntity<List<EMEQSpareDTO>> fetchDefault(EMEQSpareSearchContext context) {
        Page<EMEQSpare> domains = emeqspareService.searchDefault(context) ;
        List<EMEQSpareDTO> list = emeqspareMapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMEQSpare-Default-all')")
	@ApiOperation(value = "searchDEFAULT", tags = {"EMEQSpare" } ,notes = "searchDEFAULT")
    @RequestMapping(method= RequestMethod.POST , value="/emeqspares/searchdefault")
	public ResponseEntity<Page<EMEQSpareDTO>> searchDefault(@RequestBody EMEQSpareSearchContext context) {
        Page<EMEQSpare> domains = emeqspareService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emeqspareMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
}
