package cn.ibizlab.eam.webapi.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;
import javax.servlet.ServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import cn.ibizlab.eam.webapi.dto.*;
import cn.ibizlab.eam.webapi.mapping.*;
import cn.ibizlab.eam.core.eam_core.domain.EMEQKP;
import cn.ibizlab.eam.core.eam_core.service.IEMEQKPService;
import cn.ibizlab.eam.core.eam_core.filter.EMEQKPSearchContext;

@Slf4j
@Api(tags = {"EMEQKP" })
@RestController("WebApi-emeqkp")
@RequestMapping("")
public class EMEQKPResource {

    @Autowired
    private IEMEQKPService emeqkpService;

    @Autowired
    @Lazy
    public EMEQKPMapping emeqkpMapping;

    public EMEQKPDTO permissionDTO=new EMEQKPDTO();

    @PreAuthorize("hasPermission(#emeqkp_id,'Remove',{'Sql',this.emeqkpMapping,this.permissionDTO})")
    @ApiOperation(value = "Remove", tags = {"EMEQKP" },  notes = "Remove")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emeqkps/{emeqkp_id}")
    @Transactional
    public ResponseEntity<Boolean> remove(@PathVariable("emeqkp_id") String emeqkp_id) {
         return ResponseEntity.status(HttpStatus.OK).body(emeqkpService.remove(emeqkp_id));
    }

    @PreAuthorize("hasPermission('Remove',{'Sql',this.emeqkpMapping,this.permissionDTO,#ids})")
    @ApiOperation(value = "RemoveBatch", tags = {"EMEQKP" },  notes = "RemoveBatch")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emeqkps/batch")
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        emeqkpService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(#emeqkp_id,'Get',{'Sql',this.emeqkpMapping,this.permissionDTO})")
    @ApiOperation(value = "Get", tags = {"EMEQKP" },  notes = "Get")
	@RequestMapping(method = RequestMethod.GET, value = "/emeqkps/{emeqkp_id}")
    public ResponseEntity<EMEQKPDTO> get(@PathVariable("emeqkp_id") String emeqkp_id) {
        EMEQKP domain = emeqkpService.get(emeqkp_id);
        EMEQKPDTO dto = emeqkpMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('','Create',{'Sql',this.emeqkpMapping,#emeqkpdto})")
    @ApiOperation(value = "Create", tags = {"EMEQKP" },  notes = "Create")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqkps")
    @Transactional
    public ResponseEntity<EMEQKPDTO> create(@RequestBody EMEQKPDTO emeqkpdto) {
        EMEQKP domain = emeqkpMapping.toDomain(emeqkpdto);
		emeqkpService.create(domain);
        EMEQKPDTO dto = emeqkpMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Create',{'Sql',this.emeqkpMapping,#emeqkpdtos})")
    @ApiOperation(value = "createBatch", tags = {"EMEQKP" },  notes = "createBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqkps/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<EMEQKPDTO> emeqkpdtos) {
        emeqkpService.createBatch(emeqkpMapping.toDomain(emeqkpdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMEQKP-CheckKey-all')")
    @ApiOperation(value = "CheckKey", tags = {"EMEQKP" },  notes = "CheckKey")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqkps/checkkey")
    public ResponseEntity<Boolean> checkKey(@RequestBody EMEQKPDTO emeqkpdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emeqkpService.checkKey(emeqkpMapping.toDomain(emeqkpdto)));
    }

    @PreAuthorize("hasPermission('','Save',{'Sql',this.emeqkpMapping,#emeqkpdto})")
    @ApiOperation(value = "Save", tags = {"EMEQKP" },  notes = "Save")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqkps/save")
    public ResponseEntity<Boolean> save(@RequestBody EMEQKPDTO emeqkpdto) {
        return ResponseEntity.status(HttpStatus.OK).body(emeqkpService.save(emeqkpMapping.toDomain(emeqkpdto)));
    }

    @PreAuthorize("hasPermission('Save',{'Sql',this.emeqkpMapping,#emeqkpdtos})")
    @ApiOperation(value = "SaveBatch", tags = {"EMEQKP" },  notes = "SaveBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqkps/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<EMEQKPDTO> emeqkpdtos) {
        emeqkpService.saveBatch(emeqkpMapping.toDomain(emeqkpdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(#emeqkp_id,'Update',{'Sql',this.emeqkpMapping,#emeqkpdto})")
    @ApiOperation(value = "Update", tags = {"EMEQKP" },  notes = "Update")
	@RequestMapping(method = RequestMethod.PUT, value = "/emeqkps/{emeqkp_id}")
    @Transactional
    public ResponseEntity<EMEQKPDTO> update(@PathVariable("emeqkp_id") String emeqkp_id, @RequestBody EMEQKPDTO emeqkpdto) {
		EMEQKP domain  = emeqkpMapping.toDomain(emeqkpdto);
        domain .setEmeqkpid(emeqkp_id);
		emeqkpService.update(domain );
		EMEQKPDTO dto = emeqkpMapping.toDto(domain );
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Update',{'Sql',this.emeqkpMapping,#emeqkpdtos})")
    @ApiOperation(value = "UpdateBatch", tags = {"EMEQKP" },  notes = "UpdateBatch")
	@RequestMapping(method = RequestMethod.PUT, value = "/emeqkps/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<EMEQKPDTO> emeqkpdtos) {
        emeqkpService.updateBatch(emeqkpMapping.toDomain(emeqkpdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMEQKP-GetDraft-all')")
    @ApiOperation(value = "GetDraft", tags = {"EMEQKP" },  notes = "GetDraft")
	@RequestMapping(method = RequestMethod.GET, value = "/emeqkps/getdraft")
    public ResponseEntity<EMEQKPDTO> getDraft() {
        return ResponseEntity.status(HttpStatus.OK).body(emeqkpMapping.toDto(emeqkpService.getDraft(new EMEQKP())));
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMEQKP-Default-all')")
	@ApiOperation(value = "fetchDEFAULT", tags = {"EMEQKP" } ,notes = "fetchDEFAULT")
    @RequestMapping(method= RequestMethod.GET , value="/emeqkps/fetchdefault")
	public ResponseEntity<List<EMEQKPDTO>> fetchDefault(EMEQKPSearchContext context) {
        Page<EMEQKP> domains = emeqkpService.searchDefault(context) ;
        List<EMEQKPDTO> list = emeqkpMapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMEQKP-Default-all')")
	@ApiOperation(value = "searchDEFAULT", tags = {"EMEQKP" } ,notes = "searchDEFAULT")
    @RequestMapping(method= RequestMethod.POST , value="/emeqkps/searchdefault")
	public ResponseEntity<Page<EMEQKPDTO>> searchDefault(@RequestBody EMEQKPSearchContext context) {
        Page<EMEQKP> domains = emeqkpService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emeqkpMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
}
