package cn.ibizlab.eam.webapi.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;
import javax.servlet.ServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import cn.ibizlab.eam.webapi.dto.*;
import cn.ibizlab.eam.webapi.mapping.*;
import cn.ibizlab.eam.core.eam_core.domain.EMEQKPRCD;
import cn.ibizlab.eam.core.eam_core.service.IEMEQKPRCDService;
import cn.ibizlab.eam.core.eam_core.filter.EMEQKPRCDSearchContext;

@Slf4j
@Api(tags = {"EMEQKPRCD" })
@RestController("WebApi-emeqkprcd")
@RequestMapping("")
public class EMEQKPRCDResource {

    @Autowired
    private IEMEQKPRCDService emeqkprcdService;

    @Autowired
    @Lazy
    public EMEQKPRCDMapping emeqkprcdMapping;

    public EMEQKPRCDDTO permissionDTO=new EMEQKPRCDDTO();

    @PreAuthorize("hasPermission(#emeqkprcd_id,'Update',{'Sql',this.emeqkprcdMapping,#emeqkprcddto})")
    @ApiOperation(value = "Update", tags = {"EMEQKPRCD" },  notes = "Update")
	@RequestMapping(method = RequestMethod.PUT, value = "/emeqkprcds/{emeqkprcd_id}")
    @Transactional
    public ResponseEntity<EMEQKPRCDDTO> update(@PathVariable("emeqkprcd_id") String emeqkprcd_id, @RequestBody EMEQKPRCDDTO emeqkprcddto) {
		EMEQKPRCD domain  = emeqkprcdMapping.toDomain(emeqkprcddto);
        domain .setEmeqkprcdid(emeqkprcd_id);
		emeqkprcdService.update(domain );
		EMEQKPRCDDTO dto = emeqkprcdMapping.toDto(domain );
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Update',{'Sql',this.emeqkprcdMapping,#emeqkprcddtos})")
    @ApiOperation(value = "UpdateBatch", tags = {"EMEQKPRCD" },  notes = "UpdateBatch")
	@RequestMapping(method = RequestMethod.PUT, value = "/emeqkprcds/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<EMEQKPRCDDTO> emeqkprcddtos) {
        emeqkprcdService.updateBatch(emeqkprcdMapping.toDomain(emeqkprcddtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(#emeqkprcd_id,'Remove',{'Sql',this.emeqkprcdMapping,this.permissionDTO})")
    @ApiOperation(value = "Remove", tags = {"EMEQKPRCD" },  notes = "Remove")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emeqkprcds/{emeqkprcd_id}")
    @Transactional
    public ResponseEntity<Boolean> remove(@PathVariable("emeqkprcd_id") String emeqkprcd_id) {
         return ResponseEntity.status(HttpStatus.OK).body(emeqkprcdService.remove(emeqkprcd_id));
    }

    @PreAuthorize("hasPermission('Remove',{'Sql',this.emeqkprcdMapping,this.permissionDTO,#ids})")
    @ApiOperation(value = "RemoveBatch", tags = {"EMEQKPRCD" },  notes = "RemoveBatch")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emeqkprcds/batch")
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        emeqkprcdService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission('','Create',{'Sql',this.emeqkprcdMapping,#emeqkprcddto})")
    @ApiOperation(value = "Create", tags = {"EMEQKPRCD" },  notes = "Create")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqkprcds")
    @Transactional
    public ResponseEntity<EMEQKPRCDDTO> create(@RequestBody EMEQKPRCDDTO emeqkprcddto) {
        EMEQKPRCD domain = emeqkprcdMapping.toDomain(emeqkprcddto);
		emeqkprcdService.create(domain);
        EMEQKPRCDDTO dto = emeqkprcdMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Create',{'Sql',this.emeqkprcdMapping,#emeqkprcddtos})")
    @ApiOperation(value = "createBatch", tags = {"EMEQKPRCD" },  notes = "createBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqkprcds/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<EMEQKPRCDDTO> emeqkprcddtos) {
        emeqkprcdService.createBatch(emeqkprcdMapping.toDomain(emeqkprcddtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(#emeqkprcd_id,'Get',{'Sql',this.emeqkprcdMapping,this.permissionDTO})")
    @ApiOperation(value = "Get", tags = {"EMEQKPRCD" },  notes = "Get")
	@RequestMapping(method = RequestMethod.GET, value = "/emeqkprcds/{emeqkprcd_id}")
    public ResponseEntity<EMEQKPRCDDTO> get(@PathVariable("emeqkprcd_id") String emeqkprcd_id) {
        EMEQKPRCD domain = emeqkprcdService.get(emeqkprcd_id);
        EMEQKPRCDDTO dto = emeqkprcdMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMEQKPRCD-CheckKey-all')")
    @ApiOperation(value = "CheckKey", tags = {"EMEQKPRCD" },  notes = "CheckKey")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqkprcds/checkkey")
    public ResponseEntity<Boolean> checkKey(@RequestBody EMEQKPRCDDTO emeqkprcddto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emeqkprcdService.checkKey(emeqkprcdMapping.toDomain(emeqkprcddto)));
    }

    @PreAuthorize("hasPermission('','Save',{'Sql',this.emeqkprcdMapping,#emeqkprcddto})")
    @ApiOperation(value = "Save", tags = {"EMEQKPRCD" },  notes = "Save")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqkprcds/save")
    public ResponseEntity<Boolean> save(@RequestBody EMEQKPRCDDTO emeqkprcddto) {
        return ResponseEntity.status(HttpStatus.OK).body(emeqkprcdService.save(emeqkprcdMapping.toDomain(emeqkprcddto)));
    }

    @PreAuthorize("hasPermission('Save',{'Sql',this.emeqkprcdMapping,#emeqkprcddtos})")
    @ApiOperation(value = "SaveBatch", tags = {"EMEQKPRCD" },  notes = "SaveBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqkprcds/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<EMEQKPRCDDTO> emeqkprcddtos) {
        emeqkprcdService.saveBatch(emeqkprcdMapping.toDomain(emeqkprcddtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMEQKPRCD-GetDraft-all')")
    @ApiOperation(value = "GetDraft", tags = {"EMEQKPRCD" },  notes = "GetDraft")
	@RequestMapping(method = RequestMethod.GET, value = "/emeqkprcds/getdraft")
    public ResponseEntity<EMEQKPRCDDTO> getDraft() {
        return ResponseEntity.status(HttpStatus.OK).body(emeqkprcdMapping.toDto(emeqkprcdService.getDraft(new EMEQKPRCD())));
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMEQKPRCD-Default-all')")
	@ApiOperation(value = "fetchDEFAULT", tags = {"EMEQKPRCD" } ,notes = "fetchDEFAULT")
    @RequestMapping(method= RequestMethod.GET , value="/emeqkprcds/fetchdefault")
	public ResponseEntity<List<EMEQKPRCDDTO>> fetchDefault(EMEQKPRCDSearchContext context) {
        Page<EMEQKPRCD> domains = emeqkprcdService.searchDefault(context) ;
        List<EMEQKPRCDDTO> list = emeqkprcdMapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMEQKPRCD-Default-all')")
	@ApiOperation(value = "searchDEFAULT", tags = {"EMEQKPRCD" } ,notes = "searchDEFAULT")
    @RequestMapping(method= RequestMethod.POST , value="/emeqkprcds/searchdefault")
	public ResponseEntity<Page<EMEQKPRCDDTO>> searchDefault(@RequestBody EMEQKPRCDSearchContext context) {
        Page<EMEQKPRCD> domains = emeqkprcdService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emeqkprcdMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
}
