package cn.ibizlab.eam.webapi.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;
import javax.servlet.ServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import cn.ibizlab.eam.webapi.dto.*;
import cn.ibizlab.eam.webapi.mapping.*;
import cn.ibizlab.eam.core.eam_core.domain.EMEQDebug;
import cn.ibizlab.eam.core.eam_core.service.IEMEQDebugService;
import cn.ibizlab.eam.core.eam_core.filter.EMEQDebugSearchContext;

@Slf4j
@Api(tags = {"EMEQDebug" })
@RestController("WebApi-emeqdebug")
@RequestMapping("")
public class EMEQDebugResource {

    @Autowired
    private IEMEQDebugService emeqdebugService;

    @Autowired
    @Lazy
    public EMEQDebugMapping emeqdebugMapping;

    public EMEQDebugDTO permissionDTO=new EMEQDebugDTO();

    @PreAuthorize("hasPermission(#emeqdebug_id,'Get',{'Sql',this.emeqdebugMapping,this.permissionDTO})")
    @ApiOperation(value = "Get", tags = {"EMEQDebug" },  notes = "Get")
	@RequestMapping(method = RequestMethod.GET, value = "/emeqdebugs/{emeqdebug_id}")
    public ResponseEntity<EMEQDebugDTO> get(@PathVariable("emeqdebug_id") String emeqdebug_id) {
        EMEQDebug domain = emeqdebugService.get(emeqdebug_id);
        EMEQDebugDTO dto = emeqdebugMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('','Create',{'Sql',this.emeqdebugMapping,#emeqdebugdto})")
    @ApiOperation(value = "Create", tags = {"EMEQDebug" },  notes = "Create")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqdebugs")
    @Transactional
    public ResponseEntity<EMEQDebugDTO> create(@RequestBody EMEQDebugDTO emeqdebugdto) {
        EMEQDebug domain = emeqdebugMapping.toDomain(emeqdebugdto);
		emeqdebugService.create(domain);
        EMEQDebugDTO dto = emeqdebugMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Create',{'Sql',this.emeqdebugMapping,#emeqdebugdtos})")
    @ApiOperation(value = "createBatch", tags = {"EMEQDebug" },  notes = "createBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqdebugs/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<EMEQDebugDTO> emeqdebugdtos) {
        emeqdebugService.createBatch(emeqdebugMapping.toDomain(emeqdebugdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission('','Save',{'Sql',this.emeqdebugMapping,#emeqdebugdto})")
    @ApiOperation(value = "Save", tags = {"EMEQDebug" },  notes = "Save")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqdebugs/save")
    public ResponseEntity<Boolean> save(@RequestBody EMEQDebugDTO emeqdebugdto) {
        return ResponseEntity.status(HttpStatus.OK).body(emeqdebugService.save(emeqdebugMapping.toDomain(emeqdebugdto)));
    }

    @PreAuthorize("hasPermission('Save',{'Sql',this.emeqdebugMapping,#emeqdebugdtos})")
    @ApiOperation(value = "SaveBatch", tags = {"EMEQDebug" },  notes = "SaveBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqdebugs/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<EMEQDebugDTO> emeqdebugdtos) {
        emeqdebugService.saveBatch(emeqdebugMapping.toDomain(emeqdebugdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(#emeqdebug_id,'Remove',{'Sql',this.emeqdebugMapping,this.permissionDTO})")
    @ApiOperation(value = "Remove", tags = {"EMEQDebug" },  notes = "Remove")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emeqdebugs/{emeqdebug_id}")
    @Transactional
    public ResponseEntity<Boolean> remove(@PathVariable("emeqdebug_id") String emeqdebug_id) {
         return ResponseEntity.status(HttpStatus.OK).body(emeqdebugService.remove(emeqdebug_id));
    }

    @PreAuthorize("hasPermission('Remove',{'Sql',this.emeqdebugMapping,this.permissionDTO,#ids})")
    @ApiOperation(value = "RemoveBatch", tags = {"EMEQDebug" },  notes = "RemoveBatch")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emeqdebugs/batch")
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        emeqdebugService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMEQDebug-GetDraft-all')")
    @ApiOperation(value = "GetDraft", tags = {"EMEQDebug" },  notes = "GetDraft")
	@RequestMapping(method = RequestMethod.GET, value = "/emeqdebugs/getdraft")
    public ResponseEntity<EMEQDebugDTO> getDraft() {
        return ResponseEntity.status(HttpStatus.OK).body(emeqdebugMapping.toDto(emeqdebugService.getDraft(new EMEQDebug())));
    }

    @PreAuthorize("hasPermission(#emeqdebug_id,'Update',{'Sql',this.emeqdebugMapping,#emeqdebugdto})")
    @ApiOperation(value = "Update", tags = {"EMEQDebug" },  notes = "Update")
	@RequestMapping(method = RequestMethod.PUT, value = "/emeqdebugs/{emeqdebug_id}")
    @Transactional
    public ResponseEntity<EMEQDebugDTO> update(@PathVariable("emeqdebug_id") String emeqdebug_id, @RequestBody EMEQDebugDTO emeqdebugdto) {
		EMEQDebug domain  = emeqdebugMapping.toDomain(emeqdebugdto);
        domain .setEmeqdebugid(emeqdebug_id);
		emeqdebugService.update(domain );
		EMEQDebugDTO dto = emeqdebugMapping.toDto(domain );
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Update',{'Sql',this.emeqdebugMapping,#emeqdebugdtos})")
    @ApiOperation(value = "UpdateBatch", tags = {"EMEQDebug" },  notes = "UpdateBatch")
	@RequestMapping(method = RequestMethod.PUT, value = "/emeqdebugs/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<EMEQDebugDTO> emeqdebugdtos) {
        emeqdebugService.updateBatch(emeqdebugMapping.toDomain(emeqdebugdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMEQDebug-CheckKey-all')")
    @ApiOperation(value = "CheckKey", tags = {"EMEQDebug" },  notes = "CheckKey")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqdebugs/checkkey")
    public ResponseEntity<Boolean> checkKey(@RequestBody EMEQDebugDTO emeqdebugdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emeqdebugService.checkKey(emeqdebugMapping.toDomain(emeqdebugdto)));
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMEQDebug-Default-all')")
	@ApiOperation(value = "fetchDEFAULT", tags = {"EMEQDebug" } ,notes = "fetchDEFAULT")
    @RequestMapping(method= RequestMethod.GET , value="/emeqdebugs/fetchdefault")
	public ResponseEntity<List<EMEQDebugDTO>> fetchDefault(EMEQDebugSearchContext context) {
        Page<EMEQDebug> domains = emeqdebugService.searchDefault(context) ;
        List<EMEQDebugDTO> list = emeqdebugMapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMEQDebug-Default-all')")
	@ApiOperation(value = "searchDEFAULT", tags = {"EMEQDebug" } ,notes = "searchDEFAULT")
    @RequestMapping(method= RequestMethod.POST , value="/emeqdebugs/searchdefault")
	public ResponseEntity<Page<EMEQDebugDTO>> searchDefault(@RequestBody EMEQDebugSearchContext context) {
        Page<EMEQDebug> domains = emeqdebugService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emeqdebugMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
    @PreAuthorize("hasPermission(#emeqdebug_id,'Get',{'Sql',this.emeqdebugMapping,this.permissionDTO})")
    @ApiOperation(value = "GetByEMEquip", tags = {"EMEQDebug" },  notes = "GetByEMEquip")
	@RequestMapping(method = RequestMethod.GET, value = "/emequips/{emequip_id}/emeqdebugs/{emeqdebug_id}")
    public ResponseEntity<EMEQDebugDTO> getByEMEquip(@PathVariable("emequip_id") String emequip_id, @PathVariable("emeqdebug_id") String emeqdebug_id) {
        EMEQDebug domain = emeqdebugService.get(emeqdebug_id);
        EMEQDebugDTO dto = emeqdebugMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('','Create',{'Sql',this.emeqdebugMapping,#emeqdebugdto})")
    @ApiOperation(value = "CreateByEMEquip", tags = {"EMEQDebug" },  notes = "CreateByEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/emequips/{emequip_id}/emeqdebugs")
    @Transactional
    public ResponseEntity<EMEQDebugDTO> createByEMEquip(@PathVariable("emequip_id") String emequip_id, @RequestBody EMEQDebugDTO emeqdebugdto) {
        EMEQDebug domain = emeqdebugMapping.toDomain(emeqdebugdto);
        domain.setEquipid(emequip_id);
		emeqdebugService.create(domain);
        EMEQDebugDTO dto = emeqdebugMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Create',{'Sql',this.emeqdebugMapping,#emeqdebugdtos})")
    @ApiOperation(value = "createBatchByEMEquip", tags = {"EMEQDebug" },  notes = "createBatchByEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/emequips/{emequip_id}/emeqdebugs/batch")
    public ResponseEntity<Boolean> createBatchByEMEquip(@PathVariable("emequip_id") String emequip_id, @RequestBody List<EMEQDebugDTO> emeqdebugdtos) {
        List<EMEQDebug> domainlist=emeqdebugMapping.toDomain(emeqdebugdtos);
        for(EMEQDebug domain:domainlist){
            domain.setEquipid(emequip_id);
        }
        emeqdebugService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission('','Save',{'Sql',this.emeqdebugMapping,#emeqdebugdto})")
    @ApiOperation(value = "SaveByEMEquip", tags = {"EMEQDebug" },  notes = "SaveByEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/emequips/{emequip_id}/emeqdebugs/save")
    public ResponseEntity<Boolean> saveByEMEquip(@PathVariable("emequip_id") String emequip_id, @RequestBody EMEQDebugDTO emeqdebugdto) {
        EMEQDebug domain = emeqdebugMapping.toDomain(emeqdebugdto);
        domain.setEquipid(emequip_id);
        return ResponseEntity.status(HttpStatus.OK).body(emeqdebugService.save(domain));
    }

    @PreAuthorize("hasPermission('Save',{'Sql',this.emeqdebugMapping,#emeqdebugdtos})")
    @ApiOperation(value = "SaveBatchByEMEquip", tags = {"EMEQDebug" },  notes = "SaveBatchByEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/emequips/{emequip_id}/emeqdebugs/savebatch")
    public ResponseEntity<Boolean> saveBatchByEMEquip(@PathVariable("emequip_id") String emequip_id, @RequestBody List<EMEQDebugDTO> emeqdebugdtos) {
        List<EMEQDebug> domainlist=emeqdebugMapping.toDomain(emeqdebugdtos);
        for(EMEQDebug domain:domainlist){
             domain.setEquipid(emequip_id);
        }
        emeqdebugService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(#emeqdebug_id,'Remove',{'Sql',this.emeqdebugMapping,this.permissionDTO})")
    @ApiOperation(value = "RemoveByEMEquip", tags = {"EMEQDebug" },  notes = "RemoveByEMEquip")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emequips/{emequip_id}/emeqdebugs/{emeqdebug_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByEMEquip(@PathVariable("emequip_id") String emequip_id, @PathVariable("emeqdebug_id") String emeqdebug_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emeqdebugService.remove(emeqdebug_id));
    }

    @PreAuthorize("hasPermission('Remove',{'Sql',this.emeqdebugMapping,this.permissionDTO,#ids})")
    @ApiOperation(value = "RemoveBatchByEMEquip", tags = {"EMEQDebug" },  notes = "RemoveBatchByEMEquip")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emequips/{emequip_id}/emeqdebugs/batch")
    public ResponseEntity<Boolean> removeBatchByEMEquip(@RequestBody List<String> ids) {
        emeqdebugService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMEQDebug-GetDraft-all')")
    @ApiOperation(value = "GetDraftByEMEquip", tags = {"EMEQDebug" },  notes = "GetDraftByEMEquip")
    @RequestMapping(method = RequestMethod.GET, value = "/emequips/{emequip_id}/emeqdebugs/getdraft")
    public ResponseEntity<EMEQDebugDTO> getDraftByEMEquip(@PathVariable("emequip_id") String emequip_id) {
        EMEQDebug domain = new EMEQDebug();
        domain.setEquipid(emequip_id);
        return ResponseEntity.status(HttpStatus.OK).body(emeqdebugMapping.toDto(emeqdebugService.getDraft(domain)));
    }

    @PreAuthorize("hasPermission(#emeqdebug_id,'Update',{'Sql',this.emeqdebugMapping,#emeqdebugdto})")
    @ApiOperation(value = "UpdateByEMEquip", tags = {"EMEQDebug" },  notes = "UpdateByEMEquip")
	@RequestMapping(method = RequestMethod.PUT, value = "/emequips/{emequip_id}/emeqdebugs/{emeqdebug_id}")
    @Transactional
    public ResponseEntity<EMEQDebugDTO> updateByEMEquip(@PathVariable("emequip_id") String emequip_id, @PathVariable("emeqdebug_id") String emeqdebug_id, @RequestBody EMEQDebugDTO emeqdebugdto) {
        EMEQDebug domain = emeqdebugMapping.toDomain(emeqdebugdto);
        domain.setEquipid(emequip_id);
        domain.setEmeqdebugid(emeqdebug_id);
		emeqdebugService.update(domain);
        EMEQDebugDTO dto = emeqdebugMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Update',{'Sql',this.emeqdebugMapping,#emeqdebugdtos})")
    @ApiOperation(value = "UpdateBatchByEMEquip", tags = {"EMEQDebug" },  notes = "UpdateBatchByEMEquip")
	@RequestMapping(method = RequestMethod.PUT, value = "/emequips/{emequip_id}/emeqdebugs/batch")
    public ResponseEntity<Boolean> updateBatchByEMEquip(@PathVariable("emequip_id") String emequip_id, @RequestBody List<EMEQDebugDTO> emeqdebugdtos) {
        List<EMEQDebug> domainlist=emeqdebugMapping.toDomain(emeqdebugdtos);
        for(EMEQDebug domain:domainlist){
            domain.setEquipid(emequip_id);
        }
        emeqdebugService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMEQDebug-CheckKey-all')")
    @ApiOperation(value = "CheckKeyByEMEquip", tags = {"EMEQDebug" },  notes = "CheckKeyByEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/emequips/{emequip_id}/emeqdebugs/checkkey")
    public ResponseEntity<Boolean> checkKeyByEMEquip(@PathVariable("emequip_id") String emequip_id, @RequestBody EMEQDebugDTO emeqdebugdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emeqdebugService.checkKey(emeqdebugMapping.toDomain(emeqdebugdto)));
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMEQDebug-Default-all')")
	@ApiOperation(value = "fetchDEFAULTByEMEquip", tags = {"EMEQDebug" } ,notes = "fetchDEFAULTByEMEquip")
    @RequestMapping(method= RequestMethod.GET , value="/emequips/{emequip_id}/emeqdebugs/fetchdefault")
	public ResponseEntity<List<EMEQDebugDTO>> fetchEMEQDebugDefaultByEMEquip(@PathVariable("emequip_id") String emequip_id,EMEQDebugSearchContext context) {
        context.setN_equipid_eq(emequip_id);
        Page<EMEQDebug> domains = emeqdebugService.searchDefault(context) ;
        List<EMEQDebugDTO> list = emeqdebugMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMEQDebug-Default-all')")
	@ApiOperation(value = "searchDEFAULTByEMEquip", tags = {"EMEQDebug" } ,notes = "searchDEFAULTByEMEquip")
    @RequestMapping(method= RequestMethod.POST , value="/emequips/{emequip_id}/emeqdebugs/searchdefault")
	public ResponseEntity<Page<EMEQDebugDTO>> searchEMEQDebugDefaultByEMEquip(@PathVariable("emequip_id") String emequip_id, @RequestBody EMEQDebugSearchContext context) {
        context.setN_equipid_eq(emequip_id);
        Page<EMEQDebug> domains = emeqdebugService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emeqdebugMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
    @PreAuthorize("hasPermission(#emeqdebug_id,'Get',{'Sql',this.emeqdebugMapping,this.permissionDTO})")
    @ApiOperation(value = "GetByEMEQTypeEMEquip", tags = {"EMEQDebug" },  notes = "GetByEMEQTypeEMEquip")
	@RequestMapping(method = RequestMethod.GET, value = "/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emeqdebugs/{emeqdebug_id}")
    public ResponseEntity<EMEQDebugDTO> getByEMEQTypeEMEquip(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id, @PathVariable("emeqdebug_id") String emeqdebug_id) {
        EMEQDebug domain = emeqdebugService.get(emeqdebug_id);
        EMEQDebugDTO dto = emeqdebugMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('','Create',{'Sql',this.emeqdebugMapping,#emeqdebugdto})")
    @ApiOperation(value = "CreateByEMEQTypeEMEquip", tags = {"EMEQDebug" },  notes = "CreateByEMEQTypeEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emeqdebugs")
    @Transactional
    public ResponseEntity<EMEQDebugDTO> createByEMEQTypeEMEquip(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id, @RequestBody EMEQDebugDTO emeqdebugdto) {
        EMEQDebug domain = emeqdebugMapping.toDomain(emeqdebugdto);
        domain.setEquipid(emequip_id);
		emeqdebugService.create(domain);
        EMEQDebugDTO dto = emeqdebugMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Create',{'Sql',this.emeqdebugMapping,#emeqdebugdtos})")
    @ApiOperation(value = "createBatchByEMEQTypeEMEquip", tags = {"EMEQDebug" },  notes = "createBatchByEMEQTypeEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emeqdebugs/batch")
    public ResponseEntity<Boolean> createBatchByEMEQTypeEMEquip(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id, @RequestBody List<EMEQDebugDTO> emeqdebugdtos) {
        List<EMEQDebug> domainlist=emeqdebugMapping.toDomain(emeqdebugdtos);
        for(EMEQDebug domain:domainlist){
            domain.setEquipid(emequip_id);
        }
        emeqdebugService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission('','Save',{'Sql',this.emeqdebugMapping,#emeqdebugdto})")
    @ApiOperation(value = "SaveByEMEQTypeEMEquip", tags = {"EMEQDebug" },  notes = "SaveByEMEQTypeEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emeqdebugs/save")
    public ResponseEntity<Boolean> saveByEMEQTypeEMEquip(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id, @RequestBody EMEQDebugDTO emeqdebugdto) {
        EMEQDebug domain = emeqdebugMapping.toDomain(emeqdebugdto);
        domain.setEquipid(emequip_id);
        return ResponseEntity.status(HttpStatus.OK).body(emeqdebugService.save(domain));
    }

    @PreAuthorize("hasPermission('Save',{'Sql',this.emeqdebugMapping,#emeqdebugdtos})")
    @ApiOperation(value = "SaveBatchByEMEQTypeEMEquip", tags = {"EMEQDebug" },  notes = "SaveBatchByEMEQTypeEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emeqdebugs/savebatch")
    public ResponseEntity<Boolean> saveBatchByEMEQTypeEMEquip(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id, @RequestBody List<EMEQDebugDTO> emeqdebugdtos) {
        List<EMEQDebug> domainlist=emeqdebugMapping.toDomain(emeqdebugdtos);
        for(EMEQDebug domain:domainlist){
             domain.setEquipid(emequip_id);
        }
        emeqdebugService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(#emeqdebug_id,'Remove',{'Sql',this.emeqdebugMapping,this.permissionDTO})")
    @ApiOperation(value = "RemoveByEMEQTypeEMEquip", tags = {"EMEQDebug" },  notes = "RemoveByEMEQTypeEMEquip")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emeqdebugs/{emeqdebug_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByEMEQTypeEMEquip(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id, @PathVariable("emeqdebug_id") String emeqdebug_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emeqdebugService.remove(emeqdebug_id));
    }

    @PreAuthorize("hasPermission('Remove',{'Sql',this.emeqdebugMapping,this.permissionDTO,#ids})")
    @ApiOperation(value = "RemoveBatchByEMEQTypeEMEquip", tags = {"EMEQDebug" },  notes = "RemoveBatchByEMEQTypeEMEquip")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emeqdebugs/batch")
    public ResponseEntity<Boolean> removeBatchByEMEQTypeEMEquip(@RequestBody List<String> ids) {
        emeqdebugService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMEQDebug-GetDraft-all')")
    @ApiOperation(value = "GetDraftByEMEQTypeEMEquip", tags = {"EMEQDebug" },  notes = "GetDraftByEMEQTypeEMEquip")
    @RequestMapping(method = RequestMethod.GET, value = "/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emeqdebugs/getdraft")
    public ResponseEntity<EMEQDebugDTO> getDraftByEMEQTypeEMEquip(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id) {
        EMEQDebug domain = new EMEQDebug();
        domain.setEquipid(emequip_id);
        return ResponseEntity.status(HttpStatus.OK).body(emeqdebugMapping.toDto(emeqdebugService.getDraft(domain)));
    }

    @PreAuthorize("hasPermission(#emeqdebug_id,'Update',{'Sql',this.emeqdebugMapping,#emeqdebugdto})")
    @ApiOperation(value = "UpdateByEMEQTypeEMEquip", tags = {"EMEQDebug" },  notes = "UpdateByEMEQTypeEMEquip")
	@RequestMapping(method = RequestMethod.PUT, value = "/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emeqdebugs/{emeqdebug_id}")
    @Transactional
    public ResponseEntity<EMEQDebugDTO> updateByEMEQTypeEMEquip(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id, @PathVariable("emeqdebug_id") String emeqdebug_id, @RequestBody EMEQDebugDTO emeqdebugdto) {
        EMEQDebug domain = emeqdebugMapping.toDomain(emeqdebugdto);
        domain.setEquipid(emequip_id);
        domain.setEmeqdebugid(emeqdebug_id);
		emeqdebugService.update(domain);
        EMEQDebugDTO dto = emeqdebugMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Update',{'Sql',this.emeqdebugMapping,#emeqdebugdtos})")
    @ApiOperation(value = "UpdateBatchByEMEQTypeEMEquip", tags = {"EMEQDebug" },  notes = "UpdateBatchByEMEQTypeEMEquip")
	@RequestMapping(method = RequestMethod.PUT, value = "/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emeqdebugs/batch")
    public ResponseEntity<Boolean> updateBatchByEMEQTypeEMEquip(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id, @RequestBody List<EMEQDebugDTO> emeqdebugdtos) {
        List<EMEQDebug> domainlist=emeqdebugMapping.toDomain(emeqdebugdtos);
        for(EMEQDebug domain:domainlist){
            domain.setEquipid(emequip_id);
        }
        emeqdebugService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMEQDebug-CheckKey-all')")
    @ApiOperation(value = "CheckKeyByEMEQTypeEMEquip", tags = {"EMEQDebug" },  notes = "CheckKeyByEMEQTypeEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emeqdebugs/checkkey")
    public ResponseEntity<Boolean> checkKeyByEMEQTypeEMEquip(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id, @RequestBody EMEQDebugDTO emeqdebugdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emeqdebugService.checkKey(emeqdebugMapping.toDomain(emeqdebugdto)));
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMEQDebug-Default-all')")
	@ApiOperation(value = "fetchDEFAULTByEMEQTypeEMEquip", tags = {"EMEQDebug" } ,notes = "fetchDEFAULTByEMEQTypeEMEquip")
    @RequestMapping(method= RequestMethod.GET , value="/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emeqdebugs/fetchdefault")
	public ResponseEntity<List<EMEQDebugDTO>> fetchEMEQDebugDefaultByEMEQTypeEMEquip(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id,EMEQDebugSearchContext context) {
        context.setN_equipid_eq(emequip_id);
        Page<EMEQDebug> domains = emeqdebugService.searchDefault(context) ;
        List<EMEQDebugDTO> list = emeqdebugMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMEQDebug-Default-all')")
	@ApiOperation(value = "searchDEFAULTByEMEQTypeEMEquip", tags = {"EMEQDebug" } ,notes = "searchDEFAULTByEMEQTypeEMEquip")
    @RequestMapping(method= RequestMethod.POST , value="/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emeqdebugs/searchdefault")
	public ResponseEntity<Page<EMEQDebugDTO>> searchEMEQDebugDefaultByEMEQTypeEMEquip(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id, @RequestBody EMEQDebugSearchContext context) {
        context.setN_equipid_eq(emequip_id);
        Page<EMEQDebug> domains = emeqdebugService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emeqdebugMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
    @PreAuthorize("hasPermission(#emeqdebug_id,'Get',{'Sql',this.emeqdebugMapping,this.permissionDTO})")
    @ApiOperation(value = "GetByPFTeamEMEquip", tags = {"EMEQDebug" },  notes = "GetByPFTeamEMEquip")
	@RequestMapping(method = RequestMethod.GET, value = "/pfteams/{pfteam_id}/emequips/{emequip_id}/emeqdebugs/{emeqdebug_id}")
    public ResponseEntity<EMEQDebugDTO> getByPFTeamEMEquip(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id, @PathVariable("emeqdebug_id") String emeqdebug_id) {
        EMEQDebug domain = emeqdebugService.get(emeqdebug_id);
        EMEQDebugDTO dto = emeqdebugMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('','Create',{'Sql',this.emeqdebugMapping,#emeqdebugdto})")
    @ApiOperation(value = "CreateByPFTeamEMEquip", tags = {"EMEQDebug" },  notes = "CreateByPFTeamEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/pfteams/{pfteam_id}/emequips/{emequip_id}/emeqdebugs")
    @Transactional
    public ResponseEntity<EMEQDebugDTO> createByPFTeamEMEquip(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id, @RequestBody EMEQDebugDTO emeqdebugdto) {
        EMEQDebug domain = emeqdebugMapping.toDomain(emeqdebugdto);
        domain.setEquipid(emequip_id);
		emeqdebugService.create(domain);
        EMEQDebugDTO dto = emeqdebugMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Create',{'Sql',this.emeqdebugMapping,#emeqdebugdtos})")
    @ApiOperation(value = "createBatchByPFTeamEMEquip", tags = {"EMEQDebug" },  notes = "createBatchByPFTeamEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/pfteams/{pfteam_id}/emequips/{emequip_id}/emeqdebugs/batch")
    public ResponseEntity<Boolean> createBatchByPFTeamEMEquip(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id, @RequestBody List<EMEQDebugDTO> emeqdebugdtos) {
        List<EMEQDebug> domainlist=emeqdebugMapping.toDomain(emeqdebugdtos);
        for(EMEQDebug domain:domainlist){
            domain.setEquipid(emequip_id);
        }
        emeqdebugService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission('','Save',{'Sql',this.emeqdebugMapping,#emeqdebugdto})")
    @ApiOperation(value = "SaveByPFTeamEMEquip", tags = {"EMEQDebug" },  notes = "SaveByPFTeamEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/pfteams/{pfteam_id}/emequips/{emequip_id}/emeqdebugs/save")
    public ResponseEntity<Boolean> saveByPFTeamEMEquip(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id, @RequestBody EMEQDebugDTO emeqdebugdto) {
        EMEQDebug domain = emeqdebugMapping.toDomain(emeqdebugdto);
        domain.setEquipid(emequip_id);
        return ResponseEntity.status(HttpStatus.OK).body(emeqdebugService.save(domain));
    }

    @PreAuthorize("hasPermission('Save',{'Sql',this.emeqdebugMapping,#emeqdebugdtos})")
    @ApiOperation(value = "SaveBatchByPFTeamEMEquip", tags = {"EMEQDebug" },  notes = "SaveBatchByPFTeamEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/pfteams/{pfteam_id}/emequips/{emequip_id}/emeqdebugs/savebatch")
    public ResponseEntity<Boolean> saveBatchByPFTeamEMEquip(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id, @RequestBody List<EMEQDebugDTO> emeqdebugdtos) {
        List<EMEQDebug> domainlist=emeqdebugMapping.toDomain(emeqdebugdtos);
        for(EMEQDebug domain:domainlist){
             domain.setEquipid(emequip_id);
        }
        emeqdebugService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(#emeqdebug_id,'Remove',{'Sql',this.emeqdebugMapping,this.permissionDTO})")
    @ApiOperation(value = "RemoveByPFTeamEMEquip", tags = {"EMEQDebug" },  notes = "RemoveByPFTeamEMEquip")
	@RequestMapping(method = RequestMethod.DELETE, value = "/pfteams/{pfteam_id}/emequips/{emequip_id}/emeqdebugs/{emeqdebug_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByPFTeamEMEquip(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id, @PathVariable("emeqdebug_id") String emeqdebug_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emeqdebugService.remove(emeqdebug_id));
    }

    @PreAuthorize("hasPermission('Remove',{'Sql',this.emeqdebugMapping,this.permissionDTO,#ids})")
    @ApiOperation(value = "RemoveBatchByPFTeamEMEquip", tags = {"EMEQDebug" },  notes = "RemoveBatchByPFTeamEMEquip")
	@RequestMapping(method = RequestMethod.DELETE, value = "/pfteams/{pfteam_id}/emequips/{emequip_id}/emeqdebugs/batch")
    public ResponseEntity<Boolean> removeBatchByPFTeamEMEquip(@RequestBody List<String> ids) {
        emeqdebugService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMEQDebug-GetDraft-all')")
    @ApiOperation(value = "GetDraftByPFTeamEMEquip", tags = {"EMEQDebug" },  notes = "GetDraftByPFTeamEMEquip")
    @RequestMapping(method = RequestMethod.GET, value = "/pfteams/{pfteam_id}/emequips/{emequip_id}/emeqdebugs/getdraft")
    public ResponseEntity<EMEQDebugDTO> getDraftByPFTeamEMEquip(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id) {
        EMEQDebug domain = new EMEQDebug();
        domain.setEquipid(emequip_id);
        return ResponseEntity.status(HttpStatus.OK).body(emeqdebugMapping.toDto(emeqdebugService.getDraft(domain)));
    }

    @PreAuthorize("hasPermission(#emeqdebug_id,'Update',{'Sql',this.emeqdebugMapping,#emeqdebugdto})")
    @ApiOperation(value = "UpdateByPFTeamEMEquip", tags = {"EMEQDebug" },  notes = "UpdateByPFTeamEMEquip")
	@RequestMapping(method = RequestMethod.PUT, value = "/pfteams/{pfteam_id}/emequips/{emequip_id}/emeqdebugs/{emeqdebug_id}")
    @Transactional
    public ResponseEntity<EMEQDebugDTO> updateByPFTeamEMEquip(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id, @PathVariable("emeqdebug_id") String emeqdebug_id, @RequestBody EMEQDebugDTO emeqdebugdto) {
        EMEQDebug domain = emeqdebugMapping.toDomain(emeqdebugdto);
        domain.setEquipid(emequip_id);
        domain.setEmeqdebugid(emeqdebug_id);
		emeqdebugService.update(domain);
        EMEQDebugDTO dto = emeqdebugMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Update',{'Sql',this.emeqdebugMapping,#emeqdebugdtos})")
    @ApiOperation(value = "UpdateBatchByPFTeamEMEquip", tags = {"EMEQDebug" },  notes = "UpdateBatchByPFTeamEMEquip")
	@RequestMapping(method = RequestMethod.PUT, value = "/pfteams/{pfteam_id}/emequips/{emequip_id}/emeqdebugs/batch")
    public ResponseEntity<Boolean> updateBatchByPFTeamEMEquip(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id, @RequestBody List<EMEQDebugDTO> emeqdebugdtos) {
        List<EMEQDebug> domainlist=emeqdebugMapping.toDomain(emeqdebugdtos);
        for(EMEQDebug domain:domainlist){
            domain.setEquipid(emequip_id);
        }
        emeqdebugService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMEQDebug-CheckKey-all')")
    @ApiOperation(value = "CheckKeyByPFTeamEMEquip", tags = {"EMEQDebug" },  notes = "CheckKeyByPFTeamEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/pfteams/{pfteam_id}/emequips/{emequip_id}/emeqdebugs/checkkey")
    public ResponseEntity<Boolean> checkKeyByPFTeamEMEquip(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id, @RequestBody EMEQDebugDTO emeqdebugdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emeqdebugService.checkKey(emeqdebugMapping.toDomain(emeqdebugdto)));
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMEQDebug-Default-all')")
	@ApiOperation(value = "fetchDEFAULTByPFTeamEMEquip", tags = {"EMEQDebug" } ,notes = "fetchDEFAULTByPFTeamEMEquip")
    @RequestMapping(method= RequestMethod.GET , value="/pfteams/{pfteam_id}/emequips/{emequip_id}/emeqdebugs/fetchdefault")
	public ResponseEntity<List<EMEQDebugDTO>> fetchEMEQDebugDefaultByPFTeamEMEquip(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id,EMEQDebugSearchContext context) {
        context.setN_equipid_eq(emequip_id);
        Page<EMEQDebug> domains = emeqdebugService.searchDefault(context) ;
        List<EMEQDebugDTO> list = emeqdebugMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMEQDebug-Default-all')")
	@ApiOperation(value = "searchDEFAULTByPFTeamEMEquip", tags = {"EMEQDebug" } ,notes = "searchDEFAULTByPFTeamEMEquip")
    @RequestMapping(method= RequestMethod.POST , value="/pfteams/{pfteam_id}/emequips/{emequip_id}/emeqdebugs/searchdefault")
	public ResponseEntity<Page<EMEQDebugDTO>> searchEMEQDebugDefaultByPFTeamEMEquip(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id, @RequestBody EMEQDebugSearchContext context) {
        context.setN_equipid_eq(emequip_id);
        Page<EMEQDebug> domains = emeqdebugService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emeqdebugMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
}
