package cn.ibizlab.eam.webapi.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;
import javax.servlet.ServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import cn.ibizlab.eam.webapi.dto.*;
import cn.ibizlab.eam.webapi.mapping.*;
import cn.ibizlab.eam.core.eam_core.domain.EMEN;
import cn.ibizlab.eam.core.eam_core.service.IEMENService;
import cn.ibizlab.eam.core.eam_core.filter.EMENSearchContext;

@Slf4j
@Api(tags = {"EMEN" })
@RestController("WebApi-emen")
@RequestMapping("")
public class EMENResource {

    @Autowired
    private IEMENService emenService;

    @Autowired
    @Lazy
    public EMENMapping emenMapping;

    public EMENDTO permissionDTO=new EMENDTO();

    @PreAuthorize("hasPermission('','Create',{'Sql',this.emenMapping,#emendto})")
    @ApiOperation(value = "Create", tags = {"EMEN" },  notes = "Create")
	@RequestMapping(method = RequestMethod.POST, value = "/emen")
    @Transactional
    public ResponseEntity<EMENDTO> create(@RequestBody EMENDTO emendto) {
        EMEN domain = emenMapping.toDomain(emendto);
		emenService.create(domain);
        EMENDTO dto = emenMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Create',{'Sql',this.emenMapping,#emendtos})")
    @ApiOperation(value = "createBatch", tags = {"EMEN" },  notes = "createBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emen/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<EMENDTO> emendtos) {
        emenService.createBatch(emenMapping.toDomain(emendtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission('','Save',{'Sql',this.emenMapping,#emendto})")
    @ApiOperation(value = "Save", tags = {"EMEN" },  notes = "Save")
	@RequestMapping(method = RequestMethod.POST, value = "/emen/save")
    public ResponseEntity<Boolean> save(@RequestBody EMENDTO emendto) {
        return ResponseEntity.status(HttpStatus.OK).body(emenService.save(emenMapping.toDomain(emendto)));
    }

    @PreAuthorize("hasPermission('Save',{'Sql',this.emenMapping,#emendtos})")
    @ApiOperation(value = "SaveBatch", tags = {"EMEN" },  notes = "SaveBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emen/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<EMENDTO> emendtos) {
        emenService.saveBatch(emenMapping.toDomain(emendtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMEN-CheckKey-all')")
    @ApiOperation(value = "CheckKey", tags = {"EMEN" },  notes = "CheckKey")
	@RequestMapping(method = RequestMethod.POST, value = "/emen/checkkey")
    public ResponseEntity<Boolean> checkKey(@RequestBody EMENDTO emendto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emenService.checkKey(emenMapping.toDomain(emendto)));
    }

    @PreAuthorize("hasPermission(#emen_id,'Remove',{'Sql',this.emenMapping,this.permissionDTO})")
    @ApiOperation(value = "Remove", tags = {"EMEN" },  notes = "Remove")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emen/{emen_id}")
    @Transactional
    public ResponseEntity<Boolean> remove(@PathVariable("emen_id") String emen_id) {
         return ResponseEntity.status(HttpStatus.OK).body(emenService.remove(emen_id));
    }

    @PreAuthorize("hasPermission('Remove',{'Sql',this.emenMapping,this.permissionDTO,#ids})")
    @ApiOperation(value = "RemoveBatch", tags = {"EMEN" },  notes = "RemoveBatch")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emen/batch")
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        emenService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMEN-GetDraft-all')")
    @ApiOperation(value = "GetDraft", tags = {"EMEN" },  notes = "GetDraft")
	@RequestMapping(method = RequestMethod.GET, value = "/emen/getdraft")
    public ResponseEntity<EMENDTO> getDraft() {
        return ResponseEntity.status(HttpStatus.OK).body(emenMapping.toDto(emenService.getDraft(new EMEN())));
    }

    @PreAuthorize("hasPermission(#emen_id,'Get',{'Sql',this.emenMapping,this.permissionDTO})")
    @ApiOperation(value = "Get", tags = {"EMEN" },  notes = "Get")
	@RequestMapping(method = RequestMethod.GET, value = "/emen/{emen_id}")
    public ResponseEntity<EMENDTO> get(@PathVariable("emen_id") String emen_id) {
        EMEN domain = emenService.get(emen_id);
        EMENDTO dto = emenMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(#emen_id,'Update',{'Sql',this.emenMapping,#emendto})")
    @ApiOperation(value = "Update", tags = {"EMEN" },  notes = "Update")
	@RequestMapping(method = RequestMethod.PUT, value = "/emen/{emen_id}")
    @Transactional
    public ResponseEntity<EMENDTO> update(@PathVariable("emen_id") String emen_id, @RequestBody EMENDTO emendto) {
		EMEN domain  = emenMapping.toDomain(emendto);
        domain .setEmenid(emen_id);
		emenService.update(domain );
		EMENDTO dto = emenMapping.toDto(domain );
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Update',{'Sql',this.emenMapping,#emendtos})")
    @ApiOperation(value = "UpdateBatch", tags = {"EMEN" },  notes = "UpdateBatch")
	@RequestMapping(method = RequestMethod.PUT, value = "/emen/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<EMENDTO> emendtos) {
        emenService.updateBatch(emenMapping.toDomain(emendtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMEN-Default-all')")
	@ApiOperation(value = "fetchDEFAULT", tags = {"EMEN" } ,notes = "fetchDEFAULT")
    @RequestMapping(method= RequestMethod.GET , value="/emen/fetchdefault")
	public ResponseEntity<List<EMENDTO>> fetchDefault(EMENSearchContext context) {
        Page<EMEN> domains = emenService.searchDefault(context) ;
        List<EMENDTO> list = emenMapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMEN-Default-all')")
	@ApiOperation(value = "searchDEFAULT", tags = {"EMEN" } ,notes = "searchDEFAULT")
    @RequestMapping(method= RequestMethod.POST , value="/emen/searchdefault")
	public ResponseEntity<Page<EMENDTO>> searchDefault(@RequestBody EMENSearchContext context) {
        Page<EMEN> domains = emenService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emenMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
    @PreAuthorize("hasPermission('','Create',{'Sql',this.emenMapping,#emendto})")
    @ApiOperation(value = "CreateByEMItem", tags = {"EMEN" },  notes = "CreateByEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emitems/{emitem_id}/emen")
    @Transactional
    public ResponseEntity<EMENDTO> createByEMItem(@PathVariable("emitem_id") String emitem_id, @RequestBody EMENDTO emendto) {
        EMEN domain = emenMapping.toDomain(emendto);
        domain.setItemid(emitem_id);
		emenService.create(domain);
        EMENDTO dto = emenMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Create',{'Sql',this.emenMapping,#emendtos})")
    @ApiOperation(value = "createBatchByEMItem", tags = {"EMEN" },  notes = "createBatchByEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emitems/{emitem_id}/emen/batch")
    public ResponseEntity<Boolean> createBatchByEMItem(@PathVariable("emitem_id") String emitem_id, @RequestBody List<EMENDTO> emendtos) {
        List<EMEN> domainlist=emenMapping.toDomain(emendtos);
        for(EMEN domain:domainlist){
            domain.setItemid(emitem_id);
        }
        emenService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission('','Save',{'Sql',this.emenMapping,#emendto})")
    @ApiOperation(value = "SaveByEMItem", tags = {"EMEN" },  notes = "SaveByEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emitems/{emitem_id}/emen/save")
    public ResponseEntity<Boolean> saveByEMItem(@PathVariable("emitem_id") String emitem_id, @RequestBody EMENDTO emendto) {
        EMEN domain = emenMapping.toDomain(emendto);
        domain.setItemid(emitem_id);
        return ResponseEntity.status(HttpStatus.OK).body(emenService.save(domain));
    }

    @PreAuthorize("hasPermission('Save',{'Sql',this.emenMapping,#emendtos})")
    @ApiOperation(value = "SaveBatchByEMItem", tags = {"EMEN" },  notes = "SaveBatchByEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emitems/{emitem_id}/emen/savebatch")
    public ResponseEntity<Boolean> saveBatchByEMItem(@PathVariable("emitem_id") String emitem_id, @RequestBody List<EMENDTO> emendtos) {
        List<EMEN> domainlist=emenMapping.toDomain(emendtos);
        for(EMEN domain:domainlist){
             domain.setItemid(emitem_id);
        }
        emenService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMEN-CheckKey-all')")
    @ApiOperation(value = "CheckKeyByEMItem", tags = {"EMEN" },  notes = "CheckKeyByEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emitems/{emitem_id}/emen/checkkey")
    public ResponseEntity<Boolean> checkKeyByEMItem(@PathVariable("emitem_id") String emitem_id, @RequestBody EMENDTO emendto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emenService.checkKey(emenMapping.toDomain(emendto)));
    }

    @PreAuthorize("hasPermission(#emen_id,'Remove',{'Sql',this.emenMapping,this.permissionDTO})")
    @ApiOperation(value = "RemoveByEMItem", tags = {"EMEN" },  notes = "RemoveByEMItem")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emitems/{emitem_id}/emen/{emen_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByEMItem(@PathVariable("emitem_id") String emitem_id, @PathVariable("emen_id") String emen_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emenService.remove(emen_id));
    }

    @PreAuthorize("hasPermission('Remove',{'Sql',this.emenMapping,this.permissionDTO,#ids})")
    @ApiOperation(value = "RemoveBatchByEMItem", tags = {"EMEN" },  notes = "RemoveBatchByEMItem")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emitems/{emitem_id}/emen/batch")
    public ResponseEntity<Boolean> removeBatchByEMItem(@RequestBody List<String> ids) {
        emenService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMEN-GetDraft-all')")
    @ApiOperation(value = "GetDraftByEMItem", tags = {"EMEN" },  notes = "GetDraftByEMItem")
    @RequestMapping(method = RequestMethod.GET, value = "/emitems/{emitem_id}/emen/getdraft")
    public ResponseEntity<EMENDTO> getDraftByEMItem(@PathVariable("emitem_id") String emitem_id) {
        EMEN domain = new EMEN();
        domain.setItemid(emitem_id);
        return ResponseEntity.status(HttpStatus.OK).body(emenMapping.toDto(emenService.getDraft(domain)));
    }

    @PreAuthorize("hasPermission(#emen_id,'Get',{'Sql',this.emenMapping,this.permissionDTO})")
    @ApiOperation(value = "GetByEMItem", tags = {"EMEN" },  notes = "GetByEMItem")
	@RequestMapping(method = RequestMethod.GET, value = "/emitems/{emitem_id}/emen/{emen_id}")
    public ResponseEntity<EMENDTO> getByEMItem(@PathVariable("emitem_id") String emitem_id, @PathVariable("emen_id") String emen_id) {
        EMEN domain = emenService.get(emen_id);
        EMENDTO dto = emenMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(#emen_id,'Update',{'Sql',this.emenMapping,#emendto})")
    @ApiOperation(value = "UpdateByEMItem", tags = {"EMEN" },  notes = "UpdateByEMItem")
	@RequestMapping(method = RequestMethod.PUT, value = "/emitems/{emitem_id}/emen/{emen_id}")
    @Transactional
    public ResponseEntity<EMENDTO> updateByEMItem(@PathVariable("emitem_id") String emitem_id, @PathVariable("emen_id") String emen_id, @RequestBody EMENDTO emendto) {
        EMEN domain = emenMapping.toDomain(emendto);
        domain.setItemid(emitem_id);
        domain.setEmenid(emen_id);
		emenService.update(domain);
        EMENDTO dto = emenMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Update',{'Sql',this.emenMapping,#emendtos})")
    @ApiOperation(value = "UpdateBatchByEMItem", tags = {"EMEN" },  notes = "UpdateBatchByEMItem")
	@RequestMapping(method = RequestMethod.PUT, value = "/emitems/{emitem_id}/emen/batch")
    public ResponseEntity<Boolean> updateBatchByEMItem(@PathVariable("emitem_id") String emitem_id, @RequestBody List<EMENDTO> emendtos) {
        List<EMEN> domainlist=emenMapping.toDomain(emendtos);
        for(EMEN domain:domainlist){
            domain.setItemid(emitem_id);
        }
        emenService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMEN-Default-all')")
	@ApiOperation(value = "fetchDEFAULTByEMItem", tags = {"EMEN" } ,notes = "fetchDEFAULTByEMItem")
    @RequestMapping(method= RequestMethod.GET , value="/emitems/{emitem_id}/emen/fetchdefault")
	public ResponseEntity<List<EMENDTO>> fetchEMENDefaultByEMItem(@PathVariable("emitem_id") String emitem_id,EMENSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMEN> domains = emenService.searchDefault(context) ;
        List<EMENDTO> list = emenMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMEN-Default-all')")
	@ApiOperation(value = "searchDEFAULTByEMItem", tags = {"EMEN" } ,notes = "searchDEFAULTByEMItem")
    @RequestMapping(method= RequestMethod.POST , value="/emitems/{emitem_id}/emen/searchdefault")
	public ResponseEntity<Page<EMENDTO>> searchEMENDefaultByEMItem(@PathVariable("emitem_id") String emitem_id, @RequestBody EMENSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMEN> domains = emenService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emenMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
    @PreAuthorize("hasPermission('','Create',{'Sql',this.emenMapping,#emendto})")
    @ApiOperation(value = "CreateByEMServiceEMItem", tags = {"EMEN" },  notes = "CreateByEMServiceEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emservices/{emservice_id}/emitems/{emitem_id}/emen")
    @Transactional
    public ResponseEntity<EMENDTO> createByEMServiceEMItem(@PathVariable("emservice_id") String emservice_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMENDTO emendto) {
        EMEN domain = emenMapping.toDomain(emendto);
        domain.setItemid(emitem_id);
		emenService.create(domain);
        EMENDTO dto = emenMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Create',{'Sql',this.emenMapping,#emendtos})")
    @ApiOperation(value = "createBatchByEMServiceEMItem", tags = {"EMEN" },  notes = "createBatchByEMServiceEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emservices/{emservice_id}/emitems/{emitem_id}/emen/batch")
    public ResponseEntity<Boolean> createBatchByEMServiceEMItem(@PathVariable("emservice_id") String emservice_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMENDTO> emendtos) {
        List<EMEN> domainlist=emenMapping.toDomain(emendtos);
        for(EMEN domain:domainlist){
            domain.setItemid(emitem_id);
        }
        emenService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission('','Save',{'Sql',this.emenMapping,#emendto})")
    @ApiOperation(value = "SaveByEMServiceEMItem", tags = {"EMEN" },  notes = "SaveByEMServiceEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emservices/{emservice_id}/emitems/{emitem_id}/emen/save")
    public ResponseEntity<Boolean> saveByEMServiceEMItem(@PathVariable("emservice_id") String emservice_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMENDTO emendto) {
        EMEN domain = emenMapping.toDomain(emendto);
        domain.setItemid(emitem_id);
        return ResponseEntity.status(HttpStatus.OK).body(emenService.save(domain));
    }

    @PreAuthorize("hasPermission('Save',{'Sql',this.emenMapping,#emendtos})")
    @ApiOperation(value = "SaveBatchByEMServiceEMItem", tags = {"EMEN" },  notes = "SaveBatchByEMServiceEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emservices/{emservice_id}/emitems/{emitem_id}/emen/savebatch")
    public ResponseEntity<Boolean> saveBatchByEMServiceEMItem(@PathVariable("emservice_id") String emservice_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMENDTO> emendtos) {
        List<EMEN> domainlist=emenMapping.toDomain(emendtos);
        for(EMEN domain:domainlist){
             domain.setItemid(emitem_id);
        }
        emenService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMEN-CheckKey-all')")
    @ApiOperation(value = "CheckKeyByEMServiceEMItem", tags = {"EMEN" },  notes = "CheckKeyByEMServiceEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emservices/{emservice_id}/emitems/{emitem_id}/emen/checkkey")
    public ResponseEntity<Boolean> checkKeyByEMServiceEMItem(@PathVariable("emservice_id") String emservice_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMENDTO emendto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emenService.checkKey(emenMapping.toDomain(emendto)));
    }

    @PreAuthorize("hasPermission(#emen_id,'Remove',{'Sql',this.emenMapping,this.permissionDTO})")
    @ApiOperation(value = "RemoveByEMServiceEMItem", tags = {"EMEN" },  notes = "RemoveByEMServiceEMItem")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emservices/{emservice_id}/emitems/{emitem_id}/emen/{emen_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByEMServiceEMItem(@PathVariable("emservice_id") String emservice_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emen_id") String emen_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emenService.remove(emen_id));
    }

    @PreAuthorize("hasPermission('Remove',{'Sql',this.emenMapping,this.permissionDTO,#ids})")
    @ApiOperation(value = "RemoveBatchByEMServiceEMItem", tags = {"EMEN" },  notes = "RemoveBatchByEMServiceEMItem")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emservices/{emservice_id}/emitems/{emitem_id}/emen/batch")
    public ResponseEntity<Boolean> removeBatchByEMServiceEMItem(@RequestBody List<String> ids) {
        emenService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMEN-GetDraft-all')")
    @ApiOperation(value = "GetDraftByEMServiceEMItem", tags = {"EMEN" },  notes = "GetDraftByEMServiceEMItem")
    @RequestMapping(method = RequestMethod.GET, value = "/emservices/{emservice_id}/emitems/{emitem_id}/emen/getdraft")
    public ResponseEntity<EMENDTO> getDraftByEMServiceEMItem(@PathVariable("emservice_id") String emservice_id, @PathVariable("emitem_id") String emitem_id) {
        EMEN domain = new EMEN();
        domain.setItemid(emitem_id);
        return ResponseEntity.status(HttpStatus.OK).body(emenMapping.toDto(emenService.getDraft(domain)));
    }

    @PreAuthorize("hasPermission(#emen_id,'Get',{'Sql',this.emenMapping,this.permissionDTO})")
    @ApiOperation(value = "GetByEMServiceEMItem", tags = {"EMEN" },  notes = "GetByEMServiceEMItem")
	@RequestMapping(method = RequestMethod.GET, value = "/emservices/{emservice_id}/emitems/{emitem_id}/emen/{emen_id}")
    public ResponseEntity<EMENDTO> getByEMServiceEMItem(@PathVariable("emservice_id") String emservice_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emen_id") String emen_id) {
        EMEN domain = emenService.get(emen_id);
        EMENDTO dto = emenMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(#emen_id,'Update',{'Sql',this.emenMapping,#emendto})")
    @ApiOperation(value = "UpdateByEMServiceEMItem", tags = {"EMEN" },  notes = "UpdateByEMServiceEMItem")
	@RequestMapping(method = RequestMethod.PUT, value = "/emservices/{emservice_id}/emitems/{emitem_id}/emen/{emen_id}")
    @Transactional
    public ResponseEntity<EMENDTO> updateByEMServiceEMItem(@PathVariable("emservice_id") String emservice_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emen_id") String emen_id, @RequestBody EMENDTO emendto) {
        EMEN domain = emenMapping.toDomain(emendto);
        domain.setItemid(emitem_id);
        domain.setEmenid(emen_id);
		emenService.update(domain);
        EMENDTO dto = emenMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Update',{'Sql',this.emenMapping,#emendtos})")
    @ApiOperation(value = "UpdateBatchByEMServiceEMItem", tags = {"EMEN" },  notes = "UpdateBatchByEMServiceEMItem")
	@RequestMapping(method = RequestMethod.PUT, value = "/emservices/{emservice_id}/emitems/{emitem_id}/emen/batch")
    public ResponseEntity<Boolean> updateBatchByEMServiceEMItem(@PathVariable("emservice_id") String emservice_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMENDTO> emendtos) {
        List<EMEN> domainlist=emenMapping.toDomain(emendtos);
        for(EMEN domain:domainlist){
            domain.setItemid(emitem_id);
        }
        emenService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMEN-Default-all')")
	@ApiOperation(value = "fetchDEFAULTByEMServiceEMItem", tags = {"EMEN" } ,notes = "fetchDEFAULTByEMServiceEMItem")
    @RequestMapping(method= RequestMethod.GET , value="/emservices/{emservice_id}/emitems/{emitem_id}/emen/fetchdefault")
	public ResponseEntity<List<EMENDTO>> fetchEMENDefaultByEMServiceEMItem(@PathVariable("emservice_id") String emservice_id, @PathVariable("emitem_id") String emitem_id,EMENSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMEN> domains = emenService.searchDefault(context) ;
        List<EMENDTO> list = emenMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMEN-Default-all')")
	@ApiOperation(value = "searchDEFAULTByEMServiceEMItem", tags = {"EMEN" } ,notes = "searchDEFAULTByEMServiceEMItem")
    @RequestMapping(method= RequestMethod.POST , value="/emservices/{emservice_id}/emitems/{emitem_id}/emen/searchdefault")
	public ResponseEntity<Page<EMENDTO>> searchEMENDefaultByEMServiceEMItem(@PathVariable("emservice_id") String emservice_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMENSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMEN> domains = emenService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emenMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
    @PreAuthorize("hasPermission('','Create',{'Sql',this.emenMapping,#emendto})")
    @ApiOperation(value = "CreateByEMStorePartEMItem", tags = {"EMEN" },  notes = "CreateByEMStorePartEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emen")
    @Transactional
    public ResponseEntity<EMENDTO> createByEMStorePartEMItem(@PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMENDTO emendto) {
        EMEN domain = emenMapping.toDomain(emendto);
        domain.setItemid(emitem_id);
		emenService.create(domain);
        EMENDTO dto = emenMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Create',{'Sql',this.emenMapping,#emendtos})")
    @ApiOperation(value = "createBatchByEMStorePartEMItem", tags = {"EMEN" },  notes = "createBatchByEMStorePartEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emen/batch")
    public ResponseEntity<Boolean> createBatchByEMStorePartEMItem(@PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMENDTO> emendtos) {
        List<EMEN> domainlist=emenMapping.toDomain(emendtos);
        for(EMEN domain:domainlist){
            domain.setItemid(emitem_id);
        }
        emenService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission('','Save',{'Sql',this.emenMapping,#emendto})")
    @ApiOperation(value = "SaveByEMStorePartEMItem", tags = {"EMEN" },  notes = "SaveByEMStorePartEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emen/save")
    public ResponseEntity<Boolean> saveByEMStorePartEMItem(@PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMENDTO emendto) {
        EMEN domain = emenMapping.toDomain(emendto);
        domain.setItemid(emitem_id);
        return ResponseEntity.status(HttpStatus.OK).body(emenService.save(domain));
    }

    @PreAuthorize("hasPermission('Save',{'Sql',this.emenMapping,#emendtos})")
    @ApiOperation(value = "SaveBatchByEMStorePartEMItem", tags = {"EMEN" },  notes = "SaveBatchByEMStorePartEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emen/savebatch")
    public ResponseEntity<Boolean> saveBatchByEMStorePartEMItem(@PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMENDTO> emendtos) {
        List<EMEN> domainlist=emenMapping.toDomain(emendtos);
        for(EMEN domain:domainlist){
             domain.setItemid(emitem_id);
        }
        emenService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMEN-CheckKey-all')")
    @ApiOperation(value = "CheckKeyByEMStorePartEMItem", tags = {"EMEN" },  notes = "CheckKeyByEMStorePartEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emen/checkkey")
    public ResponseEntity<Boolean> checkKeyByEMStorePartEMItem(@PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMENDTO emendto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emenService.checkKey(emenMapping.toDomain(emendto)));
    }

    @PreAuthorize("hasPermission(#emen_id,'Remove',{'Sql',this.emenMapping,this.permissionDTO})")
    @ApiOperation(value = "RemoveByEMStorePartEMItem", tags = {"EMEN" },  notes = "RemoveByEMStorePartEMItem")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emen/{emen_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByEMStorePartEMItem(@PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emen_id") String emen_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emenService.remove(emen_id));
    }

    @PreAuthorize("hasPermission('Remove',{'Sql',this.emenMapping,this.permissionDTO,#ids})")
    @ApiOperation(value = "RemoveBatchByEMStorePartEMItem", tags = {"EMEN" },  notes = "RemoveBatchByEMStorePartEMItem")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emen/batch")
    public ResponseEntity<Boolean> removeBatchByEMStorePartEMItem(@RequestBody List<String> ids) {
        emenService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMEN-GetDraft-all')")
    @ApiOperation(value = "GetDraftByEMStorePartEMItem", tags = {"EMEN" },  notes = "GetDraftByEMStorePartEMItem")
    @RequestMapping(method = RequestMethod.GET, value = "/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emen/getdraft")
    public ResponseEntity<EMENDTO> getDraftByEMStorePartEMItem(@PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id) {
        EMEN domain = new EMEN();
        domain.setItemid(emitem_id);
        return ResponseEntity.status(HttpStatus.OK).body(emenMapping.toDto(emenService.getDraft(domain)));
    }

    @PreAuthorize("hasPermission(#emen_id,'Get',{'Sql',this.emenMapping,this.permissionDTO})")
    @ApiOperation(value = "GetByEMStorePartEMItem", tags = {"EMEN" },  notes = "GetByEMStorePartEMItem")
	@RequestMapping(method = RequestMethod.GET, value = "/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emen/{emen_id}")
    public ResponseEntity<EMENDTO> getByEMStorePartEMItem(@PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emen_id") String emen_id) {
        EMEN domain = emenService.get(emen_id);
        EMENDTO dto = emenMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(#emen_id,'Update',{'Sql',this.emenMapping,#emendto})")
    @ApiOperation(value = "UpdateByEMStorePartEMItem", tags = {"EMEN" },  notes = "UpdateByEMStorePartEMItem")
	@RequestMapping(method = RequestMethod.PUT, value = "/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emen/{emen_id}")
    @Transactional
    public ResponseEntity<EMENDTO> updateByEMStorePartEMItem(@PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emen_id") String emen_id, @RequestBody EMENDTO emendto) {
        EMEN domain = emenMapping.toDomain(emendto);
        domain.setItemid(emitem_id);
        domain.setEmenid(emen_id);
		emenService.update(domain);
        EMENDTO dto = emenMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Update',{'Sql',this.emenMapping,#emendtos})")
    @ApiOperation(value = "UpdateBatchByEMStorePartEMItem", tags = {"EMEN" },  notes = "UpdateBatchByEMStorePartEMItem")
	@RequestMapping(method = RequestMethod.PUT, value = "/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emen/batch")
    public ResponseEntity<Boolean> updateBatchByEMStorePartEMItem(@PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMENDTO> emendtos) {
        List<EMEN> domainlist=emenMapping.toDomain(emendtos);
        for(EMEN domain:domainlist){
            domain.setItemid(emitem_id);
        }
        emenService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMEN-Default-all')")
	@ApiOperation(value = "fetchDEFAULTByEMStorePartEMItem", tags = {"EMEN" } ,notes = "fetchDEFAULTByEMStorePartEMItem")
    @RequestMapping(method= RequestMethod.GET , value="/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emen/fetchdefault")
	public ResponseEntity<List<EMENDTO>> fetchEMENDefaultByEMStorePartEMItem(@PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id,EMENSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMEN> domains = emenService.searchDefault(context) ;
        List<EMENDTO> list = emenMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMEN-Default-all')")
	@ApiOperation(value = "searchDEFAULTByEMStorePartEMItem", tags = {"EMEN" } ,notes = "searchDEFAULTByEMStorePartEMItem")
    @RequestMapping(method= RequestMethod.POST , value="/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emen/searchdefault")
	public ResponseEntity<Page<EMENDTO>> searchEMENDefaultByEMStorePartEMItem(@PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMENSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMEN> domains = emenService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emenMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
    @PreAuthorize("hasPermission('','Create',{'Sql',this.emenMapping,#emendto})")
    @ApiOperation(value = "CreateByEMStoreEMItem", tags = {"EMEN" },  notes = "CreateByEMStoreEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emstores/{emstore_id}/emitems/{emitem_id}/emen")
    @Transactional
    public ResponseEntity<EMENDTO> createByEMStoreEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMENDTO emendto) {
        EMEN domain = emenMapping.toDomain(emendto);
        domain.setItemid(emitem_id);
		emenService.create(domain);
        EMENDTO dto = emenMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Create',{'Sql',this.emenMapping,#emendtos})")
    @ApiOperation(value = "createBatchByEMStoreEMItem", tags = {"EMEN" },  notes = "createBatchByEMStoreEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emstores/{emstore_id}/emitems/{emitem_id}/emen/batch")
    public ResponseEntity<Boolean> createBatchByEMStoreEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMENDTO> emendtos) {
        List<EMEN> domainlist=emenMapping.toDomain(emendtos);
        for(EMEN domain:domainlist){
            domain.setItemid(emitem_id);
        }
        emenService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission('','Save',{'Sql',this.emenMapping,#emendto})")
    @ApiOperation(value = "SaveByEMStoreEMItem", tags = {"EMEN" },  notes = "SaveByEMStoreEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emstores/{emstore_id}/emitems/{emitem_id}/emen/save")
    public ResponseEntity<Boolean> saveByEMStoreEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMENDTO emendto) {
        EMEN domain = emenMapping.toDomain(emendto);
        domain.setItemid(emitem_id);
        return ResponseEntity.status(HttpStatus.OK).body(emenService.save(domain));
    }

    @PreAuthorize("hasPermission('Save',{'Sql',this.emenMapping,#emendtos})")
    @ApiOperation(value = "SaveBatchByEMStoreEMItem", tags = {"EMEN" },  notes = "SaveBatchByEMStoreEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emstores/{emstore_id}/emitems/{emitem_id}/emen/savebatch")
    public ResponseEntity<Boolean> saveBatchByEMStoreEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMENDTO> emendtos) {
        List<EMEN> domainlist=emenMapping.toDomain(emendtos);
        for(EMEN domain:domainlist){
             domain.setItemid(emitem_id);
        }
        emenService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMEN-CheckKey-all')")
    @ApiOperation(value = "CheckKeyByEMStoreEMItem", tags = {"EMEN" },  notes = "CheckKeyByEMStoreEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emstores/{emstore_id}/emitems/{emitem_id}/emen/checkkey")
    public ResponseEntity<Boolean> checkKeyByEMStoreEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMENDTO emendto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emenService.checkKey(emenMapping.toDomain(emendto)));
    }

    @PreAuthorize("hasPermission(#emen_id,'Remove',{'Sql',this.emenMapping,this.permissionDTO})")
    @ApiOperation(value = "RemoveByEMStoreEMItem", tags = {"EMEN" },  notes = "RemoveByEMStoreEMItem")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emstores/{emstore_id}/emitems/{emitem_id}/emen/{emen_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByEMStoreEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emen_id") String emen_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emenService.remove(emen_id));
    }

    @PreAuthorize("hasPermission('Remove',{'Sql',this.emenMapping,this.permissionDTO,#ids})")
    @ApiOperation(value = "RemoveBatchByEMStoreEMItem", tags = {"EMEN" },  notes = "RemoveBatchByEMStoreEMItem")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emstores/{emstore_id}/emitems/{emitem_id}/emen/batch")
    public ResponseEntity<Boolean> removeBatchByEMStoreEMItem(@RequestBody List<String> ids) {
        emenService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMEN-GetDraft-all')")
    @ApiOperation(value = "GetDraftByEMStoreEMItem", tags = {"EMEN" },  notes = "GetDraftByEMStoreEMItem")
    @RequestMapping(method = RequestMethod.GET, value = "/emstores/{emstore_id}/emitems/{emitem_id}/emen/getdraft")
    public ResponseEntity<EMENDTO> getDraftByEMStoreEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emitem_id") String emitem_id) {
        EMEN domain = new EMEN();
        domain.setItemid(emitem_id);
        return ResponseEntity.status(HttpStatus.OK).body(emenMapping.toDto(emenService.getDraft(domain)));
    }

    @PreAuthorize("hasPermission(#emen_id,'Get',{'Sql',this.emenMapping,this.permissionDTO})")
    @ApiOperation(value = "GetByEMStoreEMItem", tags = {"EMEN" },  notes = "GetByEMStoreEMItem")
	@RequestMapping(method = RequestMethod.GET, value = "/emstores/{emstore_id}/emitems/{emitem_id}/emen/{emen_id}")
    public ResponseEntity<EMENDTO> getByEMStoreEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emen_id") String emen_id) {
        EMEN domain = emenService.get(emen_id);
        EMENDTO dto = emenMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(#emen_id,'Update',{'Sql',this.emenMapping,#emendto})")
    @ApiOperation(value = "UpdateByEMStoreEMItem", tags = {"EMEN" },  notes = "UpdateByEMStoreEMItem")
	@RequestMapping(method = RequestMethod.PUT, value = "/emstores/{emstore_id}/emitems/{emitem_id}/emen/{emen_id}")
    @Transactional
    public ResponseEntity<EMENDTO> updateByEMStoreEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emen_id") String emen_id, @RequestBody EMENDTO emendto) {
        EMEN domain = emenMapping.toDomain(emendto);
        domain.setItemid(emitem_id);
        domain.setEmenid(emen_id);
		emenService.update(domain);
        EMENDTO dto = emenMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Update',{'Sql',this.emenMapping,#emendtos})")
    @ApiOperation(value = "UpdateBatchByEMStoreEMItem", tags = {"EMEN" },  notes = "UpdateBatchByEMStoreEMItem")
	@RequestMapping(method = RequestMethod.PUT, value = "/emstores/{emstore_id}/emitems/{emitem_id}/emen/batch")
    public ResponseEntity<Boolean> updateBatchByEMStoreEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMENDTO> emendtos) {
        List<EMEN> domainlist=emenMapping.toDomain(emendtos);
        for(EMEN domain:domainlist){
            domain.setItemid(emitem_id);
        }
        emenService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMEN-Default-all')")
	@ApiOperation(value = "fetchDEFAULTByEMStoreEMItem", tags = {"EMEN" } ,notes = "fetchDEFAULTByEMStoreEMItem")
    @RequestMapping(method= RequestMethod.GET , value="/emstores/{emstore_id}/emitems/{emitem_id}/emen/fetchdefault")
	public ResponseEntity<List<EMENDTO>> fetchEMENDefaultByEMStoreEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emitem_id") String emitem_id,EMENSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMEN> domains = emenService.searchDefault(context) ;
        List<EMENDTO> list = emenMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMEN-Default-all')")
	@ApiOperation(value = "searchDEFAULTByEMStoreEMItem", tags = {"EMEN" } ,notes = "searchDEFAULTByEMStoreEMItem")
    @RequestMapping(method= RequestMethod.POST , value="/emstores/{emstore_id}/emitems/{emitem_id}/emen/searchdefault")
	public ResponseEntity<Page<EMENDTO>> searchEMENDefaultByEMStoreEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMENSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMEN> domains = emenService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emenMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
    @PreAuthorize("hasPermission('','Create',{'Sql',this.emenMapping,#emendto})")
    @ApiOperation(value = "CreateByPFEmpEMItem", tags = {"EMEN" },  notes = "CreateByPFEmpEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/pfemps/{pfemp_id}/emitems/{emitem_id}/emen")
    @Transactional
    public ResponseEntity<EMENDTO> createByPFEmpEMItem(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMENDTO emendto) {
        EMEN domain = emenMapping.toDomain(emendto);
        domain.setItemid(emitem_id);
		emenService.create(domain);
        EMENDTO dto = emenMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Create',{'Sql',this.emenMapping,#emendtos})")
    @ApiOperation(value = "createBatchByPFEmpEMItem", tags = {"EMEN" },  notes = "createBatchByPFEmpEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/pfemps/{pfemp_id}/emitems/{emitem_id}/emen/batch")
    public ResponseEntity<Boolean> createBatchByPFEmpEMItem(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMENDTO> emendtos) {
        List<EMEN> domainlist=emenMapping.toDomain(emendtos);
        for(EMEN domain:domainlist){
            domain.setItemid(emitem_id);
        }
        emenService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission('','Save',{'Sql',this.emenMapping,#emendto})")
    @ApiOperation(value = "SaveByPFEmpEMItem", tags = {"EMEN" },  notes = "SaveByPFEmpEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/pfemps/{pfemp_id}/emitems/{emitem_id}/emen/save")
    public ResponseEntity<Boolean> saveByPFEmpEMItem(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMENDTO emendto) {
        EMEN domain = emenMapping.toDomain(emendto);
        domain.setItemid(emitem_id);
        return ResponseEntity.status(HttpStatus.OK).body(emenService.save(domain));
    }

    @PreAuthorize("hasPermission('Save',{'Sql',this.emenMapping,#emendtos})")
    @ApiOperation(value = "SaveBatchByPFEmpEMItem", tags = {"EMEN" },  notes = "SaveBatchByPFEmpEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/pfemps/{pfemp_id}/emitems/{emitem_id}/emen/savebatch")
    public ResponseEntity<Boolean> saveBatchByPFEmpEMItem(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMENDTO> emendtos) {
        List<EMEN> domainlist=emenMapping.toDomain(emendtos);
        for(EMEN domain:domainlist){
             domain.setItemid(emitem_id);
        }
        emenService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMEN-CheckKey-all')")
    @ApiOperation(value = "CheckKeyByPFEmpEMItem", tags = {"EMEN" },  notes = "CheckKeyByPFEmpEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/pfemps/{pfemp_id}/emitems/{emitem_id}/emen/checkkey")
    public ResponseEntity<Boolean> checkKeyByPFEmpEMItem(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMENDTO emendto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emenService.checkKey(emenMapping.toDomain(emendto)));
    }

    @PreAuthorize("hasPermission(#emen_id,'Remove',{'Sql',this.emenMapping,this.permissionDTO})")
    @ApiOperation(value = "RemoveByPFEmpEMItem", tags = {"EMEN" },  notes = "RemoveByPFEmpEMItem")
	@RequestMapping(method = RequestMethod.DELETE, value = "/pfemps/{pfemp_id}/emitems/{emitem_id}/emen/{emen_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByPFEmpEMItem(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emen_id") String emen_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emenService.remove(emen_id));
    }

    @PreAuthorize("hasPermission('Remove',{'Sql',this.emenMapping,this.permissionDTO,#ids})")
    @ApiOperation(value = "RemoveBatchByPFEmpEMItem", tags = {"EMEN" },  notes = "RemoveBatchByPFEmpEMItem")
	@RequestMapping(method = RequestMethod.DELETE, value = "/pfemps/{pfemp_id}/emitems/{emitem_id}/emen/batch")
    public ResponseEntity<Boolean> removeBatchByPFEmpEMItem(@RequestBody List<String> ids) {
        emenService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMEN-GetDraft-all')")
    @ApiOperation(value = "GetDraftByPFEmpEMItem", tags = {"EMEN" },  notes = "GetDraftByPFEmpEMItem")
    @RequestMapping(method = RequestMethod.GET, value = "/pfemps/{pfemp_id}/emitems/{emitem_id}/emen/getdraft")
    public ResponseEntity<EMENDTO> getDraftByPFEmpEMItem(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emitem_id") String emitem_id) {
        EMEN domain = new EMEN();
        domain.setItemid(emitem_id);
        return ResponseEntity.status(HttpStatus.OK).body(emenMapping.toDto(emenService.getDraft(domain)));
    }

    @PreAuthorize("hasPermission(#emen_id,'Get',{'Sql',this.emenMapping,this.permissionDTO})")
    @ApiOperation(value = "GetByPFEmpEMItem", tags = {"EMEN" },  notes = "GetByPFEmpEMItem")
	@RequestMapping(method = RequestMethod.GET, value = "/pfemps/{pfemp_id}/emitems/{emitem_id}/emen/{emen_id}")
    public ResponseEntity<EMENDTO> getByPFEmpEMItem(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emen_id") String emen_id) {
        EMEN domain = emenService.get(emen_id);
        EMENDTO dto = emenMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(#emen_id,'Update',{'Sql',this.emenMapping,#emendto})")
    @ApiOperation(value = "UpdateByPFEmpEMItem", tags = {"EMEN" },  notes = "UpdateByPFEmpEMItem")
	@RequestMapping(method = RequestMethod.PUT, value = "/pfemps/{pfemp_id}/emitems/{emitem_id}/emen/{emen_id}")
    @Transactional
    public ResponseEntity<EMENDTO> updateByPFEmpEMItem(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emen_id") String emen_id, @RequestBody EMENDTO emendto) {
        EMEN domain = emenMapping.toDomain(emendto);
        domain.setItemid(emitem_id);
        domain.setEmenid(emen_id);
		emenService.update(domain);
        EMENDTO dto = emenMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Update',{'Sql',this.emenMapping,#emendtos})")
    @ApiOperation(value = "UpdateBatchByPFEmpEMItem", tags = {"EMEN" },  notes = "UpdateBatchByPFEmpEMItem")
	@RequestMapping(method = RequestMethod.PUT, value = "/pfemps/{pfemp_id}/emitems/{emitem_id}/emen/batch")
    public ResponseEntity<Boolean> updateBatchByPFEmpEMItem(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMENDTO> emendtos) {
        List<EMEN> domainlist=emenMapping.toDomain(emendtos);
        for(EMEN domain:domainlist){
            domain.setItemid(emitem_id);
        }
        emenService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMEN-Default-all')")
	@ApiOperation(value = "fetchDEFAULTByPFEmpEMItem", tags = {"EMEN" } ,notes = "fetchDEFAULTByPFEmpEMItem")
    @RequestMapping(method= RequestMethod.GET , value="/pfemps/{pfemp_id}/emitems/{emitem_id}/emen/fetchdefault")
	public ResponseEntity<List<EMENDTO>> fetchEMENDefaultByPFEmpEMItem(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emitem_id") String emitem_id,EMENSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMEN> domains = emenService.searchDefault(context) ;
        List<EMENDTO> list = emenMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMEN-Default-all')")
	@ApiOperation(value = "searchDEFAULTByPFEmpEMItem", tags = {"EMEN" } ,notes = "searchDEFAULTByPFEmpEMItem")
    @RequestMapping(method= RequestMethod.POST , value="/pfemps/{pfemp_id}/emitems/{emitem_id}/emen/searchdefault")
	public ResponseEntity<Page<EMENDTO>> searchEMENDefaultByPFEmpEMItem(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMENSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMEN> domains = emenService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emenMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
    @PreAuthorize("hasPermission('','Create',{'Sql',this.emenMapping,#emendto})")
    @ApiOperation(value = "CreateByPFUnitEMItem", tags = {"EMEN" },  notes = "CreateByPFUnitEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/pfunits/{pfunit_id}/emitems/{emitem_id}/emen")
    @Transactional
    public ResponseEntity<EMENDTO> createByPFUnitEMItem(@PathVariable("pfunit_id") String pfunit_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMENDTO emendto) {
        EMEN domain = emenMapping.toDomain(emendto);
        domain.setItemid(emitem_id);
		emenService.create(domain);
        EMENDTO dto = emenMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Create',{'Sql',this.emenMapping,#emendtos})")
    @ApiOperation(value = "createBatchByPFUnitEMItem", tags = {"EMEN" },  notes = "createBatchByPFUnitEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/pfunits/{pfunit_id}/emitems/{emitem_id}/emen/batch")
    public ResponseEntity<Boolean> createBatchByPFUnitEMItem(@PathVariable("pfunit_id") String pfunit_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMENDTO> emendtos) {
        List<EMEN> domainlist=emenMapping.toDomain(emendtos);
        for(EMEN domain:domainlist){
            domain.setItemid(emitem_id);
        }
        emenService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission('','Save',{'Sql',this.emenMapping,#emendto})")
    @ApiOperation(value = "SaveByPFUnitEMItem", tags = {"EMEN" },  notes = "SaveByPFUnitEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/pfunits/{pfunit_id}/emitems/{emitem_id}/emen/save")
    public ResponseEntity<Boolean> saveByPFUnitEMItem(@PathVariable("pfunit_id") String pfunit_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMENDTO emendto) {
        EMEN domain = emenMapping.toDomain(emendto);
        domain.setItemid(emitem_id);
        return ResponseEntity.status(HttpStatus.OK).body(emenService.save(domain));
    }

    @PreAuthorize("hasPermission('Save',{'Sql',this.emenMapping,#emendtos})")
    @ApiOperation(value = "SaveBatchByPFUnitEMItem", tags = {"EMEN" },  notes = "SaveBatchByPFUnitEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/pfunits/{pfunit_id}/emitems/{emitem_id}/emen/savebatch")
    public ResponseEntity<Boolean> saveBatchByPFUnitEMItem(@PathVariable("pfunit_id") String pfunit_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMENDTO> emendtos) {
        List<EMEN> domainlist=emenMapping.toDomain(emendtos);
        for(EMEN domain:domainlist){
             domain.setItemid(emitem_id);
        }
        emenService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMEN-CheckKey-all')")
    @ApiOperation(value = "CheckKeyByPFUnitEMItem", tags = {"EMEN" },  notes = "CheckKeyByPFUnitEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/pfunits/{pfunit_id}/emitems/{emitem_id}/emen/checkkey")
    public ResponseEntity<Boolean> checkKeyByPFUnitEMItem(@PathVariable("pfunit_id") String pfunit_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMENDTO emendto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emenService.checkKey(emenMapping.toDomain(emendto)));
    }

    @PreAuthorize("hasPermission(#emen_id,'Remove',{'Sql',this.emenMapping,this.permissionDTO})")
    @ApiOperation(value = "RemoveByPFUnitEMItem", tags = {"EMEN" },  notes = "RemoveByPFUnitEMItem")
	@RequestMapping(method = RequestMethod.DELETE, value = "/pfunits/{pfunit_id}/emitems/{emitem_id}/emen/{emen_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByPFUnitEMItem(@PathVariable("pfunit_id") String pfunit_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emen_id") String emen_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emenService.remove(emen_id));
    }

    @PreAuthorize("hasPermission('Remove',{'Sql',this.emenMapping,this.permissionDTO,#ids})")
    @ApiOperation(value = "RemoveBatchByPFUnitEMItem", tags = {"EMEN" },  notes = "RemoveBatchByPFUnitEMItem")
	@RequestMapping(method = RequestMethod.DELETE, value = "/pfunits/{pfunit_id}/emitems/{emitem_id}/emen/batch")
    public ResponseEntity<Boolean> removeBatchByPFUnitEMItem(@RequestBody List<String> ids) {
        emenService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMEN-GetDraft-all')")
    @ApiOperation(value = "GetDraftByPFUnitEMItem", tags = {"EMEN" },  notes = "GetDraftByPFUnitEMItem")
    @RequestMapping(method = RequestMethod.GET, value = "/pfunits/{pfunit_id}/emitems/{emitem_id}/emen/getdraft")
    public ResponseEntity<EMENDTO> getDraftByPFUnitEMItem(@PathVariable("pfunit_id") String pfunit_id, @PathVariable("emitem_id") String emitem_id) {
        EMEN domain = new EMEN();
        domain.setItemid(emitem_id);
        return ResponseEntity.status(HttpStatus.OK).body(emenMapping.toDto(emenService.getDraft(domain)));
    }

    @PreAuthorize("hasPermission(#emen_id,'Get',{'Sql',this.emenMapping,this.permissionDTO})")
    @ApiOperation(value = "GetByPFUnitEMItem", tags = {"EMEN" },  notes = "GetByPFUnitEMItem")
	@RequestMapping(method = RequestMethod.GET, value = "/pfunits/{pfunit_id}/emitems/{emitem_id}/emen/{emen_id}")
    public ResponseEntity<EMENDTO> getByPFUnitEMItem(@PathVariable("pfunit_id") String pfunit_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emen_id") String emen_id) {
        EMEN domain = emenService.get(emen_id);
        EMENDTO dto = emenMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(#emen_id,'Update',{'Sql',this.emenMapping,#emendto})")
    @ApiOperation(value = "UpdateByPFUnitEMItem", tags = {"EMEN" },  notes = "UpdateByPFUnitEMItem")
	@RequestMapping(method = RequestMethod.PUT, value = "/pfunits/{pfunit_id}/emitems/{emitem_id}/emen/{emen_id}")
    @Transactional
    public ResponseEntity<EMENDTO> updateByPFUnitEMItem(@PathVariable("pfunit_id") String pfunit_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emen_id") String emen_id, @RequestBody EMENDTO emendto) {
        EMEN domain = emenMapping.toDomain(emendto);
        domain.setItemid(emitem_id);
        domain.setEmenid(emen_id);
		emenService.update(domain);
        EMENDTO dto = emenMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Update',{'Sql',this.emenMapping,#emendtos})")
    @ApiOperation(value = "UpdateBatchByPFUnitEMItem", tags = {"EMEN" },  notes = "UpdateBatchByPFUnitEMItem")
	@RequestMapping(method = RequestMethod.PUT, value = "/pfunits/{pfunit_id}/emitems/{emitem_id}/emen/batch")
    public ResponseEntity<Boolean> updateBatchByPFUnitEMItem(@PathVariable("pfunit_id") String pfunit_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMENDTO> emendtos) {
        List<EMEN> domainlist=emenMapping.toDomain(emendtos);
        for(EMEN domain:domainlist){
            domain.setItemid(emitem_id);
        }
        emenService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMEN-Default-all')")
	@ApiOperation(value = "fetchDEFAULTByPFUnitEMItem", tags = {"EMEN" } ,notes = "fetchDEFAULTByPFUnitEMItem")
    @RequestMapping(method= RequestMethod.GET , value="/pfunits/{pfunit_id}/emitems/{emitem_id}/emen/fetchdefault")
	public ResponseEntity<List<EMENDTO>> fetchEMENDefaultByPFUnitEMItem(@PathVariable("pfunit_id") String pfunit_id, @PathVariable("emitem_id") String emitem_id,EMENSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMEN> domains = emenService.searchDefault(context) ;
        List<EMENDTO> list = emenMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMEN-Default-all')")
	@ApiOperation(value = "searchDEFAULTByPFUnitEMItem", tags = {"EMEN" } ,notes = "searchDEFAULTByPFUnitEMItem")
    @RequestMapping(method= RequestMethod.POST , value="/pfunits/{pfunit_id}/emitems/{emitem_id}/emen/searchdefault")
	public ResponseEntity<Page<EMENDTO>> searchEMENDefaultByPFUnitEMItem(@PathVariable("pfunit_id") String pfunit_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMENSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMEN> domains = emenService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emenMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
    @PreAuthorize("hasPermission('','Create',{'Sql',this.emenMapping,#emendto})")
    @ApiOperation(value = "CreateByEMStoreEMStorePartEMItem", tags = {"EMEN" },  notes = "CreateByEMStoreEMStorePartEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emen")
    @Transactional
    public ResponseEntity<EMENDTO> createByEMStoreEMStorePartEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMENDTO emendto) {
        EMEN domain = emenMapping.toDomain(emendto);
        domain.setItemid(emitem_id);
		emenService.create(domain);
        EMENDTO dto = emenMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Create',{'Sql',this.emenMapping,#emendtos})")
    @ApiOperation(value = "createBatchByEMStoreEMStorePartEMItem", tags = {"EMEN" },  notes = "createBatchByEMStoreEMStorePartEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emen/batch")
    public ResponseEntity<Boolean> createBatchByEMStoreEMStorePartEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMENDTO> emendtos) {
        List<EMEN> domainlist=emenMapping.toDomain(emendtos);
        for(EMEN domain:domainlist){
            domain.setItemid(emitem_id);
        }
        emenService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission('','Save',{'Sql',this.emenMapping,#emendto})")
    @ApiOperation(value = "SaveByEMStoreEMStorePartEMItem", tags = {"EMEN" },  notes = "SaveByEMStoreEMStorePartEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emen/save")
    public ResponseEntity<Boolean> saveByEMStoreEMStorePartEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMENDTO emendto) {
        EMEN domain = emenMapping.toDomain(emendto);
        domain.setItemid(emitem_id);
        return ResponseEntity.status(HttpStatus.OK).body(emenService.save(domain));
    }

    @PreAuthorize("hasPermission('Save',{'Sql',this.emenMapping,#emendtos})")
    @ApiOperation(value = "SaveBatchByEMStoreEMStorePartEMItem", tags = {"EMEN" },  notes = "SaveBatchByEMStoreEMStorePartEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emen/savebatch")
    public ResponseEntity<Boolean> saveBatchByEMStoreEMStorePartEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMENDTO> emendtos) {
        List<EMEN> domainlist=emenMapping.toDomain(emendtos);
        for(EMEN domain:domainlist){
             domain.setItemid(emitem_id);
        }
        emenService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMEN-CheckKey-all')")
    @ApiOperation(value = "CheckKeyByEMStoreEMStorePartEMItem", tags = {"EMEN" },  notes = "CheckKeyByEMStoreEMStorePartEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emen/checkkey")
    public ResponseEntity<Boolean> checkKeyByEMStoreEMStorePartEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMENDTO emendto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emenService.checkKey(emenMapping.toDomain(emendto)));
    }

    @PreAuthorize("hasPermission(#emen_id,'Remove',{'Sql',this.emenMapping,this.permissionDTO})")
    @ApiOperation(value = "RemoveByEMStoreEMStorePartEMItem", tags = {"EMEN" },  notes = "RemoveByEMStoreEMStorePartEMItem")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emen/{emen_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByEMStoreEMStorePartEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emen_id") String emen_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emenService.remove(emen_id));
    }

    @PreAuthorize("hasPermission('Remove',{'Sql',this.emenMapping,this.permissionDTO,#ids})")
    @ApiOperation(value = "RemoveBatchByEMStoreEMStorePartEMItem", tags = {"EMEN" },  notes = "RemoveBatchByEMStoreEMStorePartEMItem")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emen/batch")
    public ResponseEntity<Boolean> removeBatchByEMStoreEMStorePartEMItem(@RequestBody List<String> ids) {
        emenService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMEN-GetDraft-all')")
    @ApiOperation(value = "GetDraftByEMStoreEMStorePartEMItem", tags = {"EMEN" },  notes = "GetDraftByEMStoreEMStorePartEMItem")
    @RequestMapping(method = RequestMethod.GET, value = "/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emen/getdraft")
    public ResponseEntity<EMENDTO> getDraftByEMStoreEMStorePartEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id) {
        EMEN domain = new EMEN();
        domain.setItemid(emitem_id);
        return ResponseEntity.status(HttpStatus.OK).body(emenMapping.toDto(emenService.getDraft(domain)));
    }

    @PreAuthorize("hasPermission(#emen_id,'Get',{'Sql',this.emenMapping,this.permissionDTO})")
    @ApiOperation(value = "GetByEMStoreEMStorePartEMItem", tags = {"EMEN" },  notes = "GetByEMStoreEMStorePartEMItem")
	@RequestMapping(method = RequestMethod.GET, value = "/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emen/{emen_id}")
    public ResponseEntity<EMENDTO> getByEMStoreEMStorePartEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emen_id") String emen_id) {
        EMEN domain = emenService.get(emen_id);
        EMENDTO dto = emenMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(#emen_id,'Update',{'Sql',this.emenMapping,#emendto})")
    @ApiOperation(value = "UpdateByEMStoreEMStorePartEMItem", tags = {"EMEN" },  notes = "UpdateByEMStoreEMStorePartEMItem")
	@RequestMapping(method = RequestMethod.PUT, value = "/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emen/{emen_id}")
    @Transactional
    public ResponseEntity<EMENDTO> updateByEMStoreEMStorePartEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emen_id") String emen_id, @RequestBody EMENDTO emendto) {
        EMEN domain = emenMapping.toDomain(emendto);
        domain.setItemid(emitem_id);
        domain.setEmenid(emen_id);
		emenService.update(domain);
        EMENDTO dto = emenMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Update',{'Sql',this.emenMapping,#emendtos})")
    @ApiOperation(value = "UpdateBatchByEMStoreEMStorePartEMItem", tags = {"EMEN" },  notes = "UpdateBatchByEMStoreEMStorePartEMItem")
	@RequestMapping(method = RequestMethod.PUT, value = "/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emen/batch")
    public ResponseEntity<Boolean> updateBatchByEMStoreEMStorePartEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMENDTO> emendtos) {
        List<EMEN> domainlist=emenMapping.toDomain(emendtos);
        for(EMEN domain:domainlist){
            domain.setItemid(emitem_id);
        }
        emenService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMEN-Default-all')")
	@ApiOperation(value = "fetchDEFAULTByEMStoreEMStorePartEMItem", tags = {"EMEN" } ,notes = "fetchDEFAULTByEMStoreEMStorePartEMItem")
    @RequestMapping(method= RequestMethod.GET , value="/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emen/fetchdefault")
	public ResponseEntity<List<EMENDTO>> fetchEMENDefaultByEMStoreEMStorePartEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id,EMENSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMEN> domains = emenService.searchDefault(context) ;
        List<EMENDTO> list = emenMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMEN-Default-all')")
	@ApiOperation(value = "searchDEFAULTByEMStoreEMStorePartEMItem", tags = {"EMEN" } ,notes = "searchDEFAULTByEMStoreEMStorePartEMItem")
    @RequestMapping(method= RequestMethod.POST , value="/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emen/searchdefault")
	public ResponseEntity<Page<EMENDTO>> searchEMENDefaultByEMStoreEMStorePartEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMENSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMEN> domains = emenService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emenMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
}
