package cn.ibizlab.eam.webapi.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;
import javax.servlet.ServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import cn.ibizlab.eam.webapi.dto.*;
import cn.ibizlab.eam.webapi.mapping.*;
import cn.ibizlab.eam.core.eam_core.domain.EMEICell;
import cn.ibizlab.eam.core.eam_core.service.IEMEICellService;
import cn.ibizlab.eam.core.eam_core.filter.EMEICellSearchContext;

@Slf4j
@Api(tags = {"EMEICell" })
@RestController("WebApi-emeicell")
@RequestMapping("")
public class EMEICellResource {

    @Autowired
    private IEMEICellService emeicellService;

    @Autowired
    @Lazy
    public EMEICellMapping emeicellMapping;

    public EMEICellDTO permissionDTO=new EMEICellDTO();

    @PreAuthorize("hasPermission(#emeicell_id,'Remove',{'Sql',this.emeicellMapping,this.permissionDTO})")
    @ApiOperation(value = "Remove", tags = {"EMEICell" },  notes = "Remove")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emeicells/{emeicell_id}")
    @Transactional
    public ResponseEntity<Boolean> remove(@PathVariable("emeicell_id") String emeicell_id) {
         return ResponseEntity.status(HttpStatus.OK).body(emeicellService.remove(emeicell_id));
    }

    @PreAuthorize("hasPermission('Remove',{'Sql',this.emeicellMapping,this.permissionDTO,#ids})")
    @ApiOperation(value = "RemoveBatch", tags = {"EMEICell" },  notes = "RemoveBatch")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emeicells/batch")
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        emeicellService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(#emeicell_id,'Update',{'Sql',this.emeicellMapping,#emeicelldto})")
    @ApiOperation(value = "Update", tags = {"EMEICell" },  notes = "Update")
	@RequestMapping(method = RequestMethod.PUT, value = "/emeicells/{emeicell_id}")
    @Transactional
    public ResponseEntity<EMEICellDTO> update(@PathVariable("emeicell_id") String emeicell_id, @RequestBody EMEICellDTO emeicelldto) {
		EMEICell domain  = emeicellMapping.toDomain(emeicelldto);
        domain .setEmeicellid(emeicell_id);
		emeicellService.update(domain );
		EMEICellDTO dto = emeicellMapping.toDto(domain );
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Update',{'Sql',this.emeicellMapping,#emeicelldtos})")
    @ApiOperation(value = "UpdateBatch", tags = {"EMEICell" },  notes = "UpdateBatch")
	@RequestMapping(method = RequestMethod.PUT, value = "/emeicells/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<EMEICellDTO> emeicelldtos) {
        emeicellService.updateBatch(emeicellMapping.toDomain(emeicelldtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission('','Create',{'Sql',this.emeicellMapping,#emeicelldto})")
    @ApiOperation(value = "Create", tags = {"EMEICell" },  notes = "Create")
	@RequestMapping(method = RequestMethod.POST, value = "/emeicells")
    @Transactional
    public ResponseEntity<EMEICellDTO> create(@RequestBody EMEICellDTO emeicelldto) {
        EMEICell domain = emeicellMapping.toDomain(emeicelldto);
		emeicellService.create(domain);
        EMEICellDTO dto = emeicellMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Create',{'Sql',this.emeicellMapping,#emeicelldtos})")
    @ApiOperation(value = "createBatch", tags = {"EMEICell" },  notes = "createBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emeicells/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<EMEICellDTO> emeicelldtos) {
        emeicellService.createBatch(emeicellMapping.toDomain(emeicelldtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission('','Save',{'Sql',this.emeicellMapping,#emeicelldto})")
    @ApiOperation(value = "Save", tags = {"EMEICell" },  notes = "Save")
	@RequestMapping(method = RequestMethod.POST, value = "/emeicells/save")
    public ResponseEntity<Boolean> save(@RequestBody EMEICellDTO emeicelldto) {
        return ResponseEntity.status(HttpStatus.OK).body(emeicellService.save(emeicellMapping.toDomain(emeicelldto)));
    }

    @PreAuthorize("hasPermission('Save',{'Sql',this.emeicellMapping,#emeicelldtos})")
    @ApiOperation(value = "SaveBatch", tags = {"EMEICell" },  notes = "SaveBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emeicells/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<EMEICellDTO> emeicelldtos) {
        emeicellService.saveBatch(emeicellMapping.toDomain(emeicelldtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMEICell-GetDraft-all')")
    @ApiOperation(value = "GetDraft", tags = {"EMEICell" },  notes = "GetDraft")
	@RequestMapping(method = RequestMethod.GET, value = "/emeicells/getdraft")
    public ResponseEntity<EMEICellDTO> getDraft() {
        return ResponseEntity.status(HttpStatus.OK).body(emeicellMapping.toDto(emeicellService.getDraft(new EMEICell())));
    }

    @PreAuthorize("hasPermission(#emeicell_id,'Get',{'Sql',this.emeicellMapping,this.permissionDTO})")
    @ApiOperation(value = "Get", tags = {"EMEICell" },  notes = "Get")
	@RequestMapping(method = RequestMethod.GET, value = "/emeicells/{emeicell_id}")
    public ResponseEntity<EMEICellDTO> get(@PathVariable("emeicell_id") String emeicell_id) {
        EMEICell domain = emeicellService.get(emeicell_id);
        EMEICellDTO dto = emeicellMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMEICell-CheckKey-all')")
    @ApiOperation(value = "CheckKey", tags = {"EMEICell" },  notes = "CheckKey")
	@RequestMapping(method = RequestMethod.POST, value = "/emeicells/checkkey")
    public ResponseEntity<Boolean> checkKey(@RequestBody EMEICellDTO emeicelldto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emeicellService.checkKey(emeicellMapping.toDomain(emeicelldto)));
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMEICell-Default-all')")
	@ApiOperation(value = "fetchDEFAULT", tags = {"EMEICell" } ,notes = "fetchDEFAULT")
    @RequestMapping(method= RequestMethod.GET , value="/emeicells/fetchdefault")
	public ResponseEntity<List<EMEICellDTO>> fetchDefault(EMEICellSearchContext context) {
        Page<EMEICell> domains = emeicellService.searchDefault(context) ;
        List<EMEICellDTO> list = emeicellMapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMEICell-Default-all')")
	@ApiOperation(value = "searchDEFAULT", tags = {"EMEICell" } ,notes = "searchDEFAULT")
    @RequestMapping(method= RequestMethod.POST , value="/emeicells/searchdefault")
	public ResponseEntity<Page<EMEICellDTO>> searchDefault(@RequestBody EMEICellSearchContext context) {
        Page<EMEICell> domains = emeicellService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emeicellMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
}
