package cn.ibizlab.eam.webapi.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;
import javax.servlet.ServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import cn.ibizlab.eam.webapi.dto.*;
import cn.ibizlab.eam.webapi.mapping.*;
import cn.ibizlab.eam.core.eam_core.domain.EMEICamDrop;
import cn.ibizlab.eam.core.eam_core.service.IEMEICamDropService;
import cn.ibizlab.eam.core.eam_core.filter.EMEICamDropSearchContext;

@Slf4j
@Api(tags = {"EMEICamDrop" })
@RestController("WebApi-emeicamdrop")
@RequestMapping("")
public class EMEICamDropResource {

    @Autowired
    private IEMEICamDropService emeicamdropService;

    @Autowired
    @Lazy
    public EMEICamDropMapping emeicamdropMapping;

    public EMEICamDropDTO permissionDTO=new EMEICamDropDTO();

    @PreAuthorize("hasPermission(#emeicamdrop_id,'Get',{'Sql',this.emeicamdropMapping,this.permissionDTO})")
    @ApiOperation(value = "Get", tags = {"EMEICamDrop" },  notes = "Get")
	@RequestMapping(method = RequestMethod.GET, value = "/emeicamdrops/{emeicamdrop_id}")
    public ResponseEntity<EMEICamDropDTO> get(@PathVariable("emeicamdrop_id") String emeicamdrop_id) {
        EMEICamDrop domain = emeicamdropService.get(emeicamdrop_id);
        EMEICamDropDTO dto = emeicamdropMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMEICamDrop-GetDraft-all')")
    @ApiOperation(value = "GetDraft", tags = {"EMEICamDrop" },  notes = "GetDraft")
	@RequestMapping(method = RequestMethod.GET, value = "/emeicamdrops/getdraft")
    public ResponseEntity<EMEICamDropDTO> getDraft() {
        return ResponseEntity.status(HttpStatus.OK).body(emeicamdropMapping.toDto(emeicamdropService.getDraft(new EMEICamDrop())));
    }

    @PreAuthorize("hasPermission('','Save',{'Sql',this.emeicamdropMapping,#emeicamdropdto})")
    @ApiOperation(value = "Save", tags = {"EMEICamDrop" },  notes = "Save")
	@RequestMapping(method = RequestMethod.POST, value = "/emeicamdrops/save")
    public ResponseEntity<Boolean> save(@RequestBody EMEICamDropDTO emeicamdropdto) {
        return ResponseEntity.status(HttpStatus.OK).body(emeicamdropService.save(emeicamdropMapping.toDomain(emeicamdropdto)));
    }

    @PreAuthorize("hasPermission('Save',{'Sql',this.emeicamdropMapping,#emeicamdropdtos})")
    @ApiOperation(value = "SaveBatch", tags = {"EMEICamDrop" },  notes = "SaveBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emeicamdrops/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<EMEICamDropDTO> emeicamdropdtos) {
        emeicamdropService.saveBatch(emeicamdropMapping.toDomain(emeicamdropdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(#emeicamdrop_id,'Update',{'Sql',this.emeicamdropMapping,#emeicamdropdto})")
    @ApiOperation(value = "Update", tags = {"EMEICamDrop" },  notes = "Update")
	@RequestMapping(method = RequestMethod.PUT, value = "/emeicamdrops/{emeicamdrop_id}")
    @Transactional
    public ResponseEntity<EMEICamDropDTO> update(@PathVariable("emeicamdrop_id") String emeicamdrop_id, @RequestBody EMEICamDropDTO emeicamdropdto) {
		EMEICamDrop domain  = emeicamdropMapping.toDomain(emeicamdropdto);
        domain .setEmeicamdropid(emeicamdrop_id);
		emeicamdropService.update(domain );
		EMEICamDropDTO dto = emeicamdropMapping.toDto(domain );
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Update',{'Sql',this.emeicamdropMapping,#emeicamdropdtos})")
    @ApiOperation(value = "UpdateBatch", tags = {"EMEICamDrop" },  notes = "UpdateBatch")
	@RequestMapping(method = RequestMethod.PUT, value = "/emeicamdrops/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<EMEICamDropDTO> emeicamdropdtos) {
        emeicamdropService.updateBatch(emeicamdropMapping.toDomain(emeicamdropdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMEICamDrop-CheckKey-all')")
    @ApiOperation(value = "CheckKey", tags = {"EMEICamDrop" },  notes = "CheckKey")
	@RequestMapping(method = RequestMethod.POST, value = "/emeicamdrops/checkkey")
    public ResponseEntity<Boolean> checkKey(@RequestBody EMEICamDropDTO emeicamdropdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emeicamdropService.checkKey(emeicamdropMapping.toDomain(emeicamdropdto)));
    }

    @PreAuthorize("hasPermission(#emeicamdrop_id,'Remove',{'Sql',this.emeicamdropMapping,this.permissionDTO})")
    @ApiOperation(value = "Remove", tags = {"EMEICamDrop" },  notes = "Remove")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emeicamdrops/{emeicamdrop_id}")
    @Transactional
    public ResponseEntity<Boolean> remove(@PathVariable("emeicamdrop_id") String emeicamdrop_id) {
         return ResponseEntity.status(HttpStatus.OK).body(emeicamdropService.remove(emeicamdrop_id));
    }

    @PreAuthorize("hasPermission('Remove',{'Sql',this.emeicamdropMapping,this.permissionDTO,#ids})")
    @ApiOperation(value = "RemoveBatch", tags = {"EMEICamDrop" },  notes = "RemoveBatch")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emeicamdrops/batch")
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        emeicamdropService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission('','Create',{'Sql',this.emeicamdropMapping,#emeicamdropdto})")
    @ApiOperation(value = "Create", tags = {"EMEICamDrop" },  notes = "Create")
	@RequestMapping(method = RequestMethod.POST, value = "/emeicamdrops")
    @Transactional
    public ResponseEntity<EMEICamDropDTO> create(@RequestBody EMEICamDropDTO emeicamdropdto) {
        EMEICamDrop domain = emeicamdropMapping.toDomain(emeicamdropdto);
		emeicamdropService.create(domain);
        EMEICamDropDTO dto = emeicamdropMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Create',{'Sql',this.emeicamdropMapping,#emeicamdropdtos})")
    @ApiOperation(value = "createBatch", tags = {"EMEICamDrop" },  notes = "createBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emeicamdrops/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<EMEICamDropDTO> emeicamdropdtos) {
        emeicamdropService.createBatch(emeicamdropMapping.toDomain(emeicamdropdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMEICamDrop-Default-all')")
	@ApiOperation(value = "fetchDEFAULT", tags = {"EMEICamDrop" } ,notes = "fetchDEFAULT")
    @RequestMapping(method= RequestMethod.GET , value="/emeicamdrops/fetchdefault")
	public ResponseEntity<List<EMEICamDropDTO>> fetchDefault(EMEICamDropSearchContext context) {
        Page<EMEICamDrop> domains = emeicamdropService.searchDefault(context) ;
        List<EMEICamDropDTO> list = emeicamdropMapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMEICamDrop-Default-all')")
	@ApiOperation(value = "searchDEFAULT", tags = {"EMEICamDrop" } ,notes = "searchDEFAULT")
    @RequestMapping(method= RequestMethod.POST , value="/emeicamdrops/searchdefault")
	public ResponseEntity<Page<EMEICamDropDTO>> searchDefault(@RequestBody EMEICamDropSearchContext context) {
        Page<EMEICamDrop> domains = emeicamdropService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emeicamdropMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
}
