package cn.ibizlab.eam.webapi.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;
import javax.servlet.ServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import cn.ibizlab.eam.webapi.dto.*;
import cn.ibizlab.eam.webapi.mapping.*;
import cn.ibizlab.eam.core.eam_core.domain.EMBidinquiry;
import cn.ibizlab.eam.core.eam_core.service.IEMBidinquiryService;
import cn.ibizlab.eam.core.eam_core.filter.EMBidinquirySearchContext;

@Slf4j
@Api(tags = {"EMBidinquiry" })
@RestController("WebApi-embidinquiry")
@RequestMapping("")
public class EMBidinquiryResource {

    @Autowired
    private IEMBidinquiryService embidinquiryService;

    @Autowired
    @Lazy
    public EMBidinquiryMapping embidinquiryMapping;

    public EMBidinquiryDTO permissionDTO=new EMBidinquiryDTO();

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMBidinquiry-CheckKey-all')")
    @ApiOperation(value = "CheckKey", tags = {"EMBidinquiry" },  notes = "CheckKey")
	@RequestMapping(method = RequestMethod.POST, value = "/embidinquiries/checkkey")
    public ResponseEntity<Boolean> checkKey(@RequestBody EMBidinquiryDTO embidinquirydto) {
        return  ResponseEntity.status(HttpStatus.OK).body(embidinquiryService.checkKey(embidinquiryMapping.toDomain(embidinquirydto)));
    }

    @PreAuthorize("hasPermission(#embidinquiry_id,'Get',{'Sql',this.embidinquiryMapping,this.permissionDTO})")
    @ApiOperation(value = "Get", tags = {"EMBidinquiry" },  notes = "Get")
	@RequestMapping(method = RequestMethod.GET, value = "/embidinquiries/{embidinquiry_id}")
    public ResponseEntity<EMBidinquiryDTO> get(@PathVariable("embidinquiry_id") String embidinquiry_id) {
        EMBidinquiry domain = embidinquiryService.get(embidinquiry_id);
        EMBidinquiryDTO dto = embidinquiryMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMBidinquiry-GetDraft-all')")
    @ApiOperation(value = "GetDraft", tags = {"EMBidinquiry" },  notes = "GetDraft")
	@RequestMapping(method = RequestMethod.GET, value = "/embidinquiries/getdraft")
    public ResponseEntity<EMBidinquiryDTO> getDraft() {
        return ResponseEntity.status(HttpStatus.OK).body(embidinquiryMapping.toDto(embidinquiryService.getDraft(new EMBidinquiry())));
    }

    @PreAuthorize("hasPermission(#embidinquiry_id,'Update',{'Sql',this.embidinquiryMapping,#embidinquirydto})")
    @ApiOperation(value = "Update", tags = {"EMBidinquiry" },  notes = "Update")
	@RequestMapping(method = RequestMethod.PUT, value = "/embidinquiries/{embidinquiry_id}")
    @Transactional
    public ResponseEntity<EMBidinquiryDTO> update(@PathVariable("embidinquiry_id") String embidinquiry_id, @RequestBody EMBidinquiryDTO embidinquirydto) {
		EMBidinquiry domain  = embidinquiryMapping.toDomain(embidinquirydto);
        domain .setEmbidinquiryid(embidinquiry_id);
		embidinquiryService.update(domain );
		EMBidinquiryDTO dto = embidinquiryMapping.toDto(domain );
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Update',{'Sql',this.embidinquiryMapping,#embidinquirydtos})")
    @ApiOperation(value = "UpdateBatch", tags = {"EMBidinquiry" },  notes = "UpdateBatch")
	@RequestMapping(method = RequestMethod.PUT, value = "/embidinquiries/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<EMBidinquiryDTO> embidinquirydtos) {
        embidinquiryService.updateBatch(embidinquiryMapping.toDomain(embidinquirydtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(#embidinquiry_id,'Remove',{'Sql',this.embidinquiryMapping,this.permissionDTO})")
    @ApiOperation(value = "Remove", tags = {"EMBidinquiry" },  notes = "Remove")
	@RequestMapping(method = RequestMethod.DELETE, value = "/embidinquiries/{embidinquiry_id}")
    @Transactional
    public ResponseEntity<Boolean> remove(@PathVariable("embidinquiry_id") String embidinquiry_id) {
         return ResponseEntity.status(HttpStatus.OK).body(embidinquiryService.remove(embidinquiry_id));
    }

    @PreAuthorize("hasPermission('Remove',{'Sql',this.embidinquiryMapping,this.permissionDTO,#ids})")
    @ApiOperation(value = "RemoveBatch", tags = {"EMBidinquiry" },  notes = "RemoveBatch")
	@RequestMapping(method = RequestMethod.DELETE, value = "/embidinquiries/batch")
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        embidinquiryService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission('','Save',{'Sql',this.embidinquiryMapping,#embidinquirydto})")
    @ApiOperation(value = "Save", tags = {"EMBidinquiry" },  notes = "Save")
	@RequestMapping(method = RequestMethod.POST, value = "/embidinquiries/save")
    public ResponseEntity<Boolean> save(@RequestBody EMBidinquiryDTO embidinquirydto) {
        return ResponseEntity.status(HttpStatus.OK).body(embidinquiryService.save(embidinquiryMapping.toDomain(embidinquirydto)));
    }

    @PreAuthorize("hasPermission('Save',{'Sql',this.embidinquiryMapping,#embidinquirydtos})")
    @ApiOperation(value = "SaveBatch", tags = {"EMBidinquiry" },  notes = "SaveBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/embidinquiries/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<EMBidinquiryDTO> embidinquirydtos) {
        embidinquiryService.saveBatch(embidinquiryMapping.toDomain(embidinquirydtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission('','Create',{'Sql',this.embidinquiryMapping,#embidinquirydto})")
    @ApiOperation(value = "Create", tags = {"EMBidinquiry" },  notes = "Create")
	@RequestMapping(method = RequestMethod.POST, value = "/embidinquiries")
    @Transactional
    public ResponseEntity<EMBidinquiryDTO> create(@RequestBody EMBidinquiryDTO embidinquirydto) {
        EMBidinquiry domain = embidinquiryMapping.toDomain(embidinquirydto);
		embidinquiryService.create(domain);
        EMBidinquiryDTO dto = embidinquiryMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Create',{'Sql',this.embidinquiryMapping,#embidinquirydtos})")
    @ApiOperation(value = "createBatch", tags = {"EMBidinquiry" },  notes = "createBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/embidinquiries/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<EMBidinquiryDTO> embidinquirydtos) {
        embidinquiryService.createBatch(embidinquiryMapping.toDomain(embidinquirydtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMBidinquiry-Default-all')")
	@ApiOperation(value = "fetchDEFAULT", tags = {"EMBidinquiry" } ,notes = "fetchDEFAULT")
    @RequestMapping(method= RequestMethod.GET , value="/embidinquiries/fetchdefault")
	public ResponseEntity<List<EMBidinquiryDTO>> fetchDefault(EMBidinquirySearchContext context) {
        Page<EMBidinquiry> domains = embidinquiryService.searchDefault(context) ;
        List<EMBidinquiryDTO> list = embidinquiryMapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMBidinquiry-Default-all')")
	@ApiOperation(value = "searchDEFAULT", tags = {"EMBidinquiry" } ,notes = "searchDEFAULT")
    @RequestMapping(method= RequestMethod.POST , value="/embidinquiries/searchdefault")
	public ResponseEntity<Page<EMBidinquiryDTO>> searchDefault(@RequestBody EMBidinquirySearchContext context) {
        Page<EMBidinquiry> domains = embidinquiryService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(embidinquiryMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
}
