package cn.ibizlab.eam.webapi.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;
import javax.servlet.ServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import cn.ibizlab.eam.webapi.dto.*;
import cn.ibizlab.eam.webapi.mapping.*;
import cn.ibizlab.eam.core.eam_core.domain.EMApply;
import cn.ibizlab.eam.core.eam_core.service.IEMApplyService;
import cn.ibizlab.eam.core.eam_core.filter.EMApplySearchContext;

@Slf4j
@Api(tags = {"EMApply" })
@RestController("WebApi-emapply")
@RequestMapping("")
public class EMApplyResource {

    @Autowired
    private IEMApplyService emapplyService;

    @Autowired
    @Lazy
    public EMApplyMapping emapplyMapping;

    public EMApplyDTO permissionDTO=new EMApplyDTO();

    @PreAuthorize("hasPermission(#emapply_id,'Remove',{'Sql',this.emapplyMapping,this.permissionDTO})")
    @ApiOperation(value = "Remove", tags = {"EMApply" },  notes = "Remove")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emapplies/{emapply_id}")
    @Transactional
    public ResponseEntity<Boolean> remove(@PathVariable("emapply_id") String emapply_id) {
         return ResponseEntity.status(HttpStatus.OK).body(emapplyService.remove(emapply_id));
    }

    @PreAuthorize("hasPermission('Remove',{'Sql',this.emapplyMapping,this.permissionDTO,#ids})")
    @ApiOperation(value = "RemoveBatch", tags = {"EMApply" },  notes = "RemoveBatch")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emapplies/batch")
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        emapplyService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(#emapply_id,'Update',{'Sql',this.emapplyMapping,#emapplydto})")
    @ApiOperation(value = "Update", tags = {"EMApply" },  notes = "Update")
	@RequestMapping(method = RequestMethod.PUT, value = "/emapplies/{emapply_id}")
    @Transactional
    public ResponseEntity<EMApplyDTO> update(@PathVariable("emapply_id") String emapply_id, @RequestBody EMApplyDTO emapplydto) {
		EMApply domain  = emapplyMapping.toDomain(emapplydto);
        domain .setEmapplyid(emapply_id);
		emapplyService.update(domain );
		EMApplyDTO dto = emapplyMapping.toDto(domain );
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Update',{'Sql',this.emapplyMapping,#emapplydtos})")
    @ApiOperation(value = "UpdateBatch", tags = {"EMApply" },  notes = "UpdateBatch")
	@RequestMapping(method = RequestMethod.PUT, value = "/emapplies/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<EMApplyDTO> emapplydtos) {
        emapplyService.updateBatch(emapplyMapping.toDomain(emapplydtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMApply-CheckKey-all')")
    @ApiOperation(value = "CheckKey", tags = {"EMApply" },  notes = "CheckKey")
	@RequestMapping(method = RequestMethod.POST, value = "/emapplies/checkkey")
    public ResponseEntity<Boolean> checkKey(@RequestBody EMApplyDTO emapplydto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emapplyService.checkKey(emapplyMapping.toDomain(emapplydto)));
    }

    @PreAuthorize("hasPermission('','Save',{'Sql',this.emapplyMapping,#emapplydto})")
    @ApiOperation(value = "Save", tags = {"EMApply" },  notes = "Save")
	@RequestMapping(method = RequestMethod.POST, value = "/emapplies/save")
    public ResponseEntity<Boolean> save(@RequestBody EMApplyDTO emapplydto) {
        return ResponseEntity.status(HttpStatus.OK).body(emapplyService.save(emapplyMapping.toDomain(emapplydto)));
    }

    @PreAuthorize("hasPermission('Save',{'Sql',this.emapplyMapping,#emapplydtos})")
    @ApiOperation(value = "SaveBatch", tags = {"EMApply" },  notes = "SaveBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emapplies/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<EMApplyDTO> emapplydtos) {
        emapplyService.saveBatch(emapplyMapping.toDomain(emapplydtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMApply-GetDraft-all')")
    @ApiOperation(value = "GetDraft", tags = {"EMApply" },  notes = "GetDraft")
	@RequestMapping(method = RequestMethod.GET, value = "/emapplies/getdraft")
    public ResponseEntity<EMApplyDTO> getDraft() {
        return ResponseEntity.status(HttpStatus.OK).body(emapplyMapping.toDto(emapplyService.getDraft(new EMApply())));
    }

    @PreAuthorize("hasPermission('','Create',{'Sql',this.emapplyMapping,#emapplydto})")
    @ApiOperation(value = "Create", tags = {"EMApply" },  notes = "Create")
	@RequestMapping(method = RequestMethod.POST, value = "/emapplies")
    @Transactional
    public ResponseEntity<EMApplyDTO> create(@RequestBody EMApplyDTO emapplydto) {
        EMApply domain = emapplyMapping.toDomain(emapplydto);
		emapplyService.create(domain);
        EMApplyDTO dto = emapplyMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Create',{'Sql',this.emapplyMapping,#emapplydtos})")
    @ApiOperation(value = "createBatch", tags = {"EMApply" },  notes = "createBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emapplies/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<EMApplyDTO> emapplydtos) {
        emapplyService.createBatch(emapplyMapping.toDomain(emapplydtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(#emapply_id,'Get',{'Sql',this.emapplyMapping,this.permissionDTO})")
    @ApiOperation(value = "Get", tags = {"EMApply" },  notes = "Get")
	@RequestMapping(method = RequestMethod.GET, value = "/emapplies/{emapply_id}")
    public ResponseEntity<EMApplyDTO> get(@PathVariable("emapply_id") String emapply_id) {
        EMApply domain = emapplyService.get(emapply_id);
        EMApplyDTO dto = emapplyMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMApply-Default-all')")
	@ApiOperation(value = "fetchDEFAULT", tags = {"EMApply" } ,notes = "fetchDEFAULT")
    @RequestMapping(method= RequestMethod.GET , value="/emapplies/fetchdefault")
	public ResponseEntity<List<EMApplyDTO>> fetchDefault(EMApplySearchContext context) {
        Page<EMApply> domains = emapplyService.searchDefault(context) ;
        List<EMApplyDTO> list = emapplyMapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMApply-Default-all')")
	@ApiOperation(value = "searchDEFAULT", tags = {"EMApply" } ,notes = "searchDEFAULT")
    @RequestMapping(method= RequestMethod.POST , value="/emapplies/searchdefault")
	public ResponseEntity<Page<EMApplyDTO>> searchDefault(@RequestBody EMApplySearchContext context) {
        Page<EMApply> domains = emapplyService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emapplyMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
    @PreAuthorize("hasPermission(#emapply_id,'Remove',{'Sql',this.emapplyMapping,this.permissionDTO})")
    @ApiOperation(value = "RemoveByEMEquip", tags = {"EMApply" },  notes = "RemoveByEMEquip")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emequips/{emequip_id}/emapplies/{emapply_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByEMEquip(@PathVariable("emequip_id") String emequip_id, @PathVariable("emapply_id") String emapply_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emapplyService.remove(emapply_id));
    }

    @PreAuthorize("hasPermission('Remove',{'Sql',this.emapplyMapping,this.permissionDTO,#ids})")
    @ApiOperation(value = "RemoveBatchByEMEquip", tags = {"EMApply" },  notes = "RemoveBatchByEMEquip")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emequips/{emequip_id}/emapplies/batch")
    public ResponseEntity<Boolean> removeBatchByEMEquip(@RequestBody List<String> ids) {
        emapplyService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(#emapply_id,'Update',{'Sql',this.emapplyMapping,#emapplydto})")
    @ApiOperation(value = "UpdateByEMEquip", tags = {"EMApply" },  notes = "UpdateByEMEquip")
	@RequestMapping(method = RequestMethod.PUT, value = "/emequips/{emequip_id}/emapplies/{emapply_id}")
    @Transactional
    public ResponseEntity<EMApplyDTO> updateByEMEquip(@PathVariable("emequip_id") String emequip_id, @PathVariable("emapply_id") String emapply_id, @RequestBody EMApplyDTO emapplydto) {
        EMApply domain = emapplyMapping.toDomain(emapplydto);
        domain.setEquipid(emequip_id);
        domain.setEmapplyid(emapply_id);
		emapplyService.update(domain);
        EMApplyDTO dto = emapplyMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Update',{'Sql',this.emapplyMapping,#emapplydtos})")
    @ApiOperation(value = "UpdateBatchByEMEquip", tags = {"EMApply" },  notes = "UpdateBatchByEMEquip")
	@RequestMapping(method = RequestMethod.PUT, value = "/emequips/{emequip_id}/emapplies/batch")
    public ResponseEntity<Boolean> updateBatchByEMEquip(@PathVariable("emequip_id") String emequip_id, @RequestBody List<EMApplyDTO> emapplydtos) {
        List<EMApply> domainlist=emapplyMapping.toDomain(emapplydtos);
        for(EMApply domain:domainlist){
            domain.setEquipid(emequip_id);
        }
        emapplyService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMApply-CheckKey-all')")
    @ApiOperation(value = "CheckKeyByEMEquip", tags = {"EMApply" },  notes = "CheckKeyByEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/emequips/{emequip_id}/emapplies/checkkey")
    public ResponseEntity<Boolean> checkKeyByEMEquip(@PathVariable("emequip_id") String emequip_id, @RequestBody EMApplyDTO emapplydto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emapplyService.checkKey(emapplyMapping.toDomain(emapplydto)));
    }

    @PreAuthorize("hasPermission('','Save',{'Sql',this.emapplyMapping,#emapplydto})")
    @ApiOperation(value = "SaveByEMEquip", tags = {"EMApply" },  notes = "SaveByEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/emequips/{emequip_id}/emapplies/save")
    public ResponseEntity<Boolean> saveByEMEquip(@PathVariable("emequip_id") String emequip_id, @RequestBody EMApplyDTO emapplydto) {
        EMApply domain = emapplyMapping.toDomain(emapplydto);
        domain.setEquipid(emequip_id);
        return ResponseEntity.status(HttpStatus.OK).body(emapplyService.save(domain));
    }

    @PreAuthorize("hasPermission('Save',{'Sql',this.emapplyMapping,#emapplydtos})")
    @ApiOperation(value = "SaveBatchByEMEquip", tags = {"EMApply" },  notes = "SaveBatchByEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/emequips/{emequip_id}/emapplies/savebatch")
    public ResponseEntity<Boolean> saveBatchByEMEquip(@PathVariable("emequip_id") String emequip_id, @RequestBody List<EMApplyDTO> emapplydtos) {
        List<EMApply> domainlist=emapplyMapping.toDomain(emapplydtos);
        for(EMApply domain:domainlist){
             domain.setEquipid(emequip_id);
        }
        emapplyService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMApply-GetDraft-all')")
    @ApiOperation(value = "GetDraftByEMEquip", tags = {"EMApply" },  notes = "GetDraftByEMEquip")
    @RequestMapping(method = RequestMethod.GET, value = "/emequips/{emequip_id}/emapplies/getdraft")
    public ResponseEntity<EMApplyDTO> getDraftByEMEquip(@PathVariable("emequip_id") String emequip_id) {
        EMApply domain = new EMApply();
        domain.setEquipid(emequip_id);
        return ResponseEntity.status(HttpStatus.OK).body(emapplyMapping.toDto(emapplyService.getDraft(domain)));
    }

    @PreAuthorize("hasPermission('','Create',{'Sql',this.emapplyMapping,#emapplydto})")
    @ApiOperation(value = "CreateByEMEquip", tags = {"EMApply" },  notes = "CreateByEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/emequips/{emequip_id}/emapplies")
    @Transactional
    public ResponseEntity<EMApplyDTO> createByEMEquip(@PathVariable("emequip_id") String emequip_id, @RequestBody EMApplyDTO emapplydto) {
        EMApply domain = emapplyMapping.toDomain(emapplydto);
        domain.setEquipid(emequip_id);
		emapplyService.create(domain);
        EMApplyDTO dto = emapplyMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Create',{'Sql',this.emapplyMapping,#emapplydtos})")
    @ApiOperation(value = "createBatchByEMEquip", tags = {"EMApply" },  notes = "createBatchByEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/emequips/{emequip_id}/emapplies/batch")
    public ResponseEntity<Boolean> createBatchByEMEquip(@PathVariable("emequip_id") String emequip_id, @RequestBody List<EMApplyDTO> emapplydtos) {
        List<EMApply> domainlist=emapplyMapping.toDomain(emapplydtos);
        for(EMApply domain:domainlist){
            domain.setEquipid(emequip_id);
        }
        emapplyService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(#emapply_id,'Get',{'Sql',this.emapplyMapping,this.permissionDTO})")
    @ApiOperation(value = "GetByEMEquip", tags = {"EMApply" },  notes = "GetByEMEquip")
	@RequestMapping(method = RequestMethod.GET, value = "/emequips/{emequip_id}/emapplies/{emapply_id}")
    public ResponseEntity<EMApplyDTO> getByEMEquip(@PathVariable("emequip_id") String emequip_id, @PathVariable("emapply_id") String emapply_id) {
        EMApply domain = emapplyService.get(emapply_id);
        EMApplyDTO dto = emapplyMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMApply-Default-all')")
	@ApiOperation(value = "fetchDEFAULTByEMEquip", tags = {"EMApply" } ,notes = "fetchDEFAULTByEMEquip")
    @RequestMapping(method= RequestMethod.GET , value="/emequips/{emequip_id}/emapplies/fetchdefault")
	public ResponseEntity<List<EMApplyDTO>> fetchEMApplyDefaultByEMEquip(@PathVariable("emequip_id") String emequip_id,EMApplySearchContext context) {
        context.setN_equipid_eq(emequip_id);
        Page<EMApply> domains = emapplyService.searchDefault(context) ;
        List<EMApplyDTO> list = emapplyMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMApply-Default-all')")
	@ApiOperation(value = "searchDEFAULTByEMEquip", tags = {"EMApply" } ,notes = "searchDEFAULTByEMEquip")
    @RequestMapping(method= RequestMethod.POST , value="/emequips/{emequip_id}/emapplies/searchdefault")
	public ResponseEntity<Page<EMApplyDTO>> searchEMApplyDefaultByEMEquip(@PathVariable("emequip_id") String emequip_id, @RequestBody EMApplySearchContext context) {
        context.setN_equipid_eq(emequip_id);
        Page<EMApply> domains = emapplyService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emapplyMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
    @PreAuthorize("hasPermission(#emapply_id,'Remove',{'Sql',this.emapplyMapping,this.permissionDTO})")
    @ApiOperation(value = "RemoveByEMEQTypeEMEquip", tags = {"EMApply" },  notes = "RemoveByEMEQTypeEMEquip")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emapplies/{emapply_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByEMEQTypeEMEquip(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id, @PathVariable("emapply_id") String emapply_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emapplyService.remove(emapply_id));
    }

    @PreAuthorize("hasPermission('Remove',{'Sql',this.emapplyMapping,this.permissionDTO,#ids})")
    @ApiOperation(value = "RemoveBatchByEMEQTypeEMEquip", tags = {"EMApply" },  notes = "RemoveBatchByEMEQTypeEMEquip")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emapplies/batch")
    public ResponseEntity<Boolean> removeBatchByEMEQTypeEMEquip(@RequestBody List<String> ids) {
        emapplyService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(#emapply_id,'Update',{'Sql',this.emapplyMapping,#emapplydto})")
    @ApiOperation(value = "UpdateByEMEQTypeEMEquip", tags = {"EMApply" },  notes = "UpdateByEMEQTypeEMEquip")
	@RequestMapping(method = RequestMethod.PUT, value = "/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emapplies/{emapply_id}")
    @Transactional
    public ResponseEntity<EMApplyDTO> updateByEMEQTypeEMEquip(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id, @PathVariable("emapply_id") String emapply_id, @RequestBody EMApplyDTO emapplydto) {
        EMApply domain = emapplyMapping.toDomain(emapplydto);
        domain.setEquipid(emequip_id);
        domain.setEmapplyid(emapply_id);
		emapplyService.update(domain);
        EMApplyDTO dto = emapplyMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Update',{'Sql',this.emapplyMapping,#emapplydtos})")
    @ApiOperation(value = "UpdateBatchByEMEQTypeEMEquip", tags = {"EMApply" },  notes = "UpdateBatchByEMEQTypeEMEquip")
	@RequestMapping(method = RequestMethod.PUT, value = "/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emapplies/batch")
    public ResponseEntity<Boolean> updateBatchByEMEQTypeEMEquip(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id, @RequestBody List<EMApplyDTO> emapplydtos) {
        List<EMApply> domainlist=emapplyMapping.toDomain(emapplydtos);
        for(EMApply domain:domainlist){
            domain.setEquipid(emequip_id);
        }
        emapplyService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMApply-CheckKey-all')")
    @ApiOperation(value = "CheckKeyByEMEQTypeEMEquip", tags = {"EMApply" },  notes = "CheckKeyByEMEQTypeEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emapplies/checkkey")
    public ResponseEntity<Boolean> checkKeyByEMEQTypeEMEquip(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id, @RequestBody EMApplyDTO emapplydto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emapplyService.checkKey(emapplyMapping.toDomain(emapplydto)));
    }

    @PreAuthorize("hasPermission('','Save',{'Sql',this.emapplyMapping,#emapplydto})")
    @ApiOperation(value = "SaveByEMEQTypeEMEquip", tags = {"EMApply" },  notes = "SaveByEMEQTypeEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emapplies/save")
    public ResponseEntity<Boolean> saveByEMEQTypeEMEquip(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id, @RequestBody EMApplyDTO emapplydto) {
        EMApply domain = emapplyMapping.toDomain(emapplydto);
        domain.setEquipid(emequip_id);
        return ResponseEntity.status(HttpStatus.OK).body(emapplyService.save(domain));
    }

    @PreAuthorize("hasPermission('Save',{'Sql',this.emapplyMapping,#emapplydtos})")
    @ApiOperation(value = "SaveBatchByEMEQTypeEMEquip", tags = {"EMApply" },  notes = "SaveBatchByEMEQTypeEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emapplies/savebatch")
    public ResponseEntity<Boolean> saveBatchByEMEQTypeEMEquip(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id, @RequestBody List<EMApplyDTO> emapplydtos) {
        List<EMApply> domainlist=emapplyMapping.toDomain(emapplydtos);
        for(EMApply domain:domainlist){
             domain.setEquipid(emequip_id);
        }
        emapplyService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMApply-GetDraft-all')")
    @ApiOperation(value = "GetDraftByEMEQTypeEMEquip", tags = {"EMApply" },  notes = "GetDraftByEMEQTypeEMEquip")
    @RequestMapping(method = RequestMethod.GET, value = "/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emapplies/getdraft")
    public ResponseEntity<EMApplyDTO> getDraftByEMEQTypeEMEquip(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id) {
        EMApply domain = new EMApply();
        domain.setEquipid(emequip_id);
        return ResponseEntity.status(HttpStatus.OK).body(emapplyMapping.toDto(emapplyService.getDraft(domain)));
    }

    @PreAuthorize("hasPermission('','Create',{'Sql',this.emapplyMapping,#emapplydto})")
    @ApiOperation(value = "CreateByEMEQTypeEMEquip", tags = {"EMApply" },  notes = "CreateByEMEQTypeEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emapplies")
    @Transactional
    public ResponseEntity<EMApplyDTO> createByEMEQTypeEMEquip(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id, @RequestBody EMApplyDTO emapplydto) {
        EMApply domain = emapplyMapping.toDomain(emapplydto);
        domain.setEquipid(emequip_id);
		emapplyService.create(domain);
        EMApplyDTO dto = emapplyMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Create',{'Sql',this.emapplyMapping,#emapplydtos})")
    @ApiOperation(value = "createBatchByEMEQTypeEMEquip", tags = {"EMApply" },  notes = "createBatchByEMEQTypeEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emapplies/batch")
    public ResponseEntity<Boolean> createBatchByEMEQTypeEMEquip(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id, @RequestBody List<EMApplyDTO> emapplydtos) {
        List<EMApply> domainlist=emapplyMapping.toDomain(emapplydtos);
        for(EMApply domain:domainlist){
            domain.setEquipid(emequip_id);
        }
        emapplyService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(#emapply_id,'Get',{'Sql',this.emapplyMapping,this.permissionDTO})")
    @ApiOperation(value = "GetByEMEQTypeEMEquip", tags = {"EMApply" },  notes = "GetByEMEQTypeEMEquip")
	@RequestMapping(method = RequestMethod.GET, value = "/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emapplies/{emapply_id}")
    public ResponseEntity<EMApplyDTO> getByEMEQTypeEMEquip(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id, @PathVariable("emapply_id") String emapply_id) {
        EMApply domain = emapplyService.get(emapply_id);
        EMApplyDTO dto = emapplyMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMApply-Default-all')")
	@ApiOperation(value = "fetchDEFAULTByEMEQTypeEMEquip", tags = {"EMApply" } ,notes = "fetchDEFAULTByEMEQTypeEMEquip")
    @RequestMapping(method= RequestMethod.GET , value="/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emapplies/fetchdefault")
	public ResponseEntity<List<EMApplyDTO>> fetchEMApplyDefaultByEMEQTypeEMEquip(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id,EMApplySearchContext context) {
        context.setN_equipid_eq(emequip_id);
        Page<EMApply> domains = emapplyService.searchDefault(context) ;
        List<EMApplyDTO> list = emapplyMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMApply-Default-all')")
	@ApiOperation(value = "searchDEFAULTByEMEQTypeEMEquip", tags = {"EMApply" } ,notes = "searchDEFAULTByEMEQTypeEMEquip")
    @RequestMapping(method= RequestMethod.POST , value="/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emapplies/searchdefault")
	public ResponseEntity<Page<EMApplyDTO>> searchEMApplyDefaultByEMEQTypeEMEquip(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id, @RequestBody EMApplySearchContext context) {
        context.setN_equipid_eq(emequip_id);
        Page<EMApply> domains = emapplyService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emapplyMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
    @PreAuthorize("hasPermission(#emapply_id,'Remove',{'Sql',this.emapplyMapping,this.permissionDTO})")
    @ApiOperation(value = "RemoveByPFTeamEMEquip", tags = {"EMApply" },  notes = "RemoveByPFTeamEMEquip")
	@RequestMapping(method = RequestMethod.DELETE, value = "/pfteams/{pfteam_id}/emequips/{emequip_id}/emapplies/{emapply_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByPFTeamEMEquip(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id, @PathVariable("emapply_id") String emapply_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emapplyService.remove(emapply_id));
    }

    @PreAuthorize("hasPermission('Remove',{'Sql',this.emapplyMapping,this.permissionDTO,#ids})")
    @ApiOperation(value = "RemoveBatchByPFTeamEMEquip", tags = {"EMApply" },  notes = "RemoveBatchByPFTeamEMEquip")
	@RequestMapping(method = RequestMethod.DELETE, value = "/pfteams/{pfteam_id}/emequips/{emequip_id}/emapplies/batch")
    public ResponseEntity<Boolean> removeBatchByPFTeamEMEquip(@RequestBody List<String> ids) {
        emapplyService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(#emapply_id,'Update',{'Sql',this.emapplyMapping,#emapplydto})")
    @ApiOperation(value = "UpdateByPFTeamEMEquip", tags = {"EMApply" },  notes = "UpdateByPFTeamEMEquip")
	@RequestMapping(method = RequestMethod.PUT, value = "/pfteams/{pfteam_id}/emequips/{emequip_id}/emapplies/{emapply_id}")
    @Transactional
    public ResponseEntity<EMApplyDTO> updateByPFTeamEMEquip(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id, @PathVariable("emapply_id") String emapply_id, @RequestBody EMApplyDTO emapplydto) {
        EMApply domain = emapplyMapping.toDomain(emapplydto);
        domain.setEquipid(emequip_id);
        domain.setEmapplyid(emapply_id);
		emapplyService.update(domain);
        EMApplyDTO dto = emapplyMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Update',{'Sql',this.emapplyMapping,#emapplydtos})")
    @ApiOperation(value = "UpdateBatchByPFTeamEMEquip", tags = {"EMApply" },  notes = "UpdateBatchByPFTeamEMEquip")
	@RequestMapping(method = RequestMethod.PUT, value = "/pfteams/{pfteam_id}/emequips/{emequip_id}/emapplies/batch")
    public ResponseEntity<Boolean> updateBatchByPFTeamEMEquip(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id, @RequestBody List<EMApplyDTO> emapplydtos) {
        List<EMApply> domainlist=emapplyMapping.toDomain(emapplydtos);
        for(EMApply domain:domainlist){
            domain.setEquipid(emequip_id);
        }
        emapplyService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMApply-CheckKey-all')")
    @ApiOperation(value = "CheckKeyByPFTeamEMEquip", tags = {"EMApply" },  notes = "CheckKeyByPFTeamEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/pfteams/{pfteam_id}/emequips/{emequip_id}/emapplies/checkkey")
    public ResponseEntity<Boolean> checkKeyByPFTeamEMEquip(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id, @RequestBody EMApplyDTO emapplydto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emapplyService.checkKey(emapplyMapping.toDomain(emapplydto)));
    }

    @PreAuthorize("hasPermission('','Save',{'Sql',this.emapplyMapping,#emapplydto})")
    @ApiOperation(value = "SaveByPFTeamEMEquip", tags = {"EMApply" },  notes = "SaveByPFTeamEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/pfteams/{pfteam_id}/emequips/{emequip_id}/emapplies/save")
    public ResponseEntity<Boolean> saveByPFTeamEMEquip(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id, @RequestBody EMApplyDTO emapplydto) {
        EMApply domain = emapplyMapping.toDomain(emapplydto);
        domain.setEquipid(emequip_id);
        return ResponseEntity.status(HttpStatus.OK).body(emapplyService.save(domain));
    }

    @PreAuthorize("hasPermission('Save',{'Sql',this.emapplyMapping,#emapplydtos})")
    @ApiOperation(value = "SaveBatchByPFTeamEMEquip", tags = {"EMApply" },  notes = "SaveBatchByPFTeamEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/pfteams/{pfteam_id}/emequips/{emequip_id}/emapplies/savebatch")
    public ResponseEntity<Boolean> saveBatchByPFTeamEMEquip(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id, @RequestBody List<EMApplyDTO> emapplydtos) {
        List<EMApply> domainlist=emapplyMapping.toDomain(emapplydtos);
        for(EMApply domain:domainlist){
             domain.setEquipid(emequip_id);
        }
        emapplyService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMApply-GetDraft-all')")
    @ApiOperation(value = "GetDraftByPFTeamEMEquip", tags = {"EMApply" },  notes = "GetDraftByPFTeamEMEquip")
    @RequestMapping(method = RequestMethod.GET, value = "/pfteams/{pfteam_id}/emequips/{emequip_id}/emapplies/getdraft")
    public ResponseEntity<EMApplyDTO> getDraftByPFTeamEMEquip(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id) {
        EMApply domain = new EMApply();
        domain.setEquipid(emequip_id);
        return ResponseEntity.status(HttpStatus.OK).body(emapplyMapping.toDto(emapplyService.getDraft(domain)));
    }

    @PreAuthorize("hasPermission('','Create',{'Sql',this.emapplyMapping,#emapplydto})")
    @ApiOperation(value = "CreateByPFTeamEMEquip", tags = {"EMApply" },  notes = "CreateByPFTeamEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/pfteams/{pfteam_id}/emequips/{emequip_id}/emapplies")
    @Transactional
    public ResponseEntity<EMApplyDTO> createByPFTeamEMEquip(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id, @RequestBody EMApplyDTO emapplydto) {
        EMApply domain = emapplyMapping.toDomain(emapplydto);
        domain.setEquipid(emequip_id);
		emapplyService.create(domain);
        EMApplyDTO dto = emapplyMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Create',{'Sql',this.emapplyMapping,#emapplydtos})")
    @ApiOperation(value = "createBatchByPFTeamEMEquip", tags = {"EMApply" },  notes = "createBatchByPFTeamEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/pfteams/{pfteam_id}/emequips/{emequip_id}/emapplies/batch")
    public ResponseEntity<Boolean> createBatchByPFTeamEMEquip(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id, @RequestBody List<EMApplyDTO> emapplydtos) {
        List<EMApply> domainlist=emapplyMapping.toDomain(emapplydtos);
        for(EMApply domain:domainlist){
            domain.setEquipid(emequip_id);
        }
        emapplyService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(#emapply_id,'Get',{'Sql',this.emapplyMapping,this.permissionDTO})")
    @ApiOperation(value = "GetByPFTeamEMEquip", tags = {"EMApply" },  notes = "GetByPFTeamEMEquip")
	@RequestMapping(method = RequestMethod.GET, value = "/pfteams/{pfteam_id}/emequips/{emequip_id}/emapplies/{emapply_id}")
    public ResponseEntity<EMApplyDTO> getByPFTeamEMEquip(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id, @PathVariable("emapply_id") String emapply_id) {
        EMApply domain = emapplyService.get(emapply_id);
        EMApplyDTO dto = emapplyMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMApply-Default-all')")
	@ApiOperation(value = "fetchDEFAULTByPFTeamEMEquip", tags = {"EMApply" } ,notes = "fetchDEFAULTByPFTeamEMEquip")
    @RequestMapping(method= RequestMethod.GET , value="/pfteams/{pfteam_id}/emequips/{emequip_id}/emapplies/fetchdefault")
	public ResponseEntity<List<EMApplyDTO>> fetchEMApplyDefaultByPFTeamEMEquip(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id,EMApplySearchContext context) {
        context.setN_equipid_eq(emequip_id);
        Page<EMApply> domains = emapplyService.searchDefault(context) ;
        List<EMApplyDTO> list = emapplyMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMApply-Default-all')")
	@ApiOperation(value = "searchDEFAULTByPFTeamEMEquip", tags = {"EMApply" } ,notes = "searchDEFAULTByPFTeamEMEquip")
    @RequestMapping(method= RequestMethod.POST , value="/pfteams/{pfteam_id}/emequips/{emequip_id}/emapplies/searchdefault")
	public ResponseEntity<Page<EMApplyDTO>> searchEMApplyDefaultByPFTeamEMEquip(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id, @RequestBody EMApplySearchContext context) {
        context.setN_equipid_eq(emequip_id);
        Page<EMApply> domains = emapplyService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emapplyMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
}
