package cn.ibizlab.eam.webapi.dto;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.math.BigInteger;
import java.util.Map;
import java.util.HashMap;
import java.io.Serializable;
import java.math.BigDecimal;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.alibaba.fastjson.annotation.JSONField;
import cn.ibizlab.eam.util.domain.DTOBase;
import lombok.Data;

/**
 * 服务DTO对象[PFDeptDTO]
 */
@Data
public class PFDeptDTO extends DTOBase implements Serializable {

	private static final long serialVersionUID = 1L;

    /**
     * 属性 [DEPTCODE]
     *
     */
    @JSONField(name = "deptcode")
    @JsonProperty("deptcode")
    private String deptcode;

    /**
     * 属性 [UPDATEDATE]
     *
     */
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
    @JSONField(name = "updatedate" , format="yyyy-MM-dd HH:mm:ss")
    @JsonProperty("updatedate")
    private Timestamp updatedate;

    /**
     * 属性 [ORGID]
     *
     */
    @JSONField(name = "orgid")
    @JsonProperty("orgid")
    private String orgid;

    /**
     * 属性 [CREATEMAN]
     *
     */
    @JSONField(name = "createman")
    @JsonProperty("createman")
    private String createman;

    /**
     * 属性 [DEPTINFO]
     *
     */
    @JSONField(name = "deptinfo")
    @JsonProperty("deptinfo")
    private String deptinfo;

    /**
     * 属性 [DEPTFN]
     *
     */
    @JSONField(name = "deptfn")
    @JsonProperty("deptfn")
    private String deptfn;

    /**
     * 属性 [UPDATEMAN]
     *
     */
    @JSONField(name = "updateman")
    @JsonProperty("updateman")
    private String updateman;

    /**
     * 属性 [MAINDEPTCODE]
     *
     */
    @JSONField(name = "maindeptcode")
    @JsonProperty("maindeptcode")
    private String maindeptcode;

    /**
     * 属性 [ENABLE]
     *
     */
    @JSONField(name = "enable")
    @JsonProperty("enable")
    private Integer enable;

    /**
     * 属性 [PFDEPTID]
     *
     */
    @JSONField(name = "pfdeptid")
    @JsonProperty("pfdeptid")
    private String pfdeptid;

    /**
     * 属性 [PFDEPTNAME]
     *
     */
    @JSONField(name = "pfdeptname")
    @JsonProperty("pfdeptname")
    private String pfdeptname;

    /**
     * 属性 [SDEPT]
     *
     */
    @JSONField(name = "sdept")
    @JsonProperty("sdept")
    private Integer sdept;

    /**
     * 属性 [CREATEDATE]
     *
     */
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
    @JSONField(name = "createdate" , format="yyyy-MM-dd HH:mm:ss")
    @JsonProperty("createdate")
    private Timestamp createdate;

    /**
     * 属性 [DESCRIPTION]
     *
     */
    @JSONField(name = "description")
    @JsonProperty("description")
    private String description;

    /**
     * 属性 [MGREMPNAME]
     *
     */
    @JSONField(name = "mgrempname")
    @JsonProperty("mgrempname")
    private String mgrempname;

    /**
     * 属性 [DEPTPNAME]
     *
     */
    @JSONField(name = "deptpname")
    @JsonProperty("deptpname")
    private String deptpname;

    /**
     * 属性 [DEPTPID]
     *
     */
    @JSONField(name = "deptpid")
    @JsonProperty("deptpid")
    private String deptpid;

    /**
     * 属性 [MGREMPID]
     *
     */
    @JSONField(name = "mgrempid")
    @JsonProperty("mgrempid")
    private String mgrempid;


    /**
     * 设置 [DEPTCODE]
     */
    public void setDeptcode(String  deptcode){
        this.deptcode = deptcode ;
        this.modify("deptcode",deptcode);
    }

    /**
     * 设置 [DEPTFN]
     */
    public void setDeptfn(String  deptfn){
        this.deptfn = deptfn ;
        this.modify("deptfn",deptfn);
    }

    /**
     * 设置 [MAINDEPTCODE]
     */
    public void setMaindeptcode(String  maindeptcode){
        this.maindeptcode = maindeptcode ;
        this.modify("maindeptcode",maindeptcode);
    }

    /**
     * 设置 [PFDEPTNAME]
     */
    public void setPfdeptname(String  pfdeptname){
        this.pfdeptname = pfdeptname ;
        this.modify("pfdeptname",pfdeptname);
    }

    /**
     * 设置 [SDEPT]
     */
    public void setSdept(Integer  sdept){
        this.sdept = sdept ;
        this.modify("sdept",sdept);
    }

    /**
     * 设置 [DESCRIPTION]
     */
    public void setDescription(String  description){
        this.description = description ;
        this.modify("description",description);
    }

    /**
     * 设置 [DEPTPID]
     */
    public void setDeptpid(String  deptpid){
        this.deptpid = deptpid ;
        this.modify("deptpid",deptpid);
    }

    /**
     * 设置 [MGREMPID]
     */
    public void setMgrempid(String  mgrempid){
        this.mgrempid = mgrempid ;
        this.modify("mgrempid",mgrempid);
    }


}

