package cn.ibizlab.eam.webapi.dto;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.math.BigInteger;
import java.util.Map;
import java.util.HashMap;
import java.io.Serializable;
import java.math.BigDecimal;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.alibaba.fastjson.annotation.JSONField;
import cn.ibizlab.eam.util.domain.DTOBase;
import lombok.Data;

/**
 * 服务DTO对象[EMObjMapDTO]
 */
@Data
public class EMObjMapDTO extends DTOBase implements Serializable {

	private static final long serialVersionUID = 1L;

    /**
     * 属性 [EMOBJMAPID]
     *
     */
    @JSONField(name = "emobjmapid")
    @JsonProperty("emobjmapid")
    private String emobjmapid;

    /**
     * 属性 [UPDATEDATE]
     *
     */
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
    @JSONField(name = "updatedate" , format="yyyy-MM-dd HH:mm:ss")
    @JsonProperty("updatedate")
    private Timestamp updatedate;

    /**
     * 属性 [UPDATEMAN]
     *
     */
    @JSONField(name = "updateman")
    @JsonProperty("updateman")
    private String updateman;

    /**
     * 属性 [EQUIPID]
     *
     */
    @JSONField(name = "equipid")
    @JsonProperty("equipid")
    private String equipid;

    /**
     * 属性 [EMOBJMAPTYPE]
     *
     */
    @JSONField(name = "emobjmaptype")
    @JsonProperty("emobjmaptype")
    private String emobjmaptype;

    /**
     * 属性 [CREATEDATE]
     *
     */
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
    @JSONField(name = "createdate" , format="yyyy-MM-dd HH:mm:ss")
    @JsonProperty("createdate")
    private Timestamp createdate;

    /**
     * 属性 [EMOBJMAPNAME]
     *
     */
    @JSONField(name = "emobjmapname")
    @JsonProperty("emobjmapname")
    private String emobjmapname;

    /**
     * 属性 [CREATEMAN]
     *
     */
    @JSONField(name = "createman")
    @JsonProperty("createman")
    private String createman;

    /**
     * 属性 [DESCRIPTION]
     *
     */
    @JSONField(name = "description")
    @JsonProperty("description")
    private String description;

    /**
     * 属性 [ENABLE]
     *
     */
    @JSONField(name = "enable")
    @JsonProperty("enable")
    private Integer enable;

    /**
     * 属性 [ORGID]
     *
     */
    @JSONField(name = "orgid")
    @JsonProperty("orgid")
    private String orgid;

    /**
     * 属性 [OBJPTYPE]
     *
     */
    @JSONField(name = "objptype")
    @JsonProperty("objptype")
    private String objptype;

    /**
     * 属性 [MAJOREQUIPNAME]
     *
     */
    @JSONField(name = "majorequipname")
    @JsonProperty("majorequipname")
    private String majorequipname;

    /**
     * 属性 [MAJOREQUIPID]
     *
     */
    @JSONField(name = "majorequipid")
    @JsonProperty("majorequipid")
    private String majorequipid;

    /**
     * 属性 [OBJPNAME]
     *
     */
    @JSONField(name = "objpname")
    @JsonProperty("objpname")
    private String objpname;

    /**
     * 属性 [OBJTYPE]
     *
     */
    @JSONField(name = "objtype")
    @JsonProperty("objtype")
    private String objtype;

    /**
     * 属性 [OBJNAME]
     *
     */
    @JSONField(name = "objname")
    @JsonProperty("objname")
    private String objname;

    /**
     * 属性 [OBJID]
     *
     */
    @JSONField(name = "objid")
    @JsonProperty("objid")
    private String objid;

    /**
     * 属性 [OBJPID]
     *
     */
    @JSONField(name = "objpid")
    @JsonProperty("objpid")
    private String objpid;


    /**
     * 设置 [EMOBJMAPTYPE]
     */
    public void setEmobjmaptype(String  emobjmaptype){
        this.emobjmaptype = emobjmaptype ;
        this.modify("emobjmaptype",emobjmaptype);
    }

    /**
     * 设置 [EMOBJMAPNAME]
     */
    public void setEmobjmapname(String  emobjmapname){
        this.emobjmapname = emobjmapname ;
        this.modify("emobjmapname",emobjmapname);
    }

    /**
     * 设置 [DESCRIPTION]
     */
    public void setDescription(String  description){
        this.description = description ;
        this.modify("description",description);
    }

    /**
     * 设置 [OBJID]
     */
    public void setObjid(String  objid){
        this.objid = objid ;
        this.modify("objid",objid);
    }

    /**
     * 设置 [OBJPID]
     */
    public void setObjpid(String  objpid){
        this.objpid = objpid ;
        this.modify("objpid",objpid);
    }


}

