package cn.ibizlab.eam.webapi.dto;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.math.BigInteger;
import java.util.Map;
import java.util.HashMap;
import java.io.Serializable;
import java.math.BigDecimal;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.alibaba.fastjson.annotation.JSONField;
import cn.ibizlab.eam.util.domain.DTOBase;
import lombok.Data;

/**
 * 服务DTO对象[EMEQLCTTIResDTO]
 */
@Data
public class EMEQLCTTIResDTO extends DTOBase implements Serializable {

	private static final long serialVersionUID = 1L;

    /**
     * 属性 [CREATEMAN]
     *
     */
    @JSONField(name = "createman")
    @JsonProperty("createman")
    private String createman;

    /**
     * 属性 [TIRESSTATE]
     *
     */
    @JSONField(name = "tiresstate")
    @JsonProperty("tiresstate")
    private String tiresstate;

    /**
     * 属性 [DESCRIPTION]
     *
     */
    @JSONField(name = "description")
    @JsonProperty("description")
    private String description;

    /**
     * 属性 [PAR]
     *
     */
    @JSONField(name = "par")
    @JsonProperty("par")
    private String par;

    /**
     * 属性 [AMOUNT]
     *
     */
    @JSONField(name = "amount")
    @JsonProperty("amount")
    private String amount;

    /**
     * 属性 [ENABLE]
     *
     */
    @JSONField(name = "enable")
    @JsonProperty("enable")
    private Integer enable;

    /**
     * 属性 [PICPARAMS]
     *
     */
    @JSONField(name = "picparams")
    @JsonProperty("picparams")
    private String picparams;

    /**
     * 属性 [VALVE]
     *
     */
    @JSONField(name = "valve")
    @JsonProperty("valve")
    private Integer valve;

    /**
     * 属性 [REPLACEDATE]
     *
     */
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
    @JSONField(name = "replacedate" , format="yyyy-MM-dd HH:mm:ss")
    @JsonProperty("replacedate")
    private Timestamp replacedate;

    /**
     * 属性 [CREATEDATE]
     *
     */
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
    @JSONField(name = "createdate" , format="yyyy-MM-dd HH:mm:ss")
    @JsonProperty("createdate")
    private Timestamp createdate;

    /**
     * 属性 [EQMODELCODE]
     *
     */
    @JSONField(name = "eqmodelcode")
    @JsonProperty("eqmodelcode")
    private String eqmodelcode;

    /**
     * 属性 [ORGID]
     *
     */
    @JSONField(name = "orgid")
    @JsonProperty("orgid")
    private String orgid;

    /**
     * 属性 [NEWOLDFLAG]
     *
     */
    @JSONField(name = "newoldflag")
    @JsonProperty("newoldflag")
    private String newoldflag;

    /**
     * 属性 [CHANGP]
     *
     */
    @JSONField(name = "changp")
    @JsonProperty("changp")
    private String changp;

    /**
     * 属性 [SYSTEMPARAM]
     *
     */
    @JSONField(name = "systemparam")
    @JsonProperty("systemparam")
    private String systemparam;

    /**
     * 属性 [REPLACEREASON]
     *
     */
    @JSONField(name = "replacereason")
    @JsonProperty("replacereason")
    private String replacereason;

    /**
     * 属性 [LCTDESC]
     *
     */
    @JSONField(name = "lctdesc")
    @JsonProperty("lctdesc")
    private String lctdesc;

    /**
     * 属性 [UPDATEDATE]
     *
     */
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
    @JSONField(name = "updatedate" , format="yyyy-MM-dd HH:mm:ss")
    @JsonProperty("updatedate")
    private Timestamp updatedate;

    /**
     * 属性 [TIRESTYPE]
     *
     */
    @JSONField(name = "tirestype")
    @JsonProperty("tirestype")
    private String tirestype;

    /**
     * 属性 [LCTTIRESINFO]
     *
     */
    @JSONField(name = "lcttiresinfo")
    @JsonProperty("lcttiresinfo")
    private String lcttiresinfo;

    /**
     * 属性 [HAVEINNER]
     *
     */
    @JSONField(name = "haveinner")
    @JsonProperty("haveinner")
    private Integer haveinner;

    /**
     * 属性 [UPDATEMAN]
     *
     */
    @JSONField(name = "updateman")
    @JsonProperty("updateman")
    private String updateman;

    /**
     * 属性 [MCCODE]
     *
     */
    @JSONField(name = "mccode")
    @JsonProperty("mccode")
    private String mccode;

    /**
     * 属性 [LABSERVICENAME]
     *
     */
    @JSONField(name = "labservicename")
    @JsonProperty("labservicename")
    private String labservicename;

    /**
     * 属性 [MSERVICENAME]
     *
     */
    @JSONField(name = "mservicename")
    @JsonProperty("mservicename")
    private String mservicename;

    /**
     * 属性 [EQLOCATIONINFO]
     *
     */
    @JSONField(name = "eqlocationinfo")
    @JsonProperty("eqlocationinfo")
    private String eqlocationinfo;

    /**
     * 属性 [EQUIPNAME]
     *
     */
    @JSONField(name = "equipname")
    @JsonProperty("equipname")
    private String equipname;

    /**
     * 属性 [EQUIPID]
     *
     */
    @JSONField(name = "equipid")
    @JsonProperty("equipid")
    private String equipid;

    /**
     * 属性 [EMEQLOCATIONID]
     *
     */
    @JSONField(name = "emeqlocationid")
    @JsonProperty("emeqlocationid")
    private String emeqlocationid;

    /**
     * 属性 [LABSERVICEID]
     *
     */
    @JSONField(name = "labserviceid")
    @JsonProperty("labserviceid")
    private String labserviceid;

    /**
     * 属性 [MSERVICEID]
     *
     */
    @JSONField(name = "mserviceid")
    @JsonProperty("mserviceid")
    private String mserviceid;


    /**
     * 设置 [TIRESSTATE]
     */
    public void setTiresstate(String  tiresstate){
        this.tiresstate = tiresstate ;
        this.modify("tiresstate",tiresstate);
    }

    /**
     * 设置 [DESCRIPTION]
     */
    public void setDescription(String  description){
        this.description = description ;
        this.modify("description",description);
    }

    /**
     * 设置 [PAR]
     */
    public void setPar(String  par){
        this.par = par ;
        this.modify("par",par);
    }

    /**
     * 设置 [AMOUNT]
     */
    public void setAmount(String  amount){
        this.amount = amount ;
        this.modify("amount",amount);
    }

    /**
     * 设置 [PICPARAMS]
     */
    public void setPicparams(String  picparams){
        this.picparams = picparams ;
        this.modify("picparams",picparams);
    }

    /**
     * 设置 [VALVE]
     */
    public void setValve(Integer  valve){
        this.valve = valve ;
        this.modify("valve",valve);
    }

    /**
     * 设置 [EQMODELCODE]
     */
    public void setEqmodelcode(String  eqmodelcode){
        this.eqmodelcode = eqmodelcode ;
        this.modify("eqmodelcode",eqmodelcode);
    }

    /**
     * 设置 [NEWOLDFLAG]
     */
    public void setNewoldflag(String  newoldflag){
        this.newoldflag = newoldflag ;
        this.modify("newoldflag",newoldflag);
    }

    /**
     * 设置 [CHANGP]
     */
    public void setChangp(String  changp){
        this.changp = changp ;
        this.modify("changp",changp);
    }

    /**
     * 设置 [SYSTEMPARAM]
     */
    public void setSystemparam(String  systemparam){
        this.systemparam = systemparam ;
        this.modify("systemparam",systemparam);
    }

    /**
     * 设置 [LCTDESC]
     */
    public void setLctdesc(String  lctdesc){
        this.lctdesc = lctdesc ;
        this.modify("lctdesc",lctdesc);
    }

    /**
     * 设置 [TIRESTYPE]
     */
    public void setTirestype(String  tirestype){
        this.tirestype = tirestype ;
        this.modify("tirestype",tirestype);
    }

    /**
     * 设置 [HAVEINNER]
     */
    public void setHaveinner(Integer  haveinner){
        this.haveinner = haveinner ;
        this.modify("haveinner",haveinner);
    }

    /**
     * 设置 [EQUIPID]
     */
    public void setEquipid(String  equipid){
        this.equipid = equipid ;
        this.modify("equipid",equipid);
    }

    /**
     * 设置 [LABSERVICEID]
     */
    public void setLabserviceid(String  labserviceid){
        this.labserviceid = labserviceid ;
        this.modify("labserviceid",labserviceid);
    }

    /**
     * 设置 [MSERVICEID]
     */
    public void setMserviceid(String  mserviceid){
        this.mserviceid = mserviceid ;
        this.modify("mserviceid",mserviceid);
    }


}

