package cn.ibizlab.eam.webapi.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;
import javax.servlet.ServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import cn.ibizlab.eam.webapi.dto.*;
import cn.ibizlab.eam.webapi.mapping.*;
import cn.ibizlab.eam.core.eam_pf.domain.PFContract;
import cn.ibizlab.eam.core.eam_pf.service.IPFContractService;
import cn.ibizlab.eam.core.eam_pf.filter.PFContractSearchContext;

@Slf4j
@Api(tags = {"PFContract" })
@RestController("WebApi-pfcontract")
@RequestMapping("")
public class PFContractResource {

    @Autowired
    private IPFContractService pfcontractService;

    @Autowired
    @Lazy
    public PFContractMapping pfcontractMapping;

    public PFContractDTO permissionDTO=new PFContractDTO();

    @PreAuthorize("hasPermission(#pfcontract_id,'Remove',{'Sql',this.pfcontractMapping,this.permissionDTO})")
    @ApiOperation(value = "Remove", tags = {"PFContract" },  notes = "Remove")
	@RequestMapping(method = RequestMethod.DELETE, value = "/pfcontracts/{pfcontract_id}")
    @Transactional
    public ResponseEntity<Boolean> remove(@PathVariable("pfcontract_id") String pfcontract_id) {
         return ResponseEntity.status(HttpStatus.OK).body(pfcontractService.remove(pfcontract_id));
    }

    @PreAuthorize("hasPermission('Remove',{'Sql',this.pfcontractMapping,this.permissionDTO,#ids})")
    @ApiOperation(value = "RemoveBatch", tags = {"PFContract" },  notes = "RemoveBatch")
	@RequestMapping(method = RequestMethod.DELETE, value = "/pfcontracts/batch")
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        pfcontractService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(#pfcontract_id,'Get',{'Sql',this.pfcontractMapping,this.permissionDTO})")
    @ApiOperation(value = "Get", tags = {"PFContract" },  notes = "Get")
	@RequestMapping(method = RequestMethod.GET, value = "/pfcontracts/{pfcontract_id}")
    public ResponseEntity<PFContractDTO> get(@PathVariable("pfcontract_id") String pfcontract_id) {
        PFContract domain = pfcontractService.get(pfcontract_id);
        PFContractDTO dto = pfcontractMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-PFContract-GetDraft-all')")
    @ApiOperation(value = "GetDraft", tags = {"PFContract" },  notes = "GetDraft")
	@RequestMapping(method = RequestMethod.GET, value = "/pfcontracts/getdraft")
    public ResponseEntity<PFContractDTO> getDraft() {
        return ResponseEntity.status(HttpStatus.OK).body(pfcontractMapping.toDto(pfcontractService.getDraft(new PFContract())));
    }

    @PreAuthorize("hasPermission('','Save',{'Sql',this.pfcontractMapping,#pfcontractdto})")
    @ApiOperation(value = "Save", tags = {"PFContract" },  notes = "Save")
	@RequestMapping(method = RequestMethod.POST, value = "/pfcontracts/save")
    public ResponseEntity<Boolean> save(@RequestBody PFContractDTO pfcontractdto) {
        return ResponseEntity.status(HttpStatus.OK).body(pfcontractService.save(pfcontractMapping.toDomain(pfcontractdto)));
    }

    @PreAuthorize("hasPermission('Save',{'Sql',this.pfcontractMapping,#pfcontractdtos})")
    @ApiOperation(value = "SaveBatch", tags = {"PFContract" },  notes = "SaveBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/pfcontracts/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<PFContractDTO> pfcontractdtos) {
        pfcontractService.saveBatch(pfcontractMapping.toDomain(pfcontractdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-PFContract-CheckKey-all')")
    @ApiOperation(value = "CheckKey", tags = {"PFContract" },  notes = "CheckKey")
	@RequestMapping(method = RequestMethod.POST, value = "/pfcontracts/checkkey")
    public ResponseEntity<Boolean> checkKey(@RequestBody PFContractDTO pfcontractdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(pfcontractService.checkKey(pfcontractMapping.toDomain(pfcontractdto)));
    }

    @PreAuthorize("hasPermission(#pfcontract_id,'Update',{'Sql',this.pfcontractMapping,#pfcontractdto})")
    @ApiOperation(value = "Update", tags = {"PFContract" },  notes = "Update")
	@RequestMapping(method = RequestMethod.PUT, value = "/pfcontracts/{pfcontract_id}")
    @Transactional
    public ResponseEntity<PFContractDTO> update(@PathVariable("pfcontract_id") String pfcontract_id, @RequestBody PFContractDTO pfcontractdto) {
		PFContract domain  = pfcontractMapping.toDomain(pfcontractdto);
        domain .setPfcontractid(pfcontract_id);
		pfcontractService.update(domain );
		PFContractDTO dto = pfcontractMapping.toDto(domain );
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Update',{'Sql',this.pfcontractMapping,#pfcontractdtos})")
    @ApiOperation(value = "UpdateBatch", tags = {"PFContract" },  notes = "UpdateBatch")
	@RequestMapping(method = RequestMethod.PUT, value = "/pfcontracts/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<PFContractDTO> pfcontractdtos) {
        pfcontractService.updateBatch(pfcontractMapping.toDomain(pfcontractdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission('','Create',{'Sql',this.pfcontractMapping,#pfcontractdto})")
    @ApiOperation(value = "Create", tags = {"PFContract" },  notes = "Create")
	@RequestMapping(method = RequestMethod.POST, value = "/pfcontracts")
    @Transactional
    public ResponseEntity<PFContractDTO> create(@RequestBody PFContractDTO pfcontractdto) {
        PFContract domain = pfcontractMapping.toDomain(pfcontractdto);
		pfcontractService.create(domain);
        PFContractDTO dto = pfcontractMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Create',{'Sql',this.pfcontractMapping,#pfcontractdtos})")
    @ApiOperation(value = "createBatch", tags = {"PFContract" },  notes = "createBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/pfcontracts/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<PFContractDTO> pfcontractdtos) {
        pfcontractService.createBatch(pfcontractMapping.toDomain(pfcontractdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-PFContract-Default-all')")
	@ApiOperation(value = "fetchDEFAULT", tags = {"PFContract" } ,notes = "fetchDEFAULT")
    @RequestMapping(method= RequestMethod.GET , value="/pfcontracts/fetchdefault")
	public ResponseEntity<List<PFContractDTO>> fetchDefault(PFContractSearchContext context) {
        Page<PFContract> domains = pfcontractService.searchDefault(context) ;
        List<PFContractDTO> list = pfcontractMapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-PFContract-Default-all')")
	@ApiOperation(value = "searchDEFAULT", tags = {"PFContract" } ,notes = "searchDEFAULT")
    @RequestMapping(method= RequestMethod.POST , value="/pfcontracts/searchdefault")
	public ResponseEntity<Page<PFContractDTO>> searchDefault(@RequestBody PFContractSearchContext context) {
        Page<PFContract> domains = pfcontractService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(pfcontractMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
}
