package cn.ibizlab.eam.webapi.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;
import javax.servlet.ServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import cn.ibizlab.eam.webapi.dto.*;
import cn.ibizlab.eam.webapi.mapping.*;
import cn.ibizlab.eam.core.eam_core.domain.EMWPListCost;
import cn.ibizlab.eam.core.eam_core.service.IEMWPListCostService;
import cn.ibizlab.eam.core.eam_core.filter.EMWPListCostSearchContext;

@Slf4j
@Api(tags = {"EMWPListCost" })
@RestController("WebApi-emwplistcost")
@RequestMapping("")
public class EMWPListCostResource {

    @Autowired
    private IEMWPListCostService emwplistcostService;

    @Autowired
    @Lazy
    public EMWPListCostMapping emwplistcostMapping;

    public EMWPListCostDTO permissionDTO=new EMWPListCostDTO();

    @PreAuthorize("hasPermission(#emwplistcost_id,'Update',{'Sql',this.emwplistcostMapping,#emwplistcostdto})")
    @ApiOperation(value = "Update", tags = {"EMWPListCost" },  notes = "Update")
	@RequestMapping(method = RequestMethod.PUT, value = "/emwplistcosts/{emwplistcost_id}")
    @Transactional
    public ResponseEntity<EMWPListCostDTO> update(@PathVariable("emwplistcost_id") String emwplistcost_id, @RequestBody EMWPListCostDTO emwplistcostdto) {
		EMWPListCost domain  = emwplistcostMapping.toDomain(emwplistcostdto);
        domain .setEmwplistcostid(emwplistcost_id);
		emwplistcostService.update(domain );
		EMWPListCostDTO dto = emwplistcostMapping.toDto(domain );
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Update',{'Sql',this.emwplistcostMapping,#emwplistcostdtos})")
    @ApiOperation(value = "UpdateBatch", tags = {"EMWPListCost" },  notes = "UpdateBatch")
	@RequestMapping(method = RequestMethod.PUT, value = "/emwplistcosts/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<EMWPListCostDTO> emwplistcostdtos) {
        emwplistcostService.updateBatch(emwplistcostMapping.toDomain(emwplistcostdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission('','Create',{'Sql',this.emwplistcostMapping,#emwplistcostdto})")
    @ApiOperation(value = "Create", tags = {"EMWPListCost" },  notes = "Create")
	@RequestMapping(method = RequestMethod.POST, value = "/emwplistcosts")
    @Transactional
    public ResponseEntity<EMWPListCostDTO> create(@RequestBody EMWPListCostDTO emwplistcostdto) {
        EMWPListCost domain = emwplistcostMapping.toDomain(emwplistcostdto);
		emwplistcostService.create(domain);
        EMWPListCostDTO dto = emwplistcostMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Create',{'Sql',this.emwplistcostMapping,#emwplistcostdtos})")
    @ApiOperation(value = "createBatch", tags = {"EMWPListCost" },  notes = "createBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emwplistcosts/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<EMWPListCostDTO> emwplistcostdtos) {
        emwplistcostService.createBatch(emwplistcostMapping.toDomain(emwplistcostdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMWPListCost-GetDraft-all')")
    @ApiOperation(value = "GetDraft", tags = {"EMWPListCost" },  notes = "GetDraft")
	@RequestMapping(method = RequestMethod.GET, value = "/emwplistcosts/getdraft")
    public ResponseEntity<EMWPListCostDTO> getDraft() {
        return ResponseEntity.status(HttpStatus.OK).body(emwplistcostMapping.toDto(emwplistcostService.getDraft(new EMWPListCost())));
    }

    @PreAuthorize("hasPermission(#emwplistcost_id,'Remove',{'Sql',this.emwplistcostMapping,this.permissionDTO})")
    @ApiOperation(value = "Remove", tags = {"EMWPListCost" },  notes = "Remove")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emwplistcosts/{emwplistcost_id}")
    @Transactional
    public ResponseEntity<Boolean> remove(@PathVariable("emwplistcost_id") String emwplistcost_id) {
         return ResponseEntity.status(HttpStatus.OK).body(emwplistcostService.remove(emwplistcost_id));
    }

    @PreAuthorize("hasPermission('Remove',{'Sql',this.emwplistcostMapping,this.permissionDTO,#ids})")
    @ApiOperation(value = "RemoveBatch", tags = {"EMWPListCost" },  notes = "RemoveBatch")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emwplistcosts/batch")
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        emwplistcostService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(#emwplistcost_id,'Get',{'Sql',this.emwplistcostMapping,this.permissionDTO})")
    @ApiOperation(value = "Get", tags = {"EMWPListCost" },  notes = "Get")
	@RequestMapping(method = RequestMethod.GET, value = "/emwplistcosts/{emwplistcost_id}")
    public ResponseEntity<EMWPListCostDTO> get(@PathVariable("emwplistcost_id") String emwplistcost_id) {
        EMWPListCost domain = emwplistcostService.get(emwplistcost_id);
        EMWPListCostDTO dto = emwplistcostMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('','Save',{'Sql',this.emwplistcostMapping,#emwplistcostdto})")
    @ApiOperation(value = "Save", tags = {"EMWPListCost" },  notes = "Save")
	@RequestMapping(method = RequestMethod.POST, value = "/emwplistcosts/save")
    public ResponseEntity<Boolean> save(@RequestBody EMWPListCostDTO emwplistcostdto) {
        return ResponseEntity.status(HttpStatus.OK).body(emwplistcostService.save(emwplistcostMapping.toDomain(emwplistcostdto)));
    }

    @PreAuthorize("hasPermission('Save',{'Sql',this.emwplistcostMapping,#emwplistcostdtos})")
    @ApiOperation(value = "SaveBatch", tags = {"EMWPListCost" },  notes = "SaveBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emwplistcosts/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<EMWPListCostDTO> emwplistcostdtos) {
        emwplistcostService.saveBatch(emwplistcostMapping.toDomain(emwplistcostdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMWPListCost-CheckKey-all')")
    @ApiOperation(value = "CheckKey", tags = {"EMWPListCost" },  notes = "CheckKey")
	@RequestMapping(method = RequestMethod.POST, value = "/emwplistcosts/checkkey")
    public ResponseEntity<Boolean> checkKey(@RequestBody EMWPListCostDTO emwplistcostdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emwplistcostService.checkKey(emwplistcostMapping.toDomain(emwplistcostdto)));
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMWPListCost-Default-all')")
	@ApiOperation(value = "fetchDEFAULT", tags = {"EMWPListCost" } ,notes = "fetchDEFAULT")
    @RequestMapping(method= RequestMethod.GET , value="/emwplistcosts/fetchdefault")
	public ResponseEntity<List<EMWPListCostDTO>> fetchDefault(EMWPListCostSearchContext context) {
        Page<EMWPListCost> domains = emwplistcostService.searchDefault(context) ;
        List<EMWPListCostDTO> list = emwplistcostMapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMWPListCost-Default-all')")
	@ApiOperation(value = "searchDEFAULT", tags = {"EMWPListCost" } ,notes = "searchDEFAULT")
    @RequestMapping(method= RequestMethod.POST , value="/emwplistcosts/searchdefault")
	public ResponseEntity<Page<EMWPListCostDTO>> searchDefault(@RequestBody EMWPListCostSearchContext context) {
        Page<EMWPListCost> domains = emwplistcostService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emwplistcostMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
    @PreAuthorize("hasPermission(#emwplistcost_id,'Update',{'Sql',this.emwplistcostMapping,#emwplistcostdto})")
    @ApiOperation(value = "UpdateByEMItem", tags = {"EMWPListCost" },  notes = "UpdateByEMItem")
	@RequestMapping(method = RequestMethod.PUT, value = "/emitems/{emitem_id}/emwplistcosts/{emwplistcost_id}")
    @Transactional
    public ResponseEntity<EMWPListCostDTO> updateByEMItem(@PathVariable("emitem_id") String emitem_id, @PathVariable("emwplistcost_id") String emwplistcost_id, @RequestBody EMWPListCostDTO emwplistcostdto) {
        EMWPListCost domain = emwplistcostMapping.toDomain(emwplistcostdto);
        domain.setItemid(emitem_id);
        domain.setEmwplistcostid(emwplistcost_id);
		emwplistcostService.update(domain);
        EMWPListCostDTO dto = emwplistcostMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Update',{'Sql',this.emwplistcostMapping,#emwplistcostdtos})")
    @ApiOperation(value = "UpdateBatchByEMItem", tags = {"EMWPListCost" },  notes = "UpdateBatchByEMItem")
	@RequestMapping(method = RequestMethod.PUT, value = "/emitems/{emitem_id}/emwplistcosts/batch")
    public ResponseEntity<Boolean> updateBatchByEMItem(@PathVariable("emitem_id") String emitem_id, @RequestBody List<EMWPListCostDTO> emwplistcostdtos) {
        List<EMWPListCost> domainlist=emwplistcostMapping.toDomain(emwplistcostdtos);
        for(EMWPListCost domain:domainlist){
            domain.setItemid(emitem_id);
        }
        emwplistcostService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission('','Create',{'Sql',this.emwplistcostMapping,#emwplistcostdto})")
    @ApiOperation(value = "CreateByEMItem", tags = {"EMWPListCost" },  notes = "CreateByEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emitems/{emitem_id}/emwplistcosts")
    @Transactional
    public ResponseEntity<EMWPListCostDTO> createByEMItem(@PathVariable("emitem_id") String emitem_id, @RequestBody EMWPListCostDTO emwplistcostdto) {
        EMWPListCost domain = emwplistcostMapping.toDomain(emwplistcostdto);
        domain.setItemid(emitem_id);
		emwplistcostService.create(domain);
        EMWPListCostDTO dto = emwplistcostMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Create',{'Sql',this.emwplistcostMapping,#emwplistcostdtos})")
    @ApiOperation(value = "createBatchByEMItem", tags = {"EMWPListCost" },  notes = "createBatchByEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emitems/{emitem_id}/emwplistcosts/batch")
    public ResponseEntity<Boolean> createBatchByEMItem(@PathVariable("emitem_id") String emitem_id, @RequestBody List<EMWPListCostDTO> emwplistcostdtos) {
        List<EMWPListCost> domainlist=emwplistcostMapping.toDomain(emwplistcostdtos);
        for(EMWPListCost domain:domainlist){
            domain.setItemid(emitem_id);
        }
        emwplistcostService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMWPListCost-GetDraft-all')")
    @ApiOperation(value = "GetDraftByEMItem", tags = {"EMWPListCost" },  notes = "GetDraftByEMItem")
    @RequestMapping(method = RequestMethod.GET, value = "/emitems/{emitem_id}/emwplistcosts/getdraft")
    public ResponseEntity<EMWPListCostDTO> getDraftByEMItem(@PathVariable("emitem_id") String emitem_id) {
        EMWPListCost domain = new EMWPListCost();
        domain.setItemid(emitem_id);
        return ResponseEntity.status(HttpStatus.OK).body(emwplistcostMapping.toDto(emwplistcostService.getDraft(domain)));
    }

    @PreAuthorize("hasPermission(#emwplistcost_id,'Remove',{'Sql',this.emwplistcostMapping,this.permissionDTO})")
    @ApiOperation(value = "RemoveByEMItem", tags = {"EMWPListCost" },  notes = "RemoveByEMItem")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emitems/{emitem_id}/emwplistcosts/{emwplistcost_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByEMItem(@PathVariable("emitem_id") String emitem_id, @PathVariable("emwplistcost_id") String emwplistcost_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emwplistcostService.remove(emwplistcost_id));
    }

    @PreAuthorize("hasPermission('Remove',{'Sql',this.emwplistcostMapping,this.permissionDTO,#ids})")
    @ApiOperation(value = "RemoveBatchByEMItem", tags = {"EMWPListCost" },  notes = "RemoveBatchByEMItem")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emitems/{emitem_id}/emwplistcosts/batch")
    public ResponseEntity<Boolean> removeBatchByEMItem(@RequestBody List<String> ids) {
        emwplistcostService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(#emwplistcost_id,'Get',{'Sql',this.emwplistcostMapping,this.permissionDTO})")
    @ApiOperation(value = "GetByEMItem", tags = {"EMWPListCost" },  notes = "GetByEMItem")
	@RequestMapping(method = RequestMethod.GET, value = "/emitems/{emitem_id}/emwplistcosts/{emwplistcost_id}")
    public ResponseEntity<EMWPListCostDTO> getByEMItem(@PathVariable("emitem_id") String emitem_id, @PathVariable("emwplistcost_id") String emwplistcost_id) {
        EMWPListCost domain = emwplistcostService.get(emwplistcost_id);
        EMWPListCostDTO dto = emwplistcostMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('','Save',{'Sql',this.emwplistcostMapping,#emwplistcostdto})")
    @ApiOperation(value = "SaveByEMItem", tags = {"EMWPListCost" },  notes = "SaveByEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emitems/{emitem_id}/emwplistcosts/save")
    public ResponseEntity<Boolean> saveByEMItem(@PathVariable("emitem_id") String emitem_id, @RequestBody EMWPListCostDTO emwplistcostdto) {
        EMWPListCost domain = emwplistcostMapping.toDomain(emwplistcostdto);
        domain.setItemid(emitem_id);
        return ResponseEntity.status(HttpStatus.OK).body(emwplistcostService.save(domain));
    }

    @PreAuthorize("hasPermission('Save',{'Sql',this.emwplistcostMapping,#emwplistcostdtos})")
    @ApiOperation(value = "SaveBatchByEMItem", tags = {"EMWPListCost" },  notes = "SaveBatchByEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emitems/{emitem_id}/emwplistcosts/savebatch")
    public ResponseEntity<Boolean> saveBatchByEMItem(@PathVariable("emitem_id") String emitem_id, @RequestBody List<EMWPListCostDTO> emwplistcostdtos) {
        List<EMWPListCost> domainlist=emwplistcostMapping.toDomain(emwplistcostdtos);
        for(EMWPListCost domain:domainlist){
             domain.setItemid(emitem_id);
        }
        emwplistcostService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMWPListCost-CheckKey-all')")
    @ApiOperation(value = "CheckKeyByEMItem", tags = {"EMWPListCost" },  notes = "CheckKeyByEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emitems/{emitem_id}/emwplistcosts/checkkey")
    public ResponseEntity<Boolean> checkKeyByEMItem(@PathVariable("emitem_id") String emitem_id, @RequestBody EMWPListCostDTO emwplistcostdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emwplistcostService.checkKey(emwplistcostMapping.toDomain(emwplistcostdto)));
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMWPListCost-Default-all')")
	@ApiOperation(value = "fetchDEFAULTByEMItem", tags = {"EMWPListCost" } ,notes = "fetchDEFAULTByEMItem")
    @RequestMapping(method= RequestMethod.GET , value="/emitems/{emitem_id}/emwplistcosts/fetchdefault")
	public ResponseEntity<List<EMWPListCostDTO>> fetchEMWPListCostDefaultByEMItem(@PathVariable("emitem_id") String emitem_id,EMWPListCostSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMWPListCost> domains = emwplistcostService.searchDefault(context) ;
        List<EMWPListCostDTO> list = emwplistcostMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMWPListCost-Default-all')")
	@ApiOperation(value = "searchDEFAULTByEMItem", tags = {"EMWPListCost" } ,notes = "searchDEFAULTByEMItem")
    @RequestMapping(method= RequestMethod.POST , value="/emitems/{emitem_id}/emwplistcosts/searchdefault")
	public ResponseEntity<Page<EMWPListCostDTO>> searchEMWPListCostDefaultByEMItem(@PathVariable("emitem_id") String emitem_id, @RequestBody EMWPListCostSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMWPListCost> domains = emwplistcostService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emwplistcostMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
    @PreAuthorize("hasPermission(#emwplistcost_id,'Update',{'Sql',this.emwplistcostMapping,#emwplistcostdto})")
    @ApiOperation(value = "UpdateByEMWPList", tags = {"EMWPListCost" },  notes = "UpdateByEMWPList")
	@RequestMapping(method = RequestMethod.PUT, value = "/emwplists/{emwplist_id}/emwplistcosts/{emwplistcost_id}")
    @Transactional
    public ResponseEntity<EMWPListCostDTO> updateByEMWPList(@PathVariable("emwplist_id") String emwplist_id, @PathVariable("emwplistcost_id") String emwplistcost_id, @RequestBody EMWPListCostDTO emwplistcostdto) {
        EMWPListCost domain = emwplistcostMapping.toDomain(emwplistcostdto);
        domain.setWplistid(emwplist_id);
        domain.setEmwplistcostid(emwplistcost_id);
		emwplistcostService.update(domain);
        EMWPListCostDTO dto = emwplistcostMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Update',{'Sql',this.emwplistcostMapping,#emwplistcostdtos})")
    @ApiOperation(value = "UpdateBatchByEMWPList", tags = {"EMWPListCost" },  notes = "UpdateBatchByEMWPList")
	@RequestMapping(method = RequestMethod.PUT, value = "/emwplists/{emwplist_id}/emwplistcosts/batch")
    public ResponseEntity<Boolean> updateBatchByEMWPList(@PathVariable("emwplist_id") String emwplist_id, @RequestBody List<EMWPListCostDTO> emwplistcostdtos) {
        List<EMWPListCost> domainlist=emwplistcostMapping.toDomain(emwplistcostdtos);
        for(EMWPListCost domain:domainlist){
            domain.setWplistid(emwplist_id);
        }
        emwplistcostService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission('','Create',{'Sql',this.emwplistcostMapping,#emwplistcostdto})")
    @ApiOperation(value = "CreateByEMWPList", tags = {"EMWPListCost" },  notes = "CreateByEMWPList")
	@RequestMapping(method = RequestMethod.POST, value = "/emwplists/{emwplist_id}/emwplistcosts")
    @Transactional
    public ResponseEntity<EMWPListCostDTO> createByEMWPList(@PathVariable("emwplist_id") String emwplist_id, @RequestBody EMWPListCostDTO emwplistcostdto) {
        EMWPListCost domain = emwplistcostMapping.toDomain(emwplistcostdto);
        domain.setWplistid(emwplist_id);
		emwplistcostService.create(domain);
        EMWPListCostDTO dto = emwplistcostMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Create',{'Sql',this.emwplistcostMapping,#emwplistcostdtos})")
    @ApiOperation(value = "createBatchByEMWPList", tags = {"EMWPListCost" },  notes = "createBatchByEMWPList")
	@RequestMapping(method = RequestMethod.POST, value = "/emwplists/{emwplist_id}/emwplistcosts/batch")
    public ResponseEntity<Boolean> createBatchByEMWPList(@PathVariable("emwplist_id") String emwplist_id, @RequestBody List<EMWPListCostDTO> emwplistcostdtos) {
        List<EMWPListCost> domainlist=emwplistcostMapping.toDomain(emwplistcostdtos);
        for(EMWPListCost domain:domainlist){
            domain.setWplistid(emwplist_id);
        }
        emwplistcostService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMWPListCost-GetDraft-all')")
    @ApiOperation(value = "GetDraftByEMWPList", tags = {"EMWPListCost" },  notes = "GetDraftByEMWPList")
    @RequestMapping(method = RequestMethod.GET, value = "/emwplists/{emwplist_id}/emwplistcosts/getdraft")
    public ResponseEntity<EMWPListCostDTO> getDraftByEMWPList(@PathVariable("emwplist_id") String emwplist_id) {
        EMWPListCost domain = new EMWPListCost();
        domain.setWplistid(emwplist_id);
        return ResponseEntity.status(HttpStatus.OK).body(emwplistcostMapping.toDto(emwplistcostService.getDraft(domain)));
    }

    @PreAuthorize("hasPermission(#emwplistcost_id,'Remove',{'Sql',this.emwplistcostMapping,this.permissionDTO})")
    @ApiOperation(value = "RemoveByEMWPList", tags = {"EMWPListCost" },  notes = "RemoveByEMWPList")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emwplists/{emwplist_id}/emwplistcosts/{emwplistcost_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByEMWPList(@PathVariable("emwplist_id") String emwplist_id, @PathVariable("emwplistcost_id") String emwplistcost_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emwplistcostService.remove(emwplistcost_id));
    }

    @PreAuthorize("hasPermission('Remove',{'Sql',this.emwplistcostMapping,this.permissionDTO,#ids})")
    @ApiOperation(value = "RemoveBatchByEMWPList", tags = {"EMWPListCost" },  notes = "RemoveBatchByEMWPList")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emwplists/{emwplist_id}/emwplistcosts/batch")
    public ResponseEntity<Boolean> removeBatchByEMWPList(@RequestBody List<String> ids) {
        emwplistcostService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(#emwplistcost_id,'Get',{'Sql',this.emwplistcostMapping,this.permissionDTO})")
    @ApiOperation(value = "GetByEMWPList", tags = {"EMWPListCost" },  notes = "GetByEMWPList")
	@RequestMapping(method = RequestMethod.GET, value = "/emwplists/{emwplist_id}/emwplistcosts/{emwplistcost_id}")
    public ResponseEntity<EMWPListCostDTO> getByEMWPList(@PathVariable("emwplist_id") String emwplist_id, @PathVariable("emwplistcost_id") String emwplistcost_id) {
        EMWPListCost domain = emwplistcostService.get(emwplistcost_id);
        EMWPListCostDTO dto = emwplistcostMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('','Save',{'Sql',this.emwplistcostMapping,#emwplistcostdto})")
    @ApiOperation(value = "SaveByEMWPList", tags = {"EMWPListCost" },  notes = "SaveByEMWPList")
	@RequestMapping(method = RequestMethod.POST, value = "/emwplists/{emwplist_id}/emwplistcosts/save")
    public ResponseEntity<Boolean> saveByEMWPList(@PathVariable("emwplist_id") String emwplist_id, @RequestBody EMWPListCostDTO emwplistcostdto) {
        EMWPListCost domain = emwplistcostMapping.toDomain(emwplistcostdto);
        domain.setWplistid(emwplist_id);
        return ResponseEntity.status(HttpStatus.OK).body(emwplistcostService.save(domain));
    }

    @PreAuthorize("hasPermission('Save',{'Sql',this.emwplistcostMapping,#emwplistcostdtos})")
    @ApiOperation(value = "SaveBatchByEMWPList", tags = {"EMWPListCost" },  notes = "SaveBatchByEMWPList")
	@RequestMapping(method = RequestMethod.POST, value = "/emwplists/{emwplist_id}/emwplistcosts/savebatch")
    public ResponseEntity<Boolean> saveBatchByEMWPList(@PathVariable("emwplist_id") String emwplist_id, @RequestBody List<EMWPListCostDTO> emwplistcostdtos) {
        List<EMWPListCost> domainlist=emwplistcostMapping.toDomain(emwplistcostdtos);
        for(EMWPListCost domain:domainlist){
             domain.setWplistid(emwplist_id);
        }
        emwplistcostService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMWPListCost-CheckKey-all')")
    @ApiOperation(value = "CheckKeyByEMWPList", tags = {"EMWPListCost" },  notes = "CheckKeyByEMWPList")
	@RequestMapping(method = RequestMethod.POST, value = "/emwplists/{emwplist_id}/emwplistcosts/checkkey")
    public ResponseEntity<Boolean> checkKeyByEMWPList(@PathVariable("emwplist_id") String emwplist_id, @RequestBody EMWPListCostDTO emwplistcostdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emwplistcostService.checkKey(emwplistcostMapping.toDomain(emwplistcostdto)));
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMWPListCost-Default-all')")
	@ApiOperation(value = "fetchDEFAULTByEMWPList", tags = {"EMWPListCost" } ,notes = "fetchDEFAULTByEMWPList")
    @RequestMapping(method= RequestMethod.GET , value="/emwplists/{emwplist_id}/emwplistcosts/fetchdefault")
	public ResponseEntity<List<EMWPListCostDTO>> fetchEMWPListCostDefaultByEMWPList(@PathVariable("emwplist_id") String emwplist_id,EMWPListCostSearchContext context) {
        context.setN_wplistid_eq(emwplist_id);
        Page<EMWPListCost> domains = emwplistcostService.searchDefault(context) ;
        List<EMWPListCostDTO> list = emwplistcostMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMWPListCost-Default-all')")
	@ApiOperation(value = "searchDEFAULTByEMWPList", tags = {"EMWPListCost" } ,notes = "searchDEFAULTByEMWPList")
    @RequestMapping(method= RequestMethod.POST , value="/emwplists/{emwplist_id}/emwplistcosts/searchdefault")
	public ResponseEntity<Page<EMWPListCostDTO>> searchEMWPListCostDefaultByEMWPList(@PathVariable("emwplist_id") String emwplist_id, @RequestBody EMWPListCostSearchContext context) {
        context.setN_wplistid_eq(emwplist_id);
        Page<EMWPListCost> domains = emwplistcostService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emwplistcostMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
    @PreAuthorize("hasPermission(#emwplistcost_id,'Update',{'Sql',this.emwplistcostMapping,#emwplistcostdto})")
    @ApiOperation(value = "UpdateByEMServiceEMItem", tags = {"EMWPListCost" },  notes = "UpdateByEMServiceEMItem")
	@RequestMapping(method = RequestMethod.PUT, value = "/emservices/{emservice_id}/emitems/{emitem_id}/emwplistcosts/{emwplistcost_id}")
    @Transactional
    public ResponseEntity<EMWPListCostDTO> updateByEMServiceEMItem(@PathVariable("emservice_id") String emservice_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emwplistcost_id") String emwplistcost_id, @RequestBody EMWPListCostDTO emwplistcostdto) {
        EMWPListCost domain = emwplistcostMapping.toDomain(emwplistcostdto);
        domain.setItemid(emitem_id);
        domain.setEmwplistcostid(emwplistcost_id);
		emwplistcostService.update(domain);
        EMWPListCostDTO dto = emwplistcostMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Update',{'Sql',this.emwplistcostMapping,#emwplistcostdtos})")
    @ApiOperation(value = "UpdateBatchByEMServiceEMItem", tags = {"EMWPListCost" },  notes = "UpdateBatchByEMServiceEMItem")
	@RequestMapping(method = RequestMethod.PUT, value = "/emservices/{emservice_id}/emitems/{emitem_id}/emwplistcosts/batch")
    public ResponseEntity<Boolean> updateBatchByEMServiceEMItem(@PathVariable("emservice_id") String emservice_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMWPListCostDTO> emwplistcostdtos) {
        List<EMWPListCost> domainlist=emwplistcostMapping.toDomain(emwplistcostdtos);
        for(EMWPListCost domain:domainlist){
            domain.setItemid(emitem_id);
        }
        emwplistcostService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission('','Create',{'Sql',this.emwplistcostMapping,#emwplistcostdto})")
    @ApiOperation(value = "CreateByEMServiceEMItem", tags = {"EMWPListCost" },  notes = "CreateByEMServiceEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emservices/{emservice_id}/emitems/{emitem_id}/emwplistcosts")
    @Transactional
    public ResponseEntity<EMWPListCostDTO> createByEMServiceEMItem(@PathVariable("emservice_id") String emservice_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMWPListCostDTO emwplistcostdto) {
        EMWPListCost domain = emwplistcostMapping.toDomain(emwplistcostdto);
        domain.setItemid(emitem_id);
		emwplistcostService.create(domain);
        EMWPListCostDTO dto = emwplistcostMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Create',{'Sql',this.emwplistcostMapping,#emwplistcostdtos})")
    @ApiOperation(value = "createBatchByEMServiceEMItem", tags = {"EMWPListCost" },  notes = "createBatchByEMServiceEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emservices/{emservice_id}/emitems/{emitem_id}/emwplistcosts/batch")
    public ResponseEntity<Boolean> createBatchByEMServiceEMItem(@PathVariable("emservice_id") String emservice_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMWPListCostDTO> emwplistcostdtos) {
        List<EMWPListCost> domainlist=emwplistcostMapping.toDomain(emwplistcostdtos);
        for(EMWPListCost domain:domainlist){
            domain.setItemid(emitem_id);
        }
        emwplistcostService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMWPListCost-GetDraft-all')")
    @ApiOperation(value = "GetDraftByEMServiceEMItem", tags = {"EMWPListCost" },  notes = "GetDraftByEMServiceEMItem")
    @RequestMapping(method = RequestMethod.GET, value = "/emservices/{emservice_id}/emitems/{emitem_id}/emwplistcosts/getdraft")
    public ResponseEntity<EMWPListCostDTO> getDraftByEMServiceEMItem(@PathVariable("emservice_id") String emservice_id, @PathVariable("emitem_id") String emitem_id) {
        EMWPListCost domain = new EMWPListCost();
        domain.setItemid(emitem_id);
        return ResponseEntity.status(HttpStatus.OK).body(emwplistcostMapping.toDto(emwplistcostService.getDraft(domain)));
    }

    @PreAuthorize("hasPermission(#emwplistcost_id,'Remove',{'Sql',this.emwplistcostMapping,this.permissionDTO})")
    @ApiOperation(value = "RemoveByEMServiceEMItem", tags = {"EMWPListCost" },  notes = "RemoveByEMServiceEMItem")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emservices/{emservice_id}/emitems/{emitem_id}/emwplistcosts/{emwplistcost_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByEMServiceEMItem(@PathVariable("emservice_id") String emservice_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emwplistcost_id") String emwplistcost_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emwplistcostService.remove(emwplistcost_id));
    }

    @PreAuthorize("hasPermission('Remove',{'Sql',this.emwplistcostMapping,this.permissionDTO,#ids})")
    @ApiOperation(value = "RemoveBatchByEMServiceEMItem", tags = {"EMWPListCost" },  notes = "RemoveBatchByEMServiceEMItem")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emservices/{emservice_id}/emitems/{emitem_id}/emwplistcosts/batch")
    public ResponseEntity<Boolean> removeBatchByEMServiceEMItem(@RequestBody List<String> ids) {
        emwplistcostService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(#emwplistcost_id,'Get',{'Sql',this.emwplistcostMapping,this.permissionDTO})")
    @ApiOperation(value = "GetByEMServiceEMItem", tags = {"EMWPListCost" },  notes = "GetByEMServiceEMItem")
	@RequestMapping(method = RequestMethod.GET, value = "/emservices/{emservice_id}/emitems/{emitem_id}/emwplistcosts/{emwplistcost_id}")
    public ResponseEntity<EMWPListCostDTO> getByEMServiceEMItem(@PathVariable("emservice_id") String emservice_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emwplistcost_id") String emwplistcost_id) {
        EMWPListCost domain = emwplistcostService.get(emwplistcost_id);
        EMWPListCostDTO dto = emwplistcostMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('','Save',{'Sql',this.emwplistcostMapping,#emwplistcostdto})")
    @ApiOperation(value = "SaveByEMServiceEMItem", tags = {"EMWPListCost" },  notes = "SaveByEMServiceEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emservices/{emservice_id}/emitems/{emitem_id}/emwplistcosts/save")
    public ResponseEntity<Boolean> saveByEMServiceEMItem(@PathVariable("emservice_id") String emservice_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMWPListCostDTO emwplistcostdto) {
        EMWPListCost domain = emwplistcostMapping.toDomain(emwplistcostdto);
        domain.setItemid(emitem_id);
        return ResponseEntity.status(HttpStatus.OK).body(emwplistcostService.save(domain));
    }

    @PreAuthorize("hasPermission('Save',{'Sql',this.emwplistcostMapping,#emwplistcostdtos})")
    @ApiOperation(value = "SaveBatchByEMServiceEMItem", tags = {"EMWPListCost" },  notes = "SaveBatchByEMServiceEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emservices/{emservice_id}/emitems/{emitem_id}/emwplistcosts/savebatch")
    public ResponseEntity<Boolean> saveBatchByEMServiceEMItem(@PathVariable("emservice_id") String emservice_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMWPListCostDTO> emwplistcostdtos) {
        List<EMWPListCost> domainlist=emwplistcostMapping.toDomain(emwplistcostdtos);
        for(EMWPListCost domain:domainlist){
             domain.setItemid(emitem_id);
        }
        emwplistcostService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMWPListCost-CheckKey-all')")
    @ApiOperation(value = "CheckKeyByEMServiceEMItem", tags = {"EMWPListCost" },  notes = "CheckKeyByEMServiceEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emservices/{emservice_id}/emitems/{emitem_id}/emwplistcosts/checkkey")
    public ResponseEntity<Boolean> checkKeyByEMServiceEMItem(@PathVariable("emservice_id") String emservice_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMWPListCostDTO emwplistcostdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emwplistcostService.checkKey(emwplistcostMapping.toDomain(emwplistcostdto)));
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMWPListCost-Default-all')")
	@ApiOperation(value = "fetchDEFAULTByEMServiceEMItem", tags = {"EMWPListCost" } ,notes = "fetchDEFAULTByEMServiceEMItem")
    @RequestMapping(method= RequestMethod.GET , value="/emservices/{emservice_id}/emitems/{emitem_id}/emwplistcosts/fetchdefault")
	public ResponseEntity<List<EMWPListCostDTO>> fetchEMWPListCostDefaultByEMServiceEMItem(@PathVariable("emservice_id") String emservice_id, @PathVariable("emitem_id") String emitem_id,EMWPListCostSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMWPListCost> domains = emwplistcostService.searchDefault(context) ;
        List<EMWPListCostDTO> list = emwplistcostMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMWPListCost-Default-all')")
	@ApiOperation(value = "searchDEFAULTByEMServiceEMItem", tags = {"EMWPListCost" } ,notes = "searchDEFAULTByEMServiceEMItem")
    @RequestMapping(method= RequestMethod.POST , value="/emservices/{emservice_id}/emitems/{emitem_id}/emwplistcosts/searchdefault")
	public ResponseEntity<Page<EMWPListCostDTO>> searchEMWPListCostDefaultByEMServiceEMItem(@PathVariable("emservice_id") String emservice_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMWPListCostSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMWPListCost> domains = emwplistcostService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emwplistcostMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
    @PreAuthorize("hasPermission(#emwplistcost_id,'Update',{'Sql',this.emwplistcostMapping,#emwplistcostdto})")
    @ApiOperation(value = "UpdateByEMStorePartEMItem", tags = {"EMWPListCost" },  notes = "UpdateByEMStorePartEMItem")
	@RequestMapping(method = RequestMethod.PUT, value = "/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emwplistcosts/{emwplistcost_id}")
    @Transactional
    public ResponseEntity<EMWPListCostDTO> updateByEMStorePartEMItem(@PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emwplistcost_id") String emwplistcost_id, @RequestBody EMWPListCostDTO emwplistcostdto) {
        EMWPListCost domain = emwplistcostMapping.toDomain(emwplistcostdto);
        domain.setItemid(emitem_id);
        domain.setEmwplistcostid(emwplistcost_id);
		emwplistcostService.update(domain);
        EMWPListCostDTO dto = emwplistcostMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Update',{'Sql',this.emwplistcostMapping,#emwplistcostdtos})")
    @ApiOperation(value = "UpdateBatchByEMStorePartEMItem", tags = {"EMWPListCost" },  notes = "UpdateBatchByEMStorePartEMItem")
	@RequestMapping(method = RequestMethod.PUT, value = "/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emwplistcosts/batch")
    public ResponseEntity<Boolean> updateBatchByEMStorePartEMItem(@PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMWPListCostDTO> emwplistcostdtos) {
        List<EMWPListCost> domainlist=emwplistcostMapping.toDomain(emwplistcostdtos);
        for(EMWPListCost domain:domainlist){
            domain.setItemid(emitem_id);
        }
        emwplistcostService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission('','Create',{'Sql',this.emwplistcostMapping,#emwplistcostdto})")
    @ApiOperation(value = "CreateByEMStorePartEMItem", tags = {"EMWPListCost" },  notes = "CreateByEMStorePartEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emwplistcosts")
    @Transactional
    public ResponseEntity<EMWPListCostDTO> createByEMStorePartEMItem(@PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMWPListCostDTO emwplistcostdto) {
        EMWPListCost domain = emwplistcostMapping.toDomain(emwplistcostdto);
        domain.setItemid(emitem_id);
		emwplistcostService.create(domain);
        EMWPListCostDTO dto = emwplistcostMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Create',{'Sql',this.emwplistcostMapping,#emwplistcostdtos})")
    @ApiOperation(value = "createBatchByEMStorePartEMItem", tags = {"EMWPListCost" },  notes = "createBatchByEMStorePartEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emwplistcosts/batch")
    public ResponseEntity<Boolean> createBatchByEMStorePartEMItem(@PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMWPListCostDTO> emwplistcostdtos) {
        List<EMWPListCost> domainlist=emwplistcostMapping.toDomain(emwplistcostdtos);
        for(EMWPListCost domain:domainlist){
            domain.setItemid(emitem_id);
        }
        emwplistcostService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMWPListCost-GetDraft-all')")
    @ApiOperation(value = "GetDraftByEMStorePartEMItem", tags = {"EMWPListCost" },  notes = "GetDraftByEMStorePartEMItem")
    @RequestMapping(method = RequestMethod.GET, value = "/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emwplistcosts/getdraft")
    public ResponseEntity<EMWPListCostDTO> getDraftByEMStorePartEMItem(@PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id) {
        EMWPListCost domain = new EMWPListCost();
        domain.setItemid(emitem_id);
        return ResponseEntity.status(HttpStatus.OK).body(emwplistcostMapping.toDto(emwplistcostService.getDraft(domain)));
    }

    @PreAuthorize("hasPermission(#emwplistcost_id,'Remove',{'Sql',this.emwplistcostMapping,this.permissionDTO})")
    @ApiOperation(value = "RemoveByEMStorePartEMItem", tags = {"EMWPListCost" },  notes = "RemoveByEMStorePartEMItem")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emwplistcosts/{emwplistcost_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByEMStorePartEMItem(@PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emwplistcost_id") String emwplistcost_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emwplistcostService.remove(emwplistcost_id));
    }

    @PreAuthorize("hasPermission('Remove',{'Sql',this.emwplistcostMapping,this.permissionDTO,#ids})")
    @ApiOperation(value = "RemoveBatchByEMStorePartEMItem", tags = {"EMWPListCost" },  notes = "RemoveBatchByEMStorePartEMItem")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emwplistcosts/batch")
    public ResponseEntity<Boolean> removeBatchByEMStorePartEMItem(@RequestBody List<String> ids) {
        emwplistcostService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(#emwplistcost_id,'Get',{'Sql',this.emwplistcostMapping,this.permissionDTO})")
    @ApiOperation(value = "GetByEMStorePartEMItem", tags = {"EMWPListCost" },  notes = "GetByEMStorePartEMItem")
	@RequestMapping(method = RequestMethod.GET, value = "/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emwplistcosts/{emwplistcost_id}")
    public ResponseEntity<EMWPListCostDTO> getByEMStorePartEMItem(@PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emwplistcost_id") String emwplistcost_id) {
        EMWPListCost domain = emwplistcostService.get(emwplistcost_id);
        EMWPListCostDTO dto = emwplistcostMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('','Save',{'Sql',this.emwplistcostMapping,#emwplistcostdto})")
    @ApiOperation(value = "SaveByEMStorePartEMItem", tags = {"EMWPListCost" },  notes = "SaveByEMStorePartEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emwplistcosts/save")
    public ResponseEntity<Boolean> saveByEMStorePartEMItem(@PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMWPListCostDTO emwplistcostdto) {
        EMWPListCost domain = emwplistcostMapping.toDomain(emwplistcostdto);
        domain.setItemid(emitem_id);
        return ResponseEntity.status(HttpStatus.OK).body(emwplistcostService.save(domain));
    }

    @PreAuthorize("hasPermission('Save',{'Sql',this.emwplistcostMapping,#emwplistcostdtos})")
    @ApiOperation(value = "SaveBatchByEMStorePartEMItem", tags = {"EMWPListCost" },  notes = "SaveBatchByEMStorePartEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emwplistcosts/savebatch")
    public ResponseEntity<Boolean> saveBatchByEMStorePartEMItem(@PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMWPListCostDTO> emwplistcostdtos) {
        List<EMWPListCost> domainlist=emwplistcostMapping.toDomain(emwplistcostdtos);
        for(EMWPListCost domain:domainlist){
             domain.setItemid(emitem_id);
        }
        emwplistcostService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMWPListCost-CheckKey-all')")
    @ApiOperation(value = "CheckKeyByEMStorePartEMItem", tags = {"EMWPListCost" },  notes = "CheckKeyByEMStorePartEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emwplistcosts/checkkey")
    public ResponseEntity<Boolean> checkKeyByEMStorePartEMItem(@PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMWPListCostDTO emwplistcostdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emwplistcostService.checkKey(emwplistcostMapping.toDomain(emwplistcostdto)));
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMWPListCost-Default-all')")
	@ApiOperation(value = "fetchDEFAULTByEMStorePartEMItem", tags = {"EMWPListCost" } ,notes = "fetchDEFAULTByEMStorePartEMItem")
    @RequestMapping(method= RequestMethod.GET , value="/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emwplistcosts/fetchdefault")
	public ResponseEntity<List<EMWPListCostDTO>> fetchEMWPListCostDefaultByEMStorePartEMItem(@PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id,EMWPListCostSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMWPListCost> domains = emwplistcostService.searchDefault(context) ;
        List<EMWPListCostDTO> list = emwplistcostMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMWPListCost-Default-all')")
	@ApiOperation(value = "searchDEFAULTByEMStorePartEMItem", tags = {"EMWPListCost" } ,notes = "searchDEFAULTByEMStorePartEMItem")
    @RequestMapping(method= RequestMethod.POST , value="/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emwplistcosts/searchdefault")
	public ResponseEntity<Page<EMWPListCostDTO>> searchEMWPListCostDefaultByEMStorePartEMItem(@PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMWPListCostSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMWPListCost> domains = emwplistcostService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emwplistcostMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
    @PreAuthorize("hasPermission(#emwplistcost_id,'Update',{'Sql',this.emwplistcostMapping,#emwplistcostdto})")
    @ApiOperation(value = "UpdateByEMStoreEMItem", tags = {"EMWPListCost" },  notes = "UpdateByEMStoreEMItem")
	@RequestMapping(method = RequestMethod.PUT, value = "/emstores/{emstore_id}/emitems/{emitem_id}/emwplistcosts/{emwplistcost_id}")
    @Transactional
    public ResponseEntity<EMWPListCostDTO> updateByEMStoreEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emwplistcost_id") String emwplistcost_id, @RequestBody EMWPListCostDTO emwplistcostdto) {
        EMWPListCost domain = emwplistcostMapping.toDomain(emwplistcostdto);
        domain.setItemid(emitem_id);
        domain.setEmwplistcostid(emwplistcost_id);
		emwplistcostService.update(domain);
        EMWPListCostDTO dto = emwplistcostMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Update',{'Sql',this.emwplistcostMapping,#emwplistcostdtos})")
    @ApiOperation(value = "UpdateBatchByEMStoreEMItem", tags = {"EMWPListCost" },  notes = "UpdateBatchByEMStoreEMItem")
	@RequestMapping(method = RequestMethod.PUT, value = "/emstores/{emstore_id}/emitems/{emitem_id}/emwplistcosts/batch")
    public ResponseEntity<Boolean> updateBatchByEMStoreEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMWPListCostDTO> emwplistcostdtos) {
        List<EMWPListCost> domainlist=emwplistcostMapping.toDomain(emwplistcostdtos);
        for(EMWPListCost domain:domainlist){
            domain.setItemid(emitem_id);
        }
        emwplistcostService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission('','Create',{'Sql',this.emwplistcostMapping,#emwplistcostdto})")
    @ApiOperation(value = "CreateByEMStoreEMItem", tags = {"EMWPListCost" },  notes = "CreateByEMStoreEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emstores/{emstore_id}/emitems/{emitem_id}/emwplistcosts")
    @Transactional
    public ResponseEntity<EMWPListCostDTO> createByEMStoreEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMWPListCostDTO emwplistcostdto) {
        EMWPListCost domain = emwplistcostMapping.toDomain(emwplistcostdto);
        domain.setItemid(emitem_id);
		emwplistcostService.create(domain);
        EMWPListCostDTO dto = emwplistcostMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Create',{'Sql',this.emwplistcostMapping,#emwplistcostdtos})")
    @ApiOperation(value = "createBatchByEMStoreEMItem", tags = {"EMWPListCost" },  notes = "createBatchByEMStoreEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emstores/{emstore_id}/emitems/{emitem_id}/emwplistcosts/batch")
    public ResponseEntity<Boolean> createBatchByEMStoreEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMWPListCostDTO> emwplistcostdtos) {
        List<EMWPListCost> domainlist=emwplistcostMapping.toDomain(emwplistcostdtos);
        for(EMWPListCost domain:domainlist){
            domain.setItemid(emitem_id);
        }
        emwplistcostService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMWPListCost-GetDraft-all')")
    @ApiOperation(value = "GetDraftByEMStoreEMItem", tags = {"EMWPListCost" },  notes = "GetDraftByEMStoreEMItem")
    @RequestMapping(method = RequestMethod.GET, value = "/emstores/{emstore_id}/emitems/{emitem_id}/emwplistcosts/getdraft")
    public ResponseEntity<EMWPListCostDTO> getDraftByEMStoreEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emitem_id") String emitem_id) {
        EMWPListCost domain = new EMWPListCost();
        domain.setItemid(emitem_id);
        return ResponseEntity.status(HttpStatus.OK).body(emwplistcostMapping.toDto(emwplistcostService.getDraft(domain)));
    }

    @PreAuthorize("hasPermission(#emwplistcost_id,'Remove',{'Sql',this.emwplistcostMapping,this.permissionDTO})")
    @ApiOperation(value = "RemoveByEMStoreEMItem", tags = {"EMWPListCost" },  notes = "RemoveByEMStoreEMItem")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emstores/{emstore_id}/emitems/{emitem_id}/emwplistcosts/{emwplistcost_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByEMStoreEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emwplistcost_id") String emwplistcost_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emwplistcostService.remove(emwplistcost_id));
    }

    @PreAuthorize("hasPermission('Remove',{'Sql',this.emwplistcostMapping,this.permissionDTO,#ids})")
    @ApiOperation(value = "RemoveBatchByEMStoreEMItem", tags = {"EMWPListCost" },  notes = "RemoveBatchByEMStoreEMItem")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emstores/{emstore_id}/emitems/{emitem_id}/emwplistcosts/batch")
    public ResponseEntity<Boolean> removeBatchByEMStoreEMItem(@RequestBody List<String> ids) {
        emwplistcostService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(#emwplistcost_id,'Get',{'Sql',this.emwplistcostMapping,this.permissionDTO})")
    @ApiOperation(value = "GetByEMStoreEMItem", tags = {"EMWPListCost" },  notes = "GetByEMStoreEMItem")
	@RequestMapping(method = RequestMethod.GET, value = "/emstores/{emstore_id}/emitems/{emitem_id}/emwplistcosts/{emwplistcost_id}")
    public ResponseEntity<EMWPListCostDTO> getByEMStoreEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emwplistcost_id") String emwplistcost_id) {
        EMWPListCost domain = emwplistcostService.get(emwplistcost_id);
        EMWPListCostDTO dto = emwplistcostMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('','Save',{'Sql',this.emwplistcostMapping,#emwplistcostdto})")
    @ApiOperation(value = "SaveByEMStoreEMItem", tags = {"EMWPListCost" },  notes = "SaveByEMStoreEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emstores/{emstore_id}/emitems/{emitem_id}/emwplistcosts/save")
    public ResponseEntity<Boolean> saveByEMStoreEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMWPListCostDTO emwplistcostdto) {
        EMWPListCost domain = emwplistcostMapping.toDomain(emwplistcostdto);
        domain.setItemid(emitem_id);
        return ResponseEntity.status(HttpStatus.OK).body(emwplistcostService.save(domain));
    }

    @PreAuthorize("hasPermission('Save',{'Sql',this.emwplistcostMapping,#emwplistcostdtos})")
    @ApiOperation(value = "SaveBatchByEMStoreEMItem", tags = {"EMWPListCost" },  notes = "SaveBatchByEMStoreEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emstores/{emstore_id}/emitems/{emitem_id}/emwplistcosts/savebatch")
    public ResponseEntity<Boolean> saveBatchByEMStoreEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMWPListCostDTO> emwplistcostdtos) {
        List<EMWPListCost> domainlist=emwplistcostMapping.toDomain(emwplistcostdtos);
        for(EMWPListCost domain:domainlist){
             domain.setItemid(emitem_id);
        }
        emwplistcostService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMWPListCost-CheckKey-all')")
    @ApiOperation(value = "CheckKeyByEMStoreEMItem", tags = {"EMWPListCost" },  notes = "CheckKeyByEMStoreEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emstores/{emstore_id}/emitems/{emitem_id}/emwplistcosts/checkkey")
    public ResponseEntity<Boolean> checkKeyByEMStoreEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMWPListCostDTO emwplistcostdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emwplistcostService.checkKey(emwplistcostMapping.toDomain(emwplistcostdto)));
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMWPListCost-Default-all')")
	@ApiOperation(value = "fetchDEFAULTByEMStoreEMItem", tags = {"EMWPListCost" } ,notes = "fetchDEFAULTByEMStoreEMItem")
    @RequestMapping(method= RequestMethod.GET , value="/emstores/{emstore_id}/emitems/{emitem_id}/emwplistcosts/fetchdefault")
	public ResponseEntity<List<EMWPListCostDTO>> fetchEMWPListCostDefaultByEMStoreEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emitem_id") String emitem_id,EMWPListCostSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMWPListCost> domains = emwplistcostService.searchDefault(context) ;
        List<EMWPListCostDTO> list = emwplistcostMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMWPListCost-Default-all')")
	@ApiOperation(value = "searchDEFAULTByEMStoreEMItem", tags = {"EMWPListCost" } ,notes = "searchDEFAULTByEMStoreEMItem")
    @RequestMapping(method= RequestMethod.POST , value="/emstores/{emstore_id}/emitems/{emitem_id}/emwplistcosts/searchdefault")
	public ResponseEntity<Page<EMWPListCostDTO>> searchEMWPListCostDefaultByEMStoreEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMWPListCostSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMWPListCost> domains = emwplistcostService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emwplistcostMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
    @PreAuthorize("hasPermission(#emwplistcost_id,'Update',{'Sql',this.emwplistcostMapping,#emwplistcostdto})")
    @ApiOperation(value = "UpdateByPFEmpEMItem", tags = {"EMWPListCost" },  notes = "UpdateByPFEmpEMItem")
	@RequestMapping(method = RequestMethod.PUT, value = "/pfemps/{pfemp_id}/emitems/{emitem_id}/emwplistcosts/{emwplistcost_id}")
    @Transactional
    public ResponseEntity<EMWPListCostDTO> updateByPFEmpEMItem(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emwplistcost_id") String emwplistcost_id, @RequestBody EMWPListCostDTO emwplistcostdto) {
        EMWPListCost domain = emwplistcostMapping.toDomain(emwplistcostdto);
        domain.setItemid(emitem_id);
        domain.setEmwplistcostid(emwplistcost_id);
		emwplistcostService.update(domain);
        EMWPListCostDTO dto = emwplistcostMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Update',{'Sql',this.emwplistcostMapping,#emwplistcostdtos})")
    @ApiOperation(value = "UpdateBatchByPFEmpEMItem", tags = {"EMWPListCost" },  notes = "UpdateBatchByPFEmpEMItem")
	@RequestMapping(method = RequestMethod.PUT, value = "/pfemps/{pfemp_id}/emitems/{emitem_id}/emwplistcosts/batch")
    public ResponseEntity<Boolean> updateBatchByPFEmpEMItem(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMWPListCostDTO> emwplistcostdtos) {
        List<EMWPListCost> domainlist=emwplistcostMapping.toDomain(emwplistcostdtos);
        for(EMWPListCost domain:domainlist){
            domain.setItemid(emitem_id);
        }
        emwplistcostService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission('','Create',{'Sql',this.emwplistcostMapping,#emwplistcostdto})")
    @ApiOperation(value = "CreateByPFEmpEMItem", tags = {"EMWPListCost" },  notes = "CreateByPFEmpEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/pfemps/{pfemp_id}/emitems/{emitem_id}/emwplistcosts")
    @Transactional
    public ResponseEntity<EMWPListCostDTO> createByPFEmpEMItem(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMWPListCostDTO emwplistcostdto) {
        EMWPListCost domain = emwplistcostMapping.toDomain(emwplistcostdto);
        domain.setItemid(emitem_id);
		emwplistcostService.create(domain);
        EMWPListCostDTO dto = emwplistcostMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Create',{'Sql',this.emwplistcostMapping,#emwplistcostdtos})")
    @ApiOperation(value = "createBatchByPFEmpEMItem", tags = {"EMWPListCost" },  notes = "createBatchByPFEmpEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/pfemps/{pfemp_id}/emitems/{emitem_id}/emwplistcosts/batch")
    public ResponseEntity<Boolean> createBatchByPFEmpEMItem(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMWPListCostDTO> emwplistcostdtos) {
        List<EMWPListCost> domainlist=emwplistcostMapping.toDomain(emwplistcostdtos);
        for(EMWPListCost domain:domainlist){
            domain.setItemid(emitem_id);
        }
        emwplistcostService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMWPListCost-GetDraft-all')")
    @ApiOperation(value = "GetDraftByPFEmpEMItem", tags = {"EMWPListCost" },  notes = "GetDraftByPFEmpEMItem")
    @RequestMapping(method = RequestMethod.GET, value = "/pfemps/{pfemp_id}/emitems/{emitem_id}/emwplistcosts/getdraft")
    public ResponseEntity<EMWPListCostDTO> getDraftByPFEmpEMItem(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emitem_id") String emitem_id) {
        EMWPListCost domain = new EMWPListCost();
        domain.setItemid(emitem_id);
        return ResponseEntity.status(HttpStatus.OK).body(emwplistcostMapping.toDto(emwplistcostService.getDraft(domain)));
    }

    @PreAuthorize("hasPermission(#emwplistcost_id,'Remove',{'Sql',this.emwplistcostMapping,this.permissionDTO})")
    @ApiOperation(value = "RemoveByPFEmpEMItem", tags = {"EMWPListCost" },  notes = "RemoveByPFEmpEMItem")
	@RequestMapping(method = RequestMethod.DELETE, value = "/pfemps/{pfemp_id}/emitems/{emitem_id}/emwplistcosts/{emwplistcost_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByPFEmpEMItem(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emwplistcost_id") String emwplistcost_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emwplistcostService.remove(emwplistcost_id));
    }

    @PreAuthorize("hasPermission('Remove',{'Sql',this.emwplistcostMapping,this.permissionDTO,#ids})")
    @ApiOperation(value = "RemoveBatchByPFEmpEMItem", tags = {"EMWPListCost" },  notes = "RemoveBatchByPFEmpEMItem")
	@RequestMapping(method = RequestMethod.DELETE, value = "/pfemps/{pfemp_id}/emitems/{emitem_id}/emwplistcosts/batch")
    public ResponseEntity<Boolean> removeBatchByPFEmpEMItem(@RequestBody List<String> ids) {
        emwplistcostService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(#emwplistcost_id,'Get',{'Sql',this.emwplistcostMapping,this.permissionDTO})")
    @ApiOperation(value = "GetByPFEmpEMItem", tags = {"EMWPListCost" },  notes = "GetByPFEmpEMItem")
	@RequestMapping(method = RequestMethod.GET, value = "/pfemps/{pfemp_id}/emitems/{emitem_id}/emwplistcosts/{emwplistcost_id}")
    public ResponseEntity<EMWPListCostDTO> getByPFEmpEMItem(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emwplistcost_id") String emwplistcost_id) {
        EMWPListCost domain = emwplistcostService.get(emwplistcost_id);
        EMWPListCostDTO dto = emwplistcostMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('','Save',{'Sql',this.emwplistcostMapping,#emwplistcostdto})")
    @ApiOperation(value = "SaveByPFEmpEMItem", tags = {"EMWPListCost" },  notes = "SaveByPFEmpEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/pfemps/{pfemp_id}/emitems/{emitem_id}/emwplistcosts/save")
    public ResponseEntity<Boolean> saveByPFEmpEMItem(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMWPListCostDTO emwplistcostdto) {
        EMWPListCost domain = emwplistcostMapping.toDomain(emwplistcostdto);
        domain.setItemid(emitem_id);
        return ResponseEntity.status(HttpStatus.OK).body(emwplistcostService.save(domain));
    }

    @PreAuthorize("hasPermission('Save',{'Sql',this.emwplistcostMapping,#emwplistcostdtos})")
    @ApiOperation(value = "SaveBatchByPFEmpEMItem", tags = {"EMWPListCost" },  notes = "SaveBatchByPFEmpEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/pfemps/{pfemp_id}/emitems/{emitem_id}/emwplistcosts/savebatch")
    public ResponseEntity<Boolean> saveBatchByPFEmpEMItem(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMWPListCostDTO> emwplistcostdtos) {
        List<EMWPListCost> domainlist=emwplistcostMapping.toDomain(emwplistcostdtos);
        for(EMWPListCost domain:domainlist){
             domain.setItemid(emitem_id);
        }
        emwplistcostService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMWPListCost-CheckKey-all')")
    @ApiOperation(value = "CheckKeyByPFEmpEMItem", tags = {"EMWPListCost" },  notes = "CheckKeyByPFEmpEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/pfemps/{pfemp_id}/emitems/{emitem_id}/emwplistcosts/checkkey")
    public ResponseEntity<Boolean> checkKeyByPFEmpEMItem(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMWPListCostDTO emwplistcostdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emwplistcostService.checkKey(emwplistcostMapping.toDomain(emwplistcostdto)));
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMWPListCost-Default-all')")
	@ApiOperation(value = "fetchDEFAULTByPFEmpEMItem", tags = {"EMWPListCost" } ,notes = "fetchDEFAULTByPFEmpEMItem")
    @RequestMapping(method= RequestMethod.GET , value="/pfemps/{pfemp_id}/emitems/{emitem_id}/emwplistcosts/fetchdefault")
	public ResponseEntity<List<EMWPListCostDTO>> fetchEMWPListCostDefaultByPFEmpEMItem(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emitem_id") String emitem_id,EMWPListCostSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMWPListCost> domains = emwplistcostService.searchDefault(context) ;
        List<EMWPListCostDTO> list = emwplistcostMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMWPListCost-Default-all')")
	@ApiOperation(value = "searchDEFAULTByPFEmpEMItem", tags = {"EMWPListCost" } ,notes = "searchDEFAULTByPFEmpEMItem")
    @RequestMapping(method= RequestMethod.POST , value="/pfemps/{pfemp_id}/emitems/{emitem_id}/emwplistcosts/searchdefault")
	public ResponseEntity<Page<EMWPListCostDTO>> searchEMWPListCostDefaultByPFEmpEMItem(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMWPListCostSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMWPListCost> domains = emwplistcostService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emwplistcostMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
    @PreAuthorize("hasPermission(#emwplistcost_id,'Update',{'Sql',this.emwplistcostMapping,#emwplistcostdto})")
    @ApiOperation(value = "UpdateByPFUnitEMItem", tags = {"EMWPListCost" },  notes = "UpdateByPFUnitEMItem")
	@RequestMapping(method = RequestMethod.PUT, value = "/pfunits/{pfunit_id}/emitems/{emitem_id}/emwplistcosts/{emwplistcost_id}")
    @Transactional
    public ResponseEntity<EMWPListCostDTO> updateByPFUnitEMItem(@PathVariable("pfunit_id") String pfunit_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emwplistcost_id") String emwplistcost_id, @RequestBody EMWPListCostDTO emwplistcostdto) {
        EMWPListCost domain = emwplistcostMapping.toDomain(emwplistcostdto);
        domain.setItemid(emitem_id);
        domain.setEmwplistcostid(emwplistcost_id);
		emwplistcostService.update(domain);
        EMWPListCostDTO dto = emwplistcostMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Update',{'Sql',this.emwplistcostMapping,#emwplistcostdtos})")
    @ApiOperation(value = "UpdateBatchByPFUnitEMItem", tags = {"EMWPListCost" },  notes = "UpdateBatchByPFUnitEMItem")
	@RequestMapping(method = RequestMethod.PUT, value = "/pfunits/{pfunit_id}/emitems/{emitem_id}/emwplistcosts/batch")
    public ResponseEntity<Boolean> updateBatchByPFUnitEMItem(@PathVariable("pfunit_id") String pfunit_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMWPListCostDTO> emwplistcostdtos) {
        List<EMWPListCost> domainlist=emwplistcostMapping.toDomain(emwplistcostdtos);
        for(EMWPListCost domain:domainlist){
            domain.setItemid(emitem_id);
        }
        emwplistcostService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission('','Create',{'Sql',this.emwplistcostMapping,#emwplistcostdto})")
    @ApiOperation(value = "CreateByPFUnitEMItem", tags = {"EMWPListCost" },  notes = "CreateByPFUnitEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/pfunits/{pfunit_id}/emitems/{emitem_id}/emwplistcosts")
    @Transactional
    public ResponseEntity<EMWPListCostDTO> createByPFUnitEMItem(@PathVariable("pfunit_id") String pfunit_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMWPListCostDTO emwplistcostdto) {
        EMWPListCost domain = emwplistcostMapping.toDomain(emwplistcostdto);
        domain.setItemid(emitem_id);
		emwplistcostService.create(domain);
        EMWPListCostDTO dto = emwplistcostMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Create',{'Sql',this.emwplistcostMapping,#emwplistcostdtos})")
    @ApiOperation(value = "createBatchByPFUnitEMItem", tags = {"EMWPListCost" },  notes = "createBatchByPFUnitEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/pfunits/{pfunit_id}/emitems/{emitem_id}/emwplistcosts/batch")
    public ResponseEntity<Boolean> createBatchByPFUnitEMItem(@PathVariable("pfunit_id") String pfunit_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMWPListCostDTO> emwplistcostdtos) {
        List<EMWPListCost> domainlist=emwplistcostMapping.toDomain(emwplistcostdtos);
        for(EMWPListCost domain:domainlist){
            domain.setItemid(emitem_id);
        }
        emwplistcostService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMWPListCost-GetDraft-all')")
    @ApiOperation(value = "GetDraftByPFUnitEMItem", tags = {"EMWPListCost" },  notes = "GetDraftByPFUnitEMItem")
    @RequestMapping(method = RequestMethod.GET, value = "/pfunits/{pfunit_id}/emitems/{emitem_id}/emwplistcosts/getdraft")
    public ResponseEntity<EMWPListCostDTO> getDraftByPFUnitEMItem(@PathVariable("pfunit_id") String pfunit_id, @PathVariable("emitem_id") String emitem_id) {
        EMWPListCost domain = new EMWPListCost();
        domain.setItemid(emitem_id);
        return ResponseEntity.status(HttpStatus.OK).body(emwplistcostMapping.toDto(emwplistcostService.getDraft(domain)));
    }

    @PreAuthorize("hasPermission(#emwplistcost_id,'Remove',{'Sql',this.emwplistcostMapping,this.permissionDTO})")
    @ApiOperation(value = "RemoveByPFUnitEMItem", tags = {"EMWPListCost" },  notes = "RemoveByPFUnitEMItem")
	@RequestMapping(method = RequestMethod.DELETE, value = "/pfunits/{pfunit_id}/emitems/{emitem_id}/emwplistcosts/{emwplistcost_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByPFUnitEMItem(@PathVariable("pfunit_id") String pfunit_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emwplistcost_id") String emwplistcost_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emwplistcostService.remove(emwplistcost_id));
    }

    @PreAuthorize("hasPermission('Remove',{'Sql',this.emwplistcostMapping,this.permissionDTO,#ids})")
    @ApiOperation(value = "RemoveBatchByPFUnitEMItem", tags = {"EMWPListCost" },  notes = "RemoveBatchByPFUnitEMItem")
	@RequestMapping(method = RequestMethod.DELETE, value = "/pfunits/{pfunit_id}/emitems/{emitem_id}/emwplistcosts/batch")
    public ResponseEntity<Boolean> removeBatchByPFUnitEMItem(@RequestBody List<String> ids) {
        emwplistcostService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(#emwplistcost_id,'Get',{'Sql',this.emwplistcostMapping,this.permissionDTO})")
    @ApiOperation(value = "GetByPFUnitEMItem", tags = {"EMWPListCost" },  notes = "GetByPFUnitEMItem")
	@RequestMapping(method = RequestMethod.GET, value = "/pfunits/{pfunit_id}/emitems/{emitem_id}/emwplistcosts/{emwplistcost_id}")
    public ResponseEntity<EMWPListCostDTO> getByPFUnitEMItem(@PathVariable("pfunit_id") String pfunit_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emwplistcost_id") String emwplistcost_id) {
        EMWPListCost domain = emwplistcostService.get(emwplistcost_id);
        EMWPListCostDTO dto = emwplistcostMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('','Save',{'Sql',this.emwplistcostMapping,#emwplistcostdto})")
    @ApiOperation(value = "SaveByPFUnitEMItem", tags = {"EMWPListCost" },  notes = "SaveByPFUnitEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/pfunits/{pfunit_id}/emitems/{emitem_id}/emwplistcosts/save")
    public ResponseEntity<Boolean> saveByPFUnitEMItem(@PathVariable("pfunit_id") String pfunit_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMWPListCostDTO emwplistcostdto) {
        EMWPListCost domain = emwplistcostMapping.toDomain(emwplistcostdto);
        domain.setItemid(emitem_id);
        return ResponseEntity.status(HttpStatus.OK).body(emwplistcostService.save(domain));
    }

    @PreAuthorize("hasPermission('Save',{'Sql',this.emwplistcostMapping,#emwplistcostdtos})")
    @ApiOperation(value = "SaveBatchByPFUnitEMItem", tags = {"EMWPListCost" },  notes = "SaveBatchByPFUnitEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/pfunits/{pfunit_id}/emitems/{emitem_id}/emwplistcosts/savebatch")
    public ResponseEntity<Boolean> saveBatchByPFUnitEMItem(@PathVariable("pfunit_id") String pfunit_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMWPListCostDTO> emwplistcostdtos) {
        List<EMWPListCost> domainlist=emwplistcostMapping.toDomain(emwplistcostdtos);
        for(EMWPListCost domain:domainlist){
             domain.setItemid(emitem_id);
        }
        emwplistcostService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMWPListCost-CheckKey-all')")
    @ApiOperation(value = "CheckKeyByPFUnitEMItem", tags = {"EMWPListCost" },  notes = "CheckKeyByPFUnitEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/pfunits/{pfunit_id}/emitems/{emitem_id}/emwplistcosts/checkkey")
    public ResponseEntity<Boolean> checkKeyByPFUnitEMItem(@PathVariable("pfunit_id") String pfunit_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMWPListCostDTO emwplistcostdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emwplistcostService.checkKey(emwplistcostMapping.toDomain(emwplistcostdto)));
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMWPListCost-Default-all')")
	@ApiOperation(value = "fetchDEFAULTByPFUnitEMItem", tags = {"EMWPListCost" } ,notes = "fetchDEFAULTByPFUnitEMItem")
    @RequestMapping(method= RequestMethod.GET , value="/pfunits/{pfunit_id}/emitems/{emitem_id}/emwplistcosts/fetchdefault")
	public ResponseEntity<List<EMWPListCostDTO>> fetchEMWPListCostDefaultByPFUnitEMItem(@PathVariable("pfunit_id") String pfunit_id, @PathVariable("emitem_id") String emitem_id,EMWPListCostSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMWPListCost> domains = emwplistcostService.searchDefault(context) ;
        List<EMWPListCostDTO> list = emwplistcostMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMWPListCost-Default-all')")
	@ApiOperation(value = "searchDEFAULTByPFUnitEMItem", tags = {"EMWPListCost" } ,notes = "searchDEFAULTByPFUnitEMItem")
    @RequestMapping(method= RequestMethod.POST , value="/pfunits/{pfunit_id}/emitems/{emitem_id}/emwplistcosts/searchdefault")
	public ResponseEntity<Page<EMWPListCostDTO>> searchEMWPListCostDefaultByPFUnitEMItem(@PathVariable("pfunit_id") String pfunit_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMWPListCostSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMWPListCost> domains = emwplistcostService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emwplistcostMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
    @PreAuthorize("hasPermission(#emwplistcost_id,'Update',{'Sql',this.emwplistcostMapping,#emwplistcostdto})")
    @ApiOperation(value = "UpdateByEMItemEMWPList", tags = {"EMWPListCost" },  notes = "UpdateByEMItemEMWPList")
	@RequestMapping(method = RequestMethod.PUT, value = "/emitems/{emitem_id}/emwplists/{emwplist_id}/emwplistcosts/{emwplistcost_id}")
    @Transactional
    public ResponseEntity<EMWPListCostDTO> updateByEMItemEMWPList(@PathVariable("emitem_id") String emitem_id, @PathVariable("emwplist_id") String emwplist_id, @PathVariable("emwplistcost_id") String emwplistcost_id, @RequestBody EMWPListCostDTO emwplistcostdto) {
        EMWPListCost domain = emwplistcostMapping.toDomain(emwplistcostdto);
        domain.setWplistid(emwplist_id);
        domain.setEmwplistcostid(emwplistcost_id);
		emwplistcostService.update(domain);
        EMWPListCostDTO dto = emwplistcostMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Update',{'Sql',this.emwplistcostMapping,#emwplistcostdtos})")
    @ApiOperation(value = "UpdateBatchByEMItemEMWPList", tags = {"EMWPListCost" },  notes = "UpdateBatchByEMItemEMWPList")
	@RequestMapping(method = RequestMethod.PUT, value = "/emitems/{emitem_id}/emwplists/{emwplist_id}/emwplistcosts/batch")
    public ResponseEntity<Boolean> updateBatchByEMItemEMWPList(@PathVariable("emitem_id") String emitem_id, @PathVariable("emwplist_id") String emwplist_id, @RequestBody List<EMWPListCostDTO> emwplistcostdtos) {
        List<EMWPListCost> domainlist=emwplistcostMapping.toDomain(emwplistcostdtos);
        for(EMWPListCost domain:domainlist){
            domain.setWplistid(emwplist_id);
        }
        emwplistcostService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission('','Create',{'Sql',this.emwplistcostMapping,#emwplistcostdto})")
    @ApiOperation(value = "CreateByEMItemEMWPList", tags = {"EMWPListCost" },  notes = "CreateByEMItemEMWPList")
	@RequestMapping(method = RequestMethod.POST, value = "/emitems/{emitem_id}/emwplists/{emwplist_id}/emwplistcosts")
    @Transactional
    public ResponseEntity<EMWPListCostDTO> createByEMItemEMWPList(@PathVariable("emitem_id") String emitem_id, @PathVariable("emwplist_id") String emwplist_id, @RequestBody EMWPListCostDTO emwplistcostdto) {
        EMWPListCost domain = emwplistcostMapping.toDomain(emwplistcostdto);
        domain.setWplistid(emwplist_id);
		emwplistcostService.create(domain);
        EMWPListCostDTO dto = emwplistcostMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Create',{'Sql',this.emwplistcostMapping,#emwplistcostdtos})")
    @ApiOperation(value = "createBatchByEMItemEMWPList", tags = {"EMWPListCost" },  notes = "createBatchByEMItemEMWPList")
	@RequestMapping(method = RequestMethod.POST, value = "/emitems/{emitem_id}/emwplists/{emwplist_id}/emwplistcosts/batch")
    public ResponseEntity<Boolean> createBatchByEMItemEMWPList(@PathVariable("emitem_id") String emitem_id, @PathVariable("emwplist_id") String emwplist_id, @RequestBody List<EMWPListCostDTO> emwplistcostdtos) {
        List<EMWPListCost> domainlist=emwplistcostMapping.toDomain(emwplistcostdtos);
        for(EMWPListCost domain:domainlist){
            domain.setWplistid(emwplist_id);
        }
        emwplistcostService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMWPListCost-GetDraft-all')")
    @ApiOperation(value = "GetDraftByEMItemEMWPList", tags = {"EMWPListCost" },  notes = "GetDraftByEMItemEMWPList")
    @RequestMapping(method = RequestMethod.GET, value = "/emitems/{emitem_id}/emwplists/{emwplist_id}/emwplistcosts/getdraft")
    public ResponseEntity<EMWPListCostDTO> getDraftByEMItemEMWPList(@PathVariable("emitem_id") String emitem_id, @PathVariable("emwplist_id") String emwplist_id) {
        EMWPListCost domain = new EMWPListCost();
        domain.setWplistid(emwplist_id);
        return ResponseEntity.status(HttpStatus.OK).body(emwplistcostMapping.toDto(emwplistcostService.getDraft(domain)));
    }

    @PreAuthorize("hasPermission(#emwplistcost_id,'Remove',{'Sql',this.emwplistcostMapping,this.permissionDTO})")
    @ApiOperation(value = "RemoveByEMItemEMWPList", tags = {"EMWPListCost" },  notes = "RemoveByEMItemEMWPList")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emitems/{emitem_id}/emwplists/{emwplist_id}/emwplistcosts/{emwplistcost_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByEMItemEMWPList(@PathVariable("emitem_id") String emitem_id, @PathVariable("emwplist_id") String emwplist_id, @PathVariable("emwplistcost_id") String emwplistcost_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emwplistcostService.remove(emwplistcost_id));
    }

    @PreAuthorize("hasPermission('Remove',{'Sql',this.emwplistcostMapping,this.permissionDTO,#ids})")
    @ApiOperation(value = "RemoveBatchByEMItemEMWPList", tags = {"EMWPListCost" },  notes = "RemoveBatchByEMItemEMWPList")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emitems/{emitem_id}/emwplists/{emwplist_id}/emwplistcosts/batch")
    public ResponseEntity<Boolean> removeBatchByEMItemEMWPList(@RequestBody List<String> ids) {
        emwplistcostService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(#emwplistcost_id,'Get',{'Sql',this.emwplistcostMapping,this.permissionDTO})")
    @ApiOperation(value = "GetByEMItemEMWPList", tags = {"EMWPListCost" },  notes = "GetByEMItemEMWPList")
	@RequestMapping(method = RequestMethod.GET, value = "/emitems/{emitem_id}/emwplists/{emwplist_id}/emwplistcosts/{emwplistcost_id}")
    public ResponseEntity<EMWPListCostDTO> getByEMItemEMWPList(@PathVariable("emitem_id") String emitem_id, @PathVariable("emwplist_id") String emwplist_id, @PathVariable("emwplistcost_id") String emwplistcost_id) {
        EMWPListCost domain = emwplistcostService.get(emwplistcost_id);
        EMWPListCostDTO dto = emwplistcostMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('','Save',{'Sql',this.emwplistcostMapping,#emwplistcostdto})")
    @ApiOperation(value = "SaveByEMItemEMWPList", tags = {"EMWPListCost" },  notes = "SaveByEMItemEMWPList")
	@RequestMapping(method = RequestMethod.POST, value = "/emitems/{emitem_id}/emwplists/{emwplist_id}/emwplistcosts/save")
    public ResponseEntity<Boolean> saveByEMItemEMWPList(@PathVariable("emitem_id") String emitem_id, @PathVariable("emwplist_id") String emwplist_id, @RequestBody EMWPListCostDTO emwplistcostdto) {
        EMWPListCost domain = emwplistcostMapping.toDomain(emwplistcostdto);
        domain.setWplistid(emwplist_id);
        return ResponseEntity.status(HttpStatus.OK).body(emwplistcostService.save(domain));
    }

    @PreAuthorize("hasPermission('Save',{'Sql',this.emwplistcostMapping,#emwplistcostdtos})")
    @ApiOperation(value = "SaveBatchByEMItemEMWPList", tags = {"EMWPListCost" },  notes = "SaveBatchByEMItemEMWPList")
	@RequestMapping(method = RequestMethod.POST, value = "/emitems/{emitem_id}/emwplists/{emwplist_id}/emwplistcosts/savebatch")
    public ResponseEntity<Boolean> saveBatchByEMItemEMWPList(@PathVariable("emitem_id") String emitem_id, @PathVariable("emwplist_id") String emwplist_id, @RequestBody List<EMWPListCostDTO> emwplistcostdtos) {
        List<EMWPListCost> domainlist=emwplistcostMapping.toDomain(emwplistcostdtos);
        for(EMWPListCost domain:domainlist){
             domain.setWplistid(emwplist_id);
        }
        emwplistcostService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMWPListCost-CheckKey-all')")
    @ApiOperation(value = "CheckKeyByEMItemEMWPList", tags = {"EMWPListCost" },  notes = "CheckKeyByEMItemEMWPList")
	@RequestMapping(method = RequestMethod.POST, value = "/emitems/{emitem_id}/emwplists/{emwplist_id}/emwplistcosts/checkkey")
    public ResponseEntity<Boolean> checkKeyByEMItemEMWPList(@PathVariable("emitem_id") String emitem_id, @PathVariable("emwplist_id") String emwplist_id, @RequestBody EMWPListCostDTO emwplistcostdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emwplistcostService.checkKey(emwplistcostMapping.toDomain(emwplistcostdto)));
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMWPListCost-Default-all')")
	@ApiOperation(value = "fetchDEFAULTByEMItemEMWPList", tags = {"EMWPListCost" } ,notes = "fetchDEFAULTByEMItemEMWPList")
    @RequestMapping(method= RequestMethod.GET , value="/emitems/{emitem_id}/emwplists/{emwplist_id}/emwplistcosts/fetchdefault")
	public ResponseEntity<List<EMWPListCostDTO>> fetchEMWPListCostDefaultByEMItemEMWPList(@PathVariable("emitem_id") String emitem_id, @PathVariable("emwplist_id") String emwplist_id,EMWPListCostSearchContext context) {
        context.setN_wplistid_eq(emwplist_id);
        Page<EMWPListCost> domains = emwplistcostService.searchDefault(context) ;
        List<EMWPListCostDTO> list = emwplistcostMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMWPListCost-Default-all')")
	@ApiOperation(value = "searchDEFAULTByEMItemEMWPList", tags = {"EMWPListCost" } ,notes = "searchDEFAULTByEMItemEMWPList")
    @RequestMapping(method= RequestMethod.POST , value="/emitems/{emitem_id}/emwplists/{emwplist_id}/emwplistcosts/searchdefault")
	public ResponseEntity<Page<EMWPListCostDTO>> searchEMWPListCostDefaultByEMItemEMWPList(@PathVariable("emitem_id") String emitem_id, @PathVariable("emwplist_id") String emwplist_id, @RequestBody EMWPListCostSearchContext context) {
        context.setN_wplistid_eq(emwplist_id);
        Page<EMWPListCost> domains = emwplistcostService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emwplistcostMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
    @PreAuthorize("hasPermission(#emwplistcost_id,'Update',{'Sql',this.emwplistcostMapping,#emwplistcostdto})")
    @ApiOperation(value = "UpdateByEMServiceEMItemEMWPList", tags = {"EMWPListCost" },  notes = "UpdateByEMServiceEMItemEMWPList")
	@RequestMapping(method = RequestMethod.PUT, value = "/emservices/{emservice_id}/emitems/{emitem_id}/emwplists/{emwplist_id}/emwplistcosts/{emwplistcost_id}")
    @Transactional
    public ResponseEntity<EMWPListCostDTO> updateByEMServiceEMItemEMWPList(@PathVariable("emservice_id") String emservice_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emwplist_id") String emwplist_id, @PathVariable("emwplistcost_id") String emwplistcost_id, @RequestBody EMWPListCostDTO emwplistcostdto) {
        EMWPListCost domain = emwplistcostMapping.toDomain(emwplistcostdto);
        domain.setWplistid(emwplist_id);
        domain.setEmwplistcostid(emwplistcost_id);
		emwplistcostService.update(domain);
        EMWPListCostDTO dto = emwplistcostMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Update',{'Sql',this.emwplistcostMapping,#emwplistcostdtos})")
    @ApiOperation(value = "UpdateBatchByEMServiceEMItemEMWPList", tags = {"EMWPListCost" },  notes = "UpdateBatchByEMServiceEMItemEMWPList")
	@RequestMapping(method = RequestMethod.PUT, value = "/emservices/{emservice_id}/emitems/{emitem_id}/emwplists/{emwplist_id}/emwplistcosts/batch")
    public ResponseEntity<Boolean> updateBatchByEMServiceEMItemEMWPList(@PathVariable("emservice_id") String emservice_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emwplist_id") String emwplist_id, @RequestBody List<EMWPListCostDTO> emwplistcostdtos) {
        List<EMWPListCost> domainlist=emwplistcostMapping.toDomain(emwplistcostdtos);
        for(EMWPListCost domain:domainlist){
            domain.setWplistid(emwplist_id);
        }
        emwplistcostService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission('','Create',{'Sql',this.emwplistcostMapping,#emwplistcostdto})")
    @ApiOperation(value = "CreateByEMServiceEMItemEMWPList", tags = {"EMWPListCost" },  notes = "CreateByEMServiceEMItemEMWPList")
	@RequestMapping(method = RequestMethod.POST, value = "/emservices/{emservice_id}/emitems/{emitem_id}/emwplists/{emwplist_id}/emwplistcosts")
    @Transactional
    public ResponseEntity<EMWPListCostDTO> createByEMServiceEMItemEMWPList(@PathVariable("emservice_id") String emservice_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emwplist_id") String emwplist_id, @RequestBody EMWPListCostDTO emwplistcostdto) {
        EMWPListCost domain = emwplistcostMapping.toDomain(emwplistcostdto);
        domain.setWplistid(emwplist_id);
		emwplistcostService.create(domain);
        EMWPListCostDTO dto = emwplistcostMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Create',{'Sql',this.emwplistcostMapping,#emwplistcostdtos})")
    @ApiOperation(value = "createBatchByEMServiceEMItemEMWPList", tags = {"EMWPListCost" },  notes = "createBatchByEMServiceEMItemEMWPList")
	@RequestMapping(method = RequestMethod.POST, value = "/emservices/{emservice_id}/emitems/{emitem_id}/emwplists/{emwplist_id}/emwplistcosts/batch")
    public ResponseEntity<Boolean> createBatchByEMServiceEMItemEMWPList(@PathVariable("emservice_id") String emservice_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emwplist_id") String emwplist_id, @RequestBody List<EMWPListCostDTO> emwplistcostdtos) {
        List<EMWPListCost> domainlist=emwplistcostMapping.toDomain(emwplistcostdtos);
        for(EMWPListCost domain:domainlist){
            domain.setWplistid(emwplist_id);
        }
        emwplistcostService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMWPListCost-GetDraft-all')")
    @ApiOperation(value = "GetDraftByEMServiceEMItemEMWPList", tags = {"EMWPListCost" },  notes = "GetDraftByEMServiceEMItemEMWPList")
    @RequestMapping(method = RequestMethod.GET, value = "/emservices/{emservice_id}/emitems/{emitem_id}/emwplists/{emwplist_id}/emwplistcosts/getdraft")
    public ResponseEntity<EMWPListCostDTO> getDraftByEMServiceEMItemEMWPList(@PathVariable("emservice_id") String emservice_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emwplist_id") String emwplist_id) {
        EMWPListCost domain = new EMWPListCost();
        domain.setWplistid(emwplist_id);
        return ResponseEntity.status(HttpStatus.OK).body(emwplistcostMapping.toDto(emwplistcostService.getDraft(domain)));
    }

    @PreAuthorize("hasPermission(#emwplistcost_id,'Remove',{'Sql',this.emwplistcostMapping,this.permissionDTO})")
    @ApiOperation(value = "RemoveByEMServiceEMItemEMWPList", tags = {"EMWPListCost" },  notes = "RemoveByEMServiceEMItemEMWPList")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emservices/{emservice_id}/emitems/{emitem_id}/emwplists/{emwplist_id}/emwplistcosts/{emwplistcost_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByEMServiceEMItemEMWPList(@PathVariable("emservice_id") String emservice_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emwplist_id") String emwplist_id, @PathVariable("emwplistcost_id") String emwplistcost_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emwplistcostService.remove(emwplistcost_id));
    }

    @PreAuthorize("hasPermission('Remove',{'Sql',this.emwplistcostMapping,this.permissionDTO,#ids})")
    @ApiOperation(value = "RemoveBatchByEMServiceEMItemEMWPList", tags = {"EMWPListCost" },  notes = "RemoveBatchByEMServiceEMItemEMWPList")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emservices/{emservice_id}/emitems/{emitem_id}/emwplists/{emwplist_id}/emwplistcosts/batch")
    public ResponseEntity<Boolean> removeBatchByEMServiceEMItemEMWPList(@RequestBody List<String> ids) {
        emwplistcostService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(#emwplistcost_id,'Get',{'Sql',this.emwplistcostMapping,this.permissionDTO})")
    @ApiOperation(value = "GetByEMServiceEMItemEMWPList", tags = {"EMWPListCost" },  notes = "GetByEMServiceEMItemEMWPList")
	@RequestMapping(method = RequestMethod.GET, value = "/emservices/{emservice_id}/emitems/{emitem_id}/emwplists/{emwplist_id}/emwplistcosts/{emwplistcost_id}")
    public ResponseEntity<EMWPListCostDTO> getByEMServiceEMItemEMWPList(@PathVariable("emservice_id") String emservice_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emwplist_id") String emwplist_id, @PathVariable("emwplistcost_id") String emwplistcost_id) {
        EMWPListCost domain = emwplistcostService.get(emwplistcost_id);
        EMWPListCostDTO dto = emwplistcostMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('','Save',{'Sql',this.emwplistcostMapping,#emwplistcostdto})")
    @ApiOperation(value = "SaveByEMServiceEMItemEMWPList", tags = {"EMWPListCost" },  notes = "SaveByEMServiceEMItemEMWPList")
	@RequestMapping(method = RequestMethod.POST, value = "/emservices/{emservice_id}/emitems/{emitem_id}/emwplists/{emwplist_id}/emwplistcosts/save")
    public ResponseEntity<Boolean> saveByEMServiceEMItemEMWPList(@PathVariable("emservice_id") String emservice_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emwplist_id") String emwplist_id, @RequestBody EMWPListCostDTO emwplistcostdto) {
        EMWPListCost domain = emwplistcostMapping.toDomain(emwplistcostdto);
        domain.setWplistid(emwplist_id);
        return ResponseEntity.status(HttpStatus.OK).body(emwplistcostService.save(domain));
    }

    @PreAuthorize("hasPermission('Save',{'Sql',this.emwplistcostMapping,#emwplistcostdtos})")
    @ApiOperation(value = "SaveBatchByEMServiceEMItemEMWPList", tags = {"EMWPListCost" },  notes = "SaveBatchByEMServiceEMItemEMWPList")
	@RequestMapping(method = RequestMethod.POST, value = "/emservices/{emservice_id}/emitems/{emitem_id}/emwplists/{emwplist_id}/emwplistcosts/savebatch")
    public ResponseEntity<Boolean> saveBatchByEMServiceEMItemEMWPList(@PathVariable("emservice_id") String emservice_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emwplist_id") String emwplist_id, @RequestBody List<EMWPListCostDTO> emwplistcostdtos) {
        List<EMWPListCost> domainlist=emwplistcostMapping.toDomain(emwplistcostdtos);
        for(EMWPListCost domain:domainlist){
             domain.setWplistid(emwplist_id);
        }
        emwplistcostService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMWPListCost-CheckKey-all')")
    @ApiOperation(value = "CheckKeyByEMServiceEMItemEMWPList", tags = {"EMWPListCost" },  notes = "CheckKeyByEMServiceEMItemEMWPList")
	@RequestMapping(method = RequestMethod.POST, value = "/emservices/{emservice_id}/emitems/{emitem_id}/emwplists/{emwplist_id}/emwplistcosts/checkkey")
    public ResponseEntity<Boolean> checkKeyByEMServiceEMItemEMWPList(@PathVariable("emservice_id") String emservice_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emwplist_id") String emwplist_id, @RequestBody EMWPListCostDTO emwplistcostdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emwplistcostService.checkKey(emwplistcostMapping.toDomain(emwplistcostdto)));
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMWPListCost-Default-all')")
	@ApiOperation(value = "fetchDEFAULTByEMServiceEMItemEMWPList", tags = {"EMWPListCost" } ,notes = "fetchDEFAULTByEMServiceEMItemEMWPList")
    @RequestMapping(method= RequestMethod.GET , value="/emservices/{emservice_id}/emitems/{emitem_id}/emwplists/{emwplist_id}/emwplistcosts/fetchdefault")
	public ResponseEntity<List<EMWPListCostDTO>> fetchEMWPListCostDefaultByEMServiceEMItemEMWPList(@PathVariable("emservice_id") String emservice_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emwplist_id") String emwplist_id,EMWPListCostSearchContext context) {
        context.setN_wplistid_eq(emwplist_id);
        Page<EMWPListCost> domains = emwplistcostService.searchDefault(context) ;
        List<EMWPListCostDTO> list = emwplistcostMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMWPListCost-Default-all')")
	@ApiOperation(value = "searchDEFAULTByEMServiceEMItemEMWPList", tags = {"EMWPListCost" } ,notes = "searchDEFAULTByEMServiceEMItemEMWPList")
    @RequestMapping(method= RequestMethod.POST , value="/emservices/{emservice_id}/emitems/{emitem_id}/emwplists/{emwplist_id}/emwplistcosts/searchdefault")
	public ResponseEntity<Page<EMWPListCostDTO>> searchEMWPListCostDefaultByEMServiceEMItemEMWPList(@PathVariable("emservice_id") String emservice_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emwplist_id") String emwplist_id, @RequestBody EMWPListCostSearchContext context) {
        context.setN_wplistid_eq(emwplist_id);
        Page<EMWPListCost> domains = emwplistcostService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emwplistcostMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
    @PreAuthorize("hasPermission(#emwplistcost_id,'Update',{'Sql',this.emwplistcostMapping,#emwplistcostdto})")
    @ApiOperation(value = "UpdateByEMStorePartEMItemEMWPList", tags = {"EMWPListCost" },  notes = "UpdateByEMStorePartEMItemEMWPList")
	@RequestMapping(method = RequestMethod.PUT, value = "/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emwplists/{emwplist_id}/emwplistcosts/{emwplistcost_id}")
    @Transactional
    public ResponseEntity<EMWPListCostDTO> updateByEMStorePartEMItemEMWPList(@PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emwplist_id") String emwplist_id, @PathVariable("emwplistcost_id") String emwplistcost_id, @RequestBody EMWPListCostDTO emwplistcostdto) {
        EMWPListCost domain = emwplistcostMapping.toDomain(emwplistcostdto);
        domain.setWplistid(emwplist_id);
        domain.setEmwplistcostid(emwplistcost_id);
		emwplistcostService.update(domain);
        EMWPListCostDTO dto = emwplistcostMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Update',{'Sql',this.emwplistcostMapping,#emwplistcostdtos})")
    @ApiOperation(value = "UpdateBatchByEMStorePartEMItemEMWPList", tags = {"EMWPListCost" },  notes = "UpdateBatchByEMStorePartEMItemEMWPList")
	@RequestMapping(method = RequestMethod.PUT, value = "/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emwplists/{emwplist_id}/emwplistcosts/batch")
    public ResponseEntity<Boolean> updateBatchByEMStorePartEMItemEMWPList(@PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emwplist_id") String emwplist_id, @RequestBody List<EMWPListCostDTO> emwplistcostdtos) {
        List<EMWPListCost> domainlist=emwplistcostMapping.toDomain(emwplistcostdtos);
        for(EMWPListCost domain:domainlist){
            domain.setWplistid(emwplist_id);
        }
        emwplistcostService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission('','Create',{'Sql',this.emwplistcostMapping,#emwplistcostdto})")
    @ApiOperation(value = "CreateByEMStorePartEMItemEMWPList", tags = {"EMWPListCost" },  notes = "CreateByEMStorePartEMItemEMWPList")
	@RequestMapping(method = RequestMethod.POST, value = "/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emwplists/{emwplist_id}/emwplistcosts")
    @Transactional
    public ResponseEntity<EMWPListCostDTO> createByEMStorePartEMItemEMWPList(@PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emwplist_id") String emwplist_id, @RequestBody EMWPListCostDTO emwplistcostdto) {
        EMWPListCost domain = emwplistcostMapping.toDomain(emwplistcostdto);
        domain.setWplistid(emwplist_id);
		emwplistcostService.create(domain);
        EMWPListCostDTO dto = emwplistcostMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Create',{'Sql',this.emwplistcostMapping,#emwplistcostdtos})")
    @ApiOperation(value = "createBatchByEMStorePartEMItemEMWPList", tags = {"EMWPListCost" },  notes = "createBatchByEMStorePartEMItemEMWPList")
	@RequestMapping(method = RequestMethod.POST, value = "/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emwplists/{emwplist_id}/emwplistcosts/batch")
    public ResponseEntity<Boolean> createBatchByEMStorePartEMItemEMWPList(@PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emwplist_id") String emwplist_id, @RequestBody List<EMWPListCostDTO> emwplistcostdtos) {
        List<EMWPListCost> domainlist=emwplistcostMapping.toDomain(emwplistcostdtos);
        for(EMWPListCost domain:domainlist){
            domain.setWplistid(emwplist_id);
        }
        emwplistcostService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMWPListCost-GetDraft-all')")
    @ApiOperation(value = "GetDraftByEMStorePartEMItemEMWPList", tags = {"EMWPListCost" },  notes = "GetDraftByEMStorePartEMItemEMWPList")
    @RequestMapping(method = RequestMethod.GET, value = "/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emwplists/{emwplist_id}/emwplistcosts/getdraft")
    public ResponseEntity<EMWPListCostDTO> getDraftByEMStorePartEMItemEMWPList(@PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emwplist_id") String emwplist_id) {
        EMWPListCost domain = new EMWPListCost();
        domain.setWplistid(emwplist_id);
        return ResponseEntity.status(HttpStatus.OK).body(emwplistcostMapping.toDto(emwplistcostService.getDraft(domain)));
    }

    @PreAuthorize("hasPermission(#emwplistcost_id,'Remove',{'Sql',this.emwplistcostMapping,this.permissionDTO})")
    @ApiOperation(value = "RemoveByEMStorePartEMItemEMWPList", tags = {"EMWPListCost" },  notes = "RemoveByEMStorePartEMItemEMWPList")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emwplists/{emwplist_id}/emwplistcosts/{emwplistcost_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByEMStorePartEMItemEMWPList(@PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emwplist_id") String emwplist_id, @PathVariable("emwplistcost_id") String emwplistcost_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emwplistcostService.remove(emwplistcost_id));
    }

    @PreAuthorize("hasPermission('Remove',{'Sql',this.emwplistcostMapping,this.permissionDTO,#ids})")
    @ApiOperation(value = "RemoveBatchByEMStorePartEMItemEMWPList", tags = {"EMWPListCost" },  notes = "RemoveBatchByEMStorePartEMItemEMWPList")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emwplists/{emwplist_id}/emwplistcosts/batch")
    public ResponseEntity<Boolean> removeBatchByEMStorePartEMItemEMWPList(@RequestBody List<String> ids) {
        emwplistcostService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(#emwplistcost_id,'Get',{'Sql',this.emwplistcostMapping,this.permissionDTO})")
    @ApiOperation(value = "GetByEMStorePartEMItemEMWPList", tags = {"EMWPListCost" },  notes = "GetByEMStorePartEMItemEMWPList")
	@RequestMapping(method = RequestMethod.GET, value = "/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emwplists/{emwplist_id}/emwplistcosts/{emwplistcost_id}")
    public ResponseEntity<EMWPListCostDTO> getByEMStorePartEMItemEMWPList(@PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emwplist_id") String emwplist_id, @PathVariable("emwplistcost_id") String emwplistcost_id) {
        EMWPListCost domain = emwplistcostService.get(emwplistcost_id);
        EMWPListCostDTO dto = emwplistcostMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('','Save',{'Sql',this.emwplistcostMapping,#emwplistcostdto})")
    @ApiOperation(value = "SaveByEMStorePartEMItemEMWPList", tags = {"EMWPListCost" },  notes = "SaveByEMStorePartEMItemEMWPList")
	@RequestMapping(method = RequestMethod.POST, value = "/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emwplists/{emwplist_id}/emwplistcosts/save")
    public ResponseEntity<Boolean> saveByEMStorePartEMItemEMWPList(@PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emwplist_id") String emwplist_id, @RequestBody EMWPListCostDTO emwplistcostdto) {
        EMWPListCost domain = emwplistcostMapping.toDomain(emwplistcostdto);
        domain.setWplistid(emwplist_id);
        return ResponseEntity.status(HttpStatus.OK).body(emwplistcostService.save(domain));
    }

    @PreAuthorize("hasPermission('Save',{'Sql',this.emwplistcostMapping,#emwplistcostdtos})")
    @ApiOperation(value = "SaveBatchByEMStorePartEMItemEMWPList", tags = {"EMWPListCost" },  notes = "SaveBatchByEMStorePartEMItemEMWPList")
	@RequestMapping(method = RequestMethod.POST, value = "/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emwplists/{emwplist_id}/emwplistcosts/savebatch")
    public ResponseEntity<Boolean> saveBatchByEMStorePartEMItemEMWPList(@PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emwplist_id") String emwplist_id, @RequestBody List<EMWPListCostDTO> emwplistcostdtos) {
        List<EMWPListCost> domainlist=emwplistcostMapping.toDomain(emwplistcostdtos);
        for(EMWPListCost domain:domainlist){
             domain.setWplistid(emwplist_id);
        }
        emwplistcostService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMWPListCost-CheckKey-all')")
    @ApiOperation(value = "CheckKeyByEMStorePartEMItemEMWPList", tags = {"EMWPListCost" },  notes = "CheckKeyByEMStorePartEMItemEMWPList")
	@RequestMapping(method = RequestMethod.POST, value = "/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emwplists/{emwplist_id}/emwplistcosts/checkkey")
    public ResponseEntity<Boolean> checkKeyByEMStorePartEMItemEMWPList(@PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emwplist_id") String emwplist_id, @RequestBody EMWPListCostDTO emwplistcostdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emwplistcostService.checkKey(emwplistcostMapping.toDomain(emwplistcostdto)));
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMWPListCost-Default-all')")
	@ApiOperation(value = "fetchDEFAULTByEMStorePartEMItemEMWPList", tags = {"EMWPListCost" } ,notes = "fetchDEFAULTByEMStorePartEMItemEMWPList")
    @RequestMapping(method= RequestMethod.GET , value="/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emwplists/{emwplist_id}/emwplistcosts/fetchdefault")
	public ResponseEntity<List<EMWPListCostDTO>> fetchEMWPListCostDefaultByEMStorePartEMItemEMWPList(@PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emwplist_id") String emwplist_id,EMWPListCostSearchContext context) {
        context.setN_wplistid_eq(emwplist_id);
        Page<EMWPListCost> domains = emwplistcostService.searchDefault(context) ;
        List<EMWPListCostDTO> list = emwplistcostMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMWPListCost-Default-all')")
	@ApiOperation(value = "searchDEFAULTByEMStorePartEMItemEMWPList", tags = {"EMWPListCost" } ,notes = "searchDEFAULTByEMStorePartEMItemEMWPList")
    @RequestMapping(method= RequestMethod.POST , value="/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emwplists/{emwplist_id}/emwplistcosts/searchdefault")
	public ResponseEntity<Page<EMWPListCostDTO>> searchEMWPListCostDefaultByEMStorePartEMItemEMWPList(@PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emwplist_id") String emwplist_id, @RequestBody EMWPListCostSearchContext context) {
        context.setN_wplistid_eq(emwplist_id);
        Page<EMWPListCost> domains = emwplistcostService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emwplistcostMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
    @PreAuthorize("hasPermission(#emwplistcost_id,'Update',{'Sql',this.emwplistcostMapping,#emwplistcostdto})")
    @ApiOperation(value = "UpdateByEMStoreEMItemEMWPList", tags = {"EMWPListCost" },  notes = "UpdateByEMStoreEMItemEMWPList")
	@RequestMapping(method = RequestMethod.PUT, value = "/emstores/{emstore_id}/emitems/{emitem_id}/emwplists/{emwplist_id}/emwplistcosts/{emwplistcost_id}")
    @Transactional
    public ResponseEntity<EMWPListCostDTO> updateByEMStoreEMItemEMWPList(@PathVariable("emstore_id") String emstore_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emwplist_id") String emwplist_id, @PathVariable("emwplistcost_id") String emwplistcost_id, @RequestBody EMWPListCostDTO emwplistcostdto) {
        EMWPListCost domain = emwplistcostMapping.toDomain(emwplistcostdto);
        domain.setWplistid(emwplist_id);
        domain.setEmwplistcostid(emwplistcost_id);
		emwplistcostService.update(domain);
        EMWPListCostDTO dto = emwplistcostMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Update',{'Sql',this.emwplistcostMapping,#emwplistcostdtos})")
    @ApiOperation(value = "UpdateBatchByEMStoreEMItemEMWPList", tags = {"EMWPListCost" },  notes = "UpdateBatchByEMStoreEMItemEMWPList")
	@RequestMapping(method = RequestMethod.PUT, value = "/emstores/{emstore_id}/emitems/{emitem_id}/emwplists/{emwplist_id}/emwplistcosts/batch")
    public ResponseEntity<Boolean> updateBatchByEMStoreEMItemEMWPList(@PathVariable("emstore_id") String emstore_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emwplist_id") String emwplist_id, @RequestBody List<EMWPListCostDTO> emwplistcostdtos) {
        List<EMWPListCost> domainlist=emwplistcostMapping.toDomain(emwplistcostdtos);
        for(EMWPListCost domain:domainlist){
            domain.setWplistid(emwplist_id);
        }
        emwplistcostService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission('','Create',{'Sql',this.emwplistcostMapping,#emwplistcostdto})")
    @ApiOperation(value = "CreateByEMStoreEMItemEMWPList", tags = {"EMWPListCost" },  notes = "CreateByEMStoreEMItemEMWPList")
	@RequestMapping(method = RequestMethod.POST, value = "/emstores/{emstore_id}/emitems/{emitem_id}/emwplists/{emwplist_id}/emwplistcosts")
    @Transactional
    public ResponseEntity<EMWPListCostDTO> createByEMStoreEMItemEMWPList(@PathVariable("emstore_id") String emstore_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emwplist_id") String emwplist_id, @RequestBody EMWPListCostDTO emwplistcostdto) {
        EMWPListCost domain = emwplistcostMapping.toDomain(emwplistcostdto);
        domain.setWplistid(emwplist_id);
		emwplistcostService.create(domain);
        EMWPListCostDTO dto = emwplistcostMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Create',{'Sql',this.emwplistcostMapping,#emwplistcostdtos})")
    @ApiOperation(value = "createBatchByEMStoreEMItemEMWPList", tags = {"EMWPListCost" },  notes = "createBatchByEMStoreEMItemEMWPList")
	@RequestMapping(method = RequestMethod.POST, value = "/emstores/{emstore_id}/emitems/{emitem_id}/emwplists/{emwplist_id}/emwplistcosts/batch")
    public ResponseEntity<Boolean> createBatchByEMStoreEMItemEMWPList(@PathVariable("emstore_id") String emstore_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emwplist_id") String emwplist_id, @RequestBody List<EMWPListCostDTO> emwplistcostdtos) {
        List<EMWPListCost> domainlist=emwplistcostMapping.toDomain(emwplistcostdtos);
        for(EMWPListCost domain:domainlist){
            domain.setWplistid(emwplist_id);
        }
        emwplistcostService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMWPListCost-GetDraft-all')")
    @ApiOperation(value = "GetDraftByEMStoreEMItemEMWPList", tags = {"EMWPListCost" },  notes = "GetDraftByEMStoreEMItemEMWPList")
    @RequestMapping(method = RequestMethod.GET, value = "/emstores/{emstore_id}/emitems/{emitem_id}/emwplists/{emwplist_id}/emwplistcosts/getdraft")
    public ResponseEntity<EMWPListCostDTO> getDraftByEMStoreEMItemEMWPList(@PathVariable("emstore_id") String emstore_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emwplist_id") String emwplist_id) {
        EMWPListCost domain = new EMWPListCost();
        domain.setWplistid(emwplist_id);
        return ResponseEntity.status(HttpStatus.OK).body(emwplistcostMapping.toDto(emwplistcostService.getDraft(domain)));
    }

    @PreAuthorize("hasPermission(#emwplistcost_id,'Remove',{'Sql',this.emwplistcostMapping,this.permissionDTO})")
    @ApiOperation(value = "RemoveByEMStoreEMItemEMWPList", tags = {"EMWPListCost" },  notes = "RemoveByEMStoreEMItemEMWPList")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emstores/{emstore_id}/emitems/{emitem_id}/emwplists/{emwplist_id}/emwplistcosts/{emwplistcost_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByEMStoreEMItemEMWPList(@PathVariable("emstore_id") String emstore_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emwplist_id") String emwplist_id, @PathVariable("emwplistcost_id") String emwplistcost_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emwplistcostService.remove(emwplistcost_id));
    }

    @PreAuthorize("hasPermission('Remove',{'Sql',this.emwplistcostMapping,this.permissionDTO,#ids})")
    @ApiOperation(value = "RemoveBatchByEMStoreEMItemEMWPList", tags = {"EMWPListCost" },  notes = "RemoveBatchByEMStoreEMItemEMWPList")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emstores/{emstore_id}/emitems/{emitem_id}/emwplists/{emwplist_id}/emwplistcosts/batch")
    public ResponseEntity<Boolean> removeBatchByEMStoreEMItemEMWPList(@RequestBody List<String> ids) {
        emwplistcostService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(#emwplistcost_id,'Get',{'Sql',this.emwplistcostMapping,this.permissionDTO})")
    @ApiOperation(value = "GetByEMStoreEMItemEMWPList", tags = {"EMWPListCost" },  notes = "GetByEMStoreEMItemEMWPList")
	@RequestMapping(method = RequestMethod.GET, value = "/emstores/{emstore_id}/emitems/{emitem_id}/emwplists/{emwplist_id}/emwplistcosts/{emwplistcost_id}")
    public ResponseEntity<EMWPListCostDTO> getByEMStoreEMItemEMWPList(@PathVariable("emstore_id") String emstore_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emwplist_id") String emwplist_id, @PathVariable("emwplistcost_id") String emwplistcost_id) {
        EMWPListCost domain = emwplistcostService.get(emwplistcost_id);
        EMWPListCostDTO dto = emwplistcostMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('','Save',{'Sql',this.emwplistcostMapping,#emwplistcostdto})")
    @ApiOperation(value = "SaveByEMStoreEMItemEMWPList", tags = {"EMWPListCost" },  notes = "SaveByEMStoreEMItemEMWPList")
	@RequestMapping(method = RequestMethod.POST, value = "/emstores/{emstore_id}/emitems/{emitem_id}/emwplists/{emwplist_id}/emwplistcosts/save")
    public ResponseEntity<Boolean> saveByEMStoreEMItemEMWPList(@PathVariable("emstore_id") String emstore_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emwplist_id") String emwplist_id, @RequestBody EMWPListCostDTO emwplistcostdto) {
        EMWPListCost domain = emwplistcostMapping.toDomain(emwplistcostdto);
        domain.setWplistid(emwplist_id);
        return ResponseEntity.status(HttpStatus.OK).body(emwplistcostService.save(domain));
    }

    @PreAuthorize("hasPermission('Save',{'Sql',this.emwplistcostMapping,#emwplistcostdtos})")
    @ApiOperation(value = "SaveBatchByEMStoreEMItemEMWPList", tags = {"EMWPListCost" },  notes = "SaveBatchByEMStoreEMItemEMWPList")
	@RequestMapping(method = RequestMethod.POST, value = "/emstores/{emstore_id}/emitems/{emitem_id}/emwplists/{emwplist_id}/emwplistcosts/savebatch")
    public ResponseEntity<Boolean> saveBatchByEMStoreEMItemEMWPList(@PathVariable("emstore_id") String emstore_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emwplist_id") String emwplist_id, @RequestBody List<EMWPListCostDTO> emwplistcostdtos) {
        List<EMWPListCost> domainlist=emwplistcostMapping.toDomain(emwplistcostdtos);
        for(EMWPListCost domain:domainlist){
             domain.setWplistid(emwplist_id);
        }
        emwplistcostService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMWPListCost-CheckKey-all')")
    @ApiOperation(value = "CheckKeyByEMStoreEMItemEMWPList", tags = {"EMWPListCost" },  notes = "CheckKeyByEMStoreEMItemEMWPList")
	@RequestMapping(method = RequestMethod.POST, value = "/emstores/{emstore_id}/emitems/{emitem_id}/emwplists/{emwplist_id}/emwplistcosts/checkkey")
    public ResponseEntity<Boolean> checkKeyByEMStoreEMItemEMWPList(@PathVariable("emstore_id") String emstore_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emwplist_id") String emwplist_id, @RequestBody EMWPListCostDTO emwplistcostdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emwplistcostService.checkKey(emwplistcostMapping.toDomain(emwplistcostdto)));
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMWPListCost-Default-all')")
	@ApiOperation(value = "fetchDEFAULTByEMStoreEMItemEMWPList", tags = {"EMWPListCost" } ,notes = "fetchDEFAULTByEMStoreEMItemEMWPList")
    @RequestMapping(method= RequestMethod.GET , value="/emstores/{emstore_id}/emitems/{emitem_id}/emwplists/{emwplist_id}/emwplistcosts/fetchdefault")
	public ResponseEntity<List<EMWPListCostDTO>> fetchEMWPListCostDefaultByEMStoreEMItemEMWPList(@PathVariable("emstore_id") String emstore_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emwplist_id") String emwplist_id,EMWPListCostSearchContext context) {
        context.setN_wplistid_eq(emwplist_id);
        Page<EMWPListCost> domains = emwplistcostService.searchDefault(context) ;
        List<EMWPListCostDTO> list = emwplistcostMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMWPListCost-Default-all')")
	@ApiOperation(value = "searchDEFAULTByEMStoreEMItemEMWPList", tags = {"EMWPListCost" } ,notes = "searchDEFAULTByEMStoreEMItemEMWPList")
    @RequestMapping(method= RequestMethod.POST , value="/emstores/{emstore_id}/emitems/{emitem_id}/emwplists/{emwplist_id}/emwplistcosts/searchdefault")
	public ResponseEntity<Page<EMWPListCostDTO>> searchEMWPListCostDefaultByEMStoreEMItemEMWPList(@PathVariable("emstore_id") String emstore_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emwplist_id") String emwplist_id, @RequestBody EMWPListCostSearchContext context) {
        context.setN_wplistid_eq(emwplist_id);
        Page<EMWPListCost> domains = emwplistcostService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emwplistcostMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
    @PreAuthorize("hasPermission(#emwplistcost_id,'Update',{'Sql',this.emwplistcostMapping,#emwplistcostdto})")
    @ApiOperation(value = "UpdateByPFEmpEMItemEMWPList", tags = {"EMWPListCost" },  notes = "UpdateByPFEmpEMItemEMWPList")
	@RequestMapping(method = RequestMethod.PUT, value = "/pfemps/{pfemp_id}/emitems/{emitem_id}/emwplists/{emwplist_id}/emwplistcosts/{emwplistcost_id}")
    @Transactional
    public ResponseEntity<EMWPListCostDTO> updateByPFEmpEMItemEMWPList(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emwplist_id") String emwplist_id, @PathVariable("emwplistcost_id") String emwplistcost_id, @RequestBody EMWPListCostDTO emwplistcostdto) {
        EMWPListCost domain = emwplistcostMapping.toDomain(emwplistcostdto);
        domain.setWplistid(emwplist_id);
        domain.setEmwplistcostid(emwplistcost_id);
		emwplistcostService.update(domain);
        EMWPListCostDTO dto = emwplistcostMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Update',{'Sql',this.emwplistcostMapping,#emwplistcostdtos})")
    @ApiOperation(value = "UpdateBatchByPFEmpEMItemEMWPList", tags = {"EMWPListCost" },  notes = "UpdateBatchByPFEmpEMItemEMWPList")
	@RequestMapping(method = RequestMethod.PUT, value = "/pfemps/{pfemp_id}/emitems/{emitem_id}/emwplists/{emwplist_id}/emwplistcosts/batch")
    public ResponseEntity<Boolean> updateBatchByPFEmpEMItemEMWPList(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emwplist_id") String emwplist_id, @RequestBody List<EMWPListCostDTO> emwplistcostdtos) {
        List<EMWPListCost> domainlist=emwplistcostMapping.toDomain(emwplistcostdtos);
        for(EMWPListCost domain:domainlist){
            domain.setWplistid(emwplist_id);
        }
        emwplistcostService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission('','Create',{'Sql',this.emwplistcostMapping,#emwplistcostdto})")
    @ApiOperation(value = "CreateByPFEmpEMItemEMWPList", tags = {"EMWPListCost" },  notes = "CreateByPFEmpEMItemEMWPList")
	@RequestMapping(method = RequestMethod.POST, value = "/pfemps/{pfemp_id}/emitems/{emitem_id}/emwplists/{emwplist_id}/emwplistcosts")
    @Transactional
    public ResponseEntity<EMWPListCostDTO> createByPFEmpEMItemEMWPList(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emwplist_id") String emwplist_id, @RequestBody EMWPListCostDTO emwplistcostdto) {
        EMWPListCost domain = emwplistcostMapping.toDomain(emwplistcostdto);
        domain.setWplistid(emwplist_id);
		emwplistcostService.create(domain);
        EMWPListCostDTO dto = emwplistcostMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Create',{'Sql',this.emwplistcostMapping,#emwplistcostdtos})")
    @ApiOperation(value = "createBatchByPFEmpEMItemEMWPList", tags = {"EMWPListCost" },  notes = "createBatchByPFEmpEMItemEMWPList")
	@RequestMapping(method = RequestMethod.POST, value = "/pfemps/{pfemp_id}/emitems/{emitem_id}/emwplists/{emwplist_id}/emwplistcosts/batch")
    public ResponseEntity<Boolean> createBatchByPFEmpEMItemEMWPList(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emwplist_id") String emwplist_id, @RequestBody List<EMWPListCostDTO> emwplistcostdtos) {
        List<EMWPListCost> domainlist=emwplistcostMapping.toDomain(emwplistcostdtos);
        for(EMWPListCost domain:domainlist){
            domain.setWplistid(emwplist_id);
        }
        emwplistcostService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMWPListCost-GetDraft-all')")
    @ApiOperation(value = "GetDraftByPFEmpEMItemEMWPList", tags = {"EMWPListCost" },  notes = "GetDraftByPFEmpEMItemEMWPList")
    @RequestMapping(method = RequestMethod.GET, value = "/pfemps/{pfemp_id}/emitems/{emitem_id}/emwplists/{emwplist_id}/emwplistcosts/getdraft")
    public ResponseEntity<EMWPListCostDTO> getDraftByPFEmpEMItemEMWPList(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emwplist_id") String emwplist_id) {
        EMWPListCost domain = new EMWPListCost();
        domain.setWplistid(emwplist_id);
        return ResponseEntity.status(HttpStatus.OK).body(emwplistcostMapping.toDto(emwplistcostService.getDraft(domain)));
    }

    @PreAuthorize("hasPermission(#emwplistcost_id,'Remove',{'Sql',this.emwplistcostMapping,this.permissionDTO})")
    @ApiOperation(value = "RemoveByPFEmpEMItemEMWPList", tags = {"EMWPListCost" },  notes = "RemoveByPFEmpEMItemEMWPList")
	@RequestMapping(method = RequestMethod.DELETE, value = "/pfemps/{pfemp_id}/emitems/{emitem_id}/emwplists/{emwplist_id}/emwplistcosts/{emwplistcost_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByPFEmpEMItemEMWPList(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emwplist_id") String emwplist_id, @PathVariable("emwplistcost_id") String emwplistcost_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emwplistcostService.remove(emwplistcost_id));
    }

    @PreAuthorize("hasPermission('Remove',{'Sql',this.emwplistcostMapping,this.permissionDTO,#ids})")
    @ApiOperation(value = "RemoveBatchByPFEmpEMItemEMWPList", tags = {"EMWPListCost" },  notes = "RemoveBatchByPFEmpEMItemEMWPList")
	@RequestMapping(method = RequestMethod.DELETE, value = "/pfemps/{pfemp_id}/emitems/{emitem_id}/emwplists/{emwplist_id}/emwplistcosts/batch")
    public ResponseEntity<Boolean> removeBatchByPFEmpEMItemEMWPList(@RequestBody List<String> ids) {
        emwplistcostService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(#emwplistcost_id,'Get',{'Sql',this.emwplistcostMapping,this.permissionDTO})")
    @ApiOperation(value = "GetByPFEmpEMItemEMWPList", tags = {"EMWPListCost" },  notes = "GetByPFEmpEMItemEMWPList")
	@RequestMapping(method = RequestMethod.GET, value = "/pfemps/{pfemp_id}/emitems/{emitem_id}/emwplists/{emwplist_id}/emwplistcosts/{emwplistcost_id}")
    public ResponseEntity<EMWPListCostDTO> getByPFEmpEMItemEMWPList(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emwplist_id") String emwplist_id, @PathVariable("emwplistcost_id") String emwplistcost_id) {
        EMWPListCost domain = emwplistcostService.get(emwplistcost_id);
        EMWPListCostDTO dto = emwplistcostMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('','Save',{'Sql',this.emwplistcostMapping,#emwplistcostdto})")
    @ApiOperation(value = "SaveByPFEmpEMItemEMWPList", tags = {"EMWPListCost" },  notes = "SaveByPFEmpEMItemEMWPList")
	@RequestMapping(method = RequestMethod.POST, value = "/pfemps/{pfemp_id}/emitems/{emitem_id}/emwplists/{emwplist_id}/emwplistcosts/save")
    public ResponseEntity<Boolean> saveByPFEmpEMItemEMWPList(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emwplist_id") String emwplist_id, @RequestBody EMWPListCostDTO emwplistcostdto) {
        EMWPListCost domain = emwplistcostMapping.toDomain(emwplistcostdto);
        domain.setWplistid(emwplist_id);
        return ResponseEntity.status(HttpStatus.OK).body(emwplistcostService.save(domain));
    }

    @PreAuthorize("hasPermission('Save',{'Sql',this.emwplistcostMapping,#emwplistcostdtos})")
    @ApiOperation(value = "SaveBatchByPFEmpEMItemEMWPList", tags = {"EMWPListCost" },  notes = "SaveBatchByPFEmpEMItemEMWPList")
	@RequestMapping(method = RequestMethod.POST, value = "/pfemps/{pfemp_id}/emitems/{emitem_id}/emwplists/{emwplist_id}/emwplistcosts/savebatch")
    public ResponseEntity<Boolean> saveBatchByPFEmpEMItemEMWPList(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emwplist_id") String emwplist_id, @RequestBody List<EMWPListCostDTO> emwplistcostdtos) {
        List<EMWPListCost> domainlist=emwplistcostMapping.toDomain(emwplistcostdtos);
        for(EMWPListCost domain:domainlist){
             domain.setWplistid(emwplist_id);
        }
        emwplistcostService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMWPListCost-CheckKey-all')")
    @ApiOperation(value = "CheckKeyByPFEmpEMItemEMWPList", tags = {"EMWPListCost" },  notes = "CheckKeyByPFEmpEMItemEMWPList")
	@RequestMapping(method = RequestMethod.POST, value = "/pfemps/{pfemp_id}/emitems/{emitem_id}/emwplists/{emwplist_id}/emwplistcosts/checkkey")
    public ResponseEntity<Boolean> checkKeyByPFEmpEMItemEMWPList(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emwplist_id") String emwplist_id, @RequestBody EMWPListCostDTO emwplistcostdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emwplistcostService.checkKey(emwplistcostMapping.toDomain(emwplistcostdto)));
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMWPListCost-Default-all')")
	@ApiOperation(value = "fetchDEFAULTByPFEmpEMItemEMWPList", tags = {"EMWPListCost" } ,notes = "fetchDEFAULTByPFEmpEMItemEMWPList")
    @RequestMapping(method= RequestMethod.GET , value="/pfemps/{pfemp_id}/emitems/{emitem_id}/emwplists/{emwplist_id}/emwplistcosts/fetchdefault")
	public ResponseEntity<List<EMWPListCostDTO>> fetchEMWPListCostDefaultByPFEmpEMItemEMWPList(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emwplist_id") String emwplist_id,EMWPListCostSearchContext context) {
        context.setN_wplistid_eq(emwplist_id);
        Page<EMWPListCost> domains = emwplistcostService.searchDefault(context) ;
        List<EMWPListCostDTO> list = emwplistcostMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMWPListCost-Default-all')")
	@ApiOperation(value = "searchDEFAULTByPFEmpEMItemEMWPList", tags = {"EMWPListCost" } ,notes = "searchDEFAULTByPFEmpEMItemEMWPList")
    @RequestMapping(method= RequestMethod.POST , value="/pfemps/{pfemp_id}/emitems/{emitem_id}/emwplists/{emwplist_id}/emwplistcosts/searchdefault")
	public ResponseEntity<Page<EMWPListCostDTO>> searchEMWPListCostDefaultByPFEmpEMItemEMWPList(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emwplist_id") String emwplist_id, @RequestBody EMWPListCostSearchContext context) {
        context.setN_wplistid_eq(emwplist_id);
        Page<EMWPListCost> domains = emwplistcostService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emwplistcostMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
    @PreAuthorize("hasPermission(#emwplistcost_id,'Update',{'Sql',this.emwplistcostMapping,#emwplistcostdto})")
    @ApiOperation(value = "UpdateByPFUnitEMItemEMWPList", tags = {"EMWPListCost" },  notes = "UpdateByPFUnitEMItemEMWPList")
	@RequestMapping(method = RequestMethod.PUT, value = "/pfunits/{pfunit_id}/emitems/{emitem_id}/emwplists/{emwplist_id}/emwplistcosts/{emwplistcost_id}")
    @Transactional
    public ResponseEntity<EMWPListCostDTO> updateByPFUnitEMItemEMWPList(@PathVariable("pfunit_id") String pfunit_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emwplist_id") String emwplist_id, @PathVariable("emwplistcost_id") String emwplistcost_id, @RequestBody EMWPListCostDTO emwplistcostdto) {
        EMWPListCost domain = emwplistcostMapping.toDomain(emwplistcostdto);
        domain.setWplistid(emwplist_id);
        domain.setEmwplistcostid(emwplistcost_id);
		emwplistcostService.update(domain);
        EMWPListCostDTO dto = emwplistcostMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Update',{'Sql',this.emwplistcostMapping,#emwplistcostdtos})")
    @ApiOperation(value = "UpdateBatchByPFUnitEMItemEMWPList", tags = {"EMWPListCost" },  notes = "UpdateBatchByPFUnitEMItemEMWPList")
	@RequestMapping(method = RequestMethod.PUT, value = "/pfunits/{pfunit_id}/emitems/{emitem_id}/emwplists/{emwplist_id}/emwplistcosts/batch")
    public ResponseEntity<Boolean> updateBatchByPFUnitEMItemEMWPList(@PathVariable("pfunit_id") String pfunit_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emwplist_id") String emwplist_id, @RequestBody List<EMWPListCostDTO> emwplistcostdtos) {
        List<EMWPListCost> domainlist=emwplistcostMapping.toDomain(emwplistcostdtos);
        for(EMWPListCost domain:domainlist){
            domain.setWplistid(emwplist_id);
        }
        emwplistcostService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission('','Create',{'Sql',this.emwplistcostMapping,#emwplistcostdto})")
    @ApiOperation(value = "CreateByPFUnitEMItemEMWPList", tags = {"EMWPListCost" },  notes = "CreateByPFUnitEMItemEMWPList")
	@RequestMapping(method = RequestMethod.POST, value = "/pfunits/{pfunit_id}/emitems/{emitem_id}/emwplists/{emwplist_id}/emwplistcosts")
    @Transactional
    public ResponseEntity<EMWPListCostDTO> createByPFUnitEMItemEMWPList(@PathVariable("pfunit_id") String pfunit_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emwplist_id") String emwplist_id, @RequestBody EMWPListCostDTO emwplistcostdto) {
        EMWPListCost domain = emwplistcostMapping.toDomain(emwplistcostdto);
        domain.setWplistid(emwplist_id);
		emwplistcostService.create(domain);
        EMWPListCostDTO dto = emwplistcostMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Create',{'Sql',this.emwplistcostMapping,#emwplistcostdtos})")
    @ApiOperation(value = "createBatchByPFUnitEMItemEMWPList", tags = {"EMWPListCost" },  notes = "createBatchByPFUnitEMItemEMWPList")
	@RequestMapping(method = RequestMethod.POST, value = "/pfunits/{pfunit_id}/emitems/{emitem_id}/emwplists/{emwplist_id}/emwplistcosts/batch")
    public ResponseEntity<Boolean> createBatchByPFUnitEMItemEMWPList(@PathVariable("pfunit_id") String pfunit_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emwplist_id") String emwplist_id, @RequestBody List<EMWPListCostDTO> emwplistcostdtos) {
        List<EMWPListCost> domainlist=emwplistcostMapping.toDomain(emwplistcostdtos);
        for(EMWPListCost domain:domainlist){
            domain.setWplistid(emwplist_id);
        }
        emwplistcostService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMWPListCost-GetDraft-all')")
    @ApiOperation(value = "GetDraftByPFUnitEMItemEMWPList", tags = {"EMWPListCost" },  notes = "GetDraftByPFUnitEMItemEMWPList")
    @RequestMapping(method = RequestMethod.GET, value = "/pfunits/{pfunit_id}/emitems/{emitem_id}/emwplists/{emwplist_id}/emwplistcosts/getdraft")
    public ResponseEntity<EMWPListCostDTO> getDraftByPFUnitEMItemEMWPList(@PathVariable("pfunit_id") String pfunit_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emwplist_id") String emwplist_id) {
        EMWPListCost domain = new EMWPListCost();
        domain.setWplistid(emwplist_id);
        return ResponseEntity.status(HttpStatus.OK).body(emwplistcostMapping.toDto(emwplistcostService.getDraft(domain)));
    }

    @PreAuthorize("hasPermission(#emwplistcost_id,'Remove',{'Sql',this.emwplistcostMapping,this.permissionDTO})")
    @ApiOperation(value = "RemoveByPFUnitEMItemEMWPList", tags = {"EMWPListCost" },  notes = "RemoveByPFUnitEMItemEMWPList")
	@RequestMapping(method = RequestMethod.DELETE, value = "/pfunits/{pfunit_id}/emitems/{emitem_id}/emwplists/{emwplist_id}/emwplistcosts/{emwplistcost_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByPFUnitEMItemEMWPList(@PathVariable("pfunit_id") String pfunit_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emwplist_id") String emwplist_id, @PathVariable("emwplistcost_id") String emwplistcost_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emwplistcostService.remove(emwplistcost_id));
    }

    @PreAuthorize("hasPermission('Remove',{'Sql',this.emwplistcostMapping,this.permissionDTO,#ids})")
    @ApiOperation(value = "RemoveBatchByPFUnitEMItemEMWPList", tags = {"EMWPListCost" },  notes = "RemoveBatchByPFUnitEMItemEMWPList")
	@RequestMapping(method = RequestMethod.DELETE, value = "/pfunits/{pfunit_id}/emitems/{emitem_id}/emwplists/{emwplist_id}/emwplistcosts/batch")
    public ResponseEntity<Boolean> removeBatchByPFUnitEMItemEMWPList(@RequestBody List<String> ids) {
        emwplistcostService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(#emwplistcost_id,'Get',{'Sql',this.emwplistcostMapping,this.permissionDTO})")
    @ApiOperation(value = "GetByPFUnitEMItemEMWPList", tags = {"EMWPListCost" },  notes = "GetByPFUnitEMItemEMWPList")
	@RequestMapping(method = RequestMethod.GET, value = "/pfunits/{pfunit_id}/emitems/{emitem_id}/emwplists/{emwplist_id}/emwplistcosts/{emwplistcost_id}")
    public ResponseEntity<EMWPListCostDTO> getByPFUnitEMItemEMWPList(@PathVariable("pfunit_id") String pfunit_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emwplist_id") String emwplist_id, @PathVariable("emwplistcost_id") String emwplistcost_id) {
        EMWPListCost domain = emwplistcostService.get(emwplistcost_id);
        EMWPListCostDTO dto = emwplistcostMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('','Save',{'Sql',this.emwplistcostMapping,#emwplistcostdto})")
    @ApiOperation(value = "SaveByPFUnitEMItemEMWPList", tags = {"EMWPListCost" },  notes = "SaveByPFUnitEMItemEMWPList")
	@RequestMapping(method = RequestMethod.POST, value = "/pfunits/{pfunit_id}/emitems/{emitem_id}/emwplists/{emwplist_id}/emwplistcosts/save")
    public ResponseEntity<Boolean> saveByPFUnitEMItemEMWPList(@PathVariable("pfunit_id") String pfunit_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emwplist_id") String emwplist_id, @RequestBody EMWPListCostDTO emwplistcostdto) {
        EMWPListCost domain = emwplistcostMapping.toDomain(emwplistcostdto);
        domain.setWplistid(emwplist_id);
        return ResponseEntity.status(HttpStatus.OK).body(emwplistcostService.save(domain));
    }

    @PreAuthorize("hasPermission('Save',{'Sql',this.emwplistcostMapping,#emwplistcostdtos})")
    @ApiOperation(value = "SaveBatchByPFUnitEMItemEMWPList", tags = {"EMWPListCost" },  notes = "SaveBatchByPFUnitEMItemEMWPList")
	@RequestMapping(method = RequestMethod.POST, value = "/pfunits/{pfunit_id}/emitems/{emitem_id}/emwplists/{emwplist_id}/emwplistcosts/savebatch")
    public ResponseEntity<Boolean> saveBatchByPFUnitEMItemEMWPList(@PathVariable("pfunit_id") String pfunit_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emwplist_id") String emwplist_id, @RequestBody List<EMWPListCostDTO> emwplistcostdtos) {
        List<EMWPListCost> domainlist=emwplistcostMapping.toDomain(emwplistcostdtos);
        for(EMWPListCost domain:domainlist){
             domain.setWplistid(emwplist_id);
        }
        emwplistcostService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMWPListCost-CheckKey-all')")
    @ApiOperation(value = "CheckKeyByPFUnitEMItemEMWPList", tags = {"EMWPListCost" },  notes = "CheckKeyByPFUnitEMItemEMWPList")
	@RequestMapping(method = RequestMethod.POST, value = "/pfunits/{pfunit_id}/emitems/{emitem_id}/emwplists/{emwplist_id}/emwplistcosts/checkkey")
    public ResponseEntity<Boolean> checkKeyByPFUnitEMItemEMWPList(@PathVariable("pfunit_id") String pfunit_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emwplist_id") String emwplist_id, @RequestBody EMWPListCostDTO emwplistcostdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emwplistcostService.checkKey(emwplistcostMapping.toDomain(emwplistcostdto)));
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMWPListCost-Default-all')")
	@ApiOperation(value = "fetchDEFAULTByPFUnitEMItemEMWPList", tags = {"EMWPListCost" } ,notes = "fetchDEFAULTByPFUnitEMItemEMWPList")
    @RequestMapping(method= RequestMethod.GET , value="/pfunits/{pfunit_id}/emitems/{emitem_id}/emwplists/{emwplist_id}/emwplistcosts/fetchdefault")
	public ResponseEntity<List<EMWPListCostDTO>> fetchEMWPListCostDefaultByPFUnitEMItemEMWPList(@PathVariable("pfunit_id") String pfunit_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emwplist_id") String emwplist_id,EMWPListCostSearchContext context) {
        context.setN_wplistid_eq(emwplist_id);
        Page<EMWPListCost> domains = emwplistcostService.searchDefault(context) ;
        List<EMWPListCostDTO> list = emwplistcostMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMWPListCost-Default-all')")
	@ApiOperation(value = "searchDEFAULTByPFUnitEMItemEMWPList", tags = {"EMWPListCost" } ,notes = "searchDEFAULTByPFUnitEMItemEMWPList")
    @RequestMapping(method= RequestMethod.POST , value="/pfunits/{pfunit_id}/emitems/{emitem_id}/emwplists/{emwplist_id}/emwplistcosts/searchdefault")
	public ResponseEntity<Page<EMWPListCostDTO>> searchEMWPListCostDefaultByPFUnitEMItemEMWPList(@PathVariable("pfunit_id") String pfunit_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emwplist_id") String emwplist_id, @RequestBody EMWPListCostSearchContext context) {
        context.setN_wplistid_eq(emwplist_id);
        Page<EMWPListCost> domains = emwplistcostService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emwplistcostMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
    @PreAuthorize("hasPermission(#emwplistcost_id,'Update',{'Sql',this.emwplistcostMapping,#emwplistcostdto})")
    @ApiOperation(value = "UpdateByEMStoreEMStorePartEMItem", tags = {"EMWPListCost" },  notes = "UpdateByEMStoreEMStorePartEMItem")
	@RequestMapping(method = RequestMethod.PUT, value = "/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emwplistcosts/{emwplistcost_id}")
    @Transactional
    public ResponseEntity<EMWPListCostDTO> updateByEMStoreEMStorePartEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emwplistcost_id") String emwplistcost_id, @RequestBody EMWPListCostDTO emwplistcostdto) {
        EMWPListCost domain = emwplistcostMapping.toDomain(emwplistcostdto);
        domain.setItemid(emitem_id);
        domain.setEmwplistcostid(emwplistcost_id);
		emwplistcostService.update(domain);
        EMWPListCostDTO dto = emwplistcostMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Update',{'Sql',this.emwplistcostMapping,#emwplistcostdtos})")
    @ApiOperation(value = "UpdateBatchByEMStoreEMStorePartEMItem", tags = {"EMWPListCost" },  notes = "UpdateBatchByEMStoreEMStorePartEMItem")
	@RequestMapping(method = RequestMethod.PUT, value = "/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emwplistcosts/batch")
    public ResponseEntity<Boolean> updateBatchByEMStoreEMStorePartEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMWPListCostDTO> emwplistcostdtos) {
        List<EMWPListCost> domainlist=emwplistcostMapping.toDomain(emwplistcostdtos);
        for(EMWPListCost domain:domainlist){
            domain.setItemid(emitem_id);
        }
        emwplistcostService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission('','Create',{'Sql',this.emwplistcostMapping,#emwplistcostdto})")
    @ApiOperation(value = "CreateByEMStoreEMStorePartEMItem", tags = {"EMWPListCost" },  notes = "CreateByEMStoreEMStorePartEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emwplistcosts")
    @Transactional
    public ResponseEntity<EMWPListCostDTO> createByEMStoreEMStorePartEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMWPListCostDTO emwplistcostdto) {
        EMWPListCost domain = emwplistcostMapping.toDomain(emwplistcostdto);
        domain.setItemid(emitem_id);
		emwplistcostService.create(domain);
        EMWPListCostDTO dto = emwplistcostMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Create',{'Sql',this.emwplistcostMapping,#emwplistcostdtos})")
    @ApiOperation(value = "createBatchByEMStoreEMStorePartEMItem", tags = {"EMWPListCost" },  notes = "createBatchByEMStoreEMStorePartEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emwplistcosts/batch")
    public ResponseEntity<Boolean> createBatchByEMStoreEMStorePartEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMWPListCostDTO> emwplistcostdtos) {
        List<EMWPListCost> domainlist=emwplistcostMapping.toDomain(emwplistcostdtos);
        for(EMWPListCost domain:domainlist){
            domain.setItemid(emitem_id);
        }
        emwplistcostService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMWPListCost-GetDraft-all')")
    @ApiOperation(value = "GetDraftByEMStoreEMStorePartEMItem", tags = {"EMWPListCost" },  notes = "GetDraftByEMStoreEMStorePartEMItem")
    @RequestMapping(method = RequestMethod.GET, value = "/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emwplistcosts/getdraft")
    public ResponseEntity<EMWPListCostDTO> getDraftByEMStoreEMStorePartEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id) {
        EMWPListCost domain = new EMWPListCost();
        domain.setItemid(emitem_id);
        return ResponseEntity.status(HttpStatus.OK).body(emwplistcostMapping.toDto(emwplistcostService.getDraft(domain)));
    }

    @PreAuthorize("hasPermission(#emwplistcost_id,'Remove',{'Sql',this.emwplistcostMapping,this.permissionDTO})")
    @ApiOperation(value = "RemoveByEMStoreEMStorePartEMItem", tags = {"EMWPListCost" },  notes = "RemoveByEMStoreEMStorePartEMItem")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emwplistcosts/{emwplistcost_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByEMStoreEMStorePartEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emwplistcost_id") String emwplistcost_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emwplistcostService.remove(emwplistcost_id));
    }

    @PreAuthorize("hasPermission('Remove',{'Sql',this.emwplistcostMapping,this.permissionDTO,#ids})")
    @ApiOperation(value = "RemoveBatchByEMStoreEMStorePartEMItem", tags = {"EMWPListCost" },  notes = "RemoveBatchByEMStoreEMStorePartEMItem")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emwplistcosts/batch")
    public ResponseEntity<Boolean> removeBatchByEMStoreEMStorePartEMItem(@RequestBody List<String> ids) {
        emwplistcostService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(#emwplistcost_id,'Get',{'Sql',this.emwplistcostMapping,this.permissionDTO})")
    @ApiOperation(value = "GetByEMStoreEMStorePartEMItem", tags = {"EMWPListCost" },  notes = "GetByEMStoreEMStorePartEMItem")
	@RequestMapping(method = RequestMethod.GET, value = "/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emwplistcosts/{emwplistcost_id}")
    public ResponseEntity<EMWPListCostDTO> getByEMStoreEMStorePartEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emwplistcost_id") String emwplistcost_id) {
        EMWPListCost domain = emwplistcostService.get(emwplistcost_id);
        EMWPListCostDTO dto = emwplistcostMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('','Save',{'Sql',this.emwplistcostMapping,#emwplistcostdto})")
    @ApiOperation(value = "SaveByEMStoreEMStorePartEMItem", tags = {"EMWPListCost" },  notes = "SaveByEMStoreEMStorePartEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emwplistcosts/save")
    public ResponseEntity<Boolean> saveByEMStoreEMStorePartEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMWPListCostDTO emwplistcostdto) {
        EMWPListCost domain = emwplistcostMapping.toDomain(emwplistcostdto);
        domain.setItemid(emitem_id);
        return ResponseEntity.status(HttpStatus.OK).body(emwplistcostService.save(domain));
    }

    @PreAuthorize("hasPermission('Save',{'Sql',this.emwplistcostMapping,#emwplistcostdtos})")
    @ApiOperation(value = "SaveBatchByEMStoreEMStorePartEMItem", tags = {"EMWPListCost" },  notes = "SaveBatchByEMStoreEMStorePartEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emwplistcosts/savebatch")
    public ResponseEntity<Boolean> saveBatchByEMStoreEMStorePartEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMWPListCostDTO> emwplistcostdtos) {
        List<EMWPListCost> domainlist=emwplistcostMapping.toDomain(emwplistcostdtos);
        for(EMWPListCost domain:domainlist){
             domain.setItemid(emitem_id);
        }
        emwplistcostService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMWPListCost-CheckKey-all')")
    @ApiOperation(value = "CheckKeyByEMStoreEMStorePartEMItem", tags = {"EMWPListCost" },  notes = "CheckKeyByEMStoreEMStorePartEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emwplistcosts/checkkey")
    public ResponseEntity<Boolean> checkKeyByEMStoreEMStorePartEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMWPListCostDTO emwplistcostdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emwplistcostService.checkKey(emwplistcostMapping.toDomain(emwplistcostdto)));
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMWPListCost-Default-all')")
	@ApiOperation(value = "fetchDEFAULTByEMStoreEMStorePartEMItem", tags = {"EMWPListCost" } ,notes = "fetchDEFAULTByEMStoreEMStorePartEMItem")
    @RequestMapping(method= RequestMethod.GET , value="/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emwplistcosts/fetchdefault")
	public ResponseEntity<List<EMWPListCostDTO>> fetchEMWPListCostDefaultByEMStoreEMStorePartEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id,EMWPListCostSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMWPListCost> domains = emwplistcostService.searchDefault(context) ;
        List<EMWPListCostDTO> list = emwplistcostMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMWPListCost-Default-all')")
	@ApiOperation(value = "searchDEFAULTByEMStoreEMStorePartEMItem", tags = {"EMWPListCost" } ,notes = "searchDEFAULTByEMStoreEMStorePartEMItem")
    @RequestMapping(method= RequestMethod.POST , value="/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emwplistcosts/searchdefault")
	public ResponseEntity<Page<EMWPListCostDTO>> searchEMWPListCostDefaultByEMStoreEMStorePartEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMWPListCostSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMWPListCost> domains = emwplistcostService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emwplistcostMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
    @PreAuthorize("hasPermission(#emwplistcost_id,'Update',{'Sql',this.emwplistcostMapping,#emwplistcostdto})")
    @ApiOperation(value = "UpdateByEMStoreEMStorePartEMItemEMWPList", tags = {"EMWPListCost" },  notes = "UpdateByEMStoreEMStorePartEMItemEMWPList")
	@RequestMapping(method = RequestMethod.PUT, value = "/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emwplists/{emwplist_id}/emwplistcosts/{emwplistcost_id}")
    @Transactional
    public ResponseEntity<EMWPListCostDTO> updateByEMStoreEMStorePartEMItemEMWPList(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emwplist_id") String emwplist_id, @PathVariable("emwplistcost_id") String emwplistcost_id, @RequestBody EMWPListCostDTO emwplistcostdto) {
        EMWPListCost domain = emwplistcostMapping.toDomain(emwplistcostdto);
        domain.setWplistid(emwplist_id);
        domain.setEmwplistcostid(emwplistcost_id);
		emwplistcostService.update(domain);
        EMWPListCostDTO dto = emwplistcostMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Update',{'Sql',this.emwplistcostMapping,#emwplistcostdtos})")
    @ApiOperation(value = "UpdateBatchByEMStoreEMStorePartEMItemEMWPList", tags = {"EMWPListCost" },  notes = "UpdateBatchByEMStoreEMStorePartEMItemEMWPList")
	@RequestMapping(method = RequestMethod.PUT, value = "/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emwplists/{emwplist_id}/emwplistcosts/batch")
    public ResponseEntity<Boolean> updateBatchByEMStoreEMStorePartEMItemEMWPList(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emwplist_id") String emwplist_id, @RequestBody List<EMWPListCostDTO> emwplistcostdtos) {
        List<EMWPListCost> domainlist=emwplistcostMapping.toDomain(emwplistcostdtos);
        for(EMWPListCost domain:domainlist){
            domain.setWplistid(emwplist_id);
        }
        emwplistcostService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission('','Create',{'Sql',this.emwplistcostMapping,#emwplistcostdto})")
    @ApiOperation(value = "CreateByEMStoreEMStorePartEMItemEMWPList", tags = {"EMWPListCost" },  notes = "CreateByEMStoreEMStorePartEMItemEMWPList")
	@RequestMapping(method = RequestMethod.POST, value = "/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emwplists/{emwplist_id}/emwplistcosts")
    @Transactional
    public ResponseEntity<EMWPListCostDTO> createByEMStoreEMStorePartEMItemEMWPList(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emwplist_id") String emwplist_id, @RequestBody EMWPListCostDTO emwplistcostdto) {
        EMWPListCost domain = emwplistcostMapping.toDomain(emwplistcostdto);
        domain.setWplistid(emwplist_id);
		emwplistcostService.create(domain);
        EMWPListCostDTO dto = emwplistcostMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Create',{'Sql',this.emwplistcostMapping,#emwplistcostdtos})")
    @ApiOperation(value = "createBatchByEMStoreEMStorePartEMItemEMWPList", tags = {"EMWPListCost" },  notes = "createBatchByEMStoreEMStorePartEMItemEMWPList")
	@RequestMapping(method = RequestMethod.POST, value = "/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emwplists/{emwplist_id}/emwplistcosts/batch")
    public ResponseEntity<Boolean> createBatchByEMStoreEMStorePartEMItemEMWPList(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emwplist_id") String emwplist_id, @RequestBody List<EMWPListCostDTO> emwplistcostdtos) {
        List<EMWPListCost> domainlist=emwplistcostMapping.toDomain(emwplistcostdtos);
        for(EMWPListCost domain:domainlist){
            domain.setWplistid(emwplist_id);
        }
        emwplistcostService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMWPListCost-GetDraft-all')")
    @ApiOperation(value = "GetDraftByEMStoreEMStorePartEMItemEMWPList", tags = {"EMWPListCost" },  notes = "GetDraftByEMStoreEMStorePartEMItemEMWPList")
    @RequestMapping(method = RequestMethod.GET, value = "/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emwplists/{emwplist_id}/emwplistcosts/getdraft")
    public ResponseEntity<EMWPListCostDTO> getDraftByEMStoreEMStorePartEMItemEMWPList(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emwplist_id") String emwplist_id) {
        EMWPListCost domain = new EMWPListCost();
        domain.setWplistid(emwplist_id);
        return ResponseEntity.status(HttpStatus.OK).body(emwplistcostMapping.toDto(emwplistcostService.getDraft(domain)));
    }

    @PreAuthorize("hasPermission(#emwplistcost_id,'Remove',{'Sql',this.emwplistcostMapping,this.permissionDTO})")
    @ApiOperation(value = "RemoveByEMStoreEMStorePartEMItemEMWPList", tags = {"EMWPListCost" },  notes = "RemoveByEMStoreEMStorePartEMItemEMWPList")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emwplists/{emwplist_id}/emwplistcosts/{emwplistcost_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByEMStoreEMStorePartEMItemEMWPList(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emwplist_id") String emwplist_id, @PathVariable("emwplistcost_id") String emwplistcost_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emwplistcostService.remove(emwplistcost_id));
    }

    @PreAuthorize("hasPermission('Remove',{'Sql',this.emwplistcostMapping,this.permissionDTO,#ids})")
    @ApiOperation(value = "RemoveBatchByEMStoreEMStorePartEMItemEMWPList", tags = {"EMWPListCost" },  notes = "RemoveBatchByEMStoreEMStorePartEMItemEMWPList")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emwplists/{emwplist_id}/emwplistcosts/batch")
    public ResponseEntity<Boolean> removeBatchByEMStoreEMStorePartEMItemEMWPList(@RequestBody List<String> ids) {
        emwplistcostService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(#emwplistcost_id,'Get',{'Sql',this.emwplistcostMapping,this.permissionDTO})")
    @ApiOperation(value = "GetByEMStoreEMStorePartEMItemEMWPList", tags = {"EMWPListCost" },  notes = "GetByEMStoreEMStorePartEMItemEMWPList")
	@RequestMapping(method = RequestMethod.GET, value = "/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emwplists/{emwplist_id}/emwplistcosts/{emwplistcost_id}")
    public ResponseEntity<EMWPListCostDTO> getByEMStoreEMStorePartEMItemEMWPList(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emwplist_id") String emwplist_id, @PathVariable("emwplistcost_id") String emwplistcost_id) {
        EMWPListCost domain = emwplistcostService.get(emwplistcost_id);
        EMWPListCostDTO dto = emwplistcostMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('','Save',{'Sql',this.emwplistcostMapping,#emwplistcostdto})")
    @ApiOperation(value = "SaveByEMStoreEMStorePartEMItemEMWPList", tags = {"EMWPListCost" },  notes = "SaveByEMStoreEMStorePartEMItemEMWPList")
	@RequestMapping(method = RequestMethod.POST, value = "/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emwplists/{emwplist_id}/emwplistcosts/save")
    public ResponseEntity<Boolean> saveByEMStoreEMStorePartEMItemEMWPList(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emwplist_id") String emwplist_id, @RequestBody EMWPListCostDTO emwplistcostdto) {
        EMWPListCost domain = emwplistcostMapping.toDomain(emwplistcostdto);
        domain.setWplistid(emwplist_id);
        return ResponseEntity.status(HttpStatus.OK).body(emwplistcostService.save(domain));
    }

    @PreAuthorize("hasPermission('Save',{'Sql',this.emwplistcostMapping,#emwplistcostdtos})")
    @ApiOperation(value = "SaveBatchByEMStoreEMStorePartEMItemEMWPList", tags = {"EMWPListCost" },  notes = "SaveBatchByEMStoreEMStorePartEMItemEMWPList")
	@RequestMapping(method = RequestMethod.POST, value = "/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emwplists/{emwplist_id}/emwplistcosts/savebatch")
    public ResponseEntity<Boolean> saveBatchByEMStoreEMStorePartEMItemEMWPList(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emwplist_id") String emwplist_id, @RequestBody List<EMWPListCostDTO> emwplistcostdtos) {
        List<EMWPListCost> domainlist=emwplistcostMapping.toDomain(emwplistcostdtos);
        for(EMWPListCost domain:domainlist){
             domain.setWplistid(emwplist_id);
        }
        emwplistcostService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMWPListCost-CheckKey-all')")
    @ApiOperation(value = "CheckKeyByEMStoreEMStorePartEMItemEMWPList", tags = {"EMWPListCost" },  notes = "CheckKeyByEMStoreEMStorePartEMItemEMWPList")
	@RequestMapping(method = RequestMethod.POST, value = "/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emwplists/{emwplist_id}/emwplistcosts/checkkey")
    public ResponseEntity<Boolean> checkKeyByEMStoreEMStorePartEMItemEMWPList(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emwplist_id") String emwplist_id, @RequestBody EMWPListCostDTO emwplistcostdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emwplistcostService.checkKey(emwplistcostMapping.toDomain(emwplistcostdto)));
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMWPListCost-Default-all')")
	@ApiOperation(value = "fetchDEFAULTByEMStoreEMStorePartEMItemEMWPList", tags = {"EMWPListCost" } ,notes = "fetchDEFAULTByEMStoreEMStorePartEMItemEMWPList")
    @RequestMapping(method= RequestMethod.GET , value="/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emwplists/{emwplist_id}/emwplistcosts/fetchdefault")
	public ResponseEntity<List<EMWPListCostDTO>> fetchEMWPListCostDefaultByEMStoreEMStorePartEMItemEMWPList(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emwplist_id") String emwplist_id,EMWPListCostSearchContext context) {
        context.setN_wplistid_eq(emwplist_id);
        Page<EMWPListCost> domains = emwplistcostService.searchDefault(context) ;
        List<EMWPListCostDTO> list = emwplistcostMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMWPListCost-Default-all')")
	@ApiOperation(value = "searchDEFAULTByEMStoreEMStorePartEMItemEMWPList", tags = {"EMWPListCost" } ,notes = "searchDEFAULTByEMStoreEMStorePartEMItemEMWPList")
    @RequestMapping(method= RequestMethod.POST , value="/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emwplists/{emwplist_id}/emwplistcosts/searchdefault")
	public ResponseEntity<Page<EMWPListCostDTO>> searchEMWPListCostDefaultByEMStoreEMStorePartEMItemEMWPList(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emwplist_id") String emwplist_id, @RequestBody EMWPListCostSearchContext context) {
        context.setN_wplistid_eq(emwplist_id);
        Page<EMWPListCost> domains = emwplistcostService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emwplistcostMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
}
