package cn.ibizlab.eam.webapi.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;
import javax.servlet.ServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import cn.ibizlab.eam.webapi.dto.*;
import cn.ibizlab.eam.webapi.mapping.*;
import cn.ibizlab.eam.core.eam_core.domain.EMPlanTempl;
import cn.ibizlab.eam.core.eam_core.service.IEMPlanTemplService;
import cn.ibizlab.eam.core.eam_core.filter.EMPlanTemplSearchContext;

@Slf4j
@Api(tags = {"EMPlanTempl" })
@RestController("WebApi-emplantempl")
@RequestMapping("")
public class EMPlanTemplResource {

    @Autowired
    private IEMPlanTemplService emplantemplService;

    @Autowired
    @Lazy
    public EMPlanTemplMapping emplantemplMapping;

    public EMPlanTemplDTO permissionDTO=new EMPlanTemplDTO();

    @PreAuthorize("hasPermission(#emplantempl_id,'Get',{'Sql',this.emplantemplMapping,this.permissionDTO})")
    @ApiOperation(value = "Get", tags = {"EMPlanTempl" },  notes = "Get")
	@RequestMapping(method = RequestMethod.GET, value = "/emplantempls/{emplantempl_id}")
    public ResponseEntity<EMPlanTemplDTO> get(@PathVariable("emplantempl_id") String emplantempl_id) {
        EMPlanTempl domain = emplantemplService.get(emplantempl_id);
        EMPlanTemplDTO dto = emplantemplMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMPlanTempl-GetDraft-all')")
    @ApiOperation(value = "GetDraft", tags = {"EMPlanTempl" },  notes = "GetDraft")
	@RequestMapping(method = RequestMethod.GET, value = "/emplantempls/getdraft")
    public ResponseEntity<EMPlanTemplDTO> getDraft() {
        return ResponseEntity.status(HttpStatus.OK).body(emplantemplMapping.toDto(emplantemplService.getDraft(new EMPlanTempl())));
    }

    @PreAuthorize("hasPermission('','Create',{'Sql',this.emplantemplMapping,#emplantempldto})")
    @ApiOperation(value = "Create", tags = {"EMPlanTempl" },  notes = "Create")
	@RequestMapping(method = RequestMethod.POST, value = "/emplantempls")
    @Transactional
    public ResponseEntity<EMPlanTemplDTO> create(@RequestBody EMPlanTemplDTO emplantempldto) {
        EMPlanTempl domain = emplantemplMapping.toDomain(emplantempldto);
		emplantemplService.create(domain);
        EMPlanTemplDTO dto = emplantemplMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Create',{'Sql',this.emplantemplMapping,#emplantempldtos})")
    @ApiOperation(value = "createBatch", tags = {"EMPlanTempl" },  notes = "createBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emplantempls/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<EMPlanTemplDTO> emplantempldtos) {
        emplantemplService.createBatch(emplantemplMapping.toDomain(emplantempldtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(#emplantempl_id,'Remove',{'Sql',this.emplantemplMapping,this.permissionDTO})")
    @ApiOperation(value = "Remove", tags = {"EMPlanTempl" },  notes = "Remove")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emplantempls/{emplantempl_id}")
    @Transactional
    public ResponseEntity<Boolean> remove(@PathVariable("emplantempl_id") String emplantempl_id) {
         return ResponseEntity.status(HttpStatus.OK).body(emplantemplService.remove(emplantempl_id));
    }

    @PreAuthorize("hasPermission('Remove',{'Sql',this.emplantemplMapping,this.permissionDTO,#ids})")
    @ApiOperation(value = "RemoveBatch", tags = {"EMPlanTempl" },  notes = "RemoveBatch")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emplantempls/batch")
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        emplantemplService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMPlanTempl-CheckKey-all')")
    @ApiOperation(value = "CheckKey", tags = {"EMPlanTempl" },  notes = "CheckKey")
	@RequestMapping(method = RequestMethod.POST, value = "/emplantempls/checkkey")
    public ResponseEntity<Boolean> checkKey(@RequestBody EMPlanTemplDTO emplantempldto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emplantemplService.checkKey(emplantemplMapping.toDomain(emplantempldto)));
    }

    @PreAuthorize("hasPermission(#emplantempl_id,'Update',{'Sql',this.emplantemplMapping,#emplantempldto})")
    @ApiOperation(value = "Update", tags = {"EMPlanTempl" },  notes = "Update")
	@RequestMapping(method = RequestMethod.PUT, value = "/emplantempls/{emplantempl_id}")
    @Transactional
    public ResponseEntity<EMPlanTemplDTO> update(@PathVariable("emplantempl_id") String emplantempl_id, @RequestBody EMPlanTemplDTO emplantempldto) {
		EMPlanTempl domain  = emplantemplMapping.toDomain(emplantempldto);
        domain .setEmplantemplid(emplantempl_id);
		emplantemplService.update(domain );
		EMPlanTemplDTO dto = emplantemplMapping.toDto(domain );
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Update',{'Sql',this.emplantemplMapping,#emplantempldtos})")
    @ApiOperation(value = "UpdateBatch", tags = {"EMPlanTempl" },  notes = "UpdateBatch")
	@RequestMapping(method = RequestMethod.PUT, value = "/emplantempls/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<EMPlanTemplDTO> emplantempldtos) {
        emplantemplService.updateBatch(emplantemplMapping.toDomain(emplantempldtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission('','Save',{'Sql',this.emplantemplMapping,#emplantempldto})")
    @ApiOperation(value = "Save", tags = {"EMPlanTempl" },  notes = "Save")
	@RequestMapping(method = RequestMethod.POST, value = "/emplantempls/save")
    public ResponseEntity<Boolean> save(@RequestBody EMPlanTemplDTO emplantempldto) {
        return ResponseEntity.status(HttpStatus.OK).body(emplantemplService.save(emplantemplMapping.toDomain(emplantempldto)));
    }

    @PreAuthorize("hasPermission('Save',{'Sql',this.emplantemplMapping,#emplantempldtos})")
    @ApiOperation(value = "SaveBatch", tags = {"EMPlanTempl" },  notes = "SaveBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emplantempls/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<EMPlanTemplDTO> emplantempldtos) {
        emplantemplService.saveBatch(emplantemplMapping.toDomain(emplantempldtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMPlanTempl-Default-all')")
	@ApiOperation(value = "fetchDEFAULT", tags = {"EMPlanTempl" } ,notes = "fetchDEFAULT")
    @RequestMapping(method= RequestMethod.GET , value="/emplantempls/fetchdefault")
	public ResponseEntity<List<EMPlanTemplDTO>> fetchDefault(EMPlanTemplSearchContext context) {
        Page<EMPlanTempl> domains = emplantemplService.searchDefault(context) ;
        List<EMPlanTemplDTO> list = emplantemplMapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMPlanTempl-Default-all')")
	@ApiOperation(value = "searchDEFAULT", tags = {"EMPlanTempl" } ,notes = "searchDEFAULT")
    @RequestMapping(method= RequestMethod.POST , value="/emplantempls/searchdefault")
	public ResponseEntity<Page<EMPlanTemplDTO>> searchDefault(@RequestBody EMPlanTemplSearchContext context) {
        Page<EMPlanTempl> domains = emplantemplService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emplantemplMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
    @PreAuthorize("hasPermission(#emplantempl_id,'Get',{'Sql',this.emplantemplMapping,this.permissionDTO})")
    @ApiOperation(value = "GetByEMACClass", tags = {"EMPlanTempl" },  notes = "GetByEMACClass")
	@RequestMapping(method = RequestMethod.GET, value = "/emacclasses/{emacclass_id}/emplantempls/{emplantempl_id}")
    public ResponseEntity<EMPlanTemplDTO> getByEMACClass(@PathVariable("emacclass_id") String emacclass_id, @PathVariable("emplantempl_id") String emplantempl_id) {
        EMPlanTempl domain = emplantemplService.get(emplantempl_id);
        EMPlanTemplDTO dto = emplantemplMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMPlanTempl-GetDraft-all')")
    @ApiOperation(value = "GetDraftByEMACClass", tags = {"EMPlanTempl" },  notes = "GetDraftByEMACClass")
    @RequestMapping(method = RequestMethod.GET, value = "/emacclasses/{emacclass_id}/emplantempls/getdraft")
    public ResponseEntity<EMPlanTemplDTO> getDraftByEMACClass(@PathVariable("emacclass_id") String emacclass_id) {
        EMPlanTempl domain = new EMPlanTempl();
        domain.setAcclassid(emacclass_id);
        return ResponseEntity.status(HttpStatus.OK).body(emplantemplMapping.toDto(emplantemplService.getDraft(domain)));
    }

    @PreAuthorize("hasPermission('','Create',{'Sql',this.emplantemplMapping,#emplantempldto})")
    @ApiOperation(value = "CreateByEMACClass", tags = {"EMPlanTempl" },  notes = "CreateByEMACClass")
	@RequestMapping(method = RequestMethod.POST, value = "/emacclasses/{emacclass_id}/emplantempls")
    @Transactional
    public ResponseEntity<EMPlanTemplDTO> createByEMACClass(@PathVariable("emacclass_id") String emacclass_id, @RequestBody EMPlanTemplDTO emplantempldto) {
        EMPlanTempl domain = emplantemplMapping.toDomain(emplantempldto);
        domain.setAcclassid(emacclass_id);
		emplantemplService.create(domain);
        EMPlanTemplDTO dto = emplantemplMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Create',{'Sql',this.emplantemplMapping,#emplantempldtos})")
    @ApiOperation(value = "createBatchByEMACClass", tags = {"EMPlanTempl" },  notes = "createBatchByEMACClass")
	@RequestMapping(method = RequestMethod.POST, value = "/emacclasses/{emacclass_id}/emplantempls/batch")
    public ResponseEntity<Boolean> createBatchByEMACClass(@PathVariable("emacclass_id") String emacclass_id, @RequestBody List<EMPlanTemplDTO> emplantempldtos) {
        List<EMPlanTempl> domainlist=emplantemplMapping.toDomain(emplantempldtos);
        for(EMPlanTempl domain:domainlist){
            domain.setAcclassid(emacclass_id);
        }
        emplantemplService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(#emplantempl_id,'Remove',{'Sql',this.emplantemplMapping,this.permissionDTO})")
    @ApiOperation(value = "RemoveByEMACClass", tags = {"EMPlanTempl" },  notes = "RemoveByEMACClass")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emacclasses/{emacclass_id}/emplantempls/{emplantempl_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByEMACClass(@PathVariable("emacclass_id") String emacclass_id, @PathVariable("emplantempl_id") String emplantempl_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emplantemplService.remove(emplantempl_id));
    }

    @PreAuthorize("hasPermission('Remove',{'Sql',this.emplantemplMapping,this.permissionDTO,#ids})")
    @ApiOperation(value = "RemoveBatchByEMACClass", tags = {"EMPlanTempl" },  notes = "RemoveBatchByEMACClass")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emacclasses/{emacclass_id}/emplantempls/batch")
    public ResponseEntity<Boolean> removeBatchByEMACClass(@RequestBody List<String> ids) {
        emplantemplService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMPlanTempl-CheckKey-all')")
    @ApiOperation(value = "CheckKeyByEMACClass", tags = {"EMPlanTempl" },  notes = "CheckKeyByEMACClass")
	@RequestMapping(method = RequestMethod.POST, value = "/emacclasses/{emacclass_id}/emplantempls/checkkey")
    public ResponseEntity<Boolean> checkKeyByEMACClass(@PathVariable("emacclass_id") String emacclass_id, @RequestBody EMPlanTemplDTO emplantempldto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emplantemplService.checkKey(emplantemplMapping.toDomain(emplantempldto)));
    }

    @PreAuthorize("hasPermission(#emplantempl_id,'Update',{'Sql',this.emplantemplMapping,#emplantempldto})")
    @ApiOperation(value = "UpdateByEMACClass", tags = {"EMPlanTempl" },  notes = "UpdateByEMACClass")
	@RequestMapping(method = RequestMethod.PUT, value = "/emacclasses/{emacclass_id}/emplantempls/{emplantempl_id}")
    @Transactional
    public ResponseEntity<EMPlanTemplDTO> updateByEMACClass(@PathVariable("emacclass_id") String emacclass_id, @PathVariable("emplantempl_id") String emplantempl_id, @RequestBody EMPlanTemplDTO emplantempldto) {
        EMPlanTempl domain = emplantemplMapping.toDomain(emplantempldto);
        domain.setAcclassid(emacclass_id);
        domain.setEmplantemplid(emplantempl_id);
		emplantemplService.update(domain);
        EMPlanTemplDTO dto = emplantemplMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Update',{'Sql',this.emplantemplMapping,#emplantempldtos})")
    @ApiOperation(value = "UpdateBatchByEMACClass", tags = {"EMPlanTempl" },  notes = "UpdateBatchByEMACClass")
	@RequestMapping(method = RequestMethod.PUT, value = "/emacclasses/{emacclass_id}/emplantempls/batch")
    public ResponseEntity<Boolean> updateBatchByEMACClass(@PathVariable("emacclass_id") String emacclass_id, @RequestBody List<EMPlanTemplDTO> emplantempldtos) {
        List<EMPlanTempl> domainlist=emplantemplMapping.toDomain(emplantempldtos);
        for(EMPlanTempl domain:domainlist){
            domain.setAcclassid(emacclass_id);
        }
        emplantemplService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission('','Save',{'Sql',this.emplantemplMapping,#emplantempldto})")
    @ApiOperation(value = "SaveByEMACClass", tags = {"EMPlanTempl" },  notes = "SaveByEMACClass")
	@RequestMapping(method = RequestMethod.POST, value = "/emacclasses/{emacclass_id}/emplantempls/save")
    public ResponseEntity<Boolean> saveByEMACClass(@PathVariable("emacclass_id") String emacclass_id, @RequestBody EMPlanTemplDTO emplantempldto) {
        EMPlanTempl domain = emplantemplMapping.toDomain(emplantempldto);
        domain.setAcclassid(emacclass_id);
        return ResponseEntity.status(HttpStatus.OK).body(emplantemplService.save(domain));
    }

    @PreAuthorize("hasPermission('Save',{'Sql',this.emplantemplMapping,#emplantempldtos})")
    @ApiOperation(value = "SaveBatchByEMACClass", tags = {"EMPlanTempl" },  notes = "SaveBatchByEMACClass")
	@RequestMapping(method = RequestMethod.POST, value = "/emacclasses/{emacclass_id}/emplantempls/savebatch")
    public ResponseEntity<Boolean> saveBatchByEMACClass(@PathVariable("emacclass_id") String emacclass_id, @RequestBody List<EMPlanTemplDTO> emplantempldtos) {
        List<EMPlanTempl> domainlist=emplantemplMapping.toDomain(emplantempldtos);
        for(EMPlanTempl domain:domainlist){
             domain.setAcclassid(emacclass_id);
        }
        emplantemplService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMPlanTempl-Default-all')")
	@ApiOperation(value = "fetchDEFAULTByEMACClass", tags = {"EMPlanTempl" } ,notes = "fetchDEFAULTByEMACClass")
    @RequestMapping(method= RequestMethod.GET , value="/emacclasses/{emacclass_id}/emplantempls/fetchdefault")
	public ResponseEntity<List<EMPlanTemplDTO>> fetchEMPlanTemplDefaultByEMACClass(@PathVariable("emacclass_id") String emacclass_id,EMPlanTemplSearchContext context) {
        context.setN_acclassid_eq(emacclass_id);
        Page<EMPlanTempl> domains = emplantemplService.searchDefault(context) ;
        List<EMPlanTemplDTO> list = emplantemplMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMPlanTempl-Default-all')")
	@ApiOperation(value = "searchDEFAULTByEMACClass", tags = {"EMPlanTempl" } ,notes = "searchDEFAULTByEMACClass")
    @RequestMapping(method= RequestMethod.POST , value="/emacclasses/{emacclass_id}/emplantempls/searchdefault")
	public ResponseEntity<Page<EMPlanTemplDTO>> searchEMPlanTemplDefaultByEMACClass(@PathVariable("emacclass_id") String emacclass_id, @RequestBody EMPlanTemplSearchContext context) {
        context.setN_acclassid_eq(emacclass_id);
        Page<EMPlanTempl> domains = emplantemplService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emplantemplMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
    @PreAuthorize("hasPermission(#emplantempl_id,'Get',{'Sql',this.emplantemplMapping,this.permissionDTO})")
    @ApiOperation(value = "GetByEMService", tags = {"EMPlanTempl" },  notes = "GetByEMService")
	@RequestMapping(method = RequestMethod.GET, value = "/emservices/{emservice_id}/emplantempls/{emplantempl_id}")
    public ResponseEntity<EMPlanTemplDTO> getByEMService(@PathVariable("emservice_id") String emservice_id, @PathVariable("emplantempl_id") String emplantempl_id) {
        EMPlanTempl domain = emplantemplService.get(emplantempl_id);
        EMPlanTemplDTO dto = emplantemplMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMPlanTempl-GetDraft-all')")
    @ApiOperation(value = "GetDraftByEMService", tags = {"EMPlanTempl" },  notes = "GetDraftByEMService")
    @RequestMapping(method = RequestMethod.GET, value = "/emservices/{emservice_id}/emplantempls/getdraft")
    public ResponseEntity<EMPlanTemplDTO> getDraftByEMService(@PathVariable("emservice_id") String emservice_id) {
        EMPlanTempl domain = new EMPlanTempl();
        domain.setRserviceid(emservice_id);
        return ResponseEntity.status(HttpStatus.OK).body(emplantemplMapping.toDto(emplantemplService.getDraft(domain)));
    }

    @PreAuthorize("hasPermission('','Create',{'Sql',this.emplantemplMapping,#emplantempldto})")
    @ApiOperation(value = "CreateByEMService", tags = {"EMPlanTempl" },  notes = "CreateByEMService")
	@RequestMapping(method = RequestMethod.POST, value = "/emservices/{emservice_id}/emplantempls")
    @Transactional
    public ResponseEntity<EMPlanTemplDTO> createByEMService(@PathVariable("emservice_id") String emservice_id, @RequestBody EMPlanTemplDTO emplantempldto) {
        EMPlanTempl domain = emplantemplMapping.toDomain(emplantempldto);
        domain.setRserviceid(emservice_id);
		emplantemplService.create(domain);
        EMPlanTemplDTO dto = emplantemplMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Create',{'Sql',this.emplantemplMapping,#emplantempldtos})")
    @ApiOperation(value = "createBatchByEMService", tags = {"EMPlanTempl" },  notes = "createBatchByEMService")
	@RequestMapping(method = RequestMethod.POST, value = "/emservices/{emservice_id}/emplantempls/batch")
    public ResponseEntity<Boolean> createBatchByEMService(@PathVariable("emservice_id") String emservice_id, @RequestBody List<EMPlanTemplDTO> emplantempldtos) {
        List<EMPlanTempl> domainlist=emplantemplMapping.toDomain(emplantempldtos);
        for(EMPlanTempl domain:domainlist){
            domain.setRserviceid(emservice_id);
        }
        emplantemplService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(#emplantempl_id,'Remove',{'Sql',this.emplantemplMapping,this.permissionDTO})")
    @ApiOperation(value = "RemoveByEMService", tags = {"EMPlanTempl" },  notes = "RemoveByEMService")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emservices/{emservice_id}/emplantempls/{emplantempl_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByEMService(@PathVariable("emservice_id") String emservice_id, @PathVariable("emplantempl_id") String emplantempl_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emplantemplService.remove(emplantempl_id));
    }

    @PreAuthorize("hasPermission('Remove',{'Sql',this.emplantemplMapping,this.permissionDTO,#ids})")
    @ApiOperation(value = "RemoveBatchByEMService", tags = {"EMPlanTempl" },  notes = "RemoveBatchByEMService")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emservices/{emservice_id}/emplantempls/batch")
    public ResponseEntity<Boolean> removeBatchByEMService(@RequestBody List<String> ids) {
        emplantemplService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMPlanTempl-CheckKey-all')")
    @ApiOperation(value = "CheckKeyByEMService", tags = {"EMPlanTempl" },  notes = "CheckKeyByEMService")
	@RequestMapping(method = RequestMethod.POST, value = "/emservices/{emservice_id}/emplantempls/checkkey")
    public ResponseEntity<Boolean> checkKeyByEMService(@PathVariable("emservice_id") String emservice_id, @RequestBody EMPlanTemplDTO emplantempldto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emplantemplService.checkKey(emplantemplMapping.toDomain(emplantempldto)));
    }

    @PreAuthorize("hasPermission(#emplantempl_id,'Update',{'Sql',this.emplantemplMapping,#emplantempldto})")
    @ApiOperation(value = "UpdateByEMService", tags = {"EMPlanTempl" },  notes = "UpdateByEMService")
	@RequestMapping(method = RequestMethod.PUT, value = "/emservices/{emservice_id}/emplantempls/{emplantempl_id}")
    @Transactional
    public ResponseEntity<EMPlanTemplDTO> updateByEMService(@PathVariable("emservice_id") String emservice_id, @PathVariable("emplantempl_id") String emplantempl_id, @RequestBody EMPlanTemplDTO emplantempldto) {
        EMPlanTempl domain = emplantemplMapping.toDomain(emplantempldto);
        domain.setRserviceid(emservice_id);
        domain.setEmplantemplid(emplantempl_id);
		emplantemplService.update(domain);
        EMPlanTemplDTO dto = emplantemplMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Update',{'Sql',this.emplantemplMapping,#emplantempldtos})")
    @ApiOperation(value = "UpdateBatchByEMService", tags = {"EMPlanTempl" },  notes = "UpdateBatchByEMService")
	@RequestMapping(method = RequestMethod.PUT, value = "/emservices/{emservice_id}/emplantempls/batch")
    public ResponseEntity<Boolean> updateBatchByEMService(@PathVariable("emservice_id") String emservice_id, @RequestBody List<EMPlanTemplDTO> emplantempldtos) {
        List<EMPlanTempl> domainlist=emplantemplMapping.toDomain(emplantempldtos);
        for(EMPlanTempl domain:domainlist){
            domain.setRserviceid(emservice_id);
        }
        emplantemplService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission('','Save',{'Sql',this.emplantemplMapping,#emplantempldto})")
    @ApiOperation(value = "SaveByEMService", tags = {"EMPlanTempl" },  notes = "SaveByEMService")
	@RequestMapping(method = RequestMethod.POST, value = "/emservices/{emservice_id}/emplantempls/save")
    public ResponseEntity<Boolean> saveByEMService(@PathVariable("emservice_id") String emservice_id, @RequestBody EMPlanTemplDTO emplantempldto) {
        EMPlanTempl domain = emplantemplMapping.toDomain(emplantempldto);
        domain.setRserviceid(emservice_id);
        return ResponseEntity.status(HttpStatus.OK).body(emplantemplService.save(domain));
    }

    @PreAuthorize("hasPermission('Save',{'Sql',this.emplantemplMapping,#emplantempldtos})")
    @ApiOperation(value = "SaveBatchByEMService", tags = {"EMPlanTempl" },  notes = "SaveBatchByEMService")
	@RequestMapping(method = RequestMethod.POST, value = "/emservices/{emservice_id}/emplantempls/savebatch")
    public ResponseEntity<Boolean> saveBatchByEMService(@PathVariable("emservice_id") String emservice_id, @RequestBody List<EMPlanTemplDTO> emplantempldtos) {
        List<EMPlanTempl> domainlist=emplantemplMapping.toDomain(emplantempldtos);
        for(EMPlanTempl domain:domainlist){
             domain.setRserviceid(emservice_id);
        }
        emplantemplService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMPlanTempl-Default-all')")
	@ApiOperation(value = "fetchDEFAULTByEMService", tags = {"EMPlanTempl" } ,notes = "fetchDEFAULTByEMService")
    @RequestMapping(method= RequestMethod.GET , value="/emservices/{emservice_id}/emplantempls/fetchdefault")
	public ResponseEntity<List<EMPlanTemplDTO>> fetchEMPlanTemplDefaultByEMService(@PathVariable("emservice_id") String emservice_id,EMPlanTemplSearchContext context) {
        context.setN_rserviceid_eq(emservice_id);
        Page<EMPlanTempl> domains = emplantemplService.searchDefault(context) ;
        List<EMPlanTemplDTO> list = emplantemplMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMPlanTempl-Default-all')")
	@ApiOperation(value = "searchDEFAULTByEMService", tags = {"EMPlanTempl" } ,notes = "searchDEFAULTByEMService")
    @RequestMapping(method= RequestMethod.POST , value="/emservices/{emservice_id}/emplantempls/searchdefault")
	public ResponseEntity<Page<EMPlanTemplDTO>> searchEMPlanTemplDefaultByEMService(@PathVariable("emservice_id") String emservice_id, @RequestBody EMPlanTemplSearchContext context) {
        context.setN_rserviceid_eq(emservice_id);
        Page<EMPlanTempl> domains = emplantemplService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emplantemplMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
    @PreAuthorize("hasPermission(#emplantempl_id,'Get',{'Sql',this.emplantemplMapping,this.permissionDTO})")
    @ApiOperation(value = "GetByPFDept", tags = {"EMPlanTempl" },  notes = "GetByPFDept")
	@RequestMapping(method = RequestMethod.GET, value = "/pfdepts/{pfdept_id}/emplantempls/{emplantempl_id}")
    public ResponseEntity<EMPlanTemplDTO> getByPFDept(@PathVariable("pfdept_id") String pfdept_id, @PathVariable("emplantempl_id") String emplantempl_id) {
        EMPlanTempl domain = emplantemplService.get(emplantempl_id);
        EMPlanTemplDTO dto = emplantemplMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMPlanTempl-GetDraft-all')")
    @ApiOperation(value = "GetDraftByPFDept", tags = {"EMPlanTempl" },  notes = "GetDraftByPFDept")
    @RequestMapping(method = RequestMethod.GET, value = "/pfdepts/{pfdept_id}/emplantempls/getdraft")
    public ResponseEntity<EMPlanTemplDTO> getDraftByPFDept(@PathVariable("pfdept_id") String pfdept_id) {
        EMPlanTempl domain = new EMPlanTempl();
        domain.setRdeptid(pfdept_id);
        return ResponseEntity.status(HttpStatus.OK).body(emplantemplMapping.toDto(emplantemplService.getDraft(domain)));
    }

    @PreAuthorize("hasPermission('','Create',{'Sql',this.emplantemplMapping,#emplantempldto})")
    @ApiOperation(value = "CreateByPFDept", tags = {"EMPlanTempl" },  notes = "CreateByPFDept")
	@RequestMapping(method = RequestMethod.POST, value = "/pfdepts/{pfdept_id}/emplantempls")
    @Transactional
    public ResponseEntity<EMPlanTemplDTO> createByPFDept(@PathVariable("pfdept_id") String pfdept_id, @RequestBody EMPlanTemplDTO emplantempldto) {
        EMPlanTempl domain = emplantemplMapping.toDomain(emplantempldto);
        domain.setRdeptid(pfdept_id);
		emplantemplService.create(domain);
        EMPlanTemplDTO dto = emplantemplMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Create',{'Sql',this.emplantemplMapping,#emplantempldtos})")
    @ApiOperation(value = "createBatchByPFDept", tags = {"EMPlanTempl" },  notes = "createBatchByPFDept")
	@RequestMapping(method = RequestMethod.POST, value = "/pfdepts/{pfdept_id}/emplantempls/batch")
    public ResponseEntity<Boolean> createBatchByPFDept(@PathVariable("pfdept_id") String pfdept_id, @RequestBody List<EMPlanTemplDTO> emplantempldtos) {
        List<EMPlanTempl> domainlist=emplantemplMapping.toDomain(emplantempldtos);
        for(EMPlanTempl domain:domainlist){
            domain.setRdeptid(pfdept_id);
        }
        emplantemplService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(#emplantempl_id,'Remove',{'Sql',this.emplantemplMapping,this.permissionDTO})")
    @ApiOperation(value = "RemoveByPFDept", tags = {"EMPlanTempl" },  notes = "RemoveByPFDept")
	@RequestMapping(method = RequestMethod.DELETE, value = "/pfdepts/{pfdept_id}/emplantempls/{emplantempl_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByPFDept(@PathVariable("pfdept_id") String pfdept_id, @PathVariable("emplantempl_id") String emplantempl_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emplantemplService.remove(emplantempl_id));
    }

    @PreAuthorize("hasPermission('Remove',{'Sql',this.emplantemplMapping,this.permissionDTO,#ids})")
    @ApiOperation(value = "RemoveBatchByPFDept", tags = {"EMPlanTempl" },  notes = "RemoveBatchByPFDept")
	@RequestMapping(method = RequestMethod.DELETE, value = "/pfdepts/{pfdept_id}/emplantempls/batch")
    public ResponseEntity<Boolean> removeBatchByPFDept(@RequestBody List<String> ids) {
        emplantemplService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMPlanTempl-CheckKey-all')")
    @ApiOperation(value = "CheckKeyByPFDept", tags = {"EMPlanTempl" },  notes = "CheckKeyByPFDept")
	@RequestMapping(method = RequestMethod.POST, value = "/pfdepts/{pfdept_id}/emplantempls/checkkey")
    public ResponseEntity<Boolean> checkKeyByPFDept(@PathVariable("pfdept_id") String pfdept_id, @RequestBody EMPlanTemplDTO emplantempldto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emplantemplService.checkKey(emplantemplMapping.toDomain(emplantempldto)));
    }

    @PreAuthorize("hasPermission(#emplantempl_id,'Update',{'Sql',this.emplantemplMapping,#emplantempldto})")
    @ApiOperation(value = "UpdateByPFDept", tags = {"EMPlanTempl" },  notes = "UpdateByPFDept")
	@RequestMapping(method = RequestMethod.PUT, value = "/pfdepts/{pfdept_id}/emplantempls/{emplantempl_id}")
    @Transactional
    public ResponseEntity<EMPlanTemplDTO> updateByPFDept(@PathVariable("pfdept_id") String pfdept_id, @PathVariable("emplantempl_id") String emplantempl_id, @RequestBody EMPlanTemplDTO emplantempldto) {
        EMPlanTempl domain = emplantemplMapping.toDomain(emplantempldto);
        domain.setRdeptid(pfdept_id);
        domain.setEmplantemplid(emplantempl_id);
		emplantemplService.update(domain);
        EMPlanTemplDTO dto = emplantemplMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Update',{'Sql',this.emplantemplMapping,#emplantempldtos})")
    @ApiOperation(value = "UpdateBatchByPFDept", tags = {"EMPlanTempl" },  notes = "UpdateBatchByPFDept")
	@RequestMapping(method = RequestMethod.PUT, value = "/pfdepts/{pfdept_id}/emplantempls/batch")
    public ResponseEntity<Boolean> updateBatchByPFDept(@PathVariable("pfdept_id") String pfdept_id, @RequestBody List<EMPlanTemplDTO> emplantempldtos) {
        List<EMPlanTempl> domainlist=emplantemplMapping.toDomain(emplantempldtos);
        for(EMPlanTempl domain:domainlist){
            domain.setRdeptid(pfdept_id);
        }
        emplantemplService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission('','Save',{'Sql',this.emplantemplMapping,#emplantempldto})")
    @ApiOperation(value = "SaveByPFDept", tags = {"EMPlanTempl" },  notes = "SaveByPFDept")
	@RequestMapping(method = RequestMethod.POST, value = "/pfdepts/{pfdept_id}/emplantempls/save")
    public ResponseEntity<Boolean> saveByPFDept(@PathVariable("pfdept_id") String pfdept_id, @RequestBody EMPlanTemplDTO emplantempldto) {
        EMPlanTempl domain = emplantemplMapping.toDomain(emplantempldto);
        domain.setRdeptid(pfdept_id);
        return ResponseEntity.status(HttpStatus.OK).body(emplantemplService.save(domain));
    }

    @PreAuthorize("hasPermission('Save',{'Sql',this.emplantemplMapping,#emplantempldtos})")
    @ApiOperation(value = "SaveBatchByPFDept", tags = {"EMPlanTempl" },  notes = "SaveBatchByPFDept")
	@RequestMapping(method = RequestMethod.POST, value = "/pfdepts/{pfdept_id}/emplantempls/savebatch")
    public ResponseEntity<Boolean> saveBatchByPFDept(@PathVariable("pfdept_id") String pfdept_id, @RequestBody List<EMPlanTemplDTO> emplantempldtos) {
        List<EMPlanTempl> domainlist=emplantemplMapping.toDomain(emplantempldtos);
        for(EMPlanTempl domain:domainlist){
             domain.setRdeptid(pfdept_id);
        }
        emplantemplService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMPlanTempl-Default-all')")
	@ApiOperation(value = "fetchDEFAULTByPFDept", tags = {"EMPlanTempl" } ,notes = "fetchDEFAULTByPFDept")
    @RequestMapping(method= RequestMethod.GET , value="/pfdepts/{pfdept_id}/emplantempls/fetchdefault")
	public ResponseEntity<List<EMPlanTemplDTO>> fetchEMPlanTemplDefaultByPFDept(@PathVariable("pfdept_id") String pfdept_id,EMPlanTemplSearchContext context) {
        context.setN_rdeptid_eq(pfdept_id);
        Page<EMPlanTempl> domains = emplantemplService.searchDefault(context) ;
        List<EMPlanTemplDTO> list = emplantemplMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMPlanTempl-Default-all')")
	@ApiOperation(value = "searchDEFAULTByPFDept", tags = {"EMPlanTempl" } ,notes = "searchDEFAULTByPFDept")
    @RequestMapping(method= RequestMethod.POST , value="/pfdepts/{pfdept_id}/emplantempls/searchdefault")
	public ResponseEntity<Page<EMPlanTemplDTO>> searchEMPlanTemplDefaultByPFDept(@PathVariable("pfdept_id") String pfdept_id, @RequestBody EMPlanTemplSearchContext context) {
        context.setN_rdeptid_eq(pfdept_id);
        Page<EMPlanTempl> domains = emplantemplService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emplantemplMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
    @PreAuthorize("hasPermission(#emplantempl_id,'Get',{'Sql',this.emplantemplMapping,this.permissionDTO})")
    @ApiOperation(value = "GetByPFEmp", tags = {"EMPlanTempl" },  notes = "GetByPFEmp")
	@RequestMapping(method = RequestMethod.GET, value = "/pfemps/{pfemp_id}/emplantempls/{emplantempl_id}")
    public ResponseEntity<EMPlanTemplDTO> getByPFEmp(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emplantempl_id") String emplantempl_id) {
        EMPlanTempl domain = emplantemplService.get(emplantempl_id);
        EMPlanTemplDTO dto = emplantemplMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMPlanTempl-GetDraft-all')")
    @ApiOperation(value = "GetDraftByPFEmp", tags = {"EMPlanTempl" },  notes = "GetDraftByPFEmp")
    @RequestMapping(method = RequestMethod.GET, value = "/pfemps/{pfemp_id}/emplantempls/getdraft")
    public ResponseEntity<EMPlanTemplDTO> getDraftByPFEmp(@PathVariable("pfemp_id") String pfemp_id) {
        EMPlanTempl domain = new EMPlanTempl();
        domain.setMpersonid(pfemp_id);
        return ResponseEntity.status(HttpStatus.OK).body(emplantemplMapping.toDto(emplantemplService.getDraft(domain)));
    }

    @PreAuthorize("hasPermission('','Create',{'Sql',this.emplantemplMapping,#emplantempldto})")
    @ApiOperation(value = "CreateByPFEmp", tags = {"EMPlanTempl" },  notes = "CreateByPFEmp")
	@RequestMapping(method = RequestMethod.POST, value = "/pfemps/{pfemp_id}/emplantempls")
    @Transactional
    public ResponseEntity<EMPlanTemplDTO> createByPFEmp(@PathVariable("pfemp_id") String pfemp_id, @RequestBody EMPlanTemplDTO emplantempldto) {
        EMPlanTempl domain = emplantemplMapping.toDomain(emplantempldto);
        domain.setMpersonid(pfemp_id);
		emplantemplService.create(domain);
        EMPlanTemplDTO dto = emplantemplMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Create',{'Sql',this.emplantemplMapping,#emplantempldtos})")
    @ApiOperation(value = "createBatchByPFEmp", tags = {"EMPlanTempl" },  notes = "createBatchByPFEmp")
	@RequestMapping(method = RequestMethod.POST, value = "/pfemps/{pfemp_id}/emplantempls/batch")
    public ResponseEntity<Boolean> createBatchByPFEmp(@PathVariable("pfemp_id") String pfemp_id, @RequestBody List<EMPlanTemplDTO> emplantempldtos) {
        List<EMPlanTempl> domainlist=emplantemplMapping.toDomain(emplantempldtos);
        for(EMPlanTempl domain:domainlist){
            domain.setMpersonid(pfemp_id);
        }
        emplantemplService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(#emplantempl_id,'Remove',{'Sql',this.emplantemplMapping,this.permissionDTO})")
    @ApiOperation(value = "RemoveByPFEmp", tags = {"EMPlanTempl" },  notes = "RemoveByPFEmp")
	@RequestMapping(method = RequestMethod.DELETE, value = "/pfemps/{pfemp_id}/emplantempls/{emplantempl_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByPFEmp(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emplantempl_id") String emplantempl_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emplantemplService.remove(emplantempl_id));
    }

    @PreAuthorize("hasPermission('Remove',{'Sql',this.emplantemplMapping,this.permissionDTO,#ids})")
    @ApiOperation(value = "RemoveBatchByPFEmp", tags = {"EMPlanTempl" },  notes = "RemoveBatchByPFEmp")
	@RequestMapping(method = RequestMethod.DELETE, value = "/pfemps/{pfemp_id}/emplantempls/batch")
    public ResponseEntity<Boolean> removeBatchByPFEmp(@RequestBody List<String> ids) {
        emplantemplService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMPlanTempl-CheckKey-all')")
    @ApiOperation(value = "CheckKeyByPFEmp", tags = {"EMPlanTempl" },  notes = "CheckKeyByPFEmp")
	@RequestMapping(method = RequestMethod.POST, value = "/pfemps/{pfemp_id}/emplantempls/checkkey")
    public ResponseEntity<Boolean> checkKeyByPFEmp(@PathVariable("pfemp_id") String pfemp_id, @RequestBody EMPlanTemplDTO emplantempldto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emplantemplService.checkKey(emplantemplMapping.toDomain(emplantempldto)));
    }

    @PreAuthorize("hasPermission(#emplantempl_id,'Update',{'Sql',this.emplantemplMapping,#emplantempldto})")
    @ApiOperation(value = "UpdateByPFEmp", tags = {"EMPlanTempl" },  notes = "UpdateByPFEmp")
	@RequestMapping(method = RequestMethod.PUT, value = "/pfemps/{pfemp_id}/emplantempls/{emplantempl_id}")
    @Transactional
    public ResponseEntity<EMPlanTemplDTO> updateByPFEmp(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emplantempl_id") String emplantempl_id, @RequestBody EMPlanTemplDTO emplantempldto) {
        EMPlanTempl domain = emplantemplMapping.toDomain(emplantempldto);
        domain.setMpersonid(pfemp_id);
        domain.setEmplantemplid(emplantempl_id);
		emplantemplService.update(domain);
        EMPlanTemplDTO dto = emplantemplMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Update',{'Sql',this.emplantemplMapping,#emplantempldtos})")
    @ApiOperation(value = "UpdateBatchByPFEmp", tags = {"EMPlanTempl" },  notes = "UpdateBatchByPFEmp")
	@RequestMapping(method = RequestMethod.PUT, value = "/pfemps/{pfemp_id}/emplantempls/batch")
    public ResponseEntity<Boolean> updateBatchByPFEmp(@PathVariable("pfemp_id") String pfemp_id, @RequestBody List<EMPlanTemplDTO> emplantempldtos) {
        List<EMPlanTempl> domainlist=emplantemplMapping.toDomain(emplantempldtos);
        for(EMPlanTempl domain:domainlist){
            domain.setMpersonid(pfemp_id);
        }
        emplantemplService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission('','Save',{'Sql',this.emplantemplMapping,#emplantempldto})")
    @ApiOperation(value = "SaveByPFEmp", tags = {"EMPlanTempl" },  notes = "SaveByPFEmp")
	@RequestMapping(method = RequestMethod.POST, value = "/pfemps/{pfemp_id}/emplantempls/save")
    public ResponseEntity<Boolean> saveByPFEmp(@PathVariable("pfemp_id") String pfemp_id, @RequestBody EMPlanTemplDTO emplantempldto) {
        EMPlanTempl domain = emplantemplMapping.toDomain(emplantempldto);
        domain.setMpersonid(pfemp_id);
        return ResponseEntity.status(HttpStatus.OK).body(emplantemplService.save(domain));
    }

    @PreAuthorize("hasPermission('Save',{'Sql',this.emplantemplMapping,#emplantempldtos})")
    @ApiOperation(value = "SaveBatchByPFEmp", tags = {"EMPlanTempl" },  notes = "SaveBatchByPFEmp")
	@RequestMapping(method = RequestMethod.POST, value = "/pfemps/{pfemp_id}/emplantempls/savebatch")
    public ResponseEntity<Boolean> saveBatchByPFEmp(@PathVariable("pfemp_id") String pfemp_id, @RequestBody List<EMPlanTemplDTO> emplantempldtos) {
        List<EMPlanTempl> domainlist=emplantemplMapping.toDomain(emplantempldtos);
        for(EMPlanTempl domain:domainlist){
             domain.setMpersonid(pfemp_id);
        }
        emplantemplService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMPlanTempl-Default-all')")
	@ApiOperation(value = "fetchDEFAULTByPFEmp", tags = {"EMPlanTempl" } ,notes = "fetchDEFAULTByPFEmp")
    @RequestMapping(method= RequestMethod.GET , value="/pfemps/{pfemp_id}/emplantempls/fetchdefault")
	public ResponseEntity<List<EMPlanTemplDTO>> fetchEMPlanTemplDefaultByPFEmp(@PathVariable("pfemp_id") String pfemp_id,EMPlanTemplSearchContext context) {
        context.setN_mpersonid_eq(pfemp_id);
        Page<EMPlanTempl> domains = emplantemplService.searchDefault(context) ;
        List<EMPlanTemplDTO> list = emplantemplMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMPlanTempl-Default-all')")
	@ApiOperation(value = "searchDEFAULTByPFEmp", tags = {"EMPlanTempl" } ,notes = "searchDEFAULTByPFEmp")
    @RequestMapping(method= RequestMethod.POST , value="/pfemps/{pfemp_id}/emplantempls/searchdefault")
	public ResponseEntity<Page<EMPlanTemplDTO>> searchEMPlanTemplDefaultByPFEmp(@PathVariable("pfemp_id") String pfemp_id, @RequestBody EMPlanTemplSearchContext context) {
        context.setN_mpersonid_eq(pfemp_id);
        Page<EMPlanTempl> domains = emplantemplService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emplantemplMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
    @PreAuthorize("hasPermission(#emplantempl_id,'Get',{'Sql',this.emplantemplMapping,this.permissionDTO})")
    @ApiOperation(value = "GetByPFTeam", tags = {"EMPlanTempl" },  notes = "GetByPFTeam")
	@RequestMapping(method = RequestMethod.GET, value = "/pfteams/{pfteam_id}/emplantempls/{emplantempl_id}")
    public ResponseEntity<EMPlanTemplDTO> getByPFTeam(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emplantempl_id") String emplantempl_id) {
        EMPlanTempl domain = emplantemplService.get(emplantempl_id);
        EMPlanTemplDTO dto = emplantemplMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMPlanTempl-GetDraft-all')")
    @ApiOperation(value = "GetDraftByPFTeam", tags = {"EMPlanTempl" },  notes = "GetDraftByPFTeam")
    @RequestMapping(method = RequestMethod.GET, value = "/pfteams/{pfteam_id}/emplantempls/getdraft")
    public ResponseEntity<EMPlanTemplDTO> getDraftByPFTeam(@PathVariable("pfteam_id") String pfteam_id) {
        EMPlanTempl domain = new EMPlanTempl();
        domain.setRteamid(pfteam_id);
        return ResponseEntity.status(HttpStatus.OK).body(emplantemplMapping.toDto(emplantemplService.getDraft(domain)));
    }

    @PreAuthorize("hasPermission('','Create',{'Sql',this.emplantemplMapping,#emplantempldto})")
    @ApiOperation(value = "CreateByPFTeam", tags = {"EMPlanTempl" },  notes = "CreateByPFTeam")
	@RequestMapping(method = RequestMethod.POST, value = "/pfteams/{pfteam_id}/emplantempls")
    @Transactional
    public ResponseEntity<EMPlanTemplDTO> createByPFTeam(@PathVariable("pfteam_id") String pfteam_id, @RequestBody EMPlanTemplDTO emplantempldto) {
        EMPlanTempl domain = emplantemplMapping.toDomain(emplantempldto);
        domain.setRteamid(pfteam_id);
		emplantemplService.create(domain);
        EMPlanTemplDTO dto = emplantemplMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Create',{'Sql',this.emplantemplMapping,#emplantempldtos})")
    @ApiOperation(value = "createBatchByPFTeam", tags = {"EMPlanTempl" },  notes = "createBatchByPFTeam")
	@RequestMapping(method = RequestMethod.POST, value = "/pfteams/{pfteam_id}/emplantempls/batch")
    public ResponseEntity<Boolean> createBatchByPFTeam(@PathVariable("pfteam_id") String pfteam_id, @RequestBody List<EMPlanTemplDTO> emplantempldtos) {
        List<EMPlanTempl> domainlist=emplantemplMapping.toDomain(emplantempldtos);
        for(EMPlanTempl domain:domainlist){
            domain.setRteamid(pfteam_id);
        }
        emplantemplService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(#emplantempl_id,'Remove',{'Sql',this.emplantemplMapping,this.permissionDTO})")
    @ApiOperation(value = "RemoveByPFTeam", tags = {"EMPlanTempl" },  notes = "RemoveByPFTeam")
	@RequestMapping(method = RequestMethod.DELETE, value = "/pfteams/{pfteam_id}/emplantempls/{emplantempl_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByPFTeam(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emplantempl_id") String emplantempl_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emplantemplService.remove(emplantempl_id));
    }

    @PreAuthorize("hasPermission('Remove',{'Sql',this.emplantemplMapping,this.permissionDTO,#ids})")
    @ApiOperation(value = "RemoveBatchByPFTeam", tags = {"EMPlanTempl" },  notes = "RemoveBatchByPFTeam")
	@RequestMapping(method = RequestMethod.DELETE, value = "/pfteams/{pfteam_id}/emplantempls/batch")
    public ResponseEntity<Boolean> removeBatchByPFTeam(@RequestBody List<String> ids) {
        emplantemplService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMPlanTempl-CheckKey-all')")
    @ApiOperation(value = "CheckKeyByPFTeam", tags = {"EMPlanTempl" },  notes = "CheckKeyByPFTeam")
	@RequestMapping(method = RequestMethod.POST, value = "/pfteams/{pfteam_id}/emplantempls/checkkey")
    public ResponseEntity<Boolean> checkKeyByPFTeam(@PathVariable("pfteam_id") String pfteam_id, @RequestBody EMPlanTemplDTO emplantempldto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emplantemplService.checkKey(emplantemplMapping.toDomain(emplantempldto)));
    }

    @PreAuthorize("hasPermission(#emplantempl_id,'Update',{'Sql',this.emplantemplMapping,#emplantempldto})")
    @ApiOperation(value = "UpdateByPFTeam", tags = {"EMPlanTempl" },  notes = "UpdateByPFTeam")
	@RequestMapping(method = RequestMethod.PUT, value = "/pfteams/{pfteam_id}/emplantempls/{emplantempl_id}")
    @Transactional
    public ResponseEntity<EMPlanTemplDTO> updateByPFTeam(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emplantempl_id") String emplantempl_id, @RequestBody EMPlanTemplDTO emplantempldto) {
        EMPlanTempl domain = emplantemplMapping.toDomain(emplantempldto);
        domain.setRteamid(pfteam_id);
        domain.setEmplantemplid(emplantempl_id);
		emplantemplService.update(domain);
        EMPlanTemplDTO dto = emplantemplMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Update',{'Sql',this.emplantemplMapping,#emplantempldtos})")
    @ApiOperation(value = "UpdateBatchByPFTeam", tags = {"EMPlanTempl" },  notes = "UpdateBatchByPFTeam")
	@RequestMapping(method = RequestMethod.PUT, value = "/pfteams/{pfteam_id}/emplantempls/batch")
    public ResponseEntity<Boolean> updateBatchByPFTeam(@PathVariable("pfteam_id") String pfteam_id, @RequestBody List<EMPlanTemplDTO> emplantempldtos) {
        List<EMPlanTempl> domainlist=emplantemplMapping.toDomain(emplantempldtos);
        for(EMPlanTempl domain:domainlist){
            domain.setRteamid(pfteam_id);
        }
        emplantemplService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission('','Save',{'Sql',this.emplantemplMapping,#emplantempldto})")
    @ApiOperation(value = "SaveByPFTeam", tags = {"EMPlanTempl" },  notes = "SaveByPFTeam")
	@RequestMapping(method = RequestMethod.POST, value = "/pfteams/{pfteam_id}/emplantempls/save")
    public ResponseEntity<Boolean> saveByPFTeam(@PathVariable("pfteam_id") String pfteam_id, @RequestBody EMPlanTemplDTO emplantempldto) {
        EMPlanTempl domain = emplantemplMapping.toDomain(emplantempldto);
        domain.setRteamid(pfteam_id);
        return ResponseEntity.status(HttpStatus.OK).body(emplantemplService.save(domain));
    }

    @PreAuthorize("hasPermission('Save',{'Sql',this.emplantemplMapping,#emplantempldtos})")
    @ApiOperation(value = "SaveBatchByPFTeam", tags = {"EMPlanTempl" },  notes = "SaveBatchByPFTeam")
	@RequestMapping(method = RequestMethod.POST, value = "/pfteams/{pfteam_id}/emplantempls/savebatch")
    public ResponseEntity<Boolean> saveBatchByPFTeam(@PathVariable("pfteam_id") String pfteam_id, @RequestBody List<EMPlanTemplDTO> emplantempldtos) {
        List<EMPlanTempl> domainlist=emplantemplMapping.toDomain(emplantempldtos);
        for(EMPlanTempl domain:domainlist){
             domain.setRteamid(pfteam_id);
        }
        emplantemplService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMPlanTempl-Default-all')")
	@ApiOperation(value = "fetchDEFAULTByPFTeam", tags = {"EMPlanTempl" } ,notes = "fetchDEFAULTByPFTeam")
    @RequestMapping(method= RequestMethod.GET , value="/pfteams/{pfteam_id}/emplantempls/fetchdefault")
	public ResponseEntity<List<EMPlanTemplDTO>> fetchEMPlanTemplDefaultByPFTeam(@PathVariable("pfteam_id") String pfteam_id,EMPlanTemplSearchContext context) {
        context.setN_rteamid_eq(pfteam_id);
        Page<EMPlanTempl> domains = emplantemplService.searchDefault(context) ;
        List<EMPlanTemplDTO> list = emplantemplMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMPlanTempl-Default-all')")
	@ApiOperation(value = "searchDEFAULTByPFTeam", tags = {"EMPlanTempl" } ,notes = "searchDEFAULTByPFTeam")
    @RequestMapping(method= RequestMethod.POST , value="/pfteams/{pfteam_id}/emplantempls/searchdefault")
	public ResponseEntity<Page<EMPlanTemplDTO>> searchEMPlanTemplDefaultByPFTeam(@PathVariable("pfteam_id") String pfteam_id, @RequestBody EMPlanTemplSearchContext context) {
        context.setN_rteamid_eq(pfteam_id);
        Page<EMPlanTempl> domains = emplantemplService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emplantemplMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
}
