package cn.ibizlab.eam.webapi.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;
import javax.servlet.ServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import cn.ibizlab.eam.webapi.dto.*;
import cn.ibizlab.eam.webapi.mapping.*;
import cn.ibizlab.eam.core.eam_core.domain.EMOutputRct;
import cn.ibizlab.eam.core.eam_core.service.IEMOutputRctService;
import cn.ibizlab.eam.core.eam_core.filter.EMOutputRctSearchContext;

@Slf4j
@Api(tags = {"EMOutputRct" })
@RestController("WebApi-emoutputrct")
@RequestMapping("")
public class EMOutputRctResource {

    @Autowired
    private IEMOutputRctService emoutputrctService;

    @Autowired
    @Lazy
    public EMOutputRctMapping emoutputrctMapping;

    public EMOutputRctDTO permissionDTO=new EMOutputRctDTO();

    @PreAuthorize("hasPermission(#emoutputrct_id,'Get',{'Sql',this.emoutputrctMapping,this.permissionDTO})")
    @ApiOperation(value = "Get", tags = {"EMOutputRct" },  notes = "Get")
	@RequestMapping(method = RequestMethod.GET, value = "/emoutputrcts/{emoutputrct_id}")
    public ResponseEntity<EMOutputRctDTO> get(@PathVariable("emoutputrct_id") String emoutputrct_id) {
        EMOutputRct domain = emoutputrctService.get(emoutputrct_id);
        EMOutputRctDTO dto = emoutputrctMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('','Create',{'Sql',this.emoutputrctMapping,#emoutputrctdto})")
    @ApiOperation(value = "Create", tags = {"EMOutputRct" },  notes = "Create")
	@RequestMapping(method = RequestMethod.POST, value = "/emoutputrcts")
    @Transactional
    public ResponseEntity<EMOutputRctDTO> create(@RequestBody EMOutputRctDTO emoutputrctdto) {
        EMOutputRct domain = emoutputrctMapping.toDomain(emoutputrctdto);
		emoutputrctService.create(domain);
        EMOutputRctDTO dto = emoutputrctMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Create',{'Sql',this.emoutputrctMapping,#emoutputrctdtos})")
    @ApiOperation(value = "createBatch", tags = {"EMOutputRct" },  notes = "createBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emoutputrcts/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<EMOutputRctDTO> emoutputrctdtos) {
        emoutputrctService.createBatch(emoutputrctMapping.toDomain(emoutputrctdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission('','Save',{'Sql',this.emoutputrctMapping,#emoutputrctdto})")
    @ApiOperation(value = "Save", tags = {"EMOutputRct" },  notes = "Save")
	@RequestMapping(method = RequestMethod.POST, value = "/emoutputrcts/save")
    public ResponseEntity<Boolean> save(@RequestBody EMOutputRctDTO emoutputrctdto) {
        return ResponseEntity.status(HttpStatus.OK).body(emoutputrctService.save(emoutputrctMapping.toDomain(emoutputrctdto)));
    }

    @PreAuthorize("hasPermission('Save',{'Sql',this.emoutputrctMapping,#emoutputrctdtos})")
    @ApiOperation(value = "SaveBatch", tags = {"EMOutputRct" },  notes = "SaveBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emoutputrcts/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<EMOutputRctDTO> emoutputrctdtos) {
        emoutputrctService.saveBatch(emoutputrctMapping.toDomain(emoutputrctdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMOutputRct-GetDraft-all')")
    @ApiOperation(value = "GetDraft", tags = {"EMOutputRct" },  notes = "GetDraft")
	@RequestMapping(method = RequestMethod.GET, value = "/emoutputrcts/getdraft")
    public ResponseEntity<EMOutputRctDTO> getDraft() {
        return ResponseEntity.status(HttpStatus.OK).body(emoutputrctMapping.toDto(emoutputrctService.getDraft(new EMOutputRct())));
    }

    @PreAuthorize("hasPermission(#emoutputrct_id,'Update',{'Sql',this.emoutputrctMapping,#emoutputrctdto})")
    @ApiOperation(value = "Update", tags = {"EMOutputRct" },  notes = "Update")
	@RequestMapping(method = RequestMethod.PUT, value = "/emoutputrcts/{emoutputrct_id}")
    @Transactional
    public ResponseEntity<EMOutputRctDTO> update(@PathVariable("emoutputrct_id") String emoutputrct_id, @RequestBody EMOutputRctDTO emoutputrctdto) {
		EMOutputRct domain  = emoutputrctMapping.toDomain(emoutputrctdto);
        domain .setEmoutputrctid(emoutputrct_id);
		emoutputrctService.update(domain );
		EMOutputRctDTO dto = emoutputrctMapping.toDto(domain );
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Update',{'Sql',this.emoutputrctMapping,#emoutputrctdtos})")
    @ApiOperation(value = "UpdateBatch", tags = {"EMOutputRct" },  notes = "UpdateBatch")
	@RequestMapping(method = RequestMethod.PUT, value = "/emoutputrcts/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<EMOutputRctDTO> emoutputrctdtos) {
        emoutputrctService.updateBatch(emoutputrctMapping.toDomain(emoutputrctdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(#emoutputrct_id,'Remove',{'Sql',this.emoutputrctMapping,this.permissionDTO})")
    @ApiOperation(value = "Remove", tags = {"EMOutputRct" },  notes = "Remove")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emoutputrcts/{emoutputrct_id}")
    @Transactional
    public ResponseEntity<Boolean> remove(@PathVariable("emoutputrct_id") String emoutputrct_id) {
         return ResponseEntity.status(HttpStatus.OK).body(emoutputrctService.remove(emoutputrct_id));
    }

    @PreAuthorize("hasPermission('Remove',{'Sql',this.emoutputrctMapping,this.permissionDTO,#ids})")
    @ApiOperation(value = "RemoveBatch", tags = {"EMOutputRct" },  notes = "RemoveBatch")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emoutputrcts/batch")
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        emoutputrctService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMOutputRct-CheckKey-all')")
    @ApiOperation(value = "CheckKey", tags = {"EMOutputRct" },  notes = "CheckKey")
	@RequestMapping(method = RequestMethod.POST, value = "/emoutputrcts/checkkey")
    public ResponseEntity<Boolean> checkKey(@RequestBody EMOutputRctDTO emoutputrctdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emoutputrctService.checkKey(emoutputrctMapping.toDomain(emoutputrctdto)));
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMOutputRct-Default-all')")
	@ApiOperation(value = "fetchDEFAULT", tags = {"EMOutputRct" } ,notes = "fetchDEFAULT")
    @RequestMapping(method= RequestMethod.GET , value="/emoutputrcts/fetchdefault")
	public ResponseEntity<List<EMOutputRctDTO>> fetchDefault(EMOutputRctSearchContext context) {
        Page<EMOutputRct> domains = emoutputrctService.searchDefault(context) ;
        List<EMOutputRctDTO> list = emoutputrctMapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMOutputRct-Default-all')")
	@ApiOperation(value = "searchDEFAULT", tags = {"EMOutputRct" } ,notes = "searchDEFAULT")
    @RequestMapping(method= RequestMethod.POST , value="/emoutputrcts/searchdefault")
	public ResponseEntity<Page<EMOutputRctDTO>> searchDefault(@RequestBody EMOutputRctSearchContext context) {
        Page<EMOutputRct> domains = emoutputrctService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emoutputrctMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
    @PreAuthorize("hasPermission(#emoutputrct_id,'Get',{'Sql',this.emoutputrctMapping,this.permissionDTO})")
    @ApiOperation(value = "GetByEMOutput", tags = {"EMOutputRct" },  notes = "GetByEMOutput")
	@RequestMapping(method = RequestMethod.GET, value = "/emoutputs/{emoutput_id}/emoutputrcts/{emoutputrct_id}")
    public ResponseEntity<EMOutputRctDTO> getByEMOutput(@PathVariable("emoutput_id") String emoutput_id, @PathVariable("emoutputrct_id") String emoutputrct_id) {
        EMOutputRct domain = emoutputrctService.get(emoutputrct_id);
        EMOutputRctDTO dto = emoutputrctMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('','Create',{'Sql',this.emoutputrctMapping,#emoutputrctdto})")
    @ApiOperation(value = "CreateByEMOutput", tags = {"EMOutputRct" },  notes = "CreateByEMOutput")
	@RequestMapping(method = RequestMethod.POST, value = "/emoutputs/{emoutput_id}/emoutputrcts")
    @Transactional
    public ResponseEntity<EMOutputRctDTO> createByEMOutput(@PathVariable("emoutput_id") String emoutput_id, @RequestBody EMOutputRctDTO emoutputrctdto) {
        EMOutputRct domain = emoutputrctMapping.toDomain(emoutputrctdto);
        domain.setOutputid(emoutput_id);
		emoutputrctService.create(domain);
        EMOutputRctDTO dto = emoutputrctMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Create',{'Sql',this.emoutputrctMapping,#emoutputrctdtos})")
    @ApiOperation(value = "createBatchByEMOutput", tags = {"EMOutputRct" },  notes = "createBatchByEMOutput")
	@RequestMapping(method = RequestMethod.POST, value = "/emoutputs/{emoutput_id}/emoutputrcts/batch")
    public ResponseEntity<Boolean> createBatchByEMOutput(@PathVariable("emoutput_id") String emoutput_id, @RequestBody List<EMOutputRctDTO> emoutputrctdtos) {
        List<EMOutputRct> domainlist=emoutputrctMapping.toDomain(emoutputrctdtos);
        for(EMOutputRct domain:domainlist){
            domain.setOutputid(emoutput_id);
        }
        emoutputrctService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission('','Save',{'Sql',this.emoutputrctMapping,#emoutputrctdto})")
    @ApiOperation(value = "SaveByEMOutput", tags = {"EMOutputRct" },  notes = "SaveByEMOutput")
	@RequestMapping(method = RequestMethod.POST, value = "/emoutputs/{emoutput_id}/emoutputrcts/save")
    public ResponseEntity<Boolean> saveByEMOutput(@PathVariable("emoutput_id") String emoutput_id, @RequestBody EMOutputRctDTO emoutputrctdto) {
        EMOutputRct domain = emoutputrctMapping.toDomain(emoutputrctdto);
        domain.setOutputid(emoutput_id);
        return ResponseEntity.status(HttpStatus.OK).body(emoutputrctService.save(domain));
    }

    @PreAuthorize("hasPermission('Save',{'Sql',this.emoutputrctMapping,#emoutputrctdtos})")
    @ApiOperation(value = "SaveBatchByEMOutput", tags = {"EMOutputRct" },  notes = "SaveBatchByEMOutput")
	@RequestMapping(method = RequestMethod.POST, value = "/emoutputs/{emoutput_id}/emoutputrcts/savebatch")
    public ResponseEntity<Boolean> saveBatchByEMOutput(@PathVariable("emoutput_id") String emoutput_id, @RequestBody List<EMOutputRctDTO> emoutputrctdtos) {
        List<EMOutputRct> domainlist=emoutputrctMapping.toDomain(emoutputrctdtos);
        for(EMOutputRct domain:domainlist){
             domain.setOutputid(emoutput_id);
        }
        emoutputrctService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMOutputRct-GetDraft-all')")
    @ApiOperation(value = "GetDraftByEMOutput", tags = {"EMOutputRct" },  notes = "GetDraftByEMOutput")
    @RequestMapping(method = RequestMethod.GET, value = "/emoutputs/{emoutput_id}/emoutputrcts/getdraft")
    public ResponseEntity<EMOutputRctDTO> getDraftByEMOutput(@PathVariable("emoutput_id") String emoutput_id) {
        EMOutputRct domain = new EMOutputRct();
        domain.setOutputid(emoutput_id);
        return ResponseEntity.status(HttpStatus.OK).body(emoutputrctMapping.toDto(emoutputrctService.getDraft(domain)));
    }

    @PreAuthorize("hasPermission(#emoutputrct_id,'Update',{'Sql',this.emoutputrctMapping,#emoutputrctdto})")
    @ApiOperation(value = "UpdateByEMOutput", tags = {"EMOutputRct" },  notes = "UpdateByEMOutput")
	@RequestMapping(method = RequestMethod.PUT, value = "/emoutputs/{emoutput_id}/emoutputrcts/{emoutputrct_id}")
    @Transactional
    public ResponseEntity<EMOutputRctDTO> updateByEMOutput(@PathVariable("emoutput_id") String emoutput_id, @PathVariable("emoutputrct_id") String emoutputrct_id, @RequestBody EMOutputRctDTO emoutputrctdto) {
        EMOutputRct domain = emoutputrctMapping.toDomain(emoutputrctdto);
        domain.setOutputid(emoutput_id);
        domain.setEmoutputrctid(emoutputrct_id);
		emoutputrctService.update(domain);
        EMOutputRctDTO dto = emoutputrctMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Update',{'Sql',this.emoutputrctMapping,#emoutputrctdtos})")
    @ApiOperation(value = "UpdateBatchByEMOutput", tags = {"EMOutputRct" },  notes = "UpdateBatchByEMOutput")
	@RequestMapping(method = RequestMethod.PUT, value = "/emoutputs/{emoutput_id}/emoutputrcts/batch")
    public ResponseEntity<Boolean> updateBatchByEMOutput(@PathVariable("emoutput_id") String emoutput_id, @RequestBody List<EMOutputRctDTO> emoutputrctdtos) {
        List<EMOutputRct> domainlist=emoutputrctMapping.toDomain(emoutputrctdtos);
        for(EMOutputRct domain:domainlist){
            domain.setOutputid(emoutput_id);
        }
        emoutputrctService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(#emoutputrct_id,'Remove',{'Sql',this.emoutputrctMapping,this.permissionDTO})")
    @ApiOperation(value = "RemoveByEMOutput", tags = {"EMOutputRct" },  notes = "RemoveByEMOutput")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emoutputs/{emoutput_id}/emoutputrcts/{emoutputrct_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByEMOutput(@PathVariable("emoutput_id") String emoutput_id, @PathVariable("emoutputrct_id") String emoutputrct_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emoutputrctService.remove(emoutputrct_id));
    }

    @PreAuthorize("hasPermission('Remove',{'Sql',this.emoutputrctMapping,this.permissionDTO,#ids})")
    @ApiOperation(value = "RemoveBatchByEMOutput", tags = {"EMOutputRct" },  notes = "RemoveBatchByEMOutput")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emoutputs/{emoutput_id}/emoutputrcts/batch")
    public ResponseEntity<Boolean> removeBatchByEMOutput(@RequestBody List<String> ids) {
        emoutputrctService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMOutputRct-CheckKey-all')")
    @ApiOperation(value = "CheckKeyByEMOutput", tags = {"EMOutputRct" },  notes = "CheckKeyByEMOutput")
	@RequestMapping(method = RequestMethod.POST, value = "/emoutputs/{emoutput_id}/emoutputrcts/checkkey")
    public ResponseEntity<Boolean> checkKeyByEMOutput(@PathVariable("emoutput_id") String emoutput_id, @RequestBody EMOutputRctDTO emoutputrctdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emoutputrctService.checkKey(emoutputrctMapping.toDomain(emoutputrctdto)));
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMOutputRct-Default-all')")
	@ApiOperation(value = "fetchDEFAULTByEMOutput", tags = {"EMOutputRct" } ,notes = "fetchDEFAULTByEMOutput")
    @RequestMapping(method= RequestMethod.GET , value="/emoutputs/{emoutput_id}/emoutputrcts/fetchdefault")
	public ResponseEntity<List<EMOutputRctDTO>> fetchEMOutputRctDefaultByEMOutput(@PathVariable("emoutput_id") String emoutput_id,EMOutputRctSearchContext context) {
        context.setN_outputid_eq(emoutput_id);
        Page<EMOutputRct> domains = emoutputrctService.searchDefault(context) ;
        List<EMOutputRctDTO> list = emoutputrctMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMOutputRct-Default-all')")
	@ApiOperation(value = "searchDEFAULTByEMOutput", tags = {"EMOutputRct" } ,notes = "searchDEFAULTByEMOutput")
    @RequestMapping(method= RequestMethod.POST , value="/emoutputs/{emoutput_id}/emoutputrcts/searchdefault")
	public ResponseEntity<Page<EMOutputRctDTO>> searchEMOutputRctDefaultByEMOutput(@PathVariable("emoutput_id") String emoutput_id, @RequestBody EMOutputRctSearchContext context) {
        context.setN_outputid_eq(emoutput_id);
        Page<EMOutputRct> domains = emoutputrctService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emoutputrctMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
}
