package cn.ibizlab.eam.webapi.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;
import javax.servlet.ServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import cn.ibizlab.eam.webapi.dto.*;
import cn.ibizlab.eam.webapi.mapping.*;
import cn.ibizlab.eam.core.eam_core.domain.EMItemCS;
import cn.ibizlab.eam.core.eam_core.service.IEMItemCSService;
import cn.ibizlab.eam.core.eam_core.filter.EMItemCSSearchContext;

@Slf4j
@Api(tags = {"EMItemCS" })
@RestController("WebApi-emitemcs")
@RequestMapping("")
public class EMItemCSResource {

    @Autowired
    private IEMItemCSService emitemcsService;

    @Autowired
    @Lazy
    public EMItemCSMapping emitemcsMapping;

    public EMItemCSDTO permissionDTO=new EMItemCSDTO();

    @PreAuthorize("hasPermission('','Create',{'Sql',this.emitemcsMapping,#emitemcsdto})")
    @ApiOperation(value = "Create", tags = {"EMItemCS" },  notes = "Create")
	@RequestMapping(method = RequestMethod.POST, value = "/emitemcs")
    @Transactional
    public ResponseEntity<EMItemCSDTO> create(@RequestBody EMItemCSDTO emitemcsdto) {
        EMItemCS domain = emitemcsMapping.toDomain(emitemcsdto);
		emitemcsService.create(domain);
        EMItemCSDTO dto = emitemcsMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Create',{'Sql',this.emitemcsMapping,#emitemcsdtos})")
    @ApiOperation(value = "createBatch", tags = {"EMItemCS" },  notes = "createBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emitemcs/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<EMItemCSDTO> emitemcsdtos) {
        emitemcsService.createBatch(emitemcsMapping.toDomain(emitemcsdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMItemCS-GetDraft-all')")
    @ApiOperation(value = "GetDraft", tags = {"EMItemCS" },  notes = "GetDraft")
	@RequestMapping(method = RequestMethod.GET, value = "/emitemcs/getdraft")
    public ResponseEntity<EMItemCSDTO> getDraft() {
        return ResponseEntity.status(HttpStatus.OK).body(emitemcsMapping.toDto(emitemcsService.getDraft(new EMItemCS())));
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMItemCS-CheckKey-all')")
    @ApiOperation(value = "CheckKey", tags = {"EMItemCS" },  notes = "CheckKey")
	@RequestMapping(method = RequestMethod.POST, value = "/emitemcs/checkkey")
    public ResponseEntity<Boolean> checkKey(@RequestBody EMItemCSDTO emitemcsdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emitemcsService.checkKey(emitemcsMapping.toDomain(emitemcsdto)));
    }

    @PreAuthorize("hasPermission(#emitemcs_id,'Update',{'Sql',this.emitemcsMapping,#emitemcsdto})")
    @ApiOperation(value = "Update", tags = {"EMItemCS" },  notes = "Update")
	@RequestMapping(method = RequestMethod.PUT, value = "/emitemcs/{emitemcs_id}")
    @Transactional
    public ResponseEntity<EMItemCSDTO> update(@PathVariable("emitemcs_id") String emitemcs_id, @RequestBody EMItemCSDTO emitemcsdto) {
		EMItemCS domain  = emitemcsMapping.toDomain(emitemcsdto);
        domain .setEmitemcsid(emitemcs_id);
		emitemcsService.update(domain );
		EMItemCSDTO dto = emitemcsMapping.toDto(domain );
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Update',{'Sql',this.emitemcsMapping,#emitemcsdtos})")
    @ApiOperation(value = "UpdateBatch", tags = {"EMItemCS" },  notes = "UpdateBatch")
	@RequestMapping(method = RequestMethod.PUT, value = "/emitemcs/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<EMItemCSDTO> emitemcsdtos) {
        emitemcsService.updateBatch(emitemcsMapping.toDomain(emitemcsdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(#emitemcs_id,'Remove',{'Sql',this.emitemcsMapping,this.permissionDTO})")
    @ApiOperation(value = "Remove", tags = {"EMItemCS" },  notes = "Remove")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emitemcs/{emitemcs_id}")
    @Transactional
    public ResponseEntity<Boolean> remove(@PathVariable("emitemcs_id") String emitemcs_id) {
         return ResponseEntity.status(HttpStatus.OK).body(emitemcsService.remove(emitemcs_id));
    }

    @PreAuthorize("hasPermission('Remove',{'Sql',this.emitemcsMapping,this.permissionDTO,#ids})")
    @ApiOperation(value = "RemoveBatch", tags = {"EMItemCS" },  notes = "RemoveBatch")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emitemcs/batch")
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        emitemcsService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission('','Save',{'Sql',this.emitemcsMapping,#emitemcsdto})")
    @ApiOperation(value = "Save", tags = {"EMItemCS" },  notes = "Save")
	@RequestMapping(method = RequestMethod.POST, value = "/emitemcs/save")
    public ResponseEntity<Boolean> save(@RequestBody EMItemCSDTO emitemcsdto) {
        return ResponseEntity.status(HttpStatus.OK).body(emitemcsService.save(emitemcsMapping.toDomain(emitemcsdto)));
    }

    @PreAuthorize("hasPermission('Save',{'Sql',this.emitemcsMapping,#emitemcsdtos})")
    @ApiOperation(value = "SaveBatch", tags = {"EMItemCS" },  notes = "SaveBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emitemcs/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<EMItemCSDTO> emitemcsdtos) {
        emitemcsService.saveBatch(emitemcsMapping.toDomain(emitemcsdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(#emitemcs_id,'Get',{'Sql',this.emitemcsMapping,this.permissionDTO})")
    @ApiOperation(value = "Get", tags = {"EMItemCS" },  notes = "Get")
	@RequestMapping(method = RequestMethod.GET, value = "/emitemcs/{emitemcs_id}")
    public ResponseEntity<EMItemCSDTO> get(@PathVariable("emitemcs_id") String emitemcs_id) {
        EMItemCS domain = emitemcsService.get(emitemcs_id);
        EMItemCSDTO dto = emitemcsMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMItemCS-Default-all')")
	@ApiOperation(value = "fetchDEFAULT", tags = {"EMItemCS" } ,notes = "fetchDEFAULT")
    @RequestMapping(method= RequestMethod.GET , value="/emitemcs/fetchdefault")
	public ResponseEntity<List<EMItemCSDTO>> fetchDefault(EMItemCSSearchContext context) {
        Page<EMItemCS> domains = emitemcsService.searchDefault(context) ;
        List<EMItemCSDTO> list = emitemcsMapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMItemCS-Default-all')")
	@ApiOperation(value = "searchDEFAULT", tags = {"EMItemCS" } ,notes = "searchDEFAULT")
    @RequestMapping(method= RequestMethod.POST , value="/emitemcs/searchdefault")
	public ResponseEntity<Page<EMItemCSDTO>> searchDefault(@RequestBody EMItemCSSearchContext context) {
        Page<EMItemCS> domains = emitemcsService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emitemcsMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
}
