package cn.ibizlab.eam.webapi.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;
import javax.servlet.ServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import cn.ibizlab.eam.webapi.dto.*;
import cn.ibizlab.eam.webapi.mapping.*;
import cn.ibizlab.eam.core.eam_core.domain.EMEQMP;
import cn.ibizlab.eam.core.eam_core.service.IEMEQMPService;
import cn.ibizlab.eam.core.eam_core.filter.EMEQMPSearchContext;

@Slf4j
@Api(tags = {"EMEQMP" })
@RestController("WebApi-emeqmp")
@RequestMapping("")
public class EMEQMPResource {

    @Autowired
    private IEMEQMPService emeqmpService;

    @Autowired
    @Lazy
    public EMEQMPMapping emeqmpMapping;

    public EMEQMPDTO permissionDTO=new EMEQMPDTO();

    @PreAuthorize("hasPermission(#emeqmp_id,'Update',{'Sql',this.emeqmpMapping,#emeqmpdto})")
    @ApiOperation(value = "Update", tags = {"EMEQMP" },  notes = "Update")
	@RequestMapping(method = RequestMethod.PUT, value = "/emeqmps/{emeqmp_id}")
    @Transactional
    public ResponseEntity<EMEQMPDTO> update(@PathVariable("emeqmp_id") String emeqmp_id, @RequestBody EMEQMPDTO emeqmpdto) {
		EMEQMP domain  = emeqmpMapping.toDomain(emeqmpdto);
        domain .setEmeqmpid(emeqmp_id);
		emeqmpService.update(domain );
		EMEQMPDTO dto = emeqmpMapping.toDto(domain );
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Update',{'Sql',this.emeqmpMapping,#emeqmpdtos})")
    @ApiOperation(value = "UpdateBatch", tags = {"EMEQMP" },  notes = "UpdateBatch")
	@RequestMapping(method = RequestMethod.PUT, value = "/emeqmps/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<EMEQMPDTO> emeqmpdtos) {
        emeqmpService.updateBatch(emeqmpMapping.toDomain(emeqmpdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMEQMP-GetDraft-all')")
    @ApiOperation(value = "GetDraft", tags = {"EMEQMP" },  notes = "GetDraft")
	@RequestMapping(method = RequestMethod.GET, value = "/emeqmps/getdraft")
    public ResponseEntity<EMEQMPDTO> getDraft() {
        return ResponseEntity.status(HttpStatus.OK).body(emeqmpMapping.toDto(emeqmpService.getDraft(new EMEQMP())));
    }

    @PreAuthorize("hasPermission(#emeqmp_id,'Get',{'Sql',this.emeqmpMapping,this.permissionDTO})")
    @ApiOperation(value = "Get", tags = {"EMEQMP" },  notes = "Get")
	@RequestMapping(method = RequestMethod.GET, value = "/emeqmps/{emeqmp_id}")
    public ResponseEntity<EMEQMPDTO> get(@PathVariable("emeqmp_id") String emeqmp_id) {
        EMEQMP domain = emeqmpService.get(emeqmp_id);
        EMEQMPDTO dto = emeqmpMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('','Create',{'Sql',this.emeqmpMapping,#emeqmpdto})")
    @ApiOperation(value = "Create", tags = {"EMEQMP" },  notes = "Create")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqmps")
    @Transactional
    public ResponseEntity<EMEQMPDTO> create(@RequestBody EMEQMPDTO emeqmpdto) {
        EMEQMP domain = emeqmpMapping.toDomain(emeqmpdto);
		emeqmpService.create(domain);
        EMEQMPDTO dto = emeqmpMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Create',{'Sql',this.emeqmpMapping,#emeqmpdtos})")
    @ApiOperation(value = "createBatch", tags = {"EMEQMP" },  notes = "createBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqmps/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<EMEQMPDTO> emeqmpdtos) {
        emeqmpService.createBatch(emeqmpMapping.toDomain(emeqmpdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(#emeqmp_id,'Remove',{'Sql',this.emeqmpMapping,this.permissionDTO})")
    @ApiOperation(value = "Remove", tags = {"EMEQMP" },  notes = "Remove")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emeqmps/{emeqmp_id}")
    @Transactional
    public ResponseEntity<Boolean> remove(@PathVariable("emeqmp_id") String emeqmp_id) {
         return ResponseEntity.status(HttpStatus.OK).body(emeqmpService.remove(emeqmp_id));
    }

    @PreAuthorize("hasPermission('Remove',{'Sql',this.emeqmpMapping,this.permissionDTO,#ids})")
    @ApiOperation(value = "RemoveBatch", tags = {"EMEQMP" },  notes = "RemoveBatch")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emeqmps/batch")
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        emeqmpService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission('','Save',{'Sql',this.emeqmpMapping,#emeqmpdto})")
    @ApiOperation(value = "Save", tags = {"EMEQMP" },  notes = "Save")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqmps/save")
    public ResponseEntity<Boolean> save(@RequestBody EMEQMPDTO emeqmpdto) {
        return ResponseEntity.status(HttpStatus.OK).body(emeqmpService.save(emeqmpMapping.toDomain(emeqmpdto)));
    }

    @PreAuthorize("hasPermission('Save',{'Sql',this.emeqmpMapping,#emeqmpdtos})")
    @ApiOperation(value = "SaveBatch", tags = {"EMEQMP" },  notes = "SaveBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqmps/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<EMEQMPDTO> emeqmpdtos) {
        emeqmpService.saveBatch(emeqmpMapping.toDomain(emeqmpdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMEQMP-CheckKey-all')")
    @ApiOperation(value = "CheckKey", tags = {"EMEQMP" },  notes = "CheckKey")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqmps/checkkey")
    public ResponseEntity<Boolean> checkKey(@RequestBody EMEQMPDTO emeqmpdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emeqmpService.checkKey(emeqmpMapping.toDomain(emeqmpdto)));
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMEQMP-Default-all')")
	@ApiOperation(value = "fetchDEFAULT", tags = {"EMEQMP" } ,notes = "fetchDEFAULT")
    @RequestMapping(method= RequestMethod.GET , value="/emeqmps/fetchdefault")
	public ResponseEntity<List<EMEQMPDTO>> fetchDefault(EMEQMPSearchContext context) {
        Page<EMEQMP> domains = emeqmpService.searchDefault(context) ;
        List<EMEQMPDTO> list = emeqmpMapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMEQMP-Default-all')")
	@ApiOperation(value = "searchDEFAULT", tags = {"EMEQMP" } ,notes = "searchDEFAULT")
    @RequestMapping(method= RequestMethod.POST , value="/emeqmps/searchdefault")
	public ResponseEntity<Page<EMEQMPDTO>> searchDefault(@RequestBody EMEQMPSearchContext context) {
        Page<EMEQMP> domains = emeqmpService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emeqmpMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
}
