package cn.ibizlab.eam.webapi.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;
import javax.servlet.ServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import cn.ibizlab.eam.webapi.dto.*;
import cn.ibizlab.eam.webapi.mapping.*;
import cn.ibizlab.eam.core.eam_core.domain.EMEQLCTTIRes;
import cn.ibizlab.eam.core.eam_core.service.IEMEQLCTTIResService;
import cn.ibizlab.eam.core.eam_core.filter.EMEQLCTTIResSearchContext;

@Slf4j
@Api(tags = {"EMEQLCTTIRes" })
@RestController("WebApi-emeqlcttires")
@RequestMapping("")
public class EMEQLCTTIResResource {

    @Autowired
    private IEMEQLCTTIResService emeqlcttiresService;

    @Autowired
    @Lazy
    public EMEQLCTTIResMapping emeqlcttiresMapping;

    public EMEQLCTTIResDTO permissionDTO=new EMEQLCTTIResDTO();

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMEQLCTTIRes-GetDraft-all')")
    @ApiOperation(value = "GetDraft", tags = {"EMEQLCTTIRes" },  notes = "GetDraft")
	@RequestMapping(method = RequestMethod.GET, value = "/emeqlcttires/getdraft")
    public ResponseEntity<EMEQLCTTIResDTO> getDraft() {
        return ResponseEntity.status(HttpStatus.OK).body(emeqlcttiresMapping.toDto(emeqlcttiresService.getDraft(new EMEQLCTTIRes())));
    }

    @PreAuthorize("hasPermission('','Create',{'Sql',this.emeqlcttiresMapping,#emeqlcttiresdto})")
    @ApiOperation(value = "Create", tags = {"EMEQLCTTIRes" },  notes = "Create")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqlcttires")
    @Transactional
    public ResponseEntity<EMEQLCTTIResDTO> create(@RequestBody EMEQLCTTIResDTO emeqlcttiresdto) {
        EMEQLCTTIRes domain = emeqlcttiresMapping.toDomain(emeqlcttiresdto);
		emeqlcttiresService.create(domain);
        EMEQLCTTIResDTO dto = emeqlcttiresMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Create',{'Sql',this.emeqlcttiresMapping,#emeqlcttiresdtos})")
    @ApiOperation(value = "createBatch", tags = {"EMEQLCTTIRes" },  notes = "createBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqlcttires/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<EMEQLCTTIResDTO> emeqlcttiresdtos) {
        emeqlcttiresService.createBatch(emeqlcttiresMapping.toDomain(emeqlcttiresdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission('','Save',{'Sql',this.emeqlcttiresMapping,#emeqlcttiresdto})")
    @ApiOperation(value = "Save", tags = {"EMEQLCTTIRes" },  notes = "Save")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqlcttires/save")
    public ResponseEntity<Boolean> save(@RequestBody EMEQLCTTIResDTO emeqlcttiresdto) {
        return ResponseEntity.status(HttpStatus.OK).body(emeqlcttiresService.save(emeqlcttiresMapping.toDomain(emeqlcttiresdto)));
    }

    @PreAuthorize("hasPermission('Save',{'Sql',this.emeqlcttiresMapping,#emeqlcttiresdtos})")
    @ApiOperation(value = "SaveBatch", tags = {"EMEQLCTTIRes" },  notes = "SaveBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqlcttires/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<EMEQLCTTIResDTO> emeqlcttiresdtos) {
        emeqlcttiresService.saveBatch(emeqlcttiresMapping.toDomain(emeqlcttiresdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(#emeqlcttires_id,'Get',{'Sql',this.emeqlcttiresMapping,this.permissionDTO})")
    @ApiOperation(value = "Get", tags = {"EMEQLCTTIRes" },  notes = "Get")
	@RequestMapping(method = RequestMethod.GET, value = "/emeqlcttires/{emeqlcttires_id}")
    public ResponseEntity<EMEQLCTTIResDTO> get(@PathVariable("emeqlcttires_id") String emeqlcttires_id) {
        EMEQLCTTIRes domain = emeqlcttiresService.get(emeqlcttires_id);
        EMEQLCTTIResDTO dto = emeqlcttiresMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMEQLCTTIRes-CheckKey-all')")
    @ApiOperation(value = "CheckKey", tags = {"EMEQLCTTIRes" },  notes = "CheckKey")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqlcttires/checkkey")
    public ResponseEntity<Boolean> checkKey(@RequestBody EMEQLCTTIResDTO emeqlcttiresdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emeqlcttiresService.checkKey(emeqlcttiresMapping.toDomain(emeqlcttiresdto)));
    }

    @PreAuthorize("hasPermission(#emeqlcttires_id,'Remove',{'Sql',this.emeqlcttiresMapping,this.permissionDTO})")
    @ApiOperation(value = "Remove", tags = {"EMEQLCTTIRes" },  notes = "Remove")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emeqlcttires/{emeqlcttires_id}")
    @Transactional
    public ResponseEntity<Boolean> remove(@PathVariable("emeqlcttires_id") String emeqlcttires_id) {
         return ResponseEntity.status(HttpStatus.OK).body(emeqlcttiresService.remove(emeqlcttires_id));
    }

    @PreAuthorize("hasPermission('Remove',{'Sql',this.emeqlcttiresMapping,this.permissionDTO,#ids})")
    @ApiOperation(value = "RemoveBatch", tags = {"EMEQLCTTIRes" },  notes = "RemoveBatch")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emeqlcttires/batch")
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        emeqlcttiresService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(#emeqlcttires_id,'Update',{'Sql',this.emeqlcttiresMapping,#emeqlcttiresdto})")
    @ApiOperation(value = "Update", tags = {"EMEQLCTTIRes" },  notes = "Update")
	@RequestMapping(method = RequestMethod.PUT, value = "/emeqlcttires/{emeqlcttires_id}")
    @Transactional
    public ResponseEntity<EMEQLCTTIResDTO> update(@PathVariable("emeqlcttires_id") String emeqlcttires_id, @RequestBody EMEQLCTTIResDTO emeqlcttiresdto) {
		EMEQLCTTIRes domain  = emeqlcttiresMapping.toDomain(emeqlcttiresdto);
        domain .setEmeqlocationid(emeqlcttires_id);
		emeqlcttiresService.update(domain );
		EMEQLCTTIResDTO dto = emeqlcttiresMapping.toDto(domain );
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Update',{'Sql',this.emeqlcttiresMapping,#emeqlcttiresdtos})")
    @ApiOperation(value = "UpdateBatch", tags = {"EMEQLCTTIRes" },  notes = "UpdateBatch")
	@RequestMapping(method = RequestMethod.PUT, value = "/emeqlcttires/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<EMEQLCTTIResDTO> emeqlcttiresdtos) {
        emeqlcttiresService.updateBatch(emeqlcttiresMapping.toDomain(emeqlcttiresdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMEQLCTTIRes-Default-all')")
	@ApiOperation(value = "fetchDEFAULT", tags = {"EMEQLCTTIRes" } ,notes = "fetchDEFAULT")
    @RequestMapping(method= RequestMethod.GET , value="/emeqlcttires/fetchdefault")
	public ResponseEntity<List<EMEQLCTTIResDTO>> fetchDefault(EMEQLCTTIResSearchContext context) {
        Page<EMEQLCTTIRes> domains = emeqlcttiresService.searchDefault(context) ;
        List<EMEQLCTTIResDTO> list = emeqlcttiresMapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMEQLCTTIRes-Default-all')")
	@ApiOperation(value = "searchDEFAULT", tags = {"EMEQLCTTIRes" } ,notes = "searchDEFAULT")
    @RequestMapping(method= RequestMethod.POST , value="/emeqlcttires/searchdefault")
	public ResponseEntity<Page<EMEQLCTTIResDTO>> searchDefault(@RequestBody EMEQLCTTIResSearchContext context) {
        Page<EMEQLCTTIRes> domains = emeqlcttiresService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emeqlcttiresMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
}
