package cn.ibizlab.eam.webapi.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;
import javax.servlet.ServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import cn.ibizlab.eam.webapi.dto.*;
import cn.ibizlab.eam.webapi.mapping.*;
import cn.ibizlab.eam.core.eam_core.domain.EMEIGSJRB;
import cn.ibizlab.eam.core.eam_core.service.IEMEIGSJRBService;
import cn.ibizlab.eam.core.eam_core.filter.EMEIGSJRBSearchContext;

@Slf4j
@Api(tags = {"EMEIGSJRB" })
@RestController("WebApi-emeigsjrb")
@RequestMapping("")
public class EMEIGSJRBResource {

    @Autowired
    private IEMEIGSJRBService emeigsjrbService;

    @Autowired
    @Lazy
    public EMEIGSJRBMapping emeigsjrbMapping;

    public EMEIGSJRBDTO permissionDTO=new EMEIGSJRBDTO();

    @PreAuthorize("hasPermission(#emeigsjrb_id,'Remove',{'Sql',this.emeigsjrbMapping,this.permissionDTO})")
    @ApiOperation(value = "Remove", tags = {"EMEIGSJRB" },  notes = "Remove")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emeigsjrbs/{emeigsjrb_id}")
    @Transactional
    public ResponseEntity<Boolean> remove(@PathVariable("emeigsjrb_id") String emeigsjrb_id) {
         return ResponseEntity.status(HttpStatus.OK).body(emeigsjrbService.remove(emeigsjrb_id));
    }

    @PreAuthorize("hasPermission('Remove',{'Sql',this.emeigsjrbMapping,this.permissionDTO,#ids})")
    @ApiOperation(value = "RemoveBatch", tags = {"EMEIGSJRB" },  notes = "RemoveBatch")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emeigsjrbs/batch")
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        emeigsjrbService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMEIGSJRB-CheckKey-all')")
    @ApiOperation(value = "CheckKey", tags = {"EMEIGSJRB" },  notes = "CheckKey")
	@RequestMapping(method = RequestMethod.POST, value = "/emeigsjrbs/checkkey")
    public ResponseEntity<Boolean> checkKey(@RequestBody EMEIGSJRBDTO emeigsjrbdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emeigsjrbService.checkKey(emeigsjrbMapping.toDomain(emeigsjrbdto)));
    }

    @PreAuthorize("hasPermission(#emeigsjrb_id,'Update',{'Sql',this.emeigsjrbMapping,#emeigsjrbdto})")
    @ApiOperation(value = "Update", tags = {"EMEIGSJRB" },  notes = "Update")
	@RequestMapping(method = RequestMethod.PUT, value = "/emeigsjrbs/{emeigsjrb_id}")
    @Transactional
    public ResponseEntity<EMEIGSJRBDTO> update(@PathVariable("emeigsjrb_id") String emeigsjrb_id, @RequestBody EMEIGSJRBDTO emeigsjrbdto) {
		EMEIGSJRB domain  = emeigsjrbMapping.toDomain(emeigsjrbdto);
        domain .setEmeigsjrbid(emeigsjrb_id);
		emeigsjrbService.update(domain );
		EMEIGSJRBDTO dto = emeigsjrbMapping.toDto(domain );
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Update',{'Sql',this.emeigsjrbMapping,#emeigsjrbdtos})")
    @ApiOperation(value = "UpdateBatch", tags = {"EMEIGSJRB" },  notes = "UpdateBatch")
	@RequestMapping(method = RequestMethod.PUT, value = "/emeigsjrbs/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<EMEIGSJRBDTO> emeigsjrbdtos) {
        emeigsjrbService.updateBatch(emeigsjrbMapping.toDomain(emeigsjrbdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission('','Save',{'Sql',this.emeigsjrbMapping,#emeigsjrbdto})")
    @ApiOperation(value = "Save", tags = {"EMEIGSJRB" },  notes = "Save")
	@RequestMapping(method = RequestMethod.POST, value = "/emeigsjrbs/save")
    public ResponseEntity<Boolean> save(@RequestBody EMEIGSJRBDTO emeigsjrbdto) {
        return ResponseEntity.status(HttpStatus.OK).body(emeigsjrbService.save(emeigsjrbMapping.toDomain(emeigsjrbdto)));
    }

    @PreAuthorize("hasPermission('Save',{'Sql',this.emeigsjrbMapping,#emeigsjrbdtos})")
    @ApiOperation(value = "SaveBatch", tags = {"EMEIGSJRB" },  notes = "SaveBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emeigsjrbs/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<EMEIGSJRBDTO> emeigsjrbdtos) {
        emeigsjrbService.saveBatch(emeigsjrbMapping.toDomain(emeigsjrbdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission('','Create',{'Sql',this.emeigsjrbMapping,#emeigsjrbdto})")
    @ApiOperation(value = "Create", tags = {"EMEIGSJRB" },  notes = "Create")
	@RequestMapping(method = RequestMethod.POST, value = "/emeigsjrbs")
    @Transactional
    public ResponseEntity<EMEIGSJRBDTO> create(@RequestBody EMEIGSJRBDTO emeigsjrbdto) {
        EMEIGSJRB domain = emeigsjrbMapping.toDomain(emeigsjrbdto);
		emeigsjrbService.create(domain);
        EMEIGSJRBDTO dto = emeigsjrbMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Create',{'Sql',this.emeigsjrbMapping,#emeigsjrbdtos})")
    @ApiOperation(value = "createBatch", tags = {"EMEIGSJRB" },  notes = "createBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emeigsjrbs/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<EMEIGSJRBDTO> emeigsjrbdtos) {
        emeigsjrbService.createBatch(emeigsjrbMapping.toDomain(emeigsjrbdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(#emeigsjrb_id,'Get',{'Sql',this.emeigsjrbMapping,this.permissionDTO})")
    @ApiOperation(value = "Get", tags = {"EMEIGSJRB" },  notes = "Get")
	@RequestMapping(method = RequestMethod.GET, value = "/emeigsjrbs/{emeigsjrb_id}")
    public ResponseEntity<EMEIGSJRBDTO> get(@PathVariable("emeigsjrb_id") String emeigsjrb_id) {
        EMEIGSJRB domain = emeigsjrbService.get(emeigsjrb_id);
        EMEIGSJRBDTO dto = emeigsjrbMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMEIGSJRB-GetDraft-all')")
    @ApiOperation(value = "GetDraft", tags = {"EMEIGSJRB" },  notes = "GetDraft")
	@RequestMapping(method = RequestMethod.GET, value = "/emeigsjrbs/getdraft")
    public ResponseEntity<EMEIGSJRBDTO> getDraft() {
        return ResponseEntity.status(HttpStatus.OK).body(emeigsjrbMapping.toDto(emeigsjrbService.getDraft(new EMEIGSJRB())));
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMEIGSJRB-Default-all')")
	@ApiOperation(value = "fetchDEFAULT", tags = {"EMEIGSJRB" } ,notes = "fetchDEFAULT")
    @RequestMapping(method= RequestMethod.GET , value="/emeigsjrbs/fetchdefault")
	public ResponseEntity<List<EMEIGSJRBDTO>> fetchDefault(EMEIGSJRBSearchContext context) {
        Page<EMEIGSJRB> domains = emeigsjrbService.searchDefault(context) ;
        List<EMEIGSJRBDTO> list = emeigsjrbMapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMEIGSJRB-Default-all')")
	@ApiOperation(value = "searchDEFAULT", tags = {"EMEIGSJRB" } ,notes = "searchDEFAULT")
    @RequestMapping(method= RequestMethod.POST , value="/emeigsjrbs/searchdefault")
	public ResponseEntity<Page<EMEIGSJRBDTO>> searchDefault(@RequestBody EMEIGSJRBSearchContext context) {
        Page<EMEIGSJRB> domains = emeigsjrbService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emeigsjrbMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
}
