package cn.ibizlab.eam.webapi.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;
import javax.servlet.ServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import cn.ibizlab.eam.webapi.dto.*;
import cn.ibizlab.eam.webapi.mapping.*;
import cn.ibizlab.eam.core.eam_core.domain.EMAssetHist;
import cn.ibizlab.eam.core.eam_core.service.IEMAssetHistService;
import cn.ibizlab.eam.core.eam_core.filter.EMAssetHistSearchContext;

@Slf4j
@Api(tags = {"EMAssetHist" })
@RestController("WebApi-emassethist")
@RequestMapping("")
public class EMAssetHistResource {

    @Autowired
    private IEMAssetHistService emassethistService;

    @Autowired
    @Lazy
    public EMAssetHistMapping emassethistMapping;

    public EMAssetHistDTO permissionDTO=new EMAssetHistDTO();

    @PreAuthorize("hasPermission(#emassethist_id,'Update',{'Sql',this.emassethistMapping,#emassethistdto})")
    @ApiOperation(value = "Update", tags = {"EMAssetHist" },  notes = "Update")
	@RequestMapping(method = RequestMethod.PUT, value = "/emassethists/{emassethist_id}")
    @Transactional
    public ResponseEntity<EMAssetHistDTO> update(@PathVariable("emassethist_id") String emassethist_id, @RequestBody EMAssetHistDTO emassethistdto) {
		EMAssetHist domain  = emassethistMapping.toDomain(emassethistdto);
        domain .setEmassethistid(emassethist_id);
		emassethistService.update(domain );
		EMAssetHistDTO dto = emassethistMapping.toDto(domain );
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Update',{'Sql',this.emassethistMapping,#emassethistdtos})")
    @ApiOperation(value = "UpdateBatch", tags = {"EMAssetHist" },  notes = "UpdateBatch")
	@RequestMapping(method = RequestMethod.PUT, value = "/emassethists/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<EMAssetHistDTO> emassethistdtos) {
        emassethistService.updateBatch(emassethistMapping.toDomain(emassethistdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(#emassethist_id,'Remove',{'Sql',this.emassethistMapping,this.permissionDTO})")
    @ApiOperation(value = "Remove", tags = {"EMAssetHist" },  notes = "Remove")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emassethists/{emassethist_id}")
    @Transactional
    public ResponseEntity<Boolean> remove(@PathVariable("emassethist_id") String emassethist_id) {
         return ResponseEntity.status(HttpStatus.OK).body(emassethistService.remove(emassethist_id));
    }

    @PreAuthorize("hasPermission('Remove',{'Sql',this.emassethistMapping,this.permissionDTO,#ids})")
    @ApiOperation(value = "RemoveBatch", tags = {"EMAssetHist" },  notes = "RemoveBatch")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emassethists/batch")
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        emassethistService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission('','Save',{'Sql',this.emassethistMapping,#emassethistdto})")
    @ApiOperation(value = "Save", tags = {"EMAssetHist" },  notes = "Save")
	@RequestMapping(method = RequestMethod.POST, value = "/emassethists/save")
    public ResponseEntity<Boolean> save(@RequestBody EMAssetHistDTO emassethistdto) {
        return ResponseEntity.status(HttpStatus.OK).body(emassethistService.save(emassethistMapping.toDomain(emassethistdto)));
    }

    @PreAuthorize("hasPermission('Save',{'Sql',this.emassethistMapping,#emassethistdtos})")
    @ApiOperation(value = "SaveBatch", tags = {"EMAssetHist" },  notes = "SaveBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emassethists/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<EMAssetHistDTO> emassethistdtos) {
        emassethistService.saveBatch(emassethistMapping.toDomain(emassethistdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission('','Create',{'Sql',this.emassethistMapping,#emassethistdto})")
    @ApiOperation(value = "Create", tags = {"EMAssetHist" },  notes = "Create")
	@RequestMapping(method = RequestMethod.POST, value = "/emassethists")
    @Transactional
    public ResponseEntity<EMAssetHistDTO> create(@RequestBody EMAssetHistDTO emassethistdto) {
        EMAssetHist domain = emassethistMapping.toDomain(emassethistdto);
		emassethistService.create(domain);
        EMAssetHistDTO dto = emassethistMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Create',{'Sql',this.emassethistMapping,#emassethistdtos})")
    @ApiOperation(value = "createBatch", tags = {"EMAssetHist" },  notes = "createBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emassethists/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<EMAssetHistDTO> emassethistdtos) {
        emassethistService.createBatch(emassethistMapping.toDomain(emassethistdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMAssetHist-CheckKey-all')")
    @ApiOperation(value = "CheckKey", tags = {"EMAssetHist" },  notes = "CheckKey")
	@RequestMapping(method = RequestMethod.POST, value = "/emassethists/checkkey")
    public ResponseEntity<Boolean> checkKey(@RequestBody EMAssetHistDTO emassethistdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emassethistService.checkKey(emassethistMapping.toDomain(emassethistdto)));
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMAssetHist-GetDraft-all')")
    @ApiOperation(value = "GetDraft", tags = {"EMAssetHist" },  notes = "GetDraft")
	@RequestMapping(method = RequestMethod.GET, value = "/emassethists/getdraft")
    public ResponseEntity<EMAssetHistDTO> getDraft() {
        return ResponseEntity.status(HttpStatus.OK).body(emassethistMapping.toDto(emassethistService.getDraft(new EMAssetHist())));
    }

    @PreAuthorize("hasPermission(#emassethist_id,'Get',{'Sql',this.emassethistMapping,this.permissionDTO})")
    @ApiOperation(value = "Get", tags = {"EMAssetHist" },  notes = "Get")
	@RequestMapping(method = RequestMethod.GET, value = "/emassethists/{emassethist_id}")
    public ResponseEntity<EMAssetHistDTO> get(@PathVariable("emassethist_id") String emassethist_id) {
        EMAssetHist domain = emassethistService.get(emassethist_id);
        EMAssetHistDTO dto = emassethistMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMAssetHist-Default-all')")
	@ApiOperation(value = "fetchDEFAULT", tags = {"EMAssetHist" } ,notes = "fetchDEFAULT")
    @RequestMapping(method= RequestMethod.GET , value="/emassethists/fetchdefault")
	public ResponseEntity<List<EMAssetHistDTO>> fetchDefault(EMAssetHistSearchContext context) {
        Page<EMAssetHist> domains = emassethistService.searchDefault(context) ;
        List<EMAssetHistDTO> list = emassethistMapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMAssetHist-Default-all')")
	@ApiOperation(value = "searchDEFAULT", tags = {"EMAssetHist" } ,notes = "searchDEFAULT")
    @RequestMapping(method= RequestMethod.POST , value="/emassethists/searchdefault")
	public ResponseEntity<Page<EMAssetHistDTO>> searchDefault(@RequestBody EMAssetHistSearchContext context) {
        Page<EMAssetHist> domains = emassethistService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emassethistMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
}
