package cn.ibizlab.eam.webapi.dto;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.math.BigInteger;
import java.util.Map;
import java.util.HashMap;
import java.io.Serializable;
import java.math.BigDecimal;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.alibaba.fastjson.annotation.JSONField;
import cn.ibizlab.eam.util.domain.DTOBase;
import lombok.Data;

/**
 * 服务DTO对象[EMAssetClearDTO]
 */
@Data
public class EMAssetClearDTO extends DTOBase implements Serializable {

	private static final long serialVersionUID = 1L;

    /**
     * 属性 [ASSETINPRICE]
     *
     */
    @JSONField(name = "assetinprice")
    @JsonProperty("assetinprice")
    private String assetinprice;

    /**
     * 属性 [ASSETCHECKPRICE]
     *
     */
    @JSONField(name = "assetcheckprice")
    @JsonProperty("assetcheckprice")
    private String assetcheckprice;

    /**
     * 属性 [ORGID]
     *
     */
    @JSONField(name = "orgid")
    @JsonProperty("orgid")
    private String orgid;

    /**
     * 属性 [ISNEW]
     *
     */
    @JSONField(name = "isnew")
    @JsonProperty("isnew")
    private Integer isnew;

    /**
     * 属性 [ASSETOUTPRICE]
     *
     */
    @JSONField(name = "assetoutprice")
    @JsonProperty("assetoutprice")
    private String assetoutprice;

    /**
     * 属性 [ASSETCLEARLCT]
     *
     */
    @JSONField(name = "assetclearlct")
    @JsonProperty("assetclearlct")
    private String assetclearlct;

    /**
     * 属性 [EMASSETCLEARNAME]
     *
     */
    @JSONField(name = "emassetclearname")
    @JsonProperty("emassetclearname")
    private String emassetclearname;

    /**
     * 属性 [UPDATEDATE]
     *
     */
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
    @JSONField(name = "updatedate" , format="yyyy-MM-dd HH:mm:ss")
    @JsonProperty("updatedate")
    private Timestamp updatedate;

    /**
     * 属性 [ASSETOUTNUM]
     *
     */
    @JSONField(name = "assetoutnum")
    @JsonProperty("assetoutnum")
    private Integer assetoutnum;

    /**
     * 属性 [UPDATEMAN]
     *
     */
    @JSONField(name = "updateman")
    @JsonProperty("updateman")
    private String updateman;

    /**
     * 属性 [ASSETCLEARSTATE]
     *
     */
    @JSONField(name = "assetclearstate")
    @JsonProperty("assetclearstate")
    private String assetclearstate;

    /**
     * 属性 [ASSETCLEARDATE]
     *
     */
    @JsonFormat(pattern="yyyy-MM-dd", locale = "zh" , timezone="GMT+8")
    @JSONField(name = "assetcleardate" , format="yyyy-MM-dd")
    @JsonProperty("assetcleardate")
    private Timestamp assetcleardate;

    /**
     * 属性 [ENABLE]
     *
     */
    @JSONField(name = "enable")
    @JsonProperty("enable")
    private Integer enable;

    /**
     * 属性 [CREATEDATE]
     *
     */
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
    @JSONField(name = "createdate" , format="yyyy-MM-dd HH:mm:ss")
    @JsonProperty("createdate")
    private Timestamp createdate;

    /**
     * 属性 [ASSETINNUM]
     *
     */
    @JSONField(name = "assetinnum")
    @JsonProperty("assetinnum")
    private Integer assetinnum;

    /**
     * 属性 [ASSETCHECKNUM]
     *
     */
    @JSONField(name = "assetchecknum")
    @JsonProperty("assetchecknum")
    private Integer assetchecknum;

    /**
     * 属性 [CREATEMAN]
     *
     */
    @JSONField(name = "createman")
    @JsonProperty("createman")
    private String createman;

    /**
     * 属性 [EMASSETCLEARID]
     *
     */
    @JSONField(name = "emassetclearid")
    @JsonProperty("emassetclearid")
    private String emassetclearid;

    /**
     * 属性 [ASSETSORT]
     *
     */
    @JSONField(name = "assetsort")
    @JsonProperty("assetsort")
    private String assetsort;

    /**
     * 属性 [ASSETCODE]
     *
     */
    @JSONField(name = "assetcode")
    @JsonProperty("assetcode")
    private String assetcode;

    /**
     * 属性 [ASSETCLASSNAME]
     *
     */
    @JSONField(name = "assetclassname")
    @JsonProperty("assetclassname")
    private String assetclassname;

    /**
     * 属性 [EQMODELCODE]
     *
     */
    @JSONField(name = "eqmodelcode")
    @JsonProperty("eqmodelcode")
    private String eqmodelcode;

    /**
     * 属性 [PURCHDATE]
     *
     */
    @JsonFormat(pattern="yyyy-MM-dd", locale = "zh" , timezone="GMT+8")
    @JSONField(name = "purchdate" , format="yyyy-MM-dd")
    @JsonProperty("purchdate")
    private Timestamp purchdate;

    /**
     * 属性 [ORIGINALCOST]
     *
     */
    @JSONField(name = "originalcost")
    @JsonProperty("originalcost")
    private String originalcost;

    /**
     * 属性 [ASSETCLASSID]
     *
     */
    @JSONField(name = "assetclassid")
    @JsonProperty("assetclassid")
    private String assetclassid;

    /**
     * 属性 [EMASSETNAME]
     *
     */
    @JSONField(name = "emassetname")
    @JsonProperty("emassetname")
    private String emassetname;

    /**
     * 属性 [EMASSETID]
     *
     */
    @JSONField(name = "emassetid")
    @JsonProperty("emassetid")
    private String emassetid;


    /**
     * 设置 [ASSETINPRICE]
     */
    public void setAssetinprice(String  assetinprice){
        this.assetinprice = assetinprice ;
        this.modify("assetinprice",assetinprice);
    }

    /**
     * 设置 [ASSETCHECKPRICE]
     */
    public void setAssetcheckprice(String  assetcheckprice){
        this.assetcheckprice = assetcheckprice ;
        this.modify("assetcheckprice",assetcheckprice);
    }

    /**
     * 设置 [ISNEW]
     */
    public void setIsnew(Integer  isnew){
        this.isnew = isnew ;
        this.modify("isnew",isnew);
    }

    /**
     * 设置 [ASSETOUTPRICE]
     */
    public void setAssetoutprice(String  assetoutprice){
        this.assetoutprice = assetoutprice ;
        this.modify("assetoutprice",assetoutprice);
    }

    /**
     * 设置 [ASSETCLEARLCT]
     */
    public void setAssetclearlct(String  assetclearlct){
        this.assetclearlct = assetclearlct ;
        this.modify("assetclearlct",assetclearlct);
    }

    /**
     * 设置 [EMASSETCLEARNAME]
     */
    public void setEmassetclearname(String  emassetclearname){
        this.emassetclearname = emassetclearname ;
        this.modify("emassetclearname",emassetclearname);
    }

    /**
     * 设置 [ASSETOUTNUM]
     */
    public void setAssetoutnum(Integer  assetoutnum){
        this.assetoutnum = assetoutnum ;
        this.modify("assetoutnum",assetoutnum);
    }

    /**
     * 设置 [ASSETCLEARSTATE]
     */
    public void setAssetclearstate(String  assetclearstate){
        this.assetclearstate = assetclearstate ;
        this.modify("assetclearstate",assetclearstate);
    }

    /**
     * 设置 [ASSETCLEARDATE]
     */
    public void setAssetcleardate(Timestamp  assetcleardate){
        this.assetcleardate = assetcleardate ;
        this.modify("assetcleardate",assetcleardate);
    }

    /**
     * 设置 [ASSETINNUM]
     */
    public void setAssetinnum(Integer  assetinnum){
        this.assetinnum = assetinnum ;
        this.modify("assetinnum",assetinnum);
    }

    /**
     * 设置 [ASSETCHECKNUM]
     */
    public void setAssetchecknum(Integer  assetchecknum){
        this.assetchecknum = assetchecknum ;
        this.modify("assetchecknum",assetchecknum);
    }

    /**
     * 设置 [EMASSETID]
     */
    public void setEmassetid(String  emassetid){
        this.emassetid = emassetid ;
        this.modify("emassetid",emassetid);
    }


}

