package cn.ibizlab.eam.webapi.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;

import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;

import javax.servlet.ServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;

import cn.ibizlab.eam.webapi.dto.*;
import cn.ibizlab.eam.webapi.mapping.*;
import cn.ibizlab.eam.core.eam_core.domain.EMWeeklyPlan;
import cn.ibizlab.eam.core.eam_core.service.IEMWeeklyPlanService;
import cn.ibizlab.eam.core.eam_core.filter.EMWeeklyPlanSearchContext;




@Slf4j
@Api(tags = {"EMWeeklyPlan" })
@RestController("WebApi-emweeklyplan")
@RequestMapping("")
public class EMWeeklyPlanResource {

    @Autowired
    private IEMWeeklyPlanService emweeklyplanService;

    @Autowired
    @Lazy
    private EMWeeklyPlanMapping emweeklyplanMapping;




    @PreAuthorize("hasPermission('','Create',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Create", tags = {"EMWeeklyPlan" },  notes = "Create")
	@RequestMapping(method = RequestMethod.POST, value = "/emweeklyplans")
    @Transactional
    public ResponseEntity<EMWeeklyPlanDTO> create(@RequestBody EMWeeklyPlanDTO emweeklyplandto) {
        EMWeeklyPlan domain = emweeklyplanMapping.toDomain(emweeklyplandto);
		emweeklyplanService.create(domain);
        EMWeeklyPlanDTO dto = emweeklyplanMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }
    @PreAuthorize("hasPermission('','Create',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "createBatch", tags = {"EMWeeklyPlan" },  notes = "createBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emweeklyplans/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<EMWeeklyPlanDTO> emweeklyplandtos) {
        emweeklyplanService.createBatch(emweeklyplanMapping.toDomain(emweeklyplandtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @PreAuthorize("hasPermission(#emweeklyplan_id,'Get',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Get", tags = {"EMWeeklyPlan" },  notes = "Get")
	@RequestMapping(method = RequestMethod.GET, value = "/emweeklyplans/{emweeklyplan_id}")
    public ResponseEntity<EMWeeklyPlanDTO> get(@PathVariable("emweeklyplan_id") String emweeklyplan_id) {
        EMWeeklyPlan domain = emweeklyplanService.get(emweeklyplan_id);
        EMWeeklyPlanDTO dto = emweeklyplanMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }




    @ApiOperation(value = "Save", tags = {"EMWeeklyPlan" },  notes = "Save")
	@RequestMapping(method = RequestMethod.POST, value = "/emweeklyplans/save")
    public ResponseEntity<Boolean> save(@RequestBody EMWeeklyPlanDTO emweeklyplandto) {
        return ResponseEntity.status(HttpStatus.OK).body(emweeklyplanService.save(emweeklyplanMapping.toDomain(emweeklyplandto)));
    }

    @ApiOperation(value = "SaveBatch", tags = {"EMWeeklyPlan" },  notes = "SaveBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emweeklyplans/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<EMWeeklyPlanDTO> emweeklyplandtos) {
        emweeklyplanService.saveBatch(emweeklyplanMapping.toDomain(emweeklyplandtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @PreAuthorize("hasPermission(#emweeklyplan_id,'Remove',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Remove", tags = {"EMWeeklyPlan" },  notes = "Remove")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emweeklyplans/{emweeklyplan_id}")
    @Transactional
    public ResponseEntity<Boolean> remove(@PathVariable("emweeklyplan_id") String emweeklyplan_id) {
         return ResponseEntity.status(HttpStatus.OK).body(emweeklyplanService.remove(emweeklyplan_id));
    }

    @ApiOperation(value = "RemoveBatch", tags = {"EMWeeklyPlan" },  notes = "RemoveBatch")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emweeklyplans/batch")
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        emweeklyplanService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @PreAuthorize("hasPermission(#emweeklyplan_id,'Update',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Update", tags = {"EMWeeklyPlan" },  notes = "Update")
	@RequestMapping(method = RequestMethod.PUT, value = "/emweeklyplans/{emweeklyplan_id}")
    @Transactional
    public ResponseEntity<EMWeeklyPlanDTO> update(@PathVariable("emweeklyplan_id") String emweeklyplan_id, @RequestBody EMWeeklyPlanDTO emweeklyplandto) {
		EMWeeklyPlan domain = emweeklyplanMapping.toDomain(emweeklyplandto);
        domain.setEmweeklyplanid(emweeklyplan_id);
		emweeklyplanService.update(domain);
		EMWeeklyPlanDTO dto = emweeklyplanMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(#emweeklyplan_id,'Update',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "UpdateBatch", tags = {"EMWeeklyPlan" },  notes = "UpdateBatch")
	@RequestMapping(method = RequestMethod.PUT, value = "/emweeklyplans/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<EMWeeklyPlanDTO> emweeklyplandtos) {
        emweeklyplanService.updateBatch(emweeklyplanMapping.toDomain(emweeklyplandtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @ApiOperation(value = "GetDraft", tags = {"EMWeeklyPlan" },  notes = "GetDraft")
	@RequestMapping(method = RequestMethod.GET, value = "/emweeklyplans/getdraft")
    public ResponseEntity<EMWeeklyPlanDTO> getDraft() {
        return ResponseEntity.status(HttpStatus.OK).body(emweeklyplanMapping.toDto(emweeklyplanService.getDraft(new EMWeeklyPlan())));
    }




    @ApiOperation(value = "CheckKey", tags = {"EMWeeklyPlan" },  notes = "CheckKey")
	@RequestMapping(method = RequestMethod.POST, value = "/emweeklyplans/checkkey")
    public ResponseEntity<Boolean> checkKey(@RequestBody EMWeeklyPlanDTO emweeklyplandto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emweeklyplanService.checkKey(emweeklyplanMapping.toDomain(emweeklyplandto)));
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMWeeklyPlan-Default-all')")
	@ApiOperation(value = "fetchDEFAULT", tags = {"EMWeeklyPlan" } ,notes = "fetchDEFAULT")
    @RequestMapping(method= RequestMethod.GET , value="/emweeklyplans/fetchdefault")
	public ResponseEntity<List<EMWeeklyPlanDTO>> fetchDefault(EMWeeklyPlanSearchContext context) {
        Page<EMWeeklyPlan> domains = emweeklyplanService.searchDefault(context) ;
        List<EMWeeklyPlanDTO> list = emweeklyplanMapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMWeeklyPlan-Default-all')")
	@ApiOperation(value = "searchDEFAULT", tags = {"EMWeeklyPlan" } ,notes = "searchDEFAULT")
    @RequestMapping(method= RequestMethod.POST , value="/emweeklyplans/searchdefault")
	public ResponseEntity<Page<EMWeeklyPlanDTO>> searchDefault(@RequestBody EMWeeklyPlanSearchContext context) {
        Page<EMWeeklyPlan> domains = emweeklyplanService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emweeklyplanMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}


    /**
     * 用户权限校验
     * @return
     */
	public EMWeeklyPlan getEntity(){
        return new EMWeeklyPlan();
    }

}
