package cn.ibizlab.eam.webapi.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;

import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;

import javax.servlet.ServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;

import cn.ibizlab.eam.webapi.dto.*;
import cn.ibizlab.eam.webapi.mapping.*;
import cn.ibizlab.eam.core.eam_core.domain.EMWO_PT;
import cn.ibizlab.eam.core.eam_core.service.IEMWO_PTService;
import cn.ibizlab.eam.core.eam_core.filter.EMWO_PTSearchContext;




@Slf4j
@Api(tags = {"EMWO_PT" })
@RestController("WebApi-emwo_pt")
@RequestMapping("")
public class EMWO_PTResource {

    @Autowired
    private IEMWO_PTService emwo_ptService;

    @Autowired
    @Lazy
    private EMWO_PTMapping emwo_ptMapping;




    @PreAuthorize("hasPermission('','Create',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Create", tags = {"EMWO_PT" },  notes = "Create")
	@RequestMapping(method = RequestMethod.POST, value = "/emwo_pts")
    @Transactional
    public ResponseEntity<EMWO_PTDTO> create(@RequestBody EMWO_PTDTO emwo_ptdto) {
        EMWO_PT domain = emwo_ptMapping.toDomain(emwo_ptdto);
		emwo_ptService.create(domain);
        EMWO_PTDTO dto = emwo_ptMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }
    @PreAuthorize("hasPermission('','Create',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "createBatch", tags = {"EMWO_PT" },  notes = "createBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emwo_pts/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<EMWO_PTDTO> emwo_ptdtos) {
        emwo_ptService.createBatch(emwo_ptMapping.toDomain(emwo_ptdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @PreAuthorize("hasPermission(#emwo_pt_id,'Remove',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Remove", tags = {"EMWO_PT" },  notes = "Remove")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emwo_pts/{emwo_pt_id}")
    @Transactional
    public ResponseEntity<Boolean> remove(@PathVariable("emwo_pt_id") String emwo_pt_id) {
         return ResponseEntity.status(HttpStatus.OK).body(emwo_ptService.remove(emwo_pt_id));
    }

    @ApiOperation(value = "RemoveBatch", tags = {"EMWO_PT" },  notes = "RemoveBatch")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emwo_pts/batch")
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        emwo_ptService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @ApiOperation(value = "GetDraft", tags = {"EMWO_PT" },  notes = "GetDraft")
	@RequestMapping(method = RequestMethod.GET, value = "/emwo_pts/getdraft")
    public ResponseEntity<EMWO_PTDTO> getDraft() {
        return ResponseEntity.status(HttpStatus.OK).body(emwo_ptMapping.toDto(emwo_ptService.getDraft(new EMWO_PT())));
    }




    @ApiOperation(value = "CheckKey", tags = {"EMWO_PT" },  notes = "CheckKey")
	@RequestMapping(method = RequestMethod.POST, value = "/emwo_pts/checkkey")
    public ResponseEntity<Boolean> checkKey(@RequestBody EMWO_PTDTO emwo_ptdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emwo_ptService.checkKey(emwo_ptMapping.toDomain(emwo_ptdto)));
    }




    @ApiOperation(value = "Save", tags = {"EMWO_PT" },  notes = "Save")
	@RequestMapping(method = RequestMethod.POST, value = "/emwo_pts/save")
    public ResponseEntity<Boolean> save(@RequestBody EMWO_PTDTO emwo_ptdto) {
        return ResponseEntity.status(HttpStatus.OK).body(emwo_ptService.save(emwo_ptMapping.toDomain(emwo_ptdto)));
    }

    @ApiOperation(value = "SaveBatch", tags = {"EMWO_PT" },  notes = "SaveBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emwo_pts/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<EMWO_PTDTO> emwo_ptdtos) {
        emwo_ptService.saveBatch(emwo_ptMapping.toDomain(emwo_ptdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @PreAuthorize("hasPermission(#emwo_pt_id,'Update',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Update", tags = {"EMWO_PT" },  notes = "Update")
	@RequestMapping(method = RequestMethod.PUT, value = "/emwo_pts/{emwo_pt_id}")
    @Transactional
    public ResponseEntity<EMWO_PTDTO> update(@PathVariable("emwo_pt_id") String emwo_pt_id, @RequestBody EMWO_PTDTO emwo_ptdto) {
		EMWO_PT domain = emwo_ptMapping.toDomain(emwo_ptdto);
        domain.setEmwoPtid(emwo_pt_id);
		emwo_ptService.update(domain);
		EMWO_PTDTO dto = emwo_ptMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(#emwo_pt_id,'Update',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "UpdateBatch", tags = {"EMWO_PT" },  notes = "UpdateBatch")
	@RequestMapping(method = RequestMethod.PUT, value = "/emwo_pts/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<EMWO_PTDTO> emwo_ptdtos) {
        emwo_ptService.updateBatch(emwo_ptMapping.toDomain(emwo_ptdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @PreAuthorize("hasPermission(#emwo_pt_id,'Get',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Get", tags = {"EMWO_PT" },  notes = "Get")
	@RequestMapping(method = RequestMethod.GET, value = "/emwo_pts/{emwo_pt_id}")
    public ResponseEntity<EMWO_PTDTO> get(@PathVariable("emwo_pt_id") String emwo_pt_id) {
        EMWO_PT domain = emwo_ptService.get(emwo_pt_id);
        EMWO_PTDTO dto = emwo_ptMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMWO_PT-Default-all')")
	@ApiOperation(value = "fetchDEFAULT", tags = {"EMWO_PT" } ,notes = "fetchDEFAULT")
    @RequestMapping(method= RequestMethod.GET , value="/emwo_pts/fetchdefault")
	public ResponseEntity<List<EMWO_PTDTO>> fetchDefault(EMWO_PTSearchContext context) {
        Page<EMWO_PT> domains = emwo_ptService.searchDefault(context) ;
        List<EMWO_PTDTO> list = emwo_ptMapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMWO_PT-Default-all')")
	@ApiOperation(value = "searchDEFAULT", tags = {"EMWO_PT" } ,notes = "searchDEFAULT")
    @RequestMapping(method= RequestMethod.POST , value="/emwo_pts/searchdefault")
	public ResponseEntity<Page<EMWO_PTDTO>> searchDefault(@RequestBody EMWO_PTSearchContext context) {
        Page<EMWO_PT> domains = emwo_ptService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emwo_ptMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}



    @ApiOperation(value = "CreateByEMEquip", tags = {"EMWO_PT" },  notes = "CreateByEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/emequips/{emequip_id}/emwo_pts")
    @Transactional
    public ResponseEntity<EMWO_PTDTO> createByEMEquip(@PathVariable("emequip_id") String emequip_id, @RequestBody EMWO_PTDTO emwo_ptdto) {
        EMWO_PT domain = emwo_ptMapping.toDomain(emwo_ptdto);
        domain.setEquipid(emequip_id);
		emwo_ptService.create(domain);
        EMWO_PTDTO dto = emwo_ptMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "createBatchByEMEquip", tags = {"EMWO_PT" },  notes = "createBatchByEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/emequips/{emequip_id}/emwo_pts/batch")
    public ResponseEntity<Boolean> createBatchByEMEquip(@PathVariable("emequip_id") String emequip_id, @RequestBody List<EMWO_PTDTO> emwo_ptdtos) {
        List<EMWO_PT> domainlist=emwo_ptMapping.toDomain(emwo_ptdtos);
        for(EMWO_PT domain:domainlist){
            domain.setEquipid(emequip_id);
        }
        emwo_ptService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "RemoveByEMEquip", tags = {"EMWO_PT" },  notes = "RemoveByEMEquip")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emequips/{emequip_id}/emwo_pts/{emwo_pt_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByEMEquip(@PathVariable("emequip_id") String emequip_id, @PathVariable("emwo_pt_id") String emwo_pt_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emwo_ptService.remove(emwo_pt_id));
    }

    @ApiOperation(value = "RemoveBatchByEMEquip", tags = {"EMWO_PT" },  notes = "RemoveBatchByEMEquip")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emequips/{emequip_id}/emwo_pts/batch")
    public ResponseEntity<Boolean> removeBatchByEMEquip(@RequestBody List<String> ids) {
        emwo_ptService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "GetDraftByEMEquip", tags = {"EMWO_PT" },  notes = "GetDraftByEMEquip")
    @RequestMapping(method = RequestMethod.GET, value = "/emequips/{emequip_id}/emwo_pts/getdraft")
    public ResponseEntity<EMWO_PTDTO> getDraftByEMEquip(@PathVariable("emequip_id") String emequip_id) {
        EMWO_PT domain = new EMWO_PT();
        domain.setEquipid(emequip_id);
        return ResponseEntity.status(HttpStatus.OK).body(emwo_ptMapping.toDto(emwo_ptService.getDraft(domain)));
    }

    @ApiOperation(value = "CheckKeyByEMEquip", tags = {"EMWO_PT" },  notes = "CheckKeyByEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/emequips/{emequip_id}/emwo_pts/checkkey")
    public ResponseEntity<Boolean> checkKeyByEMEquip(@PathVariable("emequip_id") String emequip_id, @RequestBody EMWO_PTDTO emwo_ptdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emwo_ptService.checkKey(emwo_ptMapping.toDomain(emwo_ptdto)));
    }

    @ApiOperation(value = "SaveByEMEquip", tags = {"EMWO_PT" },  notes = "SaveByEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/emequips/{emequip_id}/emwo_pts/save")
    public ResponseEntity<Boolean> saveByEMEquip(@PathVariable("emequip_id") String emequip_id, @RequestBody EMWO_PTDTO emwo_ptdto) {
        EMWO_PT domain = emwo_ptMapping.toDomain(emwo_ptdto);
        domain.setEquipid(emequip_id);
        return ResponseEntity.status(HttpStatus.OK).body(emwo_ptService.save(domain));
    }

    @ApiOperation(value = "SaveBatchByEMEquip", tags = {"EMWO_PT" },  notes = "SaveBatchByEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/emequips/{emequip_id}/emwo_pts/savebatch")
    public ResponseEntity<Boolean> saveBatchByEMEquip(@PathVariable("emequip_id") String emequip_id, @RequestBody List<EMWO_PTDTO> emwo_ptdtos) {
        List<EMWO_PT> domainlist=emwo_ptMapping.toDomain(emwo_ptdtos);
        for(EMWO_PT domain:domainlist){
             domain.setEquipid(emequip_id);
        }
        emwo_ptService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "UpdateByEMEquip", tags = {"EMWO_PT" },  notes = "UpdateByEMEquip")
	@RequestMapping(method = RequestMethod.PUT, value = "/emequips/{emequip_id}/emwo_pts/{emwo_pt_id}")
    @Transactional
    public ResponseEntity<EMWO_PTDTO> updateByEMEquip(@PathVariable("emequip_id") String emequip_id, @PathVariable("emwo_pt_id") String emwo_pt_id, @RequestBody EMWO_PTDTO emwo_ptdto) {
        EMWO_PT domain = emwo_ptMapping.toDomain(emwo_ptdto);
        domain.setEquipid(emequip_id);
        domain.setEmwoPtid(emwo_pt_id);
		emwo_ptService.update(domain);
        EMWO_PTDTO dto = emwo_ptMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "UpdateBatchByEMEquip", tags = {"EMWO_PT" },  notes = "UpdateBatchByEMEquip")
	@RequestMapping(method = RequestMethod.PUT, value = "/emequips/{emequip_id}/emwo_pts/batch")
    public ResponseEntity<Boolean> updateBatchByEMEquip(@PathVariable("emequip_id") String emequip_id, @RequestBody List<EMWO_PTDTO> emwo_ptdtos) {
        List<EMWO_PT> domainlist=emwo_ptMapping.toDomain(emwo_ptdtos);
        for(EMWO_PT domain:domainlist){
            domain.setEquipid(emequip_id);
        }
        emwo_ptService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "GetByEMEquip", tags = {"EMWO_PT" },  notes = "GetByEMEquip")
	@RequestMapping(method = RequestMethod.GET, value = "/emequips/{emequip_id}/emwo_pts/{emwo_pt_id}")
    public ResponseEntity<EMWO_PTDTO> getByEMEquip(@PathVariable("emequip_id") String emequip_id, @PathVariable("emwo_pt_id") String emwo_pt_id) {
        EMWO_PT domain = emwo_ptService.get(emwo_pt_id);
        EMWO_PTDTO dto = emwo_ptMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

	@ApiOperation(value = "fetchDEFAULTByEMEquip", tags = {"EMWO_PT" } ,notes = "fetchDEFAULTByEMEquip")
    @RequestMapping(method= RequestMethod.GET , value="/emequips/{emequip_id}/emwo_pts/fetchdefault")
	public ResponseEntity<List<EMWO_PTDTO>> fetchEMWO_PTDefaultByEMEquip(@PathVariable("emequip_id") String emequip_id,EMWO_PTSearchContext context) {
        context.setN_equipid_eq(emequip_id);
        Page<EMWO_PT> domains = emwo_ptService.searchDefault(context) ;
        List<EMWO_PTDTO> list = emwo_ptMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

	@ApiOperation(value = "searchDEFAULTByEMEquip", tags = {"EMWO_PT" } ,notes = "searchDEFAULTByEMEquip")
    @RequestMapping(method= RequestMethod.POST , value="/emequips/{emequip_id}/emwo_pts/searchdefault")
	public ResponseEntity<Page<EMWO_PTDTO>> searchEMWO_PTDefaultByEMEquip(@PathVariable("emequip_id") String emequip_id, @RequestBody EMWO_PTSearchContext context) {
        context.setN_equipid_eq(emequip_id);
        Page<EMWO_PT> domains = emwo_ptService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emwo_ptMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}




    @ApiOperation(value = "CreateByEMEQTypeEMEquip", tags = {"EMWO_PT" },  notes = "CreateByEMEQTypeEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emwo_pts")
    @Transactional
    public ResponseEntity<EMWO_PTDTO> createByEMEQTypeEMEquip(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id, @RequestBody EMWO_PTDTO emwo_ptdto) {
        EMWO_PT domain = emwo_ptMapping.toDomain(emwo_ptdto);
        domain.setEquipid(emequip_id);
		emwo_ptService.create(domain);
        EMWO_PTDTO dto = emwo_ptMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "createBatchByEMEQTypeEMEquip", tags = {"EMWO_PT" },  notes = "createBatchByEMEQTypeEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emwo_pts/batch")
    public ResponseEntity<Boolean> createBatchByEMEQTypeEMEquip(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id, @RequestBody List<EMWO_PTDTO> emwo_ptdtos) {
        List<EMWO_PT> domainlist=emwo_ptMapping.toDomain(emwo_ptdtos);
        for(EMWO_PT domain:domainlist){
            domain.setEquipid(emequip_id);
        }
        emwo_ptService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "RemoveByEMEQTypeEMEquip", tags = {"EMWO_PT" },  notes = "RemoveByEMEQTypeEMEquip")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emwo_pts/{emwo_pt_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByEMEQTypeEMEquip(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id, @PathVariable("emwo_pt_id") String emwo_pt_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emwo_ptService.remove(emwo_pt_id));
    }

    @ApiOperation(value = "RemoveBatchByEMEQTypeEMEquip", tags = {"EMWO_PT" },  notes = "RemoveBatchByEMEQTypeEMEquip")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emwo_pts/batch")
    public ResponseEntity<Boolean> removeBatchByEMEQTypeEMEquip(@RequestBody List<String> ids) {
        emwo_ptService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "GetDraftByEMEQTypeEMEquip", tags = {"EMWO_PT" },  notes = "GetDraftByEMEQTypeEMEquip")
    @RequestMapping(method = RequestMethod.GET, value = "/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emwo_pts/getdraft")
    public ResponseEntity<EMWO_PTDTO> getDraftByEMEQTypeEMEquip(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id) {
        EMWO_PT domain = new EMWO_PT();
        domain.setEquipid(emequip_id);
        return ResponseEntity.status(HttpStatus.OK).body(emwo_ptMapping.toDto(emwo_ptService.getDraft(domain)));
    }

    @ApiOperation(value = "CheckKeyByEMEQTypeEMEquip", tags = {"EMWO_PT" },  notes = "CheckKeyByEMEQTypeEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emwo_pts/checkkey")
    public ResponseEntity<Boolean> checkKeyByEMEQTypeEMEquip(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id, @RequestBody EMWO_PTDTO emwo_ptdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emwo_ptService.checkKey(emwo_ptMapping.toDomain(emwo_ptdto)));
    }

    @ApiOperation(value = "SaveByEMEQTypeEMEquip", tags = {"EMWO_PT" },  notes = "SaveByEMEQTypeEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emwo_pts/save")
    public ResponseEntity<Boolean> saveByEMEQTypeEMEquip(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id, @RequestBody EMWO_PTDTO emwo_ptdto) {
        EMWO_PT domain = emwo_ptMapping.toDomain(emwo_ptdto);
        domain.setEquipid(emequip_id);
        return ResponseEntity.status(HttpStatus.OK).body(emwo_ptService.save(domain));
    }

    @ApiOperation(value = "SaveBatchByEMEQTypeEMEquip", tags = {"EMWO_PT" },  notes = "SaveBatchByEMEQTypeEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emwo_pts/savebatch")
    public ResponseEntity<Boolean> saveBatchByEMEQTypeEMEquip(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id, @RequestBody List<EMWO_PTDTO> emwo_ptdtos) {
        List<EMWO_PT> domainlist=emwo_ptMapping.toDomain(emwo_ptdtos);
        for(EMWO_PT domain:domainlist){
             domain.setEquipid(emequip_id);
        }
        emwo_ptService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "UpdateByEMEQTypeEMEquip", tags = {"EMWO_PT" },  notes = "UpdateByEMEQTypeEMEquip")
	@RequestMapping(method = RequestMethod.PUT, value = "/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emwo_pts/{emwo_pt_id}")
    @Transactional
    public ResponseEntity<EMWO_PTDTO> updateByEMEQTypeEMEquip(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id, @PathVariable("emwo_pt_id") String emwo_pt_id, @RequestBody EMWO_PTDTO emwo_ptdto) {
        EMWO_PT domain = emwo_ptMapping.toDomain(emwo_ptdto);
        domain.setEquipid(emequip_id);
        domain.setEmwoPtid(emwo_pt_id);
		emwo_ptService.update(domain);
        EMWO_PTDTO dto = emwo_ptMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "UpdateBatchByEMEQTypeEMEquip", tags = {"EMWO_PT" },  notes = "UpdateBatchByEMEQTypeEMEquip")
	@RequestMapping(method = RequestMethod.PUT, value = "/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emwo_pts/batch")
    public ResponseEntity<Boolean> updateBatchByEMEQTypeEMEquip(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id, @RequestBody List<EMWO_PTDTO> emwo_ptdtos) {
        List<EMWO_PT> domainlist=emwo_ptMapping.toDomain(emwo_ptdtos);
        for(EMWO_PT domain:domainlist){
            domain.setEquipid(emequip_id);
        }
        emwo_ptService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "GetByEMEQTypeEMEquip", tags = {"EMWO_PT" },  notes = "GetByEMEQTypeEMEquip")
	@RequestMapping(method = RequestMethod.GET, value = "/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emwo_pts/{emwo_pt_id}")
    public ResponseEntity<EMWO_PTDTO> getByEMEQTypeEMEquip(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id, @PathVariable("emwo_pt_id") String emwo_pt_id) {
        EMWO_PT domain = emwo_ptService.get(emwo_pt_id);
        EMWO_PTDTO dto = emwo_ptMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

	@ApiOperation(value = "fetchDEFAULTByEMEQTypeEMEquip", tags = {"EMWO_PT" } ,notes = "fetchDEFAULTByEMEQTypeEMEquip")
    @RequestMapping(method= RequestMethod.GET , value="/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emwo_pts/fetchdefault")
	public ResponseEntity<List<EMWO_PTDTO>> fetchEMWO_PTDefaultByEMEQTypeEMEquip(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id,EMWO_PTSearchContext context) {
        context.setN_equipid_eq(emequip_id);
        Page<EMWO_PT> domains = emwo_ptService.searchDefault(context) ;
        List<EMWO_PTDTO> list = emwo_ptMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

	@ApiOperation(value = "searchDEFAULTByEMEQTypeEMEquip", tags = {"EMWO_PT" } ,notes = "searchDEFAULTByEMEQTypeEMEquip")
    @RequestMapping(method= RequestMethod.POST , value="/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emwo_pts/searchdefault")
	public ResponseEntity<Page<EMWO_PTDTO>> searchEMWO_PTDefaultByEMEQTypeEMEquip(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id, @RequestBody EMWO_PTSearchContext context) {
        context.setN_equipid_eq(emequip_id);
        Page<EMWO_PT> domains = emwo_ptService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emwo_ptMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}




    @ApiOperation(value = "CreateByPFTeamEMEquip", tags = {"EMWO_PT" },  notes = "CreateByPFTeamEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/pfteams/{pfteam_id}/emequips/{emequip_id}/emwo_pts")
    @Transactional
    public ResponseEntity<EMWO_PTDTO> createByPFTeamEMEquip(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id, @RequestBody EMWO_PTDTO emwo_ptdto) {
        EMWO_PT domain = emwo_ptMapping.toDomain(emwo_ptdto);
        domain.setEquipid(emequip_id);
		emwo_ptService.create(domain);
        EMWO_PTDTO dto = emwo_ptMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "createBatchByPFTeamEMEquip", tags = {"EMWO_PT" },  notes = "createBatchByPFTeamEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/pfteams/{pfteam_id}/emequips/{emequip_id}/emwo_pts/batch")
    public ResponseEntity<Boolean> createBatchByPFTeamEMEquip(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id, @RequestBody List<EMWO_PTDTO> emwo_ptdtos) {
        List<EMWO_PT> domainlist=emwo_ptMapping.toDomain(emwo_ptdtos);
        for(EMWO_PT domain:domainlist){
            domain.setEquipid(emequip_id);
        }
        emwo_ptService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "RemoveByPFTeamEMEquip", tags = {"EMWO_PT" },  notes = "RemoveByPFTeamEMEquip")
	@RequestMapping(method = RequestMethod.DELETE, value = "/pfteams/{pfteam_id}/emequips/{emequip_id}/emwo_pts/{emwo_pt_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByPFTeamEMEquip(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id, @PathVariable("emwo_pt_id") String emwo_pt_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emwo_ptService.remove(emwo_pt_id));
    }

    @ApiOperation(value = "RemoveBatchByPFTeamEMEquip", tags = {"EMWO_PT" },  notes = "RemoveBatchByPFTeamEMEquip")
	@RequestMapping(method = RequestMethod.DELETE, value = "/pfteams/{pfteam_id}/emequips/{emequip_id}/emwo_pts/batch")
    public ResponseEntity<Boolean> removeBatchByPFTeamEMEquip(@RequestBody List<String> ids) {
        emwo_ptService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "GetDraftByPFTeamEMEquip", tags = {"EMWO_PT" },  notes = "GetDraftByPFTeamEMEquip")
    @RequestMapping(method = RequestMethod.GET, value = "/pfteams/{pfteam_id}/emequips/{emequip_id}/emwo_pts/getdraft")
    public ResponseEntity<EMWO_PTDTO> getDraftByPFTeamEMEquip(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id) {
        EMWO_PT domain = new EMWO_PT();
        domain.setEquipid(emequip_id);
        return ResponseEntity.status(HttpStatus.OK).body(emwo_ptMapping.toDto(emwo_ptService.getDraft(domain)));
    }

    @ApiOperation(value = "CheckKeyByPFTeamEMEquip", tags = {"EMWO_PT" },  notes = "CheckKeyByPFTeamEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/pfteams/{pfteam_id}/emequips/{emequip_id}/emwo_pts/checkkey")
    public ResponseEntity<Boolean> checkKeyByPFTeamEMEquip(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id, @RequestBody EMWO_PTDTO emwo_ptdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emwo_ptService.checkKey(emwo_ptMapping.toDomain(emwo_ptdto)));
    }

    @ApiOperation(value = "SaveByPFTeamEMEquip", tags = {"EMWO_PT" },  notes = "SaveByPFTeamEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/pfteams/{pfteam_id}/emequips/{emequip_id}/emwo_pts/save")
    public ResponseEntity<Boolean> saveByPFTeamEMEquip(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id, @RequestBody EMWO_PTDTO emwo_ptdto) {
        EMWO_PT domain = emwo_ptMapping.toDomain(emwo_ptdto);
        domain.setEquipid(emequip_id);
        return ResponseEntity.status(HttpStatus.OK).body(emwo_ptService.save(domain));
    }

    @ApiOperation(value = "SaveBatchByPFTeamEMEquip", tags = {"EMWO_PT" },  notes = "SaveBatchByPFTeamEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/pfteams/{pfteam_id}/emequips/{emequip_id}/emwo_pts/savebatch")
    public ResponseEntity<Boolean> saveBatchByPFTeamEMEquip(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id, @RequestBody List<EMWO_PTDTO> emwo_ptdtos) {
        List<EMWO_PT> domainlist=emwo_ptMapping.toDomain(emwo_ptdtos);
        for(EMWO_PT domain:domainlist){
             domain.setEquipid(emequip_id);
        }
        emwo_ptService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "UpdateByPFTeamEMEquip", tags = {"EMWO_PT" },  notes = "UpdateByPFTeamEMEquip")
	@RequestMapping(method = RequestMethod.PUT, value = "/pfteams/{pfteam_id}/emequips/{emequip_id}/emwo_pts/{emwo_pt_id}")
    @Transactional
    public ResponseEntity<EMWO_PTDTO> updateByPFTeamEMEquip(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id, @PathVariable("emwo_pt_id") String emwo_pt_id, @RequestBody EMWO_PTDTO emwo_ptdto) {
        EMWO_PT domain = emwo_ptMapping.toDomain(emwo_ptdto);
        domain.setEquipid(emequip_id);
        domain.setEmwoPtid(emwo_pt_id);
		emwo_ptService.update(domain);
        EMWO_PTDTO dto = emwo_ptMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "UpdateBatchByPFTeamEMEquip", tags = {"EMWO_PT" },  notes = "UpdateBatchByPFTeamEMEquip")
	@RequestMapping(method = RequestMethod.PUT, value = "/pfteams/{pfteam_id}/emequips/{emequip_id}/emwo_pts/batch")
    public ResponseEntity<Boolean> updateBatchByPFTeamEMEquip(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id, @RequestBody List<EMWO_PTDTO> emwo_ptdtos) {
        List<EMWO_PT> domainlist=emwo_ptMapping.toDomain(emwo_ptdtos);
        for(EMWO_PT domain:domainlist){
            domain.setEquipid(emequip_id);
        }
        emwo_ptService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "GetByPFTeamEMEquip", tags = {"EMWO_PT" },  notes = "GetByPFTeamEMEquip")
	@RequestMapping(method = RequestMethod.GET, value = "/pfteams/{pfteam_id}/emequips/{emequip_id}/emwo_pts/{emwo_pt_id}")
    public ResponseEntity<EMWO_PTDTO> getByPFTeamEMEquip(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id, @PathVariable("emwo_pt_id") String emwo_pt_id) {
        EMWO_PT domain = emwo_ptService.get(emwo_pt_id);
        EMWO_PTDTO dto = emwo_ptMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

	@ApiOperation(value = "fetchDEFAULTByPFTeamEMEquip", tags = {"EMWO_PT" } ,notes = "fetchDEFAULTByPFTeamEMEquip")
    @RequestMapping(method= RequestMethod.GET , value="/pfteams/{pfteam_id}/emequips/{emequip_id}/emwo_pts/fetchdefault")
	public ResponseEntity<List<EMWO_PTDTO>> fetchEMWO_PTDefaultByPFTeamEMEquip(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id,EMWO_PTSearchContext context) {
        context.setN_equipid_eq(emequip_id);
        Page<EMWO_PT> domains = emwo_ptService.searchDefault(context) ;
        List<EMWO_PTDTO> list = emwo_ptMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

	@ApiOperation(value = "searchDEFAULTByPFTeamEMEquip", tags = {"EMWO_PT" } ,notes = "searchDEFAULTByPFTeamEMEquip")
    @RequestMapping(method= RequestMethod.POST , value="/pfteams/{pfteam_id}/emequips/{emequip_id}/emwo_pts/searchdefault")
	public ResponseEntity<Page<EMWO_PTDTO>> searchEMWO_PTDefaultByPFTeamEMEquip(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id, @RequestBody EMWO_PTSearchContext context) {
        context.setN_equipid_eq(emequip_id);
        Page<EMWO_PT> domains = emwo_ptService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emwo_ptMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}


    /**
     * 用户权限校验
     * @return
     */
	public EMWO_PT getEntity(){
        return new EMWO_PT();
    }

}
